!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     diagonalization of symmetric matrix
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine zdiag ( a, e, vr, n )
!***********************************************************************

#ifdef nolapack

#endif

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      integer          :: n, info, lwork

      character(len=1) :: jobvl, jobvr

      real(8)          :: rwork(2*n)

      complex(8)       :: a(n,n), vl(n,n), vr(n,n), e(n)

      complex(8), dimension(:), allocatable  :: work

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      jobvl = 'V'
      jobvr = 'V'

#ifdef nolapack

      write( 6, '(a)' ) 'Error - Diagonalization routine not linked.'

      call error_handling ( 1, 'subroutine zdiag', 16 )

#else

      lwork = 4*n

      if ( .not. allocated( work ) ) &
     &   allocate( work(lwork) )

      call zgeev( jobvl, jobvr, n, a, n, e, vl, n, vr, n, &
     &            work, -1, rwork, info )

      lwork = int( work(1) )

      if ( lwork .gt. 4*n ) then

         if ( allocated( work ) ) &
     &      deallocate( work )

         if ( .not. allocated( work ) ) &
     &      allocate( work(lwork) )

      end if

      call zgeev( jobvl, jobvr, n, a, n, e, vl, n, vr, n, &
     &            work, lwork, rwork, info )

      if ( allocated( work ) ) &
     &   deallocate( work )

#endif

      return
      end





#ifdef nolapack

#else

!***********************************************************************
      subroutine ddiag ( a, w, v, n )
!***********************************************************************

      implicit none

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      integer          :: i, j, n, info

      character(len=1) :: jobz, uplo

      real(8)          :: a(n,n), b(n,n), w(n), work(4*n), v(n,n)

!-----------------------------------------------------------------------
!     /*   start                                                      */
!-----------------------------------------------------------------------

      jobz = 'V'
      uplo = 'U'

      do j = 1, n
      do i = 1, n
         b(i,j) = a(i,j)
      end do
      end do

      call dsyev( jobz, uplo, n, a, n, w, work, 4*n, info )

      do j = 1, n
      do i = 1, n
         v(i,j) = a(i,j)
         a(i,j) = b(i,j)
      end do
      end do

      return
      end

#endif

