!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Jan 23, 2025 by M. Shiga
!      Description:     extensive MPI parallelization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine correct_virial_XMPI
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vir, fx, fy, fz, ux, uy, uz, x, y, z, method

      use XMPI_variables, only : &
     &   jstart_atom, jend_atom, jstart_bead, jend_bead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: p(3,3)

!-----------------------------------------------------------------------
!     /*   return by option                                           */
!-----------------------------------------------------------------------

      if      ( method(1:7)  .eq. 'STATIC ' ) then
         continue
      else if ( method(1:10) .eq. 'TESTFORCE ' ) then
         continue
      else if ( method(1:11) .eq. 'TESTVIRIAL ' ) then
         continue
      else if ( method(1:5)  .eq. 'PIMD ' ) then
         continue
      else if ( method(1:6)  .eq. 'PIHMC ' ) then
         continue
      else if ( method(1:4)  .eq. 'CMD ' ) then
         continue
      else if ( method(1:5)  .eq. 'RPMD ' ) then
         continue
      else
         return
      end if

!-----------------------------------------------------------------------
!     /*   apply virial correction                                    */
!-----------------------------------------------------------------------

      p(:,:) = 0

      do j = jstart_bead, jend_bead
      do i = jstart_atom, jend_atom

         p(1,1) = p(1,1) + fx(i,j) * ( ux(i,1) - x(i,j) )
         p(1,2) = p(1,2) + fx(i,j) * ( uy(i,1) - y(i,j) )
         p(1,3) = p(1,3) + fx(i,j) * ( uz(i,1) - z(i,j) )
         p(2,1) = p(2,1) + fy(i,j) * ( ux(i,1) - x(i,j) )
         p(2,2) = p(2,2) + fy(i,j) * ( uy(i,1) - y(i,j) )
         p(2,3) = p(2,3) + fy(i,j) * ( uz(i,1) - z(i,j) )
         p(3,1) = p(3,1) + fz(i,j) * ( ux(i,1) - x(i,j) )
         p(3,2) = p(3,2) + fz(i,j) * ( uy(i,1) - y(i,j) )
         p(3,3) = p(3,3) + fz(i,j) * ( uz(i,1) - z(i,j) )

      end do
      end do

      call my_mpi_allreduce_real_2( p, 3, 3 )
!      call my_mpi_allreduce_real_2_sub( p, 3, 3 )
!      call my_mpi_allreduce_real_2_main( p, 3, 3 )

      do j = 1, 3
      do i = 1, 3
         vir(i,j) = vir(i,j) + p(i,j)
      end do
      end do

      return
      end
