!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     correction to virial
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine correct_virial
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   vir, fx, fy, fz, ux, uy, uz, x, y, z, method, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

!-----------------------------------------------------------------------
!     /*   return by option                                           */
!-----------------------------------------------------------------------

      if      ( method(1:7)  .eq. 'STATIC ' ) then
         continue
      else if ( method(1:10) .eq. 'TESTFORCE ' ) then
         continue
      else if ( method(1:11) .eq. 'TESTVIRIAL ' ) then
         continue
      else if ( method(1:5)  .eq. 'PIMD ' ) then
         continue
      else if ( method(1:6)  .eq. 'PIHMC ' ) then
         continue
      else if ( method(1:4)  .eq. 'CMD ' ) then
         continue
      else if ( method(1:5)  .eq. 'RPMD ' ) then
         continue
      else
         return
      end if

!-----------------------------------------------------------------------
!     /*   apply virial correction                                    */
!-----------------------------------------------------------------------

      do j = 1, nbead
      do i = 1, natom
         vir(1,1) = vir(1,1) + fx(i,j) * ( ux(i,1) - x(i,j) )
         vir(1,2) = vir(1,2) + fx(i,j) * ( uy(i,1) - y(i,j) )
         vir(1,3) = vir(1,3) + fx(i,j) * ( uz(i,1) - z(i,j) )
         vir(2,1) = vir(2,1) + fy(i,j) * ( ux(i,1) - x(i,j) )
         vir(2,2) = vir(2,2) + fy(i,j) * ( uy(i,1) - y(i,j) )
         vir(2,3) = vir(2,3) + fy(i,j) * ( uz(i,1) - z(i,j) )
         vir(3,1) = vir(3,1) + fz(i,j) * ( ux(i,1) - x(i,j) )
         vir(3,2) = vir(3,2) + fz(i,j) * ( uy(i,1) - y(i,j) )
         vir(3,3) = vir(3,3) + fz(i,j) * ( uz(i,1) - z(i,j) )
      end do
      end do

      return
      end
