!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     check the phase of wavefunction
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine checkphase
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   nbead, natom

      use multistate_variables, only : &
     &   dxstate, dystate, dzstate, &
     &   dxstate_old, dystate_old, dzstate_old, nstate

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l, ierr

      real(8) :: sum_1, sum_2, sum_3, sum_4, factor

      integer, dimension(nstate) :: iphase

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   initial step                                               */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

!        /*   save old nonadiabatic coupling vector   */

         dxstate_old(:,:,:,:) = dxstate(:,:,:,:)
         dystate_old(:,:,:,:) = dystate(:,:,:,:)
         dzstate_old(:,:,:,:) = dzstate(:,:,:,:)

         iset = 1

         return

      end if

!-----------------------------------------------------------------------
!     /*    calculate phase change                                    */
!-----------------------------------------------------------------------

      do l = 1, nbead

         iphase(1) = + 1

         do j = 2, nstate

            sum_1 = 0.d0
            sum_2 = 0.d0
            sum_3 = 0.d0

            do k = 1, natom

               sum_1 = sum_1 &
     &               + dxstate(1,j,k,l)*dxstate(1,j,k,l) &
     &               + dystate(1,j,k,l)*dystate(1,j,k,l) &
     &               + dzstate(1,j,k,l)*dzstate(1,j,k,l)

               sum_2 = sum_2 &
     &               + dxstate_old(1,j,k,l)*dxstate_old(1,j,k,l) &
     &               + dystate_old(1,j,k,l)*dystate_old(1,j,k,l) &
     &               + dzstate_old(1,j,k,l)*dzstate_old(1,j,k,l)

               sum_3 = sum_3 &
     &               + dxstate(1,j,k,l)*dxstate_old(1,j,k,l) &
     &               + dystate(1,j,k,l)*dystate_old(1,j,k,l) &
     &               + dzstate(1,j,k,l)*dzstate_old(1,j,k,l)

            end do

            sum_4 = sqrt(sum_1*sum_2)

            if ( sum_4 .eq. 0.d0 ) then
               iphase(j) = + 1
               cycle
            end if

            factor = cos(sum_3/sum_4)

            if ( factor .ge. 0.d0 ) then
               iphase(j) = + 1
            else
               iphase(j) = - 1
            end if

         end do

!-----------------------------------------------------------------------
!        /*   correct phase change                                    */
!-----------------------------------------------------------------------

         do j = 1, nstate
         do i = 1, nstate
         do k = 1, natom
            dxstate(i,j,k,l) = dxstate(i,j,k,l)*iphase(i)*iphase(j)
            dystate(i,j,k,l) = dystate(i,j,k,l)*iphase(i)*iphase(j)
            dzstate(i,j,k,l) = dzstate(i,j,k,l)*iphase(i)*iphase(j)
         end do
         end do
         end do

!-----------------------------------------------------------------------
!        /*   check                                                   */
!-----------------------------------------------------------------------

         do i = 1, nstate-1
         do j = i+1, nstate

            sum_1 = 0.d0
            sum_2 = 0.d0
            sum_3 = 0.d0

            do k = 1, natom

               sum_1 = sum_1 &
     &               + dxstate(i,j,k,l)*dxstate(i,j,k,l) &
     &               + dystate(i,j,k,l)*dystate(i,j,k,l) &
     &               + dzstate(i,j,k,l)*dzstate(i,j,k,l)

               sum_2 = sum_2 &
     &               + dxstate_old(i,j,k,l)*dxstate_old(i,j,k,l) &
     &               + dystate_old(i,j,k,l)*dystate_old(i,j,k,l) &
     &               + dzstate_old(i,j,k,l)*dzstate_old(i,j,k,l)

               sum_3 = sum_3 &
     &               + dxstate(i,j,k,l)*dxstate_old(i,j,k,l) &
     &               + dystate(i,j,k,l)*dystate_old(i,j,k,l) &
     &               + dzstate(i,j,k,l)*dzstate_old(i,j,k,l)

            end do

            sum_4 = sqrt(sum_1*sum_2)

            if ( sum_4 .eq. 0.d0 ) cycle

            factor = cos(sum_3/sum_4)

            if ( factor .ge. 0.d0 ) ierr = 0
            if ( factor .lt. 0.d0 ) ierr = 1

            call error_handling ( ierr, 'subroutine checkphase', 21 )

         end do
         end do

      end do

!-----------------------------------------------------------------------
!     /*   save old nonadiabatic coupling vector                      */
!-----------------------------------------------------------------------

      dxstate_old(:,:,:,:) = dxstate(:,:,:,:)
      dystate_old(:,:,:,:) = dystate(:,:,:,:)
      dzstate_old(:,:,:,:) = dzstate(:,:,:,:)

      return
      end
