!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     main cycle for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calccycle
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iconf, nconf, &
     &   iconf_ini_calc, iprint_calc, iconf_calc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Analysis: start.'

      write( 6, '(a)' )

!-----------------------------------------------------------------------
!     /*   main loop start                                            */
!-----------------------------------------------------------------------

      do iconf = 1, nconf

!-----------------------------------------------------------------------
!        /*   read geometry                                           */
!-----------------------------------------------------------------------

         call calc_read

!-----------------------------------------------------------------------
!        /*   monitor confs                                           */
!-----------------------------------------------------------------------

         call calc_monitor

!-----------------------------------------------------------------------
!        /*   skip initial confs                                      */
!-----------------------------------------------------------------------

         if ( iconf .lt. iconf_ini_calc )  cycle

!-----------------------------------------------------------------------
!        /*   impose boundary condition                               */
!-----------------------------------------------------------------------

         call calc_pbc

!-----------------------------------------------------------------------
!        /*   xyz file                                                */
!-----------------------------------------------------------------------

         call calc_xyz

!-----------------------------------------------------------------------
!        /*   print interval                                          */
!-----------------------------------------------------------------------

         if ( ( iprint_calc .le. 0 ) .or. &
     &        ( mod(iconf,iprint_calc) .ne. 0 ) ) cycle

!-----------------------------------------------------------------------
!        /*   update conf number                                      */
!-----------------------------------------------------------------------

         iconf_calc = iconf_calc + 1

!-----------------------------------------------------------------------
!        /*   distance                                                */
!-----------------------------------------------------------------------

         call calc_lin

!-----------------------------------------------------------------------
!        /*   angle                                                   */
!-----------------------------------------------------------------------

         call calc_angl

!-----------------------------------------------------------------------
!        /*   dihedral                                                */
!-----------------------------------------------------------------------

         call calc_dih

!-----------------------------------------------------------------------
!        /*   distance                                                */
!-----------------------------------------------------------------------

         call calc_lin_avg

!-----------------------------------------------------------------------
!        /*   angle                                                   */
!-----------------------------------------------------------------------

         call calc_angl_avg

!-----------------------------------------------------------------------
!        /*   dihedral                                                */
!-----------------------------------------------------------------------

         call calc_dih_avg

!-----------------------------------------------------------------------
!        /*   difference                                              */
!-----------------------------------------------------------------------

         call calc_diff

!-----------------------------------------------------------------------
!        /*   absolute difference                                     */
!-----------------------------------------------------------------------

         call calc_adiff

!-----------------------------------------------------------------------
!        /*   distance from plane                                     */
!-----------------------------------------------------------------------

         call calc_opd

!-----------------------------------------------------------------------
!        /*   out of plane angle                                      */
!-----------------------------------------------------------------------

         call calc_opa

!-----------------------------------------------------------------------
!        /*   area of triangle                                        */
!-----------------------------------------------------------------------

         call calc_tri

!-----------------------------------------------------------------------
!        /*   distance (species)                                      */
!-----------------------------------------------------------------------

         call calc_lin_spec

!-----------------------------------------------------------------------
!        /*   angle (species)                                         */
!-----------------------------------------------------------------------

         call calc_angl_spec

!-----------------------------------------------------------------------
!        /*   dihedral (species)                                      */
!-----------------------------------------------------------------------

         call calc_dih_spec

!-----------------------------------------------------------------------
!        /*   distance distribution                                   */
!-----------------------------------------------------------------------

         call calc_lin_atom_dens

!-----------------------------------------------------------------------
!        /*   angular distribution                                    */
!-----------------------------------------------------------------------

         call calc_angl_atom_dens

!-----------------------------------------------------------------------
!        /*   dihedral distribution                                   */
!-----------------------------------------------------------------------

         call calc_dih_atom_dens

!-----------------------------------------------------------------------
!        /*   distance distribution (species)                         */
!-----------------------------------------------------------------------

         call calc_lin_spec_dens

!-----------------------------------------------------------------------
!        /*   angular distribution (species)                          */
!-----------------------------------------------------------------------

         call calc_angl_spec_dens

!-----------------------------------------------------------------------
!        /*   dihedral distribution (species)                         */
!-----------------------------------------------------------------------

         call calc_dih_spec_dens

!-----------------------------------------------------------------------
!        /*   difference                                              */
!-----------------------------------------------------------------------

         call calc_diff_atom_dens

!-----------------------------------------------------------------------
!        /*   absolute difference                                     */
!-----------------------------------------------------------------------

         call calc_adiff_atom_dens

!-----------------------------------------------------------------------
!        /*   two-dimensional distance-angle distribution (species)   */
!-----------------------------------------------------------------------

         call calc_xla_spec_dens

!-----------------------------------------------------------------------
!        /*   3d cube                                                 */
!-----------------------------------------------------------------------

         call calc_cube

!-----------------------------------------------------------------------
!     /*   main loop end                                              */
!-----------------------------------------------------------------------

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a)' )

      write( 6, '(a)' ) 'Analysis: ended.'

      write( 6, '(a)' )

      return
      end
