!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_xyz_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   xo, yo, zo, jformat_xyz, jxyz_atom, jorigin_xyz, jxyz_bead, &
     &   iounit, jprint_xyz, jspec_xyz, ikind, natom_xyz, nkind, natom

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, l

!     /*   integer   */
      integer :: ierr = 0

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a,2i4,a)' ) 'XYZ setups:'

!-----------------------------------------------------------------------
!
!     /*   print interval of xyz file                                 */
!
!          jprint_xyz >  0:  print interval.
!          jprint_xyz = -1:  do not print.
!
!-----------------------------------------------------------------------

      call read_int1_calc ( jprint_xyz, '<jprint_xyz>', 12, iounit )

!-----------------------------------------------------------------------
!
!     /*   print format of xyz file:                                  */
!
!          jformat_xyz = 1:  print each bead separately.
!          jformat_xyz = 2:  print all beads at the same time.
!          jformat_xyz = 3:  print only the centroids.
!          jformat_xyz = 4:  print only the selected bead.
!
!-----------------------------------------------------------------------

      call read_int1_calc ( jformat_xyz, '<jformat_xyz>', 13, iounit )

!-----------------------------------------------------------------------
!
!     /*   origin of xyz:                                             */
!
!          jorigin_xyz = 1:  origin is fixed to zero.
!          jorigin_xyz = 2:  origin is fixed in space.
!          jorigin_xyz = 3:  origin is fixed to an atom.
!
!-----------------------------------------------------------------------

      call read_int1_calc ( jorigin_xyz, '<jorigin_xyz>', 13, iounit )

!-----------------------------------------------------------------------
!     /*   read bead number                                           */
!-----------------------------------------------------------------------

      if ( jformat_xyz .eq. 4 ) then

         call read_int1_calc ( jxyz_bead, '<jxyz_bead>', 11, iounit )

      end if

!-----------------------------------------------------------------------
!     /*   read origin                                                */
!-----------------------------------------------------------------------

      if ( jorigin_xyz .eq. 2 ) then

         open ( iounit, file = 'calc.dat' )

!           /*   tag   */
            call search_tag ( '<jxyz_origin>', 13, iounit, ierr )

!           /*   read   */
            read ( iounit, *, iostat=ierr ) xo, yo, zo

         close( iounit )

         if ( ierr .ne. 0 ) then

            open ( iounit, file = 'calc_default.dat' )

!              /*   tag   */
               call search_tag ( '<jxyz_origin>', 13, iounit, ierr )

!              /*   read   */
               read ( iounit, *, iostat=ierr ) xo, yo, zo

            close( iounit )

!           /*   check error   */
            if ( ierr .ne. 0 ) then
               write( 6, '(a)' ) &
     &            'Error - check format of <jxyz_origin>.'
               write( 6, '(a)' ) 
            end if

!           /*   error termination   */
            call error_handling_calc &
     &         ( ierr, 'subroutine calc_xyz_setup', 25 )

         end if

      else if ( jorigin_xyz .eq. 3 ) then

         open ( iounit, file = 'calc.dat' )

!           /*   tag   */
            call search_tag ( '<jxyz_atom>', 11, iounit, ierr )

!           /*   read   */
            read ( iounit, *, iostat=ierr ) jxyz_atom

         close( iounit )

         if ( ierr .ne. 0 ) then

            open ( iounit, file = 'calc_default.dat' )

!              /*   tag   */
               call search_tag ( '<jxyz_atom>', 11, iounit, ierr )

!              /*   read   */
               read ( iounit, *, iostat=ierr ) jxyz_atom

            close( iounit )

!           /*   check error   */
            if ( ierr .ne. 0 ) then
               write( 6, '(a)' ) &
     &            'Error - check format of <jxyz_atom>.'
               write( 6, '(a)' ) 
            end if

!           /*   error termination   */
            call error_handling_calc &
     &         ( ierr, 'subroutine calc_xyz_setup', 25 )

         end if

      else

         jxyz_atom = 1

         xo = 0.d0
         yo = 0.d0
         zo = 0.d0

      end if

!-----------------------------------------------------------------------
!     /*   species to print                                           */
!-----------------------------------------------------------------------

      call read_intn_calc( jspec_xyz, 2, '<jspec_xyz>', 11, iounit )

      if ( jspec_xyz(2) .le. 0 ) jspec_xyz(2) = nkind

      l = 0

      do i = 1, natom
         if ( ikind(i) .lt. jspec_xyz(1) ) cycle
         if ( ikind(i) .gt. jspec_xyz(2) ) cycle
         l = l + 1
      end do

      natom_xyz = l

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( jprint_xyz .gt. 0 ) then

         write( 6, '(a,i4,a)' ) &
     &     'calc.xyz is printed every ', jprint_xyz, &
     &     ' configurations.'

         if      ( jformat_xyz .eq. 1 ) then
            write( 6, '(a)' ) &
     &        'Each bead is printed separately.'
         else if ( jformat_xyz .eq. 2 ) then
            write( 6, '(a)' ) &
     &        'All beads are printed at the same time.'
         else if ( jformat_xyz .eq. 3 ) then
            write( 6, '(a)' ) &
     &        'Centroid coordinates are printed.'
         else if ( jformat_xyz .eq. 4 ) then
            write( 6, '(a,i4,a)' ) &
     &        'Selected bead is printed: ', jxyz_bead, '.'
         else
            write( 6, '(a)' ) &
     &        'Error - <jformat_xyz> must be 1, 2, 3 or 4.'
            ierr = 1
         end if

         if      ( jorigin_xyz .eq. 1 ) then
            write( 6, '(a)' ) &
     &        'Origin is fixed to zero.'
         else if ( jorigin_xyz .eq. 2 ) then
            write( 6, '(a,3f12.5)' ) &
     &        'Origin is fixed in space:', xo, yo, zo
         else if ( jorigin_xyz .eq. 3 ) then
            write( 6, '(a,i6)' ) &
     &        'Origin is fixed to atom', jxyz_atom, '.'
         else
            write( 6, '(a)' ) &
     &        'Error - <jorigin_xyz> must be 1, 2 or 3.'
            ierr = 1
         end if

      else

         write( 6, '(a,i4,a)' ) 'calc.xyz is not printed.'

      end if

      write( 6, '(a)' )

!-----------------------------------------------------------------------
!        /*   error termination                                       */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_xyz_setup', 25 )

      return
      end
