!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_xyz
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, x, y, z, ux, uy, uz, spec, natom_xyz, &
     &   nbead, natom, ikind, iounit_xyz, iconf, iounit, &
     &   jprint_xyz, jspec_xyz, jformat_xyz, jxyz_bead, mbox

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m1, m2, m3

!     /*   real   */
      real(8) :: xa, ya, za, xb, yb, zb

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!     /*   integer   */
      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   only with print interval                                   */
!-----------------------------------------------------------------------

      if ( jprint_xyz .le. 0 ) return
      if ( mod(iconf,jprint_xyz) .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   file open                                                  */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         open ( iounit_xyz,  file = 'calc.xyz',  status = 'unknown' )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   write geometry:  each bead separately                      */
!-----------------------------------------------------------------------

      if      ( jformat_xyz .eq. 1 ) then

         do j = 1, nbead
            write( iounit_xyz, '(i8)' ) natom_xyz
            write( iounit_xyz, '(i8)' ) iconf
            do i = 1, natom
               k = ikind(i)
               if ( k .lt. jspec_xyz(1) ) cycle
               if ( k .gt. jspec_xyz(2) ) cycle
               xa = x(i,j) * bohr2ang
               ya = y(i,j) * bohr2ang
               za = z(i,j) * bohr2ang
               xb = x(i,j)
               yb = y(i,j)
               zb = z(i,j)
               m1 = mbox(1,i,j)
               m2 = mbox(2,i,j)
               m3 = mbox(3,i,j)
               call calc_pbc_unfold( xb, yb, zb, m1, m2, m3 )
               xb = xb * bohr2ang
               yb = yb * bohr2ang
               zb = zb * bohr2ang
               write( iounit_xyz, '(a4,6f16.8)' ) &
     &            spec(k)(1:4), xa, ya, za, xb, yb, zb
            end do
         end do

!-----------------------------------------------------------------------
!     /*   write geometry:  all beads                                 */
!-----------------------------------------------------------------------

      else if ( jformat_xyz .eq. 2 ) then

         write( iounit_xyz, '(i8)' ) natom_xyz*nbead
         write( iounit_xyz, '(i8)' ) iconf

         do j = 1, nbead
            do i = 1, natom
               k = ikind(i)
               if ( k .lt. jspec_xyz(1) ) cycle
               if ( k .gt. jspec_xyz(2) ) cycle
               xa = x(i,j) * bohr2ang
               ya = y(i,j) * bohr2ang
               za = z(i,j) * bohr2ang
               xb = x(i,j)
               yb = y(i,j)
               zb = z(i,j)
               m1 = mbox(1,i,j)
               m2 = mbox(2,i,j)
               m3 = mbox(3,i,j)
               call calc_pbc_unfold( xb, yb, zb, m1, m2, m3 )
               xb = xb * bohr2ang
               yb = yb * bohr2ang
               zb = zb * bohr2ang
               write( iounit_xyz, '(a4,6f16.8)' ) &
     &            spec(k)(1:4), xa, ya, za, xb, yb, zb
            end do
         end do

!-----------------------------------------------------------------------
!     /*   write geometry:  only the centroid                         */
!-----------------------------------------------------------------------

      else if ( jformat_xyz .eq. 3 ) then

         write( iounit_xyz, '(i8)' ) natom_xyz
         write( iounit_xyz, '(i8)' ) iconf

         do i = 1, natom
            k = ikind(i)
            if ( k .lt. jspec_xyz(1) ) cycle
            if ( k .gt. jspec_xyz(2) ) cycle
            xa = ux(i,1) * bohr2ang
            ya = uy(i,1) * bohr2ang
            za = uz(i,1) * bohr2ang
            xb = ux(i,1)
            yb = uy(i,1)
            zb = uz(i,1)
            m1 = 0
            m2 = 0
            m3 = 0
            do j = 1, nbead
               m1 = m1 + mbox(1,i,j)
               m2 = m2 + mbox(2,i,j)
               m3 = m3 + mbox(3,i,j)
            end do
            m1 = m1 / nbead
            m2 = m2 / nbead
            m3 = m3 / nbead
            call calc_pbc_unfold( xb, yb, zb, m1, m2, m3 )
            xb = xb * bohr2ang
            yb = yb * bohr2ang
            zb = zb * bohr2ang
            write( iounit_xyz, '(a4,6f16.8)' ) &
     &         spec(k)(1:4), xa, ya, za, xb, yb, zb
         end do

!-----------------------------------------------------------------------
!     /*   write geometry:  only selected bead                        */
!-----------------------------------------------------------------------

      else if ( jformat_xyz .eq. 4 ) then

         write( iounit_xyz, '(i8)' ) natom_xyz
         write( iounit_xyz, '(i8)' ) iconf

         do i = 1, natom
            k = ikind(i)
            if ( k .lt. jspec_xyz(1) ) cycle
            if ( k .gt. jspec_xyz(2) ) cycle
            xa = x(i,jxyz_bead) * bohr2ang
            ya = y(i,jxyz_bead) * bohr2ang
            za = z(i,jxyz_bead) * bohr2ang
            xb = x(i,jxyz_bead)
            yb = y(i,jxyz_bead)
            zb = z(i,jxyz_bead)
            m1 = mbox(1,i,jxyz_bead)
            m2 = mbox(2,i,jxyz_bead)
            m3 = mbox(3,i,jxyz_bead)
            call calc_pbc_unfold( xb, yb, zb, m1, m2, m3 )
            xb = xb * bohr2ang
            yb = yb * bohr2ang
            zb = zb * bohr2ang
            write( iounit_xyz, '(a4,6f16.8)' ) &
     &         spec(k)(1:4), xa, ya, za, xb, yb, zb
         end do

      end if

      return
      end
