!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_xla_spec_dens_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, params_lin_dens, params_angl_dens, &
     &   counter_xla_spec_dens, iounit_calc_start, &
     &   density_xla_spec_dens, i_xla_spec_dens, j_xla_spec_dens, &
     &   k_xla_spec_dens, iounit_xla_spec_dens, nxla_spec_dens, ncalc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l, nxmesh, nymesh

      integer :: ierr = 0

      real(8) :: xmin, xmax, xmesh, ymin, ymax, ymesh

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'xla.spec.dens ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         nxla_spec_dens = l

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_xla_spec_dens_setup', 35 )

!     /*   go back if not found   */
      if ( nxla_spec_dens .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_xla_spec_dens(nxla_spec_dens) )
      allocate( j_xla_spec_dens(nxla_spec_dens) )
      allocate( k_xla_spec_dens(nxla_spec_dens) )
      allocate( iounit_xla_spec_dens(nxla_spec_dens) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'xla.spec.dens ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_xla_spec_dens(l), j_xla_spec_dens(l), &
     &            k_xla_spec_dens(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_xla_spec_dens_setup', 35 )

!              /*   file number   */
               iounit_xla_spec_dens(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_xla_spec_dens(l), file = char_file )

!              /*   print   */
               write( 6, '(a,3i5,a)' ) &
     &           '2D distrib. of distance-angle of species ', &
     &            i_xla_spec_dens(l), j_xla_spec_dens(l), &
     &            k_xla_spec_dens(l),  ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_xla_spec_dens_setup', 35 )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<params_lin_dens>', 17, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) params_lin_dens(1:3)

      close( iounit )

      if ( ierr .ne. 0 ) then

         open ( iounit, file = 'calc_default.dat' )

!           /*   tag   */
            call search_tag ( '<params_lin_dens>', 17, iounit, ierr )

!           /*   number of interatomic pairs   */
            read( iounit, *, iostat=ierr ) params_lin_dens(1:3)

         close( iounit )

      end if

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_xla_spec_dens_setup', 35 )

!     /*   minimum, maximum, mesh   */
      xmin  = params_lin_dens(1)
      xmax  = params_lin_dens(2)
      xmesh = params_lin_dens(3)

!     /*   number of meshes   */
      nxmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<params_angl_dens>', 18, iounit, ierr )

!        /*   mesh parameters   */
         read( iounit, *, iostat=ierr ) params_angl_dens(1:3)

      close( iounit )

      if ( ierr .ne. 0 ) then

         open ( iounit, file = 'calc_default.dat' )

!           /*   tag   */
            call search_tag ( '<params_angl_dens>', 18, iounit, ierr )

!           /*   mesh parameters   */
            read( iounit, *, iostat=ierr ) params_angl_dens(1:3)

         close( iounit )

      end if

!     /*   minimum, maximum, mesh   */
      ymin  = params_angl_dens(1)
      ymax  = params_angl_dens(2)
      ymesh = params_angl_dens(3)

!     /*   number of meshes   */
      nymesh = nint ( ( ymax - ymin ) / ymesh ) + 1

!     /*   memory allocation   */
      allocate( density_xla_spec_dens(nxmesh,nymesh,nxla_spec_dens) )
      allocate( counter_xla_spec_dens(nxla_spec_dens) )

!     /*   zero clear   */
      density_xla_spec_dens(:,:,:) = 0.d0
      counter_xla_spec_dens(:)   = 0.d0

      return
      end
