!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_xla_spec_dens
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, pi, x, y, z, nbead, natom, ikind, iconf, nconf, &
     &   params_lin_dens, params_angl_dens, counter_xla_spec_dens,  &
     &   density_xla_spec_dens, i_xla_spec_dens, j_xla_spec_dens, &
     &   k_xla_spec_dens, iounit_xla_spec_dens, nxla_spec_dens

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, kk, ll, nxmesh, nymesh

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, rijk, pijk, qijk, bijk, &
     &           rij2, rkj2, xmin, xmax, xmesh, ymin, ymax, ymesh, &
     &           xx, yy, zz

!     /*   real   */
      real(8) :: rij(nbead), aijk(nbead)

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nxla_spec_dens .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   minimum, maximum, mesh                                     */
!-----------------------------------------------------------------------

      xmin  = params_lin_dens(1)
      xmax  = params_lin_dens(2)
      xmesh = params_lin_dens(3)

      ymin  = params_angl_dens(1)
      ymax  = params_angl_dens(2)
      ymesh = params_angl_dens(3)

!-----------------------------------------------------------------------
!     /*   number of meshes                                           */
!-----------------------------------------------------------------------

      nxmesh = nint ( ( xmax - xmin ) / xmesh ) + 1
      nymesh = nint ( ( ymax - ymin ) / ymesh ) + 1

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do l = 1, nxla_spec_dens

         do i = 1, natom

            if ( ikind(i) .ne. i_xla_spec_dens(l) ) cycle

            do j = i+1, natom

               if ( ikind(j) .ne. j_xla_spec_dens(l) ) cycle

               do k = j+1, natom

                  if ( ikind(k) .ne. k_xla_spec_dens(l) ) cycle

                  do m = 1, nbead

                     xij = x(i,m) - x(j,m)
                     yij = y(i,m) - y(j,m)
                     zij = z(i,m) - z(j,m)

                     call pbc_atom_calc ( xij, yij, zij )

                     xkj = x(k,m) - x(j,m)
                     ykj = y(k,m) - y(j,m)
                     zkj = z(k,m) - z(j,m)

                     call pbc_atom_calc ( xkj, ykj, zkj )

!-----------------------------------------------------------------------
!                    /*   distance                                    */
!-----------------------------------------------------------------------

                     rij(m) = sqrt( xij*xij + yij*yij + zij*zij )

                     xx = rij(m)*bohr2ang

!-----------------------------------------------------------------------
!                    /*   angle                                       */
!-----------------------------------------------------------------------

                     rij2 = xij*xij + yij*yij + zij*zij
                     rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

                     rijk = sqrt( rij2*rkj2 )

                     pijk = xij*xkj + yij*ykj + zij*zkj

                     qijk  = pijk/rijk

                     qijk = max( qijk, -1.d0 )
                     qijk = min( qijk,  1.d0 )

                     bijk = acos( qijk )

                     aijk(m) = bijk*(180.d0/pi)

                     yy = aijk(m)

!-----------------------------------------------------------------------
!                    /*   mesh point                                  */
!-----------------------------------------------------------------------

                     kk = nint( ( xx - xmin ) / xmesh ) + 1

                     ll = nint( ( yy - ymin ) / ymesh ) + 1

!-----------------------------------------------------------------------
!                    /*   add counts                                  */
!-----------------------------------------------------------------------

                     counter_xla_spec_dens(l) &
     &                  = counter_xla_spec_dens(l) + 1.d0

!-----------------------------------------------------------------------
!                    /*   out of bounds                               */
!-----------------------------------------------------------------------

                     if ( ( kk .le. 0 ) .or. ( kk .gt. nxmesh ) ) cycle

                     if ( ( ll .le. 0 ) .or. ( ll .gt. nymesh ) ) cycle


!-----------------------------------------------------------------------
!                    /*   add to density                              */
!-----------------------------------------------------------------------

                     density_xla_spec_dens(kk,ll,l) &
     &                  = density_xla_spec_dens(kk,ll,l) + 1.d0

                  end do

               end do

            end do

         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do l = 1, nxla_spec_dens

            if ( counter_xla_spec_dens(l) .eq. 0.d0 ) cycle

            do kk = 1, nxmesh

               do ll = 1, nymesh

!                 /*   mesh point  */
                  xx = xmin + (kk-1)*xmesh

!                 /*   mesh point  */
                  yy = ymin + (ll-1)*ymesh

!                 /*   density normalized to unity   */
                  zz = density_xla_spec_dens(kk,ll,l) &
     &            / counter_xla_spec_dens(l) /xmesh /ymesh

!                 /*   print   */
                  write(iounit_xla_spec_dens(l),'(3e16.8)') xx, yy, zz

               end do

               write( iounit_xla_spec_dens(l), * )

            end do

         end do

      end if

      return
      end
