!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     list of variables for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      module calc_variables
!***********************************************************************

!-----------------------------------------------------------------------
!     system
!-----------------------------------------------------------------------

!     /*   option of initial geometry file   */
      character(len=10) :: input_style

!     /*   number of atoms   */
      integer:: natom

!     /*   number of beads:  only even number is valid here.   */
      integer:: nbead

!     /*   number of atom kinds   */
      integer:: nkind

!     /*   number of atoms per kind   */
      integer, dimension(:), allocatable :: natom_kind

!     /*   number of atomic species   */
      integer:: mspec

!     /*   lattice vector to unfold the trajectory   */
      integer, dimension(:,:,:), allocatable :: mbox

!     /*   atomic positions   */

      real(8), dimension(:,:), allocatable::   x
      real(8), dimension(:,:), allocatable::   y
      real(8), dimension(:,:), allocatable::   z

!     /*   atomic velocities   */

      real(8), dimension(:,:), allocatable::   vx
      real(8), dimension(:,:), allocatable::   vy
      real(8), dimension(:,:), allocatable::   vz

!     /*   atomic forces   */

      real(8), dimension(:,:), allocatable::   fx
      real(8), dimension(:,:), allocatable::   fy
      real(8), dimension(:,:), allocatable::   fz

!     /*   atomic potentials   */

      real(8), dimension(:), allocatable::   pot

!     /*   atomic masses   */

      real(8), dimension(:), allocatable::   physmass

!     /*   normal mode positions   */

      real(8), dimension(:,:), allocatable::   ux
      real(8), dimension(:,:), allocatable::   uy
      real(8), dimension(:,:), allocatable::   uz

!     /*   normal mode momenta      */

      real(8), dimension(:,:), allocatable::   pux
      real(8), dimension(:,:), allocatable::   puy
      real(8), dimension(:,:), allocatable::   puz

!     /*   cell matrix   */
      real(8), dimension(3,3)::  box
      real(8), dimension(3,3)::  boxinv

!     /*   reference volume   */
      real(8)::                  volume_ref

!     /*   reference box   */
      real(8), dimension(3,3)::  box_ref
      real(8), dimension(3,3)::  boxinv_ref

!     /*   atomic species   */

      character(len=8), dimension(:), allocatable::   spec
      character(len=8), dimension(:), allocatable::   species
      integer, dimension(:), allocatable::            int_spec
      integer, dimension(:), allocatable::            natom_spec
      real(8), dimension(:), allocatable::            physmass_spec
      integer, dimension(:), allocatable::            num_spec

!     /*   configuration parameters   */

      integer:: nconf
      integer:: iconf         = 0
      integer:: iconf_end     = 0

!     /*   properties   */

      real(8):: potential

!     /*   boundary condition   */

      integer:: iboundary    = 0
      character(len=10) :: char_boundary
      real(8):: volume

!-----------------------------------------------------------------------
!     file numbers
!-----------------------------------------------------------------------

!     /*   input and output   */
      integer, parameter:: iounit        = 10

!     /*   trajectory     */
      integer, parameter:: iounit_trj    = 12

!     /*   trajectory in xyz format     */
      integer, parameter:: iounit_xyz    = 16

!-----------------------------------------------------------------------
!     timer
!-----------------------------------------------------------------------

!     /*   wall clock time   */
      character(len=28):: char_date

!-----------------------------------------------------------------------
!     mathematical and physical constants
!-----------------------------------------------------------------------

!     /*   circular constant   */
      real(8), parameter:: pi = 3.141592653589793d0

!     /*   Boltzmann constant   */
      real(8), parameter:: boltz     = 0.316682968d-5

!     /*   unit conversion factors   */
      real(8), parameter:: au_length = 0.529177249d-10
      real(8), parameter:: au_mass   = 9.1093897d-31
      real(8), parameter:: au_energy = 4.3597482d-18
      real(8), parameter:: au_time   = 0.024188843d-15
      real(8), parameter:: au_charge = 1.60217646d-19

!     //   conversion factor: Avogadro number
      real(8), parameter:: avogadro  = 6.02214129e+23

!     /*   atomic mass unit   */
      real(8), parameter:: amu_mass  = 1.6605402d-27

!     /*   speed of light in SI unit   */
      real(8), parameter:: speedlight_SI = 2.99892458d+8

!     /*   planck constant   */
      real(8), parameter:: hbar      = 1.d0

!     /*   constant   */
      complex(8), parameter:: zin    = (0.d0,1.d0)

!     /*   debye unit   */
      real(8), parameter :: au2debye = 2.5418d0

!-----------------------------------------------------------------------
!     variables specific in calc
!-----------------------------------------------------------------------

!     /*   number of geometric parameters   */
      integer :: ncalc

!     /*   minimum conf   */
      integer :: iconf_ini_calc

!     /*   maximum conf   */
      integer :: iconf_fin_calc

!     /*   conf number   */
      integer :: iconf_calc = 0

!     /*   print interval   */
      integer :: iprint_calc

!     /*   standard output   */
      integer :: iprint_std_calc

!     /*   print interval   */
      integer :: jprint_xyz

!     /*   starting file number   */
      integer :: iounit_calc_start = 50

!     /*   distance   */
      integer, dimension(:), allocatable:: iounit_lin

!     /*   angle   */
      integer, dimension(:), allocatable:: iounit_angl

!     /*   dihedral   */
      integer, dimension(:), allocatable:: iounit_dih

!     /*   difference   */
      integer, dimension(:), allocatable:: iounit_diff

!     /*   absolute difference   */
      integer, dimension(:), allocatable:: iounit_adiff

!     /*   distance from plane   */
      integer, dimension(:), allocatable:: iounit_opd

!     /*   out of plane angle   */
      integer, dimension(:), allocatable:: iounit_opa

!     /*   area of triangle   */
      integer, dimension(:), allocatable:: iounit_tri

!     /*   distance (species)   */
      integer, dimension(:), allocatable:: iounit_lin_spec

!     /*   angle (species)   */
      integer, dimension(:), allocatable:: iounit_angl_spec

!     /*   dihedral (species)   */
      integer, dimension(:), allocatable:: iounit_dih_spec

!     /*   3d cube   */
      integer, dimension(:), allocatable:: iounit_cube

!     /*   format type of xyz file:  option   */
      integer :: jformat_xyz

!     /*   format type of xyz file:  option   */
      integer :: jorigin_xyz

!     /*   format type of xyz file:  bead number   */
      integer :: jxyz_bead

!     /*   format type of xyz file:  origin   */
      integer :: jxyz_origin

!     /*   format type of xyz file:  origin atom   */
      integer :: jxyz_atom

!     /*   format type of xyz file:  origin   */
      real(8) :: xo, yo, zo

!     /*   format type of xyz file:  printed species   */
      integer, dimension(2) :: jspec_xyz

!     /*   xyz file:  number of printed atoms   */
      integer :: natom_xyz

!     /*   atomic species   */
      integer, dimension(:),   allocatable ::  ikind

!     /*   distance   */
      integer :: nlin
      integer, dimension(:), allocatable :: i_lin
      integer, dimension(:), allocatable :: j_lin

!     /*   angle   */
      integer :: nangl
      integer, dimension(:), allocatable :: i_angl
      integer, dimension(:), allocatable :: j_angl
      integer, dimension(:), allocatable :: k_angl

!     /*   dihedral   */
      integer :: ndih
      integer, dimension(:), allocatable :: i_dih
      integer, dimension(:), allocatable :: j_dih
      integer, dimension(:), allocatable :: k_dih
      integer, dimension(:), allocatable :: l_dih

!     /*   difference   */
      integer :: ndiff
      integer, dimension(:), allocatable :: i_diff
      integer, dimension(:), allocatable :: j_diff
      integer, dimension(:), allocatable :: k_diff

!     /*   absolute difference   */
      integer :: nadiff
      integer, dimension(:), allocatable :: i_adiff
      integer, dimension(:), allocatable :: j_adiff
      integer, dimension(:), allocatable :: k_adiff

!     /*   distance from plane  */
      integer :: nopd
      integer, dimension(:), allocatable :: i_opd
      integer, dimension(:), allocatable :: j_opd
      integer, dimension(:), allocatable :: k_opd
      integer, dimension(:), allocatable :: l_opd

!     /*   out of plane angle   */
      integer :: nopa
      integer, dimension(:), allocatable :: i_opa
      integer, dimension(:), allocatable :: j_opa
      integer, dimension(:), allocatable :: k_opa
      integer, dimension(:), allocatable :: l_opa

!     /*   area of triangle  */
      integer :: ntri
      integer, dimension(:), allocatable :: i_tri
      integer, dimension(:), allocatable :: j_tri
      integer, dimension(:), allocatable :: k_tri

!     /*   distance (species)   */
      integer :: nlin_spec
      integer, dimension(:), allocatable :: i_lin_spec
      integer, dimension(:), allocatable :: j_lin_spec

!     /*   angle (species)  */
      integer :: nangl_spec
      integer, dimension(:), allocatable :: i_angl_spec
      integer, dimension(:), allocatable :: j_angl_spec
      integer, dimension(:), allocatable :: k_angl_spec

!     /*   dihedral (species)  */
      integer :: ndih_spec
      integer, dimension(:), allocatable :: i_dih_spec
      integer, dimension(:), allocatable :: j_dih_spec
      integer, dimension(:), allocatable :: k_dih_spec
      integer, dimension(:), allocatable :: l_dih_spec

!     /*   distance   */
      integer :: nlin_atom_dens
      integer, dimension(:),   allocatable :: i_lin_atom_dens
      integer, dimension(:),   allocatable :: j_lin_atom_dens
      integer, dimension(:),   allocatable :: iounit_lin_atom_dens
      real(8), dimension(:),   allocatable :: counter_lin_atom_dens
      real(8), dimension(:,:), allocatable :: density_lin_atom_dens

!     /*   angle   */
      integer :: nangl_atom_dens
      integer, dimension(:),   allocatable :: i_angl_atom_dens
      integer, dimension(:),   allocatable :: j_angl_atom_dens
      integer, dimension(:),   allocatable :: k_angl_atom_dens
      integer, dimension(:),   allocatable :: iounit_angl_atom_dens
      real(8), dimension(:),   allocatable :: counter_angl_atom_dens
      real(8), dimension(:,:), allocatable :: density_angl_atom_dens

!     /*   dihedral   */
      integer :: ndih_atom_dens
      integer, dimension(:),   allocatable :: i_dih_atom_dens
      integer, dimension(:),   allocatable :: j_dih_atom_dens
      integer, dimension(:),   allocatable :: k_dih_atom_dens
      integer, dimension(:),   allocatable :: l_dih_atom_dens
      integer, dimension(:),   allocatable :: iounit_dih_atom_dens
      real(8), dimension(:),   allocatable :: counter_dih_atom_dens
      real(8), dimension(:,:), allocatable :: density_dih_atom_dens

!     /*   difference   */
      integer :: ndiff_atom_dens
      integer, dimension(:),   allocatable :: i_diff_atom_dens
      integer, dimension(:),   allocatable :: j_diff_atom_dens
      integer, dimension(:),   allocatable :: k_diff_atom_dens
      integer, dimension(:),   allocatable :: iounit_diff_atom_dens
      real(8), dimension(:),   allocatable :: counter_diff_atom_dens
      real(8), dimension(:,:), allocatable :: density_diff_atom_dens

!     /*   absolute difference   */
      integer :: nadiff_atom_dens
      integer, dimension(:),   allocatable :: i_adiff_atom_dens
      integer, dimension(:),   allocatable :: j_adiff_atom_dens
      integer, dimension(:),   allocatable :: k_adiff_atom_dens
      integer, dimension(:),   allocatable :: iounit_adiff_atom_dens
      real(8), dimension(:),   allocatable :: counter_adiff_atom_dens
      real(8), dimension(:,:), allocatable :: density_adiff_atom_dens

!     /*   distance (species)   */
      integer :: nlin_spec_dens
      integer, dimension(:),   allocatable :: i_lin_spec_dens
      integer, dimension(:),   allocatable :: j_lin_spec_dens
      integer, dimension(:),   allocatable :: iounit_lin_spec_dens
      real(8), dimension(:),   allocatable :: counter_lin_spec_dens
      real(8), dimension(:,:), allocatable :: density_lin_spec_dens

!     /*   angle (species)   */
      integer :: nangl_spec_dens
      integer, dimension(:),   allocatable :: i_angl_spec_dens
      integer, dimension(:),   allocatable :: j_angl_spec_dens
      integer, dimension(:),   allocatable :: k_angl_spec_dens
      integer, dimension(:),   allocatable :: iounit_angl_spec_dens
      real(8), dimension(:),   allocatable :: counter_angl_spec_dens
      real(8), dimension(:,:), allocatable :: density_angl_spec_dens

!     /*   dihedral (species)   */
      integer :: ndih_spec_dens
      integer, dimension(:),   allocatable :: i_dih_spec_dens
      integer, dimension(:),   allocatable :: j_dih_spec_dens
      integer, dimension(:),   allocatable :: k_dih_spec_dens
      integer, dimension(:),   allocatable :: l_dih_spec_dens
      integer, dimension(:),   allocatable :: iounit_dih_spec_dens
      real(8), dimension(:),   allocatable :: counter_dih_spec_dens
      real(8), dimension(:,:), allocatable :: density_dih_spec_dens

!     /*   two-dimensional distance-angle (species)   */
      integer :: nxla_spec_dens
      integer, dimension(:),     allocatable :: i_xla_spec_dens
      integer, dimension(:),     allocatable :: j_xla_spec_dens
      integer, dimension(:),     allocatable :: k_xla_spec_dens
      integer, dimension(:),     allocatable :: iounit_xla_spec_dens
      real(8), dimension(:),     allocatable :: counter_xla_spec_dens
      real(8), dimension(:,:,:), allocatable :: density_xla_spec_dens

!     /*   distance   */
      integer :: nlin_avg
      integer, dimension(:),     allocatable :: i_lin_avg
      integer, dimension(:),     allocatable :: j_lin_avg
      integer, dimension(:),     allocatable :: iounit_lin_avg
      real(8), dimension(:),     allocatable :: counter_lin_avg
      real(8), dimension(:),     allocatable :: value_lin_avg
      real(8), dimension(:),     allocatable :: squar_lin_avg

!     /*   angle   */
      integer :: nangl_avg
      integer, dimension(:),     allocatable :: i_angl_avg
      integer, dimension(:),     allocatable :: j_angl_avg
      integer, dimension(:),     allocatable :: k_angl_avg
      integer, dimension(:),     allocatable :: iounit_angl_avg
      real(8), dimension(:),     allocatable :: counter_angl_avg
      real(8), dimension(:),     allocatable :: value_angl_avg
      real(8), dimension(:),     allocatable :: squar_angl_avg

!     /*   dihedral   */
      integer :: ndih_avg
      integer, dimension(:),     allocatable :: i_dih_avg
      integer, dimension(:),     allocatable :: j_dih_avg
      integer, dimension(:),     allocatable :: k_dih_avg
      integer, dimension(:),     allocatable :: l_dih_avg
      integer, dimension(:),     allocatable :: iounit_dih_avg
      real(8), dimension(:),     allocatable :: counter_dih_avg
      real(8), dimension(:),     allocatable :: value_dih_avg
      real(8), dimension(:),     allocatable :: squar_dih_avg

!     /*   distance   */
      real(8), dimension(3) :: params_lin_dens

!     /*   angle   */
      real(8), dimension(3) :: params_angl_dens

!     /*   dihedral   */
      real(8), dimension(3) :: params_dih_dens

!     /*   difference   */
      real(8), dimension(3) :: params_diff_dens

!     /*   absolute difference   */
      real(8), dimension(3) :: params_adiff_dens

!     /*   3d cube   */
      integer :: ncube
      integer, dimension(:),       allocatable :: i_cube
      integer, dimension(:),       allocatable :: j_cube
      integer, dimension(:),       allocatable :: k_cube
      real(8), dimension(:,:,:,:), allocatable :: denscube
      real(8) :: denstot_cube
      integer, dimension(:),       allocatable :: i_cube_spec
      integer :: nx_cube, ny_cube, nz_cube
      real(8) :: xmin_cube, ymin_cube, zmin_cube
      real(8) :: xmax_cube, ymax_cube, zmax_cube
      real(8) :: dx_cube, dy_cube, dz_cube

!***********************************************************************
      end module calc_variables
!***********************************************************************
