!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_tri
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, x, y, z, nbead, &
     &   iounit_tri, ntri, i_tri, j_tri, k_tri

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m, n

!     /*   real   */
      real(8) ::  xji, yji, zji, xki, yki, zki, xijk, yijk, zijk, tri

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( ntri .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, ntri

         i = i_tri(n)
         j = j_tri(n)
         k = k_tri(n)

         do m = 1, nbead

!           /*  i-j vector   */

            xji = x(j,m) - x(i,m)
            yji = y(j,m) - y(i,m)
            zji = z(j,m) - z(i,m)

            call pbc_atom_calc ( xji, yji, zji )

!           /*  i-k vector   */

            xki = x(k,m) - x(i,m)
            yki = y(k,m) - y(i,m)
            zki = z(k,m) - z(i,m)

            call pbc_atom_calc ( xki, yki, zki )

!           /*  cross product   */

            zijk = xji*yki - yji*xki
            xijk = yji*zki - zji*yki
            yijk = zji*xki - xji*zki

!           /*   area of triangle   */

            tri = 0.5d0*sqrt( xijk*xijk + yijk*yijk + zijk*zijk )

!           /*   print   */

            write( iounit_tri(n), '(f10.5)' ) tri*bohr2ang*bohr2ang

         end do

      end do

      return
      end
