!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Feb 27, 2019 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_read_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   x, y, z, fx, fy, fz, pot, vx, vy, vz, iconf, nconf, iounit, &
     &   natom, nbead, iounit_trj, iconf_end, char_date, &
     &   iconf_fin_calc, iprint_std_calc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   step number   */
      integer :: istep

!     /*   maximum step   */
      integer :: istep_max = 0

!     /*   minimum step   */
      integer :: istep_min = 0

!     /*   number of steps per configuration   */
      integer :: nstep_per_conf

!     /*   integer   */
      integer :: i, j

!     /*   integer   */
      integer :: ierr = 0

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Reading trj.out: start.'

      write( 6, '(a)' )

!-----------------------------------------------------------------------
!     /*   read number of lines                                       */
!-----------------------------------------------------------------------

      open ( iounit_trj, file = 'trj.out' )

      iconf_end = 0

      if ( iconf_fin_calc .le. 0 ) then

         do

!           /*   read geometry in trj.out type format   */

            do j = 1, nbead
            do i = 1, natom
               read ( iounit_trj, *, iostat=ierr ) &
     &            istep,  x(i,j),  y(i,j),  z(i,j), &
     &                    vx(i,j), vy(i,j), vz(i,j), &
     &                    fx(i,j), fy(i,j), fz(i,j), pot(j)
            end do
            end do

!           /*   exit if error detected   */
            if ( ierr .ne. 0 ) exit

!           /*   add conf   */
            iconf_end = iconf_end + 1

!           /*   maximum and minimum step   */
            if ( istep_min .eq. 0 ) istep_min = istep
            if ( istep_min .eq. 0 ) istep_max = istep
            if ( istep_min .gt. istep ) istep_min = istep
            if ( istep_max .lt. istep ) istep_max = istep

!           /*   scale forces   */

            do j = 1, nbead
            do i = 1, natom
               fx(i,j) = fx(i,j) / nbead
               fy(i,j) = fy(i,j) / nbead
               fz(i,j) = fz(i,j) / nbead
            end do
            end do

!           /*   read geometry in trj.out type format   */

            if ( iconf_end .eq. 1 ) then
               call getdate_calc
               write( 6, '(i8,a,2x,a26)' ) &
     &            iconf_end, ' configuration  read,', char_date
            else if ( mod(iconf_end,iprint_std_calc) .eq. 0 ) then
               call getdate_calc
               write( 6, '(i8,a,2x,a26)' ) &
     &            iconf_end, ' configurations read,', char_date
            end if

         end do

         write( 6, '(a)' )

      else

         do iconf = 1, iconf_fin_calc

!           /*   read geometry in trj.out type format   */

            do j = 1, nbead
            do i = 1, natom
               read ( iounit_trj, *, iostat=ierr ) &
     &            istep,  x(i,j),  y(i,j),  z(i,j), &
     &                    vx(i,j), vy(i,j), vz(i,j), &
     &                    fx(i,j), fy(i,j), fz(i,j), pot(j)
            end do
            end do

!           /*   exit if error detected   */
            if ( ierr .ne. 0 ) exit

!           /*   add conf   */
            iconf_end = iconf_end + 1

!           /*   scale forces   */

            do j = 1, nbead
            do i = 1, natom
               fx(i,j) = fx(i,j) / nbead
               fy(i,j) = fy(i,j) / nbead
               fz(i,j) = fz(i,j) / nbead
            end do
            end do

!           /*   read geometry in trj.out type format   */

            if ( iconf_end .eq. 1 ) then
               call getdate_calc
               write( 6, '(i8,a,2x,a26)' ) &
     &            iconf_end, ' configuration  read,', char_date
            else if ( mod(iconf_end,iprint_std_calc) .eq. 0 ) then
               call getdate_calc
               write( 6, '(i8,a,2x,a26)' ) &
     &            iconf_end, ' configurations read,', char_date
            end if

         end do

         write( 6, '(a)' )

      end if

      close( iounit_trj )

      ierr = 0

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) 'Reading trj.out: ended.'

      write( 6, '(a)' )

!-----------------------------------------------------------------------
!     /*   number of configurations read                              */
!-----------------------------------------------------------------------

      if ( iconf_fin_calc .eq. -1 ) then

         nconf = iconf_end

      else

         nconf = min( iconf_end, iconf_fin_calc )

      end if

!-----------------------------------------------------------------------
!     /*   number of steps per configuration                          */
!-----------------------------------------------------------------------

      if ( nconf .eq. 1 ) then
         nstep_per_conf = 1
      else
         nstep_per_conf = (istep_max-istep_min)/(nconf-1)
      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      write( 6, '(a)' ) &
     &   'Information of trj.out:'

      write( 6, '(a,i8)' ) &
     &   'Step number of first configuration: ', istep_min

      write( 6, '(a,i8)' ) &
     &   'Step number of last configuration:  ', istep_max

      write( 6, '(a,i8)' ) &
     &   'Number of steps per configuration:  ', nstep_per_conf

      write( 6, '(a,i8)' ) &
     &   'Number of configurations read:      ', nconf

      write( 6, '(a)' )

      return
      end
