!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_read
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   x, y, z, vx, vy, vz, fx, fy, fz, pot, potential, iconf, &
     &   iounit_trj, natom, nbead

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, ierr, istep

      integer, save :: iset = 0

!-----------------------------------------------------------------------
!     /*   file open                                                  */
!-----------------------------------------------------------------------

      if ( iset .eq. 0 ) then

         open ( iounit_trj, file = 'trj.out',  status = 'unknown' )

         iset = 1

      end if

!-----------------------------------------------------------------------
!     /*   read trj.out                                               */
!-----------------------------------------------------------------------

!     /*   read geometry in trj.out type format   */

      do j = 1, nbead
      do i = 1, natom
         read ( iounit_trj, *, iostat=ierr ) &
     &      istep,  x(i,j),  y(i,j),  z(i,j), &
     &              vx(i,j), vy(i,j), vz(i,j), &
     &              fx(i,j), fy(i,j), fz(i,j), pot(j)
      end do
      end do

!     /*   prepare for read error   */

      if ( ierr .ne. 0 ) then
         write( 6, '(a,i8,a)' ) &
     &     'Error - while reading trj.out at conf: ', iconf, '.'
         write( 6, '(a)' )
      end if

      call error_handling_calc ( ierr, 'subroutine calc_read', 20 )

!     /*   scale forces   */

      do j = 1, nbead
      do i = 1, natom
         fx(i,j) = fx(i,j) / nbead
         fy(i,j) = fy(i,j) / nbead
         fz(i,j) = fz(i,j) / nbead
      end do
      end do

!     /*   potential   */

      potential = 0.d0

      do j = 1, nbead
         potential = potential + pot(j) / nbead
      end do

      return
      end
