!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     main code for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_pbc_unfold( xb, yb, zb, m1, m2, m3 )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : iboundary, box

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: m1, m2, m3

      real(8) :: xb, yb, zb

!-----------------------------------------------------------------------
!     /*   main part                                                  */
!-----------------------------------------------------------------------

      if ( iboundary .eq. 1 ) then

         xb = xb + dble(m1)*box(1,1) &
     &           + dble(m2)*box(1,2) &
     &           + dble(m3)*box(1,3)

         yb = yb + dble(m1)*box(2,1) &
     &           + dble(m2)*box(2,2) &
     &           + dble(m3)*box(2,3)

         zb = zb + dble(m1)*box(3,1) &
     &           + dble(m2)*box(3,2) &
     &           + dble(m3)*box(3,3)

      end if

      return
      end

