!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_opd
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, x, y, z, nbead, &
     &   iounit_opd, nopd, i_opd, j_opd, k_opd, l_opd

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, n

!     /*   real   */
      real(8) ::  xkj, ykj, zkj, xlj, ylj, zlj, &
     &   xjkl, yjkl, zjkl, rjkl, a, b, c, d, opd

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nopd .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, nopd

         i = i_opd(n)
         j = j_opd(n)
         k = k_opd(n)
         l = l_opd(n)

         do m = 1, nbead

!           /*  j-k vector   */

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

!           /*  j-l vector   */

            xlj = x(l,m) - x(j,m)
            ylj = y(l,m) - y(j,m)
            zlj = z(l,m) - z(j,m)

            call pbc_atom_calc ( xlj, ylj, zlj )

!           /*  cross product   */

            zjkl = xkj*ylj - ykj*xlj
            xjkl = ykj*zlj - zkj*ylj
            yjkl = zkj*xlj - xkj*zlj

!           /*   the norm   */

            rjkl = sqrt( xjkl*xjkl + yjkl*yjkl + zjkl*zjkl )

!           /*   normal vector   */

            a = xjkl / rjkl
            b = yjkl / rjkl
            c = zjkl / rjkl

!           /*   d coefficient   */

            d = - ( a*x(j,m) + b*y(j,m) + c*z(j,m) )

!           /*   distance between point i and jkl plane   */

            opd = a*x(i,m) + b*y(i,m) + c*z(i,m) + d

            write( iounit_opd(n), '(f10.5)' ) opd*bohr2ang

         end do

      end do

      return
      end
