!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_opa
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, &
     &   iounit_opa, nopa, i_opa, j_opa, k_opa, l_opa

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, n

!     /*   real   */
      real(8) ::  xij, yij, zij, rij, xkj, ykj, zkj, xlj, ylj, zlj, &
     &   xjkl, yjkl, zjkl, rjkl, phi, opa, cos_phi

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nopa .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, nopa

         i = i_opa(n)
         j = j_opa(n)
         k = k_opa(n)
         l = l_opa(n)

         do m = 1, nbead

!           /*   j-i vector   */

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

!           /*   the norm   */

            rij = sqrt( xij*xij + yij*yij + zij*zij )

!           /*   j-k vector   */

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

!           /*   j-l vector   */

            xlj = x(l,m) - x(j,m)
            ylj = y(l,m) - y(j,m)
            zlj = z(l,m) - z(j,m)

            call pbc_atom_calc ( xlj, ylj, zlj )

!           /*   cross product   */

            zjkl = xkj*ylj - ykj*xlj
            xjkl = ykj*zlj - zkj*ylj
            yjkl = zkj*xlj - xkj*zlj

!           /*   the norm   */

            rjkl = sqrt( xjkl*xjkl + yjkl*yjkl + zjkl*zjkl )

!           /*   angle between normal and j-i vectors   */

            cos_phi = (xij*xjkl + yij*yjkl + zij*zjkl) / (rij*rjkl)

            cos_phi = max( cos_phi, -1.d0 )
            cos_phi = min( cos_phi,  1.d0 )

            phi = acos( cos_phi )

            phi = abs( phi )

!           /*   angle between jkl plane and j-i vector   */

            if ( phi .lt. 0.5d0*pi ) then

               opa = 0.5d0*pi - phi

            else

               opa = phi - 0.5d0*pi

            end if

            write( iounit_opa(n), '(f10.5)' ) opa*180.d0/pi

         end do

      end do

      return
      end
