!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_lin_spec_dens_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   params_lin_dens, counter_lin_spec_dens, iounit_calc_start, &
     &   density_lin_spec_dens, i_lin_spec_dens, j_lin_spec_dens, &
     &   iounit_lin_spec_dens, nlin_spec_dens, ncalc, iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l, nmesh

      integer :: ierr = 0

      real(8) :: xmin, xmax, xmesh

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'lin.spec.dens ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         nlin_spec_dens = l

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_lin_spec_dens_setup', 35 )

!     /*   go back if not found   */
      if ( nlin_spec_dens .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_lin_spec_dens(nlin_spec_dens) )
      allocate( j_lin_spec_dens(nlin_spec_dens) )
      allocate( iounit_lin_spec_dens(nlin_spec_dens) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'lin.spec.dens ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_lin_spec_dens(l), j_lin_spec_dens(l), &
     &            char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_lin_spec_dens_setup', 35 )

!              /*   file number   */
               iounit_lin_spec_dens(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_lin_spec_dens(l), file = char_file )

!              /*   print   */
               write( 6, '(a,2i5,a)' ) &
     &           'Distribution of distances of species ', &
     &            i_lin_spec_dens(l), j_lin_spec_dens(l), ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_lin_spec_dens_setup', 35 )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<params_lin_dens>', 17, iounit, ierr )

!        /*   mesh parameters   */
         read( iounit, *, iostat=ierr ) params_lin_dens(1:3)

      close( iounit )

      if ( ierr .ne. 0 ) then

         open ( iounit, file = 'calc_default.dat' )

!           /*   tag   */
            call search_tag ( '<params_lin_dens>', 17, iounit, ierr )

!           /*   mesh parameters   */
            read( iounit, *, iostat=ierr ) params_lin_dens(1:3)

         close( iounit )

      end if

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_lin_spec_dens_setup', 35 )

!     /*   minimum, maximum, mesh   */
      xmin  = params_lin_dens(1)
      xmax  = params_lin_dens(2)
      xmesh = params_lin_dens(3)

!     /*   number of meshes   */
      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!     /*   memory allocation   */
      allocate( density_lin_spec_dens(nmesh,nlin_spec_dens) )
      allocate( counter_lin_spec_dens(nlin_spec_dens) )

!     /*   zero clear   */
      density_lin_spec_dens(:,:) = 0.d0
      counter_lin_spec_dens(:)   = 0.d0

      return
      end
