!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_lin_avg_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   counter_lin_avg, value_lin_avg, squar_lin_avg, iounit_lin_avg, &
     &   i_lin_avg, j_lin_avg, nlin_avg, ncalc, iounit_calc_start, &
     &   iounit

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. 'lin.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         nlin_avg = l

      close( iounit )

!     /*   go back if not found   */
      if ( nlin_avg .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_lin_avg(nlin_avg) )
      allocate( j_lin_avg(nlin_avg) )
      allocate( iounit_lin_avg(nlin_avg) )
      allocate( counter_lin_avg(nlin_avg) )
      allocate( value_lin_avg(nlin_avg) )
      allocate( squar_lin_avg(nlin_avg) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. 'lin.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_lin_avg(l), j_lin_avg(l), &
     &            char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_lin_avg_setup', 29 )

!              /*   file number   */
               iounit_lin_avg(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_lin_avg(l), file = char_file )

!              /*   print   */
               write( 6, '(a,2i5,a)' ) &
     &           'Average distances of atoms ', &
     &            i_lin_avg(l), j_lin_avg(l), ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_lin_avg_setup', 29 )

!-----------------------------------------------------------------------
!     /*   zero clear                                                 */
!-----------------------------------------------------------------------

      counter_lin_avg(:) = 0.d0
      value_lin_avg(:)   = 0.d0
      squar_lin_avg(:)   = 0.d0

      return
      end
