!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_lin_avg
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, x, y, z, nbead, iconf, nconf, &
     &   value_lin_avg, squar_lin_avg, counter_lin_avg, &
     &   i_lin_avg, j_lin_avg, nlin_avg, iounit_lin_avg

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: m, k, i, j

!     /*   real   */
      real(8) :: xij, yij, zij, value_1, value_2, value_3

!     /*   real   */
      real(8) :: rij(nbead)

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nlin_avg .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do k = 1, nlin_avg

         i = i_lin_avg(k)
         j = j_lin_avg(k)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            rij(m) = sqrt( xij*xij + yij*yij + zij*zij )

            counter_lin_avg(k) = counter_lin_avg(k) + 1.d0

         end do

         do m = 1, nbead
            value_1 = rij(m)*bohr2ang
            value_lin_avg(k) = value_lin_avg(k) + value_1
            squar_lin_avg(k) = squar_lin_avg(k) + value_1*value_1
         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do k = 1, nlin_avg

            value_1 = value_lin_avg(k)/counter_lin_avg(k)
            value_2 = squar_lin_avg(k)/counter_lin_avg(k)
            value_3 = sqrt( value_2 - value_1*value_1 )

            write( iounit_lin_avg(k), '(2f10.5)' ) value_1, value_3

         end do

      end if

      return
      end
