!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_lin_atom_dens
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   au_length, x, y, z, nbead, iconf, nconf, &
     &   params_lin_dens, counter_lin_atom_dens, density_lin_atom_dens, &
     &   i_lin_atom_dens, j_lin_atom_dens, iounit_lin_atom_dens, &
     &   nlin_atom_dens

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: m, i, j, k, kk, nmesh

!     /*   real   */
      real(8) :: xij, yij, zij, xmin, xmax, xmesh, xx, yy

!     /*   real   */
      real(8) :: rij(nbead)

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nlin_atom_dens .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   minimum, maximum, mesh                                     */
!-----------------------------------------------------------------------

      xmin  = params_lin_dens(1)
      xmax  = params_lin_dens(2)
      xmesh = params_lin_dens(3)

!-----------------------------------------------------------------------
!     /*   number of meshes                                           */
!-----------------------------------------------------------------------

      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do k = 1, nlin_atom_dens

         i = i_lin_atom_dens(k)
         j = j_lin_atom_dens(k)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            rij(m) = sqrt( xij*xij + yij*yij + zij*zij )

!           /*   data   */
            xx = rij(m)*bohr2ang

!           /*   mesh point  */
            kk = nint( ( xx - xmin ) / xmesh ) + 1

!           /*   add counts   */
            counter_lin_atom_dens(k) &
     &         = counter_lin_atom_dens(k) + 1.d0

!           /*   out of bounds   */
            if ( ( kk .le. 0 ) .or. ( kk .gt. nmesh ) ) cycle

!           /*   add to density   */
            density_lin_atom_dens(kk,k) &
     &         = density_lin_atom_dens(kk,k) + 1.d0

         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do k = 1, nlin_atom_dens

            if ( counter_lin_atom_dens(k) .eq. 0.d0 ) cycle

            do kk = 1, nmesh

!              /*   mesh point  */
               xx = xmin + (kk-1)*xmesh

!              /*   density normalized to unity   */
               yy = density_lin_atom_dens(kk,k) &
     &            / counter_lin_atom_dens(k) /xmesh

!              /*   print   */
               write( iounit_lin_atom_dens(k), '(2e24.16)' ) xx, yy

            end do

         end do

      end if

      return
      end
