!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_dih_spec_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, i_dih_spec, j_dih_spec, k_dih_spec, l_dih_spec, &
     &   ndih_spec, iounit_dih_spec, ncalc, iounit_calc_start

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'dih.spec.list ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         ndih_spec = l

      close( iounit )

!     /*   go back if not found   */
      if ( ndih_spec .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_dih_spec(ndih_spec) )
      allocate( j_dih_spec(ndih_spec) )
      allocate( k_dih_spec(ndih_spec) )
      allocate( l_dih_spec(ndih_spec) )
      allocate( iounit_dih_spec(ndih_spec) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'dih.spec.list ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atomic species   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_dih_spec(l), j_dih_spec(l), &
     &            k_dih_spec(l), l_dih_spec(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_dih_spec_setup', 30 )

!              /*   file number   */
               iounit_dih_spec(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_dih_spec(l), file = char_file )

!              /*   print   */
               write( 6, '(a,4i5,a)' ) &
     &           'List of dihedrals of species ', &
     &            i_dih_spec(l), j_dih_spec(l), k_dih_spec(l), &
     &            l_dih_spec(l), ' in ' // trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_dih_setup_spec', 30 )


      return
      end
