!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_dih_spec_dens
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, natom, ikind, iconf, nconf, &
     &   params_dih_dens, counter_dih_spec_dens, &
     &   density_dih_spec_dens, i_dih_spec_dens, j_dih_spec_dens, &
     &   k_dih_spec_dens, l_dih_spec_dens, &
     &   iounit_dih_spec_dens, ndih_spec_dens

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, n, kk, nmesh

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, xlj, ylj, zlj, &
     &           xijk, yijk, zijk, xjkl, yjkl, zjkl, rijk2, rjkl2, &
     &           rijkl2, rijkl2inv, xmin, xmax, xmesh, xx, yy, &
     &           cos_phi, phi, sign_phi

!     /*   real   */
      real(8) :: psi(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( ndih_spec_dens .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   minimum, maximum, mesh                                     */
!-----------------------------------------------------------------------

      xmin  = params_dih_dens(1)
      xmax  = params_dih_dens(2)
      xmesh = params_dih_dens(3)

!-----------------------------------------------------------------------
!     /*   number of meshes                                           */
!-----------------------------------------------------------------------

      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, ndih_spec_dens

         do i = 1, natom

            if ( ikind(i) .ne. i_dih_spec_dens(n) ) cycle

            do j = i+1, natom

               if ( ikind(j) .ne. j_dih_spec_dens(n) ) cycle

               do k = j+1, natom

                  if ( ikind(k) .ne. k_dih_spec_dens(n) ) cycle

                  do l = k+1, natom

                     if ( ikind(l) .ne. l_dih_spec_dens(n) ) cycle

                     do m = 1, nbead

                        xij = x(i,m) - x(j,m)
                        yij = y(i,m) - y(j,m)
                        zij = z(i,m) - z(j,m)

                        call pbc_atom_calc ( xij, yij, zij )

                        xkj = x(k,m) - x(j,m)
                        ykj = y(k,m) - y(j,m)
                        zkj = z(k,m) - z(j,m)

                        call pbc_atom_calc ( xkj, ykj, zkj )

                        xlj = x(l,m) - x(j,m)
                        ylj = y(l,m) - y(j,m)
                        zlj = z(l,m) - z(j,m)

                        call pbc_atom_calc ( xlj, ylj, zlj )

                        xijk = yij*zkj - zij*ykj
                        yijk = zij*xkj - xij*zkj
                        zijk = xij*ykj - yij*xkj

                        xjkl = ylj*zkj - zlj*ykj
                        yjkl = zlj*xkj - xlj*zkj
                        zjkl = xlj*ykj - ylj*xkj

                        rijk2  = xijk*xijk + yijk*yijk + zijk*zijk
                        rjkl2  = xjkl*xjkl + yjkl*yjkl + zjkl*zjkl

                        rijkl2 = sqrt(rijk2*rjkl2)

                        rijkl2inv = 1.d0 / rijkl2

                        cos_phi &
     &                     = (xijk*xjkl + yijk*yjkl + zijk*zjkl) &
     &                     * rijkl2inv

                        cos_phi = max( cos_phi, -1.d0 )
                        cos_phi = min( cos_phi,  1.d0 )

                        phi = acos( cos_phi )

                        sign_phi = ( yijk*zjkl - zijk*yjkl ) * xkj &
     &                           + ( zijk*xjkl - xijk*zjkl ) * ykj &
     &                           + ( xijk*yjkl - yijk*xjkl ) * zkj

                        sign_phi = sign( 1.d0, sign_phi )

                        phi = phi * sign_phi

                        psi(m) = phi*(180.d0/pi)

                        psi(m) = psi(m) &
     &                  - 360.d0 * nint( psi(m) / 360.d0 )

!                       /*   data   */
                        xx = psi(m)

!                       /*   mesh point  */
                        kk = nint( ( xx - xmin ) / xmesh ) + 1

!                       /*   add counts   */
                        counter_dih_spec_dens(n) &
     &                     = counter_dih_spec_dens(n) + 1.d0

!                       /*   out of bounds   */
                        if ( ( kk .le. 0 ) .or. ( kk .gt. nmesh ) ) &
     &                     cycle

!                       /*   add to density   */
                        density_dih_spec_dens(kk,n) &
     &                     = density_dih_spec_dens(kk,n) + 1.d0

                     end do

                  end do

               end do

            end do

         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do n = 1, ndih_spec_dens

            if ( counter_dih_spec_dens(n) .eq. 0.d0 ) cycle

            do kk = 1, nmesh

!              /*   mesh point  */
               xx = xmin + (kk-1)*xmesh

!              /*   density normalized to unity   */
               yy = density_dih_spec_dens(kk,n) &
     &            / counter_dih_spec_dens(n) /xmesh

!              /*   print   */
               write( iounit_dih_spec_dens(n), '(2e24.16)' ) xx, yy

            end do

         end do

      end if

      return
      end
