!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_dih_spec
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, natom, ikind, &
     &   i_dih_spec, j_dih_spec, k_dih_spec, l_dih_spec, &
     &   ndih_spec, iounit_dih_spec

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, n

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, xlj, ylj, zlj, &
     &           xijk, yijk, zijk, xjkl, yjkl, zjkl, rijk2, rjkl2, &
     &           rijkl2, rijkl2inv, cos_phi, phi, sign_phi

!     /*   real   */
      real(8) :: psi(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( ndih_spec .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, ndih_spec

         do i = 1, natom

            if ( ikind(i) .ne. i_dih_spec(n) ) cycle

            do j = i+1, natom

               if ( ikind(j) .ne. j_dih_spec(n) ) cycle

               do k = j+1, natom

                  if ( ikind(k) .ne. k_dih_spec(n) ) cycle

                  do l = k+1, natom

                     if ( ikind(l) .ne. l_dih_spec(n) ) cycle

                     do m = 1, nbead

                        xij = x(i,m) - x(j,m)
                        yij = y(i,m) - y(j,m)
                        zij = z(i,m) - z(j,m)

                        call pbc_atom_calc ( xij, yij, zij )

                        xkj = x(k,m) - x(j,m)
                        ykj = y(k,m) - y(j,m)
                        zkj = z(k,m) - z(j,m)

                        call pbc_atom_calc ( xkj, ykj, zkj )

                        xlj = x(l,m) - x(j,m)
                        ylj = y(l,m) - y(j,m)
                        zlj = z(l,m) - z(j,m)

                        call pbc_atom_calc ( xlj, ylj, zlj )

                        xijk = yij*zkj - zij*ykj
                        yijk = zij*xkj - xij*zkj
                        zijk = xij*ykj - yij*xkj

                        xjkl = ylj*zkj - zlj*ykj
                        yjkl = zlj*xkj - xlj*zkj
                        zjkl = xlj*ykj - ylj*xkj

                        rijk2  = xijk*xijk + yijk*yijk + zijk*zijk
                        rjkl2  = xjkl*xjkl + yjkl*yjkl + zjkl*zjkl

                        rijkl2 = sqrt(rijk2*rjkl2)

                        rijkl2inv = 1.d0 / rijkl2

                        cos_phi &
     &                     = (xijk*xjkl + yijk*yjkl + zijk*zjkl) &
     &                     * rijkl2inv

                        cos_phi = max( cos_phi, -1.d0 )
                        cos_phi = min( cos_phi,  1.d0 )

                        phi = acos( cos_phi )

                        sign_phi = ( yijk*zjkl - zijk*yjkl ) * xkj &
     &                           + ( zijk*xjkl - xijk*zjkl ) * ykj &
     &                           + ( xijk*yjkl - yijk*xjkl ) * zkj

                        sign_phi = sign( 1.d0, sign_phi )

                        phi = phi * sign_phi

                        psi(m) = phi*(180.d0/pi)

                        psi(m) = psi(m) &
     &                     - 360.d0 * nint( psi(m) / 360.d0 )

                     end do

                     do m = 1, nbead
                        write(iounit_dih_spec(n), '(2f10.5)') &
     &                     psi(m), abs(psi(m))
                     end do

                  end do

               end do

            end do

         end do

      end do

      return
      end
