!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_dih_avg_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, counter_dih_avg, value_dih_avg, squar_dih_avg, &
     &   iounit_dih_avg, i_dih_avg, j_dih_avg, k_dih_avg, &
     &   l_dih_avg, ndih_avg, ncalc, iounit_calc_start

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. 'dih.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         ndih_avg = l

      close( iounit )

!     /*   go back if not found   */
      if ( ndih_avg .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_dih_avg(ndih_avg) )
      allocate( j_dih_avg(ndih_avg) )
      allocate( k_dih_avg(ndih_avg) )
      allocate( l_dih_avg(ndih_avg) )
      allocate( iounit_dih_avg(ndih_avg) )
      allocate( counter_dih_avg(ndih_avg) )
      allocate( value_dih_avg(ndih_avg) )
      allocate( squar_dih_avg(ndih_avg) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. 'dih.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_dih_avg(l), j_dih_avg(l), k_dih_avg(l), &
     &            l_dih_avg(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' )
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_dih_avg_setup', 29 )

!              /*   file number   */
               iounit_dih_avg(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_dih_avg(l), file = char_file )

!              /*   print   */
               write( 6, '(a,4i5,a)' ) &
     &           'Average dihedrals of species ', &
     &            i_dih_avg(l), j_dih_avg(l), k_dih_avg(l), &
     &            l_dih_avg(l), ' in ' // trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_dih_avg_setup', 29 )

!-----------------------------------------------------------------------
!     /*   zero clear                                                 */
!-----------------------------------------------------------------------

      counter_dih_avg(:) = 0.d0
      value_dih_avg(:)   = 0.d0
      squar_dih_avg(:)   = 0.d0

      return
      end
