!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_dih_avg
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, iconf, nconf, &
     &   value_dih_avg, squar_dih_avg, counter_dih_avg, &
     &   i_dih_avg, j_dih_avg, k_dih_avg, l_dih_avg, &
     &   ndih_avg, iounit_dih_avg

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, l, m, n

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, xlj, ylj, zlj, &
     &           xijk, yijk, zijk, xjkl, yjkl, zjkl, rijk2, rjkl2, &
     &           rijkl2, rijkl2inv, value_1, value_2, value_3, &
     &           cos_phi, phi, sign_phi

!     /*   real   */
      real(8) :: psi(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( ndih_avg .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do n = 1, ndih_avg

         i = i_dih_avg(n)
         j = j_dih_avg(n)
         k = k_dih_avg(n)
         l = l_dih_avg(n)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

            xlj = x(l,m) - x(j,m)
            ylj = y(l,m) - y(j,m)
            zlj = z(l,m) - z(j,m)

            call pbc_atom_calc ( xlj, ylj, zlj )

            xijk = yij*zkj - zij*ykj
            yijk = zij*xkj - xij*zkj
            zijk = xij*ykj - yij*xkj

            xjkl = ylj*zkj - zlj*ykj
            yjkl = zlj*xkj - xlj*zkj
            zjkl = xlj*ykj - ylj*xkj

            rijk2  = xijk*xijk + yijk*yijk + zijk*zijk
            rjkl2  = xjkl*xjkl + yjkl*yjkl + zjkl*zjkl

            rijkl2 = sqrt(rijk2*rjkl2)

            rijkl2inv = 1.d0 / rijkl2

            cos_phi = ( xijk*xjkl + yijk*yjkl + zijk*zjkl ) * rijkl2inv

            cos_phi = max( cos_phi, -1.d0 )
            cos_phi = min( cos_phi,  1.d0 )

            phi = acos( cos_phi )

            sign_phi = ( yijk*zjkl - zijk*yjkl ) * xkj &
     &               + ( zijk*xjkl - xijk*zjkl ) * ykj &
     &               + ( xijk*yjkl - yijk*xjkl ) * zkj

            sign_phi = sign( 1.d0, sign_phi )

            phi = phi * sign_phi

            psi(m) = phi*(180.d0/pi)

            psi(m) = psi(m) - 360.d0 * nint( psi(m) / 360.d0 )

            counter_dih_avg(n) = counter_dih_avg(n) + 1.d0

         end do

         do m = 1, nbead
            value_1 = psi(m)
            value_dih_avg(n) = value_dih_avg(n) + value_1
            squar_dih_avg(n) = squar_dih_avg(n) + value_1*value_1
         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do n = 1, ndih_avg

            value_1 = value_dih_avg(n)/counter_dih_avg(n)
            value_2 = squar_dih_avg(n)/counter_dih_avg(n)
            value_3 = sqrt( value_2 - value_1*value_1 )

            write( iounit_dih_avg(n), '(2f10.5)' ) value_1, value_3

         end do

      end if

      return
      end
