!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_diff_atom_dens_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, params_diff_dens, density_diff_atom_dens, &
     &   counter_diff_atom_dens, i_diff_atom_dens, &
     &   j_diff_atom_dens, k_diff_atom_dens, ndiff_atom_dens, &
     &   iounit_diff_atom_dens, iounit_calc_start, ncalc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l, nmesh

      integer :: ierr = 0

      real(8) :: xmin, xmax, xmesh

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:15) .eq. 'diff.atom.dens ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         ndiff_atom_dens = l

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_diff_atom_dens_setup', 36 )

!     /*   go back if not found   */
      if ( ndiff_atom_dens .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_diff_atom_dens(ndiff_atom_dens) )
      allocate( j_diff_atom_dens(ndiff_atom_dens) )
      allocate( k_diff_atom_dens(ndiff_atom_dens) )
      allocate( iounit_diff_atom_dens(ndiff_atom_dens) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:15) .eq. 'diff.atom.dens ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_diff_atom_dens(l), j_diff_atom_dens(l), &
     &            k_diff_atom_dens(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_diff_atom_dens_setup', 36 )

!              /*   file number   */
               iounit_diff_atom_dens(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_diff_atom_dens(l), file = char_file )

!              /*   print   */
               write( 6, '(a,3i5,a)' ) &
     &           "Distribution of diff's of atoms ", &
     &            i_diff_atom_dens(l), j_diff_atom_dens(l), &
     &            k_diff_atom_dens(l), ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_diff_atom_dens_setup', 36 )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<params_diff_dens>', 18, iounit, ierr )

!        /*   mesh parameters   */
         read( iounit, *, iostat=ierr ) params_diff_dens(1:3)

      close( iounit )

      if ( ierr .ne. 0 ) then

         open ( iounit, file = 'calc_default.dat' )

!           /*   tag   */
            call search_tag ( '<params_diff_dens>', 18, iounit, ierr )

!           /*   mesh parameters   */
            read( iounit, *, iostat=ierr ) params_diff_dens(1:3)

         close( iounit )

      end if

!     /*   error handling   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_diff_atom_dens_setup', 36 )

!     /*   minimum, maximum, mesh   */
      xmin  = params_diff_dens(1)
      xmax  = params_diff_dens(2)
      xmesh = params_diff_dens(3)

!     /*   number of meshes   */
      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!     /*   memory allocation   */
      allocate( density_diff_atom_dens(nmesh,ndiff_atom_dens) )
      allocate( counter_diff_atom_dens(ndiff_atom_dens) )

!     /*   zero clear   */
      density_diff_atom_dens(:,:) = 0.d0
      counter_diff_atom_dens(:)   = 0.d0

      return
      end
