!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_cube_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, xmax_cube, xmin_cube, ymax_cube, ymin_cube, zmax_cube, &
     &   zmin_cube, dx_cube, dy_cube, dz_cube, denscube, &
     &   i_cube_spec, i_cube, j_cube, k_cube, iounit_cube, &
     &   nx_cube, ny_cube, nz_cube, ncube, iounit_calc_start, ncalc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. '3d.spec.cube ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         ncube = l

      close( iounit )

!     /*   go back if not found   */
      if ( ncube .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_cube_spec(ncube) )
      allocate( i_cube(ncube) )
      allocate( j_cube(ncube) )
      allocate( k_cube(ncube) )
      allocate( iounit_cube(ncube) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:13) .eq. '3d.spec.cube ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atomic species for cube density,             */
!              /*   three atoms that determines frame of the cube,    */
!              /*   and output file name                              */

               read( iounit, *, iostat=ierr ) &
     &            char_line, i_cube_spec(l), &
     &            i_cube(l), j_cube(l), k_cube(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_cube_setup', 26 )

!              /*   file number   */
               iounit_cube(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_cube(l), file = char_file )

!              /*   print   */
               write( 6, '(a,i5,a,3i5,a)' ) &
     &           '3D distrib. of species ', i_cube_spec(l), &
     &           ' with frame ', &
     &            i_cube(l), j_cube(l), k_cube(l), ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   range of cube                                              */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!     /*   tag   */
      call search_tag ( '<3d_range_cube>', 15, iounit, ierr )

!     /*   read minimum, maximum, mesh size of the cube  */
      read( iounit, *, iostat=ierr ) xmin_cube, xmax_cube, dx_cube
      read( iounit, *, iostat=ierr ) ymin_cube, ymax_cube, dy_cube
      read( iounit, *, iostat=ierr ) zmin_cube, zmax_cube, dz_cube

      close( iounit )

      if ( ierr .ne. 0 ) then

         open ( iounit, file = 'calc_default.dat' )

!        /*   tag   */
         call search_tag ( '<3d_range_cube>', 15, iounit, ierr )

!        /*   read minimum, maximum, mesh size of the cube  */
         read( iounit, *, iostat=ierr ) xmin_cube, xmax_cube, dx_cube
         read( iounit, *, iostat=ierr ) ymin_cube, ymax_cube, dy_cube
         read( iounit, *, iostat=ierr ) zmin_cube, zmax_cube, dz_cube

         close( iounit )

      end if

!     /*   check error   */
      if ( ierr .ne. 0 ) then
         write( 6, '(a)' ) 'Error - check format of <3d_range_cube>.'
         write( 6, '(a)' ) 
      end if

!     /*   error termination   */
      call error_handling_calc &
     &   ( ierr, 'subroutine calc_cube_setup', 26 )

!     /*   number of meshes   */
      nx_cube = nint( ( xmax_cube - xmin_cube ) / dx_cube ) + 1
      ny_cube = nint( ( ymax_cube - ymin_cube ) / dy_cube ) + 1
      nz_cube = nint( ( zmax_cube - zmin_cube ) / dz_cube ) + 1

!-----------------------------------------------------------------------
!     /*   memory allocation                                          */
!-----------------------------------------------------------------------

      allocate( denscube(nx_cube,ny_cube,nz_cube,ncube) )

!     /*   density   */
      denscube(:,:,:,:) = 0.d0

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_cube_setup', 26 )

      return
      end
