!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_cube
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   ux, uy, uz, x, y, z, pux, puy, puz, &
     &   iounit, nbead, natom, ikind, iconf, nconf, &
     &   denscube, xmin_cube, ymin_cube, zmin_cube, dx_cube, dy_cube, &
     &   dz_cube, denstot_cube, nx_cube, ny_cube, nz_cube, iconf_calc, &
     &   i_cube_spec, i_cube, j_cube, k_cube, ncube, iounit_cube

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      real(8) :: ax, ay, az, ar, bx, by, bz, br, cx, cy, cz, cr, ab
      real(8) :: xr, yr, zr, xl, yl, zl

      integer :: i, j, k, m, ic, jc, kc, ics, ix, iy, iz

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( ncube .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do m = 1, ncube

!-----------------------------------------------------------------------
!        /*   atoms i, j, k                                           */
!-----------------------------------------------------------------------

         ic = i_cube(m)
         jc = j_cube(m)
         kc = k_cube(m)

!-----------------------------------------------------------------------
!        /*   rules                                                   */
!-----------------------------------------------------------------------

         if ( ic .eq. jc ) cycle
         if ( jc .eq. kc ) cycle
         if ( kc .eq. ic ) cycle

!-----------------------------------------------------------------------
!        /*   make a axis: vector from atom i to atom j               */
!-----------------------------------------------------------------------

         ax = ux(jc,1) - ux(ic,1)
         ay = uy(jc,1) - uy(ic,1)
         az = uz(jc,1) - uz(ic,1)

         call pbc_atom_calc( ax, ay, az )

         ar = sqrt( ax*ax + ay*ay + az*az )

         ax = ax / ar
         ay = ay / ar
         az = az / ar

         ar = 1.d0

!-----------------------------------------------------------------------
!        /*   make b axis: vector from i to k made orthogonal to a    */
!-----------------------------------------------------------------------

         bx = ux(kc,1) - ux(ic,1)
         by = uy(kc,1) - uy(ic,1)
         bz = uz(kc,1) - uz(ic,1)

         call pbc_atom_calc( bx, by, bz )

         ab = ax*bx + ay*by + az*bz

         bx = bx - ab * ax
         by = by - ab * ay
         bz = bz - ab * az

         br = sqrt( bx*bx + by*by + bz*bz )

         bx = bx / br
         by = by / br
         bz = bz / br

         br = 1.d0

!-----------------------------------------------------------------------
!        /*   make c axis: vector orthognal to both a and b           */
!-----------------------------------------------------------------------

         cx = ay*bz - az*by
         cy = az*bx - ax*bz
         cz = ax*by - ay*bx

         cr = 1.d0

!-----------------------------------------------------------------------
!        /*   slide and rotate the system into abc frame              */
!-----------------------------------------------------------------------

!        /*   atomic species   */
         ics = i_cube_spec(m)

         do j = 1, nbead

            do i = 1, natom

!              /*   set ic atom at origin    */
               xl = x(i,j) - ux(ic,1)
               yl = y(i,j) - uy(ic,1)
               zl = z(i,j) - uz(ic,1)

!              /*   apply periodic/free boundary condition   */
               call pbc_atom_calc ( xl, yl, zl )

!              /*   rotate system into abc frame   */
               xr = ax*xl + ay*yl + az*zl
               yr = bx*xl + by*yl + bz*zl
               zr = cx*xl + cy*yl + cz*zl

!              /*   save coordinates in abc frame   */
               pux(i,j) = xr
               puy(i,j) = yr
               puz(i,j) = zr

!              /*   nearest mesh point   */
               ix = nint( ( xr - xmin_cube ) / dx_cube ) + 1
               iy = nint( ( yr - ymin_cube ) / dy_cube ) + 1
               iz = nint( ( zr - zmin_cube ) / dz_cube ) + 1

!              /*   skip if the place is not covered by meshes   */
               if ( ( ix .gt. nx_cube ) .or. ( ix .le. 0 ) ) cycle
               if ( ( iy .gt. ny_cube ) .or. ( iy .le. 0 ) ) cycle
               if ( ( iz .gt. nz_cube ) .or. ( iz .le. 0 ) ) cycle

!              /*   for species ics, calculate the density   */
               if ( ikind(i) .eq. ics ) then
                  denscube(ix,iy,iz,m) = denscube(ix,iy,iz,m) + 1.d0
               end if

            end do

         end do

         if ( iconf .eq. nconf ) then

!           /*   divide by number of confs and number of beads   */
            denscube(:,:,:,m) = denscube(:,:,:,m) / nbead / iconf_calc

            denstot_cube = 0.d0

            do i = 1, nx_cube
            do j = 1, ny_cube
            do k = 1, nz_cube
               denstot_cube = denstot_cube + denscube(i,j,k,m)
            end do
            end do
            end do

            write( iounit_cube(m), '(a)' ) &
     &      " PIMD CUBE FILE."

            write( iounit_cube(m), '(a,e16.8)' ) &
     &      " OUTER LOOP: X, MIDDLE LOOP: Y, INNER LOOP: Z ", &
     &      denstot_cube

            write( iounit_cube(m), '(i5,3e16.8)' ) &
     &         3*nbead, xmin_cube, ymin_cube, zmin_cube

            write( iounit_cube(m), '(i5,3e16.8)' ) &
     &         nx_cube, dx_cube, 0.d0, 0.d0

            write( iounit_cube(m), '(i5,3e16.8)' ) &
     &         ny_cube, 0.d0, dy_cube, 0.d0

            write( iounit_cube(m), '(i5,3e16.8)' ) &
     &         nz_cube, 0.d0, 0.d0, dz_cube

            do i = 1, 3

               if ( i .eq. 1 ) k = i_cube(m)
               if ( i .eq. 2 ) k = j_cube(m)
               if ( i .eq. 3 ) k = k_cube(m)

               xr = 0.d0
               yr = 0.d0
               zr = 0.d0

               do j = 1, nbead
                  xr = xr + pux(k,j)
                  yr = yr + puy(k,j)
                  zr = zr + puz(k,j)
               end do

               xr = xr / nbead
               yr = yr / nbead
               zr = zr / nbead

               write( iounit_cube(m), '(i5,4e16.8)' ) &
     &            1, 0.d0, xr, yr, zr

            end do

            do i = 1, nx_cube
            do j = 1, ny_cube
            do k = 1, nz_cube
               write( iounit_cube(m), '(e16.8)' ) denscube(i,j,k,m)
            end do
            end do
            end do

            write( iounit_cube(m), '(e16.8)' )

         end if

      end do

      return
      end

