!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_angl_spec
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, natom, ikind, &
     &   i_angl_spec, j_angl_spec, k_angl_spec, &
     &   nangl_spec, iounit_angl_spec

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m, l

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, rij2, rkj2, rijk, &
     &           pijk, qijk, bijk

!     /*   real   */
      real(8) :: aijk(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nangl_spec .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do l = 1, nangl_spec

         do i = 1, natom

            if ( ikind(i) .ne. i_angl_spec(l) ) cycle

            do j = i+1, natom

               if ( ikind(j) .ne. j_angl_spec(l) ) cycle

               do k = j+1, natom

                  if ( ikind(k) .ne. k_angl_spec(l) ) cycle

                  do m = 1, nbead

                     xij = x(i,m) - x(j,m)
                     yij = y(i,m) - y(j,m)
                     zij = z(i,m) - z(j,m)

                     call pbc_atom_calc ( xij, yij, zij )

                     xkj = x(k,m) - x(j,m)
                     ykj = y(k,m) - y(j,m)
                     zkj = z(k,m) - z(j,m)

                     call pbc_atom_calc ( xkj, ykj, zkj )

                     rij2 = xij*xij + yij*yij + zij*zij
                     rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

                     rijk = sqrt( rij2*rkj2 )

                     pijk = xij*xkj + yij*ykj + zij*zkj

                     qijk  = pijk/rijk

                     qijk = max( qijk, -1.d0 )
                     qijk = min( qijk,  1.d0 )

                     bijk = acos( qijk )

                     aijk(m) = bijk*(180.d0/pi)

                  end do

                  do m = 1, nbead
                     write( iounit_angl_spec(l), '(f10.5)' ) aijk(m)
                  end do

               end do

            end do

         end do

      end do

      return
      end
