!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_angl_avg_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, counter_angl_avg, value_angl_avg, squar_angl_avg, &
     &   iounit_angl_avg, i_angl_avg, j_angl_avg, k_angl_avg, &
     &   nangl_avg, ncalc, iounit_calc_start

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'angl.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         nangl_avg = l

      close( iounit )

!     /*   go back if not found   */
      if ( nangl_avg .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_angl_avg(nangl_avg) )
      allocate( j_angl_avg(nangl_avg) )
      allocate( k_angl_avg(nangl_avg) )
      allocate( iounit_angl_avg(nangl_avg) )
      allocate( counter_angl_avg(nangl_avg) )
      allocate( value_angl_avg(nangl_avg) )
      allocate( squar_angl_avg(nangl_avg) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:14) .eq. 'angl.atom.avg ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_angl_avg(l), j_angl_avg(l), &
     &            k_angl_avg(l), char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_angl_avg_setup', 30 )

!              /*   file number   */
               iounit_angl_avg(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_angl_avg(l), file = char_file )

!              /*   print   */
               write( 6, '(a,3i5,a)' ) &
     &           'Average angles of atoms ', &
     &            i_angl_avg(l), j_angl_avg(l), k_angl_avg(l), &
     &           ' in ' // trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_angl_avg_setup', 30 )

!-----------------------------------------------------------------------
!     /*   zero clear                                                 */
!-----------------------------------------------------------------------

      counter_angl_avg(:) = 0.d0
      value_angl_avg(:)  = 0.d0
      squar_angl_avg(:)  = 0.d0

      return
      end
