!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_angl_avg
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, iconf, nconf, &
     &   value_angl_avg, squar_angl_avg, counter_angl_avg, &
     &   i_angl_avg, j_angl_avg, k_angl_avg, nangl_avg, iounit_angl_avg

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m, l

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, rij2, rkj2, rijk, &
     &           pijk, qijk, bijk, value_1, value_2, value_3

!     /*   real   */
      real(8) :: aijk(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nangl_avg .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do l = 1, nangl_avg

         i = i_angl_avg(l)
         j = j_angl_avg(l)
         k = k_angl_avg(l)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

            rij2 = xij*xij + yij*yij + zij*zij
            rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

            rijk = sqrt( rij2*rkj2 )

            pijk = xij*xkj + yij*ykj + zij*zkj

            qijk  = pijk/rijk

            qijk = max( qijk, -1.d0 )
            qijk = min( qijk,  1.d0 )

            bijk = acos( qijk )

            aijk(m) = bijk*(180.d0/pi)

            counter_angl_avg(l) = counter_angl_avg(l) + 1.d0

         end do

         do m = 1, nbead
            value_1 = aijk(m)
            value_angl_avg(l) = value_angl_avg(l) + value_1
            squar_angl_avg(l) = squar_angl_avg(l) + value_1*value_1
         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do l = 1, nangl_avg

            value_1 = value_angl_avg(l)/counter_angl_avg(l)
            value_2 = squar_angl_avg(l)/counter_angl_avg(l)
            value_3 = sqrt( value_2 - value_1*value_1 )

            write( iounit_angl_avg(l), '(2f10.5)' ) value_1, value_3

         end do

      end if

      return
      end
