!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_angl_atom_dens
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   pi, x, y, z, nbead, iconf, nconf, &
     &   params_angl_dens, counter_angl_atom_dens, &
     &   density_angl_atom_dens, iounit_angl_atom_dens, nangl_atom_dens, &
     &   i_angl_atom_dens, j_angl_atom_dens, k_angl_atom_dens

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m, l, kk, nmesh

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, rij2, rkj2, rijk, &
     &           pijk, qijk, bijk, xmin, xmax, xmesh, xx, yy

!     /*   real   */
      real(8) :: aijk(nbead)

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nangl_atom_dens .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   minimum, maximum, mesh                                     */
!-----------------------------------------------------------------------

      xmin  = params_angl_dens(1)
      xmax  = params_angl_dens(2)
      xmesh = params_angl_dens(3)

!-----------------------------------------------------------------------
!     /*   number of meshes                                           */
!-----------------------------------------------------------------------

      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do l = 1, nangl_atom_dens

         i = i_angl_atom_dens(l)
         j = j_angl_atom_dens(l)
         k = k_angl_atom_dens(l)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

            rij2 = xij*xij + yij*yij + zij*zij
            rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

            rijk = sqrt( rij2*rkj2 )

            pijk = xij*xkj + yij*ykj + zij*zkj

            qijk  = pijk/rijk

            qijk = max( qijk, -1.d0 )
            qijk = min( qijk,  1.d0 )

            bijk = acos( qijk )

            aijk(m) = bijk*(180.d0/pi)

!           /*   data   */
            xx = aijk(m)

!           /*   mesh point  */
            kk = nint( ( xx - xmin ) / xmesh ) + 1

!           /*   add counts   */
            counter_angl_atom_dens(l) &
     &         = counter_angl_atom_dens(l) + 1.d0

!           /*   out of bounds   */
            if ( ( kk .le. 0 ) .or. ( kk .gt. nmesh ) ) cycle

!           /*   add to density   */
            density_angl_atom_dens(kk,l) &
     &         = density_angl_atom_dens(kk,l) + 1.d0

         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do l = 1, nangl_atom_dens

            if ( counter_angl_atom_dens(l) .eq. 0.d0 ) cycle

            do kk = 1, nmesh

!              /*   mesh point  */
               xx = xmin + (kk-1)*xmesh

!              /*   density normalized to unity   */
               yy = density_angl_atom_dens(kk,l) &
     &            / counter_angl_atom_dens(l) /xmesh

!              /*   print   */
               write( iounit_angl_atom_dens(l), '(2e24.16)' ) xx, yy

            end do

         end do

      end if

      return
      end
