!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_adiff_setup
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   iounit, i_adiff, j_adiff, k_adiff, nadiff, iounit_adiff, &
     &   iounit_calc_start, ncalc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: k, l

      integer :: ierr = 0

      character(len=80) :: char_line, char_file

!-----------------------------------------------------------------------
!     /*   set up                                                     */
!-----------------------------------------------------------------------

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   neglect   */
         if ( ierr .ne. 0 ) then

!           /*   neglect   */
            close ( iounit )

!           /*   neglect   */
            return

!        /*   neglect   */
         end if

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:16) .eq. 'adiff.atom.list ' ) then

!              /*   counter   */
               l = l + 1

            end if

         end do

         nadiff = l

      close( iounit )

!     /*   go back if not found   */
      if ( nadiff .eq. 0 ) return

!     /*   memory allocation   */
      allocate( i_adiff(nadiff) )
      allocate( j_adiff(nadiff) )
      allocate( k_adiff(nadiff) )
      allocate( iounit_adiff(nadiff) )

      open ( iounit, file = 'calc.dat' )

!        /*   tag   */
         call search_tag ( '<ncalc>', 7, iounit, ierr )

!        /*   number of interatomic pairs   */
         read( iounit, *, iostat=ierr ) ncalc

!        /*   counter   */
         l = 0

         do k = 1, ncalc

!           /*   read a line   */
            read( iounit, *, iostat=ierr ) char_line

!           /*   match line   */
            if ( char_line(1:16) .eq. 'adiff.atom.list ' ) then

!              /*   counter   */
               l = l + 1

!              /*   go back one line   */
               backspace( iounit )

!              /*   read atoms   */
               read( iounit, *, iostat=ierr ) &
     &            char_line, i_adiff(l), j_adiff(l), k_adiff(l), &
     &            char_file

!              /*   check error   */
               if ( ierr .ne. 0 ) then
                  write( 6, '(a)' ) 'Error - check format of <ncalc>.'
                  write( 6, '(a)' ) 
               end if

!              /*   error termination   */
               call error_handling_calc &
     &            ( ierr, 'subroutine calc_adiff_setup', 27 )

!              /*   file number   */
               iounit_adiff(l) = iounit_calc_start + (k-1)

!              /*   open file   */
               open ( iounit_adiff(l), file = char_file )

!              /*   print   */
               write( 6, '(a,3i5,a)' ) &
     &           "List of adiff's of atoms ", &
     &            i_adiff(l), j_adiff(l), k_adiff(l), ' in ' // &
     &            trim(char_file) // '.'

            end if

         end do

      close( iounit )

!-----------------------------------------------------------------------
!     /*   error handling                                             */
!-----------------------------------------------------------------------

      call error_handling_calc &
     &   ( ierr, 'subroutine calc_adiff_setup', 27 )

      return
      end
