!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     subroutine for post process
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine calc_adiff_atom_dens
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use calc_variables, only : &
     &   x, y, z, nbead, iconf, nconf, &
     &   params_adiff_dens, density_adiff_atom_dens, &
     &   counter_adiff_atom_dens, i_adiff_atom_dens, &
     &   j_adiff_atom_dens, k_adiff_atom_dens, nadiff_atom_dens, &
     &   iounit_adiff_atom_dens

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   integer   */
      integer :: i, j, k, m, l, kk, nmesh

!     /*   real   */
      real(8) :: xij, yij, zij, xkj, ykj, zkj, rij2, rkj2, rijk, &
     &           rij, rkj, xmin, xmax, xmesh, xx, yy

!-----------------------------------------------------------------------
!     /*   return if no data                                          */
!-----------------------------------------------------------------------

      if ( nadiff_atom_dens .eq. 0 ) return

!-----------------------------------------------------------------------
!     /*   minimum, maximum, mesh                                     */
!-----------------------------------------------------------------------

      xmin  = params_adiff_dens(1)
      xmax  = params_adiff_dens(2)
      xmesh = params_adiff_dens(3)

!-----------------------------------------------------------------------
!     /*   number of meshes                                           */
!-----------------------------------------------------------------------

      nmesh = nint ( ( xmax - xmin ) / xmesh ) + 1

!-----------------------------------------------------------------------
!     /*   main loop                                                  */
!-----------------------------------------------------------------------

      do l = 1, nadiff_atom_dens

         i = i_adiff_atom_dens(l)
         j = j_adiff_atom_dens(l)
         k = k_adiff_atom_dens(l)

         do m = 1, nbead

            xij = x(i,m) - x(j,m)
            yij = y(i,m) - y(j,m)
            zij = z(i,m) - z(j,m)

            call pbc_atom_calc ( xij, yij, zij )

            xkj = x(k,m) - x(j,m)
            ykj = y(k,m) - y(j,m)
            zkj = z(k,m) - z(j,m)

            call pbc_atom_calc ( xkj, ykj, zkj )

            rij2 = xij*xij + yij*yij + zij*zij
            rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

            rij2 = xij*xij + yij*yij + zij*zij
            rkj2 = xkj*xkj + ykj*ykj + zkj*zkj

            rij = sqrt(rij2)
            rkj = sqrt(rkj2)

            rijk = abs( rij - rkj )

!           /*   data   */
            xx = rijk

!           /*   mesh point  */
            kk = nint( ( xx - xmin ) / xmesh ) + 1

!           /*   add counts   */
            counter_adiff_atom_dens(l) &
     &         = counter_adiff_atom_dens(l) + 1.d0

!           /*   out of bounds   */
            if ( ( kk .le. 0 ) .or. ( kk .gt. nmesh ) ) cycle

!           /*   add to density   */
            density_adiff_atom_dens(kk,l) &
     &         = density_adiff_atom_dens(kk,l) + 1.d0

         end do

      end do

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( iconf .eq. nconf ) then

         do l = 1, nadiff_atom_dens

            if ( counter_adiff_atom_dens(l) .eq. 0.d0 ) cycle

            do kk = 1, nmesh

!              /*   mesh point  */
               xx = xmin + (kk-1)*xmesh

!              /*   density normalized to unity   */
               yy = density_adiff_atom_dens(kk,l) &
     &            / counter_adiff_atom_dens(l) /xmesh

!              /*   print   */
               write( iounit_adiff_atom_dens(l), '(2e24.16)' ) xx, yy

            end do

         end do

      end if

      return
      end
