!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     backup in replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine backup_rehmc_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_rehmc_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_rehmc_MPI ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end





!***********************************************************************
      subroutine backup_rehmc_npt_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_rehmc_npt_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_rehmc_npt_MPI ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end





!***********************************************************************
      subroutine backup_remc_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_remc_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_remc_MPI( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end
