!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     polymers backup
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine backup_polymers_atom_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

      use polymers_variables, only : &
     &   jpoly

      implicit none

      character(len=30) :: filename
      character(len=3)  :: char_num

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

!     /*   write to each directory   */
      call restart_polymers_atom_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         call int3_to_char( jpoly, char_num )
         filename = 'poly.' // char_num // '/step.ini'

         open ( iounit, file = filename, status = 'unknown' )
         write ( iounit, '(i8)' ) istep_end
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_polymers_atom_MPI ( 3 )

      return
      end





!***********************************************************************
      subroutine backup_polymers_cons_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

      use polymers_variables, only : &
     &   jpoly

      implicit none

      character(len=30) :: filename
      character(len=3)  :: char_num

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

!     /*   write to each directory   */
      call restart_polymers_atom_MPI( 2 )

!     /*   write to each directory   */
      call restart_polymers_cons_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then

         call int3_to_char( jpoly, char_num )
         filename = 'poly.' // char_num // '/step.ini'

         open ( iounit, file = filename, status = 'unknown' )
         write ( iounit, '(i8)' ) istep_end
         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_polymers_cons_MPI ( 3 )

      return
      end
