!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     backup in path integral molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine backup_pimd_nve
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_nvt_nhc
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_bath_nhc( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_nvt_nhcs
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_bath_nhcs( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_nvt_mnhc
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_bath_mnhc( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_nph
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_box( 4 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_nth
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_box( 4 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_npt
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_bath_mnhc( 2 )
      call restart_box( 4 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pimd_ntt
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )
      call restart_bath_mnhc( 2 )
      call restart_box( 4 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end





!***********************************************************************
      subroutine backup_pibcmd
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   hamiltonian_cor, istep_end, nstep, iexit, iprint_rest, iounit

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_position( 3 )
      call restart_velocity( 3 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      open ( iounit, file = 'step.ini' )
         write ( iounit, '(i8)' ) istep_end
         write ( iounit, '(d24.16)' ) hamiltonian_cor
      close( iounit )

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz

      return
      end
