!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     backup in molecular dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine backup_md_nve_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, iprint_rest, iounit, nstep, myrank

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( mod(istep_end,iprint_rest) .eq. 0 ) then
         if ( iprint_rest .le. 0 ) then
            return
         else
            continue
         end if
      else if ( istep_end .eq. nstep ) then
         continue
      else
         return
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

!     /*   system position   */
      call restart_position_MPI( 4 )

!     /*   system velocity   */
      call restart_velocity_MPI( 4 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then
         open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
         close( iounit )
      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_cart_MPI ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end





!***********************************************************************
      subroutine backup_md_nvt_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, iprint_rest, iounit, nstep, myrank

      implicit none

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( mod(istep_end,iprint_rest) .eq. 0 ) then
         if ( iprint_rest .le. 0 ) then
            return
         else
            continue
         end if
      else if ( istep_end .eq. nstep ) then
         continue
      else
         return
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

!     /*   system position   */
      call restart_position_MPI( 4 )

!     /*   system velocity   */
      call restart_velocity_MPI( 4 )

!     /*   thermostat position and velocity   */
!     call restart_bath_cart_MPI( 2 )

!     /*   REVISED: thermostat position and velocity   */
      call restart_bath_cart_revised_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then
         open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
         close( iounit )
      end if

!-----------------------------------------------------------------------
!     /*   save averages                                              */
!-----------------------------------------------------------------------

      call analysis_cart_MPI ( 3 )

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end

