!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     backup in geometry optimization
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine backup_geoopt_MPI
!***********************************************************************
!=======================================================================
!
!     finalize the calculation.
!
!=======================================================================

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   istep_end, nstep, iexit, iprint_rest, iounit, myrank

      use lbfgs_variables, only : &
     &   iflag

      use cons_variables, only : &
     &   fc_cons, gc_cons, ncons, iter_cons

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i

!-----------------------------------------------------------------------
!     /*   conditions                                                 */
!-----------------------------------------------------------------------

      if ( istep_end .eq. nstep ) then
         continue
      else if ( iexit .eq. 1 ) then
         continue
      else if ( iflag .ne. 0 ) then
         continue
      else
         if ( iprint_rest .le. 0 ) then
            return
         else
            if ( mod(istep_end,iprint_rest) .eq. 0 ) then
               continue
            else
               return
            end if
         end if
      end if

!-----------------------------------------------------------------------
!     /*   write out restart file                                     */
!-----------------------------------------------------------------------

      call restart_cartesian_MPI( 2 )

!-----------------------------------------------------------------------
!     /*   in `step.ini', print the step number for restart           */
!-----------------------------------------------------------------------

      if ( myrank .eq. 0 ) then
         if ( ncons .le. 0 ) then
            open ( iounit, file = 'step.ini' )
            write ( iounit, '(i8)' ) istep_end
            close( iounit )
         else
            open ( iounit, file = 'step.ini' )
            write ( iounit, '(2i8)' ) istep_end, iter_cons
            do i = 1, ncons
               write( iounit, '(2e24.16)' ) fc_cons(i), gc_cons(i)
            end do
            close( iounit )
         end if
      end if

!-----------------------------------------------------------------------
!     /*   print final geometry                                       */
!-----------------------------------------------------------------------

      call print_final_xyz_MPI

      return
      end

