!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     analysis in string method
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_string( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &   iounit

      use analysis_variables, only : &
     &   iprint_trj, iprint_xyz, iprint_xsf, iprint_str, iprint_dcd

!     /*   local variables   */

      implicit none

      integer :: ioption

!-----------------------------------------------------------------------
!     /*   step intervals of analysis                                 */
!-----------------------------------------------------------------------

      if      ( ioption .eq. 0 ) then

         call read_int1 ( iprint_trj,  '<iprint_trj>',  12, iounit )
         call read_int1 ( iprint_xyz,  '<iprint_xyz>',  12, iounit )
         call read_int1 ( iprint_xsf,  '<iprint_xsf>',  12, iounit )
         call read_int1 ( iprint_dcd,  '<iprint_dcd>',  12, iounit )
         call read_int1 ( iprint_str,  '<iprint_str>',  12, iounit )

         call analysis_trj  ( 0 )
         call analysis_xyz  ( 0 )
         call analysis_xsf  ( 0 )
         call analysis_dcd  ( 0 )
         call analysis_string_pot( 0 )
         call analysis_string_xyz( 0 )
         call analysis_string_xsf( 0 )

      else if ( ioption .eq. 1 ) then

         call read_int1 ( iprint_trj,  '<iprint_trj>',  12, iounit )
         call read_int1 ( iprint_xyz,  '<iprint_xyz>',  12, iounit )
         call read_int1 ( iprint_xsf,  '<iprint_xsf>',  12, iounit )
         call read_int1 ( iprint_dcd,  '<iprint_dcd>',  12, iounit )
         call read_int1 ( iprint_str,  '<iprint_str>',  12, iounit )

         call analysis_trj  ( 1 )
         call analysis_xyz  ( 1 )
         call analysis_xsf  ( 1 )
         call analysis_dcd  ( 1 )
         call analysis_string_pot ( 1 )
         call analysis_string_xyz ( 1 )
         call analysis_string_xsf ( 1 )

      else if ( ioption .eq. 2 ) then

         call analysis_trj  ( 2 )
         call analysis_xyz  ( 2 )
         call analysis_xsf  ( 2 )
         call analysis_dcd  ( 2 )
         call analysis_string_pot ( 2 )
         call analysis_string_xyz ( 2 )
         call analysis_string_xsf ( 2 )

      else if ( ioption .eq. 3 ) then

         call analysis_trj  ( 3 )
         call analysis_xyz  ( 3 )
         call analysis_xsf  ( 3 )
         call analysis_dcd  ( 3 )
         call analysis_string_pot ( 3 )
         call analysis_string_xyz ( 3 )
         call analysis_string_xsf ( 3 )

      end if

      return
      end





!***********************************************************************
      subroutine analysis_string_pot( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &    pot, nbead, iounit, istep, species, natom, au_length

      use string_variables, only : &
     &    rc_arc, pot_arc, ngrid_string, narc

      use string_variables, only : &
     &    xmax_string, ymax_string, zmax_string, dmax_string, &
     &    pot_string_max, i_string_max

      use analysis_variables, only : &
     &   iprint_str

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      integer :: i, j, k, ioption

!     /*   real   */
      real(8) :: xa, ya, za

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return by option                                           */
!-----------------------------------------------------------------------

      if ( iprint_str .le. 0 ) return
      if ( mod(istep,iprint_str) .ne. 0 ) return
      if ( ioption .le. -1 ) return

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( ioption .ne. 3 ) then

         open( iounit, file = 'string.out', access = 'append' )

         do j = 1, nbead

            k = (j-1)*(ngrid_string-1) + 1

            write( iounit, '(2i8,2f16.8)' ) &
     &        istep, j, rc_arc(k), pot(j)

         end do

         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         open( iounit, file = 'string_final.out' )

         do k = 1, narc

            write( iounit, '(2i8,2f16.8)' ) &
     &         istep, k, rc_arc(k), pot_arc(k)

         end do

         close( iounit )

      end if

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      if ( ioption .le. 3 ) then

         open( iounit, file = 'string_max.xyz' )

         write( iounit, '(i8)' ) natom
         write( iounit, '(2i8,f16.8)' ) &
     &      istep, i_string_max, pot_string_max

         do i = 1, natom

            xa = xmax_string(i) * bohr2ang
            ya = ymax_string(i) * bohr2ang
            za = zmax_string(i) * bohr2ang

            write( iounit, '(a4,3f24.16)' ) species(i)(1:4), xa, ya, za

         end do

         close( iounit )

      end if

      if ( ioption .le. 3 ) then

         open( iounit, file = 'eigen_max.out' )

         write( iounit, '(e24.16)' ) 0.d0

         do i = 1, 3*natom, 3
            write( iounit, '(3e24.16)' ) dmax_string(i:i+2)
         end do

         close( iounit )

      end if

      return
      end





!***********************************************************************
      subroutine analysis_string_xyz( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   variables                                                  */
!-----------------------------------------------------------------------

!     /*   shared variables   */

      use common_variables, only : &
     &    x, y, z, au_length, pot, &
     &    natom, istep, nbead, iounit, species

      use analysis_variables, only : &
     &   iprint_str

!     /*   local variables   */
      implicit none

!     /*   local variables   */
      integer :: i, j, ioption

!     /*   real   */
      real(8) :: xa, ya, za

!     /*   real   */
      real(8), parameter :: bohr2ang = au_length/1.d-10

!-----------------------------------------------------------------------
!     /*   return by option                                           */
!-----------------------------------------------------------------------

      if ( iprint_str .le. 0 ) return
      if ( mod(istep,iprint_str) .ne. 0 ) return
      if ( ioption .le. -1 ) return

!-----------------------------------------------------------------------
!     /*   print                                                      */
!-----------------------------------------------------------------------

      open( iounit, file = 'string.xyz' )

      do j = 1, nbead

         write( iounit, '(i8)' ) natom
         write( iounit, '(2i8,f16.8)' ) istep, j, pot(j)

         do i = 1, natom

            xa = x(i,j) * bohr2ang
            ya = y(i,j) * bohr2ang
            za = z(i,j) * bohr2ang

            write( iounit, '(a4,3f24.16)' ) species(i)(1:4), xa, ya, za

         end do

      end do

      close( iounit )

      return
      end





!***********************************************************************
      subroutine analysis_string_xsf( ioption )
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   x, y, z, au_charge, au_energy, au_length, box, species, &
     &   pot, fx, fy, fz, istep, natom, nbead, iounit, iboundary, &
     &   istep

      use analysis_variables, only : &
     &   iprint_str

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     /*   initialize   */
      implicit none

!     /*   integers   */
      integer :: i, j, ioption

!     /*   real numbers   */
      real(8) :: xa, ya, za, ax, ay, az, bx, by, bz, cx, cy, cz

!     /*   real numbers   */
      real(8) :: const_1, const_2, const_3

!     /*   potential and force   */
      real(8) :: pot_ev, fxj, fyj, fzj

!-----------------------------------------------------------------------
!     /*   print condition: every iprint_xsf steps                    */
!-----------------------------------------------------------------------

      if ( iprint_str .le. 0 ) return
      if ( mod(istep,iprint_str) .ne. 0 ) return
      if ( ioption .le. -1 ) return

!-----------------------------------------------------------------------
!     /*   print xsf file                                             */
!-----------------------------------------------------------------------

!     /*   conversion factor   */
      const_1 = au_length * 1.d+10

!     /*   conversion factor   */
      const_2 =  au_charge / au_energy

!     /*   conversion factor   */
      const_3 =  1.d0 / const_2 / const_1

!     /*   open sample file   */
      open( iounit, file = 'string.xsf' )

!     /*   write header   */
      write( iounit, '(a)' ) 'ANIMSTEPS 99999999'

!     /*   loop of beads   */
      do j = 1, nbead

!        /*   potential energy in eV   */
         pot_ev = pot(j) / const_2

!        /*   write one line   */
         write( iounit, '(a,f24.12,a)' ) &
     &      '# total energy = ', pot_ev, ' eV'

!     /*   loop of beads   */
      end do

!     /*   for periodic boundary condition   */
      if ( (iboundary .eq. 1) .or. (iboundary .eq. 2) ) then

!        /*   write one line   */
         write( iounit, '(a)' ) 'CRYSTAL'

!        /*   write one line   */
         write( iounit, '(a,i8)' ) 'PRIMVEC ', istep

!        /*   lattice vectors   */
         ax = box(1,1) * const_1
         ay = box(2,1) * const_1
         az = box(3,1) * const_1
         bx = box(1,2) * const_1
         by = box(2,2) * const_1
         bz = box(3,2) * const_1
         cx = box(1,3) * const_1
         cy = box(2,3) * const_1
         cz = box(3,3) * const_1

!        /*   write three lines   */
         write( iounit, '(3f16.8)' ) ax, ay, az
         write( iounit, '(3f16.8)' ) bx, by, bz
         write( iounit, '(3f16.8)' ) cx, cy, cz

!        /*   write one line   */
         write( iounit, '(a,i8)' ) 'PRIMCOORD ', istep

!        /*   write one line   */
         write( iounit, '(i8,i2)' ) natom*nbead, 1

!     /*   for free boundary condition   */
      else if ( iboundary .eq. 0 ) then

!        /*   write one line   */
         write( iounit, '(a,i8)' ) 'ATOMS ', istep

!     /*   for free or periodic boundary condition   */
      end if

!     /*   loop of beads   */
      do j = 1, nbead

!        /*   loop of atoms   */
         do i = 1, natom

!           /*   geometry in angstroms   */
            xa = x(i,j) * const_1
            ya = y(i,j) * const_1
            za = z(i,j) * const_1

!           /*   geometry in eV per angstrom   */
            fxj = fx(i,j) * const_3 * dble(nbead)
            fyj = fy(i,j) * const_3 * dble(nbead)
            fzj = fz(i,j) * const_3 * dble(nbead)

!           /*   write one line   */
            write( iounit, '(a4,6f16.8)' ) &
     &         species(i)(1:4), xa, ya, za, fxj, fyj, fzj

!        /*   loop of atoms   */
         end do

!     /*   loop of beads   */
      end do

!     /*   close input file   */
      close( iounit )

      return
      end
