!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     backup in replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_remc_MPI ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit_avg, iounit, method, myrank

      use analysis_variables, only : &
     &   iprint_xyz

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: itest, ioption

!-----------------------------------------------------------------------
!     /*   ioption = 1:  initialize/restart                           */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

!-----------------------------------------------------------------------
!        /*   step intervals of analysis                              */
!-----------------------------------------------------------------------

         call read_int1_MPI( iprint_xyz,  '<iprint_xyz>',  12, iounit )

!-----------------------------------------------------------------------
!        /*   check if file called `averages.ini' exists              */
!-----------------------------------------------------------------------

         if ( myrank .eq. 0 ) then
            call testfile ( 'averages.ini', 12, itest )
         end if

         call my_mpi_bcast_int_0( itest )

!-----------------------------------------------------------------------
!        /*   if the file does not exist, initial start.              */
!-----------------------------------------------------------------------

         if ( itest .eq. 1 ) then

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc_MPI( 0 )
            end if

            call analysis_ratio_remc_MPI( 0 )

#if defined(aenet2) || defined(aenet_pytorch)
            call analysis_aenet_MPI( 0 )
#endif

#ifdef n2p2
            call analysis_n2p2_MPI( 0 )
#endif

!-----------------------------------------------------------------------
!        /*   if the file exists, restart.                            */
!-----------------------------------------------------------------------

         else

            if ( myrank .eq. 0 ) then
               open ( iounit_avg, file = 'averages.ini' )
            end if

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc_MPI( 1 )
            end if

            call analysis_ratio_remc_MPI( 1 )

#if defined(aenet2) || defined(aenet_pytorch)
            call analysis_aenet_MPI( 1 )
#endif

#ifdef n2p2
            call analysis_n2p2_MPI( 1 )
#endif

            if ( myrank .eq. 0 ) then
               close( iounit_avg )
            end if

         end if

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  start analysis                               */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc_MPI( 2 )
            end if

            call analysis_ratio_remc_MPI( 2 )

#if defined(aenet2) || defined(aenet_pytorch)
            call analysis_aenet_MPI( 2 )
#endif

#ifdef n2p2
            call analysis_n2p2_MPI( 2 )
#endif

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

            if ( myrank .eq. 0 ) then
               open ( iounit_avg, file = 'averages.ini' )
            end if

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc_MPI( 3 )
            end if

            call analysis_ratio_remc_MPI( 3 )

#if defined(aenet2) || defined(aenet_pytorch)
            call analysis_aenet_MPI( 3 )
#endif

#ifdef n2p2
            call analysis_n2p2_MPI( 3 )
#endif

            if ( myrank .eq. 0 ) then
               close( iounit_avg )
            end if

      end if

      return
      end





!***********************************************************************
      subroutine analysis_ratio_remc_MPI ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit_avg, myrank

      use rehmc_variables, only : &
     &   ratio_mc, ratio_mc_sub, naccept_mc, naccept_mc_sub, &
     &   nreject_mc, nreject_mc_sub

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, ierr

!-----------------------------------------------------------------------
!     /*   ioption = 0:  initialize                                   */
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 1:  restart                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         if ( myrank .eq. 0 ) then

            read ( iounit_avg, *, iostat=ierr ) naccept_mc
            read ( iounit_avg, *, iostat=ierr ) nreject_mc
            read ( iounit_avg, *, iostat=ierr ) ratio_mc

            read ( iounit_avg, *, iostat=ierr ) naccept_mc_sub
            read ( iounit_avg, *, iostat=ierr ) nreject_mc_sub
            read ( iounit_avg, *, iostat=ierr ) ratio_mc_sub

         end if

         call my_mpi_bcast_int_0 ( ierr )

         call error_handling_MPI &
     &      ( ierr, 'subroutine analysis_ratio_remc_MPI', 34 )

         call my_mpi_bcast_int_0 ( naccept_mc )
         call my_mpi_bcast_int_0 ( nreject_mc )
         call my_mpi_bcast_real_0( ratio_mc )

         call my_mpi_bcast_int_0 ( naccept_mc_sub )
         call my_mpi_bcast_int_0 ( nreject_mc_sub )
         call my_mpi_bcast_real_0( ratio_mc_sub )

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  calculate and print out data                 */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         if ( myrank .eq. 0 ) then

            write( iounit_avg, '(i8)' )     naccept_mc
            write( iounit_avg, '(i8)' )     nreject_mc
            write( iounit_avg, '(e24.16)' ) ratio_mc

            write( iounit_avg, '(i8)' )     naccept_mc_sub
            write( iounit_avg, '(i8)' )     nreject_mc_sub
            write( iounit_avg, '(e24.16)' ) ratio_mc_sub

         end if

      end if

      return
      end
