!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Apr 24, 2022 by M. Shiga
!      Description:     backup in replica exchange hybrid Monte Carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_remc ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit_avg, iounit, method

      use analysis_variables, only : &
     &   iprint_xyz

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: itest, ioption

!-----------------------------------------------------------------------
!     /*   ioption = 1:  initialize/restart                           */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

!-----------------------------------------------------------------------
!        /*   step intervals of analysis                              */
!-----------------------------------------------------------------------

         call read_int1 ( iprint_xyz,  '<iprint_xyz>',  12, iounit )

!-----------------------------------------------------------------------
!        /*   check if file called `averages.ini' exists              */
!-----------------------------------------------------------------------

         call testfile ( 'averages.ini', 12, itest )

!-----------------------------------------------------------------------
!        /*   if the file does not exist, initial start.              */
!-----------------------------------------------------------------------

         if ( itest .eq. 1 ) then

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc( 0 )
            end if

            call analysis_ratio_remc( 0 )

!#ifdef aenet2
!            call analysis_aenet( 0 )
!#endif

!-----------------------------------------------------------------------
!        /*   if the file exists, restart.                            */
!-----------------------------------------------------------------------

         else

            open ( iounit_avg, file = 'averages.ini' )

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc( 1 )
            end if

            call analysis_ratio_remc( 1 )

!#ifdef aenet2
!            call analysis_aenet( 1 )
!#endif

            close( iounit_avg )

         end if

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  start analysis                               */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc( 2 )
            end if

            call analysis_ratio_remc( 2 )

!#ifdef aenet2
!            call analysis_aenet( 2 )
!#endif

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         open ( iounit_avg, file = 'averages.ini' )

            if ( method(1:5) .eq.'REMC ' ) then
               call analysis_xyz_rehmc( 3 )
            end if

            call analysis_ratio_remc( 3 )

!#ifdef aenet2
!            call analysis_aenet( 3 )
!#endif

         close( iounit_avg )

      end if

      return
      end





!***********************************************************************
      subroutine analysis_ratio_remc ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit_avg

      use rehmc_variables, only : &
     &   ratio_mc, ratio_mc_sub, naccept_mc, naccept_mc_sub, &
     &   nreject_mc, nreject_mc_sub

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption, ierr

!-----------------------------------------------------------------------
!     /*   ioption = 0:  initialize                                   */
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 1:  restart                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         read ( iounit_avg, *, iostat=ierr ) naccept_mc
         read ( iounit_avg, *, iostat=ierr ) nreject_mc
         read ( iounit_avg, *, iostat=ierr ) ratio_mc

         read ( iounit_avg, *, iostat=ierr ) naccept_mc_sub
         read ( iounit_avg, *, iostat=ierr ) nreject_mc_sub
         read ( iounit_avg, *, iostat=ierr ) ratio_mc_sub

         call error_handling &
     &      ( ierr, 'subroutine analysis_ratio_remc', 30 )

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  calculate and print out data                 */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         write( iounit_avg, '(i8)' )     naccept_mc
         write( iounit_avg, '(i8)' )     nreject_mc
         write( iounit_avg, '(e24.16)' ) ratio_mc

         write( iounit_avg, '(i8)' )     naccept_mc_sub
         write( iounit_avg, '(i8)' )     nreject_mc_sub
         write( iounit_avg, '(e24.16)' ) ratio_mc_sub

      end if

      return
      end
