!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Dec 18, 2020 by M. Shiga
!      Description:     acceptance ratio in hybrid monte carlo
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_ratio_hmc_MPI ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   myrank, iounit_avg

      use hmc_variables, only : &
     &   ratio, naccept, nreject

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: ioption

!-----------------------------------------------------------------------
!     /*   ioption = 0:  initialize                                   */
!-----------------------------------------------------------------------

      if ( ioption .eq. 0 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 1:  restart                                      */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

         if ( myrank .eq. 0 ) then

            read ( iounit_avg, * ) naccept
            read ( iounit_avg, * ) nreject
            read ( iounit_avg, * ) ratio

         end if

         call my_mpi_bcast_int_0 ( naccept )
         call my_mpi_bcast_int_0 ( nreject )
         call my_mpi_bcast_real_0 ( ratio )

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  calculate and print out data                 */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         continue

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         if ( myrank .eq. 0 ) then

            write( iounit_avg, '(i8)' )     naccept
            write( iounit_avg, '(i8)' )     nreject
            write( iounit_avg, '(e24.16)' ) ratio

         end if

      end if

      return
      end

