!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     analysis in mean field Ehrenfest dynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_mfe_MPI ( ioption )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   iounit, myrank, iounit_avg

      use analysis_variables, only : &
     &   iprint_trj, iprint_xyz, iprint_xsf, iprint_dcd

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: itest, ioption

!-----------------------------------------------------------------------
!     /*   ioption = 1:  initialize/restart                           */
!-----------------------------------------------------------------------

      if ( ioption .eq. 1 ) then

!-----------------------------------------------------------------------
!        /*   step intervals of analysis                              */
!-----------------------------------------------------------------------

         call read_int1_MPI ( iprint_trj,  '<iprint_trj>',  12, iounit )
         call read_int1_MPI ( iprint_xyz,  '<iprint_xyz>',  12, iounit )
         call read_int1_MPI ( iprint_xsf,  '<iprint_xsf>',  12, iounit )
         call read_int1_MPI ( iprint_dcd,  '<iprint_dcd>',  12, iounit )

!-----------------------------------------------------------------------
!        /*   check if file called `averages.ini' exists              */
!-----------------------------------------------------------------------

         if ( myrank .eq. 0 ) then
            call testfile ( 'averages.ini', 12, itest )
         end if

!        /*   MPI communication   */
         call my_mpi_bcast_int_0 ( itest )

!-----------------------------------------------------------------------
!        /*   if the file does not exist, initial start.              */
!-----------------------------------------------------------------------

         if ( itest .eq. 1 ) then

             call analysis_trj_MPI  ( 0 )
             call analysis_xyz_MPI  ( 0 )
             call analysis_xsf_MPI  ( 0 )
             call analysis_dcd_MPI  ( 0 )

!-----------------------------------------------------------------------
!        /*   if the file exists, restart.                            */
!-----------------------------------------------------------------------

         else

             open ( iounit_avg, file = 'averages.ini' )

             call analysis_trj_MPI  ( 1 )
             call analysis_xyz_MPI  ( 1 )
             call analysis_xsf_MPI  ( 1 )
             call analysis_dcd_MPI  ( 1 )

             close( iounit_avg )

         end if

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 2:  start analysis                               */
!-----------------------------------------------------------------------

      if ( ioption .eq. 2 ) then

         call analysis_trj_MPI  ( 2 )
         call analysis_xyz_MPI  ( 2 )
         call analysis_xsf_MPI  ( 2 )
         call analysis_dcd_MPI  ( 2 )

      end if

!-----------------------------------------------------------------------
!     /*   ioption = 3:  finalize                                     */
!-----------------------------------------------------------------------

      if ( ioption .eq. 3 ) then

         open ( iounit_avg, file = 'averages.ini' )

         call analysis_trj_MPI  ( 3 )
         call analysis_xyz_MPI  ( 3 )
         call analysis_xsf_MPI  ( 3 )
         call analysis_dcd_MPI  ( 3 )

         close( iounit_avg )

      end if

      return
      end

