!///////////////////////////////////////////////////////////////////////
!
!      Author:          B. Thomsen, M. Shiga
!      Last updated:    Mar 2, 2022 by M. Shiga
!      Description:     dcd output
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine analysis_dcd_XMPI( ioption )
!***********************************************************************
!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   au_length, istep, istep, pi, myrank, &
     &   x, y, z, vx, vy, vz, fx, fy, fz

      use analysis_variables, only : &
     &   iprint_dcd

     use XMPI_variables, only : positions_sync, velocities_sync, & 
     &                           forces_sync

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

!     /*   initialize   */
      implicit none

!     /*   integers   */
      integer :: ioption

!-----------------------------------------------------------------------
!     /*   print condition: every iprint_dcd steps                    */
!-----------------------------------------------------------------------

      if ( iprint_dcd .le. 0 ) return
      if ( ioption .eq. 3 ) return
      if ( mod(istep,iprint_dcd) .ne. 0 ) return

!-----------------------------------------------------------------------
!     /*   Collect the things to be output to myrank = 0              */
!-----------------------------------------------------------------------

      if ( .not. positions_sync ) then
            call my_mpi_bcast_xyz_XMPI  ( x, y, z, 4 )
            positions_sync  = .true.
      endif

      if ( .not. velocities_sync ) then
            call my_mpi_bcast_xyz_XMPI  ( vx, vy, vz, 1 )
            call my_mpi_bcast_xyz_XMPI  ( vx, vy, vz, 4 )
            velocities_sync = .true.
      endif

      if ( .not. forces_sync ) then
            call my_mpi_bcast_xyz_XMPI  ( fx, fy, fz, 1 )
            call my_mpi_bcast_xyz_XMPI  ( fx, fy, fz, 4 )
            forces_sync     = .true.
      endif

!-----------------------------------------------------------------------
!     /* Call the standard MPI method once we have synced everything  */
!-----------------------------------------------------------------------
      
      if ( myrank .ne. 0 ) return

      call analysis_dcd_MPI( ioption )

      return
      end
