!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     align string with equal bead separation
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine align_string
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &    x, y, z, fictmass, natom, nbead

      use string_variables, only : &
     &    arc_ref, narc

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

!     /*   arc length   */
      real(8) :: arc

!     /*   paramter s from reactant (0) to product (1)   */
      real(8) :: s

!     /*   mass weighted coordinates   */
      real(8), dimension(3*natom) :: r1, r2

!     /*   integers   */
      integer :: i, j, k

!     /*   real numbers   */
      real(8) :: dx, dy, dz, factor, sum

!-----------------------------------------------------------------------
!     /*   initialize spline - s:r                                    */
!-----------------------------------------------------------------------

      call spline_init_crd_string

!-----------------------------------------------------------------------
!     /*   calculate arc length                                       */
!-----------------------------------------------------------------------

!     /*   arc length at the reactant is zero   */
      arc_ref(1,1) = 0.d0

!     /*   parameter s at the reactant is zero  */
      s = 0.d0

!     /*   get old mass weighted coordinates   */
      call spline_crd_string( r1, s )

!     /*   scan from the reactant to the product   */
      do j = 2, narc

!        /*   parameter s   */
         s = dble(j-1) / dble(narc-1)

!        /*   get new mass weighted coordinates   */
         call spline_crd_string( r2, s )

!        /*   calculate arc length by linear approximation   */

         k = 0

         sum = 0.d0

         do i = 1, natom

            k = k + 1

            dx = r2(k) - r1(k)

            k = k + 1

            dy = r2(k) - r1(k)

            k = k + 1

            dz = r2(k) - r1(k)

            sum = sum + dx*dx + dy*dy + dz*dz

         end do

!        /*   accumulate arc length from the reactant   */
         arc_ref(j,1) = arc_ref(j-1,1) + sqrt(sum)

!        /*   save old mass weighted coordinates */
         r1(:) = r2(:)

      end do

!-----------------------------------------------------------------------
!     /*   initialize spline - arc:s                                  */
!-----------------------------------------------------------------------

      call spline_init_arc_string

!-----------------------------------------------------------------------
!     /*   redistribute beads                                         */
!-----------------------------------------------------------------------

      do j = 2, nbead-1

!        /*  uniform distribution of arc length from the reactant   */
         arc = arc_ref(narc,1) * dble(j-1) / dble(nbead-1)

!        /*   get parameter s  */
         call spline_arc_string( s, arc )

!        /*   get mass weighted coordinates  */
         call spline_crd_string( r1, s )

!        /*   cartesian coordinates  */

         k = 0

         do i = 1, natom

            factor = 1.d0 / sqrt( fictmass(i,1) )

            k = k + 1

            x(i,j) = r1(k) * factor

            k = k + 1

            y(i,j) = r1(k) * factor

            k = k + 1

            z(i,j) = r1(k) * factor

         end do

      end do

      return
      end
