!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     add hills in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine addhills_tass
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, boltz, nbead, iounit, istep

      use tass_variables, only : &
     &   rtass, gw_meta, time_tass_save, &
     &   gc_meta, gw_meta_save, gh_meta, gh_meta_save, gc_meta_save, &
     &   ntass, ng_meta, iprint_hills_tass

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j

      real(8) :: time_current, time_elapsed

!-----------------------------------------------------------------------
!     /*   start loop of beads                                        */
!-----------------------------------------------------------------------

      do j = 1, nbead

!-----------------------------------------------------------------------
!        /*    time                                                   */
!-----------------------------------------------------------------------

!        /*   current time   */
         time_current = dble(istep) * dt

!        /*   elapsed time   */
         time_elapsed = time_current - time_tass_save(j)

!-----------------------------------------------------------------------
!        /*   add new gaussian periodically                           */
!-----------------------------------------------------------------------

!        /*   time is not long enough   */
         if ( mod(istep,iprint_hills_tass) .ne. 0 ) cycle

!-----------------------------------------------------------------------
!        /*   add gaussian                                            */
!-----------------------------------------------------------------------

!        /*   increase the number of gaussians   */
         ng_meta = ng_meta + 1

         do i = 1, ntass

!           /*   gaussian center   */
            gc_meta(i,ng_meta) =  rtass(i,j)

!           /*   last gaussian center   */
            gc_meta_save(i,j)  =  rtass(i,j)

!           /*   gaussian width   */
            gw_meta(i,ng_meta) =  gw_meta_save(i)

         end do

!        /*   gaussian height   */
         gh_meta(ng_meta) = gh_meta_save

!        /*   time since last gaussian has been added   */
         time_tass_save(j) = time_current

!-----------------------------------------------------------------------
!        /*   calculated lifted potential                             */
!-----------------------------------------------------------------------

         call getforce_lifted_tass( j )

!-----------------------------------------------------------------------
!        /*   write to file                                           */
!-----------------------------------------------------------------------

         open ( iounit, file = 'hills.ini', status = 'unknown', &
     &          access = 'append' )

            do i = 1, ntass
               write( iounit, '(i8,3e24.16)' ) &
     &            istep, gh_meta(ng_meta), gw_meta(i,ng_meta), &
     &                   gc_meta(i,ng_meta)
            end do

         close( iounit )

!-----------------------------------------------------------------------
!     /*   end loop of beads                                          */
!-----------------------------------------------------------------------

      end do

      return
      end
