!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     add hills in metadynamics
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine addhills_meta
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   shared variables                                           */
!-----------------------------------------------------------------------

      use common_variables, only : &
     &   dt, boltz, nbead, iounit, istep

      use meta_variables, only : &
     &   rmeta, gw_meta, dmeta_max, dmeta, time_meta_save, &
     &   gc_meta, gw_meta_save, gh_meta, gh_meta_save, gc_meta_save, &
     &   params_meta, time_limit_meta, ipbc_meta, &
     &   ioption_meta, nmeta, ng_meta, joption_meta

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      real(8) :: f0, f1, time_current, time_elapsed

      integer, dimension(nbead) :: iflag

!-----------------------------------------------------------------------
!     /*   prescription when two or more beads becomes close          */
!-----------------------------------------------------------------------

!     /*   option  */
      if ( ioption_meta .eq. 0 ) then

!        /*   a flag to add gaussian   */
         iflag(1:nbead) = 1

      else if ( ioption_meta .eq. 1 ) then

!        /*   a flag to add gaussian   */
         iflag(1:nbead) = 1

         do j = 1, nbead
         do k = 1, j-1

            f1 = 0.d0

            do i = 1, nmeta

!              /*   displacement   */
               f0 = rmeta(i,j) - rmeta(i,k)

!              /*   apply periodic boundary condition   */
               call pbc_meta( ipbc_meta(i), f0 )

!              /*   divided by gaussian width   */
               f0 = f0 / gw_meta_save(i)

!              /*   the sum of squares   */
               f1 = f1 + f0*f0

            end do

!           /*   the square root of the sum   */
            f1 = sqrt(f1)

!           /*   if two beads are close, add one gaussian   */

            if ( f1 .lt. dmeta_max ) then
            if ( iflag(j)*iflag(k) .eq. 1 ) then

               iflag(j) = 0
               iflag(k) = 1

            end if
            end if

         end do
         end do

!     /*   option   */
      else

!        /*   a flag to add gaussian   */
         iflag(1:nbead) = 1

!     /*   option   */
      end if

!-----------------------------------------------------------------------
!     /*   start loop of beads                                        */
!-----------------------------------------------------------------------

      do j = 1, nbead

!-----------------------------------------------------------------------
!        /*   displacement from the last gaussian center              */
!-----------------------------------------------------------------------

!        /*   displacement   */
         dmeta(j) = 0.d0

         do i = 1, nmeta

!           /*   difference between cv and gaussian center   */
            f0 = rmeta(i,j) - gc_meta_save(i,j)

!           /*   apply periodic boundary condition   */
            call pbc_meta( ipbc_meta(i), f0 )

!           /*   divided by gaussian width   */
            f0 = f0 / gw_meta_save(i)

!           /*   the sum of squares   */
            dmeta(j) = dmeta(j) + f0*f0

         end do

!        /*   the square root of the sum   */
         dmeta(j) = sqrt(dmeta(j))

!-----------------------------------------------------------------------
!        /*    time                                                   */
!-----------------------------------------------------------------------

!        /*   current time   */
         time_current = istep*dt

!        /*   elapsed time   */
         time_elapsed = time_current - time_meta_save(j)

!-----------------------------------------------------------------------
!        /*   condition 1:  don't add until cv is well displaced      */
!-----------------------------------------------------------------------

!        /*   if displacement exceeds limit, add new gaussian   */
         if ( joption_meta .eq. 0 ) then

!           /*   displacement is not large enough   */
            if ( dmeta(j) .lt. dmeta_max ) cycle

!           /*   time is not long enough   */
            if ( time_elapsed .lt. time_limit_meta ) cycle

!           /*   flag   */
            i = 0

!           /*   loop of cv dimension   */
            do k = 1, nmeta

!              /*   check if cv is out of bounds   */
               if ( rmeta(k,j) .lt. params_meta(1,k) ) i = 1
               if ( rmeta(k,j) .gt. params_meta(2,k) ) i = 1

!           /*   loop of cv dimension   */
            end do

!           /*   cv is out of bounds   */
            if ( i .eq. 1 ) cycle

!        /*   if time exceeds limit, add new gaussian   */
         else

!           /*   time is not long enough   */
            if ( time_elapsed .lt. time_limit_meta ) cycle

!           /*   flag   */
            i = 0

!           /*   loop of cv dimension   */
            do k = 1, nmeta

!              /*   check if cv is out of bounds   */
               if ( rmeta(k,j) .lt. params_meta(1,k) ) i = 1
               if ( rmeta(k,j) .gt. params_meta(2,k) ) i = 1

!           /*   loop of cv dimension   */
            end do

!           /*   cv is out of bounds   */
            if ( i .eq. 1 ) cycle

!        /*   metadynamics option   */
         end if

!-----------------------------------------------------------------------
!        /*   condition 2:  add only one when some beads are near     */
!-----------------------------------------------------------------------

!         if ( iflag(j) .eq. 0 ) cycle

!-----------------------------------------------------------------------
!        /*   add gaussian                                            */
!-----------------------------------------------------------------------

!        /*   increase the number of gaussians   */
         ng_meta = ng_meta + 1

         do i = 1, nmeta

!           /*   gaussian center   */
            gc_meta(i,ng_meta)   =  rmeta(i,j)

!           /*   last gaussian center   */
            gc_meta_save(i,j) =  rmeta(i,j)

!           /*   gaussian width   */
            gw_meta(i,ng_meta)   =  gw_meta_save(i)

         end do

!c        /*   conventional metadynamics   */
!c        if ( dtemp_meta .le. 0.d0 ) then
!c
!c           /*   gaussian height   */
!c            gh_meta(ng_meta) = gh_meta_save
!c
!c        /*   well tempered metadynamics   */
!c         else
!c
!c           /*   gaussian height   */
!c            gh_meta(ng_meta) = gh_meta_save
!c     &                       * exp( - pot_meta(j) / (boltz*dtemp_meta))
!c
!c        /*   metadynamics   */
!c         end if

!        /*   gaussian height   */
         gh_meta(ng_meta) = gh_meta_save

!        /*   time since last gaussian has been added   */
         time_meta_save(j) = time_current

!-----------------------------------------------------------------------
!        /*   calculated lifted potential                             */
!-----------------------------------------------------------------------

         call getforce_lifted_meta

!-----------------------------------------------------------------------
!        /*   write to file                                           */
!-----------------------------------------------------------------------

         open ( iounit, file = 'hills.ini', status = 'unknown', &
     &          access = 'append' )

            do i = 1, nmeta
               write( iounit, '(i8,3e24.16)' ) &
     &            istep, gh_meta(ng_meta), gw_meta(i,ng_meta), &
     &                   gc_meta(i,ng_meta)
            end do

         close( iounit )

!-----------------------------------------------------------------------
!     /*   end loop of beads                                          */
!-----------------------------------------------------------------------

      end do

      return
      end
