!///////////////////////////////////////////////////////////////////////
!
!      Author:          M. Shiga
!      Last updated:    Nov 10, 2018 by M. Shiga
!      Description:     add energy at finite pressure or tension
!
!///////////////////////////////////////////////////////////////////////
!***********************************************************************
      subroutine addebox &
     &   ( pot_pm, pressure, volume, boxinv0, volume0, box, tension )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k, l

      real(8) :: pot_pm, pressure, volume, volume0

      real(8), dimension(3,3) :: boxinv0, gbox, box, strain, tension

!-----------------------------------------------------------------------
!     /*   add pressure contribution                                  */
!-----------------------------------------------------------------------

      pot_pm = pot_pm + pressure * volume

!-----------------------------------------------------------------------
!     /*   add tension contribution                                   */
!-----------------------------------------------------------------------

      gbox(:,:) = 0.d0

      do k = 1, 3
      do j = 1, 3
      do i = 1, 3
         gbox(i,j) = gbox(i,j) + box(k,i)*box(k,j)
      end do
      end do
      end do

      strain(:,:) = 0.d0

      do l = 1, 3
      do k = 1, 3
      do j = 1, 3
      do i = 1, 3

         strain(i,j) = strain(i,j) &
     &               + boxinv0(k,i)*gbox(k,l)*boxinv0(l,j)

      end do
      end do
      end do
      end do

      do i = 1, 3
         strain(i,i) = strain(i,i) - 1.d0
      end do

      strain(:,:) = 0.5d0*strain(:,:)

      do j = 1, 3
      do i = 1, 3
         pot_pm = pot_pm - volume0*tension(i,j)*strain(j,i)
      end do
      end do

      return
      end





!***********************************************************************
      subroutine addfbox &
     &   ( fbox_ref, volume, pressure, boxinv, box, sigma_ref )
!***********************************************************************

!-----------------------------------------------------------------------
!     /*   local variables                                            */
!-----------------------------------------------------------------------

      implicit none

      integer :: i, j, k

      real(8) :: volume, pressure

      real(8), dimension(3,3) :: fbox_ref, boxinv, box, sigma_ref

!-----------------------------------------------------------------------
!     /*   add pressure contribution                                  */
!-----------------------------------------------------------------------

      do j = 1, 3
      do i = 1, 3
         fbox_ref(i,j) = fbox_ref(i,j) &
     &                 - volume * pressure * boxinv(j,i)
      end do
      end do

!-----------------------------------------------------------------------
!     /*   add tension contribution                                   */
!-----------------------------------------------------------------------

      do j = 1, 3
      do i = 1, 3
      do k = 1, 3
         fbox_ref(i,j) = fbox_ref(i,j) &
     &                 - volume * box(i,k) * sigma_ref(k,j)
      end do
      end do
      end do

      return
      end
