! Copyright 2014-2017  Kazuya Ishimura
!
! Licensed under the Apache License, Version 2.0 (the "License");
! you may not use this file except in compliance with the License.
! You may obtain a copy of the License at
!
!     http://www.apache.org/licenses/LICENSE-2.0
!
! Unless required by applicable law or agreed to in writing, software
! distributed under the License is distributed on an "AS IS" BASIS,
! WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
! See the License for the specific language governing permissions and
! limitations under the License.
!
!------------------
  module rysgrid1
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t1(13,0:17)
      real(8) :: w1(13,0:17)
      data t1 / &
&    2.279186929880208D-10,  -2.195481823196802D-09,   3.679383713809136D-09, &
&    5.117300771591971D-08,  -2.548276404038300D-07,  -9.051579470641565D-07, &
&    1.075834418657503D-05,  -2.305358938078053D-06,  -3.420447862583480D-04, &
&    1.128747795400147D-03,   8.465608465608896D-03,  -8.888888888888889D-02, &
&    3.333333333333333D-01,                                                   &
&   -4.686856811415610D-11,   3.467919396629851D-10,  -2.691721149434834D-10, &
&   -1.263346164682310D-08,   9.776071636095614D-08,  -1.487736233230722D-07, &
&   -3.026685879957030D-06,   2.727315153229200D-05,  -6.678817020086858D-05, &
&   -6.776158216879005D-04,   8.593394595266047D-03,  -5.109459500189365D-02, &
&    1.934353258874810D-01,                                                   &
&    3.838421170814386D-12,  -4.574479110537613D-11,   2.555946159848060D-10, &
&   -5.684623226272239D-11,  -1.441243195884084D-08,   1.595830270754984D-07, &
&   -8.936733727173898D-07,   5.022834957601761D-07,   4.668936805054456D-05, &
&   -5.758372760160341D-04,   4.400829826561675D-03,  -2.538314605324223D-02, &
&    1.198089714054326D-01,                                                   &
&    2.332608399129110D-13,   1.182911135164126D-12,  -3.781021279132190D-11, &
&    4.436608883241960D-10,  -3.381183910098854D-09,   1.312284316555469D-08, &
&    8.320390910729327D-08,  -2.307934237211217D-06,   2.837790229286277D-05, &
&   -2.595684974101453D-04,   1.975114498059125D-03,  -1.326972630826195D-02, &
&    8.276209985062410D-02,                                                   &
&   -5.650383428273781D-14,   7.164584044715048D-13,  -6.582303165145776D-12, &
&    4.064688664196605D-11,  -2.960444186944967D-12,  -4.512905419124395D-09, &
&    8.412875355657806D-08,  -1.083163824225574D-06,   1.152864329574831D-05, &
&   -1.083869855581038D-04,   9.385211216504500D-04,  -7.741393710597464D-03, &
&    6.243308064827961D-02,                                                   &
&   -8.131922186758408D-15,   6.717080562039290D-14,  -2.231803792801066D-13, &
&   -4.863657777010276D-12,   1.412005500055078D-10,  -2.420583916648665D-09, &
&    3.354752439900436D-08,  -4.090348221463860D-07,   4.577013296452882D-06, &
&   -4.841451429060693D-05,   4.955145362368544D-04,  -4.991494962022188D-03, &
&    4.999190002631596D-02,                                                   &
&   -4.197924442911641D-16,  -2.582816519553095D-15,   1.503616136916419D-13, &
&   -3.346103322792390D-12,   5.791646722406244D-11,  -8.743136188491876D-10, &
&    1.207025072459011D-08,  -1.568332535165088D-07,   1.959245173766461D-06, &
&   -2.392223607792974D-05,   2.888072020053692D-04,  -3.471179832164732D-03, &
&    4.166566597317281D-02,                                                   &
&    1.072008196405395D-16,  -3.126712711640044D-15,   6.586529607577028D-14, &
&   -1.193941312442543D-12,   1.970075072986534D-11,  -3.049288663140521D-10, &
&    4.518881699121183D-09,  -6.512563906466304D-08,   9.235664175426485D-07, &
&   -1.299201992348029D-05,   1.821483341079211D-04,  -2.550890547274459D-03, &
&    3.571416033137377D-02,                                                   &
&    5.308196043310264D-17,  -1.133940398139931D-15,   2.172898881251120D-14, &
&   -3.916501103607975D-13,   6.737982611819976D-12,  -1.123196879177356D-10, &
&    1.835258353209923D-09,  -2.964483068782113D-08,   4.760802180248837D-07, &
&   -7.626476590779557D-06,   1.220618568268560D-04,  -1.953108631181364D-03, &
&    3.124998412720642D-02,                                                   &
&    1.733027823213374D-17,  -3.577954802688669D-16,   6.976679512947376D-15, &
&   -1.323846582641244D-13,   2.454854476569539D-12,  -4.486715334293080D-11, &
&    8.132994366657628D-10,  -1.468092502887617D-08,   2.645156975361002D-07, &
&   -4.762625315367503D-06,   8.573281078076311D-05,  -1.543207794990744D-03, &
&    2.777777575248349D-02,                                                   &
&    5.321922714906440D-18,  -1.134944869711931D-16,   2.342894057816502D-15, &
&   -4.788216555961111D-14,   9.683780244922331D-13,  -1.946808921782812D-11, &
&    3.901975838340493D-10,  -7.810016063096043D-09,   1.562379495514401D-07, &
&   -3.124953157682667D-06,   6.249986324142532D-05,  -1.249999733471108D-03, &
&    2.499999973997181D-02,                                                   &
&    1.678236577207902D-18,  -3.797364810404312D-17,   8.434242066248719D-16, &
&   -1.870675235259085D-14,   4.131281130060410D-13,  -9.103490846958031D-12, &
&    2.003981647713210D-10,  -4.409636327842587D-09,   9.701741755607982D-08, &
&   -2.134411047531717D-06,   4.695715749113153D-05,  -1.033057816923804D-03, &
&    2.272727269371944D-02,                                                   &
&    5.611538333538890D-19,  -1.362017040963948D-17,   3.270357835849459D-16, &
&   -7.870960068731578D-15,   1.891336339950399D-13,  -4.541327799557719D-12, &
&    1.090093390406455D-10,  -2.616349914024158D-09,   6.279317286359518D-08, &
&   -1.507040122241394D-06,   3.616897921426402D-05,  -8.680555511173571D-04, &
&    2.083333332898571D-02,                                                   &
&    2.009550826540507D-19,  -5.245994374080584D-18,   1.360294994878625D-16, &
&   -3.539963759702726D-15,   9.207273656652874D-14,  -2.394195325323999D-12, &
&    6.225157659674149D-11,  -1.618558927216631D-09,   4.208264233269948D-08, &
&   -1.094149264541502D-06,   2.844788318363259D-05,  -7.396449698380262D-04, &
&    1.923076923020393D-02,                                                   &
&    7.703762543788481D-20,  -2.159702077767448D-18,   6.026255798493995D-17, &
&   -1.687811324460964D-15,   4.726372858888806D-14,  -1.323427768576167D-12, &
&    3.705633269550366D-11,  -1.037579860525503D-09,   2.905225170289184D-08, &
&   -8.134631273765373D-07,   2.277696789181612D-05,  -6.377551019657773D-04, &
&    1.785714285706913D-02,                                                   &
&    3.145733482563022D-20,  -9.439362728525810D-19,   2.822175267399902D-17, &
&   -8.467186089165424D-16,   2.540235422943652D-14,  -7.620767796046737D-13, &
&    2.286235362749455D-11,  -6.858709684938287D-10,   2.057613125672185D-08, &
&   -6.172839489263390D-07,   1.851851851353438D-05,  -5.555555555457560D-04, &
&    1.666666666665703D-02,                                                   &
&    1.359557746584310D-20,  -4.350204266659337D-19,   1.387730716503454D-17, &
&   -4.440834040229933D-16,   1.421081875864121D-14,  -4.547470694859165D-13, &
&    1.455191328817419D-11,  -4.656612758761099D-10,   1.490116113768695D-08, &
&   -4.768371579822714D-07,   1.525878906184827D-05,  -4.882812499987172D-04, &
&    1.562499999999874D-02,                                                   &
&    6.180574650522121D-21,  -2.101037504289909D-19,   7.123559451339366D-18, &
&   -2.422024656031882D-16,   8.234922282519934D-15,  -2.799874799117380D-13, &
&    9.519575300010296D-12,  -3.236655673135150D-10,   1.100462933208903D-08, &
&   -3.741573975118248D-07,   1.272135151629969D-05,  -4.325259515569252D-04, &
&    1.470588235294101D-02/
      data w1 / &
&    5.280965225853330D-11,  -1.007985867531602D-09,   1.299213286539719D-08, &
&   -1.449012437331783D-07,   1.458818539183404D-06,  -1.322746462785431D-05, &
&    1.068375903583238D-04,  -7.575757538251460D-04,   4.629629629081087D-03, &
&   -2.380952380947603D-02,   9.999999999999784D-02,  -3.333333333333333D-01, &
&    1.000000000000000D+00,                                                   &
&    1.345706419534160D-11,  -1.780974974450084D-10,   2.142399185007081D-09, &
&   -2.413594293544825D-08,   2.485626528458103D-07,  -2.320418107689557D-06, &
&    1.945671637177601D-05,  -1.449777467473457D-04,   9.487250092604400D-04, &
&   -5.390782955428558D-03,   2.647140741648749D-02,  -1.157021808561699D-01, &
&    5.981440066613041D-01,                                                   &
&    2.184243192632068D-12,  -2.941258098137492D-11,   3.615051751581291D-10, &
&   -4.178186273785731D-09,   4.441946931020583D-08,  -4.317936553702647D-07, &
&    3.816831637767906D-06,  -3.053074927685022D-05,   2.204868439724179D-04, &
&   -1.444026498372418D-03,   8.762891080996418D-03,  -5.284063206155910D-02, &
&    4.410406953812108D-01,                                                   &
&    3.653691743653942D-13,  -5.033072520253501D-12,   6.365202524398095D-11, &
&   -7.614749068868795D-10,   8.454542730033865D-09,  -8.689682779940845D-08, &
&    8.263107533528447D-07,  -7.286422028863976D-06,   6.005185149855396D-05, &
&   -4.708020335298813D-04,   3.637649859065884D-03,  -2.992744959808260D-02, &
&    3.616081473536585D-01,                                                   &
&    6.351107527376902D-14,  -9.015169105688639D-13,   1.184236446313275D-11, &
&   -1.483737821165363D-10,   1.746370634028160D-09,  -1.933970196378457D-08, &
&    2.024589065433518D-07,  -2.021052447591805D-06,   1.951797839366371D-05, &
&   -1.864372935968025D-04,   1.823344281315961D-03,  -1.956082654333778D-02, &
&    3.133086873213072D-01,                                                   &
&    1.159412142212979D-14,  -1.711897437449464D-13,   2.363753260613387D-12, &
&   -3.146562999488804D-11,   3.994322895263676D-10,  -4.861139484715503D-09, &
&    5.720113320291043D-08,  -6.584062484368580D-07,   7.525809848525314D-06, &
&   -8.709020612031530D-05,   1.049622466419238D-03,  -1.401009952884401D-02, &
&    2.802473905066427D-01,                                                   &
&    2.251229828781626D-15,  -3.497386781066486D-14,   5.146250028941745D-13, &
&   -7.391607308589474D-12,   1.028879497302721D-10,  -1.398238401616344D-09, &
&    1.872597099628824D-08,  -2.497946903039009D-07,   3.359041299594548D-06, &
&   -4.621314287903345D-05,   6.660836786932372D-04,  -1.065938692987624D-02, &
&    2.558314305293831D-01,                                                   &
&    4.714814650856858D-16,  -7.803530770812067D-15,   1.240495344911985D-13, &
&   -1.948700323936440D-12,   3.010140702247982D-11,  -4.605133930696832D-10, &
&    7.031962529344370D-09,  -1.080271919096809D-07,   1.684272655562107D-06, &
&   -2.696816079182720D-05,   4.531482541745662D-04,  -8.459044587498270D-03, &
&    2.368540799786707D-01,                                                   &
&    1.079225083154047D-16,  -1.925182406748780D-15,   3.342421610287919D-14, &
&   -5.792576602579390D-13,   9.977892713373226D-12,  -1.717779262273951D-10, &
&    2.971888546180012D-09,  -5.195821763750636D-08,   9.242226431429817D-07, &
&   -1.690275059782155D-05,   3.245440649956355D-04,  -6.923644231631797D-03, &
&    2.215567279473922D-01,                                                   &
&    2.726215463170131D-17,  -5.285876873594814D-16,   1.008246228274165D-14, &
&   -1.932457555726528D-13,   3.705363457038872D-12,  -7.134443214146885D-11, &
&    1.384611445930280D-09,  -2.720027171138067D-08,   5.440759434128241D-07, &
&   -1.119278202591473D-05,   2.417656147577299D-04,  -5.802379830845432D-03, &
&    2.088856891404153D-01,                                                   &
&    7.628767352432934D-18,  -1.614001935475711D-16,   3.384359707551509D-15, &
&   -7.154885913216040D-14,   1.518190194608326D-12,  -3.241532112740912D-11, &
&    6.983963372653756D-10,  -1.523929974778852D-08,   3.386606478899548D-07, &
&   -7.740863883999459D-06,   1.857809393313485D-04,  -4.954159069220501D-03, &
&    1.981663648299737D-01,                                                   &
&    2.358713499397475D-18,  -5.442983048423945D-17,   1.250493505660469D-15, &
&   -2.899933080813371D-14,   6.759304418650570D-13,  -1.586552405162053D-11, &
&    3.759206736464065D-10,  -9.022307490902875D-09,   2.205465856442572D-07, &
&   -5.545177937789153D-06,   1.463927254523143D-04,  -4.294186706250157D-03, &
&    1.889442153539537D-01,                                                   &
&    7.998616455618539D-19,  -2.006455516113400D-17,   5.023674631805730D-16, &
&   -1.269688910140927D-14,   3.227087294617113D-13,  -8.261842801462930D-12, &
&    2.135408913519427D-10,  -5.590917391279682D-09,   1.490913052094774D-07, &
&   -4.089362413158648D-06,   1.177736412741035D-04,  -3.768756533355095D-03, &
&    1.809003136387959D-01,                                                   &
&    2.946091056167057D-19,  -7.995587695841407D-18,   2.168885395026235D-16, &
&   -5.936646687978929D-15,   1.634410616358090D-13,  -4.532833013140131D-12, &
&    1.269198694682564D-10,  -3.599912895445183D-09,   1.039975072996076D-07, &
&   -3.090211767119029D-06,   9.641460764502256D-05,  -3.342373066730479D-03, &
&    1.738033994750940D-01,                                                   &
&    1.166861769453123D-19,  -3.408944458300442D-18,   9.962296009586472D-17, &
&   -2.936359226683385D-15,   8.705590584957478D-14,  -2.600078863662946D-12, &
&    7.840245162018306D-11,  -2.394839046036678D-09,   7.450610685567417D-08, &
&   -2.384195435844430D-06,   8.010896671351685D-05,  -2.990734757535109D-03, &
&    1.674811464226576D-01,                                                   &
&    4.924493247001450D-20,  -1.541255341577444D-18,   4.827948885063377D-17, &
&   -1.524630305254506D-15,   4.842977339142600D-14,  -1.549753984828108D-12, &
&    5.006898476763092D-11,  -1.638621390559788D-09,   5.462071345192029D-08, &
&   -1.872710177722415D-06,   6.741756640736457D-05,  -2.696702656325775D-03, &
&    1.618021593796401D-01,                                                   &
&    2.197081774279274D-20,  -7.334688537657414D-19,   2.451691155456516D-17, &
&   -8.258351898114191D-16,   2.798134871591693D-14,  -9.550968697331348D-13, &
&    3.291410880836007D-11,  -1.149001626177145D-09,   4.085339121161223D-08, &
&   -1.494066878897632D-06,   5.737216815093549D-05,  -2.447879174444136D-03, &
&    1.566642671644373D-01,                                                   &
&    1.029405694843930D-20,  -3.651380009067028D-19,   1.297219002406098D-17, &
&   -4.642683415275880D-16,   1.671370537136583D-14,  -6.061504038659491D-13, &
&    2.219443032945009D-11,  -8.232115989727091D-10,   3.109910485802270D-08, &
&   -1.208422360238261D-06,   4.930363229789243D-05,  -2.235097997505028D-03, &
&    1.519866638303436D-01/
end


!------------------
  module rysgrid2
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t2(13,2,0:21)
      real(8) :: w2(13,2,0:21)
      data t2 / &
&   -1.645683990592917D-12,   2.100144893931428D-12,   9.081766594048410D-11, &
&    5.507884812534656D-10,  -3.190939407131993D-09,  -6.289165871747832D-08, &
&   -1.964832938779592D-07,   3.512448627048798D-06,   4.002591414290830D-05, &
&    1.228366352449974D-05,  -3.459939694794278D-03,  -4.258907133796220D-02, &
&    7.415557471458092D-01,                                                   &
&    5.478985780262826D-14,  -2.879307241194254D-12,   4.324802970038289D-11, &
&   -2.989609255017712D-10,  -7.112880708807715D-11,   2.612868652963995D-08, &
&   -3.187859457282563D-07,   1.619088010250957D-06,   8.497916136770632D-06, &
&   -2.533642544591777D-04,   2.894518721210033D-03,  -2.271705111101739D-02, &
&    1.155871099970479D-01,                                                   &
&    2.405297704883191D-12,  -1.064393456492684D-11,  -1.950158964905725D-10, &
&    2.163931242390912D-10,   1.339216613230857D-08,   2.283160084897028D-08, &
&   -8.242984799077039D-07,  -3.818866505410256D-06,   4.550001875752494D-05, &
&    4.048737173587540D-04,  -2.236224974901541D-03,  -5.478705155837363D-02, &
&    6.433678586004140D-01,                                                   &
&    7.532953663920184D-14,  -7.647612284809296D-13,   1.132721368435696D-12, &
&    6.016371685390664D-11,  -9.397843145081267D-10,   9.847672924362133D-09, &
&   -5.554877491598296D-08,  -3.765686318022056D-07,   1.205947665909221D-05, &
&   -1.581767479219191D-04,   1.647775909762565D-03,  -1.382795945283651D-02, &
&    7.987475560861417D-02,                                                   &
&   -2.923852014547807D-12,   1.638518260814666D-11,   1.766699552289447D-10, &
&   -1.310020148551285D-09,  -9.655582845559199D-09,   9.652061828886505D-08, &
&    4.941429616322730D-07,  -6.963095849409221D-06,  -2.260706354458623D-05, &
&    5.190363036752180D-04,   8.196476414848574D-04,  -5.785785462941354D-02, &
&    5.286471374415058D-01,                                                   &
&    1.723350437383481D-14,   2.071153177767476D-13,  -2.580931484202777D-12, &
&    1.145047706824609D-11,  -1.961850106409899D-10,   2.090672889503840D-09, &
&    1.378698083115356D-08,  -5.224600058644362D-07,   6.899734810307933D-06, &
&   -8.150456536375979D-05,   9.498927011486032D-04,  -8.786277421102529D-03, &
&    5.772292327703358D-02,                                                   &
&    1.542122634055986D-12,  -1.241354830875376D-11,  -4.863344549645876D-11, &
&    1.139365948748136D-09,  -2.599576730713804D-09,  -6.610163110922296D-08, &
&    5.401751276172667D-07,   1.707386132965301D-06,  -4.898044395306705D-05, &
&    1.714873661197348D-04,   2.996656502916209D-03,  -4.950507620875745D-02, &
&    4.198188164673604D-01,                                                   &
&   -1.939241059744783D-14,  -5.456535613441180D-14,   1.094474780321781D-12, &
&    8.573520477629799D-12,  -1.390455452023925D-10,  -5.842489557090987D-10, &
&    2.374598860713615D-08,  -2.597555754261224D-07,   2.889816456569605D-06, &
&   -4.414778991478354D-05,   5.890542057806816D-04,  -5.782367996370005D-03, &
&    4.339268320923733D-02,                                                   &
&   -2.863642399122855D-13,   5.179941654421391D-12,  -2.255251555265906D-11, &
&   -2.345650252045292D-10,   4.060424975746009D-09,  -1.825516750563470D-08, &
&   -1.679334044835229D-07,   3.165929070939200D-06,  -1.730388192066666D-05, &
&   -1.022791087985821D-04,   3.071649831921831D-03,  -3.681767244556846D-02, &
&    3.334640974595681D-01,                                                   &
&    1.046929663198497D-14,   4.670745228578699D-15,  -1.005848832384029D-12, &
&    5.537441285922812D-12,   6.056679149509118D-11,  -1.116851695508894D-09, &
&    7.825568178956214D-09,  -6.316534514732558D-08,   1.442694661817944D-06, &
&   -2.813771636333063D-05,   3.778493003518353D-04,  -3.880051554254912D-03, &
&    3.387032129447630D-02,                                                   &
&   -4.939273687277157D-14,  -5.712251606655460D-13,   1.285906558839569D-11, &
&   -1.053970100525044D-10,   4.589265970334507D-11,   1.038738914794547D-08, &
&   -1.446891113180903D-07,   9.023183607895450D-07,   2.645466908166775D-06, &
&   -1.453127864872322D-04,   2.249445452239444D-03,  -2.609574103334399D-02, &
&    2.711093878951141D-01,                                                   &
&   -3.677029341334106D-15,   3.004311337751362D-14,   8.454096173480142D-14, &
&   -4.012990627899436D-12,   3.730995063636366D-11,  -1.042105668373821D-10, &
&   -1.429055097148441D-10,  -3.188909174406641D-08,   1.045821886369228D-06, &
&   -1.837203181612732D-05,   2.398452927413921D-04,  -2.664121869739096D-03, &
&    2.741795071940302D-02,                                                   &
&    2.339006365874919D-14,  -2.477240036331151D-13,   1.008422874752318D-12, &
&    1.534241614947592D-11,  -3.955747498354576D-10,   4.788820719765900D-09, &
&   -3.161112130860334D-08,  -6.938104933971444D-08,   5.666889850144464D-06, &
&   -1.057045392679853D-04,   1.485226443559953D-03,  -1.870813642004253D-02, &
&    2.268164260996129D-01,                                                   &
&    1.074238974889964D-16,  -9.277226128950327D-15,   1.184985664848023D-13, &
&   -5.849297319059673D-13,  -3.896921418110890D-12,   7.421994201138746D-11, &
&    4.137858397141285D-10,  -3.250514590042013D-08,   7.167536591244130D-07, &
&   -1.131478331375273D-05,   1.521073217971318D-04,  -1.894334388576228D-03, &
&    2.291780974080168D-02,                                                   &
&    2.205565045840399D-15,   1.038740105257210D-14,  -5.960349976568290D-13, &
&    1.049982191605513D-11,  -1.206741653306266D-10,   8.171389025390773D-10, &
&    2.350175373198620D-09,  -1.898364255734366D-07,   4.041873686048671D-06, &
&   -6.613963205807714D-05,   9.764534511668079D-04,  -1.386418586991188D-02, &
&    1.945823698264077D-01,                                                   &
&    2.197646548361065D-16,  -1.680954579330134D-15,  -2.881285124769840D-15, &
&    2.582783966013615D-13,  -3.211813602308095D-12,  -1.326856230952927D-12, &
&    8.977594144088450D-10,  -2.352782265916957D-08,   4.318131759963482D-07, &
&   -6.781870387726956D-06,   9.896091896660709D-05,  -1.401238930385648D-03, &
&    1.965751466650148D-02,                                                   &
&   -5.730235760987360D-16,   1.369069358255249D-14,  -2.140751217243928D-13, &
&    2.432188178567579D-12,  -1.635186751921901D-11,  -8.587205392316955D-11, &
&    5.567626580598088D-09,  -1.302277750154993D-07,   2.413141214424790D-06, &
&   -4.073279071884666D-05,   6.623725593427517D-04,  -1.063717956039035D-02, &
&    1.702895189554938D-01,                                                   &
&    5.292701652747914D-18,   3.409154026262286D-16,  -7.713472909543500D-15, &
&    8.487766880136106D-14,  -3.438529784666059D-14,  -2.282324891706944D-11, &
&    6.691503679650882D-10,  -1.383830696853077D-08,   2.473879050164378D-07, &
&   -4.130039428284849D-06,   6.696092537517004D-05,  -1.074672850435852D-03, &
&    1.720283823022513D-02,                                                   &
&   -2.382725245126936D-16,   3.611478367334609D-15,  -4.066431663850767D-14, &
&    2.571383019170889D-13,   2.752251578564124D-12,  -1.442583101402146D-10, &
&    3.618979374130231D-09,  -7.442973244915148D-08,   1.409999518184596D-06, &
&   -2.581304053457212D-05,   4.667312926822181D-04,  -8.408662097503847D-03, &
&    1.513735729191411D-01,                                                   &
&   -9.218062918276586D-18,   1.602343320948556D-16,  -1.646205881733667D-15, &
&   -8.347376854560358D-16,   5.374095436948126D-13,  -1.678193763217349D-11, &
&    3.819331778988620D-10,  -7.621983000740835D-09,   1.429779935515887D-07, &
&   -2.609894573713817D-06,   4.715644325798537D-05,  -8.494618968427755D-04, &
&    1.529185122780189D-02,                                                   &
&   -5.138938848917971D-17,   5.881528425744769D-16,  -3.076244510532477D-15, &
&   -7.379787360364046D-14,   3.323174329255218D-12,  -8.821568776922857D-11, &
&    1.984958398982914D-09,  -4.161093234919225D-08,   8.461464561807971D-07, &
&   -1.700616416558144D-05,   3.405160078080862D-04,  -6.811694353230759D-03, &
&    1.362370617621035D-01,                                                   &
&   -2.600656547173152D-18,   2.560143081480900D-17,   8.123084205372752D-17, &
&   -1.162211470497292D-14,   3.753172235985812D-13,  -9.244420573652033D-12, &
&    2.029581063586174D-10,  -4.218792751609348D-09,   8.555729054607985D-08, &
&   -1.718299476569019D-06,   3.440011966238555D-05,  -6.881229671386470D-04, &
&    1.376274022638983D-02,                                                   &
&   -7.169971446363512D-18,   2.511230658776561D-17,   1.674707644719973D-15, &
&   -6.850566019244681D-14,   1.910953344062702D-12,  -4.656002579711203D-11, &
&    1.068363957020166D-09,  -2.387346159870531D-08,   5.278363613938561D-07, &
&   -1.162770652536561D-05,   2.558803652274155D-04,  -5.629611666002487D-03, &
&    1.238520111235453D-01,                                                   &
&   -3.137513753196973D-19,  -2.703587868716922D-18,   2.288905127897885D-16, &
&   -7.547303915607906D-15,   1.989444662884933D-13,  -4.752682571947050D-12, &
&    1.082841519241904D-10,  -2.413931522675289D-09,   5.333378605726675D-08, &
&   -1.174684290493574D-06,   2.584931255834038D-05,  -5.687065676829713D-04, &
&    1.251159418651934D-02,                                                   &
&    3.734650230721343D-20,  -3.263016617276033D-17,   1.272467402129934D-15, &
&   -3.718192450960750D-14,   9.735728650196990D-13,  -2.424401733392435D-11, &
&    5.901792505729332D-10,  -1.423248801145755D-08,   3.420536208994846D-07, &
&   -8.212007264309149D-06,   1.971005691500596D-04,  -4.730455722097966D-03, &
&    1.135310319027362D-01,                                                   &
&    6.621865968348885D-20,  -4.083912716032294D-18,   1.374293994734436D-16, &
&   -3.848665757652337D-15,   9.921582867039197D-14,  -2.456311350130503D-12, &
&    5.967207401075396D-11,  -1.438094253148633D-09,   3.455608545353864D-08, &
&   -8.295879951967063D-07,   1.991122182529436D-05,  -4.778731134834697D-04, &
&    1.146896329096658D-02,                                                   &
&    5.668160943974724D-19,  -2.146986675051166D-17,   6.556901389307185D-16, &
&   -1.834655065213472D-14,   4.924289496608947D-13,  -1.296584691684190D-11, &
&    3.386219114030443D-10,  -8.816318537723915D-09,   2.293073978912821D-07, &
&   -5.962462853006956D-06,   1.550261515213561D-04,  -4.030687045323806D-03, &
&    1.047978789950159D-01,                                                   &
&    6.654654159167089D-20,  -2.285122882501881D-18,   6.754024650828967D-17, &
&   -1.866863590701667D-15,   4.987088211118169D-14,  -1.310851735333657D-12, &
&    3.421522106148115D-11,  -8.906750584837094D-10,   2.316498754606506D-08, &
&   -6.023320336167762D-07,   1.566082455424601D-05,  -4.071820849306616D-04, &
&    1.058673565385667D-02,                                                   &
&    3.309523082644297D-19,  -1.059045882372244D-17,   3.144204743299478D-16, &
&   -9.045257297268166D-15,   2.560739943601926D-13,  -7.199134082385672D-12, &
&    2.018411355517649D-10,  -5.653656870406428D-09,   1.583166128348510D-07, &
&   -4.432944751113772D-06,   1.241228075577310D-04,  -3.475439790411547D-03, &
&    9.731231673327476D-02,                                                   &
&    3.479378386980688D-20,  -1.086791033054035D-18,   3.195171462226497D-17, &
&   -9.157036166907310D-16,   2.588677227323227D-14,  -7.274086335359126D-13, &
&    2.039116176692503D-11,  -5.711418856264444D-10,   1.599325926265286D-08, &
&   -4.478184966676625D-07,   1.253895029387452D-05,  -3.510907163712183D-04, &
&    9.830540298003246D-03,                                                   &
&    1.568975138495024D-19,  -4.953495289778476D-18,   1.515594655922126D-16, &
&   -4.590036264669247D-15,   1.381958980266292D-13,  -4.150922041180389D-12, &
&    1.245731377949783D-10,  -3.737550718967962D-09,   1.121289054662453D-07, &
&   -3.363880381408101D-06,   1.009164698134724D-04,  -3.027494286968989D-03, &
&    9.082482903102808D-02,                                                   &
&    1.604716130024947D-20,  -5.028499754632174D-19,   1.533776637688288D-17, &
&   -4.639669053368411D-16,   1.396319952679424D-14,  -4.193494305002333D-13, &
&    1.258459407653071D-11,  -3.775702269145119D-10,   1.132732446818943D-08, &
&   -3.398209460445463D-07,   1.019463375482861D-05,  -3.058390304357297D-04, &
&    9.175170952185682D-03,                                                   &
&    7.176454402810617D-20,  -2.340445848389949D-18,   7.527303099324339D-17, &
&   -2.416260639236501D-15,   7.740545173491716D-14,  -2.477830249144601D-12, &
&    7.929820068620510D-11,  -2.537601700773411D-09,   8.120364728663775D-08, &
&   -2.598518874104156D-06,   8.315261344501757D-05,  -2.660883661284122D-03, &
&    8.514827722869371D-02,                                                   &
&    7.278063153359960D-21,  -2.367835350647671D-19,   7.607999816604136D-18, &
&   -2.441316621599846D-16,   7.819905143531395D-15,  -2.503146863917946D-13, &
&    8.010766487458341D-12,  -2.563499607132178D-10,   8.203234893444631D-09, &
&   -2.625037161623666D-07,   8.400119795075872D-06,  -2.688038363280184D-04, &
&    8.601722768798473D-03,                                                   &
&    3.331543051232492D-20,  -1.140245021805745D-18,   3.876532159804105D-17, &
&   -1.319299408385499D-15,   4.487056877475427D-14,  -1.525741757228358D-12, &
&    5.187647873076133D-11,  -1.763809976442340D-09,   5.996960300770802D-08, &
&   -2.038966850856884D-06,   6.932487444780357D-05,  -2.357045736172745D-03, &
&    8.013955504058868D-02,                                                   &
&    3.369595785770623D-21,  -1.152380839930204D-19,   3.916644159197934D-18, &
&   -1.332819452018903D-16,   4.532899826651423D-15,  -1.541316410212656D-13, &
&    5.240591594979628D-12,  -1.781810096957636D-10,   6.058160240514542D-09, &
&   -2.059774805706982D-07,   7.003234480936946D-06,  -2.381099728141810D-04, &
&    8.095739076686003D-03,                                                   &
&    1.595946021682885D-20,  -5.757511888972948D-19,   2.069289289343390D-17, &
&   -7.451573444972352D-16,   2.682808261752493D-14,  -9.658342970623473D-13, &
&    3.477023930512576D-11,  -1.251730180731887D-09,   4.506229674122277D-08, &
&   -1.622242738269430D-06,   5.840073881853524D-05,  -2.102426598247846D-03, &
&    7.568735753860499D-02,                                                   &
&    1.612809088781384D-21,  -5.816976478894299D-20,   2.090484726726196D-18, &
&   -7.527697503976878D-17,   2.710194024376899D-15,  -9.756913721935525D-14, &
&    3.512507887100344D-12,  -1.264504293887972D-10,   4.552216411581976D-09, &
&   -1.638797960100005D-07,   5.899672678917271D-06,  -2.123882165143063D-04, &
&    7.645975794673343D-03,                                                   &
&    7.919786471135599D-21,  -3.011202313965579D-19,   1.141975870992787D-17, &
&   -4.339858767828749D-16,   1.649187829800470D-14,  -6.266951425960411D-13, &
&    2.381444824473467D-11,  -9.049492831019847D-10,   3.438807438175126D-08, &
&   -1.306746835280379D-06,   4.965637977848613D-05,  -1.886942431704538D-03, &
&    7.170381240503443D-02,                                                   &
&    8.001424518334159D-22,  -3.042032133065260D-20,   1.153640904460178D-18, &
&   -4.384158870673593D-17,   1.666019058315944D-15,  -6.330907407577699D-14, &
&    2.405747872300595D-12,  -9.141844247932945D-11,   3.473900966276624D-09, &
&   -1.320082375420756D-07,   5.016313030157949D-06,  -1.906198951575097D-04, &
&    7.243556016010116D-03,                                                   &
&    4.067754964848439D-21,  -1.627209427042379D-19,   6.496094474591251D-18, &
&   -2.598494948358324D-16,   1.039405779430000D-14,  -4.157629130784706D-13, &
&    1.663052172705516D-11,  -6.652209085295741D-10,   2.660883659637483D-08, &
&   -1.064353465227529D-06,   4.257413861499415D-05,  -1.702965544618704D-03, &
&    6.811862178478865D-02,                                                   &
&    4.109381985701979D-22,  -1.643829422493077D-20,   6.562403526769512D-19, &
&   -2.625014539191987D-17,   1.050013209663981D-15,  -4.200058453486407D-14, &
&    1.680023868513399D-12,  -6.720095844254184D-11,   2.688038361704787D-09, &
&   -1.075215345975647D-07,   4.300861384459159D-06,  -1.720344553801583D-04, &
&    6.881378215210171D-03,                                                   &
&    2.157281516143665D-21,  -9.059883182485735D-20,   3.798216434760345D-18, &
&   -1.595260295193631D-16,   6.700111767113075D-15,  -2.814047891864682D-13, &
&    1.181900196025347D-11,  -4.963980885039066D-10,   2.084871975692953D-08, &
&   -8.756462300040478D-07,   3.677714166108108D-05,  -1.544639949768323D-03, &
&    6.487487789027577D-02,                                                   &
&    2.179313051201982D-22,  -9.152360376620836D-21,   3.836979950723571D-19, &
&   -1.611540377298218D-17,   6.768487576524013D-16,  -2.842765673165782D-14, &
&    1.193961659282241D-12,  -5.014639027163701D-11,   2.106148395163881D-09, &
&   -8.845823261703566D-08,   3.715245770001848D-06,  -1.560403223403546D-04, &
&    6.553693538295484D-03/
      data w2 / &
&    4.444956288185975D-11,  -8.563353793100921D-10,   1.116790383112313D-08, &
&   -1.259595678323385D-07,   1.278629449133057D-06,  -1.163675298543922D-05, &
&    9.380676132216553D-05,  -6.589208800651566D-04,   3.943577829306991D-03, &
&   -1.949245652252374D-02,   7.576734440937891D-02,  -2.106197114047355D-01, &
&    3.478548451374539D-01,                                                   &
&    8.360089376673550D-12,  -1.516504882215097D-10,   1.824229034274066D-09, &
&   -1.894167590083975D-08,   1.801890900503470D-07,  -1.590711642415090D-06, &
&    1.303082903615822D-05,  -9.865487375998940D-05,   6.860517997740959D-04, &
&   -4.317067286952291D-03,   2.423265559061893D-02,  -1.227136219285978D-01, &
&    6.521451548625461D-01,                                                   &
&    1.155649569940130D-11,  -1.547976914648892D-10,   1.880864149536751D-09, &
&   -2.132625448449287D-08,   2.196329022386120D-07,  -2.038091775664789D-06, &
&    1.687578938510986D-05,  -1.226698223410814D-04,   7.681738988407577D-04, &
&   -4.053686391599427D-03,   1.725693915297040D-02,  -5.411363053120103D-02, &
&    1.205437549185627D-01,                                                   &
&    1.900568495940307D-12,  -2.329980598011913D-11,   2.615350354703303D-10, &
&   -2.809688450955384D-09,   2.892975060719829D-08,  -2.823263320247681D-07, &
&    2.580926986666149D-06,  -2.230792440626423D-05,   1.805511104196823D-04, &
&   -1.337096563829131D-03,   9.214468263517093D-03,  -6.158855032496882D-02, &
&    4.776002517427414D-01,                                                   &
&    1.888467851819105D-12,  -2.598084045833718D-11,   3.236242385481052D-10, &
&   -3.695941111805464D-09,   3.878717000248805D-08,  -3.731986786780276D-07, &
&    3.210530688052596D-06,  -2.435803480048475D-05,   1.633968163811134D-04, &
&   -9.538294514632698D-04,   4.551340979521346D-03,  -1.645112401771177D-02, &
&    5.814624310326283D-02,                                                   &
&    2.957753408129629D-13,  -3.431740523037740D-12,   3.788093661002386D-11, &
&   -4.822451619802663D-10,   5.632299307717783D-09,  -5.859497669223715D-08, &
&    6.063009497153104D-07,  -6.172714476365466D-06,   5.709002759130450D-05, &
&   -4.901970469091480D-04,   4.211550101475072D-03,  -3.638950804384733D-02, &
&    3.828944522779480D-01,                                                   &
&    3.640681566887161D-13,  -4.658385639927087D-12,   5.369735451501965D-11, &
&   -6.499632804983615D-10,   7.408832057541715D-09,  -7.333832803717088D-08, &
&    6.421689177932500D-07,  -5.248729229048906D-06,   3.995584482507000D-05, &
&   -2.625796139428063D-04,   1.376572824651594D-03,  -5.929818909868264D-03, &
&    3.781964257068210D-02,                                                   &
&    1.301017676678116D-15,  -3.746868803264137D-13,   9.954670728961292D-12, &
&   -1.115116263885180D-10,   1.045710672492151D-09,  -1.355849976223758D-08, &
&    1.841418355595947D-07,  -2.037692799815069D-06,   2.009600667348396D-05, &
&   -2.082224195870750D-04,   2.261077034414291D-03,  -2.399763068821434D-02, &
&    3.237885047829764D-01,                                                   &
&    3.652140385661733D-14,  -6.236213192190320D-13,   1.103103770731032D-11, &
&   -1.432355852117152D-10,   1.461240235514865D-09,  -1.387739456749535D-08, &
&    1.383717487198245D-07,  -1.366527193323536D-06,   1.170773553804130D-05, &
&   -8.075628364995077D-05,   4.557662792084702D-04,  -2.619033356551025D-03, &
&    2.987031557852911D-02,                                                   &
&    2.698967141715169D-14,  -2.778955913498320D-13,   8.113267558224324D-13, &
&   -5.138196904821151D-12,   2.851303985132951D-10,  -5.462307396289223D-09, &
&    6.408715782352729D-08,  -6.545252542682692D-07,   7.810242855622414D-06, &
&   -1.056810099468517D-04,   1.367578002107491D-03,  -1.694179318678675D-02, &
&    2.834383717427781D-01,                                                   &
&    1.349344300855831D-14,  -2.277108827094568D-13,   2.395363034606164D-12, &
&   -2.161144857750980D-11,   2.342071760335069D-10,  -3.175150651238985D-09, &
&    4.095297648472206D-08,  -4.324663865256027D-07,   3.643875369576389D-06, &
&   -2.539224669941872D-05,   1.688458572359053D-04,  -1.478151422802517D-03, &
&    2.596024899360779D-02,                                                   &
&   -1.899321586428514D-15,   5.652113896451041D-14,  -3.160977399277784D-14, &
&   -9.854181417378241D-12,   1.652251134928608D-10,  -1.685988833476518D-09, &
&    1.624815671818837D-08,  -2.259398619112553D-07,   3.881934478948924D-06, &
&   -6.169795942089658D-05,   8.807766091833330D-04,  -1.253194810604149D-02, &
&    2.542871415130350D-01,                                                   &
&    3.093155173306254D-15,  -2.185987722478158D-14,   1.784728623582205D-13, &
&   -3.477093558106715D-12,   7.169634652869269D-11,  -1.126578188006833D-09, &
&    1.364331224091727D-08,  -1.324963284171672D-07,   1.086749151124551D-06, &
&   -8.433337601916275D-06,   7.738527698644800D-05,  -1.018827688440916D-03, &
&    2.352292018915140D-02,                                                   &
&   -8.419253445246281D-16,  -1.311399058588328D-14,   3.361521405359540D-13, &
&   -3.914513750482759D-12,   3.119160320157945D-11,  -2.716602136095109D-10, &
&    5.082658755370968D-09,  -1.172983618867337D-07,   2.272292148469998D-06, &
&   -3.777980527711718D-05,   5.886984017067892D-04,  -9.640559241435323D-03, &
&    2.323085103402317D-01,                                                   &
&   -3.623577195950088D-17,  -8.232038953710793D-16,   6.535818036463556D-14, &
&   -1.659388858081903D-12,   2.813101103517794D-11,  -3.688707574557960D-10, &
&    3.979536045908029D-09,  -3.725571518300872D-08,   3.330250347976513D-07, &
&   -3.375245682522663D-06,   4.489894257495563D-05,  -7.841294137579678D-04, &
&    2.174123301700196D-02,                                                   &
&    5.077172370451867D-16,  -6.980326875440988D-15,   5.869135412656295D-14, &
&   -2.893114658545364D-13,   1.970395987301886D-12,  -9.164263561388717D-11, &
&    3.052426483436340D-09,  -7.077147672667219D-08,   1.351247620764455D-06, &
&   -2.359291510930454D-05,   4.082493115996105D-04,  -7.674915173740302D-03, &
&    2.151128469616687D-01,                                                   &
&    2.072975370276098D-17,  -1.486223197942820D-15,   3.599438151709772D-14, &
&   -6.175864339095871D-13,   8.547867804749909D-12,  -1.005838117224492D-10, &
&    1.055460525506323D-09,  -1.073117935097792D-08,   1.216100818493063D-07, &
&   -1.728661911969579D-06,   3.041031069816812D-05,  -6.367361236897023D-04, &
&    2.032991810384911D-02,                                                   &
&    8.719275461264373D-17,  -4.389592088059601D-16,  -2.570165414218535D-15, &
&    3.832877365164813D-14,   1.430024908623317D-12,  -7.119411450494590D-11, &
&    1.916428020673690D-09,  -4.122703828652845D-08,   8.026125612936754D-07, &
&   -1.517408868585197D-05,   2.941337542974674D-04,  -6.286908107942095D-03, &
&    2.012268098435431D-01,                                                   &
&    3.085738564391150D-17,  -6.850838814718738D-16,   1.177070367639519D-14, &
&   -1.710595961785345D-13,   2.178051107966789D-12,  -2.534064611200527D-11, &
&    2.901732860239326D-10,  -3.681385538981943D-09,   5.697009329036212D-08, &
&   -1.059991229877739D-06,   2.229705138364563D-05,  -5.326407104820744D-04, &
&    1.916591674823968D-02,                                                   &
&   -3.595231012210186D-18,   1.564961941123924D-16,  -1.688241393653538D-15, &
&   -2.218615939411834D-14,   1.527312349072083D-12,  -4.600378602946358D-11, &
&    1.094438159906348D-09,  -2.351888617239873D-08,   4.871058501224620D-07, &
&   -1.013279079603699D-05,   2.194685633740842D-04,  -5.269739120363357D-03, &
&    1.897197723921756D-01,                                                   &
&    1.124229805113482D-17,  -1.976568337702906D-16,   2.994383822735282D-15, &
&   -4.110046727218371D-14,   5.264910770869552D-13,  -6.738753615006481D-12, &
&    9.549229792549220D-11,  -1.619423381452891D-09,   3.235392288519358D-08, &
&   -7.161103028703124D-07,   1.706572121965059D-05,  -4.545976174128338D-04, &
&    1.818215312838640D-02,                                                   &
&   -3.613530698701873D-18,   3.625664022271954D-17,   3.899758848162270D-16, &
&   -3.044839185997669D-14,   9.916991175213703D-13,  -2.567656751240264D-11, &
&    6.029040393398834D-10,  -1.361987636633562D-08,   3.063067250047612D-07, &
&   -7.024753581129147D-06,   1.687152181116979D-04,  -4.499561451807667D-03, &
&    1.799842117015873D-01,                                                   &
&    2.912476677235429D-18,  -4.701203915836249D-17,   6.863691365268173D-16, &
&   -9.631035900949043D-15,   1.369894694212607D-13,  -2.160880866344555D-12, &
&    4.021843134962752D-11,  -8.672354934767837D-10,   2.045953026139062D-08, &
&   -5.097894487025090D-07,   1.343517311826393D-05,  -3.940065111471555D-04, &
&    1.733596310262505D-02,                                                   &
&   -5.537631778379479D-19,  -7.417791325876946D-18,   5.641243691336522D-16, &
&   -1.936829490718467D-14,   5.389409724437964D-13,  -1.370464318527597D-11, &
&    3.357022422967790D-10,  -8.155071997426091D-09,   2.000870553828666D-07, &
&   -5.035388489086644D-06,   1.329575523340504D-04,  -3.900180195103001D-03, &
&    1.716082522513287D-01,                                                   &
&    6.554684562492292D-19,  -1.040314584008138D-17,   1.574013125261418D-16, &
&   -2.476157710119007D-15,   4.332217481349961D-14,  -8.840511375840732D-13, &
&    2.059612619586291D-11,  -5.197671201956072D-10,   1.371740359372489D-08, &
&   -3.753752024666768D-07,   1.080649449725060D-05,  -3.457910909255657D-04, &
&    1.659791438630563D-02,                                                   &
&    1.443931893126174D-19,  -9.661409321052618D-18,   3.449661506544313D-16, &
&   -1.022073139129026D-14,   2.793865546482117D-13,  -7.377791663878857D-12, &
&    1.929447651560797D-10,  -5.071150271084075D-09,   1.353739016157525D-07, &
&   -3.713987210691971D-06,   1.069671467768529D-04,  -3.422965442429529D-03, &
&    1.643023992524903D-01,                                                   &
&    1.411843307382790D-19,  -2.353141360999183D-18,   4.032687581145582D-17, &
&   -7.796122405800397D-16,   1.740363190731686D-14,  -4.376393102723924D-13, &
&    1.181567082099943D-11,  -3.314373734689401D-10,   9.548253488670343D-09, &
&   -2.835599793685877D-07,   8.846296371881829D-06,  -3.066686420586640D-04, &
&    1.594675924169208D-02,                                                   &
&    1.534247748784213D-19,  -5.642446334842219D-18,   1.765616636911677D-16, &
&   -5.157034447398890D-15,   1.460374297284922D-13,  -4.095193702867739D-12, &
&    1.151041986472569D-10,  -3.268475521976243D-09,   9.444925381093721D-08, &
&   -2.806651787750441D-06,   8.756831127314073D-05,  -3.035704424671815D-03, &
&    1.578566402334019D-01,                                                   &
&    3.174607562480807D-20,  -6.039563196854897D-19,   1.273466268685477D-17, &
&   -3.100225223515103D-16,   8.397377222501405D-15,  -2.422138586919032D-13, &
&    7.221868569118460D-12,  -2.199176845317979D-10,   6.837088387366001D-09, &
&   -2.187584863291057D-07,   7.350149258968298D-06,  -2.744050584470693D-04, &
&    1.536668153356550D-02,                                                   &
&    8.494010132050961D-20,  -2.804988138614970D-18,   8.688829740900994D-17, &
&   -2.626336704331875D-15,   7.865852862707337D-14,  -2.357865004971043D-12, &
&    7.118058305106460D-11,  -2.174921361504880D-09,   6.766901846830817D-08, &
&   -2.165436949515325D-06,   7.275881745454856D-05,  -2.716329699088040D-03, &
&    1.521144648890921D-01,                                                   &
&    8.230868403447880D-21,  -1.918672088036081D-19,   5.042442153325958D-18, &
&   -1.467161674834812D-16,   4.511614578378541D-15,  -1.427929636815071D-13, &
&    4.598524430454929D-12,  -1.503765175881611D-10,   5.011708118606492D-09, &
&   -1.718250725861423D-07,   6.185679279495412D-06,  -2.474270838027940D-04, &
&    1.484562473506403D-02,                                                   &
&    4.101406406657201D-20,  -1.349388132773836D-18,   4.323704669730780D-17, &
&   -1.377914137771025D-15,   4.391815881304746D-14,  -1.406961021146601D-12, &
&    4.547046033717599D-11,  -1.488244872971627D-09,   4.960900533331380D-08, &
&   -1.700885105136273D-06,   6.123188712786916D-05,  -2.449275572522981D-03, &
&    1.469565346445760D-01,                                                   &
&    2.650054267406965D-21,  -7.579673884771686D-20,   2.351384249594075D-18, &
&   -7.689538453841070D-17,   2.578433591422740D-15,  -8.772875324284821D-14, &
&    3.020664468385240D-12,  -1.054276691635355D-10,   3.748394451320537D-09, &
&   -1.370833022118194D-07,   5.263994868366898D-06,  -2.245970997663061D-04, &
&    1.437421433638979D-02,                                                   &
&    1.932076347537730D-20,  -6.576721149180232D-19,   2.216552730497111D-17, &
&   -7.489398052730084D-16,   2.540291512449419D-14,  -8.673681164902866D-13, &
&    2.989344433997484D-11,  -1.043573957013609D-09,   3.710499676029169D-08, &
&   -1.356983576685813D-06,   5.210817328256859D-05,  -2.223282074677829D-03, &
&    1.422900528280475D-01,                                                   &
&    1.050142592888389D-21,  -3.490241861816450D-20,   1.206840938864189D-18, &
&   -4.277903561077946D-17,   1.535290516826631D-15,  -5.563077479496170D-14, &
&    2.036493744064656D-12,  -7.553182685178798D-11,   2.853400094271203D-09, &
&   -1.108748347937371D-07,   4.523692605488395D-06,  -2.050740623709776D-04, &
&    1.394503623325498D-02,                                                   &
&    9.243914355560928D-21,  -3.302355822885497D-19,   1.176534908519676D-17, &
&   -4.214893059168085D-16,   1.517841485453920D-14,  -5.505196290709874D-13, &
&    2.015793658538543D-11,  -7.476797721209211D-10,   2.824570476375150D-08, &
&   -1.097547525444524D-06,   4.477993969240404D-05,  -2.030023935134051D-03, &
&    1.380416275970887D-01,                                                   &
&    4.793913847719391D-22,  -1.758377551018351D-20,   6.557677783249354D-19, &
&   -2.477803225321136D-17,   9.436610929714417D-16,  -3.622820295368044D-14, &
&    1.404463708985689D-12,  -5.515652039548399D-11,   2.206256744892981D-09, &
&   -9.077168291239928D-08,   3.921336594561295D-06,  -1.882241561460831D-04, &
&    1.355213924122683D-02,                                                   &
&    4.557498825147975D-21,  -1.715917870164726D-19,   6.462366725655974D-18, &
&   -2.449619458916411D-16,   9.338213362652822D-15,  -3.585957790842789D-13, &
&    1.390255837593855D-11,  -5.459919834791472D-10,   2.183968341116995D-08, &
&   -8.985469977997124D-07,   3.881723041222513D-05,  -1.863227060179742D-03, &
&    1.341523483342328D-01,                                                   &
&    2.378155272663745D-22,  -9.354574913940122D-21,   3.706158862440658D-19, &
&   -1.481230684353313D-17,   5.958394405184738D-16,  -2.414995152251657D-14, &
&    9.882776945762904D-13,  -4.096850349255132D-11,   1.729780590505630D-09, &
&   -7.512189615368815D-08,   3.425558447224569D-06,  -1.735616279293932D-04, &
&    1.319068372242688D-02,                                                   &
&    2.323941325326490D-21,  -9.220706788496743D-20,   3.664118467510013D-18, &
&   -1.465771251832437D-16,   5.897722465846947D-15,  -2.390557581032683D-13, &
&    9.782909803920560D-12,  -4.055461782871317D-10,   1.712306152922826D-08, &
&   -7.436301044755025D-07,   3.390953278146966D-05,  -1.718082994324458D-03, &
&    1.305743075688659D-01,                                                   &
&    1.242049655560298D-22,  -5.170771349481272D-21,   2.161025490880386D-19, &
&   -9.096984519846260D-18,   3.852613866350839D-16,  -1.643758641815550D-14, &
&    7.080785712201356D-13,  -3.089795784311995D-11,   1.373242462452768D-09, &
&   -6.277679767445686D-08,   3.013286285585260D-06,  -1.607086018877734D-04, &
&    1.285668815098899D-02,                                                   &
&    1.224720399411529D-21,  -5.112339110909475D-20,   2.138474857579828D-18, &
&   -9.004314410357301D-17,   3.813620234571819D-15,  -1.627146961124593D-13, &
&    7.009250519455492D-12,  -3.058582206623238D-10,   1.359369880447654D-08, &
&   -6.214262316709840D-07,   2.982845912299633D-05,  -1.590851153236579D-03, &
&    1.272680922589592D-01,                                                   &
&    6.731275531087889D-23,  -2.947511202236540D-21,   1.294416241929319D-19, &
&   -5.722340463233917D-18,   2.544723150035846D-16,  -1.140032170429587D-14, &
&    5.156449833584751D-13,  -2.362591299116336D-11,   1.102542588862651D-09, &
&   -5.292204416813039D-08,   2.667271025630499D-06,  -1.493671774337085D-04, &
&    1.254684290442633D-02,                                                   &
&    6.655789200587402D-22,  -2.916770310243157D-20,   1.281228465164667D-18, &
&   -5.664414053047875D-17,   2.519004813052252D-15,  -1.128514536244767D-13, &
&    5.104358391262201D-12,  -2.338724234464461D-10,   1.091404644489567D-08, &
&   -5.238742294522829D-07,   2.640326116483839D-05,  -1.478582625232549D-03, &
&    1.242009405195393D-01/
end


!------------------
  module rysgrid3
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t3(13,3,0:24)
      real(8) :: w3(13,3,0:24)
      data t3 / &
&    1.755558491160485D-14,  -6.948421520988065D-14,  -1.841388529492715D-12, &
&   -2.370649063629704D-11,  -8.041451527208797D-11,   2.469567632581057D-09, &
&    4.912008105905878D-08,   3.877757444794889D-07,  -1.006141947171804D-06, &
&   -8.279272879961872D-05,  -1.492607771034501D-03,  -1.745695340846739D-02, &
&    8.694993949182623D-01,                                                   &
&   -4.113630862922976D-14,   1.753799801991665D-13,   5.149991616565773D-12, &
&   -3.607523538872676D-11,  -5.733115782165397D-10,   5.908984849037566D-09, &
&    6.043523530758812D-08,  -8.855300571018462D-07,  -5.642829019333405D-06, &
&    1.392042402315720D-04,   5.397975248806591D-04,  -3.785475235398873D-02, &
&    4.371978527510939D-01,                                                   &
&    1.939344886815219D-15,  -9.076654698296908D-15,  -3.659100747648929D-13, &
&    1.015942887887809D-11,  -1.563117036306772D-10,   1.415863146902154D-09, &
&   -1.328818709573028D-09,  -2.029021925517755D-07,   4.572861477347277D-06, &
&   -6.954355539173576D-05,   8.427274914429898D-04,  -8.261085083062006D-03, &
&    5.693911596700735D-02,                                                   &
&    2.969788203007737D-14,   5.588796173977598D-13,   2.596583226723432D-12, &
&   -3.972864984990193D-11,  -7.771695020723178D-10,  -3.892598342209651D-09, &
&    5.262163313472624D-08,   1.085763388078181D-06,   6.299227788573814D-06, &
&   -6.638943326184604D-05,  -1.969316439354463D-03,  -2.441168104052968D-02, &
&    8.279524508496969D-01,                                                   &
&    1.183277788367051D-14,  -3.350033470110633D-13,   5.951531866212913D-13, &
&    4.174954597961117D-11,  -3.679215757151430D-10,  -3.589738303437604D-09, &
&    7.223074359861354D-08,   4.908383632902403D-08,  -9.933603673557880D-06, &
&    7.047966623187085D-05,   1.186095847591810D-03,  -3.426291636792223D-02, &
&    3.646470142697335D-01,                                                   &
&   -2.518433144303289D-16,   1.054047318636108D-14,  -2.218324792916320D-13, &
&    3.583724818036784D-12,  -3.780951242057249D-11,   2.397063728203517D-11, &
&    6.558811321153457D-09,  -1.524905755995199D-07,   2.721385162244425D-06, &
&   -4.072776073618175D-05,   5.193775657611389D-04,  -5.594357800804924D-03, &
&    4.329824122354560D-02,                                                   &
&   -1.461919870133050D-13,  -5.454924273799259D-13,   1.171206348108780D-11, &
&    1.406025777376711D-10,  -1.975162225355465D-10,  -1.618981042968726D-08, &
&   -9.746225257881490D-08,   1.001681623970049D-06,   1.825513785881574D-05, &
&    3.213458045431116D-05,  -2.121125477067512D-03,  -3.278969127297413D-02, &
&    7.708588937698118D-01,                                                   &
&    7.994399434193091D-15,   8.584572805771044D-14,  -1.839378512737166D-12, &
&    1.208330895861416D-11,   1.872424366463623D-10,  -4.237257334488994D-09, &
&    6.819109403127379D-09,   5.301092742536219D-07,  -6.362056023975364D-06, &
&    2.082592876465406D-06,   1.388948567224437D-03,  -2.897474644772256D-02, &
&    3.012761257245221D-01,                                                   &
&   -2.113309302246202D-16,   4.806330604954506D-15,  -5.810676425126732D-14, &
&    9.950755907497795D-13,  -1.467703847492856D-12,  -2.291283164396651D-10, &
&    4.462416766613241D-09,  -8.298974764928983D-08,   1.566252608331341D-06, &
&   -2.404494973440571D-05,   3.296617047873159D-04,  -3.929457040371350D-03, &
&    3.390029104442868D-02,                                                   &
&    2.383685354314950D-13,  -1.200937591374282D-12,  -2.697178530443175D-11, &
&    3.033723423717562D-11,   2.619759953572327D-09,   5.595050019549715D-09, &
&   -2.291783774278468D-07,  -1.269581312866889D-06,   1.835225204355891D-05, &
&    1.941246915783471D-04,  -1.443927201603113D-03,  -4.025007320114135D-02, &
&    6.973679437899719D-01,                                                   &
&   -7.347062214863304D-15,  -2.495399181219792D-15,  -1.702020057033493D-13, &
&   -3.827505850036846D-12,   2.070074970348203D-10,  -7.232116862224552D-10, &
&   -2.806246109197355D-08,   3.524714703551061D-07,  -1.600203976812420D-06, &
&   -2.851473966665630D-05,   1.290325549994998D-03,  -2.355551584698721D-02, &
&    2.488142049369707D-01,                                                   &
&   -2.585048670133986D-16,  -2.782685599465628D-15,  -3.049404447773345D-14, &
&    4.062810217320634D-13,   1.027021378170479D-11,  -1.460376160262421D-10, &
&    1.620496339936137D-09,  -4.768924691584542D-08,   9.417054447851352D-07, &
&   -1.424683952607638D-05,   2.172613010223224D-04,  -2.855114038913464D-03, &
&    2.719032490420975D-02,                                                   &
&   -1.723780343237177D-13,   2.950327268076455D-12,   1.405054922049954D-11, &
&   -2.855824227929612D-10,  -1.044993536298935D-09,   2.673868371858349D-08, &
&    7.089526220607257D-08,  -2.540412427954224D-06,  -3.850603782818832D-06, &
&    2.610464101343742D-04,   1.297290647604198D-05,  -4.324946863524637D-02, &
&    6.128848014400435D-01,                                                   &
&    9.186104180022395D-15,   5.271495508022482D-14,  -5.150021089550726D-13, &
&   -1.302178849843204D-11,   7.143459468775913D-11,   1.736785350309662D-09, &
&   -1.850616022144043D-08,   3.795446697834931D-08,   2.515041928134538D-07, &
&   -3.176556693639291D-05,   1.102159787729289D-03,  -1.876490923270765D-02, &
&    2.066201956070811D-01,                                                   &
&    6.753213356896449D-16,   4.614142795442163D-15,  -6.128591140909338D-14, &
&   -8.054691272382180D-13,   7.927567113499835D-12,   3.007656806994487D-11, &
&    8.472942804808987D-10,  -3.543534967009194D-08,   5.337421535920454D-07, &
&   -8.423287568113413D-06,   1.508766690180248D-04,  -2.130454504361108D-03, &
&    2.224879636375605D-02,                                                   &
&    1.018057283847976D-14,  -2.313616686616883D-12,   9.826009327193966D-12, &
&    1.796932890277075D-10,  -1.793860471243911D-09,  -8.289674690826728D-09, &
&    2.131229483460448D-07,  -3.100010508773804D-07,  -1.955028590477784D-05, &
&    1.518507327516307D-04,   1.315629676308975D-03,  -4.036750934898481D-02, &
&    5.283907899664879D-01,                                                   &
&   -1.197878954439801D-14,   8.518419873775489D-15,   1.318597225581836D-12, &
&   -3.260188662179374D-12,  -1.375682042093247D-10,   9.649634032685307D-10, &
&    4.552975269520164D-09,  -3.426915772349915D-08,   3.082917511120244D-08, &
&   -3.017046749799685D-05,   9.174286254958321D-04,  -1.472910617776816D-02, &
&    1.732491795183142D-01,                                                   &
&   -8.694059627310996D-16,   1.929203713811483D-15,   9.378928772083318D-14, &
&   -3.788183045050551D-13,  -7.910822156295351D-12,   1.947836531827830D-11, &
&    1.510031778633439D-09,  -2.111237558077588D-08,   2.437267095743787D-07, &
&   -5.409154998389268D-06,   1.105454506452014D-04,  -1.613600187371494D-03, &
&    1.853147331687308D-02,                                                   &
&    6.360515457214475D-14,   5.013578911843454D-13,  -1.133714399973008D-11, &
&    4.216024432247966D-11,   8.384233293819924D-10,  -1.200907209132631D-08, &
&    1.952759770561500D-08,   1.126219315090768D-06,  -1.342820609375741D-05, &
&    1.031517006413221D-05,   1.775969877046907D-03,  -3.389738313586543D-02, &
&    4.538225882276397D-01,                                                   &
&    6.572422717333592D-15,  -6.798888094548701D-14,  -3.408319837260587D-13, &
&    9.419347070446963D-12,  -2.594054406387941D-11,  -6.614671343175797D-10, &
&    4.373398060859678D-09,   4.296740774733205D-08,   8.091827653178076D-08, &
&   -3.027048361902983D-05,   7.358984534510072D-04,  -1.142202763290988D-02, &
&    1.472190939168990D-01,                                                   &
&    4.131149949512743D-16,  -5.653972784608623D-15,  -1.642875409702556D-14, &
&    6.929251494144957D-13,  -1.336677595934241D-12,  -8.168922556269490D-11, &
&    9.371255413179261D-10,  -4.935184531307883D-09,   1.195057940508702D-07, &
&   -4.066110335137281D-06,   8.261162360427407D-05,  -1.229927820460135D-03, &
&    1.570650254864482D-02,                                                   &
&   -3.200308440646006D-14,   2.401363588182507D-13,   1.117498732932893D-12, &
&   -4.407305117267567D-11,   4.239167147893263D-10,   7.073265911699256D-11, &
&   -5.478433577419265D-08,   7.401271603398188D-07,  -3.373186211975339D-06, &
&   -5.408064734000877D-05,   1.603881788504822D-03,  -2.701005278418462D-02, &
&    3.930353490200198D-01,                                                   &
&   -2.374462860668507D-16,   3.559513079904698D-14,  -3.140596776097044D-13, &
&   -1.186037270161661D-12,   4.485427259253125D-11,  -2.357241316070265D-10, &
&   -3.211949453203584D-09,   4.318320095143587D-08,   5.901186520379682D-07, &
&   -2.757831012650697D-05,   5.602516268517491D-04,  -8.835116696397060D-03, &
&    1.270793311962213D-01,                                                   &
&    3.487931054741021D-17,   2.601795412516119D-15,  -2.786478948551899D-14, &
&   -8.049355906833943D-14,   4.370182322800486D-12,  -3.722385345383920D-11, &
&   -2.273069474748135D-12,  -7.124113116235588D-12,   1.044025401321378D-07, &
&   -3.202388575937509D-06,   6.085877973979947D-05,  -9.447018574572846D-04, &
&    1.354636819202594D-02,                                                   &
&    3.041201787525870D-16,  -8.048144567416357D-14,   1.289222972529424D-12, &
&   -8.882752743968256D-12,  -4.844650515678006D-11,   2.177823041053159D-09, &
&   -3.025765402905308D-08,   2.029484007823881D-07,   1.079384582492351D-06, &
&   -5.964024912969492D-05,   1.245125068068201D-03,  -2.130237186569850D-02, &
&    3.449644288401073D-01,                                                   &
&   -1.003522812797138D-15,   1.867386149914673D-15,   1.175082995202393D-13, &
&   -1.732504842200759D-12,   5.608885378500481D-12,   1.739611855386188D-10, &
&   -2.863279109773021D-09,   9.882156439527301D-10,   8.058855175418104D-07, &
&   -2.170533361078619D-05,   4.115422580293412D-04,  -6.903391776731726D-03, &
&    1.114400764782290D-01,                                                   &
&   -9.062235184334740D-17,   3.262119267249098D-16,   9.202224752620012D-15, &
&   -1.679603704768267D-13,   9.993071228800600D-13,   7.326893046590910D-12, &
&   -1.443614565934882D-10,  -1.514487389354885D-09,   9.807731396854198D-08, &
&   -2.381581331460598D-06,   4.413119269065268D-05,  -7.363680261785565D-04, &
&    1.187644684442634D-02,                                                   &
&    2.064562258906130D-15,  -2.372362411393915D-14,   8.929212039280867D-14, &
&    2.553550860438444D-12,  -6.924260075346666D-11,   9.735690302890253D-10, &
&   -7.944880325892871D-09,  -8.685865147224681D-09,   1.827179376147736D-06, &
&   -4.662694708720860D-05,   9.235112262290992D-04,  -1.699167657274553D-02, &
&    3.068851543692067D-01,                                                   &
&    1.589480655246637D-16,  -3.993439733799814D-15,   4.001223432000394D-14, &
&    1.511515551035117D-14,  -7.215340988853524D-12,   1.184178113044525D-10, &
&   -5.875420661242001D-10,  -1.881871056078016D-08,   6.935265606396896D-07, &
&   -1.557690551841154D-05,   3.001636938833520D-04,  -5.492288817313832D-03, &
&    9.911858476548518D-02,                                                   &
&    1.001108236786253D-17,  -3.479388187982768D-16,   4.181781141610420D-15, &
&   -1.235478134926458D-14,  -4.452798519641660D-13,   7.925691498085962D-12, &
&   -1.133626567972060D-11,  -2.446207711258454D-09,   7.689170026608745D-08, &
&   -1.675503329394566D-06,   3.204580454088868D-05,  -5.854286662689902D-04, &
&    1.056269556388287D-02,                                                   &
&    2.808562827611320D-16,   6.415543317583395D-16,  -8.058240831394889D-14, &
&    1.784906127744073D-12,  -2.558264860337729D-11,   2.374520664075966D-10, &
&   -2.991943429781720D-10,  -4.791244147239119D-08,   1.469407670555902D-06, &
&   -3.319269864449719D-05,   6.855426225528278D-04,  -1.380053420290760D-02, &
&    2.762513872510593D-01,                                                   &
&    7.984375385610410D-17,  -5.577563158346444D-16,  -5.441160019953787D-15, &
&    2.296127847222264D-13,  -3.679855752960800D-12,   2.674657327733553D-11, &
&    3.576878513427540D-10,  -1.890258105058625D-08,   4.956138415526628D-07, &
&   -1.082151831020419D-05,   2.217674674161557D-04,  -4.457936501586111D-03, &
&    8.922051663733599D-02,                                                   &
&    7.646288200177117D-18,  -6.730817150014982D-17,  -1.904920746344157D-16, &
&    1.662467832451420D-14,  -2.772051272155576D-13,   1.503862428265923D-12, &
&    5.105191602920700D-11,  -2.116275509023970D-09,   5.346305095081758D-08, &
&   -1.156407026405956D-06,   2.364427835677706D-05,  -4.750857427957196D-04, &
&    9.507769583694091D-03,                                                   &
&   -5.047139683158323D-17,   1.877959621322767D-15,  -3.832003496422469D-14, &
&    5.651639152775202D-13,  -5.778395033863657D-12,   1.595955059619209D-11, &
&    1.110151717975041D-09,  -4.002824435454825D-08,   1.016335386178858D-06, &
&   -2.330626518525897D-05,   5.178684677066129D-04,  -1.141346159644376D-02, &
&    2.511489306008949D-01,                                                   &
&    2.624920621981402D-18,   2.036292797712865D-16,  -5.777117718203403D-15, &
&    9.174092017443824D-14,  -7.976582969549417D-13,  -5.645319881482088D-12, &
&    4.516637307593370D-10,  -1.360272516615765D-08,   3.322549443477640D-07, &
&   -7.545961590824698D-06,   1.673190923901960D-04,  -3.686300028113456D-03, &
&    8.111249178091693D-02,                                                   &
&    5.766001420058075D-19,   1.323515447499173D-17,  -4.561188460730828D-16, &
&    7.383535277118053D-15,  -5.503396166646821D-14,  -9.192672040062817D-13, &
&    5.097701541785716D-11,  -1.470850924282698D-09,   3.553651757663683D-08, &
&   -8.047555281883886D-07,   1.783248668186312D-05,  -3.928337695084056D-04, &
&    8.643715040378778D-03,                                                   &
&   -3.567716065682017D-17,   7.076900538723189D-16,  -1.074288167254544D-14, &
&    1.187106507423293D-13,  -4.450758364779327D-13,  -2.332746526560289D-11, &
&    9.620785228070425D-10,  -2.707398890629461D-08,   6.824953313690351D-07, &
&   -1.659798194491652D-05,   3.994896848708654D-04,  -9.592126927274798D-03, &
&    2.302220834867343D-01,                                                   &
&   -5.007302012641724D-18,   1.195740371915537D-16,  -1.907052637424890D-15, &
&    1.850864115420525D-14,   7.689007614032873D-14,  -9.672124092746374D-12, &
&    3.285584227619460D-10,  -8.869864826424260D-09,   2.211544341808401D-07, &
&   -5.363942419167514D-06,   1.290327617603473D-04,  -3.097947699777376D-03, &
&    7.435370921458615D-02,                                                   &
&   -3.830039422894949D-19,   9.946318993669917D-18,  -1.600977877369631D-16, &
&    1.395505004317550D-15,   1.488103216992195D-14,  -1.097706504463054D-12, &
&    3.558739756840685D-11,  -9.493649324686951D-10,   2.359184654341366D-08, &
&   -5.717212169226802D-07,   1.375070914842448D-05,  -3.301320543930082D-04, &
&    7.923464055032105D-03,                                                   &
&   -1.136799449726696D-17,   1.808251895361694D-16,  -2.108216165936633D-15, &
&    9.148313398327369D-15,   4.531265416448475D-13,  -2.072384552588011D-11, &
&    6.378855830126748D-10,  -1.751765675651521D-08,   4.628099053686252D-07, &
&   -1.208040797550292D-05,   3.143306281375140D-04,  -8.173496001393595D-03, &
&    2.125131165980227D-01,                                                   &
&   -2.098819460362242D-18,   3.428365765934444D-17,  -3.558027087365084D-16, &
&   -9.945011926445633D-16,   1.888103556974725D-13,  -7.093437639442332D-12, &
&    2.092796443635176D-10,  -5.680188684599345D-09,   1.496006495874240D-07, &
&   -3.902136079741122D-06,   1.015197829761566D-04,  -2.639757746111330D-03, &
&    6.863430777513122D-02,                                                   &
&   -1.810691262213861D-19,   2.961200655517025D-18,  -2.814657123079400D-17, &
&   -2.289344175842420D-16,   2.148169442407675D-14,  -7.690592812064699D-13, &
&    2.241128360084130D-11,  -6.060781034372208D-10,   1.594659766301371D-08, &
&   -4.158496862120505D-07,   1.081847179350843D-05,  -2.813045237633279D-04, &
&    7.313978244437189D-03,                                                   &
&   -2.678578366908016D-18,   3.343067022592185D-17,  -1.498829836649688D-16, &
&   -8.232050322958843D-15,   4.048598919620090D-13,  -1.346742950842249D-11, &
&    3.996551850699077D-10,  -1.139507169409919D-08,   3.206261737789360D-07, &
&   -8.987343411282067D-06,   2.516942058289225D-04,  -7.047616214313224D-03, &
&    1.973336865283273D-01,                                                   &
&   -5.346982658299351D-19,   5.957861957190163D-18,   1.446598329593579D-17, &
&   -3.401011879079348D-15,   1.385522481923900D-13,  -4.421556960001815D-12, &
&    1.296521433869421D-10,  -3.684146927961135D-09,   1.035732582193194D-07, &
&   -2.902697248561858D-06,   8.128875781539538D-05,  -2.276134248074332D-03, &
&    6.373187870399181D-02,                                                   &
&   -4.715172817769166D-20,   4.854072672734125D-19,   3.546490290518511D-18, &
&   -3.867113855188978D-16,   1.502538618367617D-14,  -4.736348944155039D-13, &
&    1.383630549594165D-11,  -3.927374395802275D-10,   1.103801910987610D-08, &
&   -3.093279587745363D-07,   8.662504859899140D-06,  -2.425550481642340D-04, &
&    6.791553378899356D-03,                                                   &
&   -4.639798780623438D-19,   2.103587913989127D-18,   1.405235561269719D-16, &
&   -7.238155608599443D-15,   2.574745842009576D-13,  -8.197720369096280D-12, &
&    2.507799152028284D-10,  -7.566149830237525D-09,   2.273032323438402D-07, &
&   -6.821053732644508D-06,   2.046411215500119D-04,  -6.139267984563514D-03, &
&    1.841781215056473D-01,                                                   &
&   -8.555263775167997D-20,  -2.348767809986787D-19,   5.696602445050242D-17, &
&   -2.471632173825250D-15,   8.453756642252244D-14,  -2.660154807004547D-12, &
&    8.109259457454482D-11,  -2.444271641383740D-09,   7.341473251155499D-08, &
&   -2.202978368401055D-06,   6.609197890971343D-05,  -1.982768924762364D-03, &
&    5.948309070607692D-02,                                                   &
&   -7.079427417139066D-21,  -5.478533720873015D-20,   6.456406817876445D-18, &
&   -2.679382120342216D-16,   9.056446038303858D-15,  -2.839189004489472D-13, &
&    8.645121354952045D-12,  -2.604965693235079D-10,   7.823537296048214D-09, &
&   -2.347598134929448D-07,   7.043058196476085D-06,  -2.112927077138158D-04, &
&    6.338783547599209D-03,                                                   &
&   -2.210396902286864D-20,  -2.236012892000734D-18,   1.192345630838905D-16, &
&   -4.495721462264659D-15,   1.526176008151845D-13,  -4.983471842118204D-12, &
&    1.604659420891495D-10,  -5.143487204198423D-09,   1.646542807724660D-07, &
&   -5.269315121413961D-06,   1.686198927459783D-04,  -5.395843006831791D-03, &
&    1.726669913907424D-01,                                                   &
&    4.755559528331690D-21,  -8.877278804622855D-19,   4.056683228292952D-17, &
&   -1.475393914781173D-15,   4.952860473882588D-14,  -1.611630258166583D-12, &
&    5.184164595623899D-11,  -1.661278216829434D-09,   5.317819130377711D-08, &
&   -1.701807185118329D-06,   5.445833589339098D-05,  -1.742668560647549D-03, &
&    5.576539823413140D-02,                                                   &
&    9.013623771962359D-22,  -1.002040514112789D-19,   4.393906283578042D-18, &
&   -1.580443809981263D-16,   5.286444608850862D-15,  -1.718194248946732D-13, &
&    5.525085112030733D-12,  -1.770373137562609D-10,   5.666928187280423D-09, &
&   -1.813522681886337D-07,   5.803323587600399D-06,  -1.857065378655148D-04, &
&    5.942609646289942D-03,                                                   &
&    3.372601932246039D-20,  -1.819053994517593D-18,   7.219938356547452D-17, &
&   -2.599311358377558D-15,   9.018636342699050D-14,  -3.086463356008487D-12, &
&    1.051364429185577D-10,  -3.576303938851239D-09,   1.216063045373118D-07, &
&   -4.134685499795733D-06,   1.405796427967213D-04,  -4.779709035923810D-03, &
&    1.625101099728149D-01,                                                   &
&    1.301251897102000D-20,  -6.165295516084718D-19,   2.367356039159339D-17, &
&   -8.434854131318570D-16,   2.916727707244807D-14,  -9.971776796906678D-13, &
&    3.395816717825517D-11,  -1.155039415638904D-09,   3.927468320658365D-08, &
&   -1.335359223109258D-06,   4.540230849549611D-05,  -1.543678824329536D-03, &
&    5.248508081262717D-02,                                                   &
&    1.459510235024377D-21,  -6.671343362202959D-20,   2.535350367292402D-18, &
&   -9.002886039882020D-17,   3.109652973704523D-15,  -1.062768024765430D-13, &
&    3.618836235320418D-12,  -1.230868366405947D-10,   4.185289253617590D-09, &
&   -1.423018534663696D-07,   4.838272620539721D-06,  -1.645013031046680D-04, &
&    5.593044385310032D-03,                                                   &
&    2.583543162360662D-20,  -1.074317772290400D-18,   4.077263556080669D-17, &
&   -1.497179758359081D-15,   5.425831093622608D-14,  -1.957224220547669D-12, &
&    7.049778005588794D-11,  -2.538234417473078D-09,   9.137866808792743D-08, &
&   -3.289645133649228D-06,   1.184272858537907D-04,  -4.263382503130907D-03, &
&    1.534817706027946D-01,                                                   &
&    8.711155384679478D-21,  -3.519321832183446D-19,   1.322823021432082D-17, &
&   -4.842053744691167D-16,   1.753020246381187D-14,  -6.321737644378947D-13, &
&    2.276876904263356D-11,  -8.197638967333007D-10,   2.951212949843150D-08, &
&   -1.062440374622202D-06,   3.824787089447690D-05,  -1.376923413044523D-03, &
&    4.956924301057716D-02,                                                   &
&    9.412687058053959D-22,  -3.768103200667810D-20,   1.411833641048606D-18, &
&   -5.162352643343579D-17,   1.868342492672270D-15,  -6.736944452880762D-14, &
&    2.426358567065517D-12,  -8.735781048917899D-11,   3.144944809622581D-09, &
&   -1.132183893253055D-07,   4.075863782653263D-06,  -1.467311023612482D-04, &
&    5.282319699358939D-03,                                                   &
&    1.484414866934963D-20,  -5.935440633453990D-19,   2.294280350151437D-17, &
&   -8.775811050689761D-16,   3.341739621602283D-14,  -1.270604795964321D-12, &
&    4.829002606329580D-11,  -1.835078952143804D-09,   6.973340637756675D-08, &
&   -2.649871800629235D-06,   1.006951393181874D-04,  -3.826415331648513D-03, &
&    1.454037826885632D-01,                                                   &
&    4.856290353235177D-21,  -1.925255225821239D-19,   7.419689027790747D-18, &
&   -2.835379413186522D-16,   1.079373744407695D-14,  -4.103704266277678D-13, &
&    1.559606194460098D-11,  -5.926667840051612D-10,   2.252145351342536D-08, &
&   -8.558159084601323D-07,   3.252100765272496D-05,  -1.235798301640769D-03, &
&    4.696033548723198D-02,                                                   &
&    5.197528411590141D-22,  -2.054672625744736D-20,   7.910424296998218D-19, &
&   -3.021915431429282D-17,   1.150269553514570D-15,  -4.373126294632388D-14, &
&    1.661988708831902D-12,  -6.315723495920545D-11,   2.399986669777796D-09, &
&   -9.119956204769449D-08,   3.465583676536331D-06,  -1.316921808130674D-04, &
&    5.004302873436368D-03,                                                   &
&    8.028628199290463D-21,  -3.269211764737481D-19,   1.313517454867430D-17, &
&   -5.265015771586412D-16,   2.107307444890921D-14,  -8.430605126881992D-13, &
&    3.372370732511842D-11,  -1.348958764873949D-09,   5.395842323503712D-08, &
&   -2.158337347167592D-06,   8.633349579977674D-05,  -3.453339838532743D-03, &
&    1.381335935561616D-01,                                                   &
&    2.603286660465377D-21,  -1.057209913112779D-19,   4.243828950881349D-18, &
&   -1.700594106488076D-16,   6.806040959063895D-15,  -2.722805785561376D-13, &
&    1.089158935977046D-11,  -4.356665686938366D-10,   1.742668360862066D-08, &
&   -6.970674648013226D-07,   2.788269914571276D-05,  -1.115307967728287D-03, &
&    4.461231871345859D-02,                                                   &
&    2.777976541627324D-22,  -1.127118193833465D-20,   4.523022444358250D-19, &
&   -1.812296133396977D-17,   7.252887356749265D-16,  -2.901549148593705D-14, &
&    1.160656801901793D-12,  -4.642657628367591D-11,   1.857065174066805D-09, &
&   -7.428261923782755D-08,   2.971304826011019D-06,  -1.188521932345497D-04, &
&    4.754087729824637D-03,                                                   &
&    4.335696961662655D-21,  -1.831864347827986D-19,   7.695621413224245D-18, &
&   -3.234191630971574D-16,   1.358599971358071D-14,  -5.706368936494733D-13, &
&    2.396698012321077D-11,  -1.006615023687665D-09,   4.227784377203153D-08, &
&   -1.775669511300952D-06,   7.457811980578394D-05,  -3.132281032967088D-03, &
&    1.315558033871527D-01,                                                   &
&    1.401965197815389D-21,  -5.918501785629766D-20,   2.485678618620228D-18, &
&   -1.044559286969986D-16,   4.387830522184059D-15,  -1.842959965999881D-13, &
&    7.740498021398383D-12,  -3.251014523619808D-10,   1.365426469446486D-08, &
&   -5.734791383181905D-07,   2.408612390578806D-05,  -1.011617204371444D-03, &
&    4.248792258434321D-02,                                                   &
&    1.494627287766418D-22,  -6.307855972015311D-21,   2.648949454572150D-19, &
&   -1.113139868996674D-17,   4.675878674051691D-16,  -1.963941298607036D-14, &
&    8.248620758134188D-13,  -3.464426173470113D-11,   1.455059369838381D-09, &
&   -6.111249569375256D-08,   2.566724828999305D-06,  -1.078024428515905D-04, &
&    4.527702599842912D-03,                                                   &
&    2.382432873692564D-21,  -1.050206440901396D-19,   4.616083502481410D-18, &
&   -2.031445601469207D-16,   8.938797226902085D-15,  -3.933115065167947D-13, &
&    1.730574691202423D-11,  -7.614531888303901D-10,   3.350394252329844D-08, &
&   -1.474173483564503D-06,   6.486363333342479D-05,  -2.853999866861550D-03, &
&    1.255759941423360D-01,                                                   &
&    7.697144343337419D-22,  -3.392155223774415D-20,   1.490875233656224D-18, &
&   -6.560903853878007D-17,   2.886923209410358D-15,  -1.270258961336991D-13, &
&    5.589151170570392D-12,  -2.459227456828559D-10,   1.082060145457632D-08, &
&   -4.761064676619282D-07,   2.094868459369235D-05,  -9.217421221784971D-04, &
&    4.055665337597979D-02,                                                   &
&    8.203451042814503D-23,  -3.614967643998460D-21,   1.588759182588745D-19, &
&   -6.991609305523791D-18,   3.076435880966575D-16,  -1.353644772014122D-14, &
&    5.956048971070782D-13,  -2.620662509060439D-11,   1.153091569890728D-09, &
&   -5.073602944992470D-08,   2.232385297494553D-06,  -9.822495309550865D-05, &
&    4.321897936215310D-03,                                                   &
&    1.339215187771483D-21,  -6.163432254247360D-20,   2.831351735796947D-18, &
&   -1.302487659947485D-16,   5.991524025966065D-15,  -2.756108801068937D-13, &
&    1.267810753460085D-11,  -5.831930025340401D-10,   2.682687849547873D-08, &
&   -1.234036412923254D-06,   5.676567500402804D-05,  -2.611221050217341D-03, &
&    1.201161683100691D-01,                                                   &
&    4.325629955282987D-22,  -1.990629402110613D-20,   9.144341472168908D-19, &
&   -4.206586609908599D-17,   1.935053358562179D-15,  -8.901267910547135D-14, &
&    4.094585289103650D-12,  -1.883509396210304D-10,   8.664143333451485D-09, &
&   -3.985505939641874D-07,   1.833332732516492D-05,  -8.433330569670399D-04, &
&    3.879332062050496D-02,                                                   &
&    4.609750448649055D-23,  -2.121325247121436D-21,   9.744643770975863D-20, &
&   -4.482729138234634D-18,   2.062079463860751D-16,  -9.485588466401441D-15, &
&    4.363372790430952D-13,  -2.007151650654490D-11,   9.232897706624855D-10, &
&   -4.247132951462291D-08,   1.953681157961392D-06,  -8.986933326719555D-05, &
&    4.133989330293168D-03,                                                   &
&    7.705015340669327D-22,  -3.698679239000214D-20,   1.772954825313244D-18, &
&   -8.510299415837570D-17,   4.084959948309810D-15,  -1.960782111948911D-13, &
&    9.411755343585137D-12,  -4.517642660107380D-10,   2.168468483258480D-08, &
&   -1.040864872322310D-06,   4.996151387306858D-05,  -2.398152665912621D-03, &
&    1.151113279638177D-01,                                                   &
&    2.488518786263332D-22,  -1.194552862924872D-20,   5.726034173523258D-19, &
&   -2.748530117983000D-17,   1.319299274936284D-15,  -6.332640417767583D-14, &
&    3.039667753282773D-12,  -1.459040549495828D-10,   7.003394656422835D-09, &
&   -3.361629436139184D-07,   1.613582129394027D-05,  -7.745194221107115D-04, &
&    3.717693226131766D-02,                                                   &
&    2.651903129800151D-23,  -1.272972273930063D-21,   6.101921515579206D-20, &
&   -2.928956758598367D-18,   1.405904212732392D-16,  -6.748344209878741D-15, &
&    3.239205582086268D-13,  -1.554818708033667D-11,   7.463129817904375D-10, &
&   -3.582302313679367D-08,   1.719505110614656D-06,  -8.253624530966597D-05, &
&    3.961739774864328D-03/
      data w3 / &
&    3.868827509310109D-11,  -7.388321507754036D-10,   9.506804287914735D-09, &
&   -1.054720132737987D-07,   1.051510444728896D-06,  -9.387274842528370D-06, &
&    7.406731714305720D-05,  -5.071895310983571D-04,   2.939644187436461D-03, &
&   -1.390542733231439D-02,   5.066596580821731D-02,  -1.277684551509877D-01, &
&    1.713244923791703D-01,                                                   &
&    1.373854876541524D-11,  -2.619478100768938D-10,   3.391693977084739D-09, &
&   -3.833304852717840D-08,   3.951302402918319D-07,  -3.710904410242091D-06, &
&    3.145901952445133D-05,  -2.377897650138422D-04,   1.576287809109948D-03, &
&   -8.944302601179112D-03,   4.179204194717199D-02,  -1.490771864588977D-01, &
&    3.607615730481386D-01,                                                   &
&    3.828284000169705D-13,  -7.205906679304306D-12,   9.363460039771964D-11, &
&   -1.096181932201160D-09,   1.217785416267623D-08,  -1.292853750838514D-07, &
&    1.311253690815223D-06,  -1.259645771294675D-05,   1.136976325346783D-04, &
&   -9.597938759825199D-04,   7.541992244608537D-03,  -5.648769172344789D-02, &
&    4.679139345726910D-01,                                                   &
&    9.883983545296825D-12,  -1.302784818651687D-10,   1.554366224531166D-09, &
&   -1.728803898797702D-08,   1.746982175633952D-07,  -1.586665613969338D-06, &
&    1.278331033728923D-05,  -8.979714116357959D-05,   5.371895110700121D-04, &
&   -2.645527355495134D-03,   1.016721377221657D-02,  -2.758580306190215D-02, &
&    4.177457074923189D-02,                                                   &
&    3.479796280605099D-12,  -4.654557127793238D-11,   5.714468193272214D-10, &
&   -6.635746215710758D-09,   7.125685683535449D-08,  -7.025770496256545D-07, &
&    6.314784655109994D-06,  -5.128510056549798D-05,   3.711057300106859D-04, &
&   -2.345691532340330D-03,   1.255444397669255D-02,  -5.311392916022090D-02, &
&    1.774551806595106D-01,                                                   &
&    9.328436943967830D-14,  -1.273444301907290D-12,   1.658614114869325D-11, &
&   -2.121577317604776D-10,   2.607578447060597D-09,  -3.117544409456387D-08, &
&    3.586213793767893D-07,  -3.895505018268115D-06,   4.042976817974200D-05, &
&   -3.995640675930944D-04,   3.749749667578366D-03,  -3.500244863404680D-02, &
&    3.789142552525616D-01,                                                   &
&    1.593569700364999D-12,  -2.123205047745220D-11,   2.567991209266374D-10, &
&   -2.902286137669146D-09,   2.989441134504351D-08,  -2.777666022842975D-07, &
&    2.300544921660371D-06,  -1.672131287061767D-05,   1.044024181838825D-04, &
&   -5.436016323345308D-04,   2.252831488968895D-03,  -6.767635975884266D-03, &
&    1.248139774674268D-02,                                                   &
&    5.747068674066313D-13,  -7.947917094104772D-12,   1.012614326747192D-10, &
&   -1.228446154010855D-09,   1.387838441156052D-08,  -1.450992537254863D-07, &
&    1.403158617890838D-06,  -1.244336533024293D-05,   9.957689965809671D-05, &
&   -7.121426171700860D-04,   4.430044878428842D-03,  -2.231403227053954D-02, &
&    1.073056984245712D-01,                                                   &
&    1.596662486043826D-14,  -2.326134098179473D-13,   3.444621556772518D-12, &
&   -4.745398210572953D-11,   6.466735536017924D-10,  -8.927799360480948D-09, &
&    1.131280982166967D-07,  -1.366071075989621D-06,   1.650752613043870D-05, &
&   -1.882822488678010D-04,   2.080014713598681D-03,  -2.375896381513529D-02, &
&    3.212535992098970D-01,                                                   &
&    2.620556676753231D-13,  -3.541318066966703D-12,   4.359974226305671D-11, &
&   -5.034761209614029D-10,   5.314072823804888D-09,  -5.084006301739609D-08, &
&    4.369547663064490D-07,  -3.323370830705713D-06,   2.196036312057625D-05, &
&   -1.235186515316576D-04,   5.673032043050342D-04,  -1.934054694136188D-03, &
&    4.862068796705688D-03,                                                   &
&    1.015254725854706D-13,  -1.428881449096919D-12,   1.921054511533435D-11, &
&   -2.475935981077958D-10,   2.940065097349283D-09,  -3.304363687477582D-08, &
&    3.517564776712766D-07,  -3.420921511779832D-06,   3.038556509857992D-05, &
&   -2.504678700656166D-04,   1.811004930313694D-03,  -1.073234729213110D-02, &
&    7.596995816517389D-02,                                                   &
&    1.788034104600528D-15,  -6.287300418987855D-14,   8.417378655898838D-13, &
&   -1.040518781768078D-11,   2.004048088796947D-10,  -3.013127907236540D-09, &
&    3.759950937511912D-08,  -5.421296863784308D-07,   7.705923279397784D-06, &
&   -9.681551193260709D-05,   1.259341724447156D-03,  -1.726104761181531D-02, &
&    2.807761203917789D-01,                                                   &
&    4.389469474910282D-14,  -6.059251185155152D-13,   7.708574790059178D-12, &
&   -9.103268334350781D-11,   9.869499959779024D-10,  -9.859467850361469D-09, &
&    8.909070349431189D-08,  -7.149886050501526D-07,   5.096308866603739D-06, &
&   -3.196524545535928D-05,   1.656966738055991D-04,  -6.446137900144540D-04, &
&    2.542639569993729D-03,                                                   &
&    1.600633987771907D-14,  -2.824794580839878D-13,   4.240532938071875D-12, &
&   -5.261432448303294D-11,   6.659733567537667D-10,  -8.689369348091782D-09, &
&    1.005105458163203D-07,  -1.035916312643999D-06,   1.053339069081586D-05, &
&   -1.022609471324787D-04,   8.303088950134837D-04,  -5.740019174041315D-03, &
&    6.014116575384055D-02,                                                   &
&    3.610040646947125D-15,  -1.311233396936090D-14,  -1.067432649983054D-13, &
&   -4.726774289995562D-12,   9.344728129649104D-11,  -7.908647653313205D-10, &
&    1.285765723271963D-08,  -2.701475298976533D-07,   3.888278836244111D-06, &
&   -5.221110100896444D-05,   8.273387124968785D-04,  -1.317619357928201D-02, &
&    2.506248819974729D-01,                                                   &
&    7.858903801519921D-15,  -1.139329758344486D-13,   1.396001069550715D-12, &
&   -1.679445492484623D-11,   1.970939487931019D-10,  -2.090294777778680D-09, &
&    1.952543915051096D-08,  -1.673844804557607D-07,   1.352490097758598D-06, &
&   -9.684595873347121D-06,   5.519734656787337D-05,  -2.460043196724184D-04, &
&    1.723790695058590D-03,                                                   &
&    6.099930424129328D-15,  -8.030705205468825D-14,   6.523842435201937D-13, &
&   -1.048596848552818D-11,   2.037110926781792D-10,  -2.711421713319922D-09, &
&    2.894235941140582D-08,  -3.401847812330238D-07,   4.352426660483818D-06, &
&   -4.724944091628878D-05,   4.059474241928824D-04,  -3.375734945440191D-03, &
&    5.130512814985992D-02,                                                   &
&   -2.364712803519455D-15,   2.305028414419042D-14,   3.153679475424775D-13, &
&   -4.185206584513634D-12,  -1.372751944913465D-12,  -5.942299361690164D-11, &
&    8.733334640993653D-09,  -1.508369867480735D-07,   1.820893090282898D-06, &
&   -3.015616933067941D-05,   5.884776956584826D-04,  -1.038836026373140D-02, &
&    2.272184716617242D-01,                                                   &
&    1.451133217394157D-15,  -1.649908396244598D-14,   2.513394268140308D-13, &
&   -3.761954600448622D-12,   4.481497713051511D-11,  -4.515009341627021D-10, &
&    4.455681317500300D-09,  -4.563020366830214D-08,   4.327700823174705D-07, &
&   -3.326197477456999D-06,   1.972937696314058D-05,  -1.085595498035463D-04, &
&    1.392403367873191D-03,                                                   &
&    3.230886448271774D-16,   9.260785442719151D-15,   1.623163981462584D-13, &
&   -5.751586341667417D-12,   7.050617681758680D-11,  -6.146773311490114D-10, &
&    8.100711119083047D-09,  -1.470292963943698D-07,   2.119928249158501D-06, &
&   -2.260905788898280D-05,   2.051407178253089D-04,  -2.202346428691282D-03, &
&    4.585975790056585D-02,                                                   &
&    4.770079665602913D-16,  -2.773556929093804D-14,   1.009691779338853D-13, &
&    2.121933633526565D-12,  -1.243320421782978D-11,  -3.320601363046301D-10, &
&    6.169578559704890D-09,  -5.713519024122897D-08,   8.063429681185768D-07, &
&   -2.027788751259366D-05,   4.412135839047877D-04,  -8.348480951381410D-03, &
&    2.085792692609440D-01,                                                   &
&    1.318071564385722D-16,  -4.657405413391522D-15,   7.642988287639177D-14, &
&   -8.486234916602149D-13,   8.255972771271838D-12,  -9.523010430248661D-11, &
&    1.293035224686415D-09,  -1.593634846764782D-08,   1.552500172413661D-07, &
&   -1.165785800977774D-06,   7.339704802076483D-06,  -5.866661026282984D-05, &
&    1.233293498220938D-03,                                                   &
&   -4.135281496350093D-16,  -9.126468558384776D-15,   1.863076611649713D-13, &
&   -1.420628203000360D-12,   5.166645030208837D-12,  -1.176042431926451D-10, &
&    4.197414031187039D-09,  -7.989089939311886D-08,   1.021912300351595D-06, &
&   -1.048059599341568D-05,   1.102353917397363D-04,  -1.595677045704219D-03, &
&    4.212442442328626D-02,                                                   &
&    7.532024582821228D-16,   5.980343200964230D-15,  -1.386880095501646D-13, &
&    3.205513707241346D-13,   1.667878922099915D-11,  -2.476790455745515D-10, &
&    1.541513273470916D-09,  -1.219994404891423D-08,   5.071103379691457D-07, &
&   -1.532177899743374D-05,   3.355731576327534D-04,  -6.804700931531221D-03, &
&    1.934963620571635D-01,                                                   &
&    1.106919592750208D-16,  -1.344929940745988D-15,   1.109281258730949D-14, &
&   -9.923606300496160D-14,   1.682749677772246D-12,  -3.309235781431689D-11, &
&    5.101731722653407D-10,  -5.939126413749617D-09,   5.347673292538520D-08, &
&   -3.964580445450790D-07,   3.054058920402667D-06,  -3.939168730362316D-05, &
&    1.138039160724380D-03,                                                   &
&    3.981782192896481D-16,  -3.953907956480181D-15,   5.258271796430440D-15, &
&    2.518470927851613D-13,   2.870522208666207D-13,  -1.128467534046380D-10, &
&    2.653971179216749D-09,  -3.874192566013579D-08,   4.440616449630228D-07, &
&   -4.891141706098743D-06,   6.641936842162798D-05,  -1.253436631886133D-03, &
&    3.930421556601466D-02,                                                   &
&   -4.009476702492643D-16,   3.373655490477389D-15,   1.707313171913926D-14, &
&   -7.318686900381387D-13,   8.008090814734359D-12,  -2.583881500844015D-11, &
&   -1.922558053020772D-10,  -7.277165563620958D-09,   4.266842652545737D-07, &
&   -1.161515084717772D-05,   2.550706376536049D-04,  -5.630815912442042D-03, &
&    1.811144732206532D-01,                                                   &
&    1.298242822189041D-17,  -4.571067477736487D-17,   4.702758926586637D-16, &
&   -2.937299585303667D-14,   8.167633486856580D-13,  -1.455684478098288D-11, &
&    1.917480959319806D-10,  -1.983263718924757D-09,   1.701967031791377D-08, &
&   -1.405060715107406D-07,   1.586480815104938D-06,  -3.061215620303390D-05, &
&    1.068994737402020D-03,                                                   &
&    2.509528752431274D-17,   6.867195511355064D-16,  -1.230506085259194D-14, &
&    1.597083278652838D-14,   3.115005508341381D-12,  -7.918523847221485D-11, &
&    1.255572791762864D-09,  -1.577490397340525D-08,   1.855709344441531D-07, &
&   -2.525060068372233D-06,   4.519341346298197D-05,  -1.034882366964764D-03, &
&    3.702991149804975D-02,                                                   &
&   -1.081556111450183D-17,  -1.169596563717623D-15,   2.191724724267493D-14, &
&   -1.798435925061445D-13,  -2.264053999881670D-13,   2.239765111172887D-11, &
&   -6.270944176456444D-11,  -9.442104019050668D-09,   3.414853386507573D-07, &
&   -8.527215886031752D-06,   1.949857204796430D-04,  -4.736885307677635D-03, &
&    1.707867829049635D-01,                                                   &
&   -1.561608423220481D-18,   3.782335170912339D-18,   6.219090115374417D-16, &
&   -1.943104192810460D-14,   3.698030410771757D-13,  -5.299661130781429D-12, &
&    6.112928646589176D-11,  -5.949442354416900D-10,   5.418034297474412D-09, &
&   -5.983916368261152D-08,   1.030825891393424D-06,  -2.553527241490065D-05, &
&    1.013211753060951D-03,                                                   &
&   -2.436522713436016D-17,   2.815637927414439D-16,   3.399640777795217D-16, &
&   -8.486547507373710D-14,   2.105758300345136D-12,  -3.509625197115927D-11, &
&    4.759085416528499D-10,  -6.009645845490779D-09,   8.440295163421981D-08, &
&   -1.509431129072400D-06,   3.348842258797242D-05,  -8.795243896035339D-04, &
&    3.512325529090349D-02,                                                   &
&    3.355560291001359D-17,  -4.467463214599274D-16,   2.422486618234546D-15, &
&    3.274765786968130D-14,  -9.573711468139860D-13,   7.980591974531577D-12, &
&    1.613585091466339D-10,  -8.634709666856046D-09,   2.488396619582605D-07, &
&   -6.171593591244448D-06,   1.512616908519827D-04,  -4.049099407202066D-03, &
&    1.620298977860092D-01,                                                   &
&    1.581656498885726D-20,  -1.434710971463409D-17,   4.257158964027415D-16, &
&   -8.297488157468876D-15,   1.266179037396435D-13,  -1.598630631018076D-12, &
&    1.735613581333929D-11,  -1.750854455651710D-10,   1.996609044128695D-09, &
&   -3.291201311630431D-08,   7.659181679398347D-07,  -2.199455758137315D-05, &
&    9.658567680974034D-04,                                                   &
&   -3.930998224793111D-18,  -3.293781782920294D-17,   2.089277560268023D-15, &
&   -4.930212794836975D-14,   8.515376960864951D-13,  -1.234498709865526D-11, &
&    1.673973289138386D-10,  -2.465724440304440D-09,   4.506392002646419D-08, &
&   -1.014770074904778D-06,   2.607076108675149D-05,  -7.613861335948926D-04, &
&    3.348726935385214D-02,                                                   &
&    6.273895159201744D-18,  -7.144902940402404D-18,  -1.264499951010295D-15, &
&    2.860028529770492D-14,  -3.022251579610816D-13,  -1.921906321947191D-12, &
&    1.911672089192285D-10,  -6.381497605033264D-09,   1.734860565736644D-07, &
&   -4.497495849768070D-06,   1.195560461976230D-04,  -3.510806015073891D-03, &
&    1.544910892320042D-01,                                                   &
&    3.060094144431594D-19,  -8.320902698631522D-18,   1.640960133511060D-16, &
&   -2.641142120401779D-15,   3.608261772804335D-14,  -4.315817190711772D-13, &
&    4.805008467469210D-12,  -5.808196443145763D-11,   9.529879930676792D-10, &
&   -2.187257765460928D-08,   6.056422319886867D-07,  -1.927321566310202D-05, &
&    9.246953072524998D-04,                                                   &
&    1.134205652203668D-18,  -4.444730268810807D-17,   1.012577987393774D-15, &
&   -1.807369774038602D-14,   2.786884104340737D-13,  -4.053295293782708D-12, &
&    6.317548780918736D-11,  -1.196270320253401D-09,   2.777514214923277D-08, &
&   -7.317260772957862D-07,   2.089961797160576D-05,  -6.680081643059803D-04, &
&    3.206131341802735D-02,                                                   &
&   -6.403534210849855D-19,   3.270365022560559D-17,  -6.743065375643071D-16, &
&    8.017950759378530D-15,   7.937701299594280D-15,  -3.776965788609045D-12, &
&    1.455603950752861D-10,  -4.336565106594824D-09,   1.203631750671769D-07, &
&   -3.335763758208252D-06,   9.626838107050908D-05,  -3.081475153386012D-03, &
&    1.479143049135160D-01,                                                   &
&    1.436129464876938D-19,  -2.892533836368937D-18,   4.861486813182461D-17, &
&   -7.132983713677984D-16,   9.310882727291481D-15,  -1.137453739696618D-13, &
&    1.474769150440293D-12,  -2.472728268624687D-11,   5.712808911590174D-10, &
&   -1.599217282916956D-08,   4.935492658377677D-07,  -1.708650777811576D-05, &
&    8.884101137332379D-04,                                                   &
&    8.207075070014217D-19,  -1.841676827578068D-17,   3.387140966710303D-16, &
&   -5.539275690637743D-15,   8.627263461621474D-14,  -1.429696108165982D-12, &
&    2.831145564968304D-11,  -6.832557011681658D-10,   1.871918261640040D-08, &
&   -5.491214683086196D-07,   1.709302821389999D-05,  -5.923867401593681D-04, &
&    3.080345146175807D-02,                                                   &
&   -6.697113478724101D-19,   1.331371441630820D-17,  -1.704404253002315D-16, &
&    3.159273740266126D-16,   6.785754429230279D-14,  -2.989391531004488D-12, &
&    9.713364466813303D-11,  -2.891929911590770D-09,   8.470704379204814D-08, &
&   -2.525098125981239D-06,   7.882803016528481D-05,  -2.732899818792995D-03, &
&    1.421115378996027D-01,                                                   &
&    4.527451216514875D-20,  -8.051489719361149D-19,   1.250873194613224D-17, &
&   -1.768597003337232D-16,   2.356712501828873D-15,  -3.292321714879003D-14, &
&    5.739931488223676D-13,  -1.353159253045564D-11,   3.887457965761153D-10, &
&   -1.222526115287827D-08,   4.096201814055261D-07,  -1.528767367443583D-05, &
&    8.560917889675598D-04,                                                   &
&    2.968266903666248D-19,  -5.703264961462782D-18,   9.799772289289115D-17, &
&   -1.631467330411258D-15,   2.881649791672222D-14,  -6.005782437093720D-13, &
&    1.514583437078844D-11,  -4.338657687551357D-10,   1.326316124688638D-08, &
&   -4.228396982155366D-07,   1.419886583656841D-05,  -5.300548591132209D-04, &
&    2.968293641378204D-02,                                                   &
&   -2.254150255864592D-19,   3.099469475098442D-18,  -1.088349474315867D-17, &
&   -1.128032195938404D-15,   5.588269543102368D-14,  -1.966577402804784D-12, &
&    6.268262410057226D-11,  -1.947441684751087D-09,   6.085419981221168D-08, &
&   -1.949130476476016D-06,   6.550048069554292D-05,  -2.445392224747452D-03, &
&    1.369421182199080D-01,                                                   &
&    1.190138125826032D-20,  -1.988007492936950D-19,   2.994998741807055D-18, &
&   -4.328789004875612D-17,   6.522120542213621D-16,  -1.195585765390110D-14, &
&    2.906366439040403D-13,  -8.628786860234351D-12,   2.807167389110606D-10, &
&   -9.579721276656246D-09,   3.446351527318083D-07,  -1.378444122565068D-05, &
&    8.270629402223661D-04,                                                   &
&    8.580453542154029D-20,  -1.572328093350448D-18,   2.768397261000535D-17, &
&   -5.216756172565838D-16,   1.149287198850323D-14,  -3.040404027468565D-13, &
&    9.129291640847961D-12,  -2.922947520836606D-10,   9.691898956960764D-09, &
&   -3.319578652845824D-07,   1.194871077607484D-05,  -4.779410951123013D-04, &
&    2.867643866728244D-02,                                                   &
&   -4.846098420979953D-20,   2.298735010667022D-19,   1.760051749882141D-17, &
&   -9.596667979491664D-16,   3.628468934870141D-14,  -1.233757724427351D-12, &
&    4.064905648287892D-11,  -1.337697851615893D-09,   4.464809775604847D-08, &
&   -1.531172591161177D-06,   5.512422047855792D-05,  -2.204977119987823D-03, &
&    1.322986577721353D-01,                                                   &
&    2.829510378446810D-21,  -4.620779842912688D-20,   7.128312523239318D-19, &
&   -1.157291572698616D-17,   2.246267119278277D-16,  -5.676967580604473D-15, &
&    1.749449766061711D-13,  -5.921171510709943D-12,   2.091085945313572D-10, &
&   -7.638357363214269D-09,   2.932664412676656D-07,  -1.251251360983270D-05, &
&    8.008001931763266D-04,                                                   &
&    2.266805447219607D-20,  -4.290754862064207D-19,   8.552008563164151D-18, &
&   -1.997145701540347D-16,   5.558189164512773D-15,  -1.751677254713628D-13, &
&    5.883557627412152D-12,  -2.040010018765135D-10,   7.242661833620938D-09, &
&   -2.648058811844621D-07,   1.016819076546375D-05,  -4.338413618982644D-04, &
&    2.776584192224914D-02,                                                   &
&   -3.526747107845312D-21,  -2.581855691301961D-19,   1.525207173907707D-17, &
&   -6.145477039303982D-16,   2.219853283947633D-14,  -7.742521766811676D-13, &
&    2.685560620434175D-11,  -9.390794527899214D-10,   3.340162078345994D-08, &
&   -1.221622640349956D-06,   4.691071094420407D-05,  -2.001525298936038D-03, &
&    1.280976250490119D-01,                                                   &
&    6.403340397890549D-22,  -1.074353258101152D-20,   1.855922311197358D-19, &
&   -3.829976763692024D-18,   1.012664630249959D-16,  -3.249797262115115D-15, &
&    1.147041962214990D-13,  -4.216759904349183D-12,   1.590168998413178D-10, &
&   -6.177173766959730D-09,   2.520197378010978D-07,  -1.142485909911353D-05, &
&    7.768902916449025D-04,                                                   &
&    6.012264402809011D-21,  -1.288783340274210D-19,   3.172166129661634D-18, &
&   -9.305901108747217D-17,   3.080398661688163D-15,  -1.085686765441062D-13, &
&    3.943074582844200D-12,  -1.459666280060470D-10,   5.512137665452651D-09, &
&   -2.141723490838607D-07,   8.738162751200979D-06,  -3.961297678732468D-04, &
&    2.693682322447710D-02,                                                   &
&    3.641458505829608D-21,  -2.255161342982635D-19,   9.614431663279641D-18, &
&   -3.673793536764238D-16,   1.353204024665267D-14,  -4.943319300597278D-13, &
&    1.813665155038439D-11,  -6.730282110623129D-10,   2.542795029272873D-08, &
&   -9.880728373874403D-07,   4.031344980889035D-05,  -1.827543370532668D-03, &
&    1.242729503142216D-01,                                                   &
&    1.460376235996540D-22,  -2.737979053184390D-21,   5.964581517359279D-20, &
&   -1.657461755036593D-18,   5.553397523671381D-17,  -2.046214499809095D-15, &
&    7.847233250885407D-14,  -3.074410164543396D-12,   1.229216991391298D-10, &
&   -5.057012836644478D-09,   2.184612708434386D-07,  -1.048613437009687D-05, &
&    7.550016512910530D-04,                                                   &
&    1.770113102062412D-21,  -4.658950460952798D-20,   1.434835340944700D-18, &
&   -4.990007288900573D-17,   1.844812714168660D-15,  -7.018901163841411D-14, &
&    2.714646106461356D-12,  -1.065547739617139D-10,   4.261769350853267D-09, &
&   -1.753387557061077D-07,   7.574621134733375D-06,  -3.635817625959913D-04, &
&    2.617788672341722D-02,                                                   &
&    3.120739484276024D-21,  -1.398480788639310D-19,   5.623653347862565D-18, &
&   -2.181824435008102D-16,   8.381527766218890D-15,  -3.225887558997361D-13, &
&    1.251390364595403D-11,  -4.915193197483739D-10,   1.966124910607053D-08, &
&   -8.089229121693595D-07,   3.494548460120961D-05,  -1.677383319359737D-03, &
&    1.207715992007514D-01,                                                   &
&    3.668955221176318D-23,  -8.595972462158386D-22,   2.501443639027081D-20, &
&   -8.767319164207838D-19,   3.373778128611441D-17,  -1.350466979859933D-15, &
&    5.509868971456887D-14,  -2.282673272843732D-12,   9.636921530630927D-11, &
&   -4.185114534971967D-09,   1.908409125919734D-07,  -9.669271695893860D-06, &
&    7.348646446713388D-04,                                                   &
&    6.293398121774746D-22,  -2.055216210121535D-20,   7.482656896053191D-19, &
&   -2.899740203758901D-17,   1.155042236009289D-15,  -4.668742597369065D-14, &
&    1.909311390803780D-12,  -7.913866413621523D-11,   3.341329971214165D-09, &
&   -1.451086964273899D-07,   6.616954122345824D-06,  -3.352589993398638D-04, &
&    2.547968391647663D-02,                                                   &
&    1.895727488187100D-21,  -8.014988345146533D-20,   3.261454227758541D-18, &
&   -1.315152980727671D-16,   5.304781889070017D-15,  -2.151678166722343D-13, &
&    8.806777417978502D-12,  -3.650933443706240D-10,   1.541514293321342D-08, &
&   -6.694581896668288D-07,   3.052729619375644D-05,  -1.546716351218094D-03, &
&    1.175504427301448D-01,                                                   &
&    1.136843962693453D-23,  -3.512549366993541D-22,   1.284229351186459D-20, &
&   -5.161512282049415D-19,   2.156062428481476D-17,  -9.166484677706981D-16, &
&    3.945485874472911D-14,  -1.721401550501315D-12,   7.650482868012025D-11, &
&   -3.497352118036989D-09,   1.678728455438098D-07,  -8.953218212331688D-06, &
&    7.162574562372077D-04,                                                   &
&    2.728145378027789D-22,  -1.045962031482559D-20,   4.234767782831393D-19, &
&   -1.764301529963656D-17,   7.449304499579892D-16,  -3.175841942484541D-14, &
&    1.367809999670594D-12,  -5.968418578564495D-11,   2.652615527161450D-09, &
&   -1.212623337209688D-07,   5.820591575040968D-06,  -3.104315489502732D-04, &
&    2.483452391005866D-02,                                                   &
&    1.064742387557562D-21,  -4.548328720706328D-20,   1.918258334872805D-18, &
&   -8.098096209557773D-17,   3.432390546964099D-15,  -1.464772146379987D-13, &
&    6.310064232260305D-12,  -2.753505911692975D-10,   1.223782091108774D-08, &
&   -5.594433435064351D-07,   2.685328098799681D-05,  -1.432174987961748D-03, &
&    1.145739990436523D-01,                                                   &
&    4.570944234652681D-24,  -1.757098786628930D-22,   7.355627594499130D-21, &
&   -3.204583624099798D-19,   1.419400644529991D-17,  -6.352781373486466D-16, &
&    2.872827731577275D-14,  -1.316228887729910D-12,   6.142366901128371D-11, &
&   -2.948334050920033D-09,   1.485960261751979D-07,  -8.321377427553872D-06, &
&    6.989957037832322D-04,                                                   &
&    1.361910492859500D-22,  -5.780599461813818D-21,   2.511351520593001D-19, &
&   -1.106626237572432D-17,   4.916816526909907D-16,  -2.202255555931347D-14, &
&    9.960513708073828D-13,  -4.563688093366514D-11,   2.129718379819512D-09, &
&   -1.022264658912887D-07,   5.152213801464316D-06,  -2.885239725767904D-04, &
&    2.423601369539984D-02,                                                   &
&    5.921296818648331D-22,  -2.615890496418637D-20,   1.152179309703742D-18, &
&   -5.097976025557838D-17,   2.267601468919546D-15,  -1.015939416321104D-13, &
&    4.595223726497520D-12,  -2.105452266162144D-10,   9.825446984927529D-09, &
&   -4.716214736782046D-07,   2.376972236282937D-05,  -1.331104452661914D-03, &
&    1.118127740247826D-01,                                                   &
&    2.242546901988616D-24,  -9.818703140812155D-23,   4.449818334126229D-21, &
&   -2.052058029248346D-19,   9.549600821540281D-18,  -4.480819623362711D-16, &
&    2.123112991359629D-14,  -1.019085499310406D-12,   4.982189607930720D-11, &
&   -2.505329266797250D-09,   1.322813835336517D-07,  -7.760507827310022D-06, &
&    6.829246887805686D-04,                                                   &
&    7.375182035837202D-23,  -3.349052936693596D-21,   1.536010112625247D-19, &
&   -7.107213542442209D-18,   3.310300173978816D-16,  -1.553545695059118D-14, &
&    7.361332763285330D-13,  -3.533432807223772D-11,   1.727455549025768D-09, &
&   -8.686633327252369D-08,   4.586542382768628D-06,  -2.690771530689815D-04, &
&    2.367878946988773D-02,                                                   &
&    3.336683663346787D-22,  -1.535918970905447D-20,   7.074948673759235D-19, &
&   -3.277602031070746D-17,   1.527071735542424D-15,  -7.167156461626289D-14, &
&    3.396138959961506D-12,  -1.630147480062898D-10,   7.969610454256560D-09, &
&   -4.007575575428660D-07,   2.115999905403720D-05,  -1.241386611230291D-03, &
&    1.092420217884710D-01,                                                   &
&    1.227389746967075D-24,  -5.800885905874404D-23,   2.778635722040932D-21, &
&   -1.343804272915741D-19,   6.543194474191749D-18,  -3.210324295898460D-16, &
&    1.590326298453332D-14,  -7.980531038202860D-13,   4.078937002435186D-11, &
&   -2.144355389104446D-09,   1.183684171748677D-07,  -7.259929585578437D-06, &
&    6.679135218693319D-04,                                                   &
&    4.185199010045053D-23,  -2.001666811538350D-21,   9.622406490941590D-20, &
&   -4.657983136258795D-18,   2.268561530149640D-16,  -1.113091449471205D-14, &
&    5.514068731356968D-13,  -2.767058711970556D-11,   1.414274366168111D-09, &
&   -7.435042331159786D-08,   4.104143364359349D-06,  -2.517207930047996D-04, &
&    2.315831295641019D-02,                                                   &
&    1.919109927025980D-22,  -9.218527144602193D-21,   4.437299500252162D-19, &
&   -2.148732672066633D-17,   1.046577127708092D-15,  -5.135223212090967D-14, &
&    2.543912271373636D-12,  -1.276581569525404D-10,   6.524750341695593D-09, &
&   -3.430154471082701D-07,   1.893445268312106D-05,  -1.161313097908479D-03, &
&    1.068408050076153D-01,                                                   &
&    7.100663724214277D-25,  -3.539520863238044D-23,   1.775207244554255D-21, &
&   -8.966504451186488D-20,   4.556751823529754D-18,  -2.333020885338362D-16, &
&    1.205988995551875D-14,  -6.314994218351422D-13,   3.367996728478144D-11, &
&   -1.847586765806843D-09,   1.064209976584801D-07,  -6.810943849947559D-06, &
&    6.538506095943084D-04,                                                   &
&    2.449784899006980D-23,  -1.225587548595536D-21,   6.153090353563709D-20, &
&   -3.108695823217202D-18,   1.579922559482557D-16,  -8.089174800731051D-15, &
&    4.181478460245676D-13,  -2.189573958945363D-11,   1.167772763003948D-09, &
&   -6.406067719653033D-08,   3.689895006100362D-06,  -2.361532803888438D-04, &
&    2.267071491732368D-02,                                                   &
&    1.128156148894180D-22,  -5.651444320328083D-21,   2.838383595296822D-19, &
&   -1.434157253814427D-17,   7.288928844334835D-16,  -3.731934798907113D-14, &
&    1.929123518921059D-12,  -1.010159248817191D-10,   5.387516010671801D-09, &
&   -2.955437355417834D-07,   1.702331916767850D-05,  -1.089492426733199D-03, &
&    1.045912729663931D-01/
end


!------------------
  module rysgrid4
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t4(13,4,0:27)
      real(8) :: w4(13,4,0:27)
      data t4 / &
&   -5.089811655025537D-16,  -6.032550395812848D-15,  -3.991751965087166D-14, &
&    7.991388086616656D-13,   2.749213465972688D-11,   4.278546141143203D-10, &
&    3.592286036457816D-09,  -1.928147899413399D-08,  -1.489050670769307D-06, &
&   -3.628489121004847D-05,  -6.300204186449510D-04,  -8.445152694880312D-03, &
&    9.221566084920587D-01,                                                   &
&    1.788366364834451D-15,  -3.230458207872181D-14,  -3.198819447961101D-13, &
&    3.952078636803999D-12,   8.759148723011197D-11,  -2.384782067096663D-10, &
&   -1.839620436159717D-08,  -7.527929943247665D-08,   3.470656001645966D-06, &
&    4.428307934772688D-05,  -6.511178771623491D-04,  -2.727787969353752D-02, &
&    6.346774762346366D-01,                                                   &
&    1.372761948983488D-15,  -5.666241706002942D-15,  -3.247336684759962D-13, &
&    4.792221300516848D-12,   1.765863811811859D-11,  -1.129913808730420D-09, &
&    8.623685511316363D-09,   1.366913524486604D-07,  -3.560316471048102D-06, &
&    1.078260668569402D-05,   9.264771217839184D-04,  -2.351841631097182D-02, &
&    2.761843138724644D-01,                                                   &
&   -7.226701467621641D-17,   2.373112836572040D-15,  -5.086936688746540D-14, &
&    7.237165275526869D-13,  -5.144973646708101D-12,  -4.778598244377775D-11, &
&    2.715121704166255D-09,  -6.807052273092284D-08,   1.319367016847396D-06, &
&   -2.184277827471171D-05,   3.144271275973849D-04,  -3.825419073360477D-03, &
&    3.364826806750685D-02,                                                   &
&   -2.034754988899167D-16,  -1.767170613203471D-14,  -3.098150445315799D-13, &
&   -2.241849837473835D-12,   2.263158573857478D-11,   8.995857433187024D-10, &
&    1.294475114135620D-08,   7.314114952589342D-08,  -1.313371716251853D-06, &
&   -4.810155472285110D-05,  -8.838075492151710D-04,  -1.144893409766686D-02, &
&    9.024317925435039D-01,                                                   &
&    2.558155980439528D-15,   2.572839232935942D-14,  -4.539450889278335D-13, &
&   -5.977234733743959D-12,   7.387201087316432D-11,   1.302186939050507D-09, &
&   -1.071185506642671D-08,  -2.722069247561842D-07,   1.655920235739145D-06, &
&    6.613235062285096D-05,  -3.125506453931608D-04,  -2.924945766966300D-02, &
&    5.779234477103597D-01,                                                   &
&   -7.540067569978389D-17,   1.272586738863445D-14,  -1.682889226620571D-13, &
&   -8.381120664086244D-13,   4.804410050116439D-11,  -4.657654539807855D-10, &
&   -3.092998201402032D-09,   1.601854370064950D-07,  -1.957689617321772D-06, &
&   -1.143289956959117D-05,   9.180207758943690D-04,  -1.978493438536234D-02, &
&    2.328874735734968D-01,                                                   &
&   -3.775900678274386D-17,   9.616779616794827D-16,  -1.600828388865643D-14, &
&    1.075699296112820D-13,   1.302277521038790D-12,  -6.399414704650472D-11, &
&    1.816154614900793D-09,  -4.069633846902594D-08,   7.847521098478640D-07, &
&   -1.360902204973208D-05,   2.102027325933396D-04,  -2.792553740804249D-03, &
&    2.709949447760696D-02,                                                   &
&    4.737896012514031D-15,   2.379751172725058D-14,  -4.761338861217654D-13, &
&   -1.149247472700697D-11,  -9.464181552096268D-11,   5.519543077452556D-10, &
&    2.526888882211019D-08,   3.066425759243507D-07,   4.580018892576369D-07, &
&   -5.308496407714308D-05,  -1.194349093002748D-03,  -1.559465492630742D-02, &
&    8.755961561857461D-01,                                                   &
&   -2.371475928526536D-15,   2.854904658719333D-14,   3.912298596901811D-13, &
&   -6.713711790749271D-12,  -6.720354406598948D-11,   1.373746209301214D-09, &
&    1.075575528976913D-08,  -2.729969950941507D-07,  -1.290336782542240D-06, &
&    6.760138591719247D-05,   1.006137060978468D-04,  -2.967627254816564D-02, &
&    5.187206692666000D-01,                                                   &
&   -3.654420100325187D-16,   4.567997044914927D-15,   3.388390360716085D-14, &
&   -1.855357555371955D-12,   1.767739040489808D-11,   8.280278757480922D-11, &
&   -5.183936686941899D-09,   1.027820081083635D-07,  -6.231423234572935D-07, &
&   -2.136318065804014D-05,   8.142789929361900D-04,  -1.630063328297399D-02, &
&    1.968717817635067D-01,                                                   &
&   -1.612894021838571D-17,   3.699682851355956D-16,  -2.344940636103062D-15, &
&   -5.480291194569112D-14,   1.372772540642910D-12,  -3.879739645873073D-11, &
&    1.096799301120990D-09,  -2.358187903942777D-08,   4.705529215512262D-07, &
&   -8.701408000857492D-06,   1.445224864862760D-04,  -2.092873172932865D-03, &
&    2.225768791743080D-02,                                                   &
&    1.254864915478654D-15,   1.625478554028110D-13,   1.683863374885007D-12, &
&   -5.148343101397461D-12,  -3.095822104082224D-10,  -2.805435796586034D-09, &
&    1.375040231284181D-08,   5.880728943984162D-07,   5.038043343213743D-06, &
&   -3.304023794054293D-05,  -1.471127006350089D-03,  -2.096490993687422D-02, &
&    8.392235681692449D-01,                                                   &
&   -5.735604421730382D-16,  -2.285589052784392D-14,   3.594147012565498D-13, &
&    2.836411442304187D-12,  -1.005553388745749D-10,  -2.076294833603961D-10, &
&    1.953441758907482D-08,  -6.843436943352313D-08,  -3.086505693799459D-06, &
&    4.869944256198157D-05,   4.567724957680466D-04,  -2.852313310672039D-02, &
&    4.602828528050343D-01,                                                   &
&   -5.162234313908437D-17,  -4.343702485524042D-16,   6.416478110290510D-14, &
&   -6.914940409982757D-13,  -6.063555653879169D-12,   1.469006689909625D-10, &
&   -3.129929643844425D-09,   5.208317159411366D-08,   1.297489045562436D-07, &
&   -2.299772161127838D-05,   6.782021761279726D-04,  -1.331253764989573D-02, &
&    1.673497269159917D-01,                                                   &
&   -4.196688451605846D-18,   1.229930508422850D-16,   2.510698558368098D-15, &
&   -4.404516597571319D-14,   3.407494003688364D-13,  -2.539121073847036D-11, &
&    6.672699596822169D-10,  -1.318425184567855D-08,   2.909775299056355D-07, &
&   -5.724355188503290D-06,   1.019601080845263D-04,  -1.605834504370714D-03, &
&    1.858726003086990D-02,                                                   &
&   -3.312212103196215D-14,  -2.608545730651834D-13,   2.409268003041808D-12, &
&    5.165448949043749D-11,   7.593466582445476D-11,  -6.114531515811069D-09, &
&   -5.574403033486400D-08,   3.865623319620222D-07,   1.062014285400866D-05, &
&    3.086625657612488D-05,  -1.500549254102129D-03,  -2.703657277702525D-02, &
&    7.912447864921139D-01,                                                   &
&    6.432533736479221D-16,  -6.668541724193028D-15,  -2.531160463042461D-14, &
&    5.431434930016697D-12,  -1.424586767230074D-11,  -1.184456502976804D-09, &
&    8.133717066905039D-09,   1.114087995730772D-07,  -2.754275506783625D-06, &
&    2.411882829896029D-05,   6.738033448181797D-04,  -2.621233001541022D-02, &
&    4.054028977798845D-01,                                                   &
&   -1.143626605140164D-16,  -1.012825383683065D-15,   5.102188941063019D-14, &
&    4.676108828358973D-13,  -7.699247497466990D-12,   8.970660416709806D-12, &
&   -2.009690858659812D-09,   2.325438330388108D-08,   4.951771960197804D-07, &
&   -2.030854838597392D-05,   5.468306799081007D-04,  -1.086792560074682D-02, &
&    1.432570378378913D-01,                                                   &
&   -1.573702672097765D-17,  -1.338834652469380D-17,   4.239368347448726D-15, &
&    2.743314351642132D-14,   1.364809789953726D-13,  -2.330604036013034D-11, &
&    3.304110579585642D-10,  -7.222487021990983D-09,   1.923041997689416D-07, &
&   -3.830943729781371D-06,   7.368621921355015D-05,  -1.258312791322934D-03, &
&    1.574190988006792D-02,                                                   &
&    5.559055154929421D-14,  -2.298302287422724D-13,  -7.491056140726274D-12, &
&    2.176242206448552D-12,   8.848359443578446D-10,   2.747775786956090D-09, &
&   -9.566595860028206D-08,  -6.492466772910896D-07,   9.739746723518084D-06, &
&    1.193828737352390D-04,  -1.046638501437501D-03,  -3.231084195173077D-02, &
&    7.315943636622127D-01,                                                   &
&   -7.784278254058935D-16,  -2.124182548582220D-14,  -2.488348673103613D-13, &
&    3.351372967725943D-12,   7.094569606998550D-11,  -6.843416920142412D-10, &
&   -6.560118681627005D-09,   1.137227428300376D-07,  -1.478436537085675D-06, &
&    7.182128030219946D-06,   7.624815976203233D-04,  -2.330588603709572D-02, &
&    3.558262664723041D-01,                                                   &
&   -1.338449732524700D-16,  -6.743827430190209D-15,  -3.080458835609989D-14, &
&    9.068079895381194D-13,   7.092732220928433D-12,  -7.608366210136611D-12, &
&   -2.285252874131196D-09,  -2.248889146031767D-09,   6.035381502467098D-07, &
&   -1.574404042607963D-05,   4.382366032870963D-04,  -8.906987842640671D-03, &
&    1.235545787904335D-01,                                                   &
&   -1.299191999927695D-17,  -6.188483567468912D-16,  -2.624285131568383D-15, &
&    6.833385340856731D-14,   1.202702713851884D-12,  -1.369759145130135D-11, &
&    5.072346682075801D-11,  -5.066953650073294D-09,   1.336958457790304D-07, &
&   -2.541140640565785D-06,   5.480211392464215D-05,  -1.003910081883028D-03, &
&    1.349224558841357D-02,                                                   &
&   -2.503787616919865D-14,   7.657018694995832D-13,   2.545736490382693D-12, &
&   -9.015363603655161D-11,  -2.335164110001968D-10,   1.039223968159257D-08, &
&    1.845022853964125D-08,  -1.226646814422416D-06,  -8.262547244060366D-07, &
&    1.590424510185431D-04,  -1.681335260734459D-04,  -3.482133459405993D-02, &
&    6.638706976185509D-01,                                                   &
&    3.953950368997377D-15,   2.751640002822228D-14,  -4.379421241182129D-13, &
&   -5.405037491690769D-12,   5.978902671827372D-11,   5.809274606643963D-10, &
&   -7.105833196748320D-09,   1.338780122591399D-08,  -8.377559437714314D-07, &
&   -1.388929009277735D-06,   7.772944775802093D-04,  -2.020947354606743D-02, &
&    3.123013740897467D-01,                                                   &
&    9.011691484937604D-16,   4.931775322191468D-15,  -1.060243480270877D-13, &
&   -9.130485934627692D-13,   9.642312031144694D-12,   1.721564174809575D-10, &
&   -1.191307540633863D-09,  -2.575610377650212D-08,   4.526986186272589D-07, &
&   -1.135877232611609D-05,   3.575401302241268D-04,  -7.324269665713889D-03, &
&    1.073770368450477D-01,                                                   &
&    8.197446177268376D-17,   4.442500058680142D-16,  -9.592743708117744D-15, &
&   -9.506364457491870D-14,   1.202959997661063D-12,   9.671035299379368D-12, &
&    2.158184064717163D-11,  -4.972071919356748D-09,   8.379488586634305D-08, &
&   -1.671351510799324D-06,   4.236400486927883D-05,  -8.113174323322573D-04, &
&    1.168528357813140D-02,                                                   &
&   -2.242741947363741D-14,  -5.149473932637505D-13,   4.978999825449678D-12, &
&    3.921057645062521D-11,  -7.621415940576830D-10,  -9.510743827392112D-10, &
&    9.466254518855367D-08,  -3.793698683996872D-07,  -9.638926779017569D-06, &
&    1.113027072540075D-04,   6.787857656411078D-04,  -3.370215895531150D-02, &
&    5.947777702954549D-01,                                                   &
&   -4.785511244745698D-15,   2.264612591813919D-14,   5.751492605077886D-13, &
&   -3.908453305134683D-12,  -5.731555208182118D-11,   5.643095676733370D-10, &
&    3.225743185399618D-09,  -9.557632409262146D-09,  -9.266635203884569D-07, &
&   -8.294142815600112D-06,   7.486889869741460D-04,  -1.714375708270882D-02, &
&    2.749671495379946D-01,                                                   &
&   -9.470835249375388D-16,   6.381050777735738D-15,   1.147439435199142D-13, &
&   -8.996245571141038D-13,  -1.389294488641528D-11,   1.382237613790479D-10, &
&    1.448607320638944D-09,  -2.373794721170699D-08,   1.778702996920438D-07, &
&   -8.850582945471864D-06,   2.980335976144265D-04,  -6.018132846016164D-03, &
&    9.407415453690398D-02,                                                   &
&   -8.437609285911267D-17,   6.087801618474562D-16,   1.063232666793277D-14, &
&   -9.268630134214175D-14,  -1.147077671929322D-12,   1.010339760567454D-11, &
&    2.064219973531905D-10,  -3.610113835456141D-09,   3.894048812689515D-08, &
&   -1.189481624760350D-06,   3.396251085304569D-05,  -6.596245134094601D-04, &
&    1.021991840255990D-02,                                                   &
&    2.835655943924249D-14,  -3.233607315555487D-14,  -3.430111523391484D-12, &
&    3.285766970847610D-11,   1.524327099136939D-10,  -5.563581911858085D-09, &
&    3.097377389393629D-08,   4.381411699277255D-07,  -8.671130831461754D-06, &
&    3.252802814643739D-05,   1.105854764297942D-03,  -2.997310034852037D-02, &
&    5.308184200431406D-01,                                                   &
&    1.431427616445575D-15,  -4.078622363421876D-14,   4.129055042489543D-14, &
&    4.810290199162772D-12,  -3.106159817113238D-11,  -3.646362392013970D-10, &
&    4.062191425494886D-09,   4.781204958297315D-08,  -7.425706775725241D-07, &
&   -1.537210243067072D-05,   6.769592047376925D-04,  -1.427814115407743D-02, &
&    2.435931683381554D-01,                                                   &
&    1.641286157290212D-16,  -9.259568288069706D-15,   2.332541021607214D-14, &
&    1.116546927802810D-12,  -8.818883574831608D-12,  -9.502396140600443D-11, &
&    1.644013910732907D-09,  -1.768544205672981D-09,   4.860858487252231D-08, &
&   -8.095767587726003D-06,   2.477128971042212D-04,  -4.928088243964261D-03, &
&    8.316141139514746D-02,                                                   &
&    1.097242780457670D-17,  -8.615287851344424D-16,   2.733376897395926D-15, &
&    1.007378861981877D-13,  -8.051990804354908D-13,  -1.045472769906364D-11, &
&    1.965219832574222D-10,  -8.904414021995489D-10,   1.655252696814367D-08, &
&   -9.860516196356059D-07,   2.752536550923119D-05,  -5.370481326413884D-04, &
&    9.027525265236803D-03,                                                   &
&   -7.214260020683133D-15,   1.325092194660124D-13,  -5.750824748635881D-13, &
&   -1.231697534267155D-11,   2.412141168409757D-10,  -1.307448258274066D-09, &
&   -1.840545196300918D-08,   4.508394689956449D-07,  -3.730200917449664D-06, &
&   -1.707654437511640D-05,   1.132047972235500D-03,  -2.539810084524897D-02, &
&    4.754324676131656D-01,                                                   &
&    9.983738543911495D-16,   1.134026189386211D-14,  -2.440838812543310D-13, &
&    6.451607583013225D-13,   2.628908758516173D-11,  -2.921829889285301D-10, &
&   -1.636334641243091D-09,   6.103005301302783D-08,  -1.391476751785454D-07, &
&   -1.898512439019303D-05,   5.714256938019588D-04,  -1.177411120984583D-02, &
&    2.176116026675151D-01,                                                   &
&    3.066097569514393D-16,   1.890666734557445D-15,  -6.163503801493903D-14, &
&    2.701115054956406D-13,   6.218527961122922D-12,  -9.318783094913361D-11, &
&    3.628408590020259D-11,   8.221306289232861D-09,   9.753837167716974D-08, &
&   -7.577617422632685D-06,   2.004834867536288D-04,  -4.032705232920072D-03, &
&    7.423213287252337D-02,                                                   &
&    3.077057578216244D-17,   1.485468972692407D-16,  -5.822648301195527D-15, &
&    2.775735099510698D-14,   6.109600099017627D-13,  -1.004574650246622D-11, &
&    2.561042605373974D-11,   4.308726306064524D-10,   1.601945103119799D-08, &
&   -8.645537892261500D-07,   2.197425053182945D-05,  -4.382883837156647D-04, &
&    8.055889481086697D-03,                                                   &
&   -2.331397036004815D-15,  -7.089731914816623D-15,   5.300511258749653D-13, &
&   -7.417910230969389D-12,   3.223497326326927D-11,   7.365156144501690D-10, &
&   -1.838690350318746D-08,   2.019034273443526D-07,  -4.747984643079768D-07, &
&   -3.219965017934598D-05,   9.712072328092020D-04,  -2.116202935247371D-02, &
&    4.289812988995365D-01,                                                   &
&   -6.454374236890392D-16,   6.169489866603189D-15,   2.392909633501766D-14, &
&   -1.273352240038451D-12,   1.217209202078093D-11,   6.001912527256771D-11, &
&   -2.965720805732812D-09,   2.836418512856101D-08,   3.204979097014337D-07, &
&   -1.803514346482597D-05,   4.585163861321385D-04,  -9.716218017408095D-03, &
&    1.961967933391915D-01,                                                   &
&   -1.495361556202683D-16,   1.851165851558624D-15,   1.145764570385257D-15, &
&   -3.140357622749631D-13,   3.815068863483627D-12,   9.646268620413066D-13, &
&   -5.567226035976390D-10,   3.741849110714955D-09,   1.631724188165894D-07, &
&   -6.503080063501672D-06,   1.579742431057597D-04,  -3.317951841605606D-03, &
&    6.690985117635213D-02,                                                   &
&   -1.372517216122997D-17,   1.849895586342525D-16,  -2.670486339495649D-17, &
&   -3.038110390018464D-14,   4.011112526248983D-13,  -5.587534875509167D-13, &
&   -4.398930979434635D-11,   1.838958620895012D-10,   1.977940557522502D-08, &
&   -7.195273621452517D-07,   1.720642187868634D-05,  -3.602178559867348D-04, &
&    7.260563902897061D-03,                                                   &
&    6.106862685278158D-16,  -1.429555581727553D-14,   1.625012065937253D-13, &
&   -3.591331396471281D-13,  -2.600240022239398D-11,   6.165609169715387D-10, &
&   -7.873265968478910D-09,   4.649762490626608D-08,   6.600253122785291D-07, &
&   -3.042584973155544D-05,   7.788778768262038D-04,  -1.766581932616041D-02, &
&    3.902822585444927D-01,                                                   &
&   -4.957868580257854D-17,  -1.878215671325117D-15,   4.142602851996638D-14, &
&   -3.283542802646884D-13,  -2.589807399730359D-12,   1.126073796658591D-10, &
&   -1.480769819220399D-09,   1.018063817978455D-09,   4.520057843999637D-07, &
&   -1.476197163100288D-05,   3.596115220588489D-04,  -8.086581949319130D-03, &
&    1.784599976966379D-01,                                                   &
&   -2.481794973758713D-17,  -3.717222899577971D-16,   1.101968511840834D-14, &
&   -1.097921043109727D-13,  -2.563438909662219D-13,   2.413477321474984D-11, &
&   -3.041309244365668D-10,  -1.732337400881843D-09,   1.705395311159334D-07, &
&   -5.131334503975281D-06,   1.230437284294168D-04,  -2.758674217018116D-03, &
&    6.085651563638347D-02,                                                   &
&   -2.780709600885836D-18,  -3.230788694901276D-17,   1.084205417809043D-15, &
&   -1.166863949018992D-14,  -7.145317794272191D-15,   2.104562282517962D-12, &
&   -2.544225811166823D-11,  -2.685651456235548D-10,   1.915504808983005D-08, &
&   -5.607261354551373D-07,   1.336832496924953D-05,  -2.993871980877700D-04, &
&    6.603517215286589D-03,                                                   &
&    2.743698811573685D-16,  -2.618984078352703D-15,  -5.799993012265091D-15, &
&    7.701974735009976D-13,  -1.736484944522134D-11,   2.446347569874059D-10, &
&   -2.024385334010053D-09,  -7.613894805316443D-09,   7.963296945464022D-07, &
&   -2.424675647483680D-05,   6.143612007263994D-04,  -1.489183961127698D-02, &
&    3.578343412605369D-01,                                                   &
&    6.038253667024246D-17,  -9.487310607244812D-16,   5.695566562979448D-15, &
&    1.010813970136513D-13,  -3.539350895161604D-12,   5.348174103931320D-11, &
&   -3.045475844738477D-10,  -8.838086629373868D-09,   4.011198046587825D-07, &
&   -1.128491852268760D-05,   2.816838316366637D-04,  -6.810970968606596D-03, &
&    1.636143676355596D-01,                                                   &
&    1.471342408197101D-17,  -2.726005081911107D-16,   2.190569977027252D-15, &
&    1.654000915840875D-14,  -8.213173284106245D-13,   1.251301105304598D-11, &
&   -3.808843232151622D-11,  -3.614587260316717D-09,   1.411263634493100D-07, &
&   -3.872355446802117D-06,   9.615246012400884D-05,  -2.322804683846420D-03, &
&    5.579294815120173D-02,                                                   &
&    1.390954775492748D-18,  -2.746121009998241D-17,   2.409791570987372D-16, &
&    1.196389060000204D-15,  -7.508366720452505D-14,   1.140199937027476D-12, &
&   -1.560503039302895D-12,  -4.162252197805661D-10,   1.549002811207698D-08, &
&   -4.211810600108055D-07,   1.043745707240047D-05,  -2.520551066520903D-04, &
&    6.054026830898977D-03,                                                   &
&    2.887142031051445D-17,   3.809677709413562D-16,  -1.907419591010750D-14, &
&    4.176807987439346D-13,  -6.339807462327837D-12,   6.394485653822657D-11, &
&   -7.127761035947913D-11,  -1.768384511710185D-08,   6.507247543976526D-07, &
&   -1.839472955102726D-05,   4.870343129993753D-04,  -1.270077759294059D-02, &
&    3.303265281108667D-01,                                                   &
&    1.593542974191659D-17,  -5.290665571316752D-17,  -3.157822065918311D-15, &
&    9.384368813851913D-14,  -1.532188979803396D-12,   1.323915390668413D-11, &
&    1.241078531702968D-10,  -9.358438935031691D-09,   3.059281862929408D-07, &
&   -8.454006564660149D-06,   2.228511632994129D-04,  -5.807563762314208D-03, &
&    1.510350032792426D-01,                                                   &
&    4.972589979894018D-18,  -2.919782250810752D-17,  -6.429258823090537D-16, &
&    2.303333819615555D-14,  -3.830749313760583D-13,   2.765222466806637D-12, &
&    6.037688875837155D-11,  -3.344123899639926D-09,   1.053653755050294D-07, &
&   -2.888374024379397D-06,   7.601408365502224D-05,  -1.980438733631896D-03, &
&    5.150311109941478D-02,                                                   &
&    5.144909336591365D-19,  -3.453850408730255D-18,  -5.483934559381731D-17, &
&    2.167560962272618D-15,  -3.620170370253248D-14,   2.308963164966372D-13, &
&    7.279672077250377D-12,  -3.691318469368501D-10,   1.147638299149005D-08, &
&   -3.136464350816200D-07,   8.249098121650646D-06,  -2.148969301784893D-04, &
&    5.588531546307778D-03,                                                   &
&   -1.119732425523469D-17,   4.011286776997015D-16,  -8.715265290556976D-15, &
&    1.408814904239611D-13,  -1.632973377987096D-12,   6.797348313171883D-12, &
&    3.372665961618204D-10,  -1.530641166841563D-08,   4.818602872691453D-07, &
&   -1.388127033514736D-05,   3.908848428953627D-04,  -1.095395927140182D-02, &
&    3.067358002489926D-01,                                                   &
&   -4.707238530641477D-19,   7.861226495719216D-17,  -2.128286753029848D-15, &
&    3.668284947633303D-14,  -3.925004790850698D-13,  -7.667887110070404D-13, &
&    1.902774421447207D-10,  -7.279963562896949D-09,   2.221166311985706D-07, &
&   -6.355937768260729D-06,   1.787570577259149D-04,  -5.008537770343466D-03, &
&    1.402482530262707D-01,                                                   &
&    1.360697212058545D-19,   1.792260638460468D-17,  -5.448705443321401D-16, &
&    9.565287042697886D-15,  -9.387686894514119D-14,  -7.197717994919663D-13, &
&    6.931423586204985D-11,  -2.518121708787559D-09,   7.597551964466151D-08, &
&   -2.168580395571735D-06,   6.096083903979511D-05,  -1.707926236724069D-03, &
&    4.782476593971575D-02,                                                   &
&    2.378353685306265D-20,   1.629491183943072D-18,  -5.230705438132873D-17, &
&    9.230829677185154D-16,  -8.589201113060675D-15,  -9.675689759320401D-14, &
&    7.704169287019458D-12,  -2.747284967573429D-10,   8.253864346654659D-09, &
&   -2.353607518737888D-07,   6.614968856617297D-06,  -1.853251124506024D-04, &
&    5.189397204100181D-03,                                                   &
&   -7.340847270984725D-18,   1.608152476351237D-16,  -2.737120417582634D-15, &
&    3.533514075724762D-14,  -2.250986711538384D-13,  -5.577482083064176D-12, &
&    3.201880858888942D-10,  -1.119535507602276D-08,   3.495729067165397D-07, &
&   -1.058316243728253D-05,   3.180204996737322D-04,  -9.542733715139099D-03, &
&    2.862876129755760D-01,                                                   &
&   -1.643177730733626D-18,   4.199132179319016D-17,  -7.554380479805556D-16, &
&    9.295326556912183D-15,  -2.010490526986542D-14,  -3.417473888832854D-12, &
&    1.541911190598900D-10,  -5.177854385814123D-09,   1.602018647405135D-07, &
&   -4.840723876891792D-06,   1.454144278081207D-04,  -4.363219595228282D-03, &
&    1.308986911174945D-01,                                                   &
&   -4.033190657233801D-19,   1.109476858009622D-17,  -2.029428715184414D-16, &
&    2.372035737045712D-15,   3.183325438880976D-15,  -1.274109301374058D-12, &
&    5.358418616757931D-11,  -1.773448100401165D-09,   5.467848342826236D-08, &
&   -1.650938312386748D-06,   4.958734121267139D-05,  -1.487863169221762D-03, &
&    4.463654753200622D-02,                                                   &
&   -3.802115028124240D-20,   1.080244541638393D-18,  -1.985993579055040D-17, &
&    2.251645058031933D-16,   7.577405442091627D-16,  -1.427788087993035D-13, &
&    5.856649416929993D-12,  -1.927656937774268D-10,   5.935206946008178D-09, &
&   -1.791516561012420D-07,   5.380691096054482D-06,  -1.614459917314414D-04, &
&    4.843447718033691D-03,                                                   &
&   -2.633495269623153D-18,   4.757049857848224D-17,  -6.655547835664704D-16, &
&    5.397525003130459D-15,   8.061058002314564D-14,  -6.034397451150936D-12, &
&    2.334237025607750D-10,  -7.869221343347776D-09,   2.551284386885259D-07, &
&   -8.186536133584072D-06,   2.620884754458339D-04,  -8.387300145148334D-03, &
&    2.683948168957229D-01,                                                   &
&   -7.285144914103280D-19,   1.374216684155499D-17,  -1.862678314930435D-16, &
&    9.115990782358493D-16,   5.493826190603985D-14,  -2.942551902114685D-12, &
&    1.083325233245821D-10,  -3.609905012236765D-09,   1.167242772525769D-07, &
&   -3.743462406041313D-06,   1.198354094522960D-04,  -3.834910268136510D-03, &
&    1.227175908154639D-01,                                                   &
&   -1.975340665255279D-19,   3.774154120532239D-18,  -4.941139873277161D-17, &
&    1.178483592980007D-16,   2.104549700294139D-14,  -1.027472380870956D-12, &
&    3.715656859030354D-11,  -1.232602793161827D-09,   3.981312380281781D-08, &
&   -1.276572636772916D-06,   4.086413767844809D-05,  -1.307707503334238D-03, &
&    4.184678442545454D-02,                                                   &
&   -1.944934712033841D-20,   3.730355128062405D-19,  -4.785939437443102D-18, &
&    4.792642453450508D-18,   2.380549397270051D-15,  -1.125090161791644D-13, &
&    4.041001720767295D-12,  -1.338178711421058D-10,   4.320501445890061D-09, &
&   -1.385212157779807D-07,   4.434116713679631D-06,  -1.418974801376200D-04, &
&    4.540734437356014D-03,                                                   &
&   -7.362298932962288D-19,   1.123483466332799D-17,  -1.061097296037744D-16, &
&   -1.026364071346396D-15,   1.036603931347579D-13,  -4.412191769059577D-12, &
&    1.599273755051248D-10,  -5.532232932839054D-09,   1.888568198645029D-07, &
&   -6.426143967678163D-06,   2.185149328686629D-04,  -7.429607898649245D-03, &
&    2.526069226475963D-01,                                                   &
&   -2.210449849823781D-19,   3.291045965353341D-18,  -2.244930837544832D-17, &
&   -8.015102362742489D-16,   5.114803252930375D-14,  -2.054526147536620D-12, &
&    7.344137106783593D-11,  -2.531802018693974D-09,   8.636446180808615D-08, &
&   -2.938278021544288D-06,   9.991134852416278D-05,  -3.397024255606497D-03, &
&    1.154989228602277D-01,                                                   &
&   -6.179860542733098D-20,   8.963065017400784D-19,  -4.353921685647707D-18, &
&   -3.165591632391716D-16,   1.794129379851170D-14,  -7.056437865754829D-13, &
&    2.508755738469500D-11,  -8.636708658281960D-10,   2.945231587951926D-08, &
&   -1.001964365081681D-06,   3.406987350154720D-05,  -1.158387717162978D-03, &
&    3.938521320700540D-02,                                                   &
&   -6.155903320660379D-21,   8.795273146704629D-20,  -3.345884257062311D-19, &
&   -3.617540933496224D-17,   1.968090035191067D-15,  -7.678541968772914D-14, &
&    2.724119846562225D-12,  -9.372983032968663D-11,   3.195914990152913D-09, &
&   -1.087221319443918D-07,   3.696874500520428D-06,  -1.256949893594068D-04, &
&    4.273632864891143D-03,                                                   &
&   -1.682711165959494D-19,   1.828242907283295D-18,   1.164265499586610D-17, &
&   -1.640024102888861D-15,   7.627545548312067D-14,  -2.959541653629821D-12, &
&    1.088488512713246D-10,  -3.939947665684599D-09,   1.420056443514941D-07, &
&   -5.113282163731876D-06,   1.840836517591577D-04,  -6.627032222441947D-03, &
&    2.385732118042096D-01,                                                   &
&   -5.106837918275111D-20,   4.375969669929872D-19,   1.077539025601136D-17, &
&   -8.175854397879710D-16,   3.562314313850213D-14,  -1.360447162984815D-12, &
&    4.982984675144654D-11,  -1.801890996358707D-09,   6.493152243806134D-08, &
&   -2.337947203644789D-06,   8.416821638819861D-05,  -3.030063848390621D-03, &
&    1.090823187825981D-01,                                                   &
&   -1.417405851831581D-20,   9.783296723147108D-20,   4.395962918673247D-18, &
&   -2.879511918223588D-16,   1.225048215770127D-14,  -4.649295533283261D-13, &
&    1.700068779271862D-11,  -6.145089389919215D-10,   2.214207048821544D-08, &
&   -7.972434105172312D-07,   2.870142670729197D-05,  -1.033253896787400D-03, &
&    3.719714667106064D-02,                                                   &
&   -1.403383072762850D-21,   8.454491207764272D-21,   5.076674792558108D-19, &
&   -3.163767203309705D-17,   1.333731072096963D-15,  -5.049303978891260D-14, &
&    1.845099868531000D-12,  -6.668224738304581D-11,   2.402620868473978D-09, &
&   -8.650781562530690D-08,   3.114350829504168D-06,  -1.121168954851472D-04, &
&    4.036208907404387D-03,                                                   &
&   -2.725200688233240D-20,  -1.130622693469633D-19,   2.411292047869834D-17, &
&   -1.215165725209937D-15,   5.024020887183115D-14,  -1.957929230046951D-12, &
&    7.491375595072602D-11,  -2.851364783949790D-09,   1.083874576438879D-07, &
&   -4.118948335100915D-06,   1.565211626436738D-04,  -5.947808369055569D-03, &
&    2.260167283272437D-01,                                                   &
&   -6.998677949477309D-21,  -1.335241375424863D-19,   1.211833146837548D-17, &
&   -5.689120000745919D-16,   2.311552334218438D-14,  -8.965986232866818D-13, &
&    3.426409359687037D-11,  -1.303804153483854D-09,   4.955823701514499D-08, &
&   -1.883300118847145D-06,   7.156584357035052D-05,  -2.719503699339709D-03, &
&    1.033411446412733D-01,                                                   &
&   -1.669263209782223D-21,  -5.652229609303828D-20,   4.282150498154362D-18, &
&   -1.958533551068770D-16,   7.902820213414910D-15,  -3.059384032115300D-13, &
&    1.168573905822230D-11,  -4.446099656246636D-10,   1.689946322605603D-08, &
&   -6.422069796349736D-07,   2.440400363169022D-05,  -9.273526575959828D-04, &
&    3.523940227739901D-02,                                                   &
&   -1.507488999657029D-22,  -6.603030876330341D-21,   4.711077547706232D-19, &
&   -2.133226419545693D-17,   8.584154942845392D-16,  -3.320562156705791D-14, &
&    1.268076033846153D-12,  -4.824451363199479D-11,   1.833739573326403D-09, &
&   -6.968497072305619D-08,   2.648043399709028D-06,  -1.006257037328313D-04, &
&    3.823776877278137D-03,                                                   &
&    1.097902510483312D-21,  -3.308146187841403D-19,   1.795685838328746D-17, &
&   -7.874020335260255D-16,   3.240880018290755D-14,  -1.307035807427189D-12, &
&    5.239112730877050D-11,  -2.096619118081283D-09,   8.387210079456737D-08, &
&   -3.354929644119453D-06,   1.341974107106899D-04,  -5.367897253983551D-03, &
&    2.147158921648048D-01,                                                   &
&    1.604664864251831D-21,  -1.674276997823230D-19,   8.422245209933719D-18, &
&   -3.625577911723758D-16,   1.484529924461097D-14,  -5.978685839305952D-13, &
&    2.395677556383650D-11,  -9.586472761561188D-10,   3.834874550834338D-08, &
&   -1.533967684753037D-06,   6.135879601843610D-05,  -2.454352167782571D-03, &
&    9.817408750975957D-02,                                                   &
&    6.974313106608194D-22,  -5.933549043901444D-20,   2.901850842782966D-18, &
&   -1.239947943867932D-16,   5.066177183877877D-15,  -2.039109714474003D-13, &
&    8.169586460988377D-12,  -3.269015679626898D-10,   1.307696163358404D-08, &
&   -5.230841075326928D-07,   2.092339236782533D-05,  -8.369357985348701D-04, &
&    3.347743219544373D-02,                                                   &
&    8.213776393937653D-23,  -6.535564994715023D-21,   3.161781586688903D-19, &
&   -1.347039586610353D-17,   5.498965174886674D-16,  -2.212774275086330D-14, &
&    8.864838529122739D-13,  -3.547171657478549D-11,   1.418962876534348D-09, &
&   -5.675910712268466D-08,   2.270367233324423D-06,  -9.081470025073357D-05, &
&    3.632588036770110D-03,                                                   &
&    4.291605458250309D-21,  -2.475444217805850D-19,   1.145746851597019D-17, &
&   -4.964891285196502D-16,   2.104948912653276D-14,  -8.863355910584675D-13, &
&    3.724883626556844D-11,  -1.564649653711324D-09,   6.571675785624956D-08, &
&   -2.760112856651283D-06,   1.159247839239571D-04,  -4.868841084169159D-03, &
&    2.044913259179713D-01,                                                   &
&    2.177047712944084D-21,  -1.162799065166059D-19,   5.278589889448278D-18, &
&   -2.274797482941351D-16,   9.629383005673979D-15,  -4.053036388228211D-13, &
&    1.703158110952204D-11,  -7.154040055891412D-10,   3.004754732430823D-08, &
&   -1.262000557895568D-06,   5.300404090300730D-05,  -2.226169781588375D-03, &
&    9.349913098033496D-02,                                                   &
&    7.725197639974450D-22,  -4.009226094437945D-20,   1.805761624549723D-18, &
&   -7.763950835317637D-17,   3.284359358262539D-15,  -1.382157196771883D-13, &
&    5.807837421717493D-12,  -2.439536570738434D-10,   1.024623682845815D-08, &
&   -4.303430793513059D-07,   1.807441488800471D-05,  -7.591254455823499D-04, &
&    3.188326876351023D-02,                                                   &
&    8.513739741663980D-23,  -4.369659689591194D-21,   1.961943022373716D-19, &
&   -8.427595637807027D-18,   3.564137161482292D-16,  -1.499789705492119D-14, &
&    6.302026175829932D-13,  -2.647107828075796D-11,   1.111804529639010D-09, &
&   -4.669590930517894D-08,   1.961228775387733D-06,  -8.237161070290845D-05, &
&    3.459607654692856D-03,                                                   &
&    3.197620312717841D-21,  -1.557139382610485D-19,   7.074990255306720D-18, &
&   -3.145500361635552D-16,   1.388129583959259D-14,  -6.112395683101022D-13, &
&    2.689912726081157D-11,  -1.183601055703731D-09,   5.207873518404485D-08, &
&   -2.291466096508985D-06,   1.008245166616592D-04,  -4.436278763309080D-03, &
&    1.951962656574326D-01,                                                   &
&    1.502673667450069D-21,  -7.177393906961729D-20,   3.242225177498908D-18, &
&   -1.439066729498592D-16,   6.347808883394689D-15,  -2.794840040656421D-13, &
&    1.229909657877088D-11,  -5.411758296512930D-10,   2.381185112997495D-08, &
&   -1.047722147252693D-06,   4.609977785169908D-05,  -2.028390237627474D-03, &
&    8.924917048463224D-02,                                                   &
&    5.182555727199569D-22,  -2.455895838078625D-20,   1.106681570937856D-18, &
&   -4.908500200740783D-17,   2.164741266972085D-15,  -9.530548668925757D-14, &
&    4.194010587902567D-12,  -1.845414043598164D-10,   8.119858213148791D-09, &
&   -3.572739835117099D-07,   1.572005635076550D-05,  -6.916824833193442D-04, &
&    3.043402927534777D-02,                                                   &
&    5.649217909316933D-23,  -2.668571173177234D-21,   1.201324348464009D-19, &
&   -5.326710869115608D-18,   2.348989663348894D-16,  -1.034151739281400D-14, &
&    4.550865143784669D-13,  -2.002432562253772D-11,   8.810741588192013D-10, &
&   -3.876728637783165D-08,   1.705760714048727D-06,  -7.505347182798116D-05, &
&    3.302352761412474D-03,                                                   &
&    1.980644832078031D-21,  -9.432504358479273D-20,   4.381673850931370D-18, &
&   -2.022269739159854D-16,   9.310775250500159D-15,  -4.283879972035608D-13, &
&    1.970675076315711D-11,  -9.065182044622900D-10,   4.169989287210385D-08, &
&   -1.918195404354660D-06,   8.823699018328494D-05,  -4.058901554057739D-03, &
&    1.867094714999232D-01,                                                   &
&    9.131043336551168D-22,  -4.323326014716119D-20,   2.004746562686755D-18, &
&   -9.247908135978032D-17,   4.257303751327088D-15,  -1.958723708019230D-13, &
&    9.010486952691199D-12,  -4.144854553676182D-10,   1.906635314911213D-08, &
&   -8.770523784238674D-07,   4.034441004643856D-05,  -1.855842864415791D-03, &
&    8.536877176852036D-02,                                                   &
&    3.124697638974791D-22,  -1.475817241308681D-20,   6.838180390310922D-19, &
&   -3.153773704281919D-17,   1.451767570037145D-15,  -6.679283615555704D-14, &
&    3.072584099886395D-12,  -1.413398410196610D-10,   6.501639767893149D-09, &
&   -2.990754720060064D-07,   1.375747191684036D-05,  -6.328437089057706D-04, &
&    2.911081061139822D-02,                                                   &
&    3.395448327813814D-23,  -1.602083431290045D-21,   7.420897762473828D-20, &
&   -3.422218101953990D-18,   1.575302949822065D-16,  -7.247604632973527D-15, &
&    3.334017637373176D-13,  -1.533658349638444D-11,   7.054835869008899D-10, &
&   -3.245224949837097D-08,   1.492803498513331D-06,  -6.866896100882667D-05, &
&    3.158772206589152D-03,                                                   &
&    1.178039549012618D-21,  -5.720905201040087D-20,   2.752226882746601D-18, &
&   -1.322412634724163D-16,   6.349231364591334D-15,  -3.047811190218744D-13, &
&    1.462966772957097D-11,  -7.022255126831953D-10,   3.370683507045680D-08, &
&   -1.617928145440881D-06,   7.766055127417822D-05,  -3.727706462193259D-03, &
&    1.789299101876921D-01,                                                   &
&    5.399873118747634D-22,  -2.617638611066489D-20,   1.258629044349018D-18, &
&   -6.046706977222828D-17,   2.903072939019683D-15,  -1.393546676886685D-13, &
&    6.689093615832862D-12,  -3.210770805011001D-10,   1.541170408237813D-08, &
&   -7.397618210736141D-07,   3.550856753056226D-05,  -1.704411241887901D-03, &
&    8.181173961160695D-02,                                                   &
&    1.843384128946140D-22,  -8.929000470226875D-21,   4.292289651502355D-19, &
&   -2.061972305286913D-17,   9.899541279407019D-16,  -4.752007738387320D-14, &
&    2.280985888083996D-12,  -1.094875100930638D-10,   5.255401834343293D-09, &
&   -2.522592961011092D-07,   1.210844625107444D-05,  -5.812054201869442D-04, &
&    2.789786016929144D-02,                                                   &
&    2.001134473791818D-23,  -9.690002373300604D-22,   4.657662101315115D-20, &
&   -2.237435041919920D-18,   1.074186911331621D-16,  -5.156337035347574D-15, &
&    2.475065133545355D-13,  -1.188033240466310D-11,   5.702560978501361D-10, &
&   -2.737229354708503D-08,   1.313870094298718D-06,  -6.306576454065196D-05, &
&    3.027156697984952D-03,                                                   &
&    7.007919469941056D-22,  -3.517102416352281D-20,   1.758263879766691D-18, &
&   -8.793951489407632D-17,   4.397296896098404D-15,  -2.198682883979178D-13, &
&    1.099344733086852D-11,  -5.496726402534873D-10,   2.748363395360928D-08, &
&   -1.374181709094505D-06,   6.870908550817954D-05,  -3.435454275595930D-03, &
&    1.717727137802306D-01,                                                   &
&    3.206619542900760D-22,  -1.608447951322462D-20,   8.039680496795743D-19, &
&   -4.020885947042550D-17,   2.010571359002396D-15,  -1.005299491196009D-13, &
&    5.026510712055202D-12,  -2.513256462849312D-10,   1.256628310199991D-08, &
&   -6.283141597484290D-07,   3.141570800926101D-05,  -1.570785400539664D-03, &
&    7.853927002716161D-02,                                                   &
&    1.093823963752073D-22,  -5.485324065940241D-21,   2.741599471411716D-19, &
&   -1.371132085888049D-17,   6.856069683998078D-16,  -3.428078930782795D-14, &
&    1.714043705193744D-12,  -8.570222072497889D-11,   4.285111289096302D-09, &
&   -2.142555659492301D-07,   1.071277830449326D-05,  -5.356389152493657D-04, &
&    2.678194576252589D-02,                                                   &
&    1.187056729045389D-23,  -5.952274518584365D-22,   2.974898635848552D-20, &
&   -1.487798975502821D-18,   7.439425993389843D-17,  -3.719759466426568D-15, &
&    1.859884205669219D-13,  -9.299424772384709D-12,   4.649712653314383D-10, &
&   -2.324856342455775D-08,   1.162428171971745D-06,  -5.812140860120198D-05, &
&    2.906070430066200D-03,                                                   &
&    4.223995703656451D-22,  -2.198928400195094D-20,   1.142456364415014D-18, &
&   -5.941278261347233D-17,   3.089526784822935D-15,  -1.606560393162484D-13, &
&    8.354120163997261D-12,  -4.344142989773483D-10,   2.258954390159937D-08, &
&   -1.174656284953214D-06,   6.108212682719022D-05,  -3.176270595047314D-03, &
&    1.651660709425374D-01,                                                   &
&    1.931748140523372D-22,  -1.005468607348075D-20,   5.223698926123034D-19, &
&   -2.716525844236110D-17,   1.412618514703879D-15,  -7.345642393702036D-14, &
&    3.819736526130156D-12,  -1.986263198877016D-10,   1.032856877900095D-08, &
&   -5.370855773557664D-07,   2.792845002645210D-05,  -1.452279401389273D-03, &
&    7.551852887227405D-02,                                                   &
&    6.587919389850225D-23,  -3.428743566550758D-21,   1.781295893183041D-19, &
&   -9.263384427180442D-18,   4.817040229727438D-16,  -2.504869284061655D-14, &
&    1.302532823819042D-12,  -6.773171343576270D-11,   3.522049145277352D-09, &
&   -1.831465558276610D-07,   9.523620904314018D-06,  -4.952282870287773D-04, &
&    2.575187092550672D-02,                                                   &
&    7.148748736792016D-24,  -3.720520589253482D-22,   1.932863538155630D-20, &
&   -1.005157091636208D-18,   5.226901674648451D-17,  -2.717997699437336D-15, &
&    1.413359644596862D-13,  -7.349470849220498D-12,   3.821724890901561D-10, &
&   -1.987296946160608D-08,   1.033394412138602D-06,  -5.373650943167864D-05, &
&    2.794298490448381D-03,                                                   &
&    2.588884104340899D-22,  -1.398388307744654D-20,   7.543618274515587D-19, &
&   -4.073649206431926D-17,   2.199782877484470D-15,  -1.187883948060261D-13, &
&    6.414574439910720D-12,  -3.463870289216173D-10,   1.870489962574518D-08, &
&   -1.010064580160893D-06,   5.454348733039973D-05,  -2.945348315847492D-03, &
&    1.590488090557781D-01,                                                   &
&    1.183782191970905D-22,  -6.393918820031448D-21,   3.449164336688546D-19, &
&   -1.862587236245852D-17,   1.005802147835543D-15,  -5.431336453708396D-14, &
&    2.932922142023888D-12,  -1.583777994204343D-10,   8.552401194962256D-09, &
&   -4.618296646805146D-07,   2.493880189345407D-05,  -1.346695302248963D-03, &
&    7.272154632144964D-02,                                                   &
&    4.036817620307371D-23,  -2.180346081830842D-21,   1.176169313559609D-19, &
&   -6.351437553415594D-18,   3.429792540166345D-16,  -1.852089531376746D-14, &
&    1.000128493977499D-12,  -5.400693988344790D-11,   2.916374762178917D-09, &
&   -1.574842372069496D-07,   8.504148809403757D-06,  -4.592240357085943D-04, &
&    2.479809792826591D-02,                                                   &
&    4.380343911455009D-24,  -2.365869174720137D-22,   1.276245269292748D-20, &
&   -6.891854541478036D-19,   3.721618672871327D-17,  -2.009675731636871D-15, &
&    1.085225050571944D-13,  -5.860215400987141D-12,   3.164516325504102D-10, &
&   -1.708838816294379D-08,   9.227729608231830D-07,  -4.982973988453581D-05, &
&    2.690805953765127D-03/
      data w4 / &
&    3.231561724943244D-11,  -6.126602923263628D-10,   7.808792717938715D-09, &
&   -8.569623080728158D-08,   8.439826606725827D-07,  -7.428950655878497D-06, &
&    5.763721324944968D-05,  -3.866467866140610D-04,   2.184175413347470D-03, &
&   -9.997910308852203D-03,   3.487910973972300D-02,  -8.282990754143865D-02, &
&    1.012285362903763D-01,                                                   &
&    1.860624578488254D-11,  -3.578502344154148D-10,   4.668568149923168D-09, &
&   -5.293364421221157D-08,   5.440797825740444D-07,  -5.058387051961868D-06, &
&    4.206522987411326D-05,  -3.080527281729691D-04,   1.944321959074704D-03, &
&   -1.024778255116357D-02,   4.286701442320861D-02,  -1.293143709637524D-01, &
&    2.223810344533745D-01,                                                   &
&    1.868145224279988D-12,  -3.706141715089653D-11,   5.085047264700964D-10, &
&   -6.183734352678161D-09,   6.957148510416666D-08,  -7.246609263397976D-07, &
&    6.941003799686509D-06,  -6.053814713196099D-05,   4.742419345433239D-04, &
&   -3.269561937456208D-03,   1.918838666703154D-02,  -8.980462425671282D-02, &
&    3.137066458778873D-01,                                                   &
&    1.964399993829784D-14,  -4.139236389274389D-13,   6.267271065214397D-12, &
&   -8.763436100695743D-11,   1.184610832610070D-09,  -1.546599367415001D-08, &
&    1.941434350743130D-07,  -2.338091906154933D-06,   2.689032211558928D-05, &
&   -2.942690120040433D-04,   3.065489170034688D-03,  -3.138443057142941D-02, &
&    3.626837833783620D-01,                                                   &
&    8.137849095714636D-12,  -1.061674430098638D-10,   1.252110451421606D-09, &
&   -1.374813231099106D-08,   1.368231531441886D-07,  -1.219951532648510D-06, &
&    9.608833290124203D-06,  -6.561828519242686D-05,   3.786869659764267D-04, &
&   -1.779245714447503D-03,   6.413197968763170D-03,  -1.588768117541735D-02, &
&    2.059291975169230D-02,                                                   &
&    4.805249375031314D-12,  -6.457050639441920D-11,   7.921574827908706D-10, &
&   -9.134968123231399D-09,   9.670350478206150D-08,  -9.315499303733030D-07, &
&    8.079881909256094D-06,  -6.222116916610426D-05,   4.172620446838803D-04, &
&   -2.368482363579551D-03,   1.087227591631214D-02,  -3.697974607626825D-02, &
&    7.665056120899771D-02,                                                   &
&    5.081099999394706D-13,  -7.265611262274657D-12,   9.668423509530040D-11, &
&   -1.230543629667292D-09,   1.470118626596248D-08,  -1.640945354009988D-07, &
&    1.700524237389415D-06,  -1.622507280444417D-05,   1.409058340163293D-04, &
&   -1.094519438265876D-03,   7.389755910418373D-03,  -4.088588033799037D-02, &
&    1.907116630936407D-01,                                                   &
&    5.855724656182239D-15,  -9.393677845069186D-14,   1.447015699303927D-12, &
&   -2.229887155850397D-11,   3.348086535977311D-10,  -4.822109266745055D-09, &
&    6.747693500629771D-08,  -9.132195843703865D-07,   1.187016458380363D-05, &
&   -1.485354391356276D-04,   1.796177620993805D-03,  -2.194887326649388D-02, &
&    3.101888626069734D-01,                                                   &
&    1.288329698955233D-12,  -1.696454514729687D-11,   2.022710048576449D-10, &
&   -2.248043851977560D-09,   2.268864879464383D-08,  -2.056393111015106D-07, &
&    1.651352537929484D-06,  -1.154142832050806D-05,   6.851200390092001D-05, &
&   -3.333870860871961D-04,   1.256837833661381D-03,  -3.305126661784756D-03, &
&    4.683485459413312D-03,                                                   &
&    8.008336537482189D-13,  -1.101835926518499D-11,   1.390616183055003D-10, &
&   -1.656016620847720D-09,   1.820153232585341D-08,  -1.832289446895316D-07, &
&    1.673772507167430D-06,  -1.370734560642586D-05,   9.894348612150861D-05, &
&   -6.140060317555330D-04,   3.149953294171062D-03,  -1.232231924563920D-02, &
&    3.233607978071216D-02,                                                   &
&    9.378687135761750D-14,  -1.407614681660518D-12,   1.979648176679726D-11, &
&   -2.675547333535025D-10,   3.423311390910612D-09,  -4.126389311900314D-08, &
&    4.654574466023260D-07,  -4.887873685107928D-06,   4.729373586331198D-05, &
&   -4.151253647337639D-04,   3.225842959482652D-03,  -2.098447902258273D-02, &
&    1.315691105894347D-01,                                                   &
&    1.292968570998469D-15,  -2.206188723253698D-14,   3.760702281865996D-13, &
&   -6.571067606948314D-12,   1.059767987979796D-10,  -1.661506460219346D-09, &
&    2.624914606866623D-08,  -3.941016648083752D-07,   5.737618086677269D-06, &
&   -8.150801579592481D-05,   1.130256993681323D-03,  -1.622870713155242D-02, &
&    2.724520195516506D-01,                                                   &
&    2.073996314179963D-13,  -2.762227823152802D-12,   3.338189825830019D-11, &
&   -3.766847072943510D-10,   3.869793984344202D-09,  -3.581670895639196D-08, &
&    2.949092571689658D-07,  -2.124660063601848D-06,   1.309333912857922D-05, &
&   -6.679560996114570D-05,   2.678559470667483D-04,  -7.654893417583748D-04, &
&    1.244552554434896D-03,                                                   &
&    1.389670855523186D-13,  -1.969049611116846D-12,   2.573219376511029D-11, &
&   -3.187083433889454D-10,   3.667069478953496D-09,  -3.892093906559072D-08, &
&    3.781894048911588D-07,  -3.331819962866387D-06,   2.619459243841528D-05, &
&   -1.800897197604578D-04,   1.048876648993289D-03,  -4.766267521129349D-03, &
&    1.661126972967946D-02,                                                   &
&    1.866690346285856D-14,  -2.964218146281864D-13,   4.420419303758356D-12, &
&   -6.386200629012274D-11,   8.833034723451009D-10,  -1.151882356119565D-08, &
&    1.417671316914205D-07,  -1.647990258292929D-06,   1.776112116042491D-05, &
&   -1.759745491684100D-04,   1.568186976602669D-03,  -1.186638360318491D-02, &
&    9.980807391334094D-02,                                                   &
&    3.355539322207900D-16,  -5.373271355666298D-15,   1.175139168121092D-13, &
&   -2.219849913460372D-12,   3.437579439106665D-11,  -6.403562162301324D-10, &
&    1.144495960129952D-08,  -1.819517441028108D-07,   3.002798771134548D-06, &
&   -4.794215463986781D-05,   7.527302864031779D-04,  -1.252930913200997D-02, &
&    2.439442511562032D-01,                                                   &
&    3.406703475429816D-14,  -4.601827498136225D-13,   5.655875553962861D-12, &
&   -6.505749412269609D-11,   6.836576795426172D-10,  -6.499871985617670D-09, &
&    5.528396174714075D-08,  -4.144635617417154D-07,   2.683233820092540D-06, &
&   -1.458033381892778D-05,   6.357763351237573D-05,  -2.027827673659330D-04, &
&    4.072538745535540D-04,                                                   &
&    2.532472378226240D-14,  -3.720046343062188D-13,   5.061316462886416D-12, &
&   -6.577045971598000D-11,   7.989966897086395D-10,  -9.005065178674003D-09, &
&    9.407596626736021D-08,  -9.010810101456296D-07,   7.770323600667867D-06, &
&   -5.990687260803630D-05,   4.004260043952855D-04,  -2.101846860879785D-03, &
&    1.016603945723640D-02,                                                   &
&    4.090800745142495D-15,  -6.829353603482605D-14,   1.064433442511018D-12, &
&   -1.694961988186524D-11,   2.530570521648794D-10,  -3.516484120609908D-09, &
&    4.792773137968524D-08,  -6.188503713423772D-07,   7.342799753642248D-06, &
&   -8.227612791463049D-05,   8.343831866429884D-04,  -7.245977682146183D-03, &
&    8.117949657819691D-02,                                                   &
&    2.851599206595839D-17,  -1.035990414196552D-15,   6.073900377245371D-14, &
&   -5.962083959949737D-13,   1.065921261202402D-11,  -3.182806788829914D-10, &
&    5.171247149165622D-09,  -8.665750436208254D-08,   1.721621219261058D-06, &
&   -2.967395925520788D-05,   5.249574567653116D-04,  -1.001021923294588D-02, &
&    2.215558974113203D-01,                                                   &
&    5.738443554325256D-15,  -7.884846026070249D-14,   9.895848997707408D-13, &
&   -1.166969630739111D-11,   1.261855444162149D-10,  -1.241287233920980D-09, &
&    1.101565105018886D-08,  -8.694224011228390D-08,   5.994601944183148D-07, &
&   -3.541219272919701D-06,   1.721604753309018D-05,  -6.245253088647934D-05, &
&    1.718779890644095D-04,                                                   &
&    4.950683591527513D-15,  -7.409777500348394D-14,   1.066621014743147D-12, &
&   -1.479187745848506D-11,   1.887602074458543D-10,  -2.278125754425465D-09, &
&    2.606363791014394D-08,  -2.711877397416955D-07,   2.567520415402058D-06, &
&   -2.263535501600572D-05,   1.730910339971873D-04,  -1.027744176495987D-03, &
&    7.185328959450600D-03,                                                   &
&    1.082756545610888D-15,  -1.417206577309595D-14,   2.917827674788896D-13, &
&   -5.296077604107685D-12,   7.528734078979532D-11,  -1.160383596138881D-09, &
&    1.842536088609071D-08,  -2.529701653645346D-07,   3.272319691254952D-06, &
&   -4.221229052722951D-05,   4.769711347987054D-04,  -4.702445313923210D-03, &
&    6.946722085677561D-02,                                                   &
&   -1.777622693338639D-16,  -4.071442707664024D-15,   1.576457862060958D-14, &
&    2.920213750958101D-13,   9.199196874503057D-12,  -1.813429002301771D-10, &
&    1.696483356486912D-09,  -4.730610321834406D-08,   1.086509547449989D-06, &
&   -1.870134130416037D-05,   3.823442500902554D-04,  -8.217457507538334D-03, &
&    2.034229627013521D-01,                                                   &
&    9.921307791336830D-16,  -1.393331073638356D-14,   1.808779025499099D-13, &
&   -2.194626977660621D-12,   2.450621494347376D-11,  -2.527121473428738D-10, &
&    2.371189418038125D-09,  -1.986617009378203D-08,   1.483072659078333D-07, &
&   -9.799993963196074D-07,   5.391897438999382D-06,  -2.219007873391854D-05, &
&    9.488989438509604D-05,                                                   &
&    8.754640289164668D-16,  -1.577398624479403D-14,   2.622609341434338D-13, &
&   -3.531620852519879D-12,   4.695804889413420D-11,  -6.530774016555570D-10, &
&    8.107471069953377D-09,  -8.819317723628479D-08,   9.451248620011392D-07, &
&   -9.775768562031477D-06,   8.220935698632913D-05,  -5.423910971574763D-04, &
&    5.674942403027288D-03,                                                   &
&   -1.598136927586662D-16,  -5.183420317876362D-15,   1.387227567417787D-13, &
&   -1.301123550090560D-12,   2.015411479211075D-11,  -4.912747929511659D-10, &
&    7.877620672998118D-09,  -1.042571477975687D-07,   1.589645627802538D-06, &
&   -2.374385907816476D-05,   2.857513006447906D-04,  -3.213547575272973D-03, &
&    6.167782604363103D-02,                                                   &
&    5.434487134901424D-16,  -8.315051161090759D-17,  -6.723659054094789D-14, &
&   -3.642359283184143D-13,   1.126957110055342D-11,  -1.174059666746861D-12, &
&    3.696898352986167D-10,  -3.747819517626534D-08,   6.759635438830380D-07, &
&   -1.171351584251761D-05,   2.927311236231181D-04,  -6.881258178711871D-03, &
&    1.883837721883396D-01,                                                   &
&    1.781348223123351D-16,  -2.675452933601186D-15,   3.457777477946628D-14, &
&   -4.263083295789271D-13,   5.106985602177263D-12,  -5.643816012016057D-11, &
&    5.539192883102462D-10,  -4.951732568987835D-09,   4.170989161282319D-08, &
&   -3.159085025198189D-07,   1.916800405523342D-06,  -8.863059513988421D-06, &
&    6.609924977207956D-05,                                                   &
&    2.839744467033005D-16,  -5.573020035739869D-15,   5.294874241832047D-14, &
&   -7.173556311706365D-13,   1.486138187161197D-11,  -2.245078376808896D-10, &
&    2.540774631136659D-09,  -3.012075092764193D-08,   4.080887794436128D-07, &
&   -4.742411393975400D-06,   4.075971951602382D-05,  -3.063691614545883D-04, &
&    4.853537041231362D-03,                                                   &
&    3.518705252799645D-16,  -5.552227934934716D-15,  -6.869503498378384D-15, &
&    5.772199262325169D-14,   1.350562681173442D-11,  -2.548529785089586D-10, &
&    2.761588584382241D-09,  -4.363948070253031D-08,   9.011239995467236D-07, &
&   -1.418066109064112D-05,   1.746911227436775D-04,  -2.311629893608627D-03, &
&    5.622632923292524D-02,                                                   &
&   -3.424983292099144D-16,   5.997170133463704D-15,   4.339252079179014D-14, &
&   -8.627583558101280D-13,  -3.372587263043825D-12,   7.528558324032554D-11, &
&    1.175680025515224D-09,  -2.931522771052084D-08,   3.333499849589470D-07, &
&   -7.729179804690857D-06,   2.357806115093415D-04,  -5.832182472921066D-03, &
&    1.757081144547420D-01,                                                   &
&    3.829090966122153D-17,  -4.601826882890739D-16,   6.322748499750441D-15, &
&   -9.495325333027043D-14,   1.229120902031150D-12,  -1.333509994814823D-11, &
&    1.349079292139511D-10,  -1.401409206246265D-09,   1.399802766685825D-08, &
&   -1.159805435842772D-07,   7.287838880849154D-07,  -3.962715407499170D-06, &
&    5.405131366405841D-05,                                                   &
&    1.127022690867585D-16,   3.291459462886695D-16,   3.391328034764732D-15, &
&   -3.820995554106253D-13,   6.406002347372100D-12,  -6.129694267587774D-11, &
&    6.926734442484265D-10,  -1.298697059475632D-08,   2.107306279837982D-07, &
&   -2.378346300961090D-06,   2.017243686536511D-05,  -1.891890094056141D-04, &
&    4.371601215453635D-03,                                                   &
&    9.643236012780802D-17,   3.214400550187846D-15,  -1.868448440727201D-14, &
&   -5.531182888432757D-13,   9.312559800915688D-12,  -5.587853097880588D-11, &
&    6.638938707698726D-10,  -2.592038595224531D-08,   5.741474145632110D-07, &
&   -8.393896122855905D-06,   1.082587519971006D-04,  -1.757258601077675D-03, &
&    5.220155775916095D-02,                                                   &
&   -1.395030305603834D-16,  -5.008546214936222D-15,   4.239462397563602D-14, &
&    4.509134373262324D-13,  -6.969790336945712D-12,  -4.126735262456322D-11, &
&    1.480413301947762D-09,  -1.164945188425847D-08,   1.253465729291143D-07, &
&   -6.014527630420273D-06,   1.953840922450849D-04,  -4.973233905741009D-03, &
&    1.649295176591136D-01,                                                   &
&    3.160405502913612D-18,  -9.173721804192104D-17,   1.862375018134398D-15, &
&   -2.535374093273447D-14,   2.711279471883417D-13,  -2.946951894785507D-12, &
&    3.836416441987494D-11,  -5.027586543996197D-10,   5.408145568139961D-09, &
&   -4.416140138404760D-08,   2.819845659763658D-07,  -2.082526116380271D-06, &
&    4.829949633489976D-05,                                                   &
&   -6.194760828553678D-17,  -1.058156553174305D-16,   1.410124040633624D-14, &
&   -1.807620577837155D-13,   9.714542433503254D-13,  -7.255821875973598D-12, &
&    3.156996576526344D-10,  -7.679181433953962D-09,   1.109625358314859D-07, &
&   -1.125977107456356D-06,   1.005576011766114D-05,  -1.312237599719190D-04, &
&    4.057880214637909D-03,                                                   &
&   -1.712490554927565D-16,  -2.422192149504932D-17,   2.874691138960377D-14, &
&   -3.103605790835110D-13,   4.881934821926088D-14,   1.246037459780725D-11, &
&    5.385682977866601D-10,  -1.964311704309169D-08,   3.472210343063027D-07, &
&   -4.749032064303115D-06,   6.973708514770489D-05,  -1.408540622270555D-03, &
&    4.906131872761593D-02,                                                   &
&    2.572984129070810D-16,  -3.068128925050805D-16,  -3.462806453133276D-14, &
&    3.232306222273081D-13,   2.413961918280944D-12,  -7.360203296851699D-11, &
&    4.919793260711109D-10,   6.247854200646034D-10,   8.048422770689559D-08, &
&   -5.273611452771206D-06,   1.616907849263875D-04,  -4.260532922486578D-03, &
&    1.557181907018266D-01,                                                   &
&    2.069094033303934D-18,  -3.917699047136956D-17,   4.486310395633009D-16, &
&   -4.082127806184496D-15,   4.858540923160968D-14,  -8.910669816408829D-13, &
&    1.549388821918105D-11,  -2.069980187823874D-10,   2.080208948277003D-09, &
&   -1.614399766540990D-08,   1.142061055516505D-07,  -1.345411223614152D-06, &
&    4.498166946287519D-05,                                                   &
&    2.047497740644064D-17,  -4.717125700457452D-16,   3.603616249841133D-15, &
&    8.285812099009393D-15,  -2.408529322168694D-13,  -6.002815188224136D-12, &
&    2.442096832933015D-10,  -4.324346622642104D-09,   5.161829578520734D-08, &
&   -4.980205880113081D-07,   5.420619279856835D-06,  -1.015179665738536D-04, &
&    3.828197031227469D-03,                                                   &
&    4.737131368113822D-17,  -1.047478030413376D-15,   6.194147847959145D-15, &
&    7.177929229061923D-14,  -1.357803058134988D-12,  -7.330527213801386D-12, &
&    5.978678684551054D-10,  -1.252116230126522D-08,   1.857623661424290D-07, &
&   -2.664997673274409D-06,   4.814135512176453D-05,  -1.176932577475255D-03, &
&    4.649015646956688D-02,                                                   &
&   -6.228661776844984D-17,   1.396967397382919D-15,  -6.862035429812070D-15, &
&   -1.475318357156045D-13,   3.068260775728573D-12,  -1.819091174374272D-11, &
&   -1.591751027022123D-10,   1.813207194901196D-09,   9.919977701404143D-08, &
&   -4.561701625048332D-06,   1.321047588241755D-04,  -3.674363113947778D-03, &
&    1.478030296597164D-01,                                                   &
&    6.580775860745632D-19,  -5.322571961176337D-18,   2.911624266522522D-17, &
&   -5.562665111260444D-16,   1.900644361772372D-14,  -4.289287914330904D-13, &
&    6.761302484557156D-12,  -7.972397428373202D-11,   7.329481127093292D-10, &
&   -5.731639573655247D-09,   5.389948554455280D-08,  -1.029690048058794D-06, &
&    4.264606715071974D-05,                                                   &
&    9.699020398636699D-18,  -1.963551947572265D-17,  -1.176920434015015D-15, &
&    1.512600225968787D-14,   1.091247138280985D-13,  -7.135708721355506D-12, &
&    1.451940823163987D-10,  -1.971944929521133D-09,   2.114152226004841D-08, &
&   -2.226853342608821D-07,   3.379599795944680D-06,  -8.446191366266925D-05, &
&    3.643561730589370D-03,                                                   &
&    2.200638899614862D-17,  -3.615124645405716D-18,  -3.897495044097374D-15, &
&    5.447634612811658D-14,   7.148274907326766D-14,  -1.700913881575548D-11, &
&    3.997327151708333D-10,  -6.402009307871973D-09,   9.318429023554862D-08, &
&   -1.590182276432010D-06,   3.574447782949634D-05,  -1.011294123671451D-03, &
&    4.431014529316856D-02,                                                   &
&   -3.000477348146244D-17,  -2.585661440193476D-17,   6.295792741107633D-15, &
&   -9.804541268481212D-14,   4.763165353459671D-13,   8.708252276923552D-12, &
&   -1.757674263253827D-10,  -5.686292792260373D-10,   1.054878250359509D-07, &
&   -3.726578687522606D-06,   1.072147483413288D-04,  -3.197400978867977D-03, &
&    1.409478622630451D-01,                                                   &
&    9.300174616367356D-21,   3.914711572485540D-19,   4.445794294437689D-18, &
&   -4.078376491255477D-16,   1.090455041648635D-14,  -1.923445835967532D-13, &
&    2.561729691245508D-12,  -2.709139960238041D-11,   2.405697931188992D-10, &
&   -2.184047722344613D-09,   3.208867971323344D-08,  -8.646710640107819D-07, &
&    4.076599030558878D-05,                                                   &
&   -1.309931295959551D-18,   4.151800635701775D-17,  -4.293298955043920D-16, &
&   -2.791227777448381D-15,   1.948559622228601D-13,  -4.265650339269706D-12, &
&    6.388302084606465D-11,  -7.588995998513435D-10,   8.303326573725491D-09, &
&   -1.129369752410157D-07,   2.423431845509420D-06,  -7.307214433945768D-05, &
&    3.486658395414924D-03,                                                   &
&   -3.870323467447422D-18,   1.207870303998811D-16,  -1.416362807683098D-15, &
&   -2.309188468242801D-15,   4.598362832608469D-13,  -1.137988775292186D-11, &
&    1.940735467712982D-10,  -2.921859764549547D-09,   4.863513506901599D-08, &
&   -1.045993099564781D-06,   2.801248756036665D-05,  -8.848593553286785D-04, &
&    4.241912303127927D-02,                                                   &
&    5.970816234352490D-18,  -1.827610630752814D-16,   2.343614372073625D-15, &
&   -7.188635206592535D-15,  -3.428880664384819D-13,   7.576039874325388D-12, &
&   -4.697740595666576D-11,  -1.883066627276411D-09,   9.191227377361699D-08, &
&   -2.928248290630506D-06,   8.730563318851422D-05,  -2.809960362622948D-03, &
&    1.349537662217961D-01,                                                   &
&   -1.684109917788903D-20,  -5.744034540026547D-20,   8.964076698713533D-18, &
&   -2.539154716845120D-16,   4.810215275200596D-15,  -7.042139677419269D-14, &
&    8.366491394563574D-13,  -8.397301818867526D-12,   8.014808152684945D-11, &
&   -1.023548157598517D-09,   2.309404008647312D-08,  -7.565780608134933D-07, &
&    3.915065462526449D-05,                                                   &
&   -9.363956476264674D-19,   8.001249390845385D-18,   9.004709776147820D-17, &
&   -4.893658404652279D-15,   1.102929593205429D-13,  -1.780297468365700D-12, &
&    2.319707054603451D-11,  -2.713300402871880D-10,   3.555717654009699D-09, &
&   -6.870465018407094D-08,   1.897175721136693D-06,  -6.451812031208276D-05, &
&    3.349416497358022D-03,                                                   &
&   -2.647534304745846D-18,   2.666210289306031D-17,   1.293987246509550D-16, &
&   -1.157839902678936D-14,   2.890009865509437D-13,  -5.184260991080137D-12, &
&    8.148370048225155D-11,  -1.355807701178581D-09,   2.836583230318701D-08, &
&   -7.483128795434278D-07,   2.270975398745525D-05,  -7.840061232476220D-04, &
&    4.075378206811332D-02,                                                   &
&    3.895380157166923D-18,  -4.260149963434684D-17,  -1.152135960852329D-17, &
&    1.078932621514722D-14,  -2.406630995108782D-13,   2.502146843079898D-12, &
&    2.140244930051394D-11,  -1.964377852160546D-09,   7.199580926088400D-08, &
&   -2.272170689233931D-06,   7.178458389634415D-05,  -2.493092245109960D-03, &
&    1.296610502549974D-01,                                                   &
&    2.124344219286401D-21,  -1.894041906285171D-19,   5.353147155850353D-18, &
&   -1.063494104951878D-16,   1.681311299107069D-15,  -2.205103207421722D-14, &
&    2.473166776850868D-13,  -2.560694975044676D-12,   3.113584692646488D-11, &
&   -6.164392920933759D-10,   1.836554403042221D-08,  -6.744580505457087D-07, &
&    3.772274557638147D-05,                                                   &
&   -9.594817759944409D-20,  -2.561428808655253D-18,   1.105567650828532D-16, &
&   -2.518274688860673D-15,   4.319484345211552D-14,  -6.111443909744647D-13, &
&    7.710586597644926D-12,  -1.020856712028781D-10,   1.840995931997950D-09, &
&   -4.822458537240108D-08,   1.553125875903139D-06,  -5.765803820943437D-05, &
&    3.227468813906904D-03,                                                   &
&   -3.572713421967041D-19,  -4.671409468806554D-18,   2.640604586764410D-16, &
&   -6.541358742826021D-15,   1.224959761825786D-13,  -2.018381397744192D-12, &
&    3.418514303660483D-11,  -7.057576806882009D-10,   1.852474139012823D-08, &
&   -5.650258414468089D-07,   1.880873094384351D-05,  -7.013340273518541D-04, &
&    3.927103742160618D-02,                                                   &
&    5.677813525221702D-19,   4.013298009789839D-18,  -2.803474108192798D-16, &
&    6.229623615498496D-15,  -8.031622508422639D-14,   5.149795712992863D-14, &
&    3.625940530824823D-11,  -1.584434999170554D-09,   5.410923368662153D-08, &
&   -1.770328569733127D-06,   5.972874434973978D-05,  -2.231068233923275D-03, &
&    1.249449174415681D-01,                                                   &
&    3.683279365219479D-21,  -1.016552553463058D-19,   2.090790377660879D-18, &
&   -3.530025583793858D-17,   5.046229469370146D-16,  -6.252164128669540D-15, &
&    7.079229934793770D-14,  -8.685172024010439D-13,   1.571214846263454D-11, &
&   -4.400425448361733D-10,   1.525643006577790D-08,  -6.075625465190249D-07, &
&    3.644278975518993D-05,                                                   &
&    6.151440561576919D-20,  -2.220735544481515D-18,   5.100923716992269D-17, &
&   -9.223374790674894D-16,   1.405338300385205D-14,  -1.913537652742931D-13, &
&    2.630207120400096D-12,  -4.581116611083852D-11,   1.151247237239616D-09, &
&   -3.662314337764575D-08,   1.301302261184388D-06,  -5.197223910963029D-05, &
&    3.118006058629303D-03,                                                   &
&    1.268593257038541D-19,  -5.362561865331823D-18,   1.321362627522062D-16, &
&   -2.573957957567322D-15,   4.453364400157413D-14,  -7.773532839489761D-13, &
&    1.605490394911974D-11,  -4.214252352812994D-10,   1.306726267258195D-08, &
&   -4.405307166897974D-07,   1.581374941588399D-05,  -6.323373115950640D-04, &
&    3.793935985332836D-02,                                                   &
&   -1.428120782148708D-19,   6.143697323582200D-18,  -1.369568014491558D-16, &
&    2.006965387218244D-15,  -1.066187656093719D-14,  -5.747947714761695D-13, &
&    3.131308139876314D-11,  -1.170516471965249D-09,   4.038649139363609D-08, &
&   -1.395116275110136D-06,   5.028725830023041D-05,  -2.011785543074562D-03, &
&    1.207083506779272D-01,                                                   &
&    1.732546657138613D-21,  -3.700848679123005D-20,   6.589059266836097D-19, &
&   -1.016959827449769D-17,   1.378070702464619D-16,  -1.704511001345358D-15, &
&    2.178531303621055D-14,  -3.750752804361887D-13,   9.971011015930163D-12, &
&   -3.405177561593236D-10,   1.293733676812689D-08,  -5.513727932167240D-07, &
&    3.528539748736875D-05,                                                   &
&    3.978009739412554D-20,  -9.265065912667077D-19,   1.750592104170492D-17, &
&   -2.853748177566390D-16,   4.182221811226258D-15,  -6.052350429529461D-14, &
&    1.047612129086687D-12,  -2.553400103672109D-11,   8.099894392677023D-10, &
&   -2.891101527692032D-08,   1.106052564090109D-06,  -4.717290099057484D-05, &
&    3.018990905319580D-03,                                                   &
&    9.729489629319033D-20,  -2.400774368569132D-18,   4.840548508829501D-17, &
&   -8.796966368514709D-16,   1.595181237716158D-14,  -3.335940390537520D-13, &
&    8.802480907858387D-12,  -2.783818546816155D-10,   9.639711015998765D-09, &
&   -3.506483735246011D-07,   1.345386552003507D-05,  -5.739814695664649D-04, &
&    3.673461251088371D-02,                                                   &
&   -1.168367226016584D-19,   2.630820592861327D-18,  -4.205340050211839D-17, &
&    3.494058630711885D-16,   7.709507457282631D-15,  -5.592748153827429D-13, &
&    2.304223045837879D-11,  -8.447106951783720D-10,   3.039371974532983D-08, &
&   -1.114166972339951D-06,   4.279931273004218D-05,  -1.826173431093879D-03, &
&    1.168753783507467D-01,                                                   &
&    5.876401444237314D-22,  -1.112634034318720D-20,   1.826431477779253D-19, &
&   -2.684109686752580D-18,   3.610931915260644D-17,  -4.884014631515897D-16, &
&    8.281537624610530D-15,  -2.112143886831931D-13,   7.170951331491319D-12, &
&   -2.730205347456971D-10,   1.110781826596010D-08,  -5.034170530474024D-07, &
&    3.423182584648604D-05,                                                   &
&    1.507901380973917D-20,  -3.001197026308045D-19,   5.171372921721262D-18, &
&   -8.125673453216368D-17,   1.245946937333594D-15,  -2.188881106685994D-14, &
&    5.241899353016161D-13,  -1.663079003738320D-11,   6.042939269913960D-10, &
&   -2.331254063333831D-08,   9.502006117027134D-07,  -4.307156824333154D-05, &
&    2.928850228456462D-03,                                                   &
&    3.919863090120944D-20,  -8.254114217373099D-19,   1.565299749139395D-17, &
&   -2.962580277175562D-16,   6.335090584072765D-15,  -1.690281702565681D-13, &
&    5.460052331745957D-12,  -1.950724624278784D-10,   7.305514923829876D-09, &
&   -2.834198663136192D-07,   1.156097124349867D-05,  -5.240860326073248D-04, &
&    3.563780569833667D-02,                                                   &
&   -4.457122790692374D-20,   7.715194638046025D-19,  -8.034823536832192D-18, &
&   -8.406946959111552D-17,   9.096558530806862D-15,  -4.147450210793695D-13, &
&    1.620190652477791D-11,  -6.112971321187643D-10,   2.318212505586994D-08, &
&   -9.014169327565575D-07,   3.678135262442509D-05,  -1.667436979601324D-03, &
&    1.133857760777040D-01,                                                   &
&    1.687468336072992D-22,  -2.980100363151402D-21,   4.673038037757851D-20, &
&   -6.801123680483861D-19,   9.800354531834515D-18,  -1.678450257690710D-16, &
&    4.164261598173125D-15,  -1.408982069687432D-13,   5.450620693457108D-12, &
&   -2.229972830010675D-10,   9.626614269462468D-09,  -4.620480502422450D-07, &
&    3.326734730107728D-05,                                                   &
&    4.621897351591984D-21,  -8.512380845885520D-20,   1.416288501750388D-18, &
&   -2.305667195782333D-17,   4.170547285336603D-16,  -9.945116686315050D-15, &
&    3.164188885958404D-13,  -1.175058351941338D-11,   4.644349829539731D-10, &
&   -1.906994391289960D-08,   8.236109656480528D-07,  -3.953241739129309D-05, &
&    2.846330561637582D-03,                                                   &
&    1.269147226042757D-20,  -2.543731270952070D-19,   5.000942288499791D-18, &
&   -1.101578865669472D-16,   2.989980050910606D-15,  -9.879678254728222D-14, &
&    3.646563236998850D-12,  -1.414038909768817D-10,   5.641146462779802D-09, &
&   -2.319897233016864D-07,   1.002138557935124D-05,  -4.810240368667713D-04, &
&    3.463372113437783D-02,                                                   &
&   -1.244522623564062D-20,   1.533014733905783D-19,   6.541733333529433D-19, &
&   -1.358453072520336D-16,   6.865039321648163D-15,  -2.859142377785930D-13, &
&    1.133987569773138D-11,  -4.478531311713674D-10,   1.793490808963570D-08, &
&   -7.380360162145246D-07,   3.188394384751766D-05,  -1.530432714017519D-03, &
&    1.101911685321432D-01,                                                   &
&    4.372152692035070D-23,  -7.418371660124829D-22,   1.150116093607112D-20, &
&   -1.768783719313298D-19,   3.112350631005271D-18,  -7.624663853292209D-17, &
&    2.576685300739509D-15,  -1.017025805457887D-13,   4.253253602550699D-12, &
&   -1.844414415818661D-10,   8.409075135904762D-09,  -4.260536795328908D-07, &
&    3.238005662782677D-05,                                                   &
&    1.261172330400391D-21,  -2.253945569698456D-20,   3.859040549969954D-19, &
&   -7.252522109237829D-18,   1.743204594809402D-16,  -5.582904419952071D-15, &
&    2.121429229296010D-13,  -8.639263557947966D-12,   3.635197612487712D-10, &
&   -1.577878758021107D-08,   7.194676078253160D-07,  -3.645283430552586D-05, &
&    2.770414685181428D-03,                                                   &
&    3.742352504447365D-21,  -7.767693577331827D-20,   1.758899244877539D-18, &
&   -4.884116322400236D-17,   1.653944742515493D-15,  -6.308717944070071D-14, &
&    2.537963863355513D-12,  -1.047926613879257D-10,   4.421200817110337D-09, &
&   -1.919837500772967D-07,   8.754336128805307D-06,  -4.435525081432990D-04, &
&    3.370998864004192D-02,                                                   &
&   -2.485489509197606D-21,  -6.034141625639074D-22,   1.878429892943561D-18, &
&   -1.051188683216054D-16,   4.662184353737982D-15,  -1.944593791265992D-13, &
&    8.018504026910997D-12,  -3.329810542532635D-10,   1.406386828777223D-08, &
&   -6.108050215301011D-07,   2.785287841692771D-05,  -1.411213226125494D-03, &
&    1.072522079094416D-01,                                                   &
&    1.060197698935941D-23,  -1.780332836551451D-22,   2.889498911978559D-21, &
&   -5.280082998280427D-20,   1.295185640933563D-18,  -4.387050159563747D-17, &
&    1.768865436238520D-15,  -7.607457814028113D-14,   3.372380790232194D-12, &
&   -1.541091681395432D-10,   7.396940409816892D-09,  -3.945022449832619D-07, &
&    3.156017499121194D-05,                                                   &
&    3.237029930189278D-22,  -5.933995612507280D-21,   1.154305118351529D-19, &
&   -2.824910491471341D-18,   9.149910668062170D-17,  -3.559839445983572D-15, &
&    1.496606775583719D-13,  -6.496478393820372D-12,   2.884628647348151D-10, &
&   -1.318510509143765D-08,   6.328756609728726D-07,  -3.375332944006598D-05, &
&    2.700266209464584D-03,                                                   &
&    1.098998660073188D-21,  -2.604003161162575D-20,   7.387700978270510D-19, &
&   -2.569586775316294D-17,   1.013039648036159D-15,  -4.229810899632454D-14, &
&    1.812119708994578D-12,  -7.898168625261253D-11,   3.509563909111196D-09, &
&   -1.604323791705973D-07,   7.700728508906858D-06,  -4.107054130004356D-04, &
&    3.285643263887242D-02,                                                   &
&   -8.437826510012540D-23,  -2.414210195080879D-20,   1.497487298093648D-18, &
&   -7.056654954880213D-17,   3.093047680849189D-15,  -1.332504635867110D-13, &
&    5.753779838686440D-12,  -2.512019392808706D-10,   1.116554211229306D-08, &
&   -5.104314359152663D-07,   2.450074429829204D-05,  -1.306706510438868D-03, &
&    1.045365213866200D-01,                                                   &
&    2.486420686204678D-24,  -4.344948516312682D-23,   8.213792943826603D-22, &
&   -2.041173976609241D-20,   6.962683764847422D-19,  -2.869392737132300D-17, &
&    1.271873363129110D-15,  -5.804052977457106D-14,   2.706753441347169D-12, &
&   -1.299125788742788D-10,   6.547533727033125D-09,  -3.666616419568005D-07, &
&    3.079957702114484D-05,                                                   &
&    8.274094219234024D-23,  -1.701510862504355D-21,   4.239283230452685D-20, &
&   -1.395694996039768D-18,   5.564377008862433D-17,  -2.416293072470305D-15, &
&    1.084891903400312D-13,  -4.963495605242655D-12,   2.315733934228592D-10, &
&   -1.111515877518113D-08,   5.602020993893130D-07,  -3.137130973611149D-05, &
&    2.635189989050848D-03,                                                   &
&    3.542409181602579D-22,  -1.042450449477030D-20,   3.716381779529351D-19, &
&   -1.514688656537216D-17,   6.562789135456095D-16,  -2.919410203511709D-14, &
&    1.318293646333637D-12,  -6.038196384770256D-11,   2.817670714656260D-09, &
&   -1.352471955459970D-07,   6.816453422010835D-06,  -3.817213700455683D-04, &
&    3.206459500429079D-02,                                                   &
&    2.934233943530563D-22,  -1.994574946222932D-20,   9.958176998056857D-19, &
&   -4.580348769253465D-17,   2.060858176045118D-15,  -9.261268629381381D-14, &
&    4.191948664583878D-12,  -1.920948364548896D-10,   8.964638172237858D-09, &
&   -4.303040067203609D-07,   2.168732913534170D-05,  -1.214490461242621D-03, &
&    1.020171988536029D-01,                                                   &
&    5.923212042830001D-25,  -1.185911102041723D-23,   2.987618072657367D-22, &
&   -1.031745912857450D-20,   4.349078147961087D-19,  -1.988155529206412D-17, &
&    9.366676862580462D-16,  -4.491199920949752D-14,   2.195333255470291D-12, &
&   -1.103915923768670D-10,   5.828664223337571D-09,  -3.419482531128877D-07, &
&    3.009144610016211D-05,                                                   &
&    2.294190090291059D-23,  -5.939083738524300D-22,   1.985837397875043D-20, &
&   -8.122589995268720D-19,   3.643310659366776D-17,  -1.693495629832855D-15, &
&    8.007682410469835D-14,  -3.842180214140589D-12,   1.878284277631052D-10, &
&   -9.445013507362817D-09,   4.986963359166806D-07,  -2.925685017352669D-05, &
&    2.574602809696009D-03,                                                   &
&    1.364146020703198D-22,  -5.033504703096069D-21,   2.115553247960595D-19, &
&   -9.507863166881801D-18,   4.391329258992448D-16,  -2.056522620078677D-14, &
&    9.740141045800782D-13,  -4.674854632818867D-11,   2.285452902758262D-09, &
&   -1.149254301685834D-07,   6.068061671082842D-06,  -3.559929471259684D-04, &
&    3.132737933162648D-02,                                                   &
&    2.497139094219420D-22,  -1.316715748920183D-20,   6.338332363904781D-19, &
&   -2.975800003053721D-17,   1.391650413454138D-15,  -6.537650014327864D-14, &
&    3.098475769832601D-12,  -1.487325230362991D-10,   7.271411235584798D-09, &
&   -3.656483848138639D-07,   1.930623614911662D-05,  -1.132632526573975D-03, &
&    9.967166235971663D-02,                                                   &
&    1.567183612537361D-25,  -4.092643109335144D-24,   1.430123974398587D-22, &
&   -6.172813104160734D-21,   2.910583816918907D-19,  -1.417200663079844D-17, &
&    7.009610738411839D-16,  -3.516588696246130D-14,   1.797295568471610D-12, &
&   -9.448594510471828D-11,   5.215621882067768D-09,  -3.198914662675785D-07, &
&    2.943001486374702D-05,                                                   &
&    7.697982886715932D-24,  -2.651050719083499D-22,   1.110237735894776D-20, &
&   -5.143358898531069D-19,   2.475256974502717D-17,  -1.211104934894854D-15, &
&    5.996169649101874D-14,  -3.008682761302735D-12,   1.537748308296867D-10, &
&   -8.084148155742334D-09,   4.462449048891590D-07,  -2.736968720508127D-05, &
&    2.518011221806721D-03,                                                   &
&    6.366516073991972D-23,  -2.774094814253461D-21,   1.290123455563254D-19, &
&   -6.183675028283778D-18,   3.003665948558631D-16,  -1.472862177248334D-14, &
&    7.295383277305749D-13,  -3.660872236482744D-11,   1.871106162569310D-09, &
&   -9.836668420613480D-08,   5.429840765002588D-06,  -3.330302327681956D-04, &
&    3.063878141172280D-02,                                                   &
&    1.634705105515697D-22,  -8.234910285905641D-21,   4.024749153439896D-19, &
&   -1.957550655297572D-17,   9.545662522146655D-16,  -4.685028033120258D-14, &
&    2.321021422198431D-12,  -1.164742261629736D-10,   5.953135788920588D-09, &
&   -3.129649075019905D-07,   1.727566317288146D-05,  -1.059574009059312D-03, &
&    9.748080883750157D-02,                                                   &
&    5.196998785464786D-26,  -1.864272775553604D-24,   8.223904646010222D-23, &
&   -3.999370082801725D-21,   2.013054980222441D-19,  -1.028488325736068D-17, &
&    5.314315642133006D-16,  -2.782580630363900D-14,   1.484029065494027D-12, &
&   -8.140950815548454D-11,   4.689187235869617D-09,  -3.001079813733513D-07, &
&    2.881036620571899D-05,                                                   &
&    3.305466441992509D-24,  -1.427708141590028D-22,   6.816472274118008D-21, &
&   -3.395401158882990D-19,   1.719513932259273D-17,  -8.796974374729983D-16, &
&    4.546667781317942D-14,  -2.380740557780349D-12,   1.269723836307472D-10, &
&   -6.965339415190790D-09,   4.012035363258320D-07,  -2.567702626914154D-05, &
&    2.464994521638925D-03,                                                   &
&    3.411964740128344D-23,  -1.646923979098342D-21,   8.174556689602573D-20, &
&   -4.116981573581361D-18,   2.090709821941605D-16,  -1.070252632482624D-14, &
&    5.532192225772949D-13,  -2.896840429896131D-11,   1.544980326935952D-09, &
&   -8.475319881107839D-08,   4.881784212617917D-06,  -3.124341894523504D-04, &
&    2.999368218687130D-02,                                                   &
&    1.005464463993143D-22,  -5.120868011532560D-21,   2.585001920933321D-19, &
&   -1.307941234632085D-17,   6.649744651904935D-16,  -3.404931623277942D-14, &
&    1.760113922946458D-12,  -9.216619322996257D-11,   4.915532001328338D-09, &
&   -2.696520517696959D-07,   1.553195823525773D-05,  -9.940453272691249D-04, &
&    9.542835141859512D-02,                                                   &
&    2.275200664363196D-26,  -1.032894614302616D-24,   5.170410047420280D-23, &
&   -2.689798332902734D-21,   1.420115709474668D-19,  -7.569634185803363D-18, &
&    4.075533814405335D-16,  -2.222982268193457D-14,   1.234987498407470D-12, &
&   -7.057069793919577D-11,   4.234241795346751D-09,  -2.822827860375909D-07, &
&    2.822827860263449D-05,                                                   &
&    1.724429621167035D-24,  -8.515748801126818D-23,   4.382041430303209D-21, &
&   -2.296411570785020D-19,   1.214513083372826D-17,  -6.476028835016384D-16, &
&    3.486957189599069D-14,  -1.901965037919302D-12,   1.056646389503138D-10, &
&   -6.037978843221324D-09,   3.622787279670101D-07,  -2.415191518743236D-05, &
&    2.415191518706565D-03,                                                   &
&    1.977643403712782D-23,  -1.018589386483655D-21,   5.309007396371788D-20, &
&   -2.791486951523261D-18,   1.477506598828671D-16,  -7.879655633695185D-15, &
&    4.242854053619534D-13,  -2.314280808531089D-11,   1.285711323004852D-09, &
&   -7.346921699460822D-08,   4.408153012351446D-06,  -2.938768674611308D-04, &
&    2.938768674601047D-02,                                                   &
&    6.132696776544756D-23,  -3.217426324311912D-21,   1.686062150366621D-19, &
&   -8.877764168409699D-18,   4.700462973151912D-16,  -2.506965715927175D-14, &
&    1.349909755109831D-12,  -7.363148536768237D-11,   4.090638401301740D-09, &
&   -2.337507677931063D-07,   1.402504607761870D-05,  -9.350030718808995D-04, &
&    9.350030718823035D-02,                                                   &
&    1.221117460546357D-26,  -6.312634685981853D-25,   3.388366767625720D-23, &
&   -1.848475376803185D-21,   1.016989865339743D-19,  -5.640071913839173D-18, &
&    3.158359588407800D-16,  -1.791644425325694D-14,   1.035171838613717D-12, &
&   -6.151878053593965D-11,   3.838771890534352D-09,  -2.661548510188105D-07, &
&    2.768010450575236D-05,                                                   &
&    1.002459951888956D-24,  -5.340488886593579D-23,   2.891292186927582D-21, &
&   -1.580627629650839D-19,   8.700328706622215D-18,  -4.825515612535486D-16, &
&    2.702262779054917D-14,  -1.532917770344926D-12,   8.856856621814775D-11, &
&   -5.263503265824460D-09,   3.284426033016580D-07,  -2.277202049367884D-05, &
&    2.368290131335920D-03,                                                   &
&    1.196501493204894D-23,  -6.464694908444024D-22,   3.513750071731078D-20, &
&   -1.922771055930625D-18,   1.058588529727218D-16,  -5.871563773917113D-15, &
&    3.288068500991808D-13,  -1.865230972055259D-11,   1.077688961279577D-09, &
&   -6.404551513953048D-08,   3.996440143348018D-06,  -2.770865166001329D-04, &
&    2.881699772639509D-02,                                                   &
&    3.775865760019795D-23,  -2.052346007537605D-21,   1.117360866281799D-19, &
&   -6.116829726273761D-18,   3.367948145560030D-16,  -1.868098715367645D-14, &
&    1.046136269425980D-12,  -5.934446587969694D-11,   3.428791423299345D-09, &
&   -2.037681763878869D-07,   1.271513420846352D-05,  -8.815826384607617D-04, &
&    9.168459439994483D-02,                                                   &
&    7.276244515365297D-27,  -4.037698808676345D-25,   2.272698635245000D-23, &
&   -1.290649198936450D-21,   7.378027031165718D-20,  -4.249586048680103D-18, &
&    2.471282597587742D-16,  -1.455808841635450D-14,   8.734852135073968D-13, &
&   -5.390651548171649D-11,   3.493142200507155D-09,  -2.515062384260096D-07, &
&    2.716267374997249D-05,                                                   &
&    6.146469431450350D-25,  -3.443429563488540D-23,   1.943081942192585D-21, &
&   -1.104104251203602D-19,   6.312413996833296D-18,  -3.635899643602838D-16, &
&    2.114410585965044D-14,  -1.245579641804974D-12,   7.473477552970020D-11, &
&   -4.612203271813210D-09,   2.988707719248455D-07,  -2.151869557824413D-05, &
&    2.324019122449164D-03,                                                   &
&    7.434949034653901D-24,  -4.183646090260287D-22,   2.363511824802300D-20, &
&   -1.343363456872865D-18,   7.680751552738131D-17,  -4.424098758847119D-15, &
&    2.572782220607050D-13,  -1.515602502097169D-11,   9.093614929308806D-10, &
&   -5.612059494185105D-08,   3.636614551983374D-06,  -2.618362477418350D-04, &
&    2.827831475611480D-02,                                                   &
&    2.359636836684502D-23,  -1.330235435069678D-21,   7.518708776977556D-20, &
&   -4.273938887239936D-18,   2.443706165781024D-16,  -1.407576688927889D-14, &
&    8.185601691317184D-13,  -4.822063699444977D-11,   2.893238231064503D-09, &
&   -1.785541309004357D-07,   1.157030768268816D-05,  -8.330621531548709D-04, &
&    8.997071254073068D-02/
end


!------------------
  module rysgrid5
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t5(13,5,0:30)
      real(8) :: w5(13,5,0:30)
      data t5 / &
&   -2.466821548017252D-17,   1.415073566125617D-16,   8.436821950175909D-15, &
&    2.085908235779166D-13,   3.460669293364369D-12,   3.373419630158751D-11, &
&   -2.242056235159139D-10,  -2.146863428581969D-08,  -6.744485210244180D-07, &
&   -1.565554025859903D-05,  -2.983536687839506D-04,  -4.652685531661274D-03, &
&    9.484939262883686D-01,                                                   &
&   -1.846897128640781D-16,   1.196779500623351D-15,   5.040219017073571D-14, &
&    3.966493614193689D-13,  -8.635210455997200D-12,  -2.424696303030124D-10, &
&   -1.050321360285531D-09,   6.106906863858959D-08,   1.360211224360696D-06, &
&    2.189820087409352D-07,  -6.372879675155994D-04,  -1.793618212797632D-02, &
&    7.483346283872805D-01,                                                   &
&   -2.354888058993531D-16,   3.359318380351703D-15,   4.523206131134161D-14, &
&   -9.630572381018954D-13,  -1.010904014443063D-11,   2.834758960242010D-10, &
&    2.250754834653457D-09,  -9.113205114886806D-08,  -5.229360588695508D-07, &
&    3.486785623995273D-05,   1.285610917424957D-04,  -2.366907022437634D-02, &
&    4.615973614962667D-01,                                                   &
&   -9.749381854917202D-17,   2.172250521063820D-15,  -8.745406457488744D-15, &
&   -4.774853565135484D-13,   1.135305059299221D-11,  -7.259721874623334D-11, &
&   -2.164361531790849D-09,   6.788516097863270D-08,  -6.643284569356918D-07, &
&   -1.225492270885508D-05,   6.471208814040512D-04,  -1.452865427101622D-02, &
&    1.878315676524455D-01,                                                   &
&   -9.237025362788326D-18,   2.281598610952117D-16,  -3.025808271168458D-15, &
&    1.457252290640952D-14,   6.503511825792454D-13,  -3.012868091609930D-11, &
&    8.684349274975176D-10,  -2.068985604112989D-08,   4.354508937865230D-07, &
&   -8.269037528762740D-06,   1.407832710814398D-04,  -2.064032859518606D-03, &
&    2.216356880721764D-02,                                                   &
&   -7.978911045423525D-17,  -8.914645230074219D-16,   2.870081203448383D-15, &
&    3.574011636661209D-13,   8.705681708345939D-12,   1.273257305446297D-10, &
&    8.047682752303112D-10,  -1.928487026630724D-08,  -8.883084421670474D-07, &
&   -2.191939988230012D-05,  -4.102150433470778D-04,  -6.057290399375228D-03, &
&    9.378584090255828D-01,                                                   &
&   -2.271932188693270D-16,  -4.064189840557981D-15,   2.229806375755869D-14, &
&    1.319859271517304D-12,   7.629448324052635D-12,  -2.736213897114786D-10, &
&   -4.969563018172973D-09,   2.545172564757342D-08,   1.832623366001461D-06, &
&    1.322706205320064D-05,  -5.988715420296545D-04,  -2.043461187894281D-02, &
&    7.099384814962178D-01,                                                   &
&   -1.609058865557339D-16,  -2.041203398421006D-15,   5.686724433577179D-14, &
&    2.627879082766498D-13,  -1.674731422057874D-11,   3.820735716459232D-11, &
&    4.627688414546316D-09,  -4.634125691485871D-08,  -1.234323288405310D-06, &
&    2.753547030119334D-05,   3.186359232131098D-04,  -2.275988926527765D-02, &
&    4.150413023662820D-01,                                                   &
&   -5.667170240540270D-17,   1.468236207450346D-16,   1.476400710914844D-14, &
&   -3.412334057691851D-13,   3.291231634254735D-12,   4.091838448353775D-11, &
&   -2.233056647317450D-09,   3.992206596592680D-08,  -1.249136776095773D-07, &
&   -1.522337204948660D-05,   5.625281412177181D-04,  -1.210349509392359D-02, &
&    1.612561011696195D-01,                                                   &
&   -4.513219488022467D-18,   5.334716195695212D-17,  -1.815038348674701D-16, &
&   -1.100664769485633D-14,   5.987210548263699D-13,  -1.955347997968399D-11, &
&    5.219334701432927D-10,  -1.249729227021747D-08,   2.729773551368788D-07, &
&   -5.489741197223399D-06,   1.001540603099400D-04,  -1.587695057177171D-03, &
&    1.853884090582964D-02,                                                   &
&   -1.761445773427256D-16,  -4.103692323292271D-15,  -4.723836558303054D-14, &
&    3.275546565838508D-14,   1.369114021246288D-11,   3.137185236170434D-10, &
&    3.793559633732056D-09,   5.676075736009845D-09,  -9.860386369522446D-07, &
&   -2.957967820663334D-05,  -5.642976778922092D-04,  -7.990930733024422D-03, &
&    9.239128530187424D-01,                                                   &
&    2.608613275226089D-16,  -4.635696446740990D-15,  -9.705086997900122D-14, &
&    6.030033365578730D-13,   2.865466767898789D-11,   3.369077713538615D-11, &
&   -7.055652775442670D-09,  -5.104944129370015D-08,   1.726321031039213D-06, &
&    2.797867432661823D-05,  -4.748467578564460D-04,  -2.261175903860853D-02, &
&    6.668093740626593D-01,                                                   &
&    9.022803299424655D-17,  -2.633178474837666D-15,  -6.713889791754490D-15, &
&    7.834574209406656D-13,  -5.352221514072655D-12,  -1.511720153601088D-10, &
&    3.616727145394161D-09,   5.811882105482314D-09,  -1.426413649667146D-06, &
&    1.654123253828033D-05,   4.516257935019631D-04,  -2.119723622083231D-02, &
&    3.709954161614155D-01,                                                   &
&   -9.338689223928400D-19,  -4.708191979495003D-16,   8.569799056806958D-15, &
&   -8.597289771028801D-14,  -3.526714212137484D-13,   5.819670783568593D-11, &
&   -1.472005229493467D-09,   1.746736662042513D-08,   1.542891540785785D-07, &
&   -1.495588312220899D-05,   4.708798055911415D-04,  -1.003727422155405D-02, &
&    1.391765784624838D-01,                                                   &
&   -8.995733330897186D-19,  -7.220382538502756D-18,   1.576630340362032D-16, &
&   -9.066302178599095D-15,   4.088462292107526D-13,  -1.154989453877563D-11, &
&    3.077871146837168D-10,  -7.630847064136260D-09,   1.744709399635730D-07, &
&   -3.732241915954445D-06,   7.288043167347502D-05,  -1.245128179757928D-03, &
&    1.572414787590615D-02,                                                   &
&    2.784775312311389D-16,  -5.282071878600637D-15,  -1.705131846487083D-13, &
&   -2.078318668889062D-12,  -9.122707304979253D-13,   4.662552689702545D-10, &
&    9.511598960215614D-09,   8.323110914369075D-08,  -5.991871533631291D-07, &
&   -3.643450028306009D-05,  -7.638413012978532D-04,  -1.063329402124192D-02, &
&    9.054218548396991D-01,                                                   &
&    3.892974496821129D-16,   5.557739997992361D-15,  -9.364495362904271D-14, &
&   -1.701239465344814D-12,   1.871037168080893D-11,   4.698627848110822D-10, &
&   -3.344994566313883D-09,  -1.197224003742158D-07,   8.349835729969196D-07, &
&    3.869016494321292D-05,  -2.712447801709522D-04,  -2.412555306274245D-02, &
&    6.199358461902478D-01,                                                   &
&    9.893110229916768D-17,   1.142021993938292D-16,  -3.464715381902355D-14, &
&    2.644644137998973D-13,   4.917471592988769D-12,  -1.416800282692600D-10, &
&    1.371932048533550D-09,   3.557401227506601D-08,  -1.196643882646662D-06, &
&    5.850835946157393D-06,   5.178645126221558D-04,  -1.923679559332517D-02, &
&    3.305173512554963D-01,                                                   &
&    1.547489683895074D-17,  -2.270927712136510D-16,   1.404313403757909D-16, &
&   -8.477552926795516D-15,  -9.456216054572417D-13,   4.599777936964338D-11, &
&   -7.325417486431309D-10,   4.415887622772374D-09,   2.562914177234938D-07, &
&   -1.322678822788128D-05,   3.859297201756957D-04,  -8.327148027909739D-03, &
&    1.208688428733132D-01,                                                   &
&    6.626889361347780D-19,  -6.048177163811461D-18,  -6.123527605368316D-17, &
&   -8.183952641727032D-15,   2.605767875562103D-13,  -6.215224132178172D-12, &
&    1.861722670975061D-10,  -4.741718750946059D-09,   1.138188006027634D-07, &
&   -2.598244337751306D-06,   5.413061478514639D-05,  -9.933664344926054D-04, &
&    1.349812097584474D-02,                                                   &
&    2.090894661626665D-15,   2.215994099068444D-14,  -7.396332867468466D-14, &
&   -5.517884636527067D-12,  -7.164518759797273D-11,  -2.690548156144131D-11, &
&    1.391539471712748D-08,   2.304472022802727D-07,   9.225032973881885D-07, &
&   -3.613140377661138D-05,  -9.875875001355594D-04,  -1.413636026765213D-02, &
&    8.808021689320530D-01,                                                   &
&   -3.179914063139585D-16,   6.241784800680202D-15,   7.127008660347044D-14, &
&   -1.948390800726363D-12,  -1.929413776837363D-11,   4.712335874263287D-10, &
&    3.971688065760085D-09,  -1.159984748209237D-07,  -4.182625982793539D-07, &
&    4.033228076605627D-05,  -2.910423596909443D-05,  -2.472952543033078D-02, &
&    5.709186607825943D-01,                                                   &
&    9.989203984041816D-18,   1.347451069423330D-15,  -1.426051131699683D-14, &
&   -2.690917111945455D-13,   4.238913414373035D-12,  -5.541148883151264D-11, &
&    7.375487377088765D-12,   4.260539526787119D-08,  -7.921335388212182D-07, &
&   -2.149469289988345D-06,   5.273396920315998D-04,  -1.713036878539287D-02, &
&    2.941440879012089D-01,                                                   &
&    1.043820911091300D-17,   9.621751568049295D-17,  -1.039896173592841D-15, &
&   -2.944508558454575D-14,  -1.253110601064601D-12,   2.896881803862121D-11, &
&   -2.021594425021422D-10,  -9.555538863479194D-10,   2.682781358573751D-07, &
&   -1.109301513195190D-05,   3.129266189794362D-04,  -6.933717039883202D-03, &
&    1.056566521218272D-01,                                                   &
&    7.350033527185891D-19,   1.196711790181089D-17,   2.234325040575885D-18, &
&   -9.446510533587950D-15,   9.999943652381034D-14,  -3.297063559685525D-12, &
&    1.225908084228607D-10,  -2.930092397840207D-09,   7.608954423608871D-08, &
&   -1.850633807458030D-06,   4.093439559900297D-05,  -8.047268350210661D-04, &
&    1.170880515902928D-02,                                                   &
&   -1.787786910565283D-15,   5.196193930005544D-14,   9.133426423411498D-13, &
&    1.526692469716013D-12,  -1.381204696947080D-10,  -1.867159410980197D-09, &
&    2.013289358540638D-09,   3.522282524220126D-07,   3.952089279159077D-06, &
&   -1.748010414336272D-05,  -1.160632351492963D-03,  -1.846975768432830D-02, &
&    8.483130474825982D-01,                                                   &
&   -1.380373186799900D-16,  -1.248800046327795D-15,   1.164114137048545D-13, &
&    2.231308132847466D-13,  -3.611327607571108D-11,  -2.559398783620519D-11, &
&    7.409842709671729D-09,  -4.060195112560628D-08,  -1.236287625537899D-06, &
&    3.320187264845014D-05,   1.947985633483381D-04,  -2.438366942860480D-02, &
&    5.216557557248956D-01,                                                   &
&   -9.346572082692736D-18,   1.279705753037608D-15,   1.535120172651445D-14, &
&   -2.549132967381555D-13,  -1.368633703489524D-12,  -3.280680651723780D-11, &
&   -5.021460118276892D-10,   3.932132936142498D-08,  -3.776235719916002D-07, &
&   -6.806183961680128D-06,   4.988108669205737D-04,  -1.506876323559680D-02, &
&    2.619641968951962D-01,                                                   &
&    4.756742081168830D-18,   2.939943941544517D-16,   3.475195329738937D-15, &
&   -1.247873520863284D-14,  -1.766942920043395D-12,   4.436848709962982D-12, &
&    4.178289867134954D-11,  -1.573368112212563D-09,   2.531734583029161D-07, &
&   -9.003549810222828D-06,   2.526993180788413D-04,  -5.806645481110307D-03, &
&    9.295643270247874D-02,                                                   &
&    4.405269061928918D-19,   2.860468277395365D-17,   4.579481858633629D-16, &
&   -5.477851103165750D-15,  -4.802411807263447D-14,  -2.973432748209204D-12, &
&    8.151163607715622D-11,  -1.709754188260123D-09,   5.329543052988072D-08, &
&   -1.341223938691932D-06,   3.144967667321825D-05,  -6.609742591411371D-04, &
&    1.024941511525519D-02,                                                   &
&   -9.750093027730753D-15,  -1.241436338046002D-13,   5.516482519823430D-13, &
&    2.299227900160574D-11,   9.064261448370633D-11,  -2.795489820228976D-09, &
&   -3.492118134196586D-08,   1.693536451550662D-07,   6.937955142655723D-06, &
&    2.727889378104248D-05,  -1.143484767210286D-03,  -2.316798587038799D-02, &
&    8.066655229171458D-01,                                                   &
&   -2.634630617959710D-16,  -3.159442648680114D-15,   7.338489426948694D-14, &
&    2.162091712137989D-12,  -1.338464082624981D-11,  -4.682548275365668D-10, &
&    3.523966267696691D-09,   3.132899321259817D-08,  -1.242931801391822D-06, &
&    2.279694305332509D-05,   3.627895144193919D-04,  -2.324748672675346D-02, &
&    4.739126081771090D-01,                                                   &
&   -1.538330096909117D-16,  -1.929751667672698D-16,   3.414570804731659D-14, &
&    2.891635104368322D-13,  -1.663642942755191D-12,  -7.034932252827596D-11, &
&   -1.216418556339197D-09,   2.957299992401065D-08,  -2.602685319982430D-08, &
&   -8.356569034495597D-06,   4.519105274384158D-04,  -1.316424522894944D-02, &
&    2.337626439261745D-01,                                                   &
&   -4.345973939383158D-17,  -4.510342986603687D-17,   8.511148674060169D-15, &
&    1.185526451408647D-13,  -9.766773599529469D-13,  -2.070806825139061D-11, &
&   -8.623270770902673D-11,  -1.479029331807113D-09,   2.392193074244152D-07, &
&   -7.035094222752620D-06,   2.046381469307057D-04,  -4.895906932174167D-03, &
&    8.228591382911832D-02,                                                   &
&   -4.416356475502148D-18,  -6.651722401434045D-18,   9.316463755137313D-16, &
&    9.585028392568618D-15,  -2.661992108585921D-14,  -3.937456313154255D-12, &
&    3.279606944644647D-11,  -1.009378082301364D-09,   4.018755091768370D-08, &
&   -9.719811526775433D-07,   2.456210248765860D-05,  -5.496873072562502D-04, &
&    9.043338348486270D-03,                                                   &
&    1.891303285543654D-14,  -5.458190889947355D-14,  -2.867613204503976D-12, &
&   -2.292992654195630D-12,   3.883564310215381D-10,   1.652694769914686D-09, &
&   -4.890821713016254D-08,  -3.976333797256470D-07,   5.948777301495492D-06, &
&    8.269207990068230D-05,  -8.097412182889867D-04,  -2.718682561278250D-02, &
&    7.560877123272804D-01,                                                   &
&   -1.514886665057610D-16,  -1.422449468553730D-14,  -1.182430335799985D-13, &
&    2.178984202555441D-12,   3.141257417294033D-11,  -3.267796795251962D-10, &
&   -2.898818505293340D-09,   3.310979080354252D-08,  -8.547766941423831D-07, &
&    1.439685691575803D-05,   4.727649271867662D-04,  -2.155957441879841D-02, &
&    4.290324472899039D-01,                                                   &
&   -6.615625174527378D-17,  -4.692649638132932D-15,  -2.259178480390594D-14, &
&    5.879294885857100D-13,   7.944015054220790D-12,  -2.818930570229384D-11, &
&   -2.091943411943731D-09,   9.156332369864012D-09,   1.767520670369457D-07, &
&   -7.616815658959916D-06,   4.031718215608409D-04,  -1.145561490445987D-02, &
&    2.091753858326688D-01,                                                   &
&   -1.727809528618749D-17,  -1.301621077509738D-15,  -7.247765206171601D-15, &
&    1.824377821341456D-13,   2.209030192102070D-12,  -1.263790374786533D-11, &
&   -3.809060840097790D-10,  -4.389524769816133D-09,   2.129473060856891D-07, &
&   -5.206884055065487D-06,   1.680148006687019D-04,  -4.154265298561502D-03, &
&    7.326014362827115D-02,                                                   &
&   -1.605315657652394D-18,  -1.317146076627726D-16,  -6.951289208819766D-16, &
&    1.705437199485008D-14,   2.624050792385397D-13,  -2.255882132998867D-12, &
&   -1.613698122718682D-11,  -9.323613912056335D-10,   3.097950187864252D-08, &
&   -6.877961575101695D-07,   1.961919832397546D-05,  -4.618928874845185D-04, &
&    8.035048589387375D-03,                                                   &
&   -6.330242217456992D-15,   2.682851362632322D-13,   7.614646777969185D-13, &
&   -3.692214921288654D-11,  -8.122433975298277D-11,   5.009244207031616D-09, &
&    6.938794426247820D-09,  -6.990440406449584D-07,  -1.118967427230279D-07, &
&    1.081166461001308D-04,  -2.126039880534646D-04,  -2.928320771665112D-02, &
&    6.992162657321388D-01,                                                   &
&    1.873174666347138D-15,   1.246335129492070D-14,  -2.456965922660714D-13, &
&   -2.496965642273254D-12,   3.305660122416406D-11,   3.062738662624895D-10, &
&   -3.090984590076021D-09,  -1.202636099531846D-08,  -7.473247185247411D-07, &
&    8.301815204606178D-06,   5.404294658863240D-04,  -1.952112304867918D-02, &
&    3.879066977571232D-01,                                                   &
&    5.662732368216289D-16,   2.919053158383978D-15,  -7.523323712607551D-14, &
&   -6.848775655859720D-13,   8.857161682356340D-12,   1.382084106355900D-10, &
&   -1.345856763908114D-09,  -1.389134638835756D-08,   1.456703882488028D-07, &
&   -6.170194076663617D-06,   3.619410245593638D-04,  -9.928345795527782D-03, &
&    1.878188946295844D-01,                                                   &
&    1.559726505109165D-16,   8.073766117017385D-16,  -2.172856470272470D-14, &
&   -1.889337632574244D-13,   2.641200265726804D-12,   3.547609219982204D-11, &
&   -2.310287772673505D-10,  -8.761286705488341D-09,   1.457161478972212D-07, &
&   -3.742136293272897D-06,   1.414378381788288D-04,  -3.538301718100458D-03, &
&    6.558525850663347D-02,                                                   &
&    1.549234317886335D-17,   7.964935141609867D-17,  -2.159308963507096D-15, &
&   -1.967086013561390D-14,   2.883178646825557D-13,   3.071333679990926D-12, &
&   -1.110615245490806D-11,  -1.173029633392834D-09,   2.040376343696687D-08, &
&   -4.805541779906342D-07,   1.615648874207326D-05,  -3.907566989322112D-04, &
&    7.184701828321952D-03,                                                   &
&   -1.164193704718657D-14,  -1.511763778146981D-13,   2.283075253225860D-12, &
&    1.094622521757209D-11,  -3.619128321538045D-10,   2.278373185694817D-10, &
&    4.901487058540630D-08,  -2.928136480403400D-07,  -5.502931546771679D-06, &
&    8.285304549136431D-05,   3.822184186911240D-04,  -2.889231326790129D-02, &
&    6.406412546238674D-01,                                                   &
&   -1.961802535626447D-15,   1.520143622723483D-14,   2.569999373309594D-13, &
&   -2.523348806232407D-12,  -2.843241313594708D-11,   3.446457708359200D-10, &
&    2.676104992087447D-09,  -1.505764195392572D-08,  -9.428917685880979D-07, &
&    1.561883513711497D-06,   5.708518073950433D-04,  -1.728508913715554D-02, &
&    3.510800903513727D-01,                                                   &
&   -5.096033127582650D-16,   5.343034444160385D-15,   7.080016598801884D-14, &
&   -8.357758429502790D-13,  -9.548089439438152D-12,   1.368479179780262D-10, &
&    9.412662682689573D-10,  -1.631218304060903D-08,  -2.895777912296020D-08, &
&   -5.687206401907767D-06,   3.270864807283830D-04,  -8.551263215615967D-03, &
&    1.693624251911122D-01,                                                   &
&   -1.352396362679859D-16,   1.561913095245906D-15,   1.920745547640839D-14, &
&   -2.469265212140302D-13,  -2.600636207208413D-12,   3.735952967051862D-11, &
&    3.817392079655140D-10,  -7.887963120300492D-09,   5.613196438229753D-08, &
&   -2.940522071091346D-06,   1.217533431046944D-04,  -3.013520280477057D-03, &
&    5.904651074453475D-02,                                                   &
&   -1.321589589944910D-17,   1.573814666795645D-16,   1.912236037174959D-15, &
&   -2.550115833465710D-14,  -2.493267520667844D-13,   3.540284725414106D-12, &
&    4.571502472936900D-11,  -9.724024228299492D-10,   9.086872899612833D-09, &
&   -3.639195093069966D-07,   1.366881448873802D-05,  -3.313388323356665D-04, &
&    6.464258619357701D-03,                                                   &
&    1.080781014415049D-14,  -5.856796338367468D-14,  -1.124783745978510D-12, &
&    1.809590555636116D-11,   8.228364229005547D-12,  -2.749975392850461D-09, &
&    2.403424006981157D-08,   1.875567442425025D-07,  -5.764396595561986D-06, &
&    3.452495130610499D-05,   7.351811967972483D-04,  -2.655954466281519D-02, &
&    5.849539902405563D-01,                                                   &
&    1.198769770383711D-16,  -2.027857390919805D-14,   8.977503307357740D-14, &
&    2.378025264502756D-12,  -2.401923539556514D-11,  -1.997270318574627D-10, &
&    3.585645564298803D-09,   3.049208947522175D-08,  -8.745853010552609D-07, &
&   -6.022535968599599D-06,   5.572036341932594D-04,  -1.501368173124440D-02, &
&    3.187904533626794D-01,                                                   &
&   -6.837141995923480D-17,  -6.058522805232024D-15,   3.920613255767465D-14, &
&    7.267564533427080D-13,  -9.430918056614415D-12,  -5.478719104188018D-11, &
&    1.509156952621723D-09,   1.187502990688967D-09,  -1.102431715118306D-07, &
&   -6.364470494763667D-06,   2.912611146549777D-04,  -7.313164655494595D-03, &
&    1.535218366838650D-01,                                                   &
&   -2.968735821031614D-17,  -1.670024501579047D-15,   1.233854738638436D-14, &
&    1.994972658755357D-13,  -2.785376919229766D-12,  -1.709449589277197D-11, &
&    5.260799046481440D-10,  -1.646073088487337D-09,   7.014259591713318D-09, &
&   -2.730628636463652D-06,   1.049375210654223D-04,  -2.560541075659002D-03, &
&    5.348363351946729D-02,                                                   &
&   -3.332012112118044D-18,  -1.656808242020579D-16,   1.288945998858170D-15, &
&    1.959416422992174D-14,  -2.804132057938994D-13,  -1.845020446459768D-12, &
&    5.807419831958319D-11,  -2.709807917893849D-10,   2.745458522305011D-09, &
&   -3.213731494527389D-07,   1.163840206423093D-05,  -2.808075602676952D-04, &
&    5.853462433913125D-03,                                                   &
&   -1.008829244476782D-15,   5.701703717360597D-14,  -5.410381353110708D-13, &
&   -2.765895828987890D-12,   1.250241553408189D-10,  -1.163201861151817D-09, &
&   -5.453263803146859D-09,   2.753456648173989D-07,  -3.150894610055536D-06, &
&   -1.689022551961483D-06,   8.229943870966184D-04,  -2.337055006847142D-02, &
&    5.349667931204354D-01,                                                   &
&    7.870652189633884D-16,   1.854340341410027D-15,  -1.403299521507450D-13, &
&    9.493283639618296D-13,   1.296809237080576D-11,  -2.492100266694828D-10, &
&   -2.738274119482291D-10,   5.094109283699599D-08,  -4.273680409306199D-07, &
&   -1.136737947231942D-05,   5.032124739862913D-04,  -1.288210490175800D-02, &
&    2.909309055674522D-01,                                                   &
&    2.841758925919428D-16,  -1.491871601504550D-16,  -4.529708515535067D-14, &
&    4.160926387768120D-13,   3.480999071283560D-12,  -9.367021524855786D-11, &
&    2.189881094621577D-10,   1.207478457969373D-08,  -3.051952074636112D-08, &
&   -7.000779030066091D-06,   2.508355650255882D-04,  -6.227669261579689D-03, &
&    1.400079977355524D-01,                                                   &
&    8.338034243022734D-17,  -1.316142286978068D-16,  -1.278296855455083D-14, &
&    1.297257912442944D-13,   9.616024224904811D-13,  -2.967997431320450D-11, &
&    1.257412034261771D-10,   2.435031892259875D-09,   1.511084684805320D-08, &
&   -2.669558912338373D-06,   8.870119926069375D-05,  -2.173374764236268D-03, &
&    4.876054685636918D-02,                                                   &
&    8.447714219453389D-18,  -1.682952315605279D-17,  -1.274440486630032D-15, &
&    1.340858351485362D-14,   9.670704729803341D-14,  -3.134200435352082D-12, &
&    1.587608971471844D-11,   1.902248505861550D-10,   2.778609957349316D-09, &
&   -3.023745945293350D-07,   9.766671505522648D-06,  -2.380341672366732D-04, &
&    5.335868612193246D-03,                                                   &
&   -1.556897456559821D-15,   7.591459333978298D-15,   1.796535981782597D-13, &
&   -4.388040290686514D-12,   3.903665755685823D-11,   1.783403574444718D-10, &
&   -1.066164250179364D-08,   1.598052871904048D-07,  -9.264963575548379D-07, &
&   -1.720314686395957D-05,   7.573825637093967D-04,  -2.017909041215423D-02, &
&    4.914620873481758D-01,                                                   &
&   -2.719958848222675D-16,   4.907380383025847D-15,  -1.483956990777064D-14, &
&   -6.826792621056907D-13,   1.130396618333233D-11,  -1.554011650474333D-11, &
&   -2.080372828512031D-09,   3.343357382385713D-08,   1.246370281269253D-08, &
&   -1.290570677382817D-05,   4.286195608697861D-04,  -1.101541348350411D-02, &
&    2.670833530955918D-01,                                                   &
&   -6.964997822875202D-17,   1.788322000734672D-15,  -9.865075502965551D-15, &
&   -1.999909736378510D-13,   4.259524119269433D-12,  -1.666354067329148D-11, &
&   -5.633624103838575D-10,   8.887865959762427D-09,   8.213331416426188D-08, &
&   -6.771559061577482D-06,   2.090616629955109D-04,  -5.308342614070135D-03, &
&    1.284998964050775D-01,                                                   &
&   -1.714805605537298D-17,   5.298567195852078D-16,  -3.425762687410641D-15, &
&   -5.521376802989222D-14,   1.321763975156064D-12,  -6.867626735638073D-12, &
&   -1.356088268514077D-10,   2.043599533484175D-09,   4.012748135331383D-08, &
&   -2.445545696781418D-06,   7.325371689675923D-05,  -1.849914260222789D-03, &
&    4.474756989616978D-02,                                                   &
&   -1.602709884889531D-18,   5.388069556339726D-17,  -3.681567868171185D-16, &
&   -5.488660427494173D-15,   1.378129165289846D-13,  -7.928929250279382D-13, &
&   -1.226348302967635D-11,   1.778059825285615D-10,   4.901356787263138D-09, &
&   -2.715257192879868D-07,   8.036253112123576D-06,  -2.024900753501853D-04, &
&    4.896499157148406D-03,                                                   &
&    5.582478457108588D-17,  -6.355503326509357D-15,   1.171298681276713D-13, &
&   -9.493094657302717D-13,  -6.686081588199680D-12,   3.524304145735082D-10, &
&   -6.102072985825337D-09,   5.702551603677033D-08,   1.103819266598226D-07, &
&   -1.977961397298932D-05,   6.423251630363532D-04,  -1.737479768616750D-02, &
&    4.539854498538579D-01,                                                   &
&   -9.764048019661262D-17,  -3.176940710495232D-16,   2.620052818287106D-14, &
&   -3.701256116572947D-13,   6.576655763907930D-13,   7.168450933195686D-11, &
&   -1.484357759935511D-09,   1.084892323101106D-08,   2.275064136006342D-07, &
&   -1.179368153511356D-05,   3.536664620445692D-04,  -9.453126615582112D-03, &
&    2.466648954164943D-01,                                                   &
&   -4.266349189721260D-17,   3.609973022207202D-17,   8.502634610401366D-15, &
&   -1.455104968027206D-13,   6.108085696751414D-13,   2.065801498540768D-11, &
&   -4.652988903430932D-10,   2.198394987936950D-09,   1.364420810102693D-07, &
&   -5.851973988534909D-06,   1.709747757827308D-04,  -4.550127137539277D-03, &
&    1.186668466943424D-01,                                                   &
&   -1.353767025453535D-17,   2.928580072810006D-17,   2.432094479912097D-15, &
&   -4.552674754885222D-14,   2.416334760357336D-13,   5.310652011568407D-12, &
&   -1.257016503100159D-10,   3.062784747013175D-10,   5.173563799656376D-08, &
&   -2.066285764973920D-06,   5.967191743150388D-05,  -1.584826272974608D-03, &
&    4.132189006220718D-02,                                                   &
&   -1.413868051698676D-18,   3.741083302818937D-18,   2.445392888805945D-16, &
&   -4.752389732357656D-15,   2.744284317523729D-14,   5.017799058228604D-13, &
&   -1.217341543408193D-11,   1.314757649360137D-11,   5.850910395795984D-09, &
&   -2.273949327659287D-07,   6.535698602783086D-06,  -1.734348862885776D-04, &
&    4.521575070485274D-03,                                                   &
&    1.560019739291629D-16,  -2.441033284169643D-15,   1.682084878529793D-14, &
&    2.336019796917557D-13,  -1.010339143561327D-11,   1.904989485729088D-10, &
&   -2.249085646570606D-09,   9.261988788961465D-09,   4.031943145627556D-07, &
&   -1.741005340688006D-05,   5.296158422668318D-04,  -1.503578035175286D-02, &
&    4.216501616371792D-01,                                                   &
&    2.463597310521508D-17,  -7.297829121034342D-16,   9.073627200647536D-15, &
&   -6.809890128035327D-15,  -2.189511351545492D-12,   5.066759611257600D-11, &
&   -5.768294705301726D-10,  -1.199382475694594D-09,   2.665785164316911D-07, &
&   -9.737458927511150D-06,   2.889241267734519D-04,  -8.172089759693414D-03, &
&    2.290828600307752D-01,                                                   &
&    5.948468962113481D-18,  -2.585014622996807D-16,   3.787309884529353D-15, &
&   -1.324784250740494D-14,  -6.636308184101750D-13,   1.701882164638200D-11, &
&   -1.783678598804297D-10,  -1.603600885326207D-09,   1.365008755897796D-07, &
&   -4.734940719391171D-06,   1.392161442463700D-04,  -3.931989453496131D-03, &
&    1.102059021080009D-01,                                                   &
&    1.375269272909293D-18,  -7.668367161096319D-17,   1.209769116851485D-15, &
&   -5.618294060178950D-15,  -1.779851492523264D-13,   4.846013389967842D-12, &
&   -4.693024113953865D-11,  -7.202623801020500D-10,   4.886279339564169D-08, &
&   -1.657062342496511D-06,   4.851401201599478D-05,  -1.369275590268630D-03, &
&    3.837522514688757D-02,                                                   &
&    1.235597981189551D-19,  -7.819929358398300D-18,   1.272095538326225D-16, &
&   -6.499000641768948D-16,  -1.724165037982312D-14,   4.831535514630413D-13, &
&   -4.460112127307423D-12,  -8.611006607038178D-11,   5.407340835788258D-09, &
&   -1.817010971507013D-07,   5.310248351188025D-06,  -1.498346442166064D-04, &
&    4.199122258119863D-03,                                                   &
&    4.048581751006288D-17,  -2.118957453629577D-16,  -6.852433955128927D-15, &
&    2.528566723255302D-13,  -5.047017851708098D-12,   6.921712663885961D-11, &
&   -5.279409662701719D-10,  -5.702464347727012D-09,   4.039763293535709D-07, &
&   -1.408387113704810D-05,   4.351444855191423D-04,  -1.311295067263503D-02, &
&    3.935644093565273D-01,                                                   &
&    1.557946516689571D-17,  -1.728016260388403D-16,  -3.405679769448745D-16, &
&    5.940075688537937D-14,  -1.437137584982812D-12,   2.016789436663892D-11, &
&   -9.606156294434584D-11,  -4.805694217423814D-09,   2.317765004132422D-07, &
&   -7.720573762926243D-06,   2.366930472594056D-04,  -7.124898468871054D-03, &
&    2.138206732353500D-01,                                                   &
&    5.961279956859436D-18,  -7.720040683585742D-17,   1.297392681798149D-16, &
&    1.891067962236668D-14,  -5.033103696941434D-13,   6.945769932053138D-12, &
&   -1.401590064648521D-11,  -2.614857099691351D-09,   1.137722153882819D-07, &
&   -3.727298518997565D-06,   1.139216477506134D-04,  -3.427731740837199D-03, &
&    1.028630315405885D-01,                                                   &
&    1.829003517775943D-18,  -2.530063579378819D-17,   7.763599526243623D-17, &
&    5.248525465569962D-15,  -1.473426588453891D-13,   1.992434706365818D-12, &
&    2.401150327203880D-13,  -9.597622773836089D-10,   3.999247276063642D-08, &
&   -1.300099190618438D-06,   3.967838431995820D-05,  -1.193605331342029D-03, &
&    3.581822984137392D-02,                                                   &
&    1.890672488497484D-19,  -2.686381691230009D-18,   9.698941098506386D-18, &
&    5.177716611121757D-16,  -1.489979859224375D-14,   1.989874435235573D-13, &
&    2.579737105054470D-13,  -1.072700729960896D-10,   4.393384388584312D-09, &
&   -1.423625754929877D-07,   4.342150758600194D-06,  -1.306085763510630D-04, &
&    3.919323888010134D-03,                                                   &
&    1.065538481387833D-18,   1.658159096058739D-16,  -5.562151162840772D-15, &
&    1.160281020187835D-13,  -1.775799686599675D-12,   1.797728849601348D-11, &
&    2.155453192027934D-11,  -8.032854338180431D-09,   3.299263352941313D-07, &
&   -1.113366304004642D-05,   3.597923400433453D-04,  -1.152898311631114D-02, &
&    3.689726700283505D-01,                                                   &
&    2.511994179133576D-18,   1.888976119885053D-17,  -1.421595820358731D-15, &
&    3.499991864566222D-14,  -5.585980446063155D-13,   4.819716021862709D-12, &
&    6.234970570893508D-11,  -4.794858711405269D-09,   1.822227124412792D-07, &
&   -6.064932268110095D-06,   1.955359737759880D-04,  -6.263751519210513D-03, &
&    2.004594346337490D-01,                                                   &
&    1.229756267711270D-18,   2.001493048508908D-18,  -4.737096525055894D-16, &
&    1.263735965429103D-14,  -2.025633804257996D-13,   1.462810438768545D-12, &
&    3.916944927755273D-11,  -2.387649756065412D-09,   8.823922816303247D-08, &
&   -2.920868898409072D-06,   9.407968989127121D-05,  -3.013341260970454D-03, &
&    9.643517281465770D-02,                                                   &
&    4.167871665034647D-19,  -1.517950745107578D-19,  -1.352532742273044D-16, &
&    3.768271918925045D-15,  -6.019271688725989D-14,   3.719835017731547D-13, &
&    1.514245312733592D-11,  -8.448972291708908D-10,   3.082346741344972D-08, &
&   -1.017631221458540D-06,   3.276198453113534D-05,  -1.049289206121085D-03, &
&    3.357994132501753D-02,                                                   &
&    4.482251581225302D-20,  -4.962958738646535D-20,  -1.353142224475844D-17, &
&    3.844764083073749D-16,  -6.122417464721000D-15,   3.446142594411647D-14, &
&    1.725880057634823D-12,  -9.307435232059392D-11,   3.377317689957838D-09, &
&   -1.113774557904354D-07,   3.585006292138222D-06,  -1.148161928912209D-04, &
&    3.674403337682989D-03,                                                   &
&   -3.465288881083231D-18,   1.085507770787874D-16,  -2.351159379252462D-15, &
&    3.926620869835772D-14,  -4.754916092521461D-13,   1.797391916127441D-12, &
&    1.360697706991493D-10,  -6.865700735422818D-09,   2.543359091167782D-07, &
&   -8.804687380994467D-06,   3.002805123791207D-04,  -1.021349208362665D-02, &
&    3.472698289016385D-01,                                                   &
&   -5.910416867405925D-19,   2.989762718461238D-17,  -7.456432084664719D-16, &
&    1.303967523918653D-14,  -1.472874871669826D-13,  -2.991438117200576D-13, &
&    8.639564914276985D-11,  -3.832202886956640D-09,   1.388620722405485D-07, &
&   -4.787103566830590D-06,   1.631534839244513D-04,  -5.548925641220933D-03, &
&    1.886683226410235D-01,                                                   &
&   -1.389442934352473D-19,   1.034681364639675D-17,  -2.758797284007200D-16, &
&    4.881191483352242D-15,  -5.117558541907740D-14,  -3.797844982949041D-13, &
&    4.394869240231160D-11,  -1.863670426340682D-09,   6.694041790331735D-08, &
&   -2.303676902737317D-06,   7.849127958614073D-05,  -2.669432289675695D-03, &
&    9.076278017217534D-02,                                                   &
&   -2.973710883940445D-20,   3.019627454471733D-18,  -8.340740242513230D-17, &
&    1.479592731800817D-15,  -1.463039383098752D-14,  -1.712082297903512D-13, &
&    1.570378495890039D-11,  -6.523707625607733D-10,   2.333319675715562D-08, &
&   -8.022979174927962D-07,   2.733216076563719D-05,  -9.295310631155211D-04, &
&    3.160473694300921D-02,                                                   &
&   -2.500188272104632D-21,   3.052486965923167D-19,  -8.565174804461529D-18, &
&    1.519749753099457D-16,  -1.455359150193403D-15,  -2.052799176721613D-14, &
&    1.736915123595527D-12,  -7.154356322277821D-11,   2.554290219812591D-09, &
&   -8.779555903532857D-08,   2.990779248830810D-06,  -1.017117276189116D-04, &
&    3.458271129609656D-03,                                                   &
&   -1.895495349239392D-18,   4.271554240767418D-17,  -7.639712975428003D-16, &
&    1.054240994899999D-14,  -7.437571625807260D-14,  -1.923848543002105D-12, &
&    1.278724312073104D-10,  -5.231833696321902D-09,   1.939446846802460D-07, &
&   -7.022523332646961D-06,   2.530403630436593D-04,  -9.110410266355157D-03, &
&    3.279773877916867D-01,                                                   &
&   -5.597427128477380D-19,   1.412729644820986D-17,  -2.645657220377897D-16, &
&    3.534389226745993D-15,  -1.252669845629911D-14,  -1.352426770451232D-12, &
&    7.237285376160747D-11,  -2.865473062941200D-09,   1.055187980140267D-07, &
&   -3.816043419117787D-06,   1.374772983155499D-04,  -4.949603608571080D-03, &
&    1.781868930877053D-01,                                                   &
&   -2.003630179622138D-19,   5.330509636924287D-18,  -1.012849555291129D-16, &
&    1.302454403053047D-15,  -7.693733373629874D-16,  -7.103958926702970D-13, &
&    3.539611158813337D-11,  -1.383209760935087D-09,   5.079336860829109D-08, &
&   -1.835950548677050D-06,   6.613691492496588D-05,  -2.381110068876911D-03, &
&    8.572046545841962D-02,                                                   &
&   -5.957509720638658D-20,   1.628908906118193D-18,  -3.111091473387259D-17, &
&    3.884392092702622D-16,   6.074762060760607D-16,  -2.574684675949914D-13, &
&    1.242449325768021D-11,  -4.824657145975819D-10,   1.769235934983017D-08, &
&   -6.393298660307760D-07,   2.302981390039680D-05,  -8.291325959686540D-04, &
&    2.984893851184488D-02,                                                   &
&   -6.074192540128665D-21,   1.680929268049761D-19,  -3.215749432817213D-18, &
&    3.952116251459710D-17,   1.069260117615709D-16,  -2.864283513084291D-14, &
&    1.364159397216264D-12,  -5.283095983579192D-11,   1.936201764585660D-09, &
&   -6.995847908078171D-08,   2.519986441667207D-06,  -9.072582041949935D-05, &
&    3.266147114376434D-03,                                                   &
&   -6.962357123817750D-19,   1.336721629352129D-17,  -2.030574991272461D-16, &
&    1.931166796283780D-15,   2.137829148790130D-14,  -2.146210939316230D-12, &
&    9.765574319260369D-11,  -3.876110056142865D-09,   1.487105331748981D-07, &
&   -5.660943707738432D-06,   2.151706529187826D-04,  -8.176707776682052D-03, &
&    3.107154921440046D-01,                                                   &
&   -2.392545545865275D-19,   4.785499542181042D-18,  -7.169432618073710D-17, &
&    5.118586542659587D-16,   1.819084995939539D-14,  -1.236200549282495D-12, &
&    5.370020717455158D-11,  -2.110858470058719D-09,   8.082495327176328D-08, &
&   -3.075696634502954D-06,   1.169007029142498D-04,  -4.442326288839118D-03, &
&    1.688086677792131D-01,                                                   &
&   -9.185938402042710D-20,   1.863275005696109D-18,  -2.732816484015612D-17, &
&    1.430366133273728D-16,   1.005136259682541D-14,  -6.089213228497735D-13, &
&    2.596702818732164D-11,  -1.016527050155554D-09,   3.888935617152419D-08, &
&   -1.479662163223289D-06,   5.623761697248156D-05,  -2.137072605200856D-03, &
&    8.120887598195839D-02,                                                   &
&   -2.833039693895640D-20,   5.778483144910862D-19,  -8.333389812783146D-18, &
&    3.248597597385240D-17,   3.721191658482918D-15,  -2.144808744271401D-13, &
&    9.065230081287754D-12,  -3.541523825036151D-10,   1.354297059112964D-08, &
&   -5.152431219606165D-07,   1.958266549307888D-05,  -7.441554689859339D-04, &
&    2.827794633796488D-02,                                                   &
&   -2.935625932386924D-21,   5.999662684920198D-20,  -8.574369480568443D-19, &
&    2.751314012396660D-18,   4.175076342656395D-16,  -2.358390067027404D-14, &
&    9.930341966412016D-13,  -3.876101825066096D-11,   1.481963980513207D-09, &
&   -5.637951672304378D-08,   2.142786424027595D-06,  -8.142739514967472D-05, &
&    3.094245123793530D-03,                                                   &
&   -2.095609610170962D-19,   3.503207910340782D-18,  -3.992695605961668D-17, &
&   -1.466923766774681D-16,   3.267125891309706D-14,  -1.665618347863630D-12, &
&    7.077973924873104D-11,  -2.872358408693095D-09,   1.152373222926846D-07, &
&   -4.611834739849095D-06,   1.844859949899020D-04,  -7.379490027407207D-03, &
&    2.951797329671935D-01,                                                   &
&   -7.721811517290208D-20,   1.283953158207105D-18,  -1.244189827417692D-17, &
&   -2.039783612458058D-16,   1.922676261183870D-14,  -9.202769998603830D-13, &
&    3.859193901690604D-11,  -1.561574239640613D-09,   6.261389279108231D-08, &
&   -2.505597161027687D-06,   1.002295448811737D-04,  -4.009204530859209D-03, &
&    1.603682413753311D-01,                                                   &
&   -3.048982813898373D-20,   5.005550039861849D-19,  -4.177513502646828D-18, &
&   -1.230759087427457D-16,   9.552678364286124D-15,  -4.459354086761136D-13, &
&    1.859484727639900D-11,  -7.514545513929541D-10,   3.012314420318819D-08, &
&   -1.205376237112766D-06,   4.821750767175616D-05,  -1.928710222662430D-03, &
&    7.714843522954368D-02,                                                   &
&   -9.528774176662791D-21,   1.547963305806911D-19,  -1.148927501339259D-18, &
&   -4.712851430341507D-17,   3.378845499158200D-15,  -1.558422907567279D-13, &
&    6.480136810599043D-12,  -2.617061818447824D-10,   1.048951370077396D-08, &
&   -4.197283885988795D-07,   1.678994412548595D-05,  -6.716010333235676D-04, &
&    2.686405002532583D-02,                                                   &
&   -9.928418360219555D-22,   1.603715137133344D-20,  -1.114879283632312D-19, &
&   -5.356969785790980D-18,   3.721923605847234D-16,  -1.707923546108546D-14, &
&    7.093189613873217D-13,  -2.863847938567799D-11,   1.147801722343485D-09, &
&   -4.592781510597425D-08,   1.837198810061376D-06,  -7.348830116126327D-05, &
&    2.939532974770584D-03,                                                   &
&   -5.383717846701407D-20,   7.148703993479757D-19,  -6.602826810220331D-19, &
&   -4.539041611428457D-16,   2.612788597067722D-14,  -1.188319403172235D-12, &
&    5.092850517115519D-11,  -2.148809905938775D-09,   9.032973684017410D-08, &
&   -3.794381214830219D-06,   1.593668189512989D-04,  -6.693417382224690D-03, &
&    2.811235584210659D-01,                                                   &
&   -2.031743823771905D-20,   2.430508002743971D-19,   1.741725763626091D-18, &
&   -2.740599892771186D-16,   1.451360010888669D-14,  -6.488471649024160D-13, &
&    2.769756005612593D-11,  -1.167641273358717D-09,   4.907657875080061D-08, &
&   -2.061456420372267D-06,   8.658244644436362D-05,  -3.636467782101322D-03, &
&    1.527316599246540D-01,                                                   &
&   -8.051988105249735D-21,   8.806991829664254D-20,   1.265595248400794D-18, &
&   -1.375522275490970D-16,   7.049537811186428D-15,  -3.128396859651384D-13, &
&    1.333072593671470D-11,  -5.617651477078528D-10,   2.360959182038158D-08, &
&   -9.917074032910920D-07,   4.165226895588480D-05,  -1.749397502656845D-03, &
&    7.347470086414014D-02,                                                   &
&   -2.514580754044616D-21,   2.575355946799667D-20,   5.144012320258341D-19, &
&   -4.889128392063744D-17,   2.466584352761496D-15,  -1.090582789779352D-13, &
&    4.643038414669358D-12,  -1.956221383124683D-10,   8.221208522623936D-09, &
&   -3.453251866418705D-07,   1.450384196321622D-05,  -6.091620918250209D-04, &
&    2.558480976131414D-02,                                                   &
&   -2.617364272461858D-22,   2.588572097155444D-21,   5.974898495896412D-20, &
&   -5.396718911548243D-18,   2.704615203380869D-16,  -1.193931585776013D-14, &
&    5.081062578283337D-13,  -2.140588056781336D-11,   8.995881998564989D-10, &
&   -3.778637681046380D-08,   1.587047483103026D-06,  -6.665607221941320D-05, &
&    2.799555236866397D-03,                                                   &
&   -1.112705808236378D-20,   4.847935594314355D-20,   5.790867042997923D-18, &
&   -3.792491591880497D-16,   1.844683194524887D-14,  -8.336235601320614D-13, &
&    3.691894947730844D-11,  -1.626685463244268D-09,   7.159206689870244D-08, &
&   -3.150168218938653D-06,   1.386080095833073D-04,  -6.098754762592570D-03, &
&    2.683452155103519D-01,                                                   &
&   -3.990728459942313D-21,  -6.118133994951152D-21,   3.603072201710378D-18, &
&   -2.118839320926042D-16,   1.008842785809028D-14,  -4.535643473293470D-13, &
&    2.006346924100356D-11,  -8.838047144190558D-10,   3.889552398365816D-08, &
&   -1.711456616168573D-06,   7.530437067052568D-05,  -3.313393392660503D-03, &
&    1.457893120487739D-01,                                                   &
&   -1.505538210376876D-21,  -9.638013119586801D-21,   1.829499354465937D-18, &
&   -1.031816807277717D-16,   4.867686605093640D-15,  -2.183429124678249D-13, &
&    9.653229997086118D-12,  -4.251819928589599D-10,   1.871154946707133D-08, &
&   -8.233316330952898D-07,   3.622671468944830D-05,  -1.593975923690072D-03, &
&    7.013494186726674D-02,                                                   &
&   -4.532092178720362D-22,  -4.516523744581023D-21,   6.538849769825486D-19, &
&   -3.614982181545681D-17,   1.697556314153571D-15,  -7.605594018004909D-14, &
&    3.361606921473893D-12,  -1.480554228909951D-10,   6.515606284826360D-09, &
&   -2.866944244752874D-07,   1.261459532021935D-05,  -5.550423522889307D-04, &
&    2.442186390725375D-02,                                                   &
&   -4.626305571693244D-23,  -5.488667074967299D-22,   7.234621739649445D-20, &
&   -3.966090657267065D-18,   1.858733530495613D-16,  -8.323489002378102D-15, &
&    3.678467240850692D-13,  -1.620068605050315D-11,   7.129548009810171D-10, &
&   -3.137083879570690D-08,   1.380321251416626D-06,  -6.073415198434115D-05, &
&    2.672302730825627D-03,                                                   &
&   -1.060757776593342D-21,  -6.778103799873702D-20,   5.122794704167310D-18, &
&   -2.661367587724651D-16,   1.266093091412700D-14,  -5.874947385412292D-13, &
&    2.707903674556653D-11,  -1.246135674165804D-09,   5.732614458562808D-08, &
&   -2.637027791816987D-06,   1.213034067675511D-04,  -5.579957198562256D-03, &
&    2.566780323575272D-01,                                                   &
&   -1.249945677549605D-22,  -4.378719232684931D-20,   2.879099022156730D-18, &
&   -1.457932544228081D-16,   6.892023902691457D-15,  -3.193128048879027D-13, &
&    1.471290918949661D-11,  -6.770215006509506D-10,   3.114477942338120D-08, &
&   -1.432671459776617D-06,   6.590294675253415D-05,  -3.031535778132176D-03, &
&    1.394506463683221D-01,                                                   &
&    3.415758693004443D-23,  -2.254597962911268D-20,   1.405797842734714D-18, &
&   -7.040089955436679D-17,   3.318541069658950D-15,  -1.536418039897042D-13, &
&    7.078204877866530D-12,  -3.256969884015980D-10,   1.498284711886746D-08, &
&   -6.892160765721989D-07,   3.170396583556449D-05,  -1.458382529147366D-03, &
&    6.708559659560130D-02,                                                   &
&    2.833389811758838D-23,  -8.111331437699712D-21,   4.931949953335202D-19, &
&   -2.456161618064541D-17,   1.156094907999958D-15,  -5.350538576630643D-14, &
&    2.464766286890327D-12,  -1.134121105337750D-10,   5.217216862812800D-09, &
&   -2.399936678443313D-07,   1.103971744926181D-05,  -5.078270361207107D-04, &
&    2.336004374631239D-02,                                                   &
&    3.876864951377275D-24,  -8.999216787925605D-22,   5.414184191309287D-20, &
&   -2.689847522217133D-18,   1.265286175783644D-16,  -5.854954980140246D-15, &
&    2.697032795956081D-13,  -1.240985953485120D-11,   5.708812979857914D-10, &
&   -2.626072066108021D-08,   1.207994084435502D-06,  -5.556773146626820D-05, &
&    2.556115656529517D-03,                                                   &
&    7.427159512663548D-22,  -6.468400179652694D-20,   3.585186762655470D-18, &
&   -1.792365485799758D-16,   8.699140509533151D-15,  -4.186987954450771D-13, &
&    2.010946090210283D-11,  -9.653619957517958D-10,   4.633820458659770D-08, &
&   -2.224239079908519D-06,   1.067635023242015D-04,  -5.124648210866579D-03, &
&    2.459831143680792D-01,                                                   &
&    4.989751935768720D-22,  -3.658636100909942D-20,   1.967339513648168D-18, &
&   -9.761881814486324D-17,   4.728818571963339D-15,  -2.275008148133939D-13, &
&    1.092549077846080D-11,  -5.244732371510134D-10,   2.517509945294104D-08, &
&   -1.208407225025628D-06,   5.800355921060567D-05,  -2.784170888855664D-03, &
&    1.336402027816192D-01,                                                   &
&    2.605726639053885D-22,  -1.791586738708885D-20,   9.507539653389977D-19, &
&   -4.701559611720393D-17,   2.275497817514442D-15,  -1.094498570185182D-13, &
&    5.255982144490044D-12,  -2.523089855741057D-10,   1.211100068249982D-08, &
&   -5.813291167888020D-07,   2.790380310777251D-05,  -1.339382569948507D-03, &
&    6.429036340944038D-02,                                                   &
&    9.436407996484616D-23,  -6.294666804242539D-21,   3.318397833459209D-19, &
&   -1.638116779816638D-17,   7.924660525869554D-16,  -3.811288761950847D-14, &
&    1.830207958747793D-12,  -8.785721167553796D-11,   4.217202311447371D-09, &
&   -2.024260708574078D-07,   9.716453230348008D-06,  -4.663897619726280D-04, &
&    2.238670859198776D-02,                                                   &
&    1.049814290926956D-23,  -6.914576383967296D-22,   3.634788379576052D-20, &
&   -1.792937425084337D-18,   8.671892067313011D-17,  -4.170461582130873D-15, &
&    2.002664769826516D-13,  -9.613563786622306D-12,   4.614570688941653D-10, &
&   -2.214997783583080D-08,   1.063199132058399D-06,  -5.103355908004147D-05, &
&    2.449610837697340D-03,                                                   &
&    7.684584860145928D-22,  -4.531399313748344D-20,   2.374868880332473D-18, &
&   -1.203579801211933D-16,   6.039097101657023D-15,  -3.022024944114439D-13, &
&    1.511267047619980D-11,  -7.556562130095355D-10,   3.778298252601783D-08, &
&   -1.889150202920599D-06,   9.445751550266356D-05,  -4.722875794989527D-03, &
&    2.361437897982439D-01,                                                   &
&    4.370597837197559D-22,  -2.490975360230406D-20,   1.294121840986482D-18, &
&   -6.543656311099085D-17,   3.281496533095251D-15,  -1.641885855362623D-13, &
&    8.210606361473502D-12,  -4.105408712074414D-10,   2.052712393706850D-08, &
&   -1.026356702846260D-06,   5.131783767147245D-05,  -2.565891892989093D-03, &
&    1.282945946726716D-01,                                                   &
&    2.145667426947498D-22,  -1.204829185227919D-20,   6.234393900088221D-19, &
&   -3.149037889432872D-17,   1.578749732578201D-15,  -7.898743890350963D-14, &
&    3.949890451242864D-12,  -1.974991847317118D-10,   9.874994840495739D-09, &
&   -4.937499667161789D-07,   2.468749946149453D-05,  -1.234374977274394D-03, &
&    6.171874887409619D-02,                                                   &
&    7.548580701616504D-23,  -4.207053864315851D-21,   2.172478738737054D-19, &
&   -1.096730456762361D-17,   5.497620554651160D-16,  -2.750462501072760D-14, &
&    1.375403039904812D-12,  -6.877169903076219D-11,   3.438596782736734D-09, &
&   -1.719299139007444D-07,   8.596496070060517D-06,  -4.298248049037647D-04, &
&    2.149124024865291D-02,                                                   &
&    8.296716755069378D-24,  -4.609072996472863D-22,   2.377944222826448D-20, &
&   -1.200165061169967D-18,   6.015741535633629D-17,  -3.009636545579116D-15, &
&    1.505002005685594D-13,  -7.525175601102326D-12,   3.762600471019148D-10, &
&   -1.881301036656362D-08,   9.406505585366504D-07,  -4.703252807709155D-05, &
&    2.351626404226418D-03,                                                   &
&    5.388218687861131D-22,  -2.958934045519606D-20,   1.561821705602970D-18, &
&   -8.156796424770160D-17,   4.246092134231778D-15,  -2.208491713905488D-13, &
&    1.148468751314001D-11,  -5.972084159849177D-10,   3.105487253100139D-08, &
&   -1.614853587686956D-06,   8.397238762314780D-05,  -4.366564160305716D-03, &
&    2.270613363453895D-01,                                                   &
&    2.966385846657132D-22,  -1.613284284082274D-20,   8.492750142144296D-19, &
&   -4.432413272848197D-17,   2.306957611667738D-15,  -1.199861078724592D-13, &
&    6.239525279253357D-12,  -3.244575034660827D-10,   1.687180663348423D-08, &
&   -8.773340472594579D-07,   4.562137096313121D-05,  -2.372311291945291D-03, &
&    1.233601871857021D-01,                                                   &
&    1.435816860090646D-22,  -7.774047485922506D-21,   4.087339932916516D-19, &
&   -2.132513321013637D-17,   1.109832117715752D-15,  -5.772199928907233D-14, &
&    3.001653567034577D-12,  -1.560869566747419D-10,   8.116529064449883D-09, &
&   -4.220595569570498D-07,   2.194709718760903D-05,  -1.141249054589151D-03, &
&    5.934495084067444D-02,                                                   &
&    5.015547084753671D-23,  -2.709384078450729D-21,   1.423578362474032D-19, &
&   -7.426063025947418D-18,   3.864616208341454D-16,  -2.009956246427002D-14, &
&    1.045213650764739D-12,  -5.435143284260063D-11,   2.826276944568387D-09, &
&   -1.469664163227865D-07,   7.642253724166343D-06,  -3.973971939351404D-04, &
&    2.066465408530912D-02,                                                   &
&    5.495761372030304D-24,  -2.965816354687236D-22,   1.557868232878378D-20, &
&   -8.125974256803952D-19,   4.228782138861911D-17,  -2.199347430859207D-15, &
&    1.143699639898504D-13,  -5.947272732177759D-12,   3.092584432820835D-10, &
&   -1.608144068146825D-08,   8.362349235252429D-07,  -4.348421605321043D-05, &
&    2.261179234840172D-03,                                                   &
&    3.471758409985581D-22,  -1.909287353357804D-20,   1.035283430830492D-18, &
&   -5.598046721075242D-17,   3.023901197094534D-15,  -1.633014859582171D-13, &
&    8.818388440715409D-12,  -4.761939157316894D-10,   2.571447840236246D-08, &
&   -1.388581876325553D-06,   7.498342152917786D-05,  -4.049104763330339D-03, &
&    2.186516572216584D-01,                                                   &
&    1.893773321468893D-22,  -1.038398629133049D-20,   5.626024462558140D-19, &
&   -3.041534181867592D-17,   1.642873919595172D-15,  -8.872026011971036D-14, &
&    4.790944975946853D-12,  -2.587114731578844D-10,   1.397042285222210D-08, &
&   -7.544028543284710D-07,   4.073775423307475D-05,  -2.199838728948432D-03, &
&    1.187912913640921D-01,                                                   &
&    9.127790364238494D-23,  -4.997974963329600D-21,   2.706848230418366D-19, &
&   -1.463232527342498D-17,   7.903425336481768D-16,  -4.268074357052001D-14, &
&    2.304782784664017D-12,  -1.244584683311436D-10,   6.720758763588200D-09, &
&   -3.629209823165411D-07,   1.959773308960426D-05,  -1.058277587001299D-03, &
&    5.714698969846435D-02,                                                   &
&    3.181583590515579D-23,  -1.740823463907764D-21,   9.426197773451171D-20, &
&   -5.095232641651427D-18,   2.752079524058770D-16,  -1.486197630186261D-14, &
&    8.025542535986495D-13,  -4.333799566878460D-11,   2.340252257826210D-09, &
&   -1.263736249564157D-07,   6.824175762528976D-06,  -3.685054912310061D-04, &
&    1.989929652660638D-02,                                                   &
&    3.482898805087398D-24,  -1.905079025936129D-22,   1.031468402047699D-20, &
&   -5.575369657999306D-19,   3.011399596791409D-17,  -1.626235780369367D-15, &
&    8.781753951449606D-14,  -4.742154208431914D-12,   2.560763800103037D-10, &
&   -1.382812484620547D-08,   7.467187432933185D-07,  -4.032281214368813D-05, &
&    2.177431855773352D-03,                                                   &
&    2.201096537031395D-22,  -1.239948286150484D-20,   6.947931639516566D-19, &
&   -3.892402370149932D-17,   2.179941738531220D-15,  -1.220789263203210D-13, &
&    6.836441507947520D-12,  -3.828409103638511D-10,   2.143909234181543D-08, &
&   -1.200589179404041D-06,   6.723299408653463D-05,  -3.765047668989812D-03, &
&    2.108426694637737D-01,                                                   &
&    1.197285213679834D-22,  -6.738596698074233D-21,   3.775010300498874D-19, &
&   -2.114735433214941D-17,   1.184344209064626D-15,  -6.632430925468877D-14, &
&    3.714171577845231D-12,  -2.079936968880792D-10,   1.164764767647065D-08, &
&   -6.522682738456193D-07,   3.652702335456151D-05,  -2.045513307924904D-03, &
&    1.145487452439613D-01,                                                   &
&    5.763155647931119D-23,  -3.242227701431621D-21,   1.816109389746505D-19, &
&   -1.017344407598300D-17,   5.697538973308720D-16,  -3.190667823687565D-14, &
&    1.786778557424254D-12,  -1.000596387843408D-10,   5.603340063336433D-09, &
&   -3.137870453248829D-07,   1.757207454682492D-05,  -9.840361746534606D-04, &
&    5.510602578066893D-02,                                                   &
&    2.007422645156930D-23,  -1.129074146691468D-21,   6.324037013934919D-20, &
&   -3.542534415410251D-18,   1.983955816948071D-16,  -1.111030581192090D-14, &
&    6.221786517509560D-13,  -3.484201771003038D-11,   1.951153089166386D-09, &
&   -1.092645735882110D-07,   6.118816123830396D-06,  -3.426537029449816D-04, &
&    1.918860736494418D-02,                                                   &
&    2.196874518355023D-24,  -1.235505438221223D-22,   6.919979763649427D-21, &
&   -3.876338448256200D-19,   2.170895859589246D-17,  -1.215718110367334D-15, &
&    6.808037790489654D-14,  -3.812502580629205D-12,   2.135001549739381D-10, &
&   -1.195600874244464D-08,   6.695364898875386D-07,  -3.749404343482879D-05, &
&    2.099666432353123D-03,                                                   &
&    1.402579332887954D-22,  -8.149871280477782D-21,   4.724708516639835D-19, &
&   -2.740648073277668D-17,   1.589615693725264D-15,  -9.219814470238304D-14, &
&    5.347496641984006D-12,  -3.101548414001538D-10,   1.798898106362412D-08, &
&   -1.043360903269086D-06,   6.051493239717137D-05,  -3.509866079063000D-03, &
&    2.035722325857183D-01,                                                   &
&    7.622787251183611D-23,  -4.428130756472190D-21,   2.566936785390642D-19, &
&   -1.488972856806035D-17,   8.636231505740157D-16,  -5.009034935262419D-14, &
&    2.905242291150793D-12,  -1.685040702161052D-10,   9.773236198706344D-09, &
&   -5.668477002865509D-07,   3.287716662027969D-05,  -1.906875663989352D-03, &
&    1.105987885114137D-01,                                                   &
&    3.667744311093545D-23,  -2.130334880310620D-21,   1.234889398877420D-19, &
&   -7.163023484773486D-18,   4.154637943230913D-16,  -2.409699236018580D-14, &
&    1.397626464830902D-12,  -8.106234273040193D-11,   4.701615935035948D-09, &
&   -2.726937245747286D-07,   1.581623602698338D-05,  -9.173416895709613D-04, &
&    5.320581799512988D-02,                                                   &
&    1.277270915567686D-23,  -7.418262471699092D-22,   4.300061237925952D-20, &
&   -2.494256950089635D-18,   1.446697166005471D-16,  -8.390874367251562D-15, &
&    4.866710166775738D-13,  -2.822692156625003D-11,   1.637161469816183D-09, &
&   -9.495536536415688D-08,   5.507411191674181D-06,  -3.194298491190913D-04, &
&    1.852693124891204D-02,                                                   &
&    1.397681402849883D-24,  -8.117335190927103D-23,   4.705247532101297D-21, &
&   -2.729280932049080D-19,   1.583013126887784D-17,  -9.181509190936770D-16, &
&    5.325278587722550D-14,  -3.088661860022936D-12,   1.791423899200960D-10, &
&   -1.039025862770804D-08,   6.026350004665433D-07,  -3.495283002727346D-05, &
&    2.027264141582371D-03,                                                   &
&    9.042077168840497D-23,  -5.428038170187560D-21,   3.254356212972151D-19, &
&   -1.952676973459678D-17,   1.171614284474030D-15,  -7.029694183177321D-14, &
&    4.217817331024174D-12,  -2.530690467897568D-10,   1.518414285724043D-08, &
&   -9.110485717320384D-07,   5.466291430533756D-05,  -3.279774858325281D-03, &
&    1.967864914995287D-01,                                                   &
&    4.912980731536672D-23,  -2.949070278462641D-21,   1.768068585621475D-19, &
&   -1.060871199133056D-17,   6.365266067212010D-16,  -3.819163697567350D-14, &
&    2.291498612938729D-12,  -1.374899201151829D-10,   8.249395231011170D-09, &
&   -4.949637140049569D-07,   2.969782284098544D-05,  -1.781869370461577D-03, &
&    1.069121622277004D-01,                                                   &
&    2.363602027381594D-23,  -1.418727688309925D-21,   8.505678508831617D-20, &
&   -5.103541234700097D-18,   3.062142194846569D-16,  -1.837287135076481D-14, &
&    1.102372458101018D-12,  -6.614234898752375D-11,   3.968540950106412D-09, &
&   -2.381124570714711D-07,   1.428674742459907D-05,  -8.572048454770526D-04, &
&    5.143229072862578D-02,                                                   &
&    8.230601023851947D-24,  -4.940219069708251D-22,   2.961787662115053D-20, &
&   -1.777117358429545D-18,   1.066276258812384D-16,  -6.397663632305880D-15, &
&    3.838598771975655D-13,  -2.303159313485308D-11,   1.381895591730838D-09, &
&   -8.291373552569158D-08,   4.974824131645875D-06,  -2.984894478991250D-04, &
&    1.790936687394838D-02,                                                   &
&    9.006232964248443D-25,  -5.405729261343279D-23,   3.240865692710374D-21, &
&   -1.944567439190418D-19,   1.166746743215264D-17,  -7.000486988064133D-16, &
&    4.200292829505290D-14,  -2.520175751766927D-12,   1.512105454973691D-10, &
&   -9.072632732191508D-09,   5.443579639427221D-07,  -3.266147783660342D-05, &
&    1.959688670196301D-03/
      data w5 / &
&    2.691964753393948D-11,  -5.077226034809943D-10,   6.424058524393160D-09, &
&   -6.987142818783722D-08,   6.810349201687823D-07,  -5.923437883474737D-06, &
&    4.532256247748109D-05,  -2.991038324698276D-04,   1.656957859387342D-03, &
&   -7.406712250957773D-03,   2.508899468486140D-02,  -5.737828174883671D-02, &
&    6.667134430868814D-02,                                                   &
&    2.132442944927298D-11,  -4.092458952672610D-10,   5.316010231745663D-09, &
&   -5.984211032933959D-08,   6.084868928002171D-07,  -5.570846086251808D-06, &
&    4.534887460897852D-05,  -3.225570003814761D-04,   1.956823937636217D-03, &
&   -9.772325950868642D-03,   3.794559457141293D-02,  -1.029792621935702D-01, &
&    1.494513491505806D-01,                                                   &
&    4.338552727070082D-12,  -8.621609801478801D-11,   1.180010644317569D-09, &
&   -1.421204707854628D-08,   1.569004333560513D-07,  -1.585269681900559D-06, &
&    1.451727458625312D-05,  -1.188620557536045D-04,   8.536985295685169D-04, &
&   -5.228778204228172D-03,   2.608545249109095D-02,  -9.711527268121125D-02, &
&    2.190863625159820D-01,                                                   &
&    2.255455404523579D-13,  -4.766318610888250D-12,   7.143324475427812D-11, &
&   -9.653271136896358D-10,   1.222951105369484D-08,  -1.452943028467782D-07, &
&    1.609073128824111D-06,  -1.646721211052083D-05,   1.538457998270376D-04, &
&   -1.288488915171088D-03,   9.388669356097514D-03,  -5.617375901872828D-02, &
&    2.692667193099964D-01,                                                   &
&    1.477007795607773D-15,  -3.495215765367628D-14,   6.202201864810775D-13, &
&   -1.033102376547946D-11,   1.667818046583227D-10,  -2.616673380429744D-09, &
&    3.980555678691211D-08,  -5.856531097170059D-07,   8.303502661973755D-06, &
&   -1.132184882503521D-04,   1.491288896535044D-03,  -1.968675769098687D-02, &
&    2.955242247147529D-01,                                                   &
&    6.711566024958548D-12,  -8.680528841601608D-11,   1.013399465201668D-09, &
&   -1.100224213991489D-08,   1.080809468721750D-07,  -9.491750293017914D-07, &
&    7.343543121662977D-06,  -4.908721015006706D-05,   2.760131901080944D-04, &
&   -1.255695438269890D-03,   4.344232998718861D-03,  -1.019604568739473D-02, &
&    1.224372781911606D-02,                                                   &
&    5.489658030119083D-12,  -7.333243346721028D-11,   8.914142842206780D-10, &
&   -1.014761906807497D-08,   1.055212708082492D-07,  -9.921891677237309D-07, &
&    8.332142315562237D-06,  -6.146932689964206D-05,   3.894036621166058D-04, &
&   -2.048419451007655D-03,   8.476781006956692D-03,  -2.493139948582420D-02, &
&    4.040304021278896D-02,                                                   &
&    1.187211395720106D-12,  -1.687685349193676D-11,   2.214720539497206D-10, &
&   -2.754774080252233D-09,   3.180602299845112D-08,  -3.383425062307992D-07, &
&    3.285948582424051D-06,  -2.877870642237335D-05,   2.234257976678990D-04, &
&   -1.498929272082011D-03,   8.338562375857065D-03,  -3.549919847808014D-02, &
&    9.798312266534085D-02,                                                   &
&    6.811121270059236D-14,  -1.073113979006046D-12,   1.593263974337713D-11, &
&   -2.280562595683742D-10,   3.097031720090995D-09,  -3.972258208883492D-08, &
&    4.785204682505116D-07,  -5.372722802313763D-06,   5.562753717228776D-05, &
&   -5.226773037105707D-04,   4.339368795941669D-03,  -3.022079327457590D-02, &
&    1.861876332103985D-01,                                                   &
&    5.175318432736271D-16,  -9.808090839209176D-15,   1.807418916369485D-13, &
&   -3.251387637791352D-12,   5.738044684403031D-11,  -9.888223444003050D-10, &
&    1.656188387623284D-08,  -2.697804729494501D-07,   4.254822195552991D-06, &
&   -6.506149035843204D-05,   9.724622390132015D-04,  -1.485474393029488D-02, &
&    2.613264827536597D-01,                                                   &
&    1.045925117183131D-12,  -1.362682068913741D-11,   1.604385152916091D-10, &
&   -1.758046944067381D-09,   1.745247906906473D-08,  -1.551207503786751D-07, &
&    1.216880480567661D-06,  -8.266653397951991D-06,   4.737840106642360D-05, &
&   -2.205342214037242D-04,   7.846353061899839D-04,  -1.907592889435701D-03, &
&    2.399839193869030D-03,                                                   &
&    9.060465066628678D-13,  -1.233182284033598D-11,   1.532502324965147D-10, &
&   -1.788071441496430D-09,   1.912824449872289D-08,  -1.858612266314191D-07, &
&    1.621642393465784D-06,  -1.251236879145510D-05,   8.359351663244217D-05, &
&   -4.687512320953438D-04,   2.098249441937782D-03,  -6.818129095082243D-03, &
&    1.275230852753834D-02,                                                   &
&    2.175235892187963D-13,  -3.207352436460224D-12,   4.390387084133210D-11, &
&   -5.719181549949015D-10,   6.954803914358902D-09,  -7.843630049518005D-08, &
&    8.137479886801027D-07,  -7.681333382757666D-06,   6.497290648089518D-05, &
&   -4.813938273337645D-04,   3.012623703691587D-03,  -1.477825290468301D-02, &
&    5.117535681147678D-02,                                                   &
&    1.460874751721026D-14,  -2.436257296590512D-13,   3.855100613228361D-12, &
&   -5.903906423034659D-11,   8.622166866728900D-10,  -1.196916389894128D-08, &
&    1.571118860733494D-07,  -1.936660652530415D-06,   2.221492845613437D-05, &
&   -2.337170089559153D-04,   2.201355991741016D-03,  -1.770838516893307D-02, &
&    1.396664481590552D-01,                                                   &
&    1.392320500633053D-16,  -2.959285782255487D-15,   5.745591544476282D-14, &
&   -1.110668996671523D-12,   2.172514138641760D-11,  -4.062139660492016D-10, &
&    7.448888981009014D-09,  -1.337330521550436D-07,   2.327091336522558D-06, &
&   -3.963020858366986D-05,   6.660266374360489D-04,  -1.162827200342508D-02, &
&    2.350467426892715D-01,                                                   &
&    1.651834543265854D-13,  -2.171101838221865D-12,   2.582604121949835D-11, &
&   -2.862224332883355D-10,   2.878490339695131D-09,  -2.597102869284859D-08, &
&    2.073310805206531D-07,  -1.437852510842967D-06,   8.446986802018461D-06, &
&   -4.052105955604486D-05,   1.496929281443340D-04,  -3.820259854589744D-04, &
&    5.141754314514452D-04,                                                   &
&    1.544805775717589D-13,  -2.150989300920963D-12,   2.745761872907924D-11, &
&   -3.300998093091519D-10,   3.654898328309822D-09,  -3.695329793610775D-08, &
&    3.376508576729904D-07,  -2.749861041594020D-06,   1.958198088135801D-05, &
&   -1.185266078317065D-04,   5.828055195162883D-04,  -2.131919338441587D-03, &
&    4.780250126674483D-03,                                                   &
&    4.226297791325333D-14,  -6.498054113423070D-13,   9.330847591793480D-12, &
&   -1.280188929158847D-10,   1.649338218514819D-09,  -1.984138571677308D-08, &
&    2.211942954028586D-07,  -2.263835466057626D-06,   2.098491221660229D-05, &
&   -1.726389404353386D-04,   1.221950861967296D-03,  -6.912759814178116D-03, &
&    3.065552590441316D-02,                                                   &
&    3.396569503625084D-15,  -6.018845777747459D-14,   1.019225103567268D-12, &
&   -1.671064299157019D-11,   2.627436401981711D-10,  -3.955110911272822D-09, &
&    5.652923398714371D-08,  -7.642869529471561D-07,   9.694499994749223D-06, &
&   -1.137507008053383D-04,   1.208254457080372D-03,  -1.112605293641865D-02, &
&    1.114875485441027D-01,                                                   &
&    4.559505017149135D-17,  -9.875119908912953D-16,   1.829260004260871D-14, &
&   -4.231283819372883D-13,   9.072203315921394D-12,  -1.760045424062136D-10, &
&    3.605285769198872D-09,  -7.058605742220577D-08,   1.343471603825975D-06, &
&   -2.536472490145306D-05,   4.749460923575930D-04,  -9.374691523585276D-03, &
&    2.141706473470167D-01,                                                   &
&    2.650514902463144D-14,  -3.521160012878011D-13,   4.241580524781984D-12, &
&   -4.767159604410776D-11,   4.872479213035471D-10,  -4.479993806906242D-09, &
&    3.656988187459611D-08,  -2.604482410273084D-07,   1.580199335347971D-06, &
&   -7.888731568215253D-06,   3.065899482410553D-05,  -8.365936983922155D-05, &
&    1.244250917884711D-04,                                                   &
&    2.737562525439053D-14,  -3.917821976482560D-13,   5.164813218795945D-12, &
&   -6.435723458218659D-11,   7.424267867443268D-10,  -7.869131347389227D-09, &
&    7.592661217210809D-08,  -6.588468752034162D-07,   5.053595815460178D-06, &
&   -3.341324698264412D-05,   1.831219994168556D-04,  -7.650061755414897D-04, &
&    2.142407394833440D-03,                                                   &
&    8.756668621418999D-15,  -1.411267990955456D-13,   2.136466881557773D-12, &
&   -3.101083240556298D-11,   4.255967244361317D-10,  -5.487011063104896D-09, &
&    6.597654427005500D-08,  -7.355842628216497D-07,   7.496476289550109D-06, &
&   -6.864553373750766D-05,   5.508590498023694D-04,  -3.571197532211553D-03, &
&    2.061199587271682D-02,                                                   &
&    8.532519734557241D-16,  -1.623215360666082D-14,   2.937753377090375D-13, &
&   -5.125128421786823D-12,   8.734563457626422D-11,  -1.425152152055373D-09, &
&    2.206360120472588D-08,  -3.273999487970484D-07,   4.574395692143825D-06, &
&   -5.954189689529281D-05,   7.085885734101676D-04,  -7.399645582999001D-03, &
&    9.329228096763898D-02,                                                   &
&    2.038039987232015D-17,  -2.597589306003464D-16,   5.728500288007703D-15, &
&   -2.089906628921581D-13,   3.753566967890287D-12,  -7.841359432883365D-11, &
&    1.922267021866730D-09,  -3.877311974238210D-08,   8.133112611616298D-07, &
&   -1.694788441314261D-05,   3.501156638624632D-04,  -7.741317882746513D-03, &
&    1.971375779943295D-01,                                                   &
&    4.334785239455331D-15,  -5.834609654156553D-14,   7.138349675670583D-13, &
&   -8.164098366352385D-12,   8.515834110138146D-11,  -8.019457023273643D-10, &
&    6.735196853795080D-09,  -4.964285258546540D-08,   3.141234311737025D-07, &
&   -1.652835430537366D-06,   6.875823919595853D-06,  -2.053580213001220D-05, &
&    3.545241067440661D-05,                                                   &
&    5.075286815775945D-15,  -7.505118799366022D-14,   1.027635717809480D-12, &
&   -1.335477277197202D-11,   1.616508351352880D-10,  -1.809335293342458D-09, &
&    1.858391395569451D-08,  -1.733978608204237D-07,   1.445354522397154D-06, &
&   -1.054677601935452D-05,   6.523944954376104D-05,  -3.127826572176022D-04, &
&    1.141365256490647D-03,                                                   &
&    1.940498014131098D-15,  -3.305057681008040D-14,   5.277373585939463D-13, &
&   -8.138133202194470D-12,   1.198191280150861D-10,  -1.654870841613629D-09, &
&    2.151996808979840D-08,  -2.627889770919424D-07,   2.938248212598823D-06, &
&   -2.998985704530177D-05,   2.728425983113872D-04,  -1.999884007334021D-03, &
&    1.522389283148073D-02,                                                   &
&    2.294380778365145D-16,  -4.891227089698415D-15,   8.977891031332593D-14, &
&   -1.689640104467946D-12,   3.197458422008000D-11,  -5.511492659556232D-10, &
&    9.241068034556701D-09,  -1.515846670310172D-07,   2.305693547026300D-06, &
&   -3.317775172821056D-05,   4.394041430367616D-04,  -5.155928667697167D-03, &
&    8.091497211119353D-02,                                                   &
&    1.411327493090474D-17,   1.493446900581689D-16,   4.766306329576372D-15, &
&   -1.189855499012212D-13,   8.294010545320924D-13,  -4.383838147642944D-11, &
&    1.120986269065739D-09,  -2.099189090800933D-08,   5.223901353293338D-07, &
&   -1.172298589691110D-05,   2.652604516077326D-04,  -6.520968394465209D-03, &
&    1.829317078968034D-01,                                                   &
&    7.254052893946103D-16,  -9.923398897906927D-15,   1.237650876908734D-13, &
&   -1.446720788203021D-12,   1.548221096918943D-11,  -1.502779562496770D-10, &
&    1.308785305210096D-09,  -1.008184540883596D-08,   6.733780030400051D-08, &
&   -3.793640605859998D-07,   1.725719706203674D-06,  -5.780634307426367D-06, &
&    1.244547467072293D-05,                                                   &
&    9.915155821285843D-16,  -1.523659192056590D-14,   2.176169258292577D-13, &
&   -2.971811499644219D-12,   3.800395510436045D-11,  -4.515674488268063D-10, &
&    4.980241352085923D-09,  -5.036272330381757D-08,   4.582155303221731D-07, &
&   -3.728636560049430D-06,   2.625792215794611D-05,  -1.431098314528461D-04, &
&    7.109537118485328D-04,                                                   &
&    4.725725098037547D-16,  -8.380984263488720D-15,   1.383321545197394D-13, &
&   -2.341053956377193D-12,   3.682087452590178D-11,  -5.368063642857128D-10, &
&    7.685848008872659D-09,  -1.028336823940749D-07,   1.245496334221417D-06, &
&   -1.430108646653407D-05,   1.466335010727643D-04,  -1.191894302778388D-03, &
&    1.211537151962538D-02,                                                   &
&    9.001526428485008D-17,  -1.552487771395744D-15,   2.521124897685718D-14, &
&   -6.573909369777356D-13,   1.275327920231372D-11,  -2.175440114102529D-10, &
&    4.211965543481623D-09,  -7.546979311109224D-08,   1.220014785322691D-06, &
&   -1.957625128084902D-05,   2.854454122206760D-04,  -3.733233066950220D-03, &
&    7.212787800599648D-02,                                                   &
&   -2.827881683017284D-17,   1.195950426924323D-16,   9.699585877446863D-15, &
&    2.536987261269440D-14,  -1.723700714932568D-13,  -4.204262084389455D-11, &
&    5.391307866379357D-10,  -1.104664608608021D-08,   3.679768494242663D-07, &
&   -8.227804511014930D-06,   2.060211235356470D-04,  -5.585369094387358D-03, &
&    1.708647818172419D-01,                                                   &
&    1.248759373667107D-16,  -1.741905660084109D-15,   2.224662174726066D-14, &
&   -2.673720208886917D-13,   2.954057187964758D-12,  -2.977756806151623D-11, &
&    2.716560346835221D-10,  -2.212193132584427D-09,   1.580136092784990D-08, &
&   -9.716290145559072D-08,   4.944858912430053D-07,  -1.884840804727262D-06, &
&    5.574816790583972D-06,                                                   &
&    2.078979906345784D-16,  -3.263838995272625D-15,   4.931932663045496D-14, &
&   -7.183902139541946D-13,   9.646944555998668D-12,  -1.224856896837704D-10, &
&    1.473370456328427D-09,  -1.610457460556088D-08,   1.599398897918105D-07, &
&   -1.478532508847260D-06,   1.180261151941028D-05,  -7.140096373777971D-05, &
&    5.059258242053139D-04,                                                   &
&    1.384920507590436D-16,  -1.864922762401030D-15,   4.062245662922404D-14, &
&   -7.826408045437651D-13,   1.155631836112072D-11,  -1.860947816451735D-10, &
&    3.086635236499908D-09,  -4.300839700225686D-08,   5.613648231711098D-07, &
&   -7.466121181627938D-06,   8.403265247812467D-05,  -7.440760186932976D-04, &
&    1.022077702707212D-02,                                                   &
&    4.362985144093669D-17,   1.964044167372268D-16,   1.223221488903715D-14, &
&   -3.485210887867123D-13,   4.079502212737302D-12,  -8.997727046258778D-11, &
&    2.219824930694708D-09,  -3.864549945262009D-08,   6.690399069773181D-07, &
&   -1.226318354990947D-05,   1.921154354005582D-04,  -2.792640647584781D-03, &
&    6.566393338533549D-02,                                                   &
&   -4.341436511558343D-17,  -1.129267769791529D-15,  -3.710854047783014D-16, &
&    1.682238042369238D-13,   1.864584704658374D-12,  -3.217808321663531D-11, &
&   -1.952412886219536D-11,  -8.056527716658655D-09,   2.781266746940183D-07, &
&   -5.663160649986944D-06,   1.647030688852300D-04,  -4.849042116677685D-03, &
&    1.604578689252672D-01,                                                   &
&    2.217246387782905D-17,  -3.168105379969565D-16,   4.190609690444127D-15, &
&   -5.202517602522020D-14,   5.959764136323553D-13,  -6.315859006543584D-12, &
&    6.112945358092208D-11,  -5.303892082031598D-10,   4.111062138118081D-09, &
&   -2.831301614439107D-08,   1.632292785428248D-07,  -7.028602548732458D-07, &
&    3.202020630470216D-06,                                                   &
&    4.071345859623136D-17,  -7.384279615529953D-16,   1.286465871886627D-14, &
&   -1.847963952008850D-13,   2.569871522214630D-12,  -3.714131926680867D-11, &
&    4.842248569551508D-10,  -5.519627186268910D-09,   6.145712953295085D-08, &
&   -6.619826326507625D-07,   5.767372730033211D-06,  -3.786673983676528D-05, &
&    4.006305385622115D-04,                                                   &
&   -1.918812151816947D-17,  -6.241741556354003D-16,   2.079659219998908D-14, &
&   -2.121867515435932D-13,   3.153640692354680D-12,  -8.189892049341908D-11, &
&    1.365542047744187D-09,  -1.771656794465035D-08,   2.746428751507963D-07, &
&   -4.288828957045192D-06,   4.990127285768522D-05,  -4.824963762071894D-04, &
&    9.016808519161300D-03,                                                   &
&   -7.559240573744546D-17,  -3.237464330096064D-16,   1.687358778211255D-14, &
&   -3.711784783544087D-14,   4.327512246127032D-13,  -6.145268854652547D-11, &
&    1.228603920270270D-09,  -1.833294417058845D-08,   3.939216793938370D-07, &
&   -8.146262440817462D-06,   1.319797986616859D-04,  -2.152630134725667D-03, &
&    6.075860777660466D-02,                                                   &
&    1.398171130969596D-16,   7.797668144617810D-17,  -2.130123228853285D-14, &
&   -9.313148965279965D-14,   3.225652860558858D-12,   1.503086108590173D-11, &
&   -1.676117323705171D-10,  -9.858689127795495D-09,   1.900898969272795D-07, &
&   -3.777363551163738D-06,   1.367323914676884D-04,  -4.249948120607302D-03, &
&    1.513774790924336D-01,                                                   &
&    4.069072094860051D-18,  -6.211835081543993D-17,   8.330795795057834D-16, &
&   -1.055344041989694D-14,   1.290379956647254D-13,  -1.469983442307401D-12, &
&    1.499209266260882D-11,  -1.388791371090536D-10,   1.209665998990417D-09, &
&   -9.554695268428649D-09,   6.088134829452916D-08,  -2.911603188651667D-07, &
&    2.274751162236070D-06,                                                   &
&    1.117379887269386D-17,  -2.693504457044538D-16,   3.092632897119440D-15, &
&   -4.092986370507913D-14,   8.243219056934900D-13,  -1.336784938900503D-11, &
&    1.621874189667166D-10,  -1.964603798043017D-09,   2.719419622263808D-08, &
&   -3.306515505373033D-07,   2.924016475019506D-06,  -2.113738641376838D-05, &
&    3.435041861427159D-04,                                                   &
&    3.125493583437492D-17,  -9.218874822579617D-16,   1.129571982734900D-15, &
&    2.240879661703314D-14,   2.052296668227487D-12,  -4.596356702603323D-11, &
&    4.887711285908048D-10,  -7.077687174578677D-09,   1.594047533685161D-07, &
&   -2.622924215224576D-06,   2.961999077420814D-05,  -3.267576529682339D-04, &
&    8.221015212601815D-03,                                                   &
&    5.012175065983688D-17,  -1.063117582223308D-15,  -4.791999206365779D-15, &
&    1.151570256186924D-13,   1.824244238452595D-12,  -4.721050016969976D-11, &
&    4.393513066318379D-10,  -8.513729434271802D-09,   2.676403477028620D-07, &
&   -5.565230685100654D-06,   9.134406213825967D-05,  -1.711118431508046D-03, &
&    5.692188356772266D-02,                                                   &
&   -6.935740283006369D-17,   1.787886173641682D-15,   9.819177029747308D-15, &
&   -2.793282736834023D-13,  -1.124537350999426D-12,   3.666746788557657D-11, &
&    2.793094990783124D-10,  -9.505372167378121D-09,   8.862698011981751D-08, &
&   -2.664420879783764D-06,   1.178166640219480D-04,  -3.743075199636519D-03, &
&    1.433970114227859D-01,                                                   &
&    9.050895376555302D-19,  -1.186792730066369D-17,   1.601530204978547D-16, &
&   -2.374441183526468D-15,   3.210401086297280D-14,  -3.688792170178804D-13, &
&    3.858163635422663D-12,  -4.067641463454267D-11,   4.198118923394437D-10, &
&   -3.671895544744284D-09,   2.427581296580775D-08,  -1.323608787900752D-07, &
&    1.875228587325859D-06,                                                   &
&    7.142772972537429D-18,  -1.392988490686412D-17,   1.429624359953643D-16, &
&   -1.830761786607834D-14,   3.788305335110409D-13,  -4.238117277505208D-12, &
&    4.693549594816102D-11,  -8.363525430992734D-10,   1.432623291172124D-08, &
&   -1.719236024433816D-07,   1.466858744706141D-06,  -1.267017907758597D-05, &
&    3.106613682705447D-04,                                                   &
&    3.503711479814362D-17,   3.621905600846090D-16,  -5.167409909198279D-15, &
&   -6.994103469715442D-14,   1.814032806758160D-12,  -1.255791196165268D-11, &
&    8.286002350303404D-11,  -4.122824775193955D-09,   1.074544336719976D-07, &
&   -1.574549075830807D-06,   1.723213262780035D-05,  -2.351426414908291D-04, &
&    7.667346400391943D-03,                                                   &
&    3.755985001791366D-17,   6.713793028626067D-16,  -8.319807820583055D-15, &
&   -8.635550382472694D-14,   2.183880929267863D-12,  -9.958660422133884D-12, &
&    3.208829519450446D-11,  -6.221568130961818D-09,   1.980509566623738D-07, &
&   -3.717022561137932D-06,   6.377238526799646D-05,  -1.404576255052275D-03, &
&    5.382453350864601D-02,                                                   &
&   -7.301605997381728D-17,  -1.169172244287259D-15,   1.656846198083962D-14, &
&    1.054297384393258D-13,  -2.890658085791711D-12,  -5.291752249099467D-12, &
&    5.326543589842534D-10,  -4.017877883898927D-09,   1.840921275152273D-08, &
&   -2.273696749042594D-06,   1.032852868778797D-04,  -3.301637632721020D-03, &
&    1.363619483240778D-01,                                                   &
&    1.053320670360494D-19,  -2.082467683346330D-18,   4.359342166163429D-17, &
&   -6.731562209779653D-16,   7.964175666801400D-15,  -8.759099794236049D-14, &
&    1.101525765783944D-12,  -1.474826110157023D-11,   1.693876803957033D-10, &
&   -1.482906121544778D-09,   9.792040907269743D-09,  -6.853688549549412D-08, &
&    1.683857114332048D-06,                                                   &
&   -2.603773629035950D-18,   1.160951088037408D-17,   5.946858308759290D-16, &
&   -1.157598918362313D-14,   9.349844636099449D-14,  -6.185018998741156D-13, &
&    1.833098193665302D-11,  -4.949857938198023D-10,   7.944744331423989D-09, &
&   -8.504874768170239D-08,   7.212512148269376D-07,  -8.466836660821827D-06, &
&    2.900180618650334D-04,                                                   &
&   -2.959463255117473D-17,   1.781503784552966D-16,   3.944803362692036D-15, &
&   -7.290538213327104D-14,   2.362605718550617D-13,   3.866358858218992D-12, &
&    5.259131674941993D-11,  -3.540056241434210D-09,   6.938059669638137D-08, &
&   -8.707875121348210D-07,   1.004824724265900D-05,  -1.819880260051582D-04, &
&    7.254984715652662D-03,                                                   &
&   -4.273527708836199D-17,   2.350155986312997D-16,   5.542977915104643D-15, &
&   -9.436968396760269D-14,   1.185948632633582D-13,   8.551605055161017D-12, &
&    6.246493977383435D-11,  -5.913519640135941D-09,   1.369898471483969D-07, &
&   -2.378567275996981D-06,   4.573019709135625D-05,  -1.188247376999749D-03, &
&    5.124370537104322D-02,                                                   &
&    7.718706470093376D-17,  -4.771228507678635D-16,  -8.875567024673771D-15, &
&    1.505248806973411D-13,   2.196123847188412D-13,  -2.757739506718406D-11, &
&    2.414319094207152D-10,   9.410024455886475D-10,   6.062009787659280D-09, &
&   -2.209291495854103D-06,   8.988323786256488D-05,  -2.915415929698932D-03, &
&    1.301538233482785D-01,                                                   &
&    3.449648942166828D-20,  -9.132218047235696D-19,   1.337523238620451D-17, &
&   -1.415459328563381D-16,   1.525574008268247D-15,  -2.425701149562282D-14, &
&    4.354578335740685D-13,  -6.378005834658443D-12,   7.018612561978311D-11, &
&   -5.792970230222108D-10,   3.997172494935227D-09,  -4.274399178322630D-08, &
&    1.576387537480050D-06,                                                   &
&    1.954528899919042D-19,  -2.344524286499833D-17,   3.160404050137735D-16, &
&   -1.127337484850019D-15,  -1.153991124305105D-14,  -2.201287655284728D-13, &
&    1.438507643976697D-11,  -3.035383709477808D-10,   3.987765313250182D-09, &
&   -3.858897869294101D-08,   3.661387409605324D-07,  -6.384469175916142D-06, &
&    2.754013924305145D-04,                                                   &
&    1.128206486864450D-18,  -1.886184591692539D-16,   2.256911186942139D-15, &
&    2.772842137948213D-15,  -3.346610166941607D-13,   1.197019723316415D-12, &
&    9.845165963246404D-11,  -2.591078548264671D-09,   3.824569956179110D-08, &
&   -4.466688865797624D-07,   6.220808041619038D-06,  -1.502955874760659D-04, &
&    6.925236048441580D-03,                                                   &
&    2.271142911173060D-18,  -2.626155928706757D-16,   2.962808950541715D-15, &
&    9.007862072173563D-15,  -5.584320463208341D-13,   2.463913520608100D-12, &
&    1.518486795054222D-10,  -4.535111633419093D-09,   8.382862473952042D-08, &
&   -1.504610347623082D-06,   3.429405180735743D-05,  -1.029943044003418D-03, &
&    4.903311055251751D-02,                                                   &
&   -2.829437131889273D-18,   4.555279615485174D-16,  -5.046768311703259D-15, &
&   -2.320870989382468D-14,   1.225816129711489D-12,  -1.167839026836335D-11, &
&   -5.157998205928463D-11,   1.845189167186521D-09,   2.295902946929588D-08, &
&   -2.098914903239840D-06,   7.688864551167159D-05,  -2.582090688707911D-03, &
&    1.246649892578688D-01,                                                   &
&    1.870916425443567D-20,  -2.195783212611154D-19,   1.690899806626938D-18, &
&   -1.686865543088493D-17,   4.457497223864578D-16,  -1.135292709531961D-14, &
&    2.050609359358272D-13,  -2.707675631483724D-12,   2.702503899570325D-11, &
&   -2.146953077165253D-10,   1.786038349242893D-09,  -3.189711465715069D-08, &
&    1.503197843978721D-06,                                                   &
&    6.895098135928074D-19,  -5.870437552030156D-18,  -2.554671580317777D-17, &
&    1.065479942954581D-15,  -1.759340676469194D-15,  -3.756108732921855D-13, &
&    9.993614260546288D-12,  -1.549563397402364D-10,   1.739682190498505D-09, &
&   -1.667289010134254D-08,   2.093097852512654D-07,  -5.277006272296562D-06, &
&    2.638432774438207D-04,                                                   &
&    5.827565440607707D-18,  -4.309828872287374D-17,  -4.751621570733511D-16, &
&    1.465178825199752D-14,  -9.500922754243490D-14,  -2.495855307066027D-12, &
&    8.457589200375947D-11,  -1.440533594460362D-09,   1.823623098296807D-08, &
&   -2.284816803016280D-07,   4.275271918913776D-06,  -1.297366936889618D-04, &
&    6.646490143046013D-03,                                                   &
&    7.999706716782554D-18,  -5.642900750422245D-17,  -7.637064579978783D-16, &
&    2.263423908945493D-14,  -1.608657719225201D-13,  -3.575918621139199D-12, &
&    1.362210166878417D-10,  -2.721387170627988D-09,   4.771845725450449D-08, &
&   -9.906276693694371D-07,   2.695263499311321D-05,  -9.084727338917471D-04, &
&    4.709956982124142D-02,                                                   &
&   -1.424088202962098D-17,   9.762172440454621D-17,   1.479612970570404D-15, &
&   -4.427128531695508D-14,   4.206296520548467D-13,   1.925904715452600D-12, &
&   -1.040757144198270D-10,   7.196718850148873D-10,   3.627611183264078D-08, &
&   -1.854214832038904D-06,   6.497560490939507D-05,  -2.298854735762816D-03, &
&    1.197919930355187D-01,                                                   &
&    2.275775045740129D-21,  -3.565386296868326D-21,   8.338052672143721D-21, &
&   -7.443527162195946D-18,   2.729938112596523D-16,  -5.793506127025771D-15, &
&    8.809560939767437D-14,  -1.026077248623224D-12,   9.519946654730965D-12, &
&   -7.962316696828635D-11,   9.721743816861198D-10,  -2.664640796353458D-08, &
&    1.445187738159181D-06,                                                   &
&    4.165854330922797D-20,   1.853832478020580D-18,  -3.864241383090206D-17, &
&    1.510117075838255D-16,   9.400753130985615D-15,  -2.912443232020763D-13, &
&    5.116799694545065D-12,  -6.554158078731938D-11,   6.863786879750099D-10, &
&   -7.563042809257072D-09,   1.407757083108695D-07,  -4.594817516768110D-06, &
&    2.540165888043933D-04,                                                   &
&    2.469591819437990D-19,   2.097206502237509D-17,  -4.504886530907997D-16, &
&    3.135640680993409D-15,   6.277361823576247D-14,  -2.466678038760526D-12, &
&    4.690393075298102D-11,  -6.528796281914149D-10,   8.151742290243179D-09, &
&   -1.281787097735579D-07,   3.245320635304949D-06,  -1.148940153582793D-04, &
&    6.402540748537167D-03,                                                   &
&    3.068696286349192D-19,   3.088794368942819D-17,  -6.756522656654693D-16, &
&    5.164224108502701D-15,   8.452846662851282D-14,  -3.752808719254982D-12, &
&    8.036049001764788D-11,  -1.420653634403779D-09,   2.757595753229526D-08, &
&   -6.981225170102045D-07,   2.196649715372905D-05,  -8.112160108051260D-04, &
&    4.538319451297056D-02,                                                   &
&   -4.810769519884741D-19,  -5.711922026182771D-17,   1.264397954630364D-15, &
&   -1.137979219660112D-14,  -6.991992595694577D-14,   3.916445723681665D-12, &
&   -5.406686445438857D-11,  -2.547381254055414D-10,   3.808250839850599D-08, &
&   -1.550251543084443D-06,   5.475540104179030D-05,  -2.060003267446972D-03, &
&    1.154399493846073D-01,                                                   &
&   -4.233780622481471D-22,   4.158457398000304D-21,   1.316147749803502D-19, &
&   -6.188359493753944D-18,   1.459875394224668D-16,  -2.471328256534939D-15, &
&    3.262960017405106D-14,  -3.481538202543258D-13,   3.198660690232494D-12, &
&   -3.320637046060184D-11,   6.585326632046492D-10,  -2.347605501313467D-08, &
&    1.395271081732889D-06,                                                   &
&   -5.841747372733829D-20,   9.529639257102959D-19,  -3.527186531764391D-18, &
&   -2.309309997370690D-16,   7.605932589452102D-15,  -1.462268051065227D-13, &
&    2.092052856776595D-12,  -2.434356110650885D-11,   2.671218599834840D-10, &
&   -4.020939834310381D-09,   1.076766801967116D-07,  -4.104888659512695D-06, &
&    2.453387296342276D-04,                                                   &
&   -5.997628549534033D-19,   1.055208052505644D-17,  -6.793760770491892D-17, &
&   -1.607094650451453D-15,   6.486807707981173D-14,  -1.333942461445826D-12, &
&    2.030430247175967D-11,  -2.657982927052907D-10,   3.824301856813922D-09, &
&   -8.283334186711764D-08,   2.629381506125861D-06,  -1.032342820302316D-04, &
&    6.184820809786798D-03,                                                   &
&   -8.626304482953693D-19,   1.569545264381829D-17,  -1.137268620307308D-16, &
&   -2.090568535201582D-15,   9.507595224674403D-14,  -2.145069323394284D-12, &
&    3.894273215420844D-11,  -7.278172600317867D-10,   1.724799059104302D-08, &
&   -5.234147197889494D-07,   1.834286573963829D-05,  -7.309448707398812D-04, &
&    4.384344394061079D-02,                                                   &
&    1.570479087508197D-18,  -2.874591089356045D-17,   2.333395303430681D-16, &
&    2.410152239629351D-15,  -1.192661760640043D-13,   2.077955933375060D-12, &
&   -1.130273231528784D-11,  -6.203141228959478D-10,   3.327810048338963D-08, &
&   -1.262407969861577D-06,   4.633698394874050D-05,  -1.858395138841136D-03, &
&    1.115271606285265D-01,                                                   &
&   -1.000186004965905D-22,  -2.630348517166282D-21,   1.317614159222874D-19, &
&   -3.301346801249918D-18,   6.067822801673013D-17,  -8.885119450385220D-16, &
&    1.070262832652168D-14,  -1.101209825175226D-13,   1.123373110228977D-12, &
&   -1.747595425310713D-11,   5.146150615367177D-10,  -2.116060229755925D-08, &
&    1.350729295354879D-06,                                                   &
&   -1.778676166181092D-20,   4.142858799677704D-20,   5.428281713269627D-18, &
&   -1.785570566923262D-16,   3.663589229762871D-15,  -5.748754601716669D-14, &
&    7.405836146327325D-13,  -8.585932780363267D-12,   1.158392230031740D-10, &
&   -2.592497874685823D-09,   8.843085728305545D-08,  -3.715489389884771D-06, &
&    2.375311034744576D-04,                                                   &
&   -1.956428216723477D-19,   1.043029763092748D-18,   3.994775216674710D-17, &
&   -1.538958813463949D-15,   3.343290136500360D-14,  -5.508384884341887D-13, &
&    7.709093812022595D-12,  -1.086701191005334D-10,   2.076705626265094D-09, &
&   -6.026223721763297D-08,   2.206985772550034D-06,  -9.360627901350433D-05, &
&    5.988260932763992D-03,                                                   &
&   -2.922765153240833D-19,   1.855561149479654D-18,   5.158788092948057D-17, &
&   -2.205070227621099D-15,   5.161927094857479D-14,  -9.711903700473503D-13, &
&    1.795775288631987D-11,  -4.028466280723010D-10,   1.180284826349608D-08, &
&   -4.093559276294967D-07,   1.556616840133527D-05,  -6.633540659722872D-04, &
&    4.245099326297567D-02,                                                   &
&    5.277769350018243D-19,  -3.670858005817845D-18,  -7.257876467085532D-17, &
&    3.100052254767206D-15,  -6.079509105544105D-14,   6.253080467106094D-13, &
&    6.495975867058351D-12,  -6.287888252414296D-10,   2.685687472573766D-08, &
&   -1.021838740221564D-06,   3.951006850470559D-05,  -1.687182179466162D-03, &
&    1.079861311359279D-01,                                                   &
&    5.596750650154554D-23,  -2.591467918706445D-21,   6.719918305443213D-20, &
&   -1.318677270203488D-18,   2.107469888191430D-17,  -2.820294671213694D-16, &
&    3.240663752530217D-15,  -3.481892684419121D-14,   4.718359652257161D-13, &
&   -1.158606407420685D-11,   4.299771236159027D-10,  -1.928300321922409D-08, &
&    1.310341778681391D-06,                                                   &
&    2.698841648200372D-22,  -1.167925635164803D-19,   3.769900793691638D-18, &
&   -8.127761092857924D-17,   1.379490488623776D-15,  -1.950214709455463D-14, &
&    2.440819732892437D-13,  -3.203099982121997D-12,   6.177440685607055D-11, &
&   -1.917232493397698D-09,   7.511405015913630D-08,  -3.389736149130436D-06, &
&    2.304347277095194D-04,                                                   &
&   -8.617454751680946D-21,  -9.022409449764842D-19,   3.288695396248299D-17, &
&   -7.441893869689820D-16,   1.314487811472878D-14,  -1.976008160353467D-13, &
&    2.847682105136457D-12,  -5.022014651799802D-11,   1.330114020837669D-09, &
&   -4.701813554390567D-08,   1.888092991376476D-06,  -8.544245752773859D-05, &
&    5.809424400463486D-03,                                                   &
&   -1.942216142271434D-20,  -1.171282671681425D-18,   4.653772004808354D-17, &
&   -1.119749980150435D-15,   2.191830780234529D-14,  -4.094246089243084D-13, &
&    8.846926592276952D-12,  -2.498083958223902D-10,   8.629575307142196D-09, &
&   -3.286361447379094D-07,   1.336481365339243D-05,  -6.056531392331252D-04, &
&    4.118345194882036D-02,                                                   &
&    3.800782145161246D-20,   1.827769647186235D-18,  -7.028958396325191D-17, &
&    1.482267313790613D-15,  -1.975004573321393D-14,   2.065919765538201D-14, &
&    1.025249899499491D-11,  -5.199451377233546D-10,   2.107716928722154D-08, &
&   -8.308392613989739D-07,   3.397518162584077D-05,  -1.540593381591815D-03, &
&    1.047620424115716D-01,                                                   &
&    4.672555534026524D-23,  -1.238725880670995D-21,   2.560270638883704D-20, &
&   -4.414027396773780D-19,   6.478319650740785D-18,  -8.241436931840935D-17, &
&    9.573830348772540D-16,  -1.236728773527779D-14,   2.582060211568312D-13, &
&   -8.811957898817687D-12,   3.696199181031762D-10,  -1.768929954014402D-08, &
&    1.273409603481003D-06,                                                   &
&    2.289253824590284D-21,  -7.178207550837192D-20,   1.610305173002399D-18, &
&   -2.926258725833424D-17,   4.498594869035809D-16,  -6.106892785028982D-15, &
&    8.192762972817218D-14,  -1.431115890557188D-12,   4.019086265742423D-11, &
&   -1.520941184998814D-09,   6.488460489262589D-08,  -3.110526835283672D-06, &
&    2.239412730833881D-04,                                                   &
&    1.846442797102496D-20,  -6.334616303178251D-19,   1.481760325293813D-17, &
&   -2.784402083347493D-16,   4.489578620289268D-15,  -6.764641122952095D-14, &
&    1.150460503102151D-12,  -2.801958234109829D-11,   9.555703418288568D-10, &
&   -3.802103519796552D-08,   1.634460438329176D-06,  -7.841528701820239D-05, &
&    5.645735547043424D-03,                                                   &
&    2.426218359863351D-20,  -8.907947209186437D-19,   2.193984298899675D-17, &
&   -4.473885031270328D-16,   8.562317177484111D-15,  -1.816529851759688D-13, &
&    4.955886315634430D-12,  -1.701353934295372D-10,   6.568276172889653D-09, &
&   -2.683717259816042D-07,   1.158200466966292D-05,  -5.558798213414237D-04, &
&    4.002310643402594D-02,                                                   &
&   -4.002570073988808D-20,   1.408101590098938D-18,  -3.127521961734450D-17, &
&    4.857927233149410D-16,  -3.226359148703439D-15,  -1.393352784781222D-13, &
&    9.117790253424610D-12,  -4.015500449257033D-10,   1.648164457266584D-08, &
&   -6.813961663896444D-07,   2.945684767398359D-05,  -1.414027891831376D-03, &
&    1.018104309117034D-01,                                                   &
&    2.065297066223127D-23,  -4.502432699854891D-22,   8.256118421653506D-21, &
&   -1.315259723701434D-19,   1.835264592180161D-18,  -2.320529306411712D-17, &
&    3.028104665827182D-16,  -5.614779656974544D-15,   1.746735075640377D-13, &
&   -7.124389833509488D-12,   3.221399599589731D-10,  -1.630913752189318D-08, &
&    1.239442776132862D-06,                                                   &
&    1.235273952868528D-21,  -2.884408635786613D-20,   5.544961908829647D-19, &
&   -9.194660174914384D-18,   1.351184002573039D-16,  -1.901107019399956D-15, &
&    3.163014008449888D-14,  -8.073320825285892D-13,   2.949018043643433D-11, &
&   -1.246299571286432D-09,   5.662529600204996D-08,  -2.868054696655574D-06, &
&    2.179681921243841D-04,                                                   &
&    1.103353210672396D-20,  -2.668429265530998D-19,   5.281297487548116D-18, &
&   -9.101079443239047D-17,   1.448420157046974D-15,  -2.457544970847485D-14, &
&    5.606193421331159D-13,  -1.834376266797021D-11,   7.295415085022743D-10, &
&   -3.134431273839126D-08,   1.427263917260617D-06,  -7.230516639510179D-05, &
&    5.495153104969040D-03,                                                   &
&    1.548953397799964D-20,  -3.911232817159886D-19,   8.278430360855178D-18, &
&   -1.637383394720269D-16,   3.469367398908424D-15,  -9.211780487301584D-14, &
&    3.133043224194865D-12,  -1.228366048141783D-10,   5.121458805066217D-09, &
&   -2.219264755962277D-07,   1.011688296376058D-05,  -5.125748113789353D-04, &
&    3.895562778020884D-02,                                                   &
&   -2.521723615542652D-20,   5.856988950980368D-19,  -1.008774580395454D-17, &
&    1.026858880249250D-16,   1.438820685560538D-15,  -1.445881427318301D-13, &
&    7.045591981617788D-12,  -3.045213674353489D-10,   1.297217695222140D-08, &
&   -5.642277883334518D-07,   2.573399691171103D-05,  -1.303880280645637D-03, &
&    9.909500277121435D-02,                                                   &
&    7.145548886686809D-24,  -1.402348163649075D-22,   2.387578048985352D-21, &
&   -3.622789486287231D-20,   4.979821210026312D-19,  -6.773411235344743D-18, &
&    1.172836177008759D-16,  -3.318069510915545D-15,   1.318164267370018D-13, &
&   -5.913446542964415D-12,   2.831964498100459D-10,  -1.510088063258732D-08, &
&    1.208058697733109D-06,                                                   &
&    4.663026972593694D-22,  -9.533600090283693D-21,   1.682375713883633D-19, &
&   -2.664590991410365D-18,   3.976830198777554D-17,  -6.554074775284688D-16, &
&    1.547222656888907D-14,  -5.417321560742252D-13,   2.290299900598770D-11, &
&   -1.038475075886756D-09,   4.979719544681660D-08,  -2.655624667284241D-06, &
&    2.124490613381548D-04,                                                   &
&    4.340838264644036D-21,  -9.098684400444501D-20,   1.658488454173834D-18, &
&   -2.797669503964809D-17,   4.844268910782732D-16,  -1.059509741693109D-14, &
&    3.320237555845463D-13,  -1.317951462174849D-11,   5.741762197892976D-10, &
&   -2.616361700435422D-08,   1.255359800196118D-06,  -6.695026672475826D-05, &
&    5.356012192072786D-03,                                                   &
&    6.327220965195443D-21,  -1.402020621415699D-19,   2.863527942778226D-18, &
&   -6.141275550504779D-17,   1.602996131878338D-15,  -5.395125182349911D-14, &
&    2.144805279385408D-12,  -9.169714299242928D-11,   4.058604461448731D-09, &
&   -1.854131192502316D-07,   8.899107768291826D-06,  -4.746157739884195D-04, &
&    3.796924847960652D-02,                                                   &
&   -9.792582111082882D-21,   1.845685785938882D-19,  -2.338064139721338D-18, &
&   -7.049859192449593D-18,   2.071192314141514D-15,  -1.139437524014208D-13, &
&    5.224910545519084D-12,  -2.313344706656809D-10,   1.031112577025855D-08, &
&   -4.715819045684253D-07,   2.263719744819702D-05,  -1.207322988863258D-03, &
&    9.658586261823302D-02,                                                   &
&    2.148674114064140D-24,  -3.946297385437727D-23,   6.408093665831466D-22, &
&   -9.535419645432742D-21,   1.372209600327443D-19,  -2.315349445601201D-18, &
&    6.020768485803269D-17,  -2.313808962149356D-15,   1.042148638088696D-13, &
&   -4.975936514354084D-12,   2.506382650288306D-10,  -1.403508359052389D-08, &
&    1.178944424329710D-06,                                                   &
&    1.479179443455318D-22,  -2.802769722016571D-21,   4.723093256693972D-20, &
&   -7.505335983161318D-19,   1.257943925719906D-17,  -2.814187949423845D-16, &
&    9.408852654470072D-15,  -3.975574687361805D-13,   1.826620698192192D-11, &
&   -8.747526712546192D-10,   4.407601198167722D-08,  -2.468205316618437D-06, &
&    2.073290430126230D-04,                                                   &
&    1.416282219068961D-21,  -2.757747802674461D-20,   4.894337750870696D-19, &
&   -8.767707926699332D-18,   1.880351081236794D-16,  -5.665616734675582D-15, &
&    2.236044968545158D-13,  -9.913510145995656D-12,   4.597845852720050D-10, &
&   -2.204945750277123D-08,   1.111177288070503D-06,  -6.222541220904108D-05, &
&    5.226932573967634D-03,                                                   &
&    2.158542905097040D-21,  -4.619867768097393D-20,   1.005962909971088D-18, &
&   -2.608908023494338D-17,   8.701157909421631D-16,  -3.499807629891567D-14, &
&    1.535638121213229D-12,  -6.987751742190042D-11,   3.256796047273494D-09, &
&   -1.562966319864070D-07,   7.877180905478497D-06,  -4.411213716292703D-04, &
&    3.705419219185503D-02,                                                   &
&   -2.992000067302738D-21,   4.450317409896722D-20,  -1.325983376339764D-19, &
&   -2.674962381410849D-17,   1.702609568772762D-15,  -8.330434815079329D-14, &
&    3.851291696213603D-12,  -1.773074375920150D-10,   8.281637979367095D-09, &
&   -3.975704555234660D-07,   2.003784734667318D-05,  -1.122120778427737D-03, &
&    9.425815067070604D-02,                                                   &
&    5.883865760973232D-25,  -1.034830550065449D-23,   1.643024448611432D-22, &
&   -2.516022548677303D-21,   4.265290673923460D-20,  -1.039934508672586D-18, &
&    3.843470672892410D-17,  -1.739358245480434D-15,   8.416337317782171D-14, &
&   -4.226230289547105D-12,   2.231118002554055D-10,  -1.308908135362545D-08, &
&    1.151838599700354D-06,                                                   &
&    4.215349635139836D-23,  -7.652516115140306D-22,   1.283327674737906D-20, &
&   -2.222617853320191D-19,   4.828977295499082D-18,  -1.544867109941179D-16, &
&    6.498480323683677D-15,  -3.038563912507900D-13,   1.478796263213369D-11, &
&   -7.431583621268579D-10,   3.923616889395191D-08,  -2.301843894930927D-06, &
&    2.025622185124397D-04,                                                   &
&    4.148302026572298D-22,  -7.860752905256867D-21,   1.455855353567351D-19, &
&   -3.118764158929867D-18,   9.111398664844803D-17,  -3.564670715954901D-15, &
&    1.607645289199156D-13,  -7.636342919404850D-12,   3.726602071894617D-10, &
&   -1.873482092659704D-08,   9.891724515831903D-07,  -5.803133595243247D-05, &
&    5.106757115992439D-03,                                                   &
&    6.807351482098029D-22,  -1.534915092768582D-20,   3.968512972442020D-19, &
&   -1.316110006075940D-17,   5.347555385663476D-16,  -2.406415083313086D-14, &
&    1.128396381597025D-12,  -5.404553747978075D-11,   2.641240858929954D-09, &
&   -1.328098284076340D-07,   7.012320501197945D-06,  -4.113893003201228D-04, &
&    3.620225776583013D-02,                                                   &
&   -7.286444998931725D-22,   5.179074072858045D-21,   3.101112851785228D-19, &
&   -2.358379762850473D-17,   1.236910198344813D-15,  -5.987075533460178D-14, &
&    2.857805540656282D-12,  -1.373806854291560D-10,   6.718114707236908D-09, &
&   -3.378371861555395D-07,   1.783787058686413D-05,  -1.046488702877743D-03, &
&    9.209100700820457D-02,                                                   &
&    1.508157366737129D-25,  -2.593818942636482D-24,   4.189426010647914D-23, &
&   -7.276883859680871D-22,   1.702026463763279D-20,  -6.041744043332916D-19, &
&    2.739129743320921D-17,  -1.350387855754393D-15,   6.882415722520261D-14, &
&   -3.616865388248674D-12,   1.996437827873395D-10,  -1.224478788460521D-08, &
&    1.126520367642805D-06,                                                   &
&    1.120801334946805D-23,  -2.017605942633137D-22,   3.609494781459325D-21, &
&   -7.775823898757250D-20,   2.397603907566601D-18,  -1.000477993009239D-16, &
&    4.761132950248806D-15,  -2.370515224877419D-13,   1.210070859280398D-11, &
&   -6.360480445690409D-10,   3.510928489159035D-08,  -2.153367030418681D-06, &
&    1.981097574125169D-04,                                                   &
&    1.145742553132586D-22,  -2.239971211344596D-21,   4.820275311055770D-20, &
&   -1.379951988818255D-18,   5.347018525972261D-17,  -2.448785581162486D-15, &
&    1.193625168445271D-13,  -5.971089955488957D-12,   3.050356875175166D-10, &
&   -1.603511841937584D-08,   8.851328019780724D-07,  -5.428812042142361D-05, &
&    4.994506983381350D-03,                                                   &
&    2.156471140627272D-22,  -5.671368637591637D-21,   1.869224502998896D-19, &
&   -7.667859233824407D-18,   3.534733605149129D-16,  -1.708852196163346D-14, &
&    8.436887228801840D-13,  -4.231032304424523D-11,   2.162301930322023D-09, &
&   -1.136737624918633D-07,   6.274783214208992D-06,  -3.848533338012280D-04, &
&    3.540650656823165D-02,                                                   &
&   -1.065898258128817D-22,  -3.162508553216586D-21,   3.039560582043570D-19, &
&   -1.715339313420005D-17,   8.706183052504083D-16,  -4.316621952871037D-14, &
&    2.143382643521473D-12,  -1.076069822659885D-10,   5.500306927298488D-09, &
&   -2.891616799877759D-07,   1.596173951979383D-05,  -9.789867544579020D-04, &
&    9.006678165650167D-02,                                                   &
&    3.700982948427079D-26,  -6.430968223927754D-25,   1.146404603071239D-23, &
&   -2.627285699067172D-22,   8.990570312405084D-21,  -4.069224291665787D-19, &
&    2.046025082485624D-17,  -1.066010143406575D-15,   5.681118720320108D-14, &
&   -3.116216236839997D-12,   1.794925346752548D-10,  -1.148751579171216D-08, &
&    1.102801491735474D-06,                                                   &
&    2.877161953575669D-24,  -5.442909679222468D-23,   1.170784950501997D-21, &
&   -3.514979566375302D-20,   1.452475989868979D-18,  -7.024519235830426D-17, &
&    3.586462400969271D-15,  -1.873804216942253D-13,   9.990261039625484D-12, &
&   -5.480147556536943D-10,   3.156552892319990D-08,  -2.020193337225404D-06, &
&    1.939385584250618D-04,                                                   &
&    3.149335997136019D-23,  -6.984451779342394D-22,   1.966755997922266D-20, &
&   -7.557467621328087D-19,   3.508379935655384D-17,  -1.755076573405960D-15, &
&    9.027560969069459D-14,  -4.722932206287352D-12,   2.518557681528261D-10, &
&   -1.381586077695899D-08,   7.957923521452019D-07,  -5.093070530739410D-05, &
&    4.889347689633966D-03,                                                   &
&    7.538803401746495D-23,  -2.504566401455255D-21,   1.034019497123613D-19, &
&   -4.877609213871449D-18,   2.430338301371677D-16,  -1.238289351994087D-14, &
&    6.394411873078047D-13,  -3.347723702148938D-11,   1.785402508432999D-09, &
&   -9.794174449146046D-08,   5.641442661646994D-06,  -3.610523225806025D-04, &
&    3.466102293818214D-02,                                                   &
&    2.822796462707620D-23,  -3.654343304564108D-21,   2.228927116212940D-19, &
&   -1.187116490563538D-17,   6.118627961513667D-16,  -3.143320267020172D-14, &
&    1.626007535250852D-12,  -8.515454823339351D-11,   4.541663392147878D-09, &
&   -2.491432632638106D-07,   1.435065513618728D-05,  -9.184419422309765D-04, &
&    8.817042650557816D-02,                                                   &
&    8.959070430623629D-27,  -1.683566020825479D-25,   3.811220977633892D-24, &
&   -1.266474163744095D-22,   5.708687691540760D-21,  -2.925155698619792D-19, &
&    1.562462678261493D-17,  -8.510937434850492D-16,   4.727390382284152D-14, &
&   -2.701306529930542D-12,   1.620780769606959D-10,  -1.080520381595395D-08, &
&    1.080520376687074D-06,                                                   &
&    7.502972667642918D-25,  -1.657686816541849D-23,   4.863892941015588D-22, &
&   -1.991162961144370D-20,   9.769165215170316D-19,  -5.116946172264630D-17, &
&    2.745363113256144D-15,  -1.496555300128683D-13,   8.313474730266649D-12, &
&   -4.750509576718404D-10,   2.850303221970444D-08,  -1.900202042138182D-06, &
&    1.900202038171588D-04,                                                   &
&    9.356061893331007D-24,  -2.649700014947675D-22,   1.007792058951583D-20, &
&   -4.736429991089547D-19,   2.430135733569676D-17,  -1.286693071513912D-15, &
&    6.918344997954452D-14,  -3.772716550411175D-12,   2.095880464019773D-10, &
&   -1.197641158214873D-08,   7.185844376740804D-07,  -4.790562809721152D-05, &
&    4.790562805661605D-03,                                                   &
&    3.146818648464301D-23,  -1.316992665235558D-21,   6.337661628132789D-20, &
&   -3.252460261306017D-18,   1.710526812393393D-16,  -9.109001932192207D-15, &
&    4.903371438484285D-13,  -2.674429311827991D-11,   1.485783223502566D-09, &
&   -8.490182695015965D-08,   5.094109234685550D-06,  -3.396072807033006D-04, &
&    3.396072806427918D-02,                                                   &
&    4.126707836278517D-23,  -2.723498201940325D-21,   1.521852971463318D-19, &
&   -8.155440537901508D-18,   4.337474358184881D-16,  -2.315732832965575D-14, &
&    1.247190704181203D-12,  -6.803097202114706D-11,   3.779517332216681D-09, &
&   -2.159725435323649D-07,   1.295835327707621D-05,  -8.638902212690340D-04, &
&    8.638902213741539D-02,                                                   &
&    2.265709600036756D-27,  -5.221368879313131D-26,   1.688404173299294D-24, &
&   -7.573233256399440D-23,   3.949267812172228D-21,  -2.164546066367297D-19, &
&    1.209444916608945D-17,  -6.858407967588285D-16,   3.962446786550988D-14, &
&   -2.354813316047240D-12,   1.469402869994565D-10,  -1.018785963459438D-08, &
&    1.059537401022165D-06,                                                   &
&    2.174157302708231D-25,  -6.379436493502892D-24,   2.580768903256641D-22, &
&   -1.282733757419090D-20,   6.889804063203130D-19,  -3.801060308280822D-17, &
&    2.126452605146454D-15,  -1.206083904723953D-13,   6.968333554242433D-12, &
&   -4.141171273918798D-10,   2.584090359013349D-08,  -1.791635960859853D-06, &
&    1.863301398501125D-04,                                                   &
&    3.341031859818429D-24,  -1.273130038704173D-22,   6.036954066853022D-21, &
&   -3.174009086411977D-19,   1.730166029072407D-17,  -9.575954338616264D-16, &
&    5.360364692232110D-14,  -3.040590929566062D-12,   1.756770469796117D-10, &
&   -1.044022592275159D-08,   6.514700448157757D-07,  -4.516858955471410D-05, &
&    4.697533312876067D-03,                                                   &
&    1.580059622383582D-23,  -7.783613037957990D-22,   4.104850809502370D-20, &
&   -2.227684631437469D-18,   1.223971626194430D-16,  -6.785904792625465D-15, &
&    3.799785537597824D-13,  -2.155485379944216D-11,   1.245389265423061D-09, &
&   -7.401169002253061D-08,   4.618329378798549D-06,  -3.202041699363843D-04, &
&    3.330123367216773D-02,                                                   &
&    3.137703427803871D-23,  -1.840745692604527D-21,   1.024535357432780D-19, &
&   -5.641523410561582D-18,   3.110639426375819D-16,  -1.725901527658441D-14, &
&    9.665608355381343D-13,  -5.483087085457034D-11,   3.168009852210903D-09, &
&   -1.882703256877877D-07,   1.174806845951228D-05,  -8.145327470939994D-04, &
&    8.471140569988666D-02,                                                   &
&    6.658312385744091D-28,  -2.138639756073767D-26,   9.513545872835355D-25, &
&   -5.042354859332362D-23,   2.835573003977058D-21,  -1.627781366990872D-19, &
&    9.460528504363983D-18,  -5.572607211467896D-16,   3.343525813416064D-14, &
&   -2.063430613790240D-12,   1.337102910247465D-10,  -9.627140901640919D-09, &
&    1.039731217186339D-06,                                                   &
&    7.852958645394832D-26,  -3.174625373977461D-24,   1.593031355434313D-22, &
&   -8.767733048974387D-21,   4.975527308668675D-19,  -2.861522611803146D-17, &
&    1.663634240187771D-15,  -9.799913403916419D-14,   5.879916999752899D-12, &
&   -3.628746786870471D-10,   2.351427814369807D-08,  -1.693028022098157D-06, &
&    1.828470263710003D-04,                                                   &
&    1.516379784710876D-24,  -7.290833418788256D-23,   3.918034758872415D-21, &
&   -2.198086704947867D-19,   1.252987356076048D-17,  -7.212760448418752D-16, &
&    4.194038506990134D-14,  -2.470628688156596D-12,   1.482374040334863D-10, &
&   -9.148363468097228D-09,   5.928139421117104D-07,  -4.268260378838242D-05, &
&    4.609721208984695D-03,                                                   &
&    9.027622105032535D-24,  -4.902379059086161D-22,   2.740714050704955D-20, &
&   -1.553598409199198D-18,   8.877308497448887D-17,  -5.112670789066860D-15, &
&    2.973146556462078D-13,  -1.751447472074906D-11,   1.050868010841584D-09, &
&   -6.485356563017774D-08,   4.202511036976988D-06,  -3.025807945970700D-04, &
&    3.267872581624317D-02,                                                   &
&    2.103004363868607D-23,  -1.217095857585318D-21,   6.930258518923285D-20, &
&   -3.946778182140980D-18,   2.257609795335097D-16,  -1.300498036037151D-14, &
&    7.563014898270313D-13,  -4.455313994197682D-11,   2.673189217605634D-09, &
&   -1.649739684220058D-07,   1.069031318127347D-05,  -7.697025491649238D-04, &
&    8.312787531022856D-02,                                                   &
&    2.548268959588700D-28,  -1.135666197531145D-26,   6.098449922598172D-25, &
&   -3.516959025182029D-23,   2.075376067171928D-21,  -1.238549374305105D-19, &
&    7.468249626343080D-18,  -4.562319588848661D-16,   2.838768924974085D-14, &
&   -1.816811624708907D-12,   1.220897386788617D-10,  -9.116033811215850D-09, &
&    1.020995786819372D-06,                                                   &
&    3.690371165184020D-26,  -1.877431652259456D-24,   1.056351811072586D-22, &
&   -6.165071592615566D-21,   3.647568548337010D-19,  -2.177899050899319D-17, &
&    1.313347625545652D-15,  -8.023277613491772D-14,   4.992255374321555D-12, &
&   -3.195043042984062D-10,   2.147068904459608D-08,  -1.603144781166113D-06, &
&    1.795522154875818D-04,                                                   &
&    8.329081362887164D-25,  -4.585570021721302D-23,   2.643123363160399D-21, &
&   -1.551781013451793D-19,   9.193062417193689D-18,  -5.490390008890014D-16, &
&    3.311032503693212D-14,  -2.022731421706483D-12,   1.258587799153852D-10, &
&   -8.054961507221806D-09,   5.412934111836299D-07,  -4.041657469315303D-05, &
&    4.526656365601939D-03,                                                   &
&    5.539400468739027D-24,  -3.195235200208019D-22,   1.866170754981556D-20, &
&   -1.099130105547074D-18,   6.515997250421356D-17,  -3.892083780829052D-15, &
&    2.347211771165034D-13,  -1.433931752113466D-11,   8.922241056452707D-10, &
&   -5.710234215253732D-08,   3.837277389505952D-06,  -2.865167117369584D-04, &
&    3.208987171449255D-02,                                                   &
&    1.367942185417394D-23,  -8.065281174554613D-22,   4.738586291304663D-20, &
&   -2.794890336345908D-18,   1.657415085651592D-16,  -9.900533882035544D-15, &
&    5.970808092447502D-13,  -3.647623127885581D-11,   2.269632334562768D-09, &
&   -1.452564704682855D-07,   9.761234820921773D-06,  -7.288388666510436D-04, &
&    8.162995306499793D-02,                                                   &
&    1.287940197564884D-28,  -7.007820652129321D-27,   4.136423025283799D-25, &
&   -2.509173751288629D-23,   1.538877547893086D-21,  -9.518202751777668D-20, &
&    5.944983707951951D-18,  -3.761533053819366D-16,   2.424097562058252D-14, &
&   -1.606830288973956D-12,   1.118353876290182D-10,  -8.648603308033558D-09, &
&    1.003237983724892D-06,                                                   &
&    2.096653308866177D-26,  -1.208469307006623D-24,   7.242504552598626D-23, &
&   -4.408753568536671D-21,   2.705845879931125D-19,  -1.673829446150794D-17, &
&    1.045480815380554D-15,  -6.615025767379437D-14,   4.263015368176788D-12, &
&   -2.825770109157076D-10,   1.966735992004918D-08,  -1.520942500323838D-06, &
&    1.764293300369876D-04,                                                   &
&    5.086166097493145D-25,  -3.016785977173522D-23,   1.821893853658030D-21, &
&   -1.110992068329947D-19,   6.821118377776626D-18,  -4.219807127770545D-16, &
&    2.635737180153372D-14,  -1.667701105545015D-12,   1.074740585203514D-10, &
&   -7.123994656118783D-09,   4.958300276564516D-07,  -3.834418880377948D-05, &
&    4.447925901232443D-03,                                                   &
&    3.530204544039178D-24,  -2.127320971254500D-22,   1.290037106620831D-20, &
&   -7.874053136997337D-19,   4.835346252107789D-17,  -2.991439029545475D-15, &
&    1.868495964983676D-13,  -1.182248103270449D-11,   7.618932030744393D-10, &
&   -5.050263505529748D-08,   3.514983399234961D-06,  -2.718253828716901D-04, &
&    3.153174441310707D-02,                                                   &
&    8.894739670380158D-24,  -5.398644876107863D-22,   3.279859864577920D-20, &
&   -2.002782580052535D-18,   1.229988002464883D-16,  -7.609575332913652D-15, &
&    4.753062815606866D-13,  -3.007392911069276D-11,   1.938097686811915D-09, &
&   -1.284681897336981D-07,   8.941386006528716D-06,  -6.914671845091823D-04, &
&    8.021019340308069D-02,                                                   &
&    7.648410793512245D-29,  -4.625555608873802D-27,   2.880757643543596D-25, &
&   -1.816116429457849D-23,   1.153354900778700D-21,  -7.381008719512530D-20, &
&    4.769221335616660D-18,  -3.121668182079020D-16,   2.081111827347860D-14, &
&   -1.427048091919784D-12,   1.027474625260275D-10,  -8.219797001714380D-09, &
&    9.863756402044103D-07,                                                   &
&    1.312371392365912D-26,  -8.087710422343180D-25,   5.059926972408885D-23, &
&   -3.193075905774415D-21,   2.028208328773737D-19,  -1.298015760208977D-17, &
&    8.387141407627658D-16,  -5.489762043837469D-14,   3.659841121466888D-12, &
&   -2.509605325418632D-10,   1.806915833541282D-08,  -1.445532666802623D-06, &
&    1.734639200162058D-04,                                                   &
&    3.268225948427093D-25,  -2.033054729988758D-23,   1.274864709754773D-21, &
&   -8.049051345661796D-20,   5.113173742175736D-18,  -3.272392649583005D-16, &
&    2.114465257681484D-14,  -1.384013289516613D-12,   9.226755014831360D-11, &
&   -6.326917708948114D-09,   4.555380749656484D-07,  -3.644304599693701D-05, &
&    4.373165519631312D-03,                                                   &
&    2.301626717732060D-24,  -1.438996620880490D-22,   9.034635810159032D-21, &
&   -5.705680160447744D-19,   3.624734913908728D-17,  -2.319824589659143D-15, &
&    1.498963007029584D-13,  -9.811393728345806D-12,   6.540929114974610D-10, &
&   -4.485208533656159D-08,   3.229350144114375D-06,  -2.583480115286767D-04, &
&    3.100176138343950D-02,                                                   &
&    5.837605635004679D-24,  -3.657945543699040D-22,   2.297882274527769D-20, &
&   -1.451364699588710D-18,   9.220525702806020D-17,  -5.901146439780310D-15, &
&    3.813049464254274D-13,  -2.495814281383154D-11,   1.663876194044528D-09, &
&   -1.140943676319166D-07,   8.214794469702363D-06,  -6.571835575770080D-04, &
&    7.886202690924390D-02/
end

!------------------
  module rysgrid6
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t6(15,6,0:22)
      real(8) :: w6(15,6,0:22)
      data t6 / &
&   -1.296426476681302D-20,   7.507527760717266D-20,   1.184795163227746D-18, &
&    5.876217514536827D-17,   1.440145199680553D-15,   2.693433942201051D-14, &
&    3.164224814476482D-13,  -1.790679808259588D-12,  -2.565167944034667D-10, &
&   -1.011578820969039D-08,  -2.968682803501680D-07,  -7.336234308345723D-06, &
&   -1.567197462928340D-04,  -2.816291451451630D-03,   9.634612787028218D-01, &
&   -1.098263831509212D-19,   7.156439863140024D-19,   1.206660818492059D-17, &
&    3.043177710965133D-16,   5.073658006335879D-16,  -1.083845262979066D-13, &
&   -2.682139966405511D-12,  -1.571211122629306D-11,   8.257371977543871D-10, &
&    2.771500603811914D-08,   2.916985492486521D-07,  -7.849539887113172D-06, &
&   -4.551632416797058D-04,  -1.193915651147557D-02,   8.174280132668750D-01, &
&   -1.961902946709126D-19,   2.081125008091244D-18,   2.637168721410707D-17, &
&   -1.475304785450393D-16,  -1.230443997158989D-14,  -1.546375871380050D-14, &
&    4.511667778381224D-12,   3.397664666139826D-11,  -1.622220119395737D-09, &
&   -2.546923625883676D-08,   5.792893544644550D-07,   1.771464783137503D-05, &
&   -2.155625111696482D-04,  -1.931179310446262D-02,   5.927501277315417D-01, &
&   -1.338975447167183D-19,   2.216591185437368D-18,   2.482081890738010D-18, &
&   -5.824477550783849D-16,   3.694300183688969D-15,   1.810586373485631D-13, &
&   -3.283787608864083D-12,  -3.707752688329716D-11,   1.753211486691324D-09, &
&   -3.419522262549767D-09,  -7.908319917941347D-07,   1.185662226812707D-05, &
&    3.357670295332793D-04,  -1.807657074418952D-02,   3.449423794274173D-01, &
&   -3.717248979981817D-20,   8.035281406734956D-19,  -8.243526199434106D-18, &
&   -6.037036747325861D-17,   4.624285830346124D-15,  -9.672660733757205D-14, &
&    6.039697171076040D-13,   2.666965301010490D-11,  -1.038344198534015D-09, &
&    1.719066428463594D-08,   2.693676187066721D-08,  -1.124945546333966D-05, &
&    4.093083012464652D-04,  -9.359513480107034D-03,   1.353000116552482D-01, &
&   -2.892253161806586D-21,   6.512981305851508D-20,  -1.033292950004163D-18, &
&    1.264733664857924D-17,  -1.812612449588062D-17,  -6.274785848813686D-15, &
&    2.927642373354146D-13,  -9.718101118367696D-12,   2.757478310505001D-10, &
&   -7.065156000369335D-09,   1.665512919877961D-07,  -3.623636690763030D-06, &
&    7.173565352544819D-05,  -1.234994989166992D-03,   1.568340660740046D-02, &
&   -4.977677665481714D-20,  -5.186458452330377D-19,  -5.526751036078612D-18, &
&    3.937571520289590D-17,   3.707647773225157D-15,   1.047861534820783D-13, &
&    1.933009950800456D-12,   2.099611301010027D-11,  -1.213683288008044D-10, &
&   -1.420803804683545D-08,  -4.820412381826029D-07,  -1.194626788964130D-05, &
&   -2.418197375139187D-04,  -3.991222612406352D-03,   9.533771556236357D-01, &
&   -3.178195629385894D-20,  -2.153051231519490D-18,  -2.750798120573113D-17, &
&    3.584126034013871D-16,   1.554913591331922D-14,   1.225800280438012D-13, &
&   -3.562045420580724D-12,  -1.029828928929201D-10,  -3.743998787119930D-10, &
&    3.460342511763461D-08,   7.858641751388367D-07,  -1.496068134664758D-06, &
&   -5.017139858504234D-04,  -1.483827477283551D-02,   7.773330472694119D-01, &
&    7.418569862658768D-21,  -2.065020203610923D-18,  -2.479942993589353D-18, &
&    7.590087279927854D-16,   1.169802642864331D-15,  -2.649494598844799D-13, &
&   -2.318668275561407D-13,   9.973197789069249D-11,  -1.082489774833908D-11, &
&   -4.233119046425803D-08,   3.358015545779223D-08,   2.165140959697607D-05, &
&   -3.343615966359759D-05,  -2.007674071313680D-02,   5.333926349912138D-01, &
&   -3.015830775915435D-20,  -6.666320768173071D-19,   1.468424723093141D-17, &
&    4.520402173546939D-17,  -6.023790631531897D-15,   8.923998207485573D-14, &
&    1.030889472906774D-12,  -5.851678659306181D-11,   5.626317500925738D-10, &
&    1.806139709913072D-08,  -6.533782327134986D-07,   2.867280988264994D-06, &
&    4.007370972396626D-04,  -1.582631394701591D-02,   2.939909900672940D-01, &
&   -1.396774171381088D-20,  -8.629531389774500D-21,   2.619313710067863D-18, &
&   -7.386595014817396D-17,   1.428983061118762D-15,  -6.208810607077529D-15, &
&   -5.572311290588392D-13,   2.235187732840760D-11,  -4.768115266544757D-10, &
&    3.720973731658494D-09,   1.709327673101908D-07,  -9.860732506973462D-06, &
&    3.130397635051940D-04,  -7.198899677788283D-03,   1.106071735292422D-01, &
&   -1.057422462114533D-21,   4.530573176645353D-21,  -4.462179699728381D-20, &
&   -3.220491908267716D-19,   9.501720180680529D-17,  -4.152602049049915D-15, &
&    1.455352824420963D-13,  -4.583115616477626D-12,   1.318187573755164D-10, &
&   -3.557997342995231D-09,   9.008790224444293D-08,  -2.135927145092299D-06, &
&    4.650003005244322D-05,  -8.869359039228283D-04,   1.253815971743314D-02, &
&    2.831688852102902D-20,  -1.662067589648246D-18,  -5.201733476819393D-17, &
&   -8.374726197236457D-16,  -4.848908686723060D-15,   1.572115142440820D-13, &
&    5.985230591731348D-12,   1.124462263145696D-10,   1.105479554171210D-09, &
&   -8.207260383078707D-09,  -6.769680460675664D-07,  -1.898179943171089D-05, &
&   -3.791940516635162D-04,  -5.822534044909938D-03,   9.388620354301521D-01, &
&    4.435799545550907D-19,   3.511044892419581D-18,  -4.327466531568210D-17, &
&   -1.588271892452755D-15,  -2.504788669072766D-15,   4.905745131127514D-13, &
&    5.899295676854992D-12,  -9.672451176577912D-11,  -2.878510510612065D-09, &
&    5.272620306545393D-09,   1.143128085641718D-06,   1.051782429183200D-05, &
&   -4.644376427351310D-04,  -1.779118806993261D-02,   7.283339487136755D-01, &
&    1.378677635759113D-19,   1.025317145179678D-18,  -3.313421655473415D-17, &
&   -2.824846218066929D-16,   1.221132383200988D-14,   2.875960833124315D-14, &
&   -4.209630453562603D-12,   2.953562069291204D-11,   1.520340774377924D-09, &
&   -2.642504839507077D-08,  -5.173384835663966D-07,   1.850316339132286D-05, &
&    1.522817503587703D-04,  -1.970581293551505D-02,   4.734387126724406D-01, &
&    4.333860099123344D-20,  -1.352180265036644D-19,  -6.467339394279446D-18, &
&    1.197320676276578D-16,  -1.138608171185438D-15,  -2.304435501031226D-14, &
&    1.565096915058376D-12,  -2.125544612194876D-11,  -2.942860674443896D-10, &
&    1.926417099475762D-08,  -3.540750769564876D-07,  -3.191793753500256D-06, &
&    3.965481512616972D-04,  -1.340718087846388D-02,   2.501478543321836D-01, &
&    5.783640900659876D-21,  -3.818569517539342D-20,   1.944476818583615D-19, &
&   -2.206358208698721D-17,   1.059847666942705D-16,   1.252557732179097D-14, &
&   -3.862948273010122D-13,   1.006431761446585D-11,  -1.443268871892917D-10, &
&   -1.476258188673889D-09,   1.803240608807736D-07,  -7.676419668142905D-06, &
&    2.340514274203919D-04,  -5.567524148167456D-03,   9.157603992287677D-02, &
&    3.512620737566245D-22,   2.263018087540119D-22,  -6.114392400124925D-20, &
&   -1.866813249236405D-18,   6.199736896811765D-17,  -1.675979841797699D-15, &
&    6.902650760526657D-14,  -2.143394290619960D-12,   6.438569633254257D-11, &
&   -1.868154432834962D-09,   5.089466359493513D-08,  -1.315152502677697D-06, &
&    3.132021661668372D-05,  -6.571461284079172D-04,   1.024470172120134D-02, &
&    1.688985743788031D-18,   1.304925013455485D-17,   3.775270765524727D-17, &
&   -2.582268031709776D-15,  -6.832645612633379D-14,  -7.710163003334845D-13, &
&    2.066308691472650D-12,   2.572390320244049D-10,   5.114816880848745D-09, &
&    4.291637836730589D-08,  -5.073626128420372D-07,  -2.683968162986533D-05, &
&   -5.867535248270169D-04,  -8.684345445662004D-03,   9.174134431829452D-01, &
&   -8.027193879599509D-19,  -2.540661265972457D-20,   1.324701677143049D-16, &
&    3.938594836267040D-16,  -4.128603449020403D-14,  -3.362641487679095D-13, &
&    1.086921603897600D-11,   1.510130911015966D-10,  -2.542462371629657D-09, &
&   -5.161800122619839D-08,   7.890793402406233D-07,   2.298912072942388D-05, &
&   -3.104591986146096D-04,  -2.017279928233820D-02,   6.711560395424249D-01, &
&   -1.062263325789591D-19,   7.530446331546087D-19,   2.135834920994080D-17, &
&   -4.412428716201328D-16,  -5.408089329623538D-15,   1.429341302738709D-13, &
&   -6.238678368680824D-13,  -3.475805643389898D-11,   1.303965046207902D-09, &
&    1.058926147880636D-09,  -7.019676089960691D-07,   1.076881992476440D-05, &
&    2.856566406364797D-04,  -1.835681413994502D-02,   4.161442158518468D-01, &
&   -5.459121858430947D-21,   2.630217587421486D-19,   8.970505158937514D-21, &
&   -4.042843518727462D-17,  -5.286442318791711D-16,  -3.407814834551841D-14, &
&    7.625932632022096D-13,   7.118107425785450D-12,  -4.087959794674999D-10, &
&    1.204030832690769D-08,  -1.168681017775520D-07,  -5.906403786663978D-06, &
&    3.534671557296708D-04,  -1.114502019501379D-02,   2.133848164844261D-01, &
&    1.726532865233701D-22,   4.107483022611096D-20,   7.400817738114840D-19, &
&   -1.461525669805828D-17,  -5.609057001138103D-16,   5.251159136420467D-15, &
&   -1.004083114935625D-13,   4.620783888721563D-12,  -2.529436946661490D-12, &
&   -2.629004144900543D-09,   1.464006869026303D-07,  -5.699283640875717D-06, &
&    1.741716699896672D-04,  -4.351766883275824D-03,   7.678682902314676D-02, &
&   -4.693951981179717D-23,   4.934029635712911D-21,   7.522027572510018D-20, &
&   -2.190467597630944D-18,  -1.902723158872188D-17,  -9.945927459651084D-16, &
&    3.863699457719604D-14,  -8.886733621789580D-13,   3.377706619448681D-11, &
&   -1.023977382727211D-09,   2.988693667140571D-08,  -8.430079976346628D-07, &
&    2.179633818687352D-05,  -4.999098689619745D-04,   8.523347346942792D-03, &
&   -8.823499180433491D-18,  -6.341831960748066D-18,   9.357546289953354D-16, &
&    1.496023985936663D-14,   3.780961814546440D-14,  -2.672111606606178D-12, &
&   -5.019374962156203D-11,  -2.020669022185398D-10,   7.932425482586054D-09, &
&    1.740229293326714D-07,   1.046135631188900D-06,  -2.561364440963980D-05, &
&   -8.366347302249501D-04,  -1.295820623517434D-02,   8.853285712466456D-01, &
&    7.344669591654052D-19,  -2.704377822580663D-18,  -5.827995292812064D-17, &
&    2.105130713029844D-15,   2.105554269950433D-14,  -7.876600020927564D-13, &
&   -8.812085977087831D-12,   2.017044138199889D-10,   2.026674389142343D-09, &
&   -5.802515813521671D-08,  -1.400215623254189D-07,   2.698508951968238D-05, &
&   -7.701804847933206D-05,  -2.135330651770247D-02,   6.085141266237617D-01, &
&    6.045405206895018D-21,  -2.117865357914617D-19,   2.113805574761064D-17, &
&    4.277713453656324D-16,  -5.421346289715126D-15,  -9.301618870727948D-14, &
&    4.680805379186965D-14,  -2.813887841520881D-11,   6.154237454140150D-10, &
&    1.803741468387086D-08,  -5.431264257846108D-07,   3.044580491020238D-06, &
&    3.463591608371748D-04,  -1.642577976155258D-02,   3.638797121878930D-01, &
&   -1.180946191598123D-20,   1.251584940086016D-19,   7.422154066269692D-18, &
&    1.073312026850604D-16,  -1.429623066049202D-16,  -5.658903361738752D-14, &
&   -4.778626988378332D-13,   1.188597334888365D-11,  -1.570500987702865D-10, &
&    6.788626252087847D-09,   1.844954785494470D-08,  -6.417650996929626D-06, &
&    2.968018506099297D-04,  -9.191984092358423D-03,   1.829646687270615D-01, &
&   -3.445348446085523D-21,   3.562541440143997D-20,   2.327074809499782D-18, &
&    4.024290418717630D-17,  -2.924100833096911D-16,  -1.206840153808285D-14, &
&   -2.085007485403355D-13,   1.897922578240824D-12,   7.058436567564741D-11, &
&   -1.937070850575126D-09,   1.104888226580398D-07,  -4.168555665579565D-06, &
&    1.300926157179474D-04,  -3.445852666899069D-03,   6.515642002357831D-02, &
&   -4.009428613220466D-22,   3.807319925169115D-21,   2.536099176605601D-19, &
&    3.732150619943993D-18,  -1.094615814866320D-17,  -1.932843011962951D-15, &
&   -1.196754190275582D-15,  -3.834468709008546D-13,   2.209462142270574D-11, &
&   -5.374135244385779D-10,   1.843182061296166D-08,  -5.603445861673293D-07, &
&    1.558389385281596D-05,  -3.890346531056937D-04,   7.199218495578413D-03, &
&    3.006674895151414D-17,  -1.050163269870604D-16,  -3.963691400417910D-15, &
&   -1.624201746808796D-14,   5.317867248604116D-13,   8.014829849046442D-12, &
&   -1.856503100663221D-11,  -1.625321494191957D-09,  -1.221707684418180D-08, &
&    1.841154855495504D-07,   4.189130837173123D-06,   5.495652245993909D-06, &
&   -9.562776235381788D-04,  -1.847660378417993D-02,   8.383646603639446D-01, &
&   -1.417340855300824D-18,  -8.965430604873552D-18,  -8.010204415795103D-17, &
&    2.435958607874795D-16,   5.840702647435562D-14,   5.474066982036647D-13, &
&   -1.453325222079186D-11,  -1.520308295155035D-10,   2.809133754203018D-09, &
&   -2.892626575779950D-09,  -6.157237249251591D-07,   2.158819504239803D-05, &
&    1.458778782218790D-04,  -2.112165102533773D-02,   5.444660470287513D-01, &
&   -3.322158249195128D-19,  -4.651075209462444D-18,  -3.796566997837602D-17, &
&    6.442637183652063D-16,   1.744285887903792D-14,   6.048966759566820D-14, &
&   -2.000839759851434D-12,  -5.954471946892343D-11,  -2.055172877118620D-10, &
&    2.276502980369835D-08,  -2.191124561821935D-07,  -1.602944907805061D-06, &
&    3.498983814477331D-04,  -1.431602534845808D-02,   3.177625842223229D-01, &
&   -1.198900197189416D-19,  -1.860681674151398D-18,  -1.443035594008545D-17, &
&    2.198408840605275D-16,   7.183002986241591D-15,   3.559248365255658D-14, &
&   -1.280210732371921D-12,  -1.402422127722218D-11,  -1.413603528701396D-10, &
&    4.948953786221629D-09,   1.059480873444267D-07,  -5.646246191389380D-06, &
&    2.417279291813608D-04,  -7.579887589968980D-03,   1.578897078487809D-01, &
&   -3.484975846863579D-20,  -5.834588921063488D-19,  -4.791246192486999D-18, &
&    7.142352790450891D-17,   2.183504204625135D-15,   1.241355494272374D-14, &
&   -3.790228605447690D-13,  -6.426225212734475D-12,   3.169850510005101D-11, &
&   -7.464283586244260D-10,   9.119561380890563D-08,  -2.977129009532139D-06, &
&    9.810920767596870D-05,  -2.766591486155934D-03,   5.588567744017467D-02, &
&   -3.511679546184346D-21,  -6.108029325808162D-20,  -5.039232729881481D-19, &
&    7.186099635450322D-18,   2.369238870999686D-16,   1.033503157979936D-15, &
&   -3.093285787292376D-14,  -9.239580198718483D-13,   9.766577579598206D-12, &
&   -2.326755062176234D-10,   1.292694125023636D-08,  -3.768182714503653D-07, &
&    1.141572270128431D-05,  -3.088574866818800D-04,   6.158617885731892D-03, &
&   -8.609420091481081D-17,   2.530691207109634D-16,   8.433774319110869D-15, &
&   -1.335579203540904D-14,  -1.320881017078948D-12,  -2.610387882700783D-12, &
&    1.987996544535035D-10,   1.091079258054533D-09,  -2.824092693119846D-08, &
&   -2.689950940105631D-07,   3.962491801762223D-06,   6.147335978908625D-05, &
&   -6.536544852413012D-04,  -2.356476654224409D-02,   7.748483941676609D-01, &
&    4.669513615688746D-18,   4.433766368912529D-17,  -3.637712963361138D-17, &
&   -8.336868903610614D-15,  -6.714804830300660D-14,   1.236247516881445D-12, &
&    1.782786816704184D-11,  -1.590765655275204D-10,  -1.885331795393482D-09, &
&    5.963118705554005D-09,  -4.805129556682355D-07,   1.487588428235580D-05, &
&    3.085422966088235D-04,  -1.972806281361656D-02,   4.829479338117647D-01, &
&    1.540329038215573D-18,   1.516288829980064D-17,  -2.883994506624973D-17, &
&   -2.978835486308872D-15,  -1.829299243893684D-14,   3.886391126574761D-13, &
&    6.411411118729262D-12,  -2.821818049930853D-11,  -1.499786358947135D-09, &
&    6.577367165020846D-09,   3.179113699448363D-08,  -2.481734738881335D-06, &
&    3.292023481113133D-04,  -1.227499008266821D-02,   2.779078070227699D-01, &
&    5.573330497468027D-19,   5.745672413248157D-18,  -9.613399355445459D-18, &
&   -1.154308082839087D-15,  -7.374720323788034D-15,   1.624614853527240D-13, &
&    2.355263346767063D-12,  -9.453295904214670D-12,  -5.485457499573912D-10, &
&   -1.347599006909800D-09,   1.428582145268343D-07,  -4.058773636139907D-06, &
&    1.977047528213627D-04,  -6.268818397003616D-03,   1.371827912156431D-01, &
&    1.651466293030782D-19,   1.772077764392784D-18,  -2.676811214886729D-18, &
&   -3.568648031889247D-16,  -2.336511148961504D-15,   5.057300300731450D-14, &
&    7.710661792315110D-13,  -4.243489449061716D-12,  -1.311296012045878D-10, &
&   -1.692895513314081D-09,   7.679767410813685D-08,  -1.954840519083719D-06, &
&    7.603772961888257D-05,  -2.248763914126526D-03,   4.839571577976799D-02, &
&    1.679227155419810D-20,   1.837364994484827D-19,  -2.570912705918225D-19, &
&   -3.717144802534109D-17,  -2.415239119272498D-16,   5.158654989536283D-15, &
&    8.445357284915092D-14,  -5.522989413903681D-13,  -1.084492984748262D-11, &
&   -2.522502670663965D-10,   9.777262640429213D-09,  -2.402722773358024D-07, &
&    8.666266913364655D-06,  -2.492262734366718D-04,   5.325608310178120D-03, &
&    1.147110412053035D-16,  -1.342588001898581D-16,  -9.363329376370658D-15, &
&    4.072434911454423D-14,   1.258845454266215D-12,  -9.312960682160316D-12, &
&   -1.675739393571592D-10,   1.896469575578206D-09,   2.036012790588929D-08, &
&   -3.682010046495495D-07,  -1.991233738405476D-06,   7.487771749669048D-05, &
&    1.568773222617445D-05,  -2.554044061275127D-02,   7.001695565953226D-01, &
&   -3.491881203403617D-18,  -8.646425808829542D-17,   1.810740250705266D-16, &
&    1.425941386439010D-14,  -1.362109753782162D-14,  -2.199022495984692D-12, &
&    1.973593028511486D-12,   2.897920714992967D-10,   1.739663779703691D-10, &
&   -2.498158994579072D-08,  -6.726129752704311D-07,   8.469783305426873D-06, &
&    4.154181587974374D-04,  -1.752783448829789D-02,   4.269032160253215D-01, &
&   -1.755140705215855D-18,  -2.743418084382014D-17,   1.132867183579029D-16, &
&    4.791120113104266D-15,  -1.026958296503457D-14,  -7.925825910388084D-13, &
&    7.666833637106462D-13,   1.303713505361793D-10,  -1.898789916494039D-10, &
&   -1.410586210795704D-08,  -5.521218337396580D-08,  -2.294948169459519D-06, &
&    3.085460981378078D-04,  -1.036288658569780D-02,   2.439817175161791D-01, &
&   -6.963932828296239D-19,  -1.006520022194581D-17,   4.751221065038194D-17, &
&    1.822805238948961D-15,  -4.838446084091358D-15,  -3.073349350434035D-13, &
&    3.628011162290912D-13,   5.182436092345822D-11,  -2.018890563812493D-11, &
&   -8.586209550710178D-09,   5.609207998075545D-08,  -2.749882045339239D-06, &
&    1.678690584118943D-04,  -5.178093250774123D-03,   1.200569334132038D-01, &
&   -2.139619183846449D-19,  -3.035713257173951D-18,   1.497296555003716D-17, &
&    5.596776443616571D-16,  -1.579758529958130D-15,  -9.619796770930316D-14, &
&    1.448983950977381D-13,   1.568394256708223D-11,   1.521927772137789D-11, &
&   -3.422917104915651D-09,   3.501854790074047D-08,  -1.255854317346355D-06, &
&    6.197184453922325D-05,  -1.837906751421790D-03,   4.228669312915732D-02, &
&   -2.204815989769003D-20,  -3.117550707645591D-19,   1.561313448621126D-18, &
&    5.786517693772610D-17,  -1.657635848115413D-16,  -1.006870692417631D-14, &
&    1.723962989282427D-14,   1.594899496245107D-12,   2.916686493312432D-12, &
&   -3.973723508921243D-10,   4.582827627026730D-09,  -1.517055051467984D-07, &
&    6.949706606941166D-06,  -2.027791592049336D-04,   4.650160723236216D-03, &
&   -5.471465138581126D-17,   2.531034414055393D-17,   4.723317405408209D-15, &
&   -3.991940333950284D-14,  -4.043796739833835D-13,   1.003210561021048D-11, &
&   -2.101432649350572D-11,  -1.480946220530381D-09,   1.732488253040853D-08, &
&    8.455982162768077D-08,  -4.014457579807831D-06,   3.170197123400016D-05, &
&    5.132892819123328D-04,  -2.375265416992567D-02,   6.254781440930548D-01, &
&   -2.618223143652248D-18,   6.806951864824994D-17,  -1.221771731323086D-16, &
&   -1.050242655878070D-14,   7.493375887453511D-14,   1.235179823111332D-12, &
&   -1.734880913748735D-11,  -1.096037000739806D-10,   2.931638927382176D-09, &
&    1.698671114979088D-08,  -7.986234532861649D-07,  -1.031121759956130D-06, &
&    4.501482503191778D-04,  -1.488775767612194D-02,   3.782273398929039D-01, &
&    2.501515465783231D-20,   2.333155397960013D-17,  -1.109735426905503D-16, &
&   -3.525703779739416D-15,   3.485773788065095D-14,   4.147369343773609D-13, &
&   -7.721567731678008D-12,  -2.807709491007541D-11,   1.270434205689064D-09, &
&    1.110287694724085D-09,  -1.873327344807158D-07,  -3.995596517152220D-06, &
&    2.814915203013915D-04,  -8.584893217117688D-03,   2.156002455133844D-01, &
&    1.415399862941278D-19,   8.655512102422276D-18,  -5.223654780882359D-17, &
&   -1.307035072756663D-15,   1.466407718624699D-14,   1.536631366501475D-13, &
&   -3.184242604816038D-12,  -1.058226285339513D-11,   5.747784126014381D-10, &
&   -1.438949238849839D-09,  -3.323764916497274D-08,  -2.726684243681193D-06, &
&    1.440545245619464D-04,  -4.242321709051922D-03,   1.059617803781478D-01, &
&    6.093532496865457D-20,   2.610211121505523D-18,  -1.737392814722071D-17, &
&   -3.953514637674228D-16,   4.712644633884153D-15,   4.615874938562572D-14, &
&   -1.006312799979476D-12,  -3.450467828608018D-12,   1.962071450268032D-10, &
&   -8.587998419906758D-10,  -1.411249963627261D-09,  -1.094733687583229D-06, &
&    5.173002952503385D-05,  -1.497488889172206D-03,   3.729886060378670D-02, &
&    7.014234057232928D-21,   2.676565095262543D-19,  -1.851557773026240D-18, &
&   -4.063124796434606D-17,   4.968736775026967D-16,   4.718440474598205D-15, &
&   -1.051013681107669D-13,  -3.722116951509438D-13,   2.133423924764198D-11, &
&   -1.110783579598376D-10,   3.290728765012284D-10,  -1.267406607740905D-07, &
&    5.735795748374021D-06,  -1.648308544511757D-04,   4.100554733956519D-03, &
&    1.383984428597085D-17,  -3.448591013352499D-17,  -9.679623151692739D-16, &
&    1.936323834611527D-14,  -1.027984542516192D-13,  -2.281347242506283D-12, &
&    5.408924568749479D-11,  -3.692581765645637D-10,  -4.974195999642182D-09, &
&    1.560616951606405D-07,  -1.695725671556528D-06,  -3.506638625608674D-06, &
&    6.183651041862927D-04,  -2.019844903928268D-02,   5.594005373086921D-01, &
&    1.423557976838505D-18,  -2.496958217448016D-17,   1.393483537247919D-16, &
&    3.066574770076207D-15,  -6.021409692632885D-14,   1.013486181578417D-13, &
&    9.890440448844903D-12,  -1.221245351272313D-10,  -7.228531526712696D-10, &
&    3.673097472094085D-08,  -3.078697089158973D-07,  -7.965127453672502D-06, &
&    4.050857586512323D-04,  -1.229058766970956D-02,   3.375288106452063D-01, &
&    1.391207128234827D-19,  -9.169812906544352D-18,   8.426064689334735D-17, &
&    8.867914080889215D-16,  -2.537475012604624D-14,   1.053552999569123D-13, &
&    3.571832201663380D-12,  -5.586950719286928D-11,  -1.219161913848408D-10, &
&    1.216883450152252D-08,  -5.404104767456563D-08,  -5.611674635289734D-06, &
&    2.369966587206186D-04,  -7.022004567897478D-03,   1.922570279426625D-01, &
&   -1.584697202800714D-20,  -3.468213774948004D-18,   3.814810925006673D-17, &
&    2.941308470016416D-16,  -1.035554845218361D-14,   5.290104260500927D-14, &
&    1.400675691815899D-12,  -2.459773130337451D-11,  -2.644300897746771D-12, &
&    4.099704374879409D-09,   6.763981137050306D-10,  -3.006228941815249D-06, &
&    1.179253051626978D-04,  -3.455048101751928D-03,   9.445502220673570D-02, &
&   -1.559537038900457D-20,  -1.052322269672829D-18,   1.260695356278914D-17, &
&    8.256128124158060D-17,  -3.273843441760963D-15,   1.818304382954466D-14, &
&    4.384785312346315D-13,  -8.169866356432674D-12,   8.541058869361030D-12, &
&    1.117747521832078D-09,   5.058508191183124D-09,  -1.102879485240990D-06, &
&    4.177415303454999D-05,  -1.216912516501644D-03,   3.324221339111924D-02, &
&   -2.088173424306246D-21,  -1.081069353943284D-19,   1.342736137654296D-18, &
&    8.173151811017291D-18,  -3.425147286135860D-16,   1.965455821836268D-15, &
&    4.579895827756892D-14,  -8.754303177293035D-13,   1.372318227794141D-12, &
&    1.076500334356827D-10,   7.844066959570551D-10,  -1.233817875790927D-07, &
&    4.605255788649229D-06,  -1.338198095733957D-04,   3.654276160900930D-03, &
&   -2.116899348175617D-18,   1.751945591292441D-17,  -8.049798886066409D-17, &
&   -2.462287663412498D-15,   7.241724610199520D-14,  -8.916928842433883D-13, &
&    9.322123322485268D-13,   1.958253614715063D-10,  -4.481646284247639D-09, &
&    5.381319997413290D-08,  -1.433074064573775D-07,  -1.295655216627039D-05, &
&    5.303561490549534D-04,  -1.671120583184675D-02,   5.041722391600460D-01, &
&    9.362371635143626D-21,   4.733249591162191D-18,  -8.284558732015258D-17, &
&    3.006852407799302D-16,   1.371845558557426D-14,  -3.019187038934704D-13, &
&    1.969442784361604D-12,   3.848095376114195D-11,  -1.223892718265390D-09, &
&    1.404587383136979D-08,   8.244591663674448D-08,  -8.961772403842365D-06, &
&    3.253862016534846D-04,  -1.009501324634038D-02,   3.040710190705705D-01, &
&    9.436892017930524D-20,   1.553711936630295D-18,  -3.761082933109084D-17, &
&    2.426060696846224D-16,   4.477988648462507D-15,  -1.287837665021708D-13, &
&    1.095033710872065D-12,   1.179530036768221D-11,  -4.620107706230672D-10, &
&    4.711415186300259D-09,   7.962434878536968D-08,  -5.339618605954581D-06, &
&    1.865006060881972D-04,  -5.752846327246020D-03,   1.731708617888157D-01, &
&    5.477927553804077D-20,   5.456921930023216D-19,  -1.579557832413500D-17, &
&    1.206876844161798D-16,   1.607254033229936D-15,  -5.381302719848882D-14, &
&    5.133731264872496D-13,   3.820058860910848D-12,  -1.759534203682328D-10, &
&    1.563754680100732D-09,   4.683505011389373D-08,  -2.680293032297171D-06, &
&    9.191407319034123D-05,  -2.827034558533101D-03,   8.507104244645095D-02, &
&    1.987851410088671D-20,   1.577704321576601D-19,  -5.060428560067445D-18, &
&    4.167060339315733D-17,   4.741409588430367D-16,  -1.730066316845851D-14, &
&    1.748485271067379D-13,   1.020870581521614D-12,  -5.305587957720422D-11, &
&    4.163249993606302D-10,   1.788467454977969D-08,  -9.537823708955283D-07, &
&    3.240141448492801D-05,  -9.950674017903617D-04,   2.993833824461697D-02, &
&    2.194731314216517D-21,   1.582452730662326D-20,  -5.323541563407775D-19, &
&    4.520244471282915D-18,   4.809442882096870D-17,  -1.825260386664379D-15, &
&    1.891271299623399D-14,   9.750377493421844D-14,  -5.416317316032697D-12, &
&    3.939412255251870D-11,   2.033281930958931D-09,  -1.053546972705312D-07, &
&    3.564444232533751D-06,  -1.093928780668140D-04,   3.291021828699639D-03, &
&   -4.966195867489340D-20,  -1.841413227577567D-18,   5.701563181674962D-17, &
&   -8.936111474379066D-16,   5.835620623149016D-15,   1.186004934238275D-13, &
&   -4.875324449794680D-12,   9.587906985467013D-11,  -1.214163277417004D-09, &
&    6.025343968562808D-09,   2.311189636733175D-07,  -1.172370358179150D-05, &
&    4.160596322682350D-04,  -1.387813741878111D-02,   4.584606223371933D-01, &
&   -1.100987487035767D-19,   1.739828246224043D-19,   1.294949751649225D-17, &
&   -3.292441680810058D-16,   3.954249391493695D-15,   4.095313478815629D-15, &
&   -1.267996559774870D-12,   2.998403100398947D-11,  -3.760608459217784D-10, &
&    2.147695173403997D-11,   1.683085760445523D-07,  -7.248143963777924D-06, &
&    2.517046012009638D-04,  -8.371639839515590D-03,   2.764817783038211D-01, &
&   -5.535934437518153D-20,   1.849273117015855D-19,   4.306151591456557D-18, &
&   -1.407803182427602D-16,   1.977247982641309D-15,  -4.171073615895745D-15, &
&   -4.744320503260775D-13,   1.223168644780974D-11,  -1.459081220443556D-10, &
&   -7.287000956110265D-10,   1.020994822969135D-07,  -4.167825594548619D-06, &
&    1.435283587616737D-04,  -4.768105735207282D-03,   1.574539469360003D-01, &
&   -2.430614987241063D-20,   9.846221391349626D-20,   1.528070986847493D-18, &
&   -5.846111754137230D-17,   8.843634150137818D-16,  -3.051462581019497D-15, &
&   -1.816585172175804D-13,   4.921575627541513D-12,  -5.567165709955764D-11, &
&   -5.370685521085033D-10,   5.170206768873447D-08,  -2.057533424324880D-06, &
&    7.055524777551548D-05,  -2.342457401367189D-03,   7.734885365156045D-02, &
&   -7.959536123029739D-21,   3.502549410116296D-20,   4.441511740258147D-19, &
&   -1.868967487507012D-17,   2.938447038552399D-16,  -1.210652168363177D-15, &
&   -5.523594176458234D-14,   1.539960514791626D-12,  -1.669790203998473D-11, &
&   -2.219129711984901D-10,   1.848250338344492D-08,  -7.259820421254394D-07, &
&    2.483867501521971D-05,  -8.243808797871790D-04,   2.722051086578243D-02, &
&   -8.452091650118915D-22,   3.846191103150583D-21,   4.464550561572627D-20, &
&   -1.965812479484604D-18,   3.143502618835279D-17,  -1.386132225255389D-16, &
&   -5.670076208300472D-15,   1.602025035723052D-13,  -1.697063096858169D-12, &
&   -2.598161504833387D-11,   2.045672571154502D-09,  -7.989707454164619D-08, &
&    2.730861978089164D-06,  -9.062240532660141D-05,   2.992249240669930D-03, &
&    5.782972734597704D-20,  -5.362761843558301D-19,   5.084066793710996D-18, &
&    3.662080367669308D-17,  -3.146793974789667D-15,   8.549336260769979D-14, &
&   -1.583474814686359D-12,   2.093872400238818D-11,  -1.300898283591539D-10, &
&   -3.730549433477973D-09,   2.245875177014322D-07,  -8.850128528034340D-06, &
&    3.235784029405459D-04,  -1.167227710812255D-02,   4.202736866925927D-01, &
&    1.525727918393832D-20,  -2.147178004943440D-19,   3.255784071679059D-18, &
&   -1.724467412656244D-17,  -7.016548983513842D-16,   2.682905007561889D-14, &
&   -5.512544876776022D-13,   7.208267506679265D-12,  -1.810280346371067D-11, &
&   -2.803373099036363D-09,   1.395415029287866D-07,  -5.360844727980385D-06, &
&    1.952371622482970D-04,  -7.039342734839324D-03,   2.534499218925401D-01, &
&    5.327615398581351D-21,  -9.372652850596073D-20,   1.627499832169546D-18, &
&   -1.252774165678448D-17,  -2.329439987948544D-16,   1.105728794687348D-14, &
&   -2.369587851542855D-13,   2.992450448732755D-12,   2.775371332972232D-12, &
&   -1.721758683902579D-09,   8.042821449762170D-08,  -3.058653981484309D-06, &
&    1.112101276538082D-04,  -4.008893808603126D-03,   1.443368639351440D-01, &
&    1.932054867886997D-21,  -3.919840608515846D-20,   7.275527617956804D-19, &
&   -6.365004895411685D-18,  -8.158556087851397D-17,   4.499816607480107D-15, &
&   -9.846942112083021D-14,   1.201675470225424D-12,   4.600060678009916D-12, &
&   -8.774130656700059D-10,   3.975645517332368D-08,  -1.504037651814968D-06, &
&    5.463807986972556D-05,  -1.969372279966154D-03,   7.090495160447285D-02, &
&    5.673463191499807D-22,  -1.256473301968820D-20,   2.415727790175929D-19, &
&   -2.241038252355212D-18,  -2.335151661125348D-17,   1.420721587524104D-15, &
&   -3.142437856329412D-14,   3.736692738859158D-13,   2.220639562020428D-12, &
&   -3.147169785265007D-10,   1.403773171513599D-08,  -5.295819829966032D-07, &
&    1.922939145348824D-05,  -6.930615874896876D-04,   2.495274876753559D-02, &
&    5.726557954226933D-23,  -1.322767308976492D-21,   2.583170556639551D-20, &
&   -2.455458575222385D-19,  -2.324302750630119D-18,   1.485218451860601D-16, &
&   -3.300253732329333D-15,   3.870402431370858D-14,   2.733090259143808D-13, &
&   -3.488542523815332D-11,   1.545403761006453D-09,  -5.822889250631313D-08, &
&    2.113875871549466D-06,  -7.618580356261688D-05,   2.742961022234932D-03, &
&    5.555171336483376D-21,   1.048809036247494D-21,  -1.397932255208251D-18, &
&    4.856569870850435D-17,  -1.150204108581100D-15,   2.098805956999604D-14, &
&   -2.883796236448319D-13,   1.955860748305922D-12,   5.713209460287822D-11, &
&   -3.811111916420712D-09,   1.640494487390743D-07,  -6.518798317509595D-06, &
&    2.549700491428244D-04,  -9.947121645695391D-03,   3.879473346636855D-01, &
&    3.408845594317914D-21,  -1.581633945786178D-20,  -2.533219208384674D-19, &
&    1.484574660856285D-17,  -4.083923681277861D-16,   7.910749860433400D-15, &
&   -1.064564256299032D-13,   3.600117099120318D-13,   4.290137012082288D-11, &
&   -2.371103442921536D-09,   9.944297897214471D-08,  -3.934040554517756D-06, &
&    1.537733235408727D-04,  -5.998725267018032D-03,   2.339549064184682D-01, &
&    1.706992509002469D-21,  -9.751179313436266D-21,  -6.451990130539308D-20, &
&    6.013784922198523D-18,  -1.781954587363315D-16,   3.526949546347503D-15, &
&   -4.592101973315786D-14,   1.846409795238128D-14,   2.642318947037464D-11, &
&   -1.367977104213535D-09,   5.675885301301701D-08,  -2.241107804737527D-06, &
&    8.757508977402799D-05,  -3.416211992306633D-03,   1.332345935141837D-01, &
&    7.643106824835981D-22,  -4.737176558055360D-21,  -1.661041845131538D-20, &
&    2.422579172591771D-18,  -7.492294353676314D-17,   1.496882206228554D-15, &
&   -1.891838113445210D-14,  -3.807312941261655D-14,   1.349194320661841D-11, &
&   -6.766147720910733D-10,   2.791611283008747D-08,  -1.101126725624323D-06, &
&    4.302172498749112D-05,  -1.678203109435386D-03,   6.545098094670416D-02, &
&    2.539918401507029D-22,  -1.637056967457765D-21,  -3.466017437505209D-21, &
&    7.605683116273038D-19,  -2.410382816399764D-17,   4.835940674083414D-16, &
&   -5.980943145757442D-15,  -2.226252929637574D-14,   4.845137363644956D-12, &
&   -2.389927308345747D-10,   9.830643759330025D-09,  -3.875435497040456D-07, &
&    1.514028433668505D-05,  -5.905906646577692D-04,   2.303339265083453D-02, &
&    2.716923120967730D-23,  -1.780398544201483D-22,  -2.755948455586901D-22, &
&    7.930897807485019D-20,  -2.541864396778126D-18,   5.108013463069501D-17, &
&   -6.246258768138534D-16,  -2.879790863944079D-15,   5.373670058713030D-13, &
&   -2.631485970036536D-11,   1.080964085513244D-09,  -4.260302136001867D-08, &
&    1.664321615501217D-06,  -6.492140697218629D-05,   2.531973279829137D-03, &
&   -8.635207188935526D-22,   1.940471893638221D-20,  -5.533645446245021D-19, &
&    1.254497206010567D-17,  -2.303583067922043D-16,   3.265341683081494D-15, &
&   -2.182094693364023D-14,  -8.418316011599826D-13,   5.814067031545495D-11, &
&   -2.691268094326966D-09,   1.153060326168871D-07,  -4.859702938021744D-06, &
&    2.042054043172468D-04,  -8.577045789810104D-03,   3.602370989072422D-01, &
&   -9.599408206077386D-23,   5.692044492921492D-21,  -1.977875048050690D-19, &
&    4.843299376755484D-18,  -9.200498962648452D-17,   1.261909823550850D-15, &
&   -3.846954020729645D-15,  -6.139999212834092D-13,   3.610261715829887D-11, &
&   -1.631563229881847D-09,   6.959420218294368D-08,  -2.930993303112390D-06, &
&    1.231489880376439D-04,  -5.172461955344130D-03,   2.172439816355289D-01, &
&    2.756367653954948D-25,   2.233543856097497D-21,  -8.650757320566765D-20, &
&    2.193660083091812D-18,  -4.209744973634665D-17,   5.564837491518197D-16, &
&    1.977728559953934D-17,  -3.756411769761184D-13,   2.082044447264220D-11, &
&   -9.313472449420300D-10,   3.964816919886920D-08,  -1.669248181741662D-06, &
&    7.013223608934071D-05,  -2.945657446274787D-03,   1.237179075446787D-01, &
&    9.965704396650915D-24,   8.803373559965322D-22,  -3.643620546130612D-20, &
&    9.415155489265759D-19,  -1.812682253939216D-17,   2.323041610143383D-16, &
&    5.790725913417553D-16,  -1.913168716341569D-13,   1.029680033926302D-11, &
&   -4.581059159247442D-10,   1.948107544224691D-08,  -8.200339260512887D-07, &
&    3.445227907390180D-05,  -1.447043048768609D-03,   6.077594316313501D-02, &
&    4.983405754451324D-24,   2.726463251598164D-22,  -1.173686391533651D-20, &
&    3.064103419879537D-19,  -5.904237888841149D-18,   7.402423120751261D-17, &
&    3.119282592282171D-16,  -6.862652599319570D-14,   3.636894874040313D-12, &
&   -1.613292156649686D-10,   6.856537138123328D-09,  -2.885892197383928D-07, &
&    1.212440202208248D-05,  -5.092408467566271D-04,   2.138816119936282D-02, &
&    6.110554323252034D-25,   2.824504244069118D-23,  -1.238531781876583D-21, &
&    3.248276457319461D-20,  -6.259859577695780D-19,   7.759954928791246D-18, &
&    3.959368142461272D-17,  -7.607808904189137D-15,   4.004454585131991D-13, &
&   -1.773992785333395D-11,   7.537524065478710D-10,  -3.172373193523075D-08, &
&    1.332790281671666D-06,  -5.597891182970286D-05,   2.351119217668700D-03, &
&   -3.915244125705635D-22,   5.220307173797520D-21,  -1.133411990610396D-19, &
&    2.142230314599395D-18,  -3.097181715355720D-17,   1.758754237305899D-16, &
&    1.175258170610869D-14,  -8.046581981461727D-13,   3.954859344425899D-11, &
&   -1.814207379580544D-09,   8.193895347105485D-08,  -3.689381271728190D-06, &
&    1.660340616251653D-04,  -7.471582009272562D-03,   3.362213244607564D-01, &
&   -1.387087168155231D-22,   2.030443879336751D-21,  -4.650016682758437D-20, &
&    8.926355631740301D-19,  -1.229458267513130D-17,   1.554965698108966D-17, &
&    8.219566074186706D-15,  -4.976239130214661D-13,   2.396655414704010D-11, &
&   -1.095000010776329D-09,   4.942004562218732D-08,  -2.224943587189317D-06, &
&    1.001283428054721D-04,  -4.505799959338599D-03,   2.027610654740804D-01, &
&   -6.025767369146570D-23,   9.232150886568992D-22,  -2.163337546852586D-20, &
&    4.160772829233542D-19,  -5.475015617716222D-18,  -1.341411298455650D-17, &
&    4.966218797752669D-15,  -2.865725054118946D-13,   1.367917058517232D-11, &
&   -6.238364331912217D-10,   2.814577871569859D-08,  -1.267087970693550D-06, &
&    5.702195363335520D-05,  -2.566000458519269D-03,   1.154700551795962D-01, &
&   -2.527126055006533D-23,   3.973051889004290D-22,  -9.421100070842468D-21, &
&    1.809664702520157D-19,  -2.295292569062978D-18,  -1.242263046974866D-17, &
&    2.515250505852256D-15,  -1.416296603152413D-13,   6.728081569210296D-12, &
&   -3.065244509557360D-10,   1.382695504619472D-08,  -6.224544395237062D-07, &
&    2.801182318604222D-05,  -1.260537809810685D-03,   5.672421735527184D-02, &
&   -8.120074676260279D-24,   1.295279725353456D-22,  -3.090777185762349D-21, &
&    5.927122617107170D-20,  -7.327684399199896D-19,  -5.489769691116132D-18, &
&    8.997518989542799D-16,  -5.000739813401546D-14,   2.369341978480165D-12, &
&   -1.078847065813989D-10,   4.866045857464868D-09,  -2.190535226474246D-07, &
&    9.857872529608808D-06,  -4.436062146444785D-04,   1.996228504928111D-02, &
&   -8.558847224775497D-25,   1.374339694652034D-23,  -3.288484718121578D-22, &
&    6.299864220529802D-21,  -7.686996710514522D-20,  -6.585666490320567D-19, &
&    9.962776734373093D-17,  -5.505323928021904D-15,   2.605326976790438D-13, &
&   -1.186001201048803D-11,   5.349103394124849D-10,  -2.407974415895612D-08, &
&    1.083638527340565D-06,  -4.876394423956195D-05,   2.194378072762001D-03, &
&   -8.204462837255589D-23,   9.190618010430514D-22,  -1.684596758158065D-20, &
&    2.481428252676112D-19,  -7.898486932877833D-19,  -1.520423609641121D-16, &
&    1.016004741853014D-14,  -5.255660975531246D-13,   2.566376714568784D-11, &
&   -1.236185044710908D-09,   5.937301779853687D-08,  -2.850152989992099D-06, &
&    1.368086895769688D-04,  -6.566822514101463D-03,   3.152074950462713D-01, &
&   -3.396350265397180D-23,   3.924131710626409D-22,  -7.241644126238116D-21, &
&    9.928394303399894D-20,   2.892876992582510D-19,  -1.020854915616963D-16, &
&    6.252282873744447D-15,  -3.182695302489713D-13,   1.548883142865985D-11, &
&   -7.455853034571601D-10,   3.580599090611244D-08,  -1.718811494746568D-06, &
&    8.250362915029636D-05,  -3.960176942775544D-03,   1.900885005801117D-01, &
&   -1.588227970499684D-23,   1.858194267758761D-22,  -3.419575449496377D-21, &
&    4.405827751499836D-20,   3.590012665199376D-19,  -6.082776977008373D-17, &
&    3.593587330397062D-15,  -1.816047325336854D-13,   8.823987623859702D-12, &
&   -4.246278417907878D-10,   2.039125946896421D-08,  -9.788438943850291D-07, &
&    4.698485499816917D-05,  -2.255274454481950D-03,   1.082531776047933D-01, &
&   -6.940360595886884D-24,   8.169909870625331D-23,  -1.497197450606174D-21, &
&    1.836384230905498D-20,   2.279991367456677D-19,  -3.060420150982228D-17, &
&    1.774274440771825D-15,  -8.930930689970978D-14,   4.335651943737790D-12, &
&   -2.086039082367474D-10,   1.001717360111388D-08,  -4.808535104738164D-07, &
&    2.308112893335919D-05,  -1.107894842091123D-03,   5.317895417374168D-02, &
&   -2.281895052574147D-24,   2.694400432398577D-23,  -4.920859980293554D-22, &
&    5.833001781808881D-21,   9.021585944462604D-20,  -1.091064676272290D-17, &
&    6.261454263653084D-16,  -3.144854184289221D-14,   1.525972611167560D-12, &
&   -7.341292303242495D-11,   3.525235005253095D-09,  -1.692211543093051D-07, &
&    8.122669764848494D-06,  -3.898883703126664D-04,   1.871464237037854D-02, &
&   -2.430444781099167D-25,   2.873538029473871D-24,  -5.238325963414160D-23, &
&    6.101508318199512D-22,   1.041091472252693D-20,  -1.206338335661391D-18, &
&    6.891667606062729D-17,  -3.457964932826023D-15,   1.677532508219596D-13, &
&   -8.070073991834581D-12,   3.875161382061974D-10,  -1.860184028120299D-08, &
&    8.928942033091603D-07,  -4.285894570047027D-05,   2.057229457976971D-03, &
&   -1.266127659020478D-23,   1.224376618456977D-22,  -1.625101499520961D-21, &
&   -3.767669923472791D-21,   1.797336513541542D-18,  -1.175347050276323D-16, &
&    6.365209818879713D-15,  -3.293292970689945D-13,   1.684798767309449D-11, &
&   -8.597471549588778D-10,   4.385115622150409D-08,  -2.236436028315895D-06, &
&    1.140583805752697D-04,  -5.816977971824500D-03,   2.966658780240357D-01, &
&   -5.584979988716963D-24,   5.367272492191326D-23,  -6.358453810982864D-22, &
&   -7.980235244708845D-21,   1.167523856657873D-18,  -7.197893187222284D-17, &
&    3.851439480696189D-15,  -1.987369349404218D-13,   1.016149769968823D-11, &
&   -5.184866031233896D-10,   2.644486032418383D-08,  -1.348701619408020D-06, &
&    6.878385572845072D-05,  -3.507976931205089D-03,   1.789068242461601D-01, &
&   -2.682739191927959D-24,   2.553607937175311D-23,  -2.740522077695475D-22, &
&   -6.032238477604767D-21,   6.870611510690456D-19,  -4.128689281359273D-17, &
&    2.196855112806758D-15,  -1.132148666231812D-13,   5.787183293873493D-12, &
&   -2.952745763666130D-10,   1.506005457100831D-08,  -7.680698763935592D-07, &
&    3.917160156434251D-05,  -1.997751829874993D-03,   1.018853437165591D-01, &
&   -1.188541075317610D-24,   1.121948005060554D-23,  -1.111317801509182D-22, &
&   -3.364023922567652D-21,   3.435408104356310D-19,  -2.036302554099792D-17, &
&    1.080163460015829D-15,  -5.562649901352299D-14,   2.843023301309515D-12, &
&   -1.450531994977646D-10,   7.398197970056950D-09,  -3.773113742850429D-07, &
&    1.924289761925543D-05,  -9.813878481829085D-04,   5.005078043982321D-02, &
&   -3.936015047807517D-25,   3.693651821311117D-24,  -3.456040907689249D-23, &
&   -1.261858705078894D-21,   1.220768091077973D-19,  -7.182035273522645D-18, &
&    3.803199426993960D-16,  -1.957798459486170D-14,   1.000529933936153D-12, &
&   -5.104700335632859D-11,   2.603561486853959D-09,  -1.327827480490116D-07, &
&    6.771926105131384D-06,  -3.453682550256045D-04,   1.761378106840854D-02, &
&   -4.205461280744319D-26,   3.934605530608768D-25,  -3.573762555672752D-24, &
&   -1.425858644519966D-22,   1.347813672852403D-20,  -7.902883671773611D-19, &
&    4.181666760437890D-17,  -2.152233964557269D-15,   1.099853672918482D-13, &
&   -5.611410022900837D-12,   2.861996573469762D-10,  -1.459630270667367D-08, &
&    7.444120817794490D-07,  -3.796501873012061D-05,   1.936215961955632D-03, &
&   -1.498708317277547D-24,   9.602205795684811D-24,   1.413242488383201D-22, &
&   -1.934490770798617D-20,   1.250705462587443D-18,  -7.072023815058037D-17, &
&    3.862831767398697D-15,  -2.091316829279173D-13,   1.129891150216803D-11, &
&   -6.101952641554276D-10,   3.295097150903221D-08,  -1.779355250309979D-06, &
&    9.608519795658220D-05,  -5.188600745290718D-03,   2.801844403875637D-01, &
&   -6.642706747858178D-25,   3.530873291317937D-24,   1.222767560293994D-22, &
&   -1.226228452046832D-20,   7.627355237311869D-19,  -4.275706469650114D-17, &
&    2.330753422480764D-15,  -1.261310894509011D-13,   6.814011699914742D-12, &
&   -3.679841395830416D-10,   1.987136232909507D-08,  -1.073055001892063D-06, &
&    5.794497757623995D-05,  -3.129028818050541D-03,   1.689675562488325D-01, &
&   -3.167044668936970D-25,   1.418512708627083D-24,   7.952785093120309D-23, &
&   -7.144636573634272D-21,   4.366972769960260D-19,  -2.437980926358397D-17, &
&    1.327684996002725D-15,  -7.183372017728603D-14,   3.880531188621641D-12, &
&   -2.095628974646868D-10,   1.131650986365448D-08,  -6.110922791140013D-07, &
&    3.299898696737284D-05,  -1.781945311354453D-03,   9.622504685194480D-02, &
&   -1.391017881503164D-25,   5.368932234210701D-25,   4.176511342578909D-23, &
&   -3.554106170435919D-21,   2.151697464269045D-19,  -1.198488052790037D-17, &
&    6.523175660267732D-16,  -3.528903286205810D-14,   1.906304744782683D-12, &
&   -1.029470281725997D-10,   5.559192050002678D-09,  -3.001967170540480D-07, &
&    1.621062453103756D-05,  -8.753737317107748D-04,   4.727018153046481D-02, &
&   -4.576458598022394D-26,   1.577655800376695D-25,   1.522656802934389D-23, &
&   -1.259478451893397D-21,   7.584936313130455D-20,  -4.219361959507937D-18, &
&    2.295818167392711D-16,  -1.241905203127003D-14,   6.708651205563333D-13, &
&   -3.622894724477514D-11,   1.956380999485947D-09,  -1.056446917689855D-07, &
&    5.704813971702338D-06,  -3.080599568685905D-04,   1.663523767706936D-02, &
&   -4.872115108865530D-27,   1.579282735591201D-26,   1.700148608188505D-24, &
&   -1.388855173384469D-22,   8.344200732001912D-21,  -4.639018905009336D-19, &
&    2.523803004470829D-17,  -1.365189158638331D-15,   7.374574023667903D-14, &
&   -3.982511054104430D-12,   2.150575267416601D-10,  -1.161311918624774D-08, &
&    6.271085027371491D-07,  -3.386385940726094D-05,   1.828648408659785D-03, &
&   -7.892427545586425D-26,  -1.880626742985927D-24,   1.902987523442240D-22, &
&   -1.229476846738755D-20,   7.249822199119079D-19,  -4.168506131428784D-17, &
&    2.380888076302452D-15,  -1.357683748452510D-13,   7.739403968596395D-12, &
&   -4.411515506108966D-10,   2.514568114988071D-08,  -1.433304099293575D-06, &
&    8.169833505158551D-05,  -4.656805103212512D-03,   2.654378908963435D-01, &
&   -2.205043375226642D-26,  -1.367743938772417D-24,   1.184733378992495D-22, &
&   -7.472789772374205D-21,   4.380180004956706D-19,  -2.514869129360436D-17, &
&    1.435928226112438D-15,  -8.187737311067764D-14,   4.667321587245136D-12, &
&   -2.660401812476016D-10,   1.516431251066352D-08,  -8.643659557473179D-07, &
&    4.926886020597214D-05,  -2.808325034510529D-03,   1.600745269740780D-01, &
&   -5.698608630143444D-27,  -8.424863484331467D-25,   6.849381232166508D-23, &
&   -4.271942403651286D-21,   2.496749504497186D-19,  -1.432478081980075D-17, &
&    8.177770417278958D-16,  -4.662853234531396D-14,   2.657987874210546D-12, &
&   -1.515067921542709D-10,   8.635898723521102D-09,  -4.922463018345466D-07, &
&    2.805803958634055D-05,  -1.599308257876433D-03,   9.116057070262912D-02, &
&   -9.237204006948829D-28,  -4.313635302443459D-25,   3.393151439333312D-23, &
&   -2.103116191369358D-21,   1.227160513612446D-19,  -7.037809602980677D-18, &
&    4.017390736155305D-16,  -2.290617870432545D-14,   1.305727054465772D-12, &
&   -7.442713074912506D-11,   4.242351832726464D-09,  -2.418140891987691D-07, &
&    1.378340326233305D-05,  -7.856539866322488D-04,   4.478227723975467D-02, &
&    3.990295233535295D-29,  -1.552553770905547D-25,   1.199738960095267D-23, &
&   -7.410264936027163D-22,   4.319880101840557D-20,  -2.476896487793782D-18, &
&    1.413811527848049D-16,  -8.061120051659801D-15,   4.595092904508079D-13, &
&   -2.619226384501623D-11,   1.492960871157863D-09,  -8.509878149302935D-08, &
&    4.850630605812436D-06,  -2.764859447631471D-04,   1.575969885208563D-02, &
&    2.292737764327530D-29,  -1.723883102805554D-26,   1.321644088831356D-24, &
&   -8.150348324971342D-23,   4.749322899110061D-21,  -2.722840258000858D-19, &
&    1.554158606769858D-17,  -8.861292096726862D-16,   5.051211685514850D-14, &
&   -2.879216007910298D-12,   1.641155107297840D-10,  -9.354585393220961D-09, &
&    5.332113739891243D-07,  -3.039304834249911D-05,   1.732403755585988D-03, &
&    4.044170359643259D-26,  -1.712134137292378D-24,   1.119801448978851D-22, &
&   -6.893090145477139D-21,   4.162256847299217D-19,  -2.501187109616515D-17, &
&    1.501214067438306D-15,  -9.007869954175588D-14,   5.404782210466031D-12, &
&   -3.242874707634780D-10,   1.945725233752150D-08,  -1.167435166007622D-06, &
&    7.004611008936666D-05,  -4.202766605843107D-03,   2.521659963517770D-01, &
&    2.694085070052998D-26,  -1.055152560066936D-24,   6.788132276230870D-23, &
&   -4.162342974977059D-21,   2.510821750075039D-19,  -1.508452559891450D-17, &
&    9.053296362604978D-16,  -5.432280615641490D-14,   3.259399673723798D-12, &
&   -1.955642613611503D-10,   1.173385782685952D-08,  -7.040314831685125D-07, &
&    4.224188905821394D-05,  -2.534513343747890D-03,   1.520708006255066D-01, &
&    1.603829607966298D-26,  -6.072589996618063D-25,   3.875714463667536D-23, &
&   -2.371952172575379D-21,   1.430096559170015D-19,  -8.590725154614923D-18, &
&    5.155775711054036D-16,  -3.093623144051020D-14,   1.856190233856651D-12, &
&   -1.113715610915892D-10,   6.682294790933978D-09,  -4.009376945833705D-07, &
&    2.405626171087682D-05,  -1.443375702787213D-03,   8.660254216756753D-02, &
&    8.075300263870083D-27,  -3.000782737574950D-25,   1.906728572038378D-23, &
&   -1.165649565381366D-21,   7.025898654333014D-20,  -4.220235827629992D-18, &
&    2.532763245675122D-16,  -1.519731212628736D-14,   9.118463330146169D-13, &
&   -5.471084849539033D-11,   3.282651434751737D-09,  -1.969590894142014D-07, &
&    1.181754538162829D-05,  -7.090527229607122D-04,   4.254316337779962D-02, &
&    2.881861616214381D-27,  -1.059584322592182D-25,   6.715695335932726D-24, &
&   -4.103007446761625D-22,   2.472662979285211D-20,  -1.485192995591519D-18, &
&    8.913272010400954D-17,  -5.348212552008971D-15,   3.208953437538005D-13, &
&   -1.925374398224180D-11,   1.155224818056312D-09,  -6.931349021996802D-08, &
&    4.158809418929534D-06,  -2.495285651573142D-04,   1.497171390949252D-02, &
&    3.185991851312307D-28,  -1.166521278663351D-26,   7.385129828555641D-25, &
&   -4.510720854910777D-23,   2.718165580219812D-21,  -1.632623832816337D-19, &
&    9.798029486465687D-18,  -5.879087494432961D-16,   3.527480539642236D-14, &
&   -2.116490853075080D-12,   1.269894705881221D-10,  -7.619368358450772D-09, &
&    4.571621021283144D-07,  -2.742972613003465D-05,   1.645783567807899D-03, &
&    2.854511400001729D-26,  -9.549380111603995D-25,   6.095884523362325D-23, &
&   -3.864832823074696D-21,   2.437565649410750D-19,  -1.536049862827437D-17, &
&    9.677608465987222D-16,  -6.096949937692348D-14,   3.841084181598607D-12, &
&   -2.419883537105165D-10,   1.524526666010979D-08,  -9.604518019216215D-07, &
&    6.050846353258750D-05,  -3.812033202595470D-03,   2.401580917636184D-01, &
&    1.746029160429822D-26,  -5.779623639507510D-25,   3.679327045613241D-23, &
&   -2.331198743431006D-21,   1.470058602665678D-19,  -9.263354475677114D-18, &
&    5.836170726494883D-16,  -3.676817165288856D-14,   2.316397818950251D-12, &
&   -1.459330891001301D-10,   9.193784812469433D-09,  -5.792084444252985D-07, &
&    3.649013200493335D-05,  -2.298878316333486D-03,   1.448293339290653D-01, &
&    1.000544298268226D-26,  -3.297484110460991D-25,   2.096254060953290D-23, &
&   -1.327730248757890D-21,   8.372001058901762D-20,  -5.275395131779323D-18, &
&    3.323633488927880D-16,  -2.093904611703197D-14,   1.319161483285625D-12, &
&   -8.310718739488019D-11,   5.235752910881399D-09,  -3.298524340403423D-07, &
&    2.078070334779002D-05,  -1.309184310922794D-03,   8.247861158816555D-02, &
&    4.931500507288837D-27,  -1.621486355188032D-25,   1.030039303711515D-23, &
&   -6.522823868848441D-22,   4.112767397022265D-20,  -2.591524079695870D-18, &
&    1.632722807201679D-16,  -1.028622600390038D-14,   6.480329747608125D-13, &
&   -4.082608392829117D-11,   2.572043336611121D-09,  -1.620387305132057D-07, &
&    1.020844002385506D-05,  -6.431317215085112D-04,   4.051729845505007D-02, &
&    1.742549755610934D-27,  -5.710063709159641D-26,   3.625395308408877D-24, &
&   -2.295580721782898D-22,   1.447368707567383D-20,  -9.120058617857741D-19, &
&    5.745850359138204D-17,  -3.619910388106958D-15,   2.280546058033468D-13, &
&   -1.436744239172566D-11,   9.051488874681192D-10,  -5.702438001537196D-08, &
&    3.592535941489582D-06,  -2.263297643157754D-04,   1.425877515189860D-02, &
&    1.913936510650088D-28,  -6.278290828259021D-27,   3.985550197371868D-25, &
&   -2.523485485433834D-23,   1.591042913108397D-21,  -1.002534039556226D-19, &
&    6.316195517326178D-18,  -3.979229885780750D-16,   2.506917551245933D-14, &
&   -1.579358298545695D-12,   9.949957462853536D-11,  -6.268473212971257D-09, &
&    3.949138124737196D-07,  -2.487957018605394D-05,   1.567412921721914D-03, &
&    1.520203541607024D-26,  -5.073402521300842D-25,   3.346192282574783D-23, &
&   -2.214167937365535D-21,   1.461620290033319D-19,  -9.647051644585036D-18, &
&    6.367100678129037D-16,  -4.202291698990713D-14,   2.773513043896396D-12, &
&   -1.830518654235354D-10,   1.208142315138452D-08,  -7.973739281961324D-07, &
&    5.262667926194331D-05,  -3.473360831291895D-03,   2.292418148652739D-01, &
&    9.180049159435721D-27,  -3.061243393993894D-25,   2.018228663509641D-23, &
&   -1.335313334076445D-21,   8.814476786710189D-20,  -5.817741180644654D-18, &
&    3.839733695940280D-16,  -2.534227013284953D-14,   1.672590105770340D-12, &
&   -1.103909493882141D-10,   7.285802677458517D-09,  -4.808629768218270D-07, &
&    3.173695647077642D-05,  -2.094639127073200D-03,   1.382461823868360D-01, &
&    5.241167499225229D-27,  -1.744097544476754D-25,   1.149433157094888D-23, &
&   -7.604572986951458D-22,   5.019757619171414D-20,  -3.313137500337284D-18, &
&    2.186683636273169D-16,  -1.443212661008220D-14,   9.525205024377663D-13, &
&   -6.286635443352779D-11,   4.149179402057871D-09,  -2.738458405939314D-07, &
&    1.807382547948410D-05,  -1.192872481646992D-03,   7.872958378870398D-02, &
&    2.573500008691681D-27,  -8.567913501482899D-26,   5.646798546351143D-24, &
&   -3.735753068910537D-22,   2.465941164703091D-20,  -1.627566528896788D-18, &
&    1.074199927261112D-16,  -7.089726351817773D-15,   4.679220076456758D-13, &
&   -3.088285310099540D-11,   2.038268309096314D-09,  -1.345257084276429D-07, &
&    8.878696756358206D-06,  -5.859939859201312D-04,   3.867560307072985D-02, &
&    9.076557279280871D-28,  -3.015854769032355D-26,   1.987246357168538D-24, &
&   -1.314686381859385D-22,   8.678105542324502D-21,  -5.727704147914909D-19, &
&    3.780305281989162D-17,  -2.495003820052600D-15,   1.646702755143997D-13, &
&   -1.086823838794667D-11,   7.173037351208997D-10,  -4.734204652732359D-08, &
&    3.124575070849192D-06,  -2.062219546762145D-04,   1.361064900863056D-02, &
&    9.962043251013739D-29,  -3.315268100372827D-27,   2.184540385349814D-25, &
&   -1.445188402941029D-23,   9.539516157625915D-22,  -6.296247910988889D-20, &
&    4.155545882702654D-18,  -2.742662812420382D-16,   1.810157709815623D-14, &
&   -1.194704110603179D-12,   7.885047146432161D-11,  -5.204131117659215D-09, &
&    3.434726537704832D-07,  -2.266919514887011D-05,   1.496166879825472D-03/
      data w6 / &
&    1.749709333526868D-13,  -3.136555702505482D-12,   3.922323401756585D-11, &
&   -4.693478534788315D-10,   5.406970471165391D-09,  -5.762746637201533D-08, &
&    5.560660922704404D-07,  -4.788547064532109D-06,   3.623098889764546D-05, &
&   -2.360571158436993D-04,   1.288417888166504D-03,  -5.659934524932288D-03, &
&    1.877927875427306D-02,  -4.188443018346283D-02,   4.717533638651183D-02, &
&    1.663550376630084D-13,  -3.006173677708570D-12,   3.826056394147563D-11, &
&   -4.694328448728367D-10,   5.568825647915673D-09,  -6.139128367723911D-08, &
&    6.161690353689275D-07,  -5.556315226995851D-06,   4.437282046104653D-05, &
&   -3.080329895596080D-04,   1.811698366947824D-03,  -8.694749059099863D-03, &
&    3.205835456660582D-02,  -8.120294973365039D-02,   1.069393259953184D-01, &
&    4.923318850563796D-14,  -9.037054045368248D-13,   1.190073177378400D-11, &
&   -1.531770348273542D-10,   1.921000459510902D-09,  -2.256954072726481D-08, &
&    2.438648838203860D-07,  -2.395975514100438D-06,   2.114382671883410D-05, &
&   -1.649261354347655D-04,   1.112069874326912D-03,  -6.271935961288443D-03, &
&    2.804663308045053D-02,  -8.990320886991961D-02,   1.600783285433462D-01, &
&    5.138204940530207D-15,  -9.678709405452140D-14,   1.347941415514447D-12, &
&   -1.873818571307419D-11,   2.566468009997702D-10,  -3.332456469335665D-09, &
&    4.038525513194471D-08,  -4.527964510213675D-07,   4.652609410161602D-06, &
&   -4.327129662445936D-05,   3.579775014262547D-04,  -2.566886676229950D-03, &
&    1.529309827797143D-02,  -6.979802599340246D-02,   2.031674267230659D-01, &
&    1.532817798475150D-16,  -3.012011224855113D-15,   4.590425696008854D-14, &
&   -7.195360027312050D-13,   1.127682273570096D-11,  -1.702932887451103D-10, &
&    2.448524020509611D-09,  -3.332999487583080D-08,   4.269402438628656D-07, &
&   -5.105423266535321D-06,   5.636117958133057D-05,  -5.649182858103108D-04, &
&    5.001444144552549D-03,  -3.714025922678073D-02,   2.334925365383548D-01, &
&    5.957715540812267D-19,  -1.262043218792325D-17,   2.260554512860461D-16, &
&   -4.354341924046402D-15,   8.544849367145855D-14,  -1.653363101392723D-12, &
&    3.130762615875142D-11,  -5.789970339938642D-10,   1.043408548257357D-08, &
&   -1.828006455378907D-07,   3.104819899806095D-06,  -5.109930224437023D-05, &
&    8.211911761514241D-04,  -1.340445932611743D-02,   2.491470458134028D-01, &
&    2.146262946471549D-14,  -1.607311792266832D-13,   2.062944198809277D-12, &
&   -2.760241203527018D-11,   3.269335327604513D-10,  -3.525454141765621D-09, &
&    3.438948980156969D-08,  -2.996526177932109D-07,   2.297335457988068D-06, &
&   -1.519325771302921D-05,   8.435388627194522D-05,  -3.779344894848983D-04, &
&    1.283156586525348D-03,  -2.941103081215169D-03,   3.424007045205588D-03, &
&    2.122844526763446D-14,  -1.631731749653861D-13,   2.169304222946220D-12, &
&   -3.002519255928700D-11,   3.708702172678173D-10,  -4.200900272217457D-09, &
&    4.339021349207592D-08,  -4.041542483000124D-07,   3.349660399278570D-06, &
&   -2.427224394974656D-05,   1.500760963499592D-04,  -7.639719978611815D-04, &
&    3.022788186676543D-03,  -8.348449718823309D-03,   1.228544546328761D-02, &
&    6.758456313386747D-15,  -5.452713839847076D-14,   7.729415023309110D-13, &
&   -1.138124898254901D-11,   1.516110430437590D-10,  -1.874182868642870D-09, &
&    2.140154866833459D-08,  -2.237400370101728D-07,   2.118313620577593D-06, &
&   -1.790292081127267D-05,   1.323783957185817D-04,  -8.312193744587917D-04, &
&    4.222421324105245D-03,  -1.582347293641862D-02,   3.486776604184501D-02, &
&    7.880382348018448D-16,  -6.850657422952569D-15,   1.069029153101851D-13, &
&   -1.727862375207663D-12,   2.572871140315806D-11,  -3.610244642765826D-10, &
&    4.757548742182468D-09,  -5.849285259191381D-08,   6.655730718214292D-07, &
&   -6.933894168333553D-06,   6.514671401630881D-05,  -5.397493833679417D-04, &
&    3.802575651282835D-03,  -2.118534018000849D-02,   8.319982864133125D-02, &
&    2.756333119800390D-17,  -2.675893633410557D-16,   4.789357100020299D-15, &
&   -8.854656806696283D-14,   1.542027980673323D-12,  -2.577638861670123D-11, &
&    4.126908939915938D-10,  -6.302220257894815D-09,   9.133448510166785D-08, &
&   -1.247607993224645D-06,   1.591159895468794D-05,  -1.867854382827318D-04, &
&    1.970135238756810D-03,  -1.787806505265607D-02,   1.554082184998071D-01, &
&    1.329095164724966D-19,  -1.585997108914017D-18,   3.513406297449733D-17, &
&   -7.925670550337376D-16,   1.764193706632198D-14,  -3.833560899569749D-13, &
&    8.167488916396649D-12,  -1.709683848782405D-10,   3.495526824476989D-09, &
&   -6.988103881938859D-08,   1.361680718322904D-06,  -2.595726844260059D-05, &
&    4.898544763525639D-04,  -9.582984341474918D-03,   2.151582945399614D-01, &
&    1.286274276213876D-15,  -9.710840204632946D-15,   1.259302045850901D-13, &
&   -1.700610038913752D-12,   2.036547580741236D-11,  -2.223450332118485D-10, &
&    2.199212303395413D-09,  -1.946617926283284D-08,   1.519378958963112D-07, &
&   -1.025753664295045D-06,   5.833160962289620D-06,  -2.688247416366214D-05, &
&    9.440456490407965D-05,  -2.254975270498659D-04,   2.765702499312635D-04, &
&    1.373211167048298D-15,  -1.077105672419987D-14,   1.469835167235764D-13, &
&   -2.084296015103774D-12,   2.650575076987185D-11,  -3.103715633126915D-10, &
&    3.329009147996629D-09,  -3.237501730296508D-08,   2.819868930747223D-07, &
&   -2.164399695316285D-06,   1.431514449359437D-05,  -7.893027833090656D-05, &
&    3.439409372164223D-04,  -1.071167871314608D-03,   1.853521581229214D-03, &
&    4.999653004542927D-16,  -4.194055746362279D-15,   6.243601822114476D-14, &
&   -9.624087648693969D-13,   1.352921042764950D-11,  -1.776300886774341D-10, &
&    2.169287437732484D-09,  -2.445028791359067D-08,   2.519291881141486D-07, &
&   -2.343125332045542D-06,   1.932672067765310D-05,  -1.377031313483600D-04, &
&    8.123209347806530D-04,  -3.651326917971051D-03,   1.049419909255116D-02, &
&    7.046553559935711D-17,  -6.507529693796589D-16,   1.092272437243623D-14, &
&   -1.890029165581414D-13,   3.041661524737680D-12,  -4.645247951891983D-11, &
&    6.710744512368235D-10,  -9.120325333185352D-09,   1.157956477904643D-07, &
&   -1.360666525441584D-06,   1.460846709409014D-05,  -1.405607874761923D-04, &
&    1.175546455178603D-03,  -7.977530173865183D-03,   4.326835232460207D-02, &
&    3.160131344570166D-18,  -3.327972643864657D-17,   6.544189327100055D-16, &
&   -1.319477292126281D-14,   2.528532728447189D-13,  -4.681050518959795D-12, &
&    8.340984401056345D-11,  -1.427068309765473D-09,   2.333693347387704D-08, &
&   -3.625029738681270D-07,   5.307764408904336D-06,  -7.231342916045778D-05, &
&    8.970194121559853D-04,  -9.780330385101370D-03,   1.155027822143557D-01, &
&    2.476840479503190D-20,  -2.946716904965047D-19,   6.212289636287570D-18, &
&   -1.774437697234967D-16,   4.409696031897146D-15,  -1.011070355373903D-13, &
&    2.483590333778517D-12,  -5.788338013235568D-11,   1.324244579707799D-09, &
&   -2.997385859364996D-08,   6.605938438355079D-07,  -1.441193304738610D-05, &
&    3.144175548326715D-04,  -7.221596722780649D-03,   1.902127218909891D-01, &
&    7.891911764507698D-17,  -6.019919220653188D-16,   7.911098667660177D-15, &
&   -1.081348419251326D-13,   1.313891365307294D-12,  -1.458368626045000D-11, &
&    1.469786178494290D-10,  -1.329263224948359D-09,   1.063677924601735D-08, &
&   -7.393233854172795D-08,   4.351855679851624D-07,  -2.090550627960518D-06, &
&    7.725391408545884D-06,  -1.968204402776290D-05,   2.632022724395810D-05, &
&    9.400229265721224D-17,  -7.570603316840887D-16,   1.068698212008931D-14, &
&   -1.564398112537973D-13,   2.066620752606519D-12,  -2.527223660787846D-11, &
&    2.847568187028540D-10,  -2.929692807063894D-09,   2.722358053437089D-08, &
&   -2.252131483377730D-07,   1.625908380445447D-06,  -9.945683754875652D-06, &
&    4.915883064318467D-05,  -1.792173214845788D-04,   3.897053432198612D-04, &
&    4.090154849816724D-17,  -3.598374308771384D-16,   5.680889928835540D-15, &
&   -9.253878737983991D-14,   1.387023782302183D-12,  -1.955138617559857D-11, &
&    2.582621195822745D-10,  -3.175813680126165D-09,   3.605108023174010D-08, &
&   -3.737489804870079D-07,   3.484986847127699D-06,  -2.856625901070683D-05, &
&    1.987654970067095D-04,  -1.084907902672301D-03,   4.270783898760490D-03, &
&    7.246749653091605D-18,  -7.162010445107326D-17,   1.301142758852956D-15, &
&   -2.425872288838820D-14,   4.248388089417407D-13,  -7.097998577843437D-12, &
&    1.129438021420828D-10,  -1.705218182845247D-09,   2.422627773783896D-08, &
&   -3.218382999490364D-07,   3.953092400949892D-06,  -4.412519401275161D-05, &
&    4.368974419087843D-04,  -3.560965186661860D-03,   2.704129113650207D-02, &
&    4.260866078961643D-19,  -4.917562621576957D-18,   1.053010802657845D-16, &
&   -2.309353803615770D-15,   4.912229921285214D-14,  -1.001509608521137D-12, &
&    1.975936713197124D-11,  -3.787801642440895D-10,   6.941540678237017D-09, &
&   -1.218462417479149D-07,   2.032698922500068D-06,  -3.178644093764791D-05, &
&    4.574106527579710D-04,  -5.896283387889525D-03,   9.263870351656658D-02, &
&    5.940831357177693D-21,  -7.990415523224125D-21,   1.710828845660139D-18, &
&   -6.516637162663514D-17,   8.348067062314510D-16,  -3.117719709847607D-14, &
&    9.333965353169028D-13,  -2.056388223048028D-11,   5.636971306487730D-10, &
&   -1.413498033465205D-08,   3.466094572929167D-07,  -8.602867979295998D-06, &
&    2.136467269751326D-04,  -5.663335247028072D-03,   1.710356452975474D-01, &
&    4.988306674624484D-18,  -3.856597297519324D-17,   5.157180012267561D-16, &
&   -7.163857234277231D-15,   8.875974606761249D-14,  -1.007574337212632D-12, &
&    1.042022052516662D-11,  -9.710950155892491D-11,   8.049170171549462D-10, &
&   -5.833573481022190D-09,   3.611205695961519D-08,  -1.845372971988715D-07, &
&    7.371911353821363D-07,  -2.079184964255518D-06,   3.228582011298720D-06, &
&    6.912652350795747D-18,  -5.759949321499226D-17,   8.490026540889282D-16, &
&   -1.294669594434181D-14,   1.795565664727763D-13,  -2.320261792543286D-12, &
&    2.782680020617018D-11,  -3.073252133808907D-10,   3.096454888342798D-09, &
&   -2.811841444534326D-08,   2.261542446140110D-07,  -1.570934707457826D-06, &
&    9.063562357272036D-06,  -3.985523407139439D-05,   1.178299299260208D-04, &
&    3.758615960784996D-18,  -3.498459104973188D-17,   5.907420123147300D-16, &
&   -1.026262673893742D-14,   1.655138442462523D-13,  -2.526442006303951D-12, &
&    3.645243210608793D-11,  -4.934424740034850D-10,   6.221293842854806D-09, &
&   -7.258303915500145D-08,   7.706986234896257D-07,  -7.318355249511904D-06, &
&    6.060235794857933D-05,  -3.986501318179950D-04,   2.245837072499457D-03, &
&    8.614988901803395D-19,  -9.199063438596283D-18,   1.796915183548841D-16, &
&   -3.662424194751686D-15,   6.993724969474655D-14,  -1.271498389660316D-12, &
&    2.251858656875692D-11,  -3.775682109726852D-10,   5.970269268087918D-09, &
&   -9.005803623882280D-08,   1.258721286529651D-06,  -1.621337427024929D-05, &
&    1.889246156710712D-04,  -1.806123928824492D-03,   1.935564044523415D-02, &
&    6.902425826179920D-20,  -8.742113453491865D-19,   1.820396965931781D-17, &
&   -4.900637445910594D-16,   1.124778534402042D-14,  -2.390994219890756D-13, &
&    5.457490844882385D-12,  -1.158351642802610D-10,   2.328600339141141D-09, &
&   -4.645193493466377D-08,   8.716798738578107D-07,  -1.546728504863177D-05, &
&    2.550378353542470D-04,  -3.831386832250607D-03,   7.834769975907304D-02, &
&    5.955268126209111D-23,   7.584253784201540D-20,   3.298790461701243D-18, &
&    1.513933626486249D-17,  -1.473946931059977D-16,  -2.732101921648484D-14, &
&    2.120811802123965D-13,  -6.957471892513267D-12,   3.044358950154457D-10, &
&   -6.749692162176676D-09,   1.956752140505329D-07,  -5.458656305968071D-06, &
&    1.517181162266985D-04,  -4.581291617947495D-03,   1.557611947406391D-01, &
&    3.275924054349499D-19,  -2.578199565390143D-18,   3.528343432326399D-17, &
&   -5.009482445199555D-16,   6.373965875391955D-15,  -7.462482800617802D-14, &
&    7.999682540823153D-13,  -7.775835518904541D-12,   6.775315988340161D-11, &
&   -5.214106088666164D-10,   3.472167259150248D-09,  -1.942935144364049D-08, &
&    8.723448140791754D-08,  -2.864744353908676D-07,   5.779030146785092D-07, &
&    5.557666999620008D-19,  -4.830104333898162D-18,   7.511580114496934D-17, &
&   -1.206105936551192D-15,   1.775280551697119D-14,  -2.454446920191909D-13, &
&    3.176461406973747D-12,  -3.816911759411512D-11,   4.234658517875144D-10, &
&   -4.293519833049855D-09,   3.906286034364980D-08,  -3.142276512451881D-07, &
&    2.166490254931881D-06,  -1.152774172018423D-05,   5.063756275963424D-05, &
&    3.989436355434135D-19,  -3.854200250151076D-18,   7.087635713046374D-17, &
&   -1.332462889678023D-15,   2.296810256016978D-14,  -3.848435100380329D-13, &
&    6.131713377386994D-12,  -9.091750735224723D-11,   1.285793753176501D-09, &
&   -1.703431102228205D-08,   2.043547640602300D-07,  -2.266061592732003D-06, &
&    2.238316241292518D-05,  -1.717240685849814D-04,   1.446155045580778D-03, &
&    1.487003156098335D-19,  -1.065968789192680D-18,   2.999696533849052D-17, &
&   -6.943714708219934D-16,   1.229560842424129D-14,  -2.690058378051928D-13, &
&    5.424163872579424D-12,  -9.396094039418248D-11,   1.706746708940588D-09, &
&   -2.957923585980738D-08,   4.543350855472502D-07,  -6.816780951376958D-06, &
&    9.236350230663321D-05,  -1.003760399486648D-03,   1.528355428309484D-02, &
&    3.774830446909793D-20,   1.657826054583014D-19,   5.969788339128148D-18, &
&   -1.662154731004764D-16,   1.626914335550719D-15,  -7.077606712349253D-14, &
&    1.907294369722452D-12,  -3.628850676152575D-11,   8.751503045492400D-10, &
&   -2.006894997265586D-08,   4.048386257723193D-07,  -8.196636678111339D-06, &
&    1.526945283963634D-04,  -2.640560836159689D-03,   6.879205723823698D-02, &
&   -6.186111803792411D-20,  -6.671196955400647D-19,  -2.340060272812490D-18, &
&    1.167544849910849D-16,   2.485707218769316D-15,  -2.083103655054658D-15, &
&   -3.680790986262624D-13,  -1.007919453847422D-11,   1.514745702603357D-10, &
&   -2.540605887613026D-09,   1.293199311747217D-07,  -3.572148892218535D-06, &
&    1.116708044880926D-04,  -3.799556893860334D-03,   1.432498162970504D-01, &
&    2.260063544999952D-20,  -1.821845370000727D-19,   2.573335357758501D-18, &
&   -3.762205418765783D-17,   4.963278522390181D-16,  -6.065786379724023D-15, &
&    6.831910885649312D-14,  -7.037940540359630D-13,   6.578215171288761D-12, &
&   -5.504074031079954D-11,   4.052315819009084D-10,  -2.577930438222832D-09, &
&    1.363281543216928D-08,  -5.415164745843525D-08,   1.700098808597593D-07, &
&    4.841010848351011D-20,  -4.561513716729375D-19,   7.641305579644911D-18, &
&   -1.276401091997527D-16,   2.027938784486790D-15,  -3.066102166182080D-14, &
&    4.283502393861698D-13,  -5.658430978695991D-12,   7.075926856316741D-11, &
&   -8.041230269552465D-10,   8.297770591270275D-09,  -7.961150431721062D-08, &
&    6.580140391649908D-07,  -4.066468564803722D-06,   2.943147903861227D-05, &
&    2.207649078767151D-20,  -5.978881957366136D-19,   1.144071617490760D-17, &
&   -1.680842007286449D-16,   3.765842848072703D-15,  -7.443654319541737D-14, &
&    1.154790046192654D-12,  -1.928894652844838D-11,   3.276367121961691D-10, &
&   -4.672670116419977D-09,   6.223444502003453D-08,  -8.455962589059538D-07, &
&    9.623225340063349D-06,  -8.193826137978156D-05,   1.084433352433669D-03, &
&   -1.064783888682888D-19,  -9.789429780764514D-19,   1.191576796920717D-17, &
&    6.127738130675275D-17,   3.306171947108499D-15,  -9.732591631262758D-14, &
&    1.068095932012533D-12,  -2.465128330474337D-11,   6.393790550882378D-10, &
&   -1.059501183751330D-08,   1.762521087931935D-07,  -3.311694426229281D-06, &
&    4.924691379395113D-05,  -5.944538739106307D-04,   1.295017454403692D-02, &
&   -1.045108156571228D-19,  -9.068833159303964D-19,   5.383340238125153D-18, &
&    1.685530720232818D-16,   1.478383898890117D-15,  -5.407515543397711D-14, &
&    2.360493971395529D-13,  -1.113686500801243D-11,   4.472372735747345D-10, &
&   -8.957073116022385D-09,   1.964565470696605D-07,  -4.753177725229775D-06, &
&    9.627928154824064D-05,  -1.908988002862892D-03,   6.205180128134187D-02, &
&    2.585016266476086D-19,   1.715888414174876D-18,  -1.249339315815262D-17, &
&   -4.204676963735735D-16,  -9.901468773819040D-16,   6.931283487076436D-14, &
&    7.497558684019068D-13,  -9.905108681353900D-12,  -1.069790765092822D-10, &
&   -2.116352875253062D-09,   1.004298403559740D-07,  -2.200124180794134D-06, &
&    8.594454722087771D-05,  -3.212879072479866D-03,   1.327696784736834D-01, &
&    1.695585828828209D-21,  -1.388451278867440D-20,   2.014666715390470D-19, &
&   -3.104294741195318D-18,   4.328928676784601D-17,  -5.553484929120823D-16, &
&    6.665435949644377D-15,  -7.489502418035126D-14,   7.684477707576180D-13, &
&   -7.094431739929476D-12,   5.970804752066441D-11,  -4.550213183057107D-10, &
&    2.885076201410168D-09,  -1.357081097068697D-08,   8.370398894089141D-08, &
&    7.786378857492646D-21,  -4.400460098437602D-20,   6.544583444370552D-19, &
&   -1.723700477326043D-17,   3.002294998140534D-16,  -4.180938655980499D-15, &
&    6.585176052392535D-14,  -1.069918026942967D-12,   1.446141398216682D-11, &
&   -1.734539886263802D-10,   2.169725532785044D-09,  -2.586801736373429D-08, &
&    2.363896257645050D-07,  -1.617099437773005D-06,   2.152292267838631D-05, &
&    5.237128549826856D-20,   1.193963886241656D-19,  -2.045732814209414D-18, &
&   -7.513866207458281D-17,   1.181811948015174D-15,  -6.580223832170778D-15, &
&    2.155343255556930D-13,  -6.446821389497332D-12,   9.563566063371061D-11, &
&   -1.245214062822302D-09,   2.290060842048169D-08,  -3.850806525524258D-07, &
&    4.430223215263982D-06,  -4.180539542163436D-05,   9.065050000553847D-04, &
&    2.063762893465784D-19,   1.253247256355790D-18,  -1.513585636791481D-17, &
&   -2.862261392316183D-16,   2.879763352565704D-15,   2.922057488848316D-14, &
&    1.288807760298757D-13,  -1.750988100952029D-11,   2.364850068813194D-10, &
&   -2.890602435147983D-09,   8.399514356289954D-08,  -1.865302641930325D-06, &
&    2.676488569179464D-05,  -3.728238257983335D-04,   1.153273872741484D-02, &
&    1.529112800257813D-19,   1.389726540471609D-18,  -1.220351978789051D-17, &
&   -2.755880604022230D-16,   1.965228725370374D-15,   3.993340524562115D-14, &
&   -2.170716677249049D-14,  -1.412599474494867D-11,   1.934952677394140D-10, &
&   -3.059936279788239D-09,   1.119848594253161D-07,  -2.991425737040701D-06, &
&    6.217867237012053D-05,  -1.441461838395145D-03,   5.707705370184174D-02, &
&   -4.040253412376090D-19,  -2.895515856137441D-18,   3.262264837139526D-17, &
&    5.652917162546172D-16,  -4.335838010782056D-15,  -1.029156593251801D-13, &
&    6.082070872719386D-13,   1.674059149334571D-11,  -3.221447071872403D-11, &
&   -4.276554525658840D-09,   5.079343234355134D-08,  -1.257569439493386D-06, &
&    7.083469789087101D-05,  -2.746815631248607D-03,   1.238526658690002D-01, &
&    1.072623508306717D-22,  -1.209110350037730D-21,   2.011479750467005D-20, &
&   -2.873741365905523D-19,   3.981652533204627D-18,  -5.863730440033418D-17, &
&    8.138664540844354D-16,  -9.767823970112032D-15,   1.055348533004043D-13, &
&   -1.130755505206915D-12,   1.195471178843110D-11,  -1.089813334800881D-10, &
&    7.525004977340176D-10,  -4.141806763230405D-09,   6.021537277834006D-08, &
&   -1.452445376095829D-21,  -1.450245394286490D-20,   3.177640148143231D-19, &
&   -1.555488209366569D-18,   1.083523460125780D-17,  -7.803283263731252D-16, &
&    1.821697364656279D-14,  -2.311903617594465D-13,   2.638436118130412D-12, &
&   -4.494001984772164D-11,   7.898255788749644D-10,  -9.963571285928421D-09, &
&    8.710808558089424D-08,  -7.165373307221625D-07,   1.824286017902665D-05, &
&   -2.870162972833646D-20,  -2.214039599963422D-19,   3.768416918431221D-18, &
&    1.708987716610805D-17,  -4.883622966343747D-16,  -4.912827897752471D-15, &
&    1.836806988941286D-13,  -1.646473441239145D-12,   1.091785803144020D-11, &
&   -4.377829128228841D-10,   1.218522369275795D-08,  -1.862218363873116D-07, &
&    1.952366063080929D-06,  -2.354217747760647D-05,   8.121729669479357D-04, &
&   -1.184780757068620D-19,  -1.211871062821629D-18,   1.644080441675616D-17, &
&    1.446906893221207D-16,  -3.111904083192809D-15,  -1.724052070766354D-14, &
&    7.480808429602321D-13,  -3.977247490096846D-12,  -1.917875119822178D-11, &
&   -1.381487773025454D-09,   5.785013832899656D-08,  -1.035500533030748D-06, &
&    1.393585024929827D-05,  -2.544371181396858D-04,   1.061102487840458D-02, &
&   -7.871541332563255D-20,  -1.172815429409116D-18,   1.306633608749137D-17, &
&    1.557699488583046D-16,  -2.859901833246401D-15,  -1.663540870536242D-14, &
&    6.593509492097845D-13,  -2.916927446544579D-12,  -1.729158286649022D-11, &
&   -1.851013775203201D-09,   8.004510147154281D-08,  -1.856217408747573D-06, &
&    4.064281153003957D-05,  -1.138091005163050D-03,   5.323994582378051D-02, &
&    2.298091376514456D-19,   2.589603305930867D-18,  -3.282820235654139D-17, &
&   -3.356670564362848D-16,   6.947756326051736D-15,   2.693070125014023D-14, &
&   -1.287434654008149D-12,   5.197638429883200D-13,   2.363493964531144D-10, &
&   -1.874562154899508D-09,  -1.790938574497779D-09,  -1.001350082373603D-06, &
&    6.115475284560613D-05,  -2.351965553437267D-03,   1.162188668941111D-01, &
&    1.863030647054872D-23,  -7.546709255089221D-23,   8.992454788529608D-22, &
&   -2.865190781811311D-20,   6.129787429729137D-19,  -8.976262006661725D-18, &
&    1.039335328953913D-16,  -1.237930093594811D-15,   1.817490054261148D-14, &
&   -2.709316670272001D-13,   3.283780181587854D-12,  -2.970613277491072D-11, &
&    2.032244747349871D-10,  -1.620712080565997D-09,   5.237347070061384D-08, &
&    7.134121156826116D-22,   3.042885227145998D-21,  -8.000184489391198D-20, &
&   -2.312227304061111D-19,   2.317237748177393D-17,  -3.253861252753066D-16, &
&    1.876054935718038D-15,  -1.430781547459657D-14,   7.610325761315161D-13, &
&   -2.102441988543816D-11,   3.341530553745008D-10,  -3.558590128015810D-09, &
&    3.029156950698611D-08,  -3.928633910603469D-07,   1.666278245314160D-05, &
&    1.028410709890225D-20,   8.293795413729732D-20,  -1.799158709361435D-18, &
&   -7.321943214559778D-19,   3.673451462911453D-16,  -4.284115647136788D-15, &
&   -6.377922899965050D-15,   4.160946962094196D-13,   6.564811459618135D-12, &
&   -3.449085251994859D-10,   6.373277018750686D-09,  -7.607125218756189D-08, &
&    8.242809884080566D-07,  -1.570690773695518D-05,   7.549758038190312D-04, &
&    4.332975441158360D-20,   4.635570927420351D-19,  -9.155594137431486D-18, &
&   -5.687398788786969D-18,   1.828165427274339D-15,  -1.897406272527833D-14, &
&   -1.107362759744477D-13,   3.550525252830231D-12,   1.565163008182974D-11, &
&   -1.648982384515926D-09,   3.415463505738733D-08,  -4.787544469048078D-07, &
&    7.336847105605437D-06,  -1.931289005616651D-04,   9.949509559038987D-03, &
&    3.120593816053657D-20,   4.354875549492586D-19,  -7.886242488958430D-18, &
&   -1.042378762580949D-17,   1.657649880721630D-15,  -1.626840223185041D-14, &
&   -1.186736338954201D-13,   3.330044600895926D-12,   2.263219668046612D-11, &
&   -1.997576077863161D-09,   5.011653197590820D-08,  -1.072468524688375D-06, &
&    2.773512785048010D-05,  -9.364867813808145D-04,   5.014735897610354D-02, &
&   -8.508210004204802D-20,  -9.915376648987604D-19,   1.910126809064107D-17, &
&    1.194482380358869D-17,  -3.730997776057456D-15,   3.571283625760874D-14, &
&    3.523976144342603D-13,  -1.069652929852369D-11,   5.368198334217003D-11, &
&    1.087635041885055D-09,  -3.228053268711027D-09,  -1.076949919806447D-06, &
&    5.180702050055221D-05,  -2.012698691448925D-03,   1.096858918294952D-01, &
&   -5.084121687659676D-25,  -1.427885689362163D-23,   4.342838844542040D-22, &
&   -6.543595804020208D-21,   6.537956819936746D-20,  -6.006799059474798D-19, &
&    1.124640529412836D-17,  -2.887211109686170D-16,   5.731528255297610D-15, &
&   -8.299839882070172D-14,   8.937314190835643D-13,  -7.381791134044544D-12, &
&    5.737503034235488D-11,  -9.369359137400034D-10,   4.874951787066991D-08, &
&   -1.879211891526096D-22,  -3.885048749809970D-22,   3.017123755701414D-20, &
&   -4.079353015698464D-19,   1.188416366217531D-18,   4.141452630787360D-17, &
&   -3.157689658216744D-16,  -1.534298812721695D-14,   5.273862683428352D-13, &
&   -9.271793878105683D-12,   1.118672418595998D-10,  -1.059387840004369D-09, &
&    1.150259205630789D-08,  -2.785678119272591D-07,   1.568322263356163D-05, &
&   -3.718285164734132D-21,  -6.484313025794280D-21,   5.618019832255587D-19, &
&   -7.116336634964925D-18,  -2.845372468207814D-18,   1.422449173346013D-15, &
&   -1.672855025343025D-14,  -1.705366442515255D-13,   9.328334291441992D-12, &
&   -1.814413019084587D-10,   2.363135073658405D-09,  -2.616858166988871D-08, &
&    4.004055925150375D-07,  -1.225512064646895D-05,   7.136576987129641D-04, &
&   -1.828412102725279D-20,  -3.582467050497853D-20,   2.853831286572571D-18, &
&   -3.514836957678138D-17,  -5.964871914048624D-17,   8.471433144508605D-15, &
&   -1.085471087102859D-13,  -5.655833514691414D-13,   4.563209767347236D-11, &
&   -9.584217983882097D-10,   1.393318262796907D-08,  -2.010149835071379D-07, &
&    4.461068639041055D-06,  -1.589751041574969D-04,   9.425612111958060D-03, &
&   -1.538454360341859D-20,  -3.544723245479810D-20,   2.533503502467650D-18, &
&   -3.079284123875907D-17,  -6.761061144368957D-17,   7.899215238327845D-15, &
&   -1.010107706254348D-13,  -6.081095536502334D-13,   4.932183645978980D-11, &
&   -1.217754142945053D-09,   2.541181741798709D-08,  -6.314029684074764D-07, &
&    2.029110078718985D-05,  -7.943818370698677D-04,   4.756215493604968D-02, &
&    3.767737810366456D-20,   7.657184381426665D-20,  -5.931077936964805D-18, &
&    7.193594551888177D-17,   1.771318855632834D-16,  -1.935854821293877D-14, &
&    2.750207234654186D-13,  -1.898927222746116D-13,  -5.474640145211038D-11, &
&    7.283506449576862D-10,   1.279981735902648D-08,  -1.013056874506774D-06, &
&    4.225343142153198D-05,  -1.730811089704100D-03,   1.040850026607679D-01, &
&    5.194769337689182D-25,  -3.536424926805682D-24,   2.063058059050231D-23, &
&    5.654034095525647D-23,  -1.130408157049250D-22,  -1.378426322998567D-19, &
&    5.132408094717804D-18,  -1.117298301226098D-16,   1.753234532942532D-15, &
&   -2.110204260132403D-14,   2.015270591198991D-13,  -1.722415615234219D-12, &
&    2.247727018161692D-11,  -7.220314933866200D-10,   4.631161239914947D-08, &
&    4.887057826637174D-23,  -3.118751833157205D-22,  -1.605981334442360D-23, &
&    6.835951567915912D-20,  -1.244724493425645D-18,   2.538197734709614D-18, &
&    3.978223879510050D-16,  -1.185440444219277D-14,   2.109946182062605D-13, &
&   -2.753113736467780D-12,   2.893939254761167D-11,  -3.119255498814284D-10, &
&    6.064857631811327D-09,  -2.291415636387938D-07,   1.492959692079321D-05, &
&    9.457425173293332D-22,  -6.014796290731527D-21,  -8.587132771421823D-21, &
&    1.673611336346020D-18,  -3.257157022070456D-17,   1.883635024124081D-16, &
&    6.188667352644114D-15,  -2.228924510207615D-13,   4.228040017018233D-12, &
&   -5.827172487689897D-11,   6.844155000837179D-10,  -9.733668148298033D-09, &
&    2.537361383205118D-07,  -1.036498625518521D-05,   6.799431035856582D-04, &
&    4.790359723473065D-21,  -3.059302068286883D-20,  -5.443379300270671D-20, &
&    9.127693351487162D-18,  -1.833072662216147D-16,   1.290582901321920D-15, &
&    2.734121592932767D-14,  -1.114657226065222D-12,   2.226342226218991D-11, &
&   -3.328469858905533D-10,   4.800248982115276D-09,  -9.803791478144861D-08, &
&    3.196514255035967D-06,  -1.364572565172999D-04,   8.984336179055590D-03, &
&    4.196661721187094D-21,  -2.701233703503514D-20,  -4.886654861672539D-20, &
&    8.263090021893906D-18,  -1.687727193325333D-16,   1.238320589551732D-15, &
&    2.542152626963681D-14,  -1.122365942212895D-12,   2.582963623385393D-11, &
&   -5.277551543042097D-10,   1.287303039688007D-08,  -4.120814149413799D-07, &
&    1.570725710496411D-05,  -6.873643478491300D-04,   4.534637800494966D-02, &
&   -9.956572646082316D-21,   6.349782678168240D-20,   1.266900494701595D-19, &
&   -1.964616531772369D-17,   4.036445883734060D-16,  -3.336173448467187D-15, &
&   -3.781291038283961D-14,   1.713622495555842D-12,  -2.558647838971187D-11, &
&   -4.845716980439336D-11,   1.718369008023711D-08,  -8.213503302794003D-07, &
&    3.396047742143784D-05,  -1.503042724989864D-03,   9.924667263151691D-02, &
&    2.039469799957247D-27,   2.464238330840277D-25,  -4.642442634011428D-24, &
&   -8.467327828619060D-24,   2.689869376793153D-21,  -8.782978983396825D-20, &
&    1.872841721620727D-18,  -3.051860878262536D-17,   3.983937620141892D-16, &
&   -4.277125759598021D-15,   4.103908365310238D-14,  -5.117973141058300D-13, &
&    1.381444951388020D-11,  -6.183867403370500D-10,   4.431356875048996D-08, &
&   -9.524263418924619D-25,   5.372719003046304D-23,  -1.195915766739149D-21, &
&    1.157831820590621D-20,   1.399026459561658D-19,  -8.754908515581402D-18, &
&    2.198956438954330D-16,  -3.891787608755893D-15,   5.392318158634755D-14, &
&   -6.229753161211607D-13,   7.114120562550756D-12,  -1.267900602918438D-10, &
&    4.280803638072938D-09,  -1.989099190139266D-07,   1.429013953073053D-05, &
&   -1.959761155583801D-23,   1.178612772420738D-21,  -2.785723164783173D-20, &
&    3.232083414194494D-19,   1.280118377033214D-18,  -1.577761358739328D-16, &
&    4.311222280116089D-15,  -7.958904502328014D-14,   1.150078052486274D-12, &
&   -1.448791291943509D-11,   2.074938419967366D-10,  -5.024979043440658D-09, &
&    1.914911097915063D-07,  -9.049920545808056D-06,   6.509128761007268D-04, &
&   -9.265119122561469D-23,   6.175302519792959D-21,  -1.506972007255181D-19, &
&    1.871270199204614D-18,   2.617685468848516D-18,  -7.603823662851727D-16, &
&    2.192360675651714D-14,  -4.201356700740040D-13,   6.481271851648543D-12, &
&   -9.665280867674292D-11,   1.932395956153696D-09,  -6.111663754942063D-08, &
&    2.505494735962474D-06,  -1.195142746793425D-04,   8.601407940250955D-03, &
&   -7.144942669649947D-23,   5.470248496048977D-21,  -1.368740382141583D-19, &
&    1.760701495431323D-18,   8.843041652134459D-19,  -6.897055481325046D-16, &
&    2.134864994974079D-14,  -4.636403746510297D-13,   9.444076721057598D-12, &
&   -2.316374637769743D-10,   7.544871101021282D-09,  -2.939509812310898D-07, &
&    1.257740479401354D-05,  -6.030380349761227D-04,   4.341545510590301D-02, &
&    1.918845049883228D-22,  -1.301320470427501D-20,   3.216247422742812D-19, &
&   -4.155485518943080D-18,   2.193539615300026D-18,   1.346966258352447D-15, &
&   -3.752337316357014D-14,   5.724634142615992D-13,  -1.822726115505827D-12, &
&   -2.577430660596969D-10,   1.435402409724497D-08,  -6.290987810305546D-07, &
&    2.745988174893132D-05,  -1.319649457818798D-03,   9.502237720010549D-02, &
&   -6.765339814236504D-27,   2.665071597978444D-26,   9.098991083932569D-25, &
&   -4.542759533784579D-23,   1.257328570102414D-21,  -2.610256171654124D-20, &
&    4.387397980488336D-19,  -6.137597614775408D-18,   7.283623178958158D-17, &
&   -7.828395957060487D-16,   1.014915408303509D-14,  -2.548691523585984D-13, &
&    1.062995596759713D-11,  -5.461653672179418D-10,   4.257143927091872D-08, &
&   -1.325489754908551D-24,   9.231033190433778D-24,   7.401982927075938D-24, &
&   -4.180287294392585D-21,   1.442746732031937D-19,  -3.290658748122534D-18, &
&    5.856421866227054D-17,  -8.578483343920631D-16,   1.081147667937337D-14, &
&   -1.339616594203174D-13,   2.376726755448633D-12,  -7.690194364484430D-11, &
&    3.405158242351529D-09,  -1.760702853961211D-07,   1.372897061439774D-05, &
&   -2.959699598338104D-23,   2.287688116726610D-22,  -7.172951092221855D-22, &
&   -7.100458205062192D-20,   2.781134808033664D-18,  -6.643536146143675D-17, &
&    1.218776677947933D-15,  -1.848004118515760D-14,   2.506580584836966D-13, &
&   -3.772295207738897D-12,   9.019217854764010D-11,  -3.393968380413197D-09, &
&    1.546266446618699D-07,  -8.018769397072311D-06,   6.253648361015303D-04, &
&   -1.574430061317280D-22,   1.274060039287687D-21,  -5.947939656924641D-21, &
&   -3.269029042161020D-19,   1.389162982258993D-17,  -3.422637794545097D-16, &
&    6.467840188664266D-15,  -1.038062518564915D-13,   1.633126417174741D-12, &
&   -3.342932894862504D-11,   1.062916416593514D-09,  -4.406390404769406D-08, &
&    2.039818845051287D-06,  -1.059542552328951D-04,   8.263901392362754D-03, &
&   -1.417961613762032D-22,   1.183978901869474D-21,  -6.541335023300508D-21, &
&   -2.751340283171917D-19,   1.258709649199730D-17,  -3.292265043865992D-16, &
&    6.975384749127209D-15,  -1.448832772693192D-13,   3.662825092568295D-12, &
&   -1.235786403952687D-10,   5.008083220818762D-09,  -2.202246077612304D-07, &
&    1.028621865633288D-05,  -5.347775124395897D-04,   4.171216181182624D-02, &
&    3.324332152501808D-22,  -2.741863560045648D-21,   1.503666720163377D-20, &
&    6.020890327227524D-19,  -2.633376168622414D-17,   6.151449837919981D-16, &
&   -9.513922856876748D-15,   5.141895488885222D-14,   3.540319377073901D-12, &
&   -2.261555913969656D-10,   1.060948066091392D-08,  -4.798395798650563D-07, &
&    2.250356341514135D-05,  -1.170430300647740D-03,   9.129468184276454D-02, &
&    3.429635685653001D-28,  -1.660848909057497D-26,   5.803921943976244D-25, &
&   -1.473537728627084D-23,   3.037286185649818D-22,  -5.284367236055240D-21, &
&    7.881269776164120D-20,  -1.022784738821163D-18,   1.223543828082333D-17, &
&   -1.714845625228083D-16,   4.290643152536213D-15,  -1.769465462953400D-13, &
&    8.737223258573409D-12,  -4.884068100171093D-10,   4.102240526349781D-08, &
&   -4.472887196099118D-26,  -1.359402034157875D-24,   6.547735035999367D-23, &
&   -1.842668879537885D-21,   4.033840314586291D-20,  -7.318718442903587D-19, &
&    1.132919032186726D-17,  -1.549461724516948D-16,   2.101453656393607D-15, &
&   -3.903752955740736D-14,   1.266663937089394D-12,  -5.640267182006123D-11, &
&    2.814947204218983D-09,  -1.575010148010673D-07,   1.322949612481046D-05, &
&   -1.632022862458908D-24,  -2.084587736389088D-23,   1.244924216911602D-21, &
&   -3.691570325512909D-20,   8.325179049220830D-19,  -1.546452170492108D-17, &
&    2.467482326464202D-16,  -3.609239315421276D-15,   5.841634969824464D-14, &
&   -1.442050819415209D-12,   5.523357642742798D-11,  -2.555035029449562D-09, &
&    1.281634237254835D-07,  -7.174144642229077D-06,   6.026150686188634D-04, &
&   -1.028886163225487D-23,  -8.812386767410288D-23,   6.142081679176328D-21, &
&   -1.881676303431819D-19,   4.335481891171839D-18,  -8.262326871914132D-17, &
&    1.390234239607344D-15,  -2.337025424768395D-14,   5.054567401083025D-13, &
&   -1.662893824384052D-11,   7.119282043085907D-10,  -3.365961298098903D-08, &
&    1.693178612493851D-06,  -9.480186463565338D-05,   7.963286243747309D-03, &
&   -1.032957536035374D-23,  -6.664650579463705D-23,   5.366926341881305D-21, &
&   -1.713865217265276D-19,   4.165854329041981D-18,  -8.863549351860772D-17, &
&    1.916055157533243D-15,  -5.105213746089667D-14,   1.813061974282621D-12, &
&   -7.717063564860304D-11,   3.543158867753344D-09,  -1.696047538643064D-07, &
&    8.545098305843403D-06,  -4.785107353215233D-04,   4.019483719645367D-02, &
&    2.306756250309182D-23,   1.601645742342987D-22,  -1.209149490615301D-20, &
&    3.662668233031013D-19,  -7.963814888849196D-18,   1.250938904877957D-16, &
&   -7.909685204674622D-16,  -4.606417530615258D-14,   3.240954621448654D-12, &
&   -1.622175027116429D-10,   7.704997430688716D-09,  -3.709202921273020D-07, &
&    1.870126816397867D-05,  -1.047305068645241D-03,   8.797377439661574D-02, &
&    3.952580492645730D-28,  -5.949756803176265D-27,   1.426130944968058D-25, &
&   -3.000717842901393D-24,   5.426703899451416D-23,  -8.602184807523863D-22, &
&    1.211755955180928D-20,  -1.604173283316967D-19,   2.478548190479846D-18, &
&   -6.480897807178599D-17,   2.726228415898160D-15,  -1.363699988207265D-13, &
&    7.341013471388253D-12,  -4.403533507970821D-10,   3.963135526886042D-08, &
&    4.325134218202895D-26,  -7.374829220036352D-25,   1.893968642659851D-23, &
&   -4.148259612499065D-22,   7.747954050309913D-21,  -1.267527319535178D-19, &
&    1.874387095791193D-18,  -2.793267914567156D-17,   5.606083937306268D-16, &
&   -1.888524584551876D-14,   8.652388446647368D-13,  -4.390236843454894D-11, &
&    2.367129232958396D-09,  -1.420107791088005D-07,   1.278089910187112D-05, &
&    8.050595214990007D-25,  -1.466997949071662D-23,   3.897236673629062D-22, &
&   -8.712679155293019D-21,   1.659376744730084D-19,  -2.792531973566957D-18, &
&    4.409637389616163D-17,  -7.786033606523522D-16,   2.049156925116181D-14, &
&   -8.169565023812589D-13,   3.910836206213341D-11,  -1.998109790894369D-09, &
&    1.078179551987408D-07,  -6.468698550604341D-06,   5.821812791111337D-04, &
&    3.909652387832011D-24,  -7.425168456018761D-23,   2.015426725448762D-21, &
&   -4.580229305861774D-20,   8.934100033656804D-19,  -1.585347382215480D-17, &
&    2.874226352313362D-16,  -6.718362028993478D-15,   2.339614738717081D-13, &
&   -1.047712343580462D-11,   5.145450356682400D-10,  -2.639156942720800D-08, &
&    1.424714247974707D-06,  -8.548081109945233D-05,   7.693264398242891D-03, &
&    3.325713574387245D-24,  -6.590545122542396D-23,   1.850593704079637D-21, &
&   -4.425672646930215D-20,   9.656444074054256D-19,  -2.209917661575319D-17, &
&    6.322536307378365D-16,  -2.395293031270911D-14,   1.077672863237066D-12, &
&   -5.198602324737738D-11,   2.590798809083356D-09,  -1.331763085716288D-07, &
&    7.191125575669645D-06,  -4.314656548563319D-04,   3.883190101140729D-02, &
&   -7.800093162443855D-24,   1.489445012437024D-22,  -3.967130296494482D-21, &
&    8.468868040375159D-20,  -1.349174898113930D-18,   8.490987256094049D-18, &
&    5.772387570498179D-16,  -4.258111073167210D-14,   2.256328907038629D-12, &
&   -1.128890982306899D-10,   5.664087401667154D-09,  -2.914452201117543D-07, &
&    1.573895106946610D-05,  -9.443413834744892D-04,   8.499074270098191D-02, &
&    1.006064185203024D-28,  -1.222098633787343D-27,   2.522868154709535D-26, &
&   -4.827734007993762D-25,   8.118477512753285D-24,  -1.234671562850343D-22, &
&    1.801876096616331D-21,  -3.106048788807309D-20,   8.769299069519728D-19, &
&   -3.845268503647543D-17,   1.986008716313634D-15,  -1.084806853382530D-13, &
&    6.245787096906697D-12,  -3.997181095755754D-10,   3.837288894500475D-08, &
&    1.331384760892652D-26,  -1.688237891417273D-25,   3.604721915417010D-24, &
&   -7.072064448024648D-23,   1.223049368285607D-21,  -1.950831940295458D-20, &
&    3.204395617493957D-19,  -7.095971815655444D-18,   2.546114368250570D-16, &
&   -1.217074141193900D-14,   6.389323552805015D-13,  -3.497623439164227D-11, &
&    2.014200581145045D-09,  -1.289068689604009D-07,   1.237505141671610D-05, &
&    2.729585586737617D-25,  -3.536219626275541D-24,   7.685913922843451D-23, &
&   -1.533297839298498D-21,   2.727143631894791D-20,  -4.655740056179026D-19, &
&    9.065579043999489D-18,  -2.602473233565265D-16,   1.098117264097952D-14, &
&   -5.492928747669953D-13,   2.906932744526338D-11,  -1.593012771370825D-09, &
&    9.174788555884656D-08,  -5.871820410194550D-06,   5.636945788269933D-04, &
&    1.405215176757045D-24,  -1.846934146615501D-23,   4.076939998576245D-22, &
&   -8.326921090174461D-21,   1.566428131844209D-19,  -3.087970275185928D-18, &
&    7.935310089428290D-17,  -2.974655191557681D-15,   1.405310200125998D-13, &
&   -7.220559794211770D-12,   3.838777879898032D-10,  -2.104954449052480D-08, &
&    1.212401550972505D-06,  -7.759345928269747D-05,   7.448971110492868D-03, &
&    1.262946232853212D-24,  -1.709128874847818D-23,   3.985716103242807D-22, &
&   -9.169275915642042D-21,   2.255104775832574D-19,  -7.032987354018669D-18, &
&    2.870356921810525D-16,  -1.370522525860627D-14,   6.963643998484020D-13, &
&   -3.633763267417128D-11,   1.936888128715543D-09,  -1.062439651582244D-07, &
&    6.119604257924919D-06,  -3.916544508647183D-04,   3.759882637578955D-02, &
&   -2.843194610803614D-24,   3.649581821107406D-23,  -7.493646106943963D-22, &
&    1.219728828789568D-20,  -6.350979970515283D-20,  -6.933781281104715D-18, &
&    5.156652763837837D-16,  -2.869457006570580D-14,   1.511199174034135D-12, &
&   -7.942346935576285D-11,   4.238492578445924D-09,  -2.325303923689236D-07, &
&    1.339386103061283D-05,  -8.572076138273100D-04,   8.229193300389599D-02, &
&    1.778077128315013D-29,  -1.953362004658908D-28,   3.705581838996931D-27, &
&   -6.717490759522274D-26,   1.099787813828457D-24,  -1.766663911030030D-23, &
&    3.430943090616994D-22,  -1.069197963936641D-20,   4.961437325673239D-19, &
&   -2.670370300055743D-17,   1.505651173232426D-15,  -8.770517637945564D-14, &
&    5.367259161103550D-12,  -3.649723042659225D-10,   3.722716982549984D-08, &
&    2.547704891777723D-27,  -2.859184499040653D-26,   5.553452509120316D-25, &
&   -1.032844231661315D-23,   1.776654220470720D-22,  -3.230058404473143D-21, &
&    8.016153787044895D-20,  -3.117862289977331D-18,   1.569114253850400D-16, &
&   -8.587255777648239D-15,   4.854037122176234D-13,  -2.828361606125142D-11, &
&    1.730909162382596D-09,  -1.177016085892919D-07,   1.200556322463990D-05, &
&    5.419411055065048D-26,  -6.166241776175332D-25,   1.218556747612660D-23, &
&   -2.333148862724539D-22,   4.320996264336018D-21,  -9.371172030218148D-20, &
&    2.982080248513417D-18,  -1.346789531912621D-16,   7.077924707412218D-15, &
&   -3.905995510941550D-13,   2.210688456683948D-11,  -1.288324531698650D-09, &
&    7.884437434820702D-08,  -5.361412599775862D-06,   5.468640658467711D-04, &
&    2.856310591491958D-25,  -3.295135734703095D-24,   6.687894853373949D-23, &
&   -1.362081709793492D-21,   2.946617282396811D-20,  -8.437146808351293D-19, &
&    3.442556154146100D-17,  -1.724718765636622D-15,   9.300763288103187D-14, &
&   -5.157373268325060D-12,   2.921045034674689D-10,  -1.702448345966453D-08, &
&    1.041892480738836D-06,  -7.084866225695198D-05,   7.226563444816446D-03, &
&    2.670771034469431D-25,  -3.264380039067104D-24,   7.610589292879974D-23, &
&   -2.066585461513430D-21,   7.110606976998348D-20,  -3.144831197325972D-18, &
&    1.596454755935017D-16,  -8.549070174696542D-15,   4.679620664990698D-13, &
&   -2.601984390943339D-11,   1.474322559660200D-09,  -8.593098603204176D-08, &
&    5.258970877878410D-06,  -3.576099951923743D-04,   3.647621941178414D-02, &
&   -5.632616749154105D-25,   5.983050601021404D-24,  -9.131210322934992D-23, &
&    2.345716717148486D-22,   7.860638489218339D-20,  -5.775093761071355D-18, &
&    3.353387262572208D-16,  -1.855489934522593D-14,   1.022724044977535D-12, &
&   -5.693707793891171D-11,   3.226744631819314D-09,  -1.880753088642007D-07, &
&    1.151022141219421D-05,  -7.826951120375266D-04,   7.983490165124545D-02, &
&    2.608289865527471D-30,  -2.678546059298967D-29,   4.835112058321450D-28, &
&   -8.678511469048091D-27,   1.538112410896265D-25,  -3.397749717854509D-24, &
&    1.185433851764663D-22,  -5.875251239824319D-21,   3.311307593875428D-19, &
&   -1.940553156114304D-17,   1.163505389012811D-15,  -7.179927328426494D-14, &
&    4.652561867357058D-12,  -3.349843197789145D-10,   3.617830601439846D-08, &
&    3.893825933632620D-28,  -4.085831374098870D-27,   7.587537618051607D-26, &
&   -1.436217834027432D-24,   2.911010586496401D-23,  -8.195172516055851D-22, &
&    3.491759954255459D-20,  -1.859820261595048D-18,   1.064689646469031D-16, &
&   -6.255705580427698D-15,   3.752083992869179D-13,  -2.315480098231222D-11, &
&    1.500426021242041D-09,  -1.080306513788517D-07,   1.166731026273829D-05, &
&    8.488935305418703D-27,  -9.055919979131464D-26,   1.740883966263409D-24, &
&   -3.579375470431756D-23,   8.741977686645327D-22,  -3.116406494243598D-20, &
&    1.515778871097961D-18,  -8.392046271886585D-17,   4.842418080712064D-15, &
&   -2.848955290875348D-13,   1.709070473909300D-11,  -1.054719844194271D-09, &
&    6.834573041870607D-08,  -4.920892085617523D-06,   5.314563432793851D-04, &
&    4.574652384526162D-26,  -5.021640990789917D-25,   1.040655306457052D-23, &
&   -2.536910426140479D-22,   8.183404999506351D-21,  -3.655440353717599D-19, &
&    1.946600691587630D-17,  -1.102929325271791D-15,   6.393441184328068D-14, &
&   -3.764326731755389D-12,   2.258431454286196D-10,  -1.393763516566441D-08, &
&    9.031581287582700D-07,  -6.502738251431175D-05,   7.022957300783299D-03, &
&    4.630297591262898D-26,  -5.927007051577131D-25,   1.709134130562454D-23, &
&   -6.608848919731413D-22,   3.174814836050495D-20,  -1.713304597440156D-18, &
&    9.664242754069519D-17,  -5.549738150074216D-15,   3.225492861200253D-13, &
&   -1.899924427291548D-11,   1.139939415698989D-09,  -7.035044177712854D-08, &
&    4.558708042063787D-06,  -3.282269764652658D-04,   3.544851344822726D-02, &
&   -8.076509751731649D-26,   6.249149863738169D-25,   2.223384980046804D-24, &
&   -8.297867164858484D-22,   5.995329417120449D-20,  -3.618170105748527D-18, &
&    2.099050764919672D-16,  -1.212925156357268D-14,   7.057967091727167D-13, &
&   -4.158205810077280D-11,   2.494958346967213D-09,  -1.539748122423388D-07, &
&    9.977569168973016D-06,  -7.183849860124823D-04,   7.758557851218592D-02, &
&    3.673321143105271D-31,  -3.362893019062795D-30,   5.990469250033107D-29, &
&   -1.207037884249601D-27,   3.067376516579202D-26,  -1.207055228235706D-24, &
&    6.416378064319388D-23,  -3.795025276752047D-21,   2.318132637965085D-19, &
&   -1.440387125349643D-17,   9.121596402837823D-16,  -5.942011438278314D-14, &
&    4.064332737567459D-12,  -3.088892749055503D-10,   3.521337728914539D-08, &
&    5.194849610129401D-29,  -5.314646815284631D-28,   1.025624468591733D-26, &
&   -2.383291009961993D-25,   7.686616953857949D-24,  -3.603312178453448D-22, &
&    2.035390735158668D-20,  -1.220385193677771D-18,   7.472731195603134D-17, &
&   -4.644933795241249D-15,   2.941651101212751D-13,  -1.916266170634406D-11, &
&    1.310725550093712D-09,  -9.961513962300820D-08,   1.135612590867319D-05, &
&    1.163477001850416D-27,  -1.238017147586393D-26,   2.643709899137568D-25, &
&   -7.471956788573434D-24,   3.001757718767794D-22,  -1.575133588133111D-20, &
&    9.193221060805859D-19,  -5.550838310469971D-17,   3.403162943129828D-15, &
&   -2.115752444282081D-13,   1.339944639177062D-11,  -8.728760782765365D-10, &
&    5.970471208751400D-08,  -4.537558068644652D-06,   5.172816196339444D-04, &
&    6.549219088221096D-27,  -7.587544899580483D-26,   1.977513832044505D-24, &
&   -7.329012341480342D-23,   3.588826163365439D-21,  -2.031123233692067D-19, &
&    1.208870154573682D-17,  -7.328947755582297D-16,   4.496562681495501D-14, &
&   -2.795828551982993D-12,   1.770674000484229D-10,  -1.153466462803809D-08, &
&    7.889709967017123D-07,  -5.996179547527339D-05,   6.835644683130144D-03, &
&    8.195287456161584D-27,  -1.349268144650170D-25,   5.674801967733779D-24, &
&   -2.973813008465996D-22,   1.703377890972125D-20,  -1.010767509957848D-18, &
&    6.084608951584469D-17,  -3.697501468309303D-15,   2.269485476913336D-13, &
&   -1.411187301867745D-11,   8.937503395762722D-10,  -5.822143978963879D-08, &
&    3.982346422123949D-06,  -3.026583278258155D-04,   3.450304937116163D-02, &
&   -6.755775412784931D-27,  -4.832390858581808D-26,   8.121711901318438D-24, &
&   -5.783224227835549D-22,   3.619874191090797D-20,  -2.197754967625606D-18, &
&    1.330001221076267D-16,  -8.090850126729742D-15,   4.967021026003187D-13, &
&   -3.088629739593376D-11,   1.956135861464070D-09,  -1.274283038345309D-07, &
&    8.716096117805660D-06,  -6.624233055350953D-04,   7.551625683323316D-02, &
&   -4.252842634207508D-32,  -4.125330537278931D-31,   9.163134125552700D-30, &
&   -2.561247824641305D-28,   1.139122275773975D-26,  -6.496234513642140D-25, &
&    4.033597331202501D-23,  -2.570358466209472D-21,   1.659673349651971D-19, &
&   -1.086224013617699D-17,   7.241408999278188D-16,  -4.965532065895382D-14, &
&    3.575182793187346D-12,  -2.860146222207651D-10,   3.432175466185966D-08, &
&    6.478504973345933D-30,  -7.087701177403089D-29,   1.777377207242019D-27, &
&   -6.694023246643129D-26,   3.450807819392216D-24,  -2.066324263035593D-22, &
&    1.297525959298777D-20,  -8.285943056832242D-19,   5.352065468660481D-17, &
&   -3.502992480219131D-15,   2.335314328697127D-13,  -1.601357476231197D-11, &
&    1.152977333757056D-09,  -9.223818649380408D-08,   1.106858237847804D-05, &
&    1.542918146763110D-28,  -1.891337525618028D-27,   5.879565600040018D-26, &
&   -2.689310068417798D-24,   1.520116285792717D-22,  -9.345314379898272D-21, &
&    5.902609936161430D-19,  -3.773532631516626D-17,   2.437843625333422D-15, &
&   -1.595638930103002D-13,   1.063756087241758D-11,  -7.294325345880853D-10, &
&    5.251914136238705D-08,  -4.201531304235339D-06,   5.041837564903051D-04, &
&    9.799284361383670D-28,  -1.490072608998464D-26,   6.089898430122684D-25, &
&   -3.279652085616065D-23,   1.969145702945212D-21,  -1.229791684698104D-19, &
&    7.794061824250148D-18,  -4.985943482533444D-16,   3.221446823468714D-14, &
&   -2.108561208078869D-12,   1.405705719931767D-10,  -9.639123779999285D-09, &
&    6.940169059677545D-07,  -5.552135245128369D-05,   6.662562294055365D-03, &
&    1.952404358848949D-27,  -4.641845355554424D-26,   2.592663228178336D-24, &
&   -1.576664504286529D-22,   9.825182073705707D-21,  -6.192525978829098D-19, &
&    3.932338943212083D-17,  -2.516487482270125D-15,   1.626015778481026D-13, &
&   -1.064299173329779D-11,   7.095326189190377D-10,  -4.865366421801793D-08, &
&    3.503063817913103D-06,  -2.802451054086086D-04,   3.362941264894067D-02, &
&    1.280919556465766D-27,  -7.279807615534281D-26,   5.192137855402135D-24, &
&   -3.371760740495097D-22,   2.138947283124577D-20,  -1.353850657431797D-18, &
&    8.604902616260876D-17,  -5.507615940250934D-15,   3.558818067372211D-13, &
&   -2.329412892984332D-11,   1.552942300571641D-09,  -1.064874744953718D-07, &
&    7.667098176820531D-06,  -6.133678542011824D-04,   7.360414250435165D-02, &
&   -2.402675518107930D-32,  -6.161609791855509D-32,   2.231113207485642D-30, &
&   -1.004391210599114D-28,   6.126904463347720D-27,  -3.990791815268315D-25, &
&    2.652574645813123D-23,  -1.781417519249126D-21,   1.208508284392451D-19, &
&   -8.305644233871003D-18,   5.813942969528672D-16,  -4.186038422134553D-14, &
&    3.164645020095998D-12,  -2.658301815762100D-10,   3.349460287818810D-08, &
&    8.323560584851060D-31,  -1.288748008361025D-29,   5.438833387666552D-28, &
&   -3.085633891143525D-26,   1.954637889940427D-24,  -1.284298236451129D-22, &
&    8.551356601653999D-21,  -5.744672230874530D-19,   3.897348279526697D-17, &
&   -2.678523916430860D-15,   1.874965404730910D-13,  -1.349975004848533D-11, &
&    1.020581099115210D-09,  -8.572881230679809D-08,   1.080183035058643D-05, &
&    2.501533380496420D-29,  -4.492206477629319D-28,   2.248583467945135D-26, &
&   -1.369431006734801D-24,   8.852766055725565D-23,  -5.843649935435639D-21, &
&    3.894488305347822D-19,  -2.616676064869691D-17,   1.775270381426414D-15, &
&   -1.220090957232848D-13,   8.540633629068826D-12,  -6.149256013684626D-10, &
&    4.648837535853647D-08,  -3.905023529681045D-06,   4.920329647381895D-04, &
&    2.047293893732015D-28,  -4.850898236847675D-27,   2.797920460603398D-25, &
&   -1.781859927059319D-23,   1.165925571166551D-21,  -7.717120327340549D-20, &
&    5.145822602934813D-18,  -3.457762933241367D-16,   2.345935222635554D-14, &
&   -1.612295126313497D-12,   1.128606419714933D-10,  -8.125966112390828D-09, &
&    6.143230375192291D-07,  -5.160313514921283D-05,   6.501995028791870D-03, &
&    7.077680026688526D-28,  -2.138939468520347D-26,   1.361960854757063D-24, &
&   -8.913646344094805D-23,   5.873652058561488D-21,  -3.893779228438791D-19, &
&    2.597198360541960D-17,  -1.745295891919675D-15,   1.184113903910644D-13, &
&   -8.138089893669471D-12,   5.696662767909701D-10,  -4.101597182646204D-08, &
&    3.100807469539755D-06,  -2.604678274390878D-04,   3.281894625731667D-02, &
&    1.217133471187122D-27,  -4.370914286665260D-26,   2.930344636739962D-24, &
&   -1.942823002799144D-22,   1.284408732614035D-20,  -8.520784043375621D-19, &
&    5.684277935633092D-17,  -3.819883553226328D-15,   2.591649154002319D-13, &
&   -1.781170243526933D-11,   1.246819206311235D-09,  -8.977098308724865D-08, &
&    6.786686322623787D-06,  -5.700816511055071D-04,   7.183028803931293D-02, &
&    2.671694101795686D-32,  -1.215222795027197D-32,   6.545973028430062D-31, &
&   -5.412696543110112D-29,   3.689592028993914D-27,  -2.555761552497802D-25, &
&    1.785101792363661D-23,  -1.256605367156891D-21,   8.931456169897005D-20, &
&   -6.430638846509633D-18,   4.715801090974867D-16,  -3.557061347870966D-14, &
&    2.817192585109889D-12,  -2.479129474798459D-10,   3.272450906730368D-08, &
&    1.222511733577751D-31,  -4.176769708653237D-30,   2.586406025761202D-28, &
&   -1.729966979096472D-26,   1.187743816423394D-24,  -8.239739685206803D-23, &
&    5.756584922507083D-21,  -4.052458318051140D-19,   2.880344572398535D-17, &
&   -2.073846479841611D-15,   1.520820628887905D-13,  -1.147133266507758D-11, &
&    9.085295466667272D-10,  -7.995060010500267D-08,   1.055347921385422D-05, &
&    6.586621891757039D-30,  -1.798586022364858D-28,   1.154162422498991D-26, &
&   -7.845472837757029D-25,   5.405525374337297D-23,  -3.752681142889608D-21, &
&    2.622109301121011D-19,  -1.845924214473044D-17,   1.312021969599592D-15, &
&   -9.446554466918351D-14,   6.927472991922677D-12,  -5.225293895756728D-10, &
&    4.138432764496301D-08,  -3.641820832718051D-06,   4.807203499186405D-04, &
&    7.136502310348379D-29,  -2.264591077580112D-27,   1.508342818370660D-25, &
&   -1.034070716943026D-23,   7.139446290827365D-22,  -4.958535320756788D-20, &
&    3.464947868811984D-18,  -2.439300942315277D-16,   1.733777765974757D-14, &
&   -1.248319787174435D-12,   9.154344949648113D-11,  -6.904991609157736D-09, &
&    5.468753353932602D-07,  -4.812502951439321D-05,   6.352503895899117D-03, &
&    3.298987482584389D-28,  -1.110995063797267D-26,   7.563495327604298D-25, &
&   -5.211719454423312D-23,   3.602568228174145D-21,  -2.502694777714202D-19, &
&    1.748923965308973D-17,  -1.231240383854262D-15,   8.751275665700205D-14, &
&   -6.300918288076628D-12,   4.620673396614581D-10,  -3.485307932508296D-08, &
&    2.760363882497742D-06,  -2.429120216596006D-04,   3.206438685906654D-02, &
&    6.897582313892405D-28,  -2.400928814093032D-26,   1.650387128495825D-24, &
&   -1.139894007852204D-22,   7.883788291828591D-21,  -5.477469660828724D-19, &
&    3.827825716576805D-17,  -2.694794054558564D-15,   1.915377183501128D-13, &
&   -1.379071615552574D-11,   1.011319188061883D-09,  -7.628236163509135D-08, &
&    6.041563041609937D-06,  -5.316575476621292D-04,   7.017879629140273D-02/
end


!------------------
  module rysgrid7
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t7(15,7,0:24)
      real(8) :: w7(15,7,0:24)
      data t7 / &
&    3.235856650466072D-20,  -3.480605951659624D-19,   2.133575822217575D-18, &
&    4.204295973249670D-18,   2.116580688609939D-16,   2.874892885046313D-15, &
&   -7.589911450770838D-15,  -2.587681201857980D-12,  -1.266275105641751D-10, &
&   -4.544411371335088D-09,  -1.385683068860801D-07,  -3.738041949704036D-06, &
&   -8.942389954297370D-05,  -1.827724111389344D-03,   9.727557512974903D-01, &
&   -7.372546901520482D-20,   9.266482184937037D-19,  -2.738712360246040D-18, &
&    2.916116733294205D-18,  -1.059008537114143D-15,  -2.654479209039622D-14, &
&   -2.244656543570143D-13,   8.844691540584580D-12,   4.280494546101160D-10, &
&    8.519448024050219D-09,  -6.811813397968406D-09,  -7.153835055682866D-06, &
&   -3.073983398889341D-04,  -8.204294805905510D-03,   8.619913332033933D-01, &
&    9.103195714613180D-20,  -7.887549336152776D-19,   4.884204452170672D-19, &
&   -1.054145399751662D-16,   5.698861391874646D-16,   5.448476596504639D-14, &
&    4.962688601303923D-13,  -2.199773955121827D-11,  -6.091319534661395D-10, &
&    3.567407314599360D-09,   4.496445207105953D-07,   5.367542132671554D-06, &
&   -2.843213065855277D-04,  -1.489982824740957D-02,   6.842620156531486D-01, &
&   -8.525673356127937D-21,  -2.234743890617733D-20,  -4.410669017758064D-18, &
&    1.171176402087848D-16,   1.360872470040556D-15,  -5.851686424468531D-14, &
&   -5.659797592366129D-13,   3.162927841919156D-11,   2.383233986384063D-10, &
&   -1.879120573064472D-08,  -1.044709853897551D-07,   1.344492198265299D-05, &
&    4.877334430705990D-05,  -1.718873572637969D-02,   4.723715370044845D-01, &
&    9.320196766051113D-21,  -2.527915331505926D-19,   4.248571638391513D-18, &
&    4.721041960181386D-18,  -2.007779790478626D-15,   3.353222415581535D-14, &
&    4.396676449957197D-13,  -2.668279441116810D-11,   2.665585064695021D-10, &
&    1.079798856105836D-08,  -4.038448791086649D-07,   1.281416713961177D-06, &
&    3.259873410827094D-04,  -1.344833878648849D-02,   2.654811572689373D-01, &
&   -2.562655106242371D-21,   2.294385237105922D-20,   7.612611308131822D-19, &
&   -3.554445728331057D-17,   7.571485093297244D-16,  -5.315003025122652D-15, &
&   -2.726867655087585D-13,   1.320370626304047D-11,  -3.111166960681227D-10, &
&    2.768502503410932D-09,   1.222122511817826D-07,  -7.677494755392673D-06, &
&    2.596857437719763D-04,  -6.307779613672685D-03,   1.018327040027696D-01, &
&   -2.459856347551139D-22,   4.825698046703671D-21,  -5.784398114179675D-20, &
&   -1.931626355285096D-19,   5.111995027458842D-17,  -2.554771279086413D-15, &
&    9.662876701645097D-14,  -3.194648522241102D-12,   9.660197945844295D-11, &
&   -2.722948712897823D-09,   7.193875284712774D-08,  -1.775030284510550D-06, &
&    4.018602319336238D-05,  -7.958307554885493D-04,   1.167587194014667D-02, &
&   -3.085067549189074D-21,  -6.891372784754533D-21,   6.545434665132087D-19, &
&    2.893110240202202D-17,   8.017646684225461D-16,   1.630697874217300D-14, &
&    2.114844528237867D-13,  -8.479700565550922D-13,  -1.715687237298758D-10, &
&   -7.278572822732880D-09,  -2.261902534030186D-07,  -5.885435333353124D-06, &
&   -1.319428705901764D-04,  -2.482198248684137D-03,   9.663544104600229D-01, &
&   -2.041387174066405D-20,   4.615777848343164D-21,   5.156594848786717D-18, &
&    1.148101093854031D-16,   3.071880474651808D-16,  -4.783784935944537D-14, &
&   -1.314085601733975D-12,  -8.357324955191978D-12,   4.796258773850721D-10, &
&    1.722214586899786D-08,   1.848792886520462D-07,  -6.217560715860586D-06, &
&   -3.692922103922778D-04,  -1.023846016286233D-02,   8.344205579830058D-01, &
&   -1.660317573064644D-20,   2.719985573028282D-19,   6.074650132950171D-18, &
&   -7.901551747616829D-17,  -3.316570411102977D-15,   1.226391993817726D-14, &
&    1.672622194714547D-12,   6.315624788248437D-12,  -8.255622467349869D-10, &
&   -1.025113032386502D-08,   4.046238442449522D-07,   1.070316780203486D-05, &
&   -2.116073040881408D-04,  -1.641181446870929D-02,   6.371853630519913D-01, &
&    8.548148522633405D-21,   1.904844293863724D-19,  -3.442568799027298D-18, &
&   -6.140280467334667D-17,   2.226431541320467D-15,   1.075963592926542D-14, &
&   -1.268622820722469D-12,   5.702291092835496D-12,   6.603009752280394D-10, &
&   -9.861774963765022D-09,  -3.289987526720868D-07,   1.070760403604580D-05, &
&    1.594979012884331D-04,  -1.655148021555133D-02,   4.215945125493261D-01, &
&    7.283521022036089D-21,  -4.406198261685937D-20,  -8.058630790618769D-19, &
&    4.583456038234051D-17,  -6.874990301238416D-16,  -9.967390413354726D-15, &
&    6.621594842981036D-13,  -1.108014812121785D-11,  -1.384702913804310D-10, &
&    1.144421693568148D-08,  -2.278784789688006D-07,  -2.517077713171275D-06, &
&    3.188266716200478D-04,  -1.149679678245415D-02,   2.280746771012377D-01, &
&    3.878326548397749D-22,  -1.321540245313726D-20,   4.858938959117123D-19, &
&   -9.507511460246720D-18,   5.043286116598916D-17,   4.598661036410409D-15, &
&   -2.352024259821599D-13,   6.597677366644803D-12,  -1.051705334293795D-10, &
&   -7.668361432805584D-10,   1.326005754751702D-07,  -6.096225466777279D-06, &
&    1.976188236241738D-04,  -4.943028529535830D-03,   8.504961665332013D-02, &
&   -4.272183931962923D-23,   4.273843751150798D-22,   7.580487472450169D-21, &
&   -6.456666250148969D-19,   3.156999150177203D-17,  -1.283998053191289D-15, &
&    4.619784289394295D-14,  -1.549649276784924D-12,   4.889300030093500D-11, &
&   -1.464876412885779D-09,   4.159406208613790D-08,  -1.112550891615000D-06, &
&    2.746310220510796D-05,  -5.958477499351239D-04,   9.607357449985514D-03, &
&   -2.069551588787522D-20,  -2.204525805315747D-19,  -2.441579234211404D-18, &
&    1.894834631259487D-17,   1.881043913467952D-15,   5.699024395493353D-14, &
&    1.124357730819596D-12,   1.298229259487860D-11,  -8.184191319366742D-11, &
&   -9.981057551238433D-09,  -3.574880396799294D-07,  -9.345720282002895D-06, &
&   -1.992981890519884D-04,  -3.460388229043614D-03,   9.575412078541394D-01, &
&   -1.911132368043910D-20,  -6.706679521787150D-19,  -7.531046964891744D-18, &
&    1.561507481207333D-16,   6.021650487450151D-15,   4.220975393820189D-14, &
&   -1.792491764647234D-12,  -5.043904265943695D-11,  -1.142025982077544D-10, &
&    2.186661505980021D-08,   4.912935370794945D-07,  -2.234296332158394D-06, &
&   -4.101070529681100D-04,  -1.259451465555020D-02,   8.002331555130177D-01, &
&   -2.294428787579636D-20,  -4.062294514018843D-19,   4.076607089044942D-18, &
&    1.884342922744040D-16,  -1.324332659848304D-15,  -8.090337880565806D-14, &
&    6.090671872458487D-13,   3.898841795393748D-11,  -3.040417150104790D-10, &
&   -2.148081858800080D-08,   1.546915451823130D-07,   1.423073952815632D-05, &
&   -9.713367179867179D-05,  -1.735406723757863D-02,   5.863641459330555D-01, &
&   -1.473918928107548D-20,   2.962369826385591D-20,   2.697583105688717D-18, &
&   -5.344015129495131D-17,  -3.019135384731146D-16,   3.859257590694286D-14, &
&   -4.229788481780996D-13,  -1.608692535371968D-11,   5.142065435628347D-10, &
&    1.404502206475415D-09,  -3.889714206677358D-07,   6.228689717820116D-06, &
&    2.362446225646450D-04,  -1.534394273338312D-02,   3.736360988507241D-01, &
&   -8.616046787687106D-22,   1.537880749408115D-20,  -7.069085489125734D-19, &
&    1.236725321268079D-17,   2.536862884164843D-16,  -1.360607675556494D-14, &
&    2.807099846193451D-13,   3.992848498523364D-13,  -2.340688536308430D-10, &
&    7.728808774550427D-09,  -8.200531563328165D-08,  -4.319560526195294D-06, &
&    2.867452639032696D-04,  -9.672021361403965D-03,   1.963699674262855D-01, &
&    1.112204313395765D-23,  -7.616790979022639D-21,   1.169810267860375D-19, &
&    6.776066772272843D-19,  -5.940611167024987D-17,   3.635398617632880D-15, &
&   -1.171079211004038D-13,   2.430863809290749D-12,  -1.538735674835425D-11, &
&   -1.721010196925887D-09,   1.119442879287209D-07,  -4.615035675219875D-06, &
&    1.496076329225061D-04,  -3.908026891426241D-03,   7.184499300384422D-02, &
&   -3.759567648944118D-23,  -3.520491308517606D-22,   9.282777593063602D-21, &
&   -2.583900748381607D-19,   1.646819970594700D-17,  -5.968273595247468D-16, &
&    2.182868182038785D-14,  -7.700705397161099D-13,   2.555085271690444D-11, &
&   -8.192080096957350D-10,   2.498407672535715D-08,  -7.226944015518673D-07, &
&    1.935305459133285D-05,  -4.571450106142853D-04,   8.039988933512865D-03, &
&   -7.602395973710203D-23,  -7.370124946425695D-19,  -2.204967173065153D-17, &
&   -3.542404560560908D-16,  -1.711322039616489D-15,   8.913775605945911D-14, &
&    3.313393223702046D-12,   6.418527676923645D-11,   6.347553721233262D-10, &
&   -6.603975802784499D-09,  -4.975745275946289D-07,  -1.452197277396945D-05, &
&   -3.054141006642625D-04,  -4.951192511982733D-03,   9.450826204305965D-01, &
&    1.378202056789210D-19,   6.630479439775621D-19,  -2.088370945809686D-17, &
&   -5.050619579708250D-16,   1.784618606875132D-15,   2.164494200476010D-13, &
&    1.963529347438253D-12,  -5.842503011151179D-11,  -1.417164742314558D-09, &
&    8.400827797561429D-09,   7.483395388875182D-07,   5.404454620531330D-06, &
&   -3.982093868667707D-04,  -1.505401879430906D-02,   7.587432263171394D-01, &
&    4.328221749167325D-20,  -6.173699555176160D-20,  -1.046873465920409D-17, &
&    3.041814918488849D-17,   3.805104436351031D-15,  -2.990028821967398D-14, &
&   -1.254053702437992D-12,   2.834185992725241D-11,   4.843394310648327D-10, &
&   -1.950404289416934D-08,  -1.708060332415592D-07,   1.410331429407359D-05, &
&    3.333193867988495D-05,  -1.754487093449636D-02,   5.338191472991771D-01, &
&    5.029898785187907D-21,  -8.725539974853298D-20,  -3.579877203550483D-20, &
&    7.896934600069684D-18,  -7.596684831888201D-16,   1.737490484004344D-14, &
&    3.593575670928215D-13,  -1.564634058536226D-11,   1.479394487014717D-10, &
&    7.342193227809887D-09,  -3.149810024147544D-07,   1.915984754275340D-06, &
&    2.722145263070719D-04,  -1.379907805412886D-02,   3.298678191180476D-01, &
&    7.735537277196403D-22,   1.429101451888158D-21,  -5.254743103315996D-19, &
&   -7.790695548881128D-18,   3.136018148540261D-16,  -3.469708289102038D-15, &
&    4.633690498170605D-14,   3.759083439342837D-12,  -1.805306373137177D-10, &
&    3.895184432278426D-09,   3.925524060418374D-09,  -4.730232891631370D-06, &
&    2.452500987165417D-04,  -8.074239389133874D-03,   1.698130500807492D-01, &
&    5.762042403927874D-22,  -3.406696282205304D-21,  -1.448398917690957D-19, &
&   -2.136862685350574D-19,  -2.514118302022898D-17,   2.447340405806042D-15, &
&   -3.766779023422226D-14,   6.368134599101343D-13,   1.351057666743708D-11, &
&   -1.681784690655897D-09,   8.578798248085409D-08,  -3.429398277501099D-06, &
&    1.136442190605894D-04,  -3.123605958533803D-03,   6.135141774327028D-02, &
&    5.247429211752630D-23,  -3.349665879004566D-22,  -1.134584426685631D-20, &
&   -2.920804484510615D-19,   9.529463334582604D-18,  -2.041536995635518D-16, &
&    1.145416229209008D-14,  -3.919096911195992D-13,   1.378221328972275D-11, &
&   -4.769886352543331D-10,   1.552545836751920D-08,  -4.847353190965278D-07, &
&    1.400427676405662D-05,  -3.581392576296629D-04,   6.825060361647377D-03, &
&    5.977768500876005D-19,   4.015894161088215D-18,  -4.334065397739851D-18, &
&   -1.294222178792484D-15,  -3.005153589451187D-14,  -3.018156530738845D-13, &
&    2.366435606983882D-12,   1.524938283434911D-10,   2.933465253973355D-09, &
&    2.260399130359469D-08,  -4.293702372130109D-07,  -2.051288491739941D-05, &
&   -4.635915220576051D-04,  -7.230867413456619D-03,   9.270469408477684D-01, &
&   -1.733512308607239D-19,   1.106177026570257D-18,   3.934902331109679D-17, &
&   -2.534710152870021D-16,  -1.707154953745220D-14,  -3.213429111987431D-14, &
&    5.812752700981123D-12,   4.851494979602465D-11,  -1.694644008818798D-09, &
&   -2.306042706011443D-08,   6.454392574313868D-07,   1.424952256715051D-05, &
&   -3.088537008252071D-04,  -1.721544908359864D-02,   7.102047188918236D-01, &
&   -6.122740403352731D-21,   4.347686278346449D-19,   9.143839435346577D-19, &
&   -2.002963122297160D-16,  -1.855353162034386D-16,   4.445362925122769D-14, &
&   -7.717663077992210D-13,  -2.046343433291776D-13,   7.570631087647063D-10, &
&   -7.404909032598147D-09,  -3.786524163199177D-07,   1.062226152454008D-05, &
&    1.464784152967209D-04,  -1.698960816975462D-02,   4.818471431339320D-01, &
&    5.650443181338884D-21,   7.403915850038449D-20,  -2.971444045794423D-19, &
&   -1.774047730692099D-17,  -8.970982419876405D-16,  -5.017070481254876D-15, &
&    5.351338245029200D-13,  -3.731482852005741D-12,  -6.298426207215809D-11, &
&    7.724110464781805D-09,  -1.972042453033760D-07,  -1.161698044855269D-06, &
&    2.745401965682588D-04,  -1.214496064717655D-02,   2.909485942579987D-01, &
&    1.393354075982162D-21,   3.449587179923572D-20,   1.348036510921718D-19, &
&   -1.886592720263817D-17,  -1.912257353557548D-16,  -6.493493742789503D-16, &
&    2.568039672070216D-14,   4.460017661723563D-12,  -9.365923127028882D-11, &
&    1.406454950665302D-09,   4.173121962047666D-08,  -4.418899808357094D-06, &
&    2.037422734761957D-04,  -6.728696948280571D-03,   1.476710078778554D-01, &
&    5.427521381788257D-22,   1.100553861252048D-20,   8.397067621532213D-21, &
&   -4.361578123796114D-18,  -1.159226722092725D-16,   7.031676476026179D-16, &
&    1.119905700080324D-14,   4.092176272263975D-13,   2.238753368274771D-11, &
&   -1.352088177125751D-09,   6.284378797379910D-08,  -2.542572236766288D-06, &
&    8.697718432517100D-05,  -2.525727990205874D-03,   5.291735527997427D-02, &
&    5.831269512518685D-23,   1.117912357949126D-21,   3.762366758586686D-21, &
&   -5.999280810504543D-19,  -6.688407919709373D-18,  -1.331432121683816D-16, &
&    8.015635951051931D-15,  -1.624276350783566D-13,   8.096650587211868D-12, &
&   -2.872804772670477D-10,   9.920776059751760D-09,  -3.348819654975360D-07, &
&    1.036621236589936D-05,  -2.856995969952658D-04,   5.864744141672697D-03, &
&   -1.895014756462832D-18,   7.714157163111100D-18,   3.930396405668035D-16, &
&    4.648691870423054D-15,  -1.577069800916662D-14,  -1.460053261847455D-12, &
&   -2.181678849399254D-11,  -1.337290075888403D-11,   5.411203782344505D-09, &
&    1.024919947263418D-07,   4.485239676315777D-07,  -2.161006688206940D-05, &
&   -6.609337367800852D-04,  -1.059840978462364D-02,   9.006013603851789D-01, &
&    1.031283622652902D-19,  -1.465268621725995D-18,   8.607506190327277D-18, &
&    9.647661453971582D-16,  -1.926578683257307D-15,  -4.239354610609790D-13, &
&   -1.414994289213138D-12,   1.236294210410778D-10,   4.256128753360340D-10, &
&   -3.699180713445197D-08,   1.459164925364650D-07,   1.921434554084094D-05, &
&   -1.536810464542620D-04,  -1.862559306579401D-02,   6.562090095197037D-01, &
&   -6.451544071357512D-21,   1.832577683257862D-19,   1.257719021524139D-17, &
&    7.517313836033058D-17,  -3.390891529947843D-15,  -3.249931128898524D-14, &
&   -3.787164758940804D-13,  -9.600467972517478D-12,   6.356005450899962D-10, &
&    5.396558467841592D-09,  -3.908949298670564D-07,   5.812190056469576D-06, &
&    2.205384848552722D-04,  -1.586673835184203D-02,   4.324515024024928D-01, &
&   -3.048392836788894D-22,   1.406711327697328D-19,   4.195627971401364D-18, &
&    4.487784258526947D-17,  -8.949686438661758D-16,  -3.693513660098789D-14, &
&   -2.534357568491066D-14,   4.163371835066217D-12,  -3.498045371624083D-11, &
&    6.582398303694833D-09,  -9.064096525076052D-08,  -2.870848851585089D-06, &
&    2.554360712501650D-04,  -1.054735710321844D-02,   2.569390609331938D-01, &
&   -2.299781534722429D-22,   5.898098403965470D-20,   2.011260804645469D-18, &
&    1.668103403172697D-17,  -4.122616581162870D-16,  -1.258116656613116D-14, &
&   -1.355200636773583D-13,   3.817109155520964D-12,  -1.342000899446228D-13, &
&    5.782292107200143D-10,   5.448257818377766D-08,  -3.829235746330063D-06, &
&    1.665147646346311D-04,  -5.620590450347556D-03,   1.292029508145013D-01, &
&   -1.137184400019033D-22,   2.017570916894586D-20,   6.424315477644785D-19, &
&    6.192287580498103D-18,  -1.483145055955891D-16,  -4.111006921042370D-15, &
&   -3.177654369069113D-14,   4.313454135011671D-13,   3.298992985130754D-11, &
&   -8.561075010051903D-10,   4.603583049606281D-08,  -1.896724758484359D-06, &
&    6.715206924185734D-05,  -2.066239860083237D-03,   4.605909560248414D-02, &
&   -1.303719289932945D-23,   2.134819841280955D-21,   7.003577989405320D-20, &
&    5.986586486167141D-19,  -1.325248208708311D-17,  -5.288922669236023D-16, &
&   -3.905728186621279D-16,  -4.852334751225504D-14,   6.229945917463807D-12, &
&   -1.620730094602004D-10,   6.591068060413751D-09,  -2.376776300831600D-07, &
&    7.819589957576144D-06,  -2.315779339086437D-04,   5.092638819318181D-03, &
&    1.467638756405827D-18,  -7.991156551365187D-17,  -1.103315258838411D-15, &
&    4.607735350667688D-15,   2.826170417219484D-13,   2.319879088855620D-12, &
&   -3.229813604268668D-11,  -8.633834895419344D-10,  -3.161991300815324D-09, &
&    1.507631638690735D-07,   2.537608412522394D-06,  -4.503027155339515D-06, &
&   -7.975831742183894D-04,  -1.505018002449808D-02,   8.623392353390132D-01, &
&   -5.574417593285108D-19,  -2.593987402330345D-18,  -1.520689345175196D-17, &
&    8.254883125902363D-16,   2.914706420700950D-14,  -3.411586810468578D-15, &
&   -9.296746775142659D-12,  -2.775582643942580D-11,   1.781105175652972D-09, &
&   -1.221841422182080D-08,  -2.552627670178579D-07,   1.817174241318832D-05, &
&    1.822599946479165D-05,  -1.902691282327766D-02,   5.994712815416295D-01, &
&   -2.216637685767904D-19,  -1.702851391467480D-18,   1.030603771729096D-18, &
&    5.064367508466128D-16,   7.078767838552662D-15,  -1.592100650363625D-14, &
&   -1.749036922167735D-12,  -3.559547639899644D-11,   2.246476422281726D-10, &
&    1.395935370959531D-08,  -2.367770685610552D-07,   1.915253103395206D-06, &
&    2.539090458331742D-04,  -1.442574077882336D-02,   3.869631507687458D-01, &
&   -1.013575919088252D-19,  -7.868046193774736D-19,   1.647655931093297D-19, &
&    2.192521836365194D-16,   3.732752679206321D-15,  -1.039172060101587D-14, &
&   -9.793819994963449D-13,  -9.145905390958091D-12,  -4.457265738460097D-11, &
&    6.293054249055452D-09,   5.943367048601150D-09,  -3.375983323659970D-06, &
&    2.264561887504075D-04,  -9.099409464986077D-03,   2.275126416192235D-01, &
&   -4.304129015297976D-20,  -3.510202353824629D-19,  -1.775478602937305D-20, &
&    9.562606242397388D-17,   1.585592139354085D-15,  -2.231142533648443D-15, &
&   -4.719124968420049D-13,  -3.949205684651268D-12,   1.375795916774337D-11, &
&    9.482619032581534D-10,   6.554770812745902D-08,  -3.115350185992938D-06, &
&    1.351652878757148D-04,  -4.718756822973480D-03,   1.137409836717265D-01, &
&   -1.395923326855726D-20,  -1.162870014943941D-19,  -3.970268085264619D-20, &
&    3.150686342557852D-17,   5.228889772763676D-16,  -8.287186329896181D-16, &
&   -1.443072149436809D-13,  -1.832500643703266D-12,   2.339080883349744D-11, &
&   -2.764924226398260D-10,   3.773355541285043D-08,  -1.403020309506082D-06, &
&    5.237760955445799D-05,  -1.709864388864822D-03,   4.041707864139987D-02, &
&   -1.476630189504765D-21,  -1.245830043516139D-20,  -4.934174045130888D-21, &
&    3.323542678909487D-18,   5.693325562273194D-17,  -1.251102788116093D-16, &
&   -1.401762175566185D-14,  -2.403847404191024D-13,   3.809235215497237D-12, &
&   -6.556513539965352D-11,   4.935411997195291D-09,  -1.699849713838941D-07, &
&    5.999918442830815D-06,  -1.904226988676932D-04,   4.462362945871106D-03, &
&   -1.085050130134949D-18,   2.289165096091061D-16,   1.428806728914771D-15, &
&   -3.519587272021546D-14,  -4.554740737426599D-13,   3.826272025564589D-12, &
&    1.035222642838351D-10,  -1.382189343700632D-10,  -1.983782477277136D-08, &
&   -7.812578894325601D-08,   3.486198360034467D-06,   3.513749554541647D-05, &
&   -6.690146823284938D-04,  -1.963152838238650D-02,   8.101267039360242D-01, &
&    2.702669678543577D-18,   6.987268192805999D-18,  -2.022719082545643D-16, &
&   -3.615401969656418D-15,   5.680892436333981D-15,   8.929659264787781D-13, &
&    3.963928186490492D-12,  -1.442256637840790D-10,  -5.908982062055382D-10, &
&    2.503880999797584D-09,  -2.721873671579925D-07,   1.477372874600793D-05, &
&    1.665302743210256D-04,  -1.845713804883949D-02,   5.430227472668540D-01, &
&    9.914938867032764D-19,   2.527779760769803D-18,  -8.402732066780701D-17, &
&   -1.295345420366406D-15,   3.977898236039882D-15,   3.034446988865114D-13, &
&    2.197766672484412D-12,  -4.913660262541989D-11,  -8.308088210500004D-10, &
&    9.054248431808347D-09,  -3.968191263969398D-08,   3.282623140206054D-07, &
&    2.621863465788913D-04,  -1.287037699508016D-02,   3.460071094956651D-01, &
&    4.319427621809822D-19,   1.178963490534496D-18,  -3.693997586899696D-17, &
&   -5.970849276672001D-16,   1.839467765693221D-15,   1.430276615533358D-13, &
&    8.758358653724154D-13,  -1.943876295761480D-11,  -4.229350164065014D-10, &
&    2.468810381525426D-09,   8.052283254252669D-08,  -2.801049924240826D-06, &
&    1.979720942195023D-04,  -7.828761848700696D-03,   2.021633191300626D-01, &
&    1.819440060643919D-19,   5.246748958493913D-19,  -1.560849462682160D-17, &
&   -2.579093825613686D-16,   7.364556610189633D-16,   6.294410366179406D-14, &
&    3.783950824871757D-13,  -8.924035679621070D-12,  -1.572810102057588D-10, &
&   -1.615596793534819D-10,   7.545795772300859D-08,  -2.253247548653334D-06, &
&    1.109100631355846D-04,  -3.984424463214272D-03,   1.007226244930050D-01, &
&    5.864954541833814D-20,   1.752839313630983D-19,  -5.033574854047082D-18, &
&   -8.452114871414537D-17,   2.352397719600901D-16,   2.052057300122684D-14, &
&    1.323895122467738D-13,  -3.238004651556866D-12,  -4.152956981746705D-11, &
&   -3.872155308347276D-10,   3.426909219133998D-08,  -9.695119791158141D-07, &
&    4.172962977141076D-05,  -1.429494734270350D-03,   3.572400376007524D-02, &
&    6.193037226183933D-21,   1.881533771595822D-20,  -5.310140377964436D-19, &
&   -9.005835272713878D-18,   2.508416939216853D-17,   2.166406082586710D-15, &
&    1.478669570422552D-14,  -3.665634972416327D-13,  -3.780558670078731D-12, &
&   -6.044755867993260D-11,   4.166572748213561D-09,  -1.154655655278438D-07, &
&    4.721989084343716D-06,  -1.585022240376202D-04,   3.940890517771337D-03, &
&    1.302220256000210D-17,  -3.187278841780285D-16,  -1.145173486890499D-15, &
&    5.695210052599571D-14,   1.632914198186401D-13,  -9.735924940825424D-12, &
&   -2.156095715997252D-11,   1.684436915950027D-09,   2.044334806314367D-09, &
&   -3.012673476200325D-07,   1.222178493634738D-07,   6.033151905252622D-05, &
&   -2.081744010047892D-04,  -2.237973528392058D-02,   7.464090549747400D-01, &
&   -6.269469816389473D-18,  -1.169928775821488D-17,   5.443077760924522D-16, &
&    3.766776291187135D-15,  -7.995641292110947D-14,  -8.481882930224813D-13, &
&    1.163694947943111D-11,   1.438562509845978D-10,  -9.812933647038187D-10, &
&   -2.137450377772202D-08,  -4.030645209401469D-07,   1.111043344562220D-05, &
&    2.841662256093528D-04,  -1.708892488645520D-02,   4.895268545381689D-01, &
&   -2.220946906414332D-18,  -2.524137046554217D-18,   2.081384839678913D-16, &
&    1.158694265775453D-15,  -3.201119012475313D-14,  -3.221550342816962D-13, &
&    4.862989474588739D-12,   7.159970488688989D-11,  -7.332345212053768D-10, &
&   -9.058196244533166D-09,  -4.123180114158926D-08,   1.268785549075567D-07, &
&    2.642506219546508D-04,  -1.129042040432604D-02,   3.097628118990962D-01, &
&   -9.451717476399970D-19,  -9.458469815124366D-19,   9.202821479750349D-17, &
&    4.896374809294805D-16,  -1.473578360051587D-14,  -1.412470028691845D-13, &
&    2.232546902746205D-12,   3.419809887283520D-11,  -3.369422358334284D-10, &
&   -6.165229312044451D-09,   5.119928986031054D-08,  -1.875683507329779D-06, &
&    1.771933178460481D-04,  -6.707553451784800D-03,   1.803899340704899D-01, &
&   -3.913870469227634D-19,  -3.828434281874547D-19,   3.885332712405755D-17, &
&    2.055326468558687D-16,  -6.362943586647818D-15,  -6.028104812021984D-14, &
&    9.835389791332415D-13,   1.449505679433898D-11,  -1.293206360319737D-10, &
&   -3.524395178838826D-09,   4.733184233654512D-08,  -1.463656356089703D-06, &
&    9.443787882072048D-05,  -3.371982307264382D-03,   8.971264636124761D-02, &
&   -1.248937106012305D-19,  -1.227991464467396D-19,   1.252874709415202D-17, &
&    6.631497371273045D-17,  -2.073490210162184D-15,  -1.971559157680240D-14, &
&    3.280654066054609D-13,   4.597864428227221D-12,  -3.713063570152312D-11, &
&   -1.356915549029571D-09,   2.113691485652284D-08,  -6.217257020135790D-07, &
&    3.468730363407774D-05,  -1.201823102116155D-03,   3.178755501755624D-02, &
&   -1.312430703678800D-20,  -1.299313446348395D-20,   1.322840032026107D-18, &
&    7.006914523621447D-18,  -2.197990564145021D-16,  -2.099928604313362D-15, &
&    3.526978682132716D-14,   4.791317453820667D-13,  -3.634878961175174D-12, &
&   -1.554091440379208D-10,   2.549385039956959D-09,  -7.365866312689652D-08, &
&    3.885477593779396D-06,  -1.328693490040328D-04,   3.505083562397116D-03, &
&   -1.689011877356986D-17,   2.162651864128292D-16,   2.650295483999567D-16, &
&   -4.048246931315738D-14,   2.264154831156762D-13,   5.617967111856385D-12, &
&   -7.811435909266537D-11,  -4.505511595499534D-10,   1.737043986709066D-08, &
&   -5.305998842561409D-08,  -2.890716631430738D-06,   3.976876820797356D-05, &
&    2.700413600687337D-04,  -2.209795545936137D-02,   6.789667819713702D-01, &
&    5.750871868871959D-18,   1.547831049502980D-17,  -5.764004577526785D-16, &
&   -1.106740502135991D-15,   9.647268213055335D-14,  -1.204863107295536D-13, &
&   -1.528847180842028D-11,   5.518175810798239D-11,   2.363139422274278D-09, &
&   -5.846453528800051D-09,  -6.883634615092902D-07,   4.319275693526115D-06, &
&    3.563183156007143D-04,  -1.513668890637620D-02,   4.410793704801281D-01, &
&    2.295582941920226D-18,   2.671688942684013D-18,  -2.285997643846386D-16, &
&    4.680989672476275D-17,   3.890519060789371D-14,  -1.137364677527224D-13, &
&   -6.551300580955651D-12,   3.888754743276535D-11,   9.555357892458034D-10, &
&   -5.945270021249783D-09,  -1.942321614305953D-07,  -1.336043330999166D-06, &
&    2.602611913102917D-04,  -9.710255339875246D-03,   2.782673371258547D-01, &
&    1.006041831081195D-18,   6.421588497414564D-19,  -1.016090947508356D-16, &
&    1.066996944806862D-16,   1.756097348744794D-14,  -6.356412035639202D-14, &
&   -3.038397824042635D-12,   1.993400768336837D-11,   4.751031522835536D-10, &
&   -4.442416584923219D-09,  -4.776985913789007D-08,  -1.882426638343939D-06, &
&    1.612083851845539D-04,  -5.692292832397450D-03,   1.618138594010909D-01, &
&    4.202014465503060D-19,   1.658858775481156D-19,  -4.293413813373086D-17, &
&    6.275017100947267D-17,   7.509570208587799D-15,  -3.008894329854389D-14, &
&   -1.309716940442214D-12,   8.804462267052985D-12,   2.211716662016529D-10, &
&   -2.506887369867528D-09,  -6.284115352898637D-09,  -1.233220356427339D-06, &
&    8.279995398079596D-05,  -2.841291275533406D-03,   8.041004145007080D-02, &
&    1.344370971943300D-19,   3.679245071980280D-20,  -1.383755794042261D-17, &
&    2.309850322046614D-17,   2.439845746588924D-15,  -1.031238271329551D-14, &
&   -4.259388634053485D-13,   2.871780607992123D-12,   7.606273094463419D-11, &
&   -9.485591784506544D-10,   1.136424975850832D-09,  -4.943896217557467D-07, &
&    2.984979416288594D-05,  -1.008779077608466D-03,   2.847885185654650D-02, &
&    1.413709570591226D-20,   3.140451630343892D-21,  -1.460249315728488D-18, &
&    2.567024399319374D-18,   2.585074524571717D-16,  -1.118807738649459D-15, &
&   -4.510377037025503D-14,   3.036560357920423D-13,   8.287648740126202D-12, &
&   -1.076323243251060D-10,   2.910015481236783D-10,  -5.735119188695960D-08, &
&    3.316786370174877D-06,  -1.113352722445384D-04,   3.139623342591341D-03, &
&    5.341315404827957D-18,  -8.058454200963786D-17,   4.217002958012592D-16, &
&    1.096703945117308D-14,  -2.265329718930566D-13,   6.851307161130452D-13, &
&    3.674634134376840D-11,  -6.240744425444664D-10,   1.016368301896726D-09, &
&    1.156955029672621D-07,  -2.029695836518512D-06,   7.708071137503687D-06, &
&    4.752155267638637D-04,  -1.971562524879382D-02,   6.159412853317633D-01, &
&   -2.408989376518762D-18,  -6.156219483489024D-18,   3.015062956653904D-16, &
&   -1.375137473935049D-15,  -4.200048999746326D-14,   6.311765551842148D-13, &
&    2.341924820448391D-12,  -1.396308333099363D-10,   6.405841336305817D-10, &
&    2.756847163361237D-08,  -4.827399563604409D-07,  -3.228024697798438D-06, &
&    3.592983278257159D-04,  -1.295539994161352D-02,   3.989373568888633D-01, &
&   -1.131714054519978D-18,  -3.522086386603939D-19,   1.222850595981981D-16, &
&   -9.089965261673155D-16,  -1.498226436598808D-14,   3.055098915096072D-13, &
&    2.443431697173964D-13,  -5.999597248652121D-11,   4.110117883099539D-10, &
&    9.616016104931850D-09,  -1.529221858414032D-07,  -3.662366362919342D-06, &
&    2.373705439736585D-04,  -8.206668733646209D-03,   2.514264097603473D-01, &
&   -5.267072146644638D-19,   2.744017880020178D-19,   5.436175623999326D-17, &
&   -4.805517447815382D-16,  -6.300363907397848D-15,   1.485556689217542D-13, &
&   -2.601074629724621D-14,  -2.873368361779501D-11,   2.395668032835428D-10, &
&    3.598728220515400D-09,  -4.812072433951290D-08,  -2.583313274926596D-06, &
&    1.411044182149339D-04,  -4.782085522258674D-03,   1.461324517520203D-01, &
&   -2.263111448493286D-19,   2.131864655402932D-19,   2.289962934578002D-17, &
&   -2.207917851315925D-16,  -2.572244769901912D-15,   6.577395320483070D-14, &
&   -3.995471717700247D-14,  -1.279555960090512D-11,   1.189127889455156D-10, &
&    1.268918755757574D-09,  -1.298248312400124D-08,  -1.407647143320695D-06, &
&    7.097145361194585D-05,  -2.379138333290826D-03,   7.259712381050493D-02, &
&   -7.343364933704775D-20,   8.558544531771671D-20,   7.361373506651527D-18, &
&   -7.430931239667918D-17,  -8.121802743004246D-16,   2.173047870160522D-14, &
&   -1.766259489497239D-14,  -4.262024618407707D-12,   4.205305157632186D-11, &
&    3.508176008616687D-10,  -2.489554448387102D-09,  -5.227231447683906D-07, &
&    2.530380494052389D-05,  -8.431723036255723D-04,   2.570773467607306D-02, &
&   -7.768572601402072D-21,   9.822421698786286D-21,   7.757725554399418D-19, &
&   -7.991373546482836D-18,  -8.488234412534230D-17,   2.318316262543780D-15, &
&   -2.079961198608134D-15,  -4.569478216660571D-13,   4.632017845670348D-12, &
&    3.385181492280319D-11,  -1.704171531953010D-10,  -5.882719029178374D-08, &
&    2.797963257169126D-06,  -9.298237167212862D-05,   2.833923940325480D-03, &
&    1.171836078029659D-19,   1.458932366189317D-17,  -2.862859458813710D-16, &
&    1.613756387936667D-15,   3.975507763816054D-14,  -1.139646234574122D-12, &
&    1.192227675590862D-11,   4.696435960011555D-11,  -3.841311227311458D-09, &
&    6.861766876311541D-08,  -5.437679258171732D-07,  -6.960944857756442D-06, &
&    4.650223463464259D-04,  -1.682962108351052D-02,   5.611427952346329D-01, &
&    7.475808271948649D-19,  -1.113474887613026D-18,  -7.388205661411141D-17, &
&    1.289647416369861D-15,  -3.382472397555637D-15,  -2.425506754081422D-13, &
&    4.422005357120581D-12,  -9.329134027007307D-12,  -9.821961696209714D-10, &
&    2.007484615327571D-08,  -8.869589126093820D-08,  -6.530570028117201D-06, &
&    3.117720263242950D-04,  -1.092744624678974D-02,   3.631854693696047D-01, &
&    3.509169518816177D-19,  -1.177030289290952D-18,  -2.606029299454118D-17, &
&    6.205570287807317D-16,  -3.403994827457913D-15,  -9.220781244140594D-14, &
&    2.110606774372394D-12,  -8.964691718095735D-12,  -3.820836199658422D-10, &
&    8.121961335434643D-09,  -1.751195181341383D-09,  -4.562541249211960D-06, &
&    1.989650592484827D-04,  -6.893638361096895D-03,   2.288339796055898D-01, &
&    1.646979726377593D-19,  -6.940853684281772D-19,  -1.056986652245213D-17, &
&    3.004533931517493D-16,  -2.022264528393363D-15,  -4.028246453948481D-14, &
&    1.043432927129057D-12,  -5.638833328734911D-12,  -1.625798754500930D-10, &
&    3.493689090189454D-09,   1.429874023558319D-08,  -2.782183950376225D-06, &
&    1.163811641185585D-04,  -4.008738490940354D-03,   1.329834763302227D-01, &
&    7.112467919415633D-20,  -3.342719080880364D-19,  -4.179329926540809D-18, &
&    1.326582208259380D-16,  -9.815740360217377D-16,  -1.685629058402683D-14, &
&    4.694716501233614D-13,  -2.862102964704303D-12,  -6.545736496258069D-11, &
&    1.406147805633763D-09,   1.131574620743311D-08,  -1.418633966503159D-06, &
&    5.802681541054872D-05,  -1.992093620002134D-03,   6.605976174306771D-02, &
&    2.314041135835424D-20,  -1.151056429331134D-19,  -1.290562173179837D-18, &
&    4.375759794761023D-17,  -3.397657144423246D-16,  -5.403759158351215D-15, &
&    1.568572956723339D-13,  -1.019537271854910D-12,  -2.029525059109936D-11, &
&    4.343057907391208D-10,   4.831819083892759D-09,  -5.095715709974315D-07, &
&    2.058998422516683D-05,  -7.055494443978479D-04,   2.339174366963082D-02, &
&    2.450851382624329D-21,  -1.249887211880626D-20,  -1.333701123322005D-19, &
&    4.664896729540374D-18,  -3.698711952420340D-17,  -5.688957390794591D-16, &
&    1.682939286638215D-14,  -1.125427336198392D-13,  -2.096753398630674D-12, &
&    4.473461073725425D-11,   5.736564294371013D-10,  -5.653377450489314D-08, &
&    2.271861350410314D-06,  -7.778311946659078D-05,   2.578566986038899D-03, &
&   -3.741996427241686D-19,   1.168380417687148D-18,   3.243908316991163D-17, &
&   -1.090251181689688D-15,   1.724522840076465D-14,  -9.438894040653158D-14, &
&   -2.800239818150124D-12,   9.808612332497900D-11,  -1.717704416738359D-09, &
&    1.734864140467733D-08,   5.053152333577485D-08,  -9.148096450135059D-06, &
&    3.872758129744139D-04,  -1.426358060613440D-02,   5.146211771718463D-01, &
&   -1.398605694030747D-19,   1.224049339785170D-18,  -4.913398541903658D-18, &
&   -2.305086886162159D-16,   6.418449374143946D-15,  -7.016488737303635D-14, &
&   -3.518764291027955D-13,   2.882729291983320D-11,  -5.727323374082348D-10, &
&    4.949601738800118D-09,   8.884552304073140D-08,  -6.299494905801775D-06, &
&    2.524578367374530D-04,  -9.236004907090280D-03,   3.330297351011350D-01, &
&   -5.496161621901793D-20,   6.258879247239714D-19,  -4.618894818202288D-18, &
&   -7.866832997507587D-17,   2.970918352199382D-15,  -3.859746396200413D-14, &
&   -4.791055665311896D-14,   1.223226985770362D-11,  -2.539613295961943D-10, &
&    1.754050713923140D-09,   6.900806084865014D-08,  -4.061583281530194D-06, &
&    1.595259577882119D-04,  -5.820508020947066D-03,   2.098221070141560D-01, &
&   -2.348453561462759D-20,   3.108040973649223D-19,  -2.767505118399452D-18, &
&   -3.101183458751791D-17,   1.433279406561724D-15,  -2.023988760722112D-14, &
&    7.984461877956675D-15,   5.576822709317084D-12,  -1.179648208566238D-10, &
&    6.251940255701184D-10,   4.397946342651117D-08,  -2.388469623151668D-06, &
&    9.284843730607550D-05,  -3.382861431374242D-03,   1.219314546601566D-01, &
&   -9.558040587130742D-21,   1.389649468371744D-19,  -1.354439132406979D-18, &
&   -1.196330556816441D-17,   6.339523394856782D-16,  -9.379955138634185D-15, &
&    1.196628262521033D-14,   2.370804297994974D-12,  -5.055519977606450D-11, &
&    2.010124277975024D-10,   2.294226994955841D-08,  -1.194530953262926D-06, &
&    4.616377503776245D-05,  -1.680547194820494D-03,   6.056862610765928D-02, &
&   -2.999233341156104D-21,   4.613528196307925D-20,  -4.713128051617144D-19, &
&   -3.628183420161766D-18,   2.095511161677378D-16,  -3.182426771459175D-15, &
&    5.604424900901583D-15,   7.637193291557543D-13,  -1.633867054151554D-11, &
&    4.960242785064088D-11,   8.341663967805059D-09,  -4.245967295616626D-07, &
&    1.635487702827908D-05,  -5.951026506399464D-04,   2.144712756042028D-02, &
&   -3.122090797148629D-22,   4.932158332621440D-21,  -5.143699150359086D-20, &
&   -3.714074568054902D-19,   2.236691736056092D-17,  -3.437302028537936D-16, &
&    6.806994517413367D-16,   8.048290004299745D-14,  -1.723678146251300D-12, &
&    4.391649101546723D-12,   9.304556401244142D-10,  -4.688624604660470D-08, &
&    1.803283566278318D-06,  -6.560166595982063D-05,   2.364193627679143D-03, &
&    3.444207043506152D-20,  -6.572177791718163D-19,   1.287979463453448D-17, &
&   -1.381208227945686D-16,  -7.379760437166701D-16,   7.241170266252732D-14, &
&   -1.916269424525541D-12,   3.336416438294082D-11,  -3.843949019310371D-10, &
&    5.172692075565540D-10,   1.547562667376588D-07,  -7.670222688130082D-06, &
&    3.107087540877547D-04,  -1.217649641727289D-02,   4.750761707597898D-01, &
&   -5.875804693368406D-21,  -1.482265522377418D-19,   5.115830631350650D-18, &
&   -8.240621648617804D-17,   4.200530267819290D-16,   1.771189596786502D-14, &
&   -6.448981050003607D-13,   1.229117235814767D-11,  -1.322023599196510D-10, &
&   -8.455791485738092D-10,   1.096810552081967D-07,  -5.023091509931141D-06, &
&    2.013366007258479D-04,  -7.880441472368998D-03,   3.074317959593059D-01, &
&   -5.971241088999790D-21,  -4.847077637662848D-20,   2.384548237193995D-18, &
&   -4.374692053574862D-17,   3.240094579737010D-16,   6.646976206483370D-15, &
&   -2.925640847912938D-13,   5.754665597398343D-12,  -5.641888330841190D-11, &
&   -8.204052971649372D-10,   7.152974468923843D-08,  -3.180415580917572D-06, &
&    1.269223593299168D-04,  -4.965162206221531D-03,   1.936925104099939D-01, &
&   -3.692857283283871D-21,  -1.787499899752594D-20,   1.148350453626808D-18, &
&   -2.254788457768842D-17,   1.912870015617513D-16,   2.778698282715220D-15, &
&   -1.392723410453762D-13,   2.776032959554298D-12,  -2.483438859478934D-11, &
&   -5.641066900853478D-10,   4.231925064035705D-08,  -1.853135323034615D-06, &
&    7.377998707710894D-05,  -2.885400833542885D-03,   1.125576578128837D-01, &
&   -1.837971191054947D-21,  -6.442738160717534D-21,   5.063885585239256D-19, &
&   -1.034389066519592D-17,   9.391332061462691D-17,   1.111445952589457D-15, &
&   -6.096849744441958D-14,   1.222238629687350D-12,  -1.009783768176282D-11, &
&   -3.051719636280741D-10,   2.123914612466801D-08,  -9.219732726795118D-07, &
&    3.665650230056431D-05,  -1.433319546003711D-03,   5.591208159155823D-02, &
&   -6.454379723116903D-22,  -1.849678788531362D-21,   1.669780731743063D-19, &
&   -3.488693728513038D-18,   3.282970736166078D-17,   3.442205547118303D-16, &
&   -2.000900154455716D-14,   4.020661026347473D-13,  -3.131580517780679D-12, &
&   -1.130534481930916D-10,   7.564487141828342D-09,  -3.267592326239770D-07, &
&    1.298131521653099D-05,  -5.075364877096597D-04,   1.979822686326479D-02, &
&   -7.072850858693687D-23,  -1.836288275106870D-22,   1.779969432650173D-20, &
&   -3.757665846932911D-19,   3.592510811856555D-18,   3.557767812782932D-17, &
&   -2.127874054698671D-15,   4.279262109919437D-14,  -3.229740343429565D-13, &
&   -1.271343635906305D-11,   8.360707717150791D-10,  -3.603461923475647D-08, &
&    1.431047026595678D-06,  -5.594773210386899D-05,   2.182427605719921D-03, &
&    1.271405547528362D-20,  -9.357908422827006D-20,   1.981052544037324D-19, &
&    3.284612996213856D-17,  -1.251337582057945D-15,   2.958571678454586D-14, &
&   -5.209539854510648D-13,   6.565027477445679D-12,  -2.383762120867452D-11, &
&   -2.328426615099808D-09,   1.333243171017016D-07,  -5.901518404060636D-06, &
&    2.498427297027685D-04,  -1.050283638766353D-02,   4.411484067702713D-01, &
&    5.248064922748896D-21,  -5.314908889579447D-20,   5.271188031855372D-19, &
&    5.001741780178230D-18,  -3.981893964077130D-16,   1.107929050666510D-14, &
&   -2.072117577357073D-13,   2.497997242151624D-12,   4.311963826054685D-12, &
&   -1.691028135678330D-09,   8.767012836346501D-08,  -3.827215472033624D-06, &
&    1.617136270881781D-04,  -6.796682471914733D-03,   2.854754828030903D-01, &
&    2.466485255284278D-21,  -2.807391829447779D-20,   3.368154431738933D-19, &
&    8.983464371833715D-19,  -1.749302092762732D-16,   5.278209705004861D-15, &
&   -1.007401885498646D-13,   1.147488236406857D-12,   7.748466717653108D-12, &
&   -1.114125079183805D-09,   5.561484358655517D-08,  -2.413574078602438D-06, &
&    1.018951412437432D-04,  -4.282163901525207D-03,   1.798590180354046D-01, &
&    1.189514064715685D-21,  -1.443370854240939D-20,   1.879392864989149D-19, &
&    3.499266599983118D-20,  -8.169391584119979D-17,   2.586638727817391D-15, &
&   -4.976642698246727D-14,   5.376376724329395D-13,   6.061416648006925D-12, &
&   -6.627964075371164D-10,   3.244012335508266D-08,  -1.403309184962283D-06, &
&    5.921610433063315D-05,  -2.488437838751476D-03,   1.045187184393146D-01, &
&    5.243545180408055D-22,  -6.610514048548684D-21,   8.990656499413702D-20, &
&   -9.323797093978472D-20,  -3.535084548994783D-17,   1.153338066297306D-15, &
&   -2.225993418463200D-14,   2.302262053993531D-13,   3.461118882999835D-12, &
&   -3.337206371665927D-10,   1.615011401874453D-08,  -6.973029242264199D-07, &
&    2.941608988805200D-05,  -1.236113051297017D-03,   5.191877934747843D-02, &
&    1.727908721972913D-22,  -2.227178464446496D-21,   3.101760773669248D-20, &
&   -5.201627303467682D-20,  -1.152467357873757D-17,   3.827366338951278D-16, &
&   -7.395155612188673D-15,   7.415994328916369D-14,   1.316201734521554D-12, &
&   -1.190769028112191D-10,   5.725964290501485D-09,  -2.469570931516680D-07, &
&    1.041631206766077D-05,  -4.377027570517687D-04,   1.838421046257088D-02, &
&    1.841177763661729D-23,  -2.397648929368255D-22,   3.374852496655399D-21, &
&   -6.608799383959378D-21,  -1.221869182737003D-18,   4.091769246791098D-17, &
&   -7.908454015284929D-16,   7.804863640978311D-15,   1.496633892198461D-13, &
&   -1.317222636304797D-11,   6.315625249095920D-10,  -2.722523857217085D-08, &
&    1.148236689910984D-06,  -4.824952511741942D-05,   2.026555375328969D-03, &
&    6.266649278024367D-22,   9.435029253182355D-21,  -5.508629008803741D-19, &
&    1.651218206221128D-17,  -3.737331531678264D-16,   6.728244930968911D-15, &
&   -9.073256593333075D-14,   4.418791648735452D-13,   3.217234978622712D-11, &
&   -2.068154883044079D-09,   9.916778303356763D-08,  -4.511015894189409D-06, &
&    2.032958022878643D-04,  -9.149673839385655D-03,   4.117393687160921D-01, &
&    6.463319283995054D-22,  -3.235768048650947D-22,  -1.622731052003828D-19, &
&    6.090697276251078D-18,  -1.515550878602863D-16,   2.837653354704790D-15, &
&   -3.680799016277019D-14,   1.431161957500029D-14,   2.368393473747203D-11, &
&   -1.363627618744600D-09,   6.435558186072634D-08,  -2.920194934171964D-06, &
&    1.315608155354416D-04,  -5.920936030978907D-03,   2.664442210166429D-01, &
&    3.893750195999140D-22,  -9.840796314902149D-22,  -6.724080819693349D-20, &
&    2.877814365575976D-18,  -7.482219542916116D-17,   1.418197349764590D-15, &
&   -1.759132103042092D-14,  -6.305640702341462D-14,   1.570541546830022D-11, &
&   -8.662297449835519D-10,   4.059846149375677D-08,  -1.840121408399234D-06, &
&    8.288894193088733D-05,  -3.730388702998836D-03,   1.678686577629337D-01, &
&    2.128944064336738D-22,  -7.140439259822845D-22,  -3.010435539305275D-20, &
&    1.404278388900135D-18,  -3.742476815390922D-17,   7.123158731905072D-16, &
&   -8.488485597416635D-15,  -5.938311529956583D-14,   9.377735446156551D-12, &
&   -5.056827715597279D-10,   2.360953080868743D-08,  -1.069421617796753D-06, &
&    4.816840579580657D-05,  -2.167784612585681D-03,   9.755093241875193D-02, &
&    1.008589136092924D-22,  -3.813812278040521D-22,  -1.264967351174809D-20, &
&    6.247666316454231D-19,  -1.689795809808704D-17,   3.219961258793077D-16, &
&   -3.716001930367652D-15,  -3.613358456436386D-14,   4.732231018253229D-12, &
&   -2.518770258694231D-10,   1.173295880399873D-08,  -5.312560822215653D-07, &
&    2.392737143324123D-05,  -1.076828742531736D-03,   4.845758778999582D-02, &
&    3.462218950167884D-23,  -1.388433127980273D-22,  -4.047706290786191D-21, &
&    2.071056803529787D-19,  -5.649387164609162D-18,   1.076613573631183D-16, &
&   -1.215076881643106D-15,  -1.413875011268757D-14,   1.690714114550518D-12, &
&   -8.932833456304747D-11,   4.155641582438755D-09,  -1.881216228688256D-07, &
&    8.472602981589745D-06,  -3.813003597369348D-04,   1.715861710596608D-02, &
&    3.758808987299013D-24,  -1.545625764991369D-23,  -4.252717035727916D-22, &
&    2.213158538325624D-20,  -6.060698706966537D-19,   1.154861517713312D-17, &
&   -1.288595125488964D-16,  -1.626604993415532D-15,   1.871374844976356D-13, &
&   -9.854087162478052D-12,   4.581444952478709D-10,  -2.073761623717617D-08, &
&    9.339658086130481D-07,  -4.203206604038896D-05,   1.891453926176628D-03, &
&   -3.445807597627890D-22,   6.466773611800813D-21,  -1.759666515723086D-19, &
&    3.971788364936143D-18,  -7.350918598200734D-17,   1.044490631795752D-15, &
&   -5.551624173323012D-15,  -4.176309558394425D-13,   2.901340151398897D-11, &
&   -1.492243033758606D-09,   7.255092162173926D-08,  -3.489415726814516D-06, &
&    1.675332452514990D-04,  -8.041776028859446D-03,   3.860057659559215D-01, &
&   -8.760316565883909D-23,   2.316410802874015D-21,  -7.152775633754227D-20, &
&    1.709322939241561D-18,  -3.242647556567009D-17,   4.422236085761423D-16, &
&   -4.376386466864293D-16,  -3.072305164994426D-13,   1.914666837765882D-11, &
&   -9.688029897250660D-10,   4.697089144049695D-08,  -2.258185516982041D-06, &
&    1.084143654264804D-04,  -5.203984165767389D-03,   2.497915135442116D-01, &
&   -3.172143831292514D-23,   1.073649359303872D-21,  -3.535089327054153D-20, &
&    8.666165283677795D-19,  -1.654626317881260D-17,   2.163568844065677D-16, &
&    5.912522548003438D-16,  -2.039927728073415D-13,   1.217017048905122D-11, &
&   -6.113023087721187D-10,   2.959974227273773D-08,  -1.422767737963366D-06, &
&    6.830477779348315D-05,  -3.278682178962628D-03,   1.573768980547384D-01, &
&   -1.263569308270901D-23,   5.173915045256638D-22,  -1.770169188605604D-20, &
&    4.400366762411247D-19,  -8.412105255219212D-18,   1.060643991844172D-16, &
&    6.217348076949297D-16,  -1.219329181037428D-13,   7.107489263725029D-12, &
&   -3.555436877301615D-10,   1.720303066787257D-08,  -8.268033982000150D-07, &
&    3.969295563348241D-05,  -1.905290276952807D-03,   9.145401600340700D-02, &
&   -4.830218950985105D-24,   2.283377663767166D-22,  -8.000764080192421D-21, &
&    2.005043610451458D-19,  -3.831400558129055D-18,   4.694701941204750D-17, &
&    3.907792814166953D-16,  -6.157545375221894D-14,   3.541111914665342D-12, &
&   -1.767055595210379D-10,   8.546118812250812D-09,  -4.107112076575289D-07, &
&    1.971715007927157D-05,  -9.464366125434443D-04,   4.542899650646098D-02, &
&   -1.445390910001070D-24,   7.532515322993900D-23,  -2.676864415330049D-21, &
&    6.739176717211155D-20,  -1.286818607748479D-18,   1.546111710124331D-17, &
&    1.550622888079989D-16,  -2.200951732042351D-14,   1.256054968862152D-12, &
&   -6.258968333560142D-11,   3.026279537516881D-09,  -1.454317905298246D-07, &
&    6.981758652494959D-06,  -3.351290173264306D-04,   1.608620626541198D-02, &
&   -1.466390866605987D-25,   8.030912161332512D-24,  -2.872903047183932D-22, &
&    7.247797307472726D-21,  -1.383264598434246D-19,   1.645473965037329D-18, &
&    1.794047072738105D-17,  -2.436667797071464D-15,   1.385696412385899D-13, &
&   -6.900450624683000D-12,   3.336042995387904D-10,  -1.603149068904635D-08, &
&    7.696236554100906D-07,  -3.694243525949838D-05,   1.773238352071110D-03, &
&   -1.220783181797225D-22,   1.625775146750853D-21,  -3.578642380767063D-20, &
&    6.911666427407309D-19,  -1.020534183095185D-17,   5.022375111429321D-17, &
&    5.136425750360296D-15,  -3.717028582185453D-13,   2.031020687929163D-11, &
&   -1.050090588699162D-09,   5.368104537246491D-08,  -2.738650533911042D-06, &
&    1.396764188735086D-04,  -7.123519518178736D-03,   3.632995570794005D-01, &
&   -4.908363232426208D-23,   7.019074312653891D-22,  -1.613625925813429D-20, &
&    3.156607760312476D-19,  -4.441804033362687D-18,   9.732983402377648D-19, &
&    3.729441149621687D-15,  -2.450932995045495D-13,   1.318724456013854D-11, &
&   -6.798945043885505D-10,   3.474043874063711D-08,  -1.772244696014375D-06, &
&    9.038726041976146D-05,  -4.609762130011000D-03,   2.350979018400639D-01, &
&   -2.409021615274469D-23,   3.565824413391191D-22,  -8.354151281460115D-21, &
&    1.636469526633429D-19,  -2.201424803880967D-18,  -8.321145282461768D-18, &
&    2.467168713816377D-15,  -1.557627802492439D-13,   8.321653975316997D-12, &
&   -4.284661461567908D-10,   2.188837563379620D-08,  -1.116576712040673D-06, &
&    5.694697342489389D-05,  -2.904302322904873D-03,   1.481194372549490D-01, &
&   -1.201187217694649D-23,   1.813643326097918D-22,  -4.292249995957917D-21, &
&    8.395493067679085D-20,  -1.087403215070424D-18,  -7.745378952244305D-18, &
&    1.472415546694826D-15,  -9.096386165263047D-14,   4.840284190030522D-12, &
&   -2.490252166790381D-10,   1.271991151940434D-08,  -6.488604420169205D-07, &
&    3.309272425776408D-05,  -1.687732546552397D-03,   8.607437005029834D-02, &
&   -5.414038207016668D-24,   8.274891643048174D-23,  -1.969714399323996D-21, &
&    3.844979245490231D-20,  -4.835913499088664D-19,  -4.712108082070916D-18, &
&    7.429900803593847D-16,  -4.532029450866030D-14,   2.405715742289304D-12, &
&   -1.237124677346581D-10,   6.318585035893075D-09,  -3.223162751585564D-07, &
&    1.643852808704418D-05,  -8.383666419029892D-04,   4.275670356320857D-02, &
&   -1.808626115827062D-24,   2.783819406348386D-23,  -6.647796524932058D-22, &
&    1.295561013743076D-20,  -1.597116907484972D-19,  -1.845556862035910D-18, &
&    2.654700303487884D-16,  -1.607552090141375D-14,   8.521318905323515D-13, &
&   -4.380838836468471D-11,   2.237399244595491D-09,  -1.141308531635879D-07, &
&    5.820810276469190D-06,  -2.968619119626619D-04,   1.513995917109592D-02, &
&   -1.939681171147710D-25,   2.995306685130436D-24,  -7.163206735616715D-23, &
&    1.394761962438336D-21,  -1.702022422572532D-20,  -2.124554385182154D-19, &
&    2.938516088486376D-17,  -1.773482136640212D-15,   9.394772590213476D-14, &
&   -4.829271361110917D-12,   2.466371218763290D-10,  -1.258104467371954D-08, &
&    6.416481392573405D-07,  -3.272411900560070D-05,   1.668930249912809D-03, &
&   -2.555622143829381D-23,   2.935805940294799D-22,  -5.570470103766274D-21, &
&    8.555084366103963D-20,  -2.902985619483476D-19,  -5.964331235930450D-17, &
&    4.378541543430315D-15,  -2.520927677881488D-13,   1.379734484078842D-11, &
&   -7.469232137001161D-10,   4.034980497877859D-08,  -2.179001499341554D-06, &
&    1.176667025739359D-04,  -6.354004496453668D-03,   3.431162497503906D-01, &
&   -1.158128166336055D-23,   1.367646997466892D-22,  -2.614513190060522D-21, &
&    3.777607820887498D-20,   8.748364025277388D-20,  -4.244618490520979D-17, &
&    2.881166603824665D-15,  -1.636529260849595D-13,   8.933397433744548D-12, &
&   -4.833867926458742D-10,   2.611136513904086D-08,  -1.410073738330600D-06, &
&    7.614431729983649D-05,  -4.111794523275410D-03,   2.220369080499460D-01, &
&   -6.014039739342182D-24,   7.186724673802750D-23,  -1.371978713270764D-21, &
&    1.879099629857023D-20,   1.352822270202581D-19,  -2.788488758917814D-17, &
&    1.829631568530364D-15,  -1.032656786896463D-13,   5.629849277971361D-12, &
&   -3.045618463568977D-10,   1.645110300797375D-08,  -8.883934200651567D-07, &
&    4.797343459682489D-05,  -2.590566257355813D-03,   1.398905800587371D-01, &
&   -3.098156476008056D-24,   3.723544257612257D-23,  -7.085729343611178D-22, &
&    9.284853851657221D-21,   1.050793916474207D-19,  -1.658524212638361D-17, &
&    1.068070302055540D-15,  -6.006308354959634D-14,   3.272104730063289D-12, &
&   -1.769895384630503D-10,   9.560004498026258D-09,  -5.162585505907068D-07, &
&    2.787806465018672D-05,  -1.505415919626719D-03,   8.129246083581789D-02, &
&   -1.423840909987254D-24,   1.717399008259825D-23,  -3.257969090189103D-22, &
&    4.125850527229692D-21,   6.012374097763968D-20,  -8.353351311220838D-18, &
&    5.320222077482367D-16,  -2.985222120180617D-14,   1.625547935099166D-12, &
&   -8.791932024191618D-11,   4.748858717830375D-09,  -2.564470439644933D-07, &
&    1.384818919847225D-05,  -7.478024202642816D-04,   4.038133125352259D-02, &
&   -4.811464267514078D-25,   5.813239661744613D-24,  -1.100238672555253D-22, &
&    1.361324388999696D-21,   2.291998452083359D-20,  -2.981579009285865D-18, &
&    1.886906258055955D-16,  -1.057394567073179D-14,   5.756322271552683D-13, &
&   -3.113211040706766D-11,   1.681551626921574D-09,  -9.080677093986688D-08, &
&    4.903582437281193D-06,  -2.647935217318092D-04,   1.429885036630613D-02, &
&   -5.187597750987100D-26,   6.272456074047097D-25,  -1.185705946608926D-23, &
&    1.449896428286142D-22,   2.609776752772119D-21,  -3.298816880950936D-19, &
&    2.081559430196076D-17,  -1.165777542667443D-15,   6.345562965641845D-14, &
&   -3.431814425775821D-12,   1.853633656579961D-10,  -1.000994604542574D-08, &
&    5.405389142382980D-07,  -2.918910899728222D-05,   1.576211906834173D-03, &
&   -4.140280038834058D-24,   4.181721338052834D-23,  -6.021160278978243D-22, &
&   -2.431103255149322D-24,   6.485226753827193D-19,  -4.765194636298817D-17, &
&    2.872937051861712D-15,  -1.657919398533101D-13,   9.473248431304435D-12, &
&   -5.402016495341804D-10,   3.079337319605701D-08,  -1.755235118603292D-06, &
&    1.000484712929141D-04,  -5.702763143283464D-03,   3.250574999100618D-01, &
&   -1.983715358215400D-24,   2.000519245958489D-23,  -2.650950086717575D-22, &
&   -2.127936257029402D-21,   4.517705335731631D-19,  -3.127086218728277D-17, &
&    1.864360894325755D-15,  -1.073424203441314D-13,   6.130823276798926D-12, &
&   -3.495784955737806D-10,   1.992699013060495D-08,  -1.135845427422207D-06, &
&    6.474322742187304D-05,  -3.690364116915313D-03,   2.103507550750853D-01, &
&   -1.055865224420952D-24,   1.058583268535587D-23,  -1.305299401335518D-22, &
&   -1.974767105234812D-21,   2.943609279039969D-19,  -1.983529923988586D-17, &
&    1.176238840847408D-15,  -6.764673026737306D-14,   3.862782945592374D-12, &
&   -2.202472641442801D-10,   1.255466972693672D-08,  -7.156201488115659D-07, &
&    4.079037018899254D-05,  -2.325051188783077D-03,   1.325279179962984D-01, &
&   -5.509516905240113D-25,   5.491534163954704D-24,  -6.377373932680563D-23, &
&   -1.359480701970628D-21,   1.743380065452047D-19,  -1.157198680432417D-17, &
&    6.840873512954341D-16,  -3.931651798512621D-14,   2.244775733952000D-12, &
&   -1.279893484941026D-10,   7.295704988674366D-09,  -4.158573436254891D-07, &
&    2.370388040209201D-05,  -1.351121230909029D-03,   7.701391029052502D-02, &
&   -2.552288428670097D-25,   2.531457394351320D-24,  -2.805493701517150D-23, &
&   -7.392415433898174D-22,   8.759582230550698D-20,  -5.762120577386595D-18, &
&    3.399852044676091D-16,  -1.953199013181083D-14,   1.115090351227690D-12, &
&   -6.357774620698484D-11,   3.624079650288712D-09,  -2.065735660407091D-07, &
&    1.177469888504225D-05,  -6.711578593017377D-04,   3.825599804155822D-02, &
&   -8.660669208775103D-26,   8.561364703221300D-25,  -9.188175366933746D-24, &
&   -2.749697021013238D-22,   3.122349319899438D-20,  -2.043217123264831D-18, &
&    1.204228254094856D-16,  -6.916577094159272D-15,   3.948521710784330D-13, &
&   -2.251262687265649D-11,   1.283270725973759D-09,  -7.314678487548783D-08, &
&    4.169368675860225D-06,  -2.376540224090977D-04,   1.354627929850134D-02, &
&   -9.354970273056318D-27,   9.232061839531930D-26,  -9.747462773950681D-25, &
&   -3.098660688010462D-23,   3.452442883623359D-21,  -2.253785465031587D-19, &
&    1.327645475681710D-17,  -7.624581694734464D-16,   4.352611198491362D-14, &
&   -2.481646487560463D-12,   1.414593960949932D-10,  -8.063224038382346D-09, &
&    4.596039811110559D-07,  -2.619742778178850D-05,   1.493253385868808D-03, &
&   -5.368515056790790D-25,   3.946888637603626D-24,   2.860727316459538D-23, &
&   -6.561222768999570D-21,   4.809054766904227D-19,  -3.023415722592219D-17, &
&    1.833568402599995D-15,  -1.102592719054621D-13,   6.618259853532700D-12, &
&   -3.971213854020151D-10,   2.382749191000687D-08,  -1.429650909680327D-06, &
&    8.577906197348753D-05,  -5.146743747553519D-03,   3.088046249292339D-01, &
&   -2.600920492886777D-25,   1.708418006405298D-24,   3.285964019912910D-23, &
&   -4.483549287351348D-21,   3.146882382364994D-19,  -1.961102556296227D-17, &
&    1.187076160621303D-15,  -7.135641753170609D-14,   4.282849327049653D-12, &
&   -2.569850202758764D-10,   1.541921569801183D-08,  -9.251537109667831D-07, &
&    5.550922675380165D-05,  -3.330553621449684D-03,   1.998332173294770D-01, &
&   -1.392671777034371D-25,   8.223424091024153D-25,   2.508498227135335D-23, &
&   -2.898219414817018D-21,   1.993549023109351D-19,  -1.237014160011306D-17, &
&    7.480699670185379D-16,  -4.495870509314680D-14,   2.698352813026050D-12, &
&   -1.619091705228598D-10,   9.714615582701681D-09,  -5.828773752459980D-07, &
&    3.497264486572432D-05,  -2.098358701277579D-03,   1.259015221011641D-01, &
&   -7.130256793133256D-26,   3.935865194099621D-25,   1.604723747385855D-23, &
&   -1.709212077945234D-21,   1.162221999699089D-19,  -7.193491013615959D-18, &
&    4.347743797248268D-16,  -2.612679133282723D-14,   1.568058008889150D-12, &
&   -9.408783011725881D-11,   5.645305397472240D-09,  -3.387185640457070D-07, &
&    2.032311512739723D-05,  -1.219386912752097D-03,   7.316321477855811D-02, &
&   -3.358120702494058D-26,   1.696615299912359D-25,   8.426079581395329D-24, &
&   -8.566655423629437D-22,   5.784699637387152D-20,  -3.574849275064639D-18, &
&    2.159889543923995D-16,  -1.297845436742168D-14,   7.789211248509216D-13, &
&   -4.673733484426656D-11,   2.804257026740634D-09,  -1.682555360304108D-07, &
&    1.009533277444006D-05,  -6.057199689047310D-04,   3.634319814070130D-02, &
&   -1.118914323337261D-26,   5.482463007542132D-26,   3.075444669965651D-24, &
&   -3.049290921040882D-22,   2.050727623945958D-20,  -1.266161138205943D-18, &
&    7.648461074572895D-17,  -4.595654154611606D-15,   2.758128925139581D-13, &
&   -1.654948598071538D-11,   9.929749992881997D-10,  -5.957853944318586D-08, &
&    3.574712578120795D-06,  -2.144827555296604D-04,   1.286896533399797D-02, &
&   -1.213703257434015D-27,   5.770673686980870D-27,   3.438511896031670D-25, &
&   -3.369489694468511D-23,   2.261817598036840D-21,  -1.395899633075027D-19, &
&    8.431364143803768D-18,  -5.065970252543797D-16,   3.040383188569187D-14, &
&   -1.824307433645758D-12,   1.094590817358015D-10,  -6.567549203406250D-09, &
&    3.940529752425382D-07,  -2.364317860632616D-05,   1.418590716621302D-03, &
&   -4.098589525493559D-26,  -4.199401745499672D-25,   6.172374858339877D-23, &
&   -4.515748098666397D-21,   2.952750560501794D-19,  -1.876739486117831D-17, &
&    1.184613284435821D-15,  -7.465836239622707D-14,   4.703775134094358D-12, &
&   -2.963406156306408D-10,   1.866948083539057D-08,  -1.176177437108485D-06, &
&    7.409917928953586D-05,  -4.668248298153677D-03,   2.940996427911580D-01, &
&   -1.604672599132500D-26,  -3.653905635697836D-25,   4.147963240961824D-23, &
&   -2.947135405553363D-21,   1.914347687562874D-19,  -1.214933137275644D-17, &
&    7.666382912046623D-16,  -4.831335381409233D-14,   3.043905149379353D-12, &
&   -1.917675608465681D-10,   1.208136857065634D-08,  -7.611263004981311D-07, &
&    4.795095735223481D-05,  -3.020910314828105D-03,   1.903173498383886D-01, &
&   -7.900144523716121D-27,  -2.594740778425038D-25,   2.662517636702055D-23, &
&   -1.864712239156199D-21,   1.207248384515246D-19,  -7.655972298894086D-18, &
&    4.830247688679231D-16,  -3.043918512644760D-14,   1.917762285091138D-12, &
&   -1.208199043052013D-10,   7.611661001401891D-09,  -4.795346894747911D-07, &
&    3.021068567983430D-05,  -1.903273198776675D-03,   1.199062115253754D-01, &
&   -2.924662565753861D-27,  -1.606863564861363D-25,   1.563385749898560D-23, &
&   -1.086351713148736D-21,   7.019486047059436D-20,  -4.449519330224502D-18, &
&    2.806988479480161D-16,  -1.768871813505297D-14,   1.114440256213939D-12, &
&   -7.021021666459962D-11,   4.423247493388212D-09,  -2.786646174820516D-07, &
&    1.755587103456823D-05,  -1.106019875697812D-03,   6.967925217030617D-02, &
&   -1.376069479478802D-27,  -8.282072851789305D-26,   7.819037405221717D-24, &
&   -5.404797736847494D-22,   3.488101193930730D-20,  -2.210422321937899D-18, &
&    1.394366357217241D-16,  -8.786738273577850D-15,   5.535887945558398D-13, &
&   -3.487632304397653D-11,   2.197210185219341D-09,  -1.384242537961367D-07, &
&    8.720728052813634D-06,  -5.494058675759887D-04,   3.461256965793067D-02, &
&   -3.949921812919994D-28,  -2.996431300698825D-26,   2.779163864242121D-24, &
&   -1.915579740658158D-22,   1.235379612706385D-20,  -7.827347423368960D-19, &
&    4.937429344934386D-17,  -3.111349191732170D-15,   1.960233748406954D-13, &
&   -1.234955164838967D-11,   7.780223870384471D-10,  -4.901541457404528D-08, &
&    3.087971140173541D-06,  -1.945421819169723D-04,   1.225615746099192D-02, &
&   -3.960948823910005D-29,  -3.335986644836427D-27,   3.068998440428387D-25, &
&   -2.112519069495730D-23,   1.361935125658348D-21,  -8.628532300281807D-20, &
&    5.442720363856785D-18,  -3.429750342396927D-16,   2.160833891819148D-14, &
&   -1.361333957838990D-12,   8.576410831205541D-11,  -5.403139280232854D-09, &
&    3.403977770531512D-07,  -2.144505996372723D-05,   1.351038777739092D-03, &
&    9.545831663040918D-27,  -5.353378023802665D-25,   3.954283457672122D-23, &
&   -2.687967132573676D-21,   1.786495839977824D-19,  -1.180939377678772D-17, &
&    7.796684030727606D-16,  -5.146108445900506D-14,   3.396462866674199D-12, &
&   -2.241668354349509D-10,   1.479501336646001D-08,  -9.764708965363107D-07, &
&    6.444707924487001D-05,  -4.253507230441866D-03,   2.807314772098727D-01, &
&    7.658693073196016D-27,  -3.562420263536776D-25,   2.574171095503687D-23, &
&   -1.741907042220230D-21,   1.156422223517929D-19,  -7.642518260329119D-18, &
&    5.045429078237193D-16,  -3.330147487320807D-14,   2.197914737154993D-12, &
&   -1.450625324880402D-10,   9.574128393421157D-09,  -6.318924820439867D-07, &
&    4.170490385641589D-05,  -2.752523654682445D-03,   1.816665612094450D-01, &
&    4.427811617698829D-27,  -2.273109931555190D-25,   1.627457279927979D-23, &
&   -1.098266512771239D-21,   7.286980733993984D-20,  -4.815184344962251D-18, &
&    3.178803446184610D-16,  -2.098104496171260D-14,   1.384758969645742D-12, &
&   -9.139418412314137D-11,   6.032016873784851D-09,  -3.981131183464340D-07, &
&    2.627546583494539D-05,  -1.734180745198801D-03,   1.144559291833559D-01, &
&    3.323288601374451D-27,  -1.335304414564277D-25,   9.469686690982227D-24, &
&   -6.384982907955858D-22,   4.234974494781135D-20,  -2.798225510691358D-18, &
&    1.847255045015055D-16,  -1.219239786816820D-14,   8.047037305135453D-13, &
&   -5.311049668290460D-11,   3.505293176967990D-09,  -2.313493522488488D-07, &
&    1.526905726166852D-05,  -1.007757779321006D-03,   6.651201343531591D-02, &
&    1.399119242683453D-27,  -6.643602168415677D-26,   4.711820695281311D-24, &
&   -3.172578442742811D-22,   2.103811468661431D-20,  -1.390010547495763D-18, &
&    9.176099140643004D-17,  -6.056470725079395D-15,   3.997296786009021D-13, &
&   -2.638218289329348D-11,   1.741224260219179D-09,  -1.149208024036150D-07, &
&    7.584772964980613D-06,  -5.005950157131039D-04,   3.303927103712697D-02, &
&    5.610727803848724D-28,  -2.365167727923374D-26,   1.669102221016058D-24, &
&   -1.123575996399577D-22,   7.449768126726629D-21,  -4.921999657768719D-19, &
&    3.249219925231570D-17,  -2.144569828455597D-15,   1.415425104846252D-13, &
&   -9.341814023322397D-12,   6.165597909865886D-10,  -4.069294663037324D-08, &
&    2.685734479799884D-06,  -1.772584756752363D-04,   1.169905939458712D-02, &
&    6.029317984993470D-29,  -2.608298312765718D-27,   1.840644910366786D-25, &
&   -1.238653820868236D-23,   8.212273767987727D-22,  -5.425708616439801D-20, &
&    3.581729924597938D-18,  -2.364033964735085D-16,   1.560272240251085D-14, &
&   -1.029780586355428D-12,   6.796552583245457D-11,  -4.485724751301273D-09, &
&    2.960578338252518D-07,  -1.953981703338754D-05,   1.289627924205925D-03, &
&    8.725254338043302D-27,  -3.252406235627687D-25,   2.286412693037387D-23, &
&   -1.588441130237044D-21,   1.097379035062245D-19,  -7.573878756376785D-18, &
&    5.226235144852294D-16,  -3.606132601599095D-14,   2.488234636026073D-12, &
&   -1.716882181356416D-10,   1.184648726776747D-08,  -8.174076228492432D-07, &
&    5.640112598353045D-05,  -3.891677692889710D-03,   2.685257608094552D-01, &
&    5.550326165229503D-27,  -2.115969045306826D-25,   1.481249289717454D-23, &
&   -1.028143358218931D-21,   7.101667446562896D-20,  -4.901238227669058D-18, &
&    3.381998489144143D-16,  -2.333595934002339D-14,   1.610182958517248D-12, &
&   -1.111026400649786D-10,   7.666082286934924D-09,  -5.289596785781967D-07, &
&    3.649821782584416D-05,  -2.518377029998163D-03,   1.737680150699106D-01, &
&    3.676638193894141D-27,  -1.334814490786683D-25,   9.336206133228808D-24, &
&   -6.478432106385291D-22,   4.474393669784430D-20,  -3.087955444116394D-18, &
&    2.130772193142643D-16,  -1.470242606671124D-14,   1.014468418528986D-12, &
&   -6.999833010659180D-11,   4.829884848442315D-09,  -3.332620549960017D-07, &
&    2.299508179702475D-05,  -1.586660644003413D-03,   1.094795844362573D-01, &
&    2.210744702809937D-27,  -7.767080847641146D-26,   5.426632076861235D-24, &
&   -3.764988536088705D-22,   2.600174303465522D-20,  -1.794460903423574D-18, &
&    1.238223414086944D-16,  -8.543795235791208D-15,   5.895224310767307D-13, &
&   -4.067705281595798D-11,   2.806716683418321D-09,  -1.936634514056926D-07, &
&    1.336277814826164D-05,  -9.220316922348595D-04,   6.362018676421738D-02, &
&    9.682766036785369D-28,  -3.868397435786290D-26,   2.697251566199072D-24, &
&   -1.870307268093773D-22,   1.291625995924794D-20,  -8.913845589165071D-19, &
&    6.150770114669043D-17,  -4.244057025786269D-15,   2.928402024852260D-13, &
&   -2.020597639883112D-11,   1.394212390256020D-09,  -9.620065504741962D-08, &
&    6.637845198880603D-06,  -4.580113187250686D-04,   3.160278099203553D-02, &
&    3.825246821507990D-28,  -1.367790060428638D-26,   9.548917907394070D-25, &
&   -6.622876851821739D-23,   4.573616898589721D-21,  -3.156356430835472D-19, &
&    2.177960793560324D-17,  -1.502801813317595D-15,   1.036934177099235D-13, &
&   -7.154846661949962D-12,   4.936844261613011D-10,  -3.406422544660809D-08, &
&    2.350431556026862D-06,  -1.621797773666532D-04,   1.119040463830108D-02, &
&    4.137978769861272D-29,  -1.509763668519563D-27,   1.052736204684785D-25, &
&   -7.300709425201957D-24,   5.041669703452924D-22,  -3.479362929793670D-20, &
&    2.400841968973147D-18,  -1.656590619661147D-16,   1.143048536790462D-14, &
&   -7.887035819616723D-13,   5.442054786272474D-11,  -3.755017807052108D-09, &
&    2.590962287096036D-07,  -1.787763978104991D-05,   1.233557144892663D-03, &
&    5.117829917911200D-27,  -1.834550898356258D-25,   1.322279651738419D-23, &
&   -9.544101444671279D-22,   6.873163898213515D-20,  -4.948873489321288D-18, &
&    3.563214717903196D-16,  -2.565517573974231D-14,   1.847172956489978D-12, &
&   -1.329964555545210D-10,   9.575744820225482D-09,  -6.894536271833599D-07, &
&    4.964066115783565D-05,  -3.574127603366525D-03,   2.573371874423956D-01, &
&    3.003825222839017D-27,  -1.191232148653890D-25,   8.560563197314002D-24, &
&   -6.176356810072594D-22,   4.447780605831643D-20,  -3.202511682155303D-18, &
&    2.305822922965902D-16,  -1.660194185564602D-14,   1.195339985437247D-12, &
&   -8.606448047933848D-11,   6.196642606090348D-09,  -4.461582677112251D-07, &
&    3.212339527557174D-05,  -2.312884459842522D-03,   1.665276811086649D-01, &
&    2.246285654556564D-27,  -7.445993656606536D-26,   5.391243868690578D-24, &
&   -3.891425578616169D-22,   2.802259251725805D-20,  -2.017689265702502D-18, &
&    1.452744677003411D-16,  -1.045977142301902D-14,   7.531036422889791D-13, &
&   -5.422346313411965D-11,   3.904089352407518D-09,  -2.810944334158130D-07, &
&    2.023879920615119D-05,  -1.457193542843681D-03,   1.049179350847470D-01, &
&    1.310933575996752D-27,  -4.382644108896905D-26,   3.132965676887143D-24, &
&   -2.261351043779600D-22,   1.628437452046348D-20,  -1.172509176170895D-18, &
&    8.442112153377209D-17,  -6.078326111085400D-15,   4.376395349599668D-13, &
&   -3.151004700728197D-11,   2.268723388249288D-09,  -1.633480839774080D-07, &
&    1.176106204649095D-05,  -8.467964673477882D-04,   6.096934564904184D-02, &
&    4.522728145884839D-28,  -2.156674232430671D-26,   1.557951767007718D-24, &
&   -1.123329733978409D-22,   8.089129018872711D-21,  -5.824339913579491D-19, &
&    4.193546812413929D-17,  -3.019356270826508D-15,   2.173936778332609D-13, &
&   -1.565234503902392D-11,   1.126968844597068D-09,  -8.114175682225282D-08, &
&    5.842206491258693D-06,  -4.206388673708373D-04,   3.028599845070081D-02, &
&    2.407147779756985D-28,  -7.662788677540344D-27,   5.510290477882320D-25, &
&   -3.977659101990149D-23,   2.864329145822436D-21,  -2.062373242437913D-19, &
&    1.484916366832951D-17,  -1.069140672427653D-15,   7.697813753342620D-14, &
&   -5.542425983826279D-12,   3.990546714549343D-10,  -2.873193634866058D-08, &
&    2.068699417123155D-06,  -1.489463580329405D-04,   1.072413777837190D-02, &
&    2.301212985893893D-29,  -8.444526292332238D-28,   6.077034066089248D-26, &
&   -4.384723289120498D-24,   3.157449804058728D-22,  -2.273425762446710D-20, &
&    1.636874869514396D-18,  -1.178550874511329D-16,   8.485567290937807D-15, &
&   -6.109608538288338D-13,   4.398918154325874D-11,  -3.167221071540790D-09, &
&    2.280399171530753D-07,  -1.641887403502943D-05,   1.182158930522139D-03/
      data w7 / &
&    1.494742923403058D-13,  -2.674046938650169D-12,   3.329775393255870D-11, &
&   -3.961830878307730D-10,   4.535864135866439D-09,  -4.802186893109046D-08, &
&    4.600053744111996D-07,  -3.929401493567189D-06,   2.946347017039828D-05, &
&   -1.900288860868240D-04,   1.025364517907952D-03,  -4.445759907935497D-03, &
&    1.452960314155946D-02,  -3.183960492608004D-02,   3.511946033175186D-02, &
&    1.665314454145707D-13,  -3.003472369444799D-12,   3.805932321597230D-11, &
&   -4.639978493148609D-10,   5.462135331038620D-09,  -5.966527600509329D-08, &
&    5.922609227715299D-07,  -5.269715854157317D-06,   4.140611787549600D-05, &
&   -2.818127129197062D-04,   1.617894293227027D-03,  -7.536778079075498D-03, &
&    2.677677120120862D-02,  -6.471183013877671D-02,   8.015808715976021D-02, &
&    6.719286033066971D-14,  -1.230658434901216D-12,   1.611831923910698D-11, &
&   -2.056514972655398D-10,   2.549130432372481D-09,  -2.950167415988890D-08, &
&    3.126897932383062D-07,  -2.998229022379928D-06,   2.566064642055986D-05, &
&   -1.926274252274079D-04,   1.237892347364903D-03,  -6.570883527802221D-03, &
&    2.719248233222956D-02,  -7.873905744003291D-02,   1.215185706879032D-01, &
&    1.178851558701992D-14,  -2.212264430376182D-13,   3.051566758856637D-12, &
&   -4.176055097335534D-11,   5.599750231073402D-10,  -7.073379318404652D-09, &
&    8.274892350394581D-08,  -8.873650473184706D-07,   8.624252346570536D-06, &
&   -7.484172095593622D-05,   5.679741968032207D-04,  -3.654482213535379D-03, &
&    1.895401278454533D-02,  -7.199720728147938D-02,   1.572031671581935D-01, &
&    8.446642269149213D-16,  -1.644178194152292D-14,   2.449389696164525D-13, &
&   -3.709251484957275D-12,   5.563015129011993D-11,  -7.951923040072571D-10, &
&    1.068311845074244D-08,  -1.338339546701302D-07,   1.549850009415826D-06, &
&   -1.640035545254374D-05,   1.560364519531371D-04,  -1.302925741354427D-03, &
&    9.179296552374652D-03,  -5.055927786085793D-02,   1.855383974779378D-01, &
&    1.941876798553184D-17,  -3.992739228131906D-16,   6.670181872985982D-15, &
&   -1.169056535679720D-13,   2.055479546528546D-12,  -3.496694252136405D-11, &
&    5.696188097187859D-10,  -8.840600154064409D-09,   1.299912904370885D-07, &
&   -1.797438507287291D-06,   2.313101109663247D-05,  -2.727832225509400D-04, &
&    2.873344085096725D-03,  -2.581007719269287D-02,   2.051984637212956D-01, &
&    5.133715649388854D-20,  -1.333652506552782D-18,   2.947907795312980D-17, &
&   -6.676209511677378D-16,   1.509930583744253D-14,  -3.362389058877226D-13, &
&    7.347054940322822D-12,  -1.572763137915077D-10,   3.291704156118270D-09, &
&   -6.722222490027175D-08,   1.336811995758997D-06,  -2.591111735126315D-05, &
&    4.944899029904557D-04,  -9.676278493413598D-03,   2.152638534631578D-01, &
&    1.814826284021037D-14,  -1.351339176045696D-13,   1.721792400118035D-12, &
&   -2.288937837755203D-11,   2.690441865609018D-10,  -2.876491568088012D-09, &
&    2.779308296468510D-08,  -2.395976870987709D-07,   1.814810228846386D-06, &
&   -1.183748890801133D-05,   6.468545820014409D-05,  -2.844964726244222D-04, &
&    9.450506690081609D-04,  -2.110148678439304D-03,   2.379010726594994D-03, &
&    2.105058623413970D-14,  -1.607337378918246D-13,   2.117257790557255D-12, &
&   -2.903498796040708D-11,   3.544398304720704D-10,  -3.958017900460502D-09, &
&    4.018835172941342D-08,  -3.666962660190547D-07,   2.964436786109922D-06, &
&   -2.084074336622814D-05,   1.241793842330515D-04,  -6.039137713972159D-04, &
&    2.256496323621097D-03,  -5.790429713531468D-03,   7.717668394428021D-03, &
&    9.133865761044484D-15,  -7.301267781817776D-14,   1.020875910875074D-12, &
&   -1.480683095227201D-11,   1.933616387606149D-10,  -2.331744532470316D-09, &
&    2.582618514134610D-08,  -2.600831376751584D-07,   2.352257218232335D-06, &
&   -1.879682216232866D-05,   1.297302955833210D-04,  -7.477288855630554D-04, &
&    3.407938810471197D-03,  -1.108230255779129D-02,   1.982207674680272D-02, &
&    1.781409927775053D-15,  -1.524415532220732D-14,   2.324226399001413D-13, &
&   -3.659628458519561D-12,   5.266867533665173D-11,  -7.085765253766276D-10, &
&    8.870926297732921D-09,  -1.025045424078324D-07,   1.082255029388407D-06, &
&   -1.030106424508548D-05,   8.673925744582437D-05,  -6.282532737241672D-04, &
&    3.738947052386057D-03,  -1.674948484169415D-02,   4.572310856543317D-02, &
&    1.470665995108847D-16,  -1.383131092801949D-15,   2.369245308095972D-14, &
&   -4.172326306590692D-13,   6.837414712368977D-12,  -1.062664281709811D-10, &
&    1.560797523648156D-09,  -2.153232528111071D-08,   2.769033570949996D-07, &
&   -3.285746213792690D-06,   3.546599717927485D-05,  -3.409185831547811D-04, &
&    2.819583866593734D-03,  -1.872705138973687D-02,   9.084322584416135D-02, &
&    4.056322891323141D-18,  -4.347489087724171D-17,   8.702804938404907D-16, &
&   -1.784582203170939D-14,   3.476430767290007D-13,  -6.530836257277092D-12, &
&    1.180376557872906D-10,  -2.044541808246762D-09,   3.377446286044097D-08, &
&   -5.286626283007322D-07,   7.770474318718758D-06,  -1.058019707921412D-04, &
&    1.304262878731225D-03,  -1.401231758597766D-02,   1.477785981796801D-01, &
&    1.783555808169134D-20,  -2.307533845258912D-19,   5.855535229491426D-18, &
&   -1.508859951225774D-16,   3.785473585502060D-15,  -9.370078547100844D-14, &
&    2.277774457675806D-12,  -5.444404790920754D-11,   1.275479059315685D-09, &
&   -2.927815067898172D-08,   6.575050694712475D-07,  -1.450499464236245D-05, &
&    3.186518628878740D-04,  -7.287680543425841D-03,   1.900798717743375D-01, &
&    1.069544291132321D-15,  -8.016379521434424D-15,   1.029949533637902D-13, &
&   -1.379300484513116D-12,   1.635340211758850D-11,  -1.765338782745369D-10, &
&    1.723947230673490D-09,  -1.503905370257322D-08,   1.154369371590951D-07, &
&   -7.643534672187272D-07,   4.248762718166293D-06,  -1.905710348754815D-05, &
&    6.476438110906688D-05,  -1.485445433610094D-04,   1.729568833747725D-04, &
&    1.335602921747872D-15,  -1.036781540328895D-14,   1.394882261707266D-13, &
&   -1.950187228827649D-12,   2.436115843734422D-11,  -2.792077009604614D-10, &
&    2.919075672825129D-09,  -2.753069016545999D-08,   2.310999771852110D-07, &
&   -1.696272418384573D-06,   1.062323171856242D-05,  -5.475491248540232D-05, &
&    2.191689550681158D-04,  -6.112875072514940D-04,   9.050174308558292D-04, &
&    6.585199926097579D-16,  -5.434368207188490D-15,   7.908272827893575D-14, &
&   -1.190222284674215D-12,   1.623223672001439D-11,  -2.054566787442027D-10, &
&    2.401492686896396D-09,  -2.568408503544358D-08,   2.485312999439766D-07, &
&   -2.143571800199486D-06,   1.613910256166090D-05,  -1.028399819631391D-04, &
&    5.273864718029233D-04,  -1.978375657281173D-03,   4.277263459024820D-03, &
&    1.531167605263447D-16,  -1.376783333822026D-15,   2.229084634970418D-14, &
&   -3.711983777556694D-13,   5.695827199812852D-12,  -8.219809861620383D-11, &
&    1.110977826227677D-09,  -1.396171556545659D-08,   1.616820292421401D-07, &
&   -1.704740132438728D-06,   1.609272824379461D-05,  -1.326483597197480D-04, &
&    9.167901278787010D-04,  -4.906111623837287D-03,   1.729666974162066D-02, &
&    1.574694333842837D-17,  -1.582934907681926D-16,   2.930566231935407D-15, &
&   -5.551783030906218D-14,   9.867347775783994D-13,  -1.672938453228802D-11, &
&    2.696698700380875D-10,  -4.110802061769503D-09,   5.886586724159164D-08, &
&   -7.847447701305155D-07,   9.618402906019453D-06,  -1.063997101692202D-04, &
&    1.031024896288770D-03,  -8.198752946795490D-03,   5.307109504482885D-02, &
&    5.671893932827320D-19,  -6.588216199755689D-18,   1.443490389027849D-16, &
&   -3.225686695908900D-15,   6.890894865058150D-14,  -1.426068068351064D-12, &
&    2.852303294125881D-11,  -5.494191809252400D-10,   1.015032284313969D-08, &
&   -1.788073038987417D-07,   2.980017349596939D-06,  -4.641251860685153D-05, &
&    6.614959724282232D-04,  -8.377742792332447D-03,   1.151451153643560D-01, &
&    3.080316801370534D-21,  -5.187000194517419D-20,   1.425690602748098D-18, &
&   -3.805936043349303D-17,   1.093297559052424D-15,  -2.951307934721419D-14, &
&    7.904551036528654D-13,  -2.099579084363550D-11,   5.443693140771494D-10, &
&   -1.393215728946143D-08,   3.496059825664685D-07,  -8.689447095055667D-06, &
&    2.170190544926150D-04,  -5.706634527223826D-03,   1.707400294295975D-01, &
&    6.425397413911239D-17,  -4.855662916779735D-16,   6.304416541138980D-15, &
&   -8.522384701869785D-14,   1.021754885618617D-12,  -1.116855052147475D-11, &
&    1.106021188793951D-10,  -9.801786332274228D-10,   7.659586958033862D-09, &
&   -5.176790580152329D-08,   2.946645199108144D-07,  -1.358850693840486D-06, &
&    4.772601752776370D-06,  -1.139166633209492D-05,   1.393927621903033D-05, &
&    8.878320082706484D-17,  -7.039603112556497D-16,   9.731087175785021D-15, &
&   -1.394976996604493D-13,   1.795295284183431D-12,  -2.128208809464977D-11, &
&    2.311223564093467D-10,  -2.275844138629755D-09,   2.006762045789116D-08, &
&   -1.558650123954207D-07,   1.042284339198727D-06,  -5.802058921957518D-06, &
&    2.546229423757600D-05,  -7.952232340303497D-05,   1.366547616121180D-04, &
&    5.162263406982835D-17,  -4.429270373068408D-16,   6.764148946708972D-15, &
&   -1.064862549385283D-13,   1.530285315371599D-12,  -2.052783817927698D-11, &
&    2.558688640849482D-10,  -2.939232505852390D-09,   3.080459867522727D-08, &
&   -2.906275834098435D-07,   2.422530527573578D-06,  -1.735075630423269D-05, &
&    1.020765145547343D-04,  -4.521190838165777D-04,   1.235818487310288D-03, &
&    1.480848518454417D-17,  -1.408755652587994D-16,   2.439222540129638D-15, &
&   -4.326145615331796D-14,   7.128251455650518D-13,  -1.111355673017651D-11, &
&    1.633154797493881D-10,  -2.247839598724430D-09,   2.874782864398073D-08, &
&   -3.380097595874710D-07,   3.600226160932674D-06,  -3.397777806496019D-05, &
&    2.744380376239560D-04,  -1.759291506455061D-03,   8.230483396367955D-03, &
&    1.940604052613916D-18,  -2.093457855562798D-17,   4.202916287254570D-16, &
&   -8.592376673318977D-15,   1.660688972815022D-13,  -3.078648183261305D-12, &
&    5.453180854517219D-11,  -9.192900986547457D-10,   1.465766787187721D-08, &
&   -2.192640697806503D-07,   3.045099947022269D-06,  -3.861766885137870D-05, &
&    4.359131511521995D-04,  -4.095686999881189D-03,   3.550507846079821D-02, &
&    9.171589112257524D-20,  -1.153766891345334D-18,   2.775185917383685D-17, &
&   -6.729864939587178D-16,   1.571692379912463D-14,  -3.578930007204978D-13, &
&    7.882443101828866D-12,  -1.681064676117362D-10,   3.454811980725387D-09, &
&   -6.802813784516886D-08,   1.275681451402741D-06,  -2.250545079632364D-05, &
&    3.664425052735878D-04,  -5.400057989677623D-03,   9.491650460916514D-02, &
&    1.121728415500074D-21,  -1.779116867859739D-20,   2.066928885343483D-19, &
&   -1.206268412798251D-17,   3.853632574905033D-16,  -9.419717830254539D-15, &
&    3.110511738494261D-13,  -8.840498757755073D-12,   2.508409711174613D-10, &
&   -7.151520578034559D-09,   1.979946302603801D-07,  -5.504432690545295D-06, &
&    1.544994361054979D-04,  -4.606321520198519D-03,   1.553639704283677D-01, &
&    3.953365148852050D-18,  -3.018987592693796D-17,   3.972783777730314D-16, &
&   -5.436376941272156D-15,   6.613544715732869D-14,  -7.349790321834238D-13, &
&    7.416081512375650D-12,  -6.714311185536576D-11,   5.377653905587349D-10, &
&   -3.740054287289763D-09,   2.201734033285561D-08,  -1.056947220578234D-07, &
&    3.898071355544614D-07,  -9.889518166028817D-07,   1.311021286891779D-06, &
&    6.256996276896655D-18,  -5.097393988884888D-17,   7.292942021879609D-16, &
&   -1.079579316805312D-14,   1.443410039988949D-13,  -1.786481184543198D-12, &
&    2.036730219861063D-11,  -2.119175238837171D-10,   1.989810342525545D-09, &
&   -1.661162116195276D-08,   1.207826299780817D-07,  -7.418782308304318D-07, &
&    3.664471967433017D-06,  -1.325071337103030D-05,   2.797788628626544D-05, &
&    4.462826683527253D-18,  -4.010996768407529D-17,   6.481967430355438D-16, &
&   -1.076127403475558D-14,   1.644030062449607D-13,  -2.359071630618341D-12, &
&    3.166402561668086D-11,  -3.947094500211620D-10,   4.528820009541723D-09, &
&   -4.727093384357653D-08,   4.415044807233813D-07,  -3.599905899354529D-06, &
&    2.466074637421777D-05,  -1.307783316258237D-04,   4.726596547404036D-04, &
&    1.624878113903132D-18,  -1.645094479031647D-17,   3.062889651598770D-16, &
&   -5.817554917683583D-15,   1.035106991594038D-13,  -1.752103926950739D-12, &
&    2.812344860512772D-11,  -4.259264632183536D-10,   6.037285514790471D-09, &
&   -7.941926822352461D-08,   9.569535610897962D-07,  -1.035382148692005D-05, &
&    9.787580017006191D-05,  -7.453714171267680D-04,   4.731562617481722D-03, &
&    2.742851817780265D-19,  -3.193744850834660D-18,   6.949087527890022D-17, &
&   -1.531754394906803D-15,   3.234920054235938D-14,  -6.546875168085423D-13, &
&    1.271741638344102D-11,  -2.373719608344155D-10,   4.198361459960844D-09, &
&   -7.026777534577616D-08,   1.101494525340751D-06,  -1.591190469520144D-05, &
&    2.076180195710035D-04,  -2.265336378270154D-03,   2.630091130930067D-02, &
&    1.654676073893592D-20,  -2.372424276976225D-19,   6.098835507223052D-18, &
&   -1.566825025553527D-16,   4.105399822254146D-15,  -1.015506380602935D-13, &
&    2.436123914317467D-12,  -5.769105513289468D-11,   1.306429774619550D-09, &
&   -2.857174444340013D-08,   5.985316770722156D-07,  -1.184193985721310D-05, &
&    2.178891245297295D-04,  -3.694529173038752D-03,   8.149566177965972D-02, &
&    1.259521710939092D-21,   8.226082641335936D-21,   8.947163145435987D-21, &
&   -1.109256140738924D-17,   2.304020710250636D-17,  -3.323037761208451D-15, &
&    1.632132007230762D-13,  -3.478471142851470D-12,   1.274987586001862D-10, &
&   -3.913293111510206D-09,   1.177570849641644D-07,  -3.657997987440356D-06, &
&    1.139857089452500D-04,  -3.809131964627109D-03,   1.428013462606274D-01, &
&    2.506726446714739D-19,  -1.940382017890989D-18,   2.598453682071911D-17, &
&   -3.613597837766035D-16,   4.482430629339800D-15,  -5.093716629410995D-14, &
&    5.272404224394401D-13,  -4.916218475797690D-12,   4.075175055647909D-11, &
&   -2.951403953640074D-10,   1.823660408672205D-09,  -9.285230974992327D-09, &
&    3.684875059008199D-08,  -1.027447275999528D-07,   1.557432719840673D-07, &
&    4.740605101087391D-19,  -3.996322785413426D-18,   5.968774130771724D-17, &
&   -9.200678380643063D-16,   1.290364339343240D-14,  -1.685360302187183D-13, &
&    2.041161627121062D-12,  -2.273778718829255D-11,   2.306856805148300D-10, &
&   -2.104201165780938D-09,   1.694515240041532D-08,  -1.172974148947646D-07, &
&    6.692632804076266D-07,  -2.884490214391804D-06,   8.014565992752006D-06, &
&    4.309348098748146D-19,  -4.087128874261035D-18,   7.042378559914916D-17, &
&   -1.242459699851404D-15,   2.034039449567727D-14,  -3.146474563735391D-13, &
&    4.585723175744769D-12,  -6.254158203856956D-11,   7.917183320933295D-10, &
&   -9.221581259681341D-09,   9.724590693379448D-08,  -9.094304231125679D-07, &
&    7.327604605996745D-06,  -4.644350132043235D-05,   2.319566371028266D-04, &
&    2.028824668069689D-19,  -2.202679172439702D-18,   4.408058866125058D-17, &
&   -9.024318801631521D-16,   1.741496385770757D-14,  -3.198082185060301D-13, &
&    5.637470172594703D-12,  -9.413201227804688D-11,   1.476164421898867D-09, &
&   -2.179837567485989D-08,   2.964841454138968D-07,  -3.668080961022003D-06, &
&    4.054689101833050D-05,  -3.594490077398757D-04,   3.158616679332221D-03, &
&    4.382629636029186D-20,  -5.744774261710086D-19,   1.269252027346372D-17, &
&   -3.149874214038497D-16,   7.302950299964805D-15,  -1.557689300653785D-13, &
&    3.394981904789838D-12,  -6.995095885579323D-11,   1.349670974903913D-09, &
&   -2.544860552412712D-08,   4.460407643007938D-07,  -7.283845756320702D-06, &
&    1.090251544325364D-04,  -1.353647478067711D-03,   2.101860260850282D-02, &
&    3.469075325716229D-21,  -6.663508160901275D-20,   1.139532896160810D-18, &
&   -4.376558850063100D-17,   1.277069337421292D-15,  -2.982968160725958D-14, &
&    8.470154164348149D-13,  -2.207036653161490D-11,   5.341501654201451D-10, &
&   -1.310503862732315D-08,   3.030415474577401D-07,  -6.661235636940476D-06, &
&    1.372537145259569D-04,  -2.652209216362375D-03,   7.209572255625499D-02, &
&    1.044439822529119D-21,   3.781532906830509D-20,   8.935804451239142D-19, &
&    1.722682079420245D-18,  -2.183480824491081D-16,  -7.250555582106406D-15, &
&    3.792946299404397D-14,  -8.421767913345401D-13,   8.724302321001620D-11, &
&   -2.065090537138332D-09,   7.380225724200850D-08,  -2.536109693862159D-06, &
&    8.650624572653589D-05,  -3.212679975814842D-03,   1.323097295392798D-01, &
&    1.651745549017786D-20,  -1.301528071744938D-19,   1.783556519378809D-18, &
&   -2.534603575334603D-17,   3.227588260998230D-16,  -3.780638910368413D-15, &
&    4.052734958967810D-14,  -3.936503361192273D-13,   3.423886563600272D-12, &
&   -2.626062592785914D-11,   1.738969987266088D-10,  -9.642005851403624D-10, &
&    4.264291732870578D-09,  -1.369101134485565D-08,   2.606919596305458D-08, &
&    3.921657463967346D-20,  -3.448237772937785D-19,   5.426516452350409D-18, &
&   -8.792748719570522D-17,   1.306747618781055D-15,  -1.821111245441839D-14, &
&    2.371717498830450D-13,  -2.864478581019268D-12,   3.183611992604358D-11, &
&   -3.221906096324881D-10,   2.917375990196559D-09,  -2.316741066433236D-08, &
&    1.561451204725793D-07,  -8.099472418825701D-07,   3.207814312496319D-06, &
&    4.717697278378336D-20,  -4.721798178404626D-19,   8.725763775001777D-18, &
&   -1.654345371298606D-16,   2.907830399383141D-15,  -4.881192059816138D-14, &
&    7.795529796741523D-13,  -1.164659760263916D-11,   1.636256414620257D-10, &
&   -2.143999520781643D-09,   2.547418955686261D-08,  -2.748167049427163D-07, &
&    2.620695160960397D-06,  -1.936452444222658D-05,   1.401213188529356D-04, &
&    3.187886622539391D-20,  -3.213242996619029D-19,   7.129917460893257D-18, &
&   -1.668115014109739D-16,   3.287375320577837D-15,  -6.676058714300226D-14, &
&    1.325922476865950D-12,  -2.363023697076169D-11,   4.132906323859441D-10, &
&   -6.933427528863487D-09,   1.041431507102978D-07,  -1.480973526251102D-06, &
&    1.906613497204608D-05,  -1.902593375913915D-04,   2.365773538784132D-03, &
&    1.972585869458093D-20,  -4.045307436279576D-20,   2.346851650234088D-18, &
&   -9.816323594465847D-17,   1.492832327847527D-15,  -4.079396043105185D-14, &
&    1.120090380142858D-12,  -2.179995160564454D-11,   4.786989011568354D-10, &
&   -1.047252147357579D-08,   1.958193180419172D-07,  -3.652936680798290D-06, &
&    6.202740349904413D-05,  -8.566323518440992D-04,   1.777301853683666D-02, &
&    8.636285568202508D-21,   4.284058628295192D-20,   2.127417787067031D-19, &
&   -3.076104448015334D-17,   1.465915309903502D-16,  -9.353208429796062D-15, &
&    3.929632426082267D-13,  -8.287785140784840D-12,   2.338355922598281D-10, &
&   -6.620427768633226D-09,   1.617758184715698D-07,  -3.968327665438899D-06, &
&    9.068011833972274D-05,  -1.980439896132933D-03,   6.521623298254067D-02, &
&   -2.255235655327489D-20,  -1.400687941929740D-19,   8.357245248857400D-19, &
&    5.046023475511635D-17,   6.203824297356109D-16,  -5.540160146004204D-15, &
&   -1.908675867745997D-13,  -2.721728318321310D-12,   5.990067433003823D-11, &
&   -6.814441850602734D-10,   5.377219364246314D-08,  -1.791595837234096D-06, &
&    6.721085337375120D-05,  -2.754860082581554D-03,   1.233873088798924D-01, &
&    1.143692058659783D-21,  -9.225794893155790D-21,   1.303676707814727D-19, &
&   -1.907484405701176D-18,   2.516392077201261D-17,  -3.071865889508043D-16, &
&    3.454456078932297D-15,  -3.548207408606817D-14,   3.298047593826255D-13, &
&   -2.738297816896531D-12,   1.994167887512228D-11,  -1.245008813073958D-10, &
&    6.409425677185516D-10,  -2.474067695787825D-09,   6.887653183276368D-09, &
&    3.587069940535087D-21,  -3.315372579398228D-20,   5.593150976194087D-19, &
&   -9.569352792854830D-18,   1.518557983517274D-16,  -2.292950408035891D-15, &
&    3.238553921624242D-14,  -4.273923177384026D-13,   5.288394345868862D-12, &
&   -5.997712887369711D-11,   6.134701666267888D-10,  -5.705948960260271D-09, &
&    4.596443124506593D-08,  -2.789234524526853D-07,   1.733979339409655D-06, &
&    5.074352270837270D-21,  -6.038897539302029D-20,   1.346687135504139D-18, &
&   -2.458150548777905D-17,   4.683343043578823D-16,  -9.094245175617185D-15, &
&    1.533283001173590D-13,  -2.482099723040510D-12,   4.030181687242295D-11, &
&   -5.848493299968342D-10,   7.672408203986178D-09,  -9.851161672818393D-08, &
&    1.096221475724090D-06,  -8.987140507351075D-06,   9.983448073869971D-05, &
&   -5.723102743550248D-21,  -5.531388583114681D-20,   2.582476418728403D-18, &
&   -2.119770884458291D-17,   6.005929890534895D-16,  -1.994479710028159D-14, &
&    3.313863140635529D-13,  -6.148777879825856D-12,   1.409219254038033D-10, &
&   -2.481346353817058D-09,   3.948203851548811D-08,  -6.844149547356795D-07, &
&    9.893263959396855D-06,  -1.069075898216753D-04,   1.933612390703220D-03, &
&   -4.051945581062209D-20,  -6.179900525126692D-20,   5.172017738000548D-18, &
&    3.159625394405266D-17,   4.750218883643710D-17,  -2.827577429022750D-14, &
&    2.903509914110939D-13,  -5.436903881963861D-12,   2.266786046467474D-10, &
&   -4.636323811071670D-09,   8.802230862350321D-08,  -2.035897228710555D-06, &
&    3.738800503507615D-05,  -5.655859848515649D-04,   1.567636327744754D-02, &
&   -2.904232539280818D-20,  -6.190979793874523D-20,   2.977942114575285D-18, &
&    3.372947531377278D-17,  -1.245141903215416D-16,  -1.445180808189344D-14, &
&    9.453280247859844D-14,  -2.103374303591767D-12,   1.370523391072502D-10, &
&   -3.479512737171117D-09,   8.814885483962165D-08,  -2.515299091981173D-06, &
&    6.216266220844615D-05,  -1.528408545428386D-03,   5.999553932789583D-02, &
&    8.259524799287541D-20,   9.075640064645019D-20,  -8.675341757827483D-18, &
&   -1.000721226952007D-16,   8.655497907010175D-16,   2.928857147286731D-14, &
&    9.799381519280769D-14,  -5.852888521497442D-12,  -4.194155884683078D-11, &
&   -4.081080650363997D-10,   4.794445530445334D-08,  -1.185748167701718D-06, &
&    5.386099581756005D-05,  -2.394366702983338D-03,   1.156834795812017D-01, &
&    8.440606492564242D-23,  -7.051870017029961D-22,   1.032541595919559D-20, &
&   -1.569364026233016D-19,   2.178893152210699D-18,  -2.808808958663548D-17, &
&    3.356385485883188D-16,  -3.720709988617490D-15,   3.784756024851108D-14, &
&   -3.470310483214291D-13,   2.853524824326648D-12,  -2.094990755713746D-11, &
&    1.297041576438026D-10,  -5.992083785948777D-10,   3.002932608031258D-09, &
&    4.032322101134879D-22,  -3.977584281032700D-21,   6.070630309142812D-20, &
&   -1.163355734234383D-18,   2.156170859674812D-17,  -3.380108173181375D-16, &
&    5.048061392989294D-15,  -7.700000181492631D-14,   1.073897430124968D-12, &
&   -1.314926303957758D-11,   1.551071724468777D-10,  -1.766369323055665D-09, &
&    1.630571713011789D-08,  -1.092480348286787D-07,   1.195040294027903D-06, &
&    2.623376499971097D-21,  -1.738432293841766D-20,  -1.233275674325844D-20, &
&   -3.857910986647982D-18,   1.321856395390666D-16,  -1.741927453325592D-15, &
&    2.794288881925799D-14,  -6.862454939295016D-13,   1.213119958997415D-11, &
&   -1.671785976852522D-10,   2.643420536699795D-09,  -4.272200485420385D-08, &
&    5.048481808235870D-07,  -4.429550931604701D-06,   8.058338811972861D-05, &
&    2.408205669846720D-20,  -6.440062649997553D-20,  -2.307281449835521D-18, &
&   -7.171926362106613D-18,   6.557668166930875D-16,  -2.435116032350516D-15, &
&    1.820086745230138D-14,  -2.883939383050164D-12,   5.935211680835255D-11, &
&   -7.759048806708196D-10,   1.682798242654216D-08,  -3.718528248185517D-07, &
&    5.340796265322974D-06,  -6.258927834298352D-05,   1.686135970379157D-03, &
&    8.978359745519754D-20,  -1.120954223721954D-19,  -9.532043140619921D-18, &
&   -1.830204161148319D-17,   1.899012538123441D-15,   4.477760580384938D-15, &
&   -1.791440870298513D-13,  -5.906716004539634D-12,   1.286211138714362D-10, &
&   -1.412368622004533D-09,   4.476601825066427D-08,  -1.287620164184869D-06, &
&    2.281776365288053D-05,  -3.882922787012557D-04,   1.426728604087279D-02, &
&    5.874652906241977D-20,  -5.668855996067122D-21,  -6.159017171158971D-18, &
&   -1.914480249862212D-17,   1.146497595544871D-15,   5.131546647429389D-15, &
&   -1.318595786749156D-13,  -3.654148965228621D-12,   8.700691049704556D-11, &
&   -1.407060718749549D-09,   5.257694085002671D-08,  -1.702208029765548D-06, &
&    4.350212639545493D-05,  -1.215044881833032D-03,   5.590825475849345D-02, &
&   -1.731543621241274D-19,   1.720332885011441D-19,   1.872487667775108D-17, &
&    2.983757016000203D-17,  -3.354798191536776D-15,  -1.776318652664508D-14, &
&    5.821848866482728D-13,   4.949927837929656D-12,  -7.468219436590854D-11, &
&   -1.814908278105922D-09,   3.211898244825880D-08,  -6.831720703048593D-07, &
&    4.559167135833374D-05,  -2.098290696303012D-03,   1.089568554377041D-01, &
&    6.467562355773803D-24,  -5.581915705075173D-23,   9.288926078844027D-22, &
&   -1.500503249007407D-20,   2.118773339262366D-19,  -2.896482004764705D-18, &
&    3.878271218156862D-17,  -4.777185342089400D-16,   5.251645057206097D-15, &
&   -5.370751534699490D-14,   5.315485530963428D-13,  -4.765160051866446D-12, &
&    3.369139729891691D-11,  -1.782436832125975D-10,   1.975012839668752D-09, &
&   -2.169792976279724D-23,  -6.969530301436082D-23,   1.421891752572067D-20, &
&   -2.462461155459543D-19,   2.482194928675439D-18,  -4.546473403572424D-17, &
&    1.105482969407275D-15,  -1.825549263986882D-14,   2.291197604912827D-13, &
&   -3.179277197678108D-12,   5.097074190063342D-11,  -6.742987674243687D-10, &
&    6.227465073264566D-09,  -4.643481076031594D-08,   9.763661160959393D-07, &
&   -2.434221589334002D-21,   8.092493529001338D-21,   2.697798981366523D-19, &
&   -2.983790141107724D-18,  -1.634199708584777D-17,  -8.495289155990420D-18, &
&    1.487223136565876D-14,  -2.663520941875682D-13,   2.587134611506382D-12, &
&   -4.734746876525294D-11,   1.247331883725998D-09,  -2.113781889287315D-08, &
&    2.296620067247065D-07,  -2.321579071147090D-06,   7.086586645613854D-05, &
&   -2.845223865187892D-20,   7.147063752033037D-20,   2.793098234376818D-18, &
&   -2.070521277988562D-17,  -3.944334716905663D-16,   3.007513110105619D-15, &
&    1.053753355712358D-13,  -1.713341206353861D-12,   6.719751956156035D-12, &
&   -2.161115392230987D-10,   1.059309639784123D-08,  -2.156213282959822D-07, &
&    2.751090313519164D-06,  -3.900923360496664D-05,   1.537606865379865D-03, &
&   -1.019695903252701D-19,   1.866620771355099D-19,   1.007043256568236D-17, &
&   -5.866506582213117D-17,  -1.624112678796470D-15,   1.284540230009498D-14, &
&    3.251113187194781D-13,  -4.657235458613451D-12,  -5.872913950230328D-12, &
&   -3.436874373347918D-10,   3.473254151311989D-08,  -8.265552212301854D-07, &
&    1.338854164061801D-05,  -2.817338603799518D-04,   1.327636603869057D-02, &
&   -6.169420353519421D-20,   6.030523344360411D-20,   6.291067982993233D-18, &
&   -2.792852835510855D-17,  -1.058562557505624D-15,   7.379246229032484D-15, &
&    2.065159931624724D-13,  -2.890667889492021D-12,   2.573361526249393D-12, &
&   -6.240225372019621D-10,   3.931726029128920D-08,  -1.162519978554660D-06, &
&    3.072657713714968D-05,  -9.947768841684579D-04,   5.261265118374552D-02, &
&    1.950352265190869D-19,  -3.329925721031063D-19,  -1.925835633583952D-17, &
&    1.053854166755745D-16,   3.236704667270287D-15,  -2.732341186797533D-14, &
&   -5.344293743673929D-13,   6.130919365664673D-12,   9.306812349152818D-11, &
&   -1.690725330007853D-09,   1.812095242461234D-09,  -4.813190289468054D-07, &
&    4.063163898454540D-05,  -1.840527594952534D-03,   1.030559830289795D-01, &
&    8.403335225303691D-25,  -6.854414983001451D-24,   7.926984419988932D-23, &
&   -1.248600117141536D-21,   2.416933352775916D-20,  -4.158443276848254D-19, &
&    5.674492466574672D-18,  -6.709402032650687D-17,   8.279037207290302D-16, &
&   -1.118164724095370D-14,   1.387552997027239D-13,  -1.345591292329017D-12, &
&    9.563470270015139D-12,  -6.333865754211916D-11,   1.647840953585832D-09, &
&    4.988916013154168D-23,  -2.919483774517453D-22,  -1.300000743077411D-21, &
&    2.982590187830124D-20,   6.231060669634757D-19,  -2.244472491307380D-17, &
&    2.898574370918685D-16,  -2.496309219926662D-15,   4.472289214269597D-14, &
&   -1.205605592218725D-12,   2.208367904568183D-11,  -2.641111482594743D-10, &
&    2.257519485516659D-09,  -2.280094053753384D-08,   8.783924405231002D-07, &
&    1.587614232985728D-21,  -6.999903259695552D-21,  -1.038337124588649D-19, &
&    1.877404424885921D-18,   9.439719146703470D-18,  -5.456648108372673D-16, &
&    5.007410287629607D-15,   6.048184022910516D-15,   2.907219213110154D-13, &
&   -3.025388204657508D-11,   7.149795366182912D-10,  -9.593631974793531D-09, &
&    9.607383712533000D-08,  -1.396124040200318D-06,   6.548829421256252D-05, &
&    1.657707550208571D-20,  -6.103763093829937D-20,  -1.281406508090376D-18, &
&    2.108947371137718D-17,   8.918163402000733D-17,  -5.267995437513139D-15, &
&    3.526023820305840D-14,   4.622537592508101D-13,  -3.112936543162029D-12, &
&   -2.553683082781324D-10,   7.262645061784357D-09,  -1.076786950394031D-07, &
&    1.325856447157357D-06,  -2.726494804506964D-05,   1.440324603942366D-03, &
&    5.712822030661450D-20,  -1.847860452941263D-19,  -4.743358620425546D-18, &
&    7.316574883225160D-17,   3.335449756456198D-16,  -1.798642699311909D-14, &
&    9.862711112692359D-14,   2.219221016564089D-12,  -2.054626998727629D-11, &
&   -8.097015461291212D-10,   2.636027887893221D-08,  -4.523081571923319D-07, &
&    7.708547475453459D-06,  -2.201338992129037D-04,   1.253206197928281D-02, &
&    3.326815576036131D-20,  -8.971250782430574D-20,  -2.965095461827408D-18, &
&    4.203485031532101D-17,   2.345153620020697D-16,  -1.090520608564386D-14, &
&    5.632538452684026D-14,   1.315430250074834D-12,  -6.739353147721459D-12, &
&   -8.008115619591056D-10,   2.880618160941808D-08,  -7.507007341456363D-07, &
&    2.221139562950310D-05,  -8.378190897269282D-04,   4.987650173669589D-02, &
&   -1.085097965855670D-19,   3.412477342068151D-19,   9.143579390418022D-18, &
&   -1.397321354146029D-16,  -6.190479877694949D-16,   3.320351708599975D-14, &
&   -1.470859047582703D-13,  -5.550143787556088D-12,   8.013127173017724D-11, &
&    2.587306950914322D-10,  -8.545594069178607D-09,  -5.521635026306986D-07, &
&    3.607342593516954D-05,  -1.610065731021478D-03,   9.788690272522497D-02, &
&   -4.616796645192767D-27,  -9.414756552373506D-26,   1.093623862602201D-23, &
&   -2.922844058871140D-22,   4.577283209731140D-21,  -5.213172144201001D-20, &
&    6.069144524457148D-19,  -1.068278750950446D-17,   2.138289851715387D-16, &
&   -3.465265634544407D-15,   4.182804740397392D-14,  -3.730094670897377D-13, &
&    2.679527731169407D-12,  -3.088828532551668D-11,   1.516574380349378D-09, &
&   -1.149866990587994D-23,   8.900393535052644D-23,   3.480133065142487D-22, &
&   -2.772662323139307D-20,   4.019397138111822D-19,  -1.632702925484077D-18, &
&   -1.616803281757859D-17,  -3.978298390217050D-16,   2.701146079523377D-14, &
&   -6.184560032391252D-13,   8.745035716488806D-12,  -8.778067581546124D-11, &
&    7.934823660699915D-10,  -1.443370613248036D-08,   8.247007537700688D-07, &
&   -4.406778990911760D-22,   3.385551146243271D-21,   8.662901886424168D-21, &
&   -8.939799795107013D-19,   1.154580202729120D-17,   1.563336806748575D-17, &
&   -2.079037453095743D-15,   8.132583616345056D-15,   7.358613908455575D-13, &
&   -2.086450098372396D-11,   3.202465229165254D-10,  -3.523849608196289D-09, &
&    4.061921220699784D-08,  -1.013231152063310D-06,   6.195636831861703D-05, &
&   -4.738038999463238D-21,   3.522114311117060D-20,   1.035116764429168D-19, &
&   -9.428818915549273D-18,   1.143222350078948D-16,   4.583514314940284D-16, &
&   -2.890187528874820D-14,   1.997271680926354D-13,   6.516839640663733D-12, &
&   -2.142479946666742D-10,   3.511838381846897D-09,  -4.368296157148755D-08, &
&    6.789071322932627D-07,  -2.153803817183906D-05,   1.368080240374684D-03, &
&   -1.647504984099932D-20,   1.189738330680319D-19,   4.088719575848293D-19, &
&   -3.291645475609216D-17,   3.864127158872008D-16,   2.030970379678161D-15, &
&   -1.113942223399482D-13,   8.833549385955148D-13,   2.077259550009400D-11, &
&   -7.578562996438397D-10,   1.363477245251398D-08,  -2.132750892878805D-07, &
&    4.829726412835638D-06,  -1.835938190929714D-04,   1.193075351212363D-02, &
&   -9.664154641934220D-21,   6.701030292274876D-20,   2.837983163887657D-19, &
&   -1.963967872350652D-17,   2.255372438711173D-16,   1.303455014024096D-15, &
&   -6.719294098389432D-14,   4.674115318560941D-13,   1.709621237202494D-11, &
&   -6.762073448168745D-10,   1.716938069100344D-08,  -4.768167322125374D-07, &
&    1.679332228382194D-05,  -7.220356015410646D-04,   4.754481495032314D-02, &
&    3.135500603996573D-20,  -2.251174788715071D-19,  -7.903966560068693D-19, &
&    6.239359673032202D-17,  -7.204763187261961D-16,  -4.423231458695572D-15, &
&    2.311250911488662D-13,  -2.316476967549410D-12,  -1.820136621731923D-11, &
&    6.996928107248616D-10,   9.255009668781702D-10,  -6.041301897506392D-07, &
&    3.078070105160878D-05,  -1.409264024654255D-03,   9.336587453917279D-02, &
&    1.246045433006725D-26,  -1.897282411465166D-25,   2.898461835615548D-24, &
&   -2.729021877746446D-23,   1.578667019591378D-22,  -3.236500859393522D-21, &
&    1.458313335901716D-19,  -4.049925413267499D-18,   7.613914802059220D-17, &
&   -1.050017567743131D-15,   1.098943571488308D-14,  -9.176803279031431D-14, &
&    8.601832958668016D-13,  -2.150285578499686D-11,   1.440635728708593D-09, &
&    1.078845674078806D-24,  -2.741089693826541D-23,   4.049611768174750D-22, &
&   -1.251614353972841D-21,  -6.304956698091466D-20,   1.044471405355932D-18, &
&    6.971132315052353D-18,  -6.257262586074926D-16,   1.503261818557030D-14, &
&   -2.322146394963482D-13,   2.640570649006012D-12,  -2.528499427586818D-11, &
&    3.391261463142304D-10,  -1.131186544996034D-08,   7.867476636952624D-07, &
&    3.457627992614276D-23,  -9.550826276515193D-22,   1.382989740203270D-20, &
&   -1.332731275869637D-20,  -3.260629089115124D-18,   5.908248549804636D-17, &
&   -7.778808146647560D-17,  -1.918403519171250D-14,   5.274669180888729D-13, &
&   -8.627552455539321D-12,   1.041765556402165D-10,  -1.163472904885313D-09, &
&    2.146133407969282D-08,  -8.374426558571079D-07,   5.920851515524609D-05, &
&    3.692323311016599D-22,  -1.010989182712401D-20,   1.451480162627916D-19, &
&   -3.133671749547209D-20,  -3.882862753791048D-17,   7.309525703802655D-16, &
&   -2.596705910717027D-15,  -1.832913644315599D-13,   5.498937901304701D-12, &
&   -9.403592998649261D-11,   1.228133535504602D-09,  -1.708250828152618D-08, &
&    4.259603672396907D-07,  -1.834146831629941D-05,   1.308634258882742D-03, &
&    1.303459462528563D-21,  -3.498532710720956D-20,   5.003687471654050D-19, &
&    3.933351426914613D-20,  -1.409867452600005D-16,   2.708816399554757D-15, &
&   -1.217641135357850D-14,  -6.023138626678318D-13,   1.926217446091792D-11, &
&   -3.508202339953002D-10,   5.374324251961544D-09,  -1.054660550131615D-07, &
&    3.469620805922204D-06,  -1.591752431421791D-04,   1.141861782420446D-02, &
&    7.860992439876675D-22,  -2.046300241246701D-20,   2.922683168714209D-19, &
&    5.680670825546724D-20,  -8.456757704296616D-17,   1.633120317757531D-15, &
&   -6.887585840336183D-15,  -4.193249651829202D-13,   1.489594648022469D-11, &
&   -3.604149669515377D-10,   9.456723548299845D-09,  -3.218804523260130D-07, &
&    1.326847746182591D-05,  -6.325430450940728D-04,   4.551821347616575D-02, &
&   -2.487222735752493D-21,   6.640583729691868D-20,  -9.470271238557704D-19, &
&   -2.389329197036706D-19,   2.748247107719718D-16,  -5.402753538339684D-15, &
&    3.201324853087052D-14,   8.299200219537920D-13,  -2.489261243283483D-11, &
&    2.129834441712040D-10,   7.879930704571959D-09,  -5.437008154242170D-07, &
&    2.555270705138932D-05,  -1.240542683749111D-03,   8.939902531275205D-02, &
&    2.748344483604862D-27,  -9.059986003365188D-27,  -1.093446521602231D-25, &
&    2.310391012848274D-24,   2.946873806052815D-23,  -2.511159393978746D-21, &
&    7.316997236571587D-20,  -1.440259540240331D-18,   2.151576524517093D-17, &
&   -2.532658956953582D-16,   2.430270269261892D-15,  -2.295468673949468D-14, &
&    4.187861693730841D-13,  -1.796516807581742D-11,   1.382073611276219D-09, &
&    5.037740092188925D-25,  -6.284279576765691D-25,  -6.544798248133204D-23, &
&    1.549268850872587D-21,  -1.325082654190718D-20,  -2.733481879647876D-19, &
&    1.342556317929772D-17,  -3.082060164667105D-16,   4.990584452021010D-15, &
&   -6.246999203507560D-14,   6.573721198096461D-13,  -8.011517874710237D-12, &
&    2.067314099481142D-10,  -9.749773129854604D-09,   7.553486187243553D-07, &
&    1.848348062131807D-23,  -1.800542223051940D-23,  -2.767586112051923D-21, &
&    6.904719200895266D-20,  -7.534591188769189D-19,  -5.886013001898883D-18, &
&    4.500793561441992D-16,  -1.116654244909381D-14,   1.882887353639733D-13, &
&   -2.460765597790165D-12,   2.873460960556476D-11,  -4.576537297845827D-10, &
&    1.483127778260003D-08,  -7.316588591286383D-07,   5.686461026324251D-05, &
&    1.983619897571455D-22,  -1.915803983596144D-22,  -3.084226379883650D-20, &
&    7.925513960703831D-19,  -9.421089339410228D-18,  -3.922122012318187D-17, &
&    4.533211298160179D-15,  -1.180647793363401D-13,   2.054588335918216D-12, &
&   -2.837428268192634D-11,   3.887771439723211D-10,  -8.358666762944000D-09, &
&    3.188866643330034D-07,  -1.614530753799150D-05,   1.257062500582844D-03, &
&    6.892573774468270D-22,  -6.913489525822077D-22,  -1.084800510082542D-19, &
&    2.839068355165747D-18,  -3.519623767531234D-17,  -9.062241915708779D-17, &
&    1.525506929518009D-14,  -4.128607024276770D-13,   7.519950971561678D-12, &
&   -1.167127740758312D-10,   2.136763281544254D-09,  -6.388910544694906D-08, &
&    2.736172952075635D-06,  -1.407418262890929D-04,   1.096983385968368D-02, &
&    4.041192473903551D-22,  -4.417884865417193D-22,  -6.368499843142269D-20, &
&    1.697633096361896D-18,  -2.153125967159488D-17,  -5.054650554360157D-17, &
&    9.770001693913837D-15,  -2.930274405116600D-13,   6.757777563431466D-12, &
&   -1.700894122785455D-10,   5.663931540754425D-09,  -2.339969848751304D-07, &
&    1.080082715090787D-05,  -5.607280561647947D-04,   4.373199820377647D-02, &
&   -1.308463820385669D-21,   1.297562624557971D-21,   2.076788659683341D-19, &
&   -5.475029815601145D-18,   6.998689860117741D-17,   6.045459435274550D-17, &
&   -2.481477865922700D-14,   6.188145096466549D-13,  -7.427804448280802D-12, &
&   -6.937064255559026D-11,   8.554192974516721D-09,  -4.408887715798217D-07, &
&    2.111671815409048D-05,  -1.101000837578755D-03,   8.589336552011016D-02, &
&   -2.237591479933458D-28,   2.886060845829405D-27,  -2.222746355847945D-26, &
&   -8.404944793429148D-25,   4.280773420632414D-23,  -1.154280935047363D-21, &
&    2.294893215808029D-20,  -3.631101587068164D-19,   4.695234657387010D-18, &
&   -5.080835338752514D-17,   5.186484759442446D-16,  -8.198347314644832D-15, &
&    2.951453825318785D-13,  -1.588717180694003D-11,   1.331475682183682D-09, &
&   -7.519430302186082D-26,   1.084343886364221D-24,  -1.552991189652991D-23, &
&    6.016731865175921D-24,   7.003078166498313D-21,  -2.384251052372214D-19, &
&    5.225645811742770D-18,  -8.767284813163165D-17,   1.188814426536222D-15, &
&   -1.377774862170755D-14,   1.694365197896363D-13,  -3.760316782195906D-12, &
&    1.579997701708800D-10,  -8.674079298038789D-09,   7.277846842277576D-07, &
&   -2.929648012856664D-24,   4.488659035109210D-23,  -7.162633338880153D-22, &
&    3.128210843885989D-21,   2.167710359750197D-19,  -8.448376081128630D-18, &
&    1.941723000032096D-16,  -3.356657272776191D-15,   4.705586263838535D-14, &
&   -5.890114907899784D-13,   8.987371706972239D-12,  -2.586587949050297D-10, &
&    1.178000985878407D-08,  -6.526961553871082D-07,   5.479260371721955D-05, &
&   -3.151494772740571D-23,   5.002207505575229D-22,  -8.378688370083393D-21, &
&    4.964041311366919D-20,   2.060680232965802D-18,  -8.776058332937388D-17, &
&    2.077819070541015D-15,  -3.678215211819522D-14,   5.379221556811172D-13, &
&   -7.612562770167979D-12,   1.524976448687118D-10,  -5.414719038989589D-09, &
&    2.589728174886734D-07,  -1.442470650836774D-05,   1.211296738069006D-03, &
&   -1.086935880224977D-22,   1.764610241788637D-21,  -3.036820402301187D-20, &
&    2.041347384317796D-19,   6.618867390441831D-18,  -2.997680691473781D-16, &
&    7.280139859837134D-15,  -1.335250909245915D-13,   2.140129946749632D-12, &
&   -3.862082871073460D-11,   1.091157202149765D-09,  -4.566635606812566D-08, &
&    2.252370208240918D-06,  -1.258571791584395D-04,   1.057065832395086D-02, &
&   -6.261030664577232D-23,   1.043998078455400D-21,  -1.842818415943472D-20, &
&    1.337547113598979D-19,   3.815143771432158D-18,  -1.859066614279925D-16, &
&    4.935410594289942D-15,  -1.106675591194611D-13,   2.735576312465086D-12, &
&   -9.042687392887855D-11,   3.799558396508457D-09,  -1.783936102970907D-07, &
&    8.961688515560286D-06,  -5.016896712516934D-04,   4.214112535544744D-02, &
&    2.065966272567083D-22,  -3.371630577836320D-21,   5.863538708337418D-20, &
&   -4.227236862679491D-19,  -1.130782694861016D-17,   5.197567197056525D-16, &
&   -1.171931330707612D-14,   1.601677201059694D-13,   1.581255874370829D-13, &
&   -1.202352309800754D-10,   6.964218463356149D-09,  -3.470591609061728D-07, &
&    1.758556234440467D-05,  -9.853168596259002D-04,   8.276918128662123D-02, &
&   -4.191011560006344D-29,  -8.873762242647902D-29,   1.679408408643478D-26, &
&   -6.060151237884183D-25,   1.531446336903117D-23,  -3.075349309033381D-22, &
&    5.117538387209747D-21,  -7.173863422497110D-20,   8.620882985853304D-19, &
&   -9.685310871564094D-18,   1.479256669522904D-16,  -4.789435744938400D-15, &
&    2.398900067386790D-13,  -1.429688433188850D-11,   1.286281542847996D-09, &
&   -1.827155874461078D-26,   7.358966812634477D-26,   2.301576276677824D-24, &
&   -1.199452716879030D-22,   3.428222191758214D-21,  -7.350581389444147D-20, &
&    1.278284104150453D-18,  -1.861336750654704D-17,   2.363037710231728D-16, &
&   -3.070228361158059D-15,   6.377696595725768D-14,  -2.515366250630169D-12, &
&    1.306734341408707D-10,  -7.813525472663894D-09,   7.030939969827625D-07, &
&   -7.899859084129049D-25,   4.138603805925275D-24,   6.044984140117396D-23, &
&   -4.135336502133584D-21,   1.259282707011049D-19,  -2.787329962573698D-18, &
&    4.960595561727465D-17,  -7.422630223486014D-16,   1.002571789734824D-14, &
&   -1.556581195496891D-13,   4.208615283684597D-12,  -1.857445765990931D-10, &
&    9.821772922906396D-09,  -5.882133769746230D-07,   5.293416448306419D-05, &
&   -9.010449922873209D-24,   5.205616701803594D-23,   4.965262885995240D-22, &
&   -4.213964391285584D-20,   1.334167212359517D-18,  -3.013441695657363D-17, &
&    5.465610156155898D-16,  -8.469676916467696D-15,   1.265439197174667D-13, &
&   -2.503998338542865D-12,   8.559359734126203D-11,  -4.060211273772617D-09, &
&    2.169218412501962D-07,  -1.300305217429198D-05,   1.170218002678291D-03, &
&   -3.223994348077926D-23,   1.958794930426625D-22,   1.403734828841246D-21, &
&   -1.414977364939096D-19,   4.604111373760881D-18,  -1.059554195128864D-16, &
&    1.979356244795722D-15,  -3.313760368217491D-14,   6.111779957060956D-13, &
&   -1.695300436892535D-11,   7.077636345725684D-10,  -3.518865481016936D-08, &
&    1.891913826289804D-06,  -1.134711959962534D-04,   1.021220543602114D-02, &
&   -1.940077240486346D-23,   1.232979485236868D-22,   6.660558305685013D-22, &
&   -8.255016069851431D-20,   2.825227399126186D-18,  -7.024938764883326D-17, &
&    1.568513217849044D-15,  -3.903080566358798D-14,   1.304300150148958D-12, &
&   -5.628372605924080D-11,   2.730801842744550D-09,  -1.397170016414373D-07, &
&    7.539753225340073D-06,  -4.523589383026585D-04,   4.071218248252195D-02, &
&    6.174344571575661D-23,  -3.820717611183000D-22,  -2.321389072463722D-21, &
&    2.559425839443720D-19,  -8.209258384344440D-18,   1.768185593238502D-16, &
&   -2.602421933949733D-15,   7.339934860218957D-15,   1.536732951011296D-12, &
&   -1.002886846711460D-10,   5.280975958720274D-09,  -2.739011141822542D-07, &
&    1.480644173942850D-05,  -8.884697714408019D-04,   7.996266545421740D-02, &
&    8.684042182729727D-30,  -2.248236768296579D-28,   6.969143067413925D-27, &
&   -1.714031476953126D-25,   3.504443793845076D-24,  -6.121063313481343D-23, &
&    9.226156371380806D-22,  -1.216945716096269D-20,   1.507130070921364D-19, &
&   -2.366228860963823D-18,   7.279412691350364D-17,  -3.569617314120335D-15, &
&    2.029235667567238D-13,  -1.297384076102804D-11,   1.245430713494859D-09, &
&    7.419526715382372D-28,  -4.186305911693715D-26,   1.537471775866194D-24, &
&   -4.064555133103359D-23,   8.706667632036131D-22,  -1.573769791482590D-20, &
&    2.447749429769645D-19,  -3.382791768399744D-18,   4.731792867100348D-17, &
&   -9.784047917834757D-16,   3.747827546674081D-14,  -1.937854115147686D-12, &
&    1.108634542046401D-10,  -7.091487113488691D-09,   6.807661251325006D-07, &
&    5.996118523625860D-27,  -1.385945049079215D-24,   5.590987858508550D-23, &
&   -1.531814292531176D-21,   3.357367216615542D-20,  -6.182668530570887D-19, &
&    9.843990479507612D-18,  -1.435384528962887D-16,   2.342696659878495D-15, &
&   -6.248644913606286D-14,   2.738218865397479D-12,  -1.454076300430397D-10, &
&    8.344528818618771D-09,  -5.338947988036942D-07,   5.125321424055313D-05, &
&   -6.467421539831387D-26,  -1.372369076231501D-23,   5.878511537472539D-22, &
&   -1.645975074563285D-20,   3.662115492370504D-19,  -6.852505004701419D-18, &
&    1.125348747364752D-16,  -1.793233320409088D-15,   3.646424883875405D-14, &
&   -1.239533666481210D-12,   5.946539276080324D-11,  -3.208226327462977D-09, &
&    1.844455790818792D-07,  -1.180276754200278D-05,   1.133057918423877D-03, &
&   -4.969879495297189D-25,  -4.507654826085100D-23,   2.012127766066808D-21, &
&   -5.724910026172727D-20,   1.292993535750645D-18,  -2.483829418067720D-17, &
&    4.373779242548513D-16,  -8.436005377942337D-15,   2.375384597832305D-13, &
&   -1.006579329965288D-11,   5.132501916820486D-10,  -2.796366068659114D-08, &
&    1.609464611914010D-06,  -1.029994830239305D-04,   9.887922572289044D-03, &
&   -4.556809342663946D-25,  -2.513180052989926D-23,   1.185626615983990D-21, &
&   -3.507877654725878D-20,   8.499763556400001D-19,  -1.927954198706008D-17, &
&    4.935503979755894D-16,  -1.699235682828789D-14,   7.600815413326885D-13, &
&   -3.838157823469129D-11,   2.032861036747844D-09,  -1.114015463879833D-07, &
&    6.415979688530706D-06,  -4.106189200105953D-04,   3.941939948013696D-02, &
&    1.121936842735242D-24,   8.258899433471424D-23,  -3.705669770822759D-21, &
&    1.034568488310229D-19,  -2.196483188760623D-18,   3.406446223154505D-17, &
&   -1.621109950640892D-16,  -1.827329593076864D-14,   1.322856839646619D-12, &
&   -7.379279147202778D-11,   3.980616349834844D-09,  -2.187312170483077D-07, &
&    1.260128969671436D-05,  -8.064944811357036D-04,   7.742352329666478D-02, &
&    4.799474710925501D-30,  -6.841399963088404D-29,   1.623902358455174D-27, &
&   -3.444447883830109D-26,   6.311433564111667D-25,  -1.016857231629454D-23, &
&    1.459197910658155D-22,  -1.986053014359651D-21,   3.315641491781691D-20, &
&   -1.015869852309244D-18,   4.993651933573983D-17,  -2.852596172652567D-15, &
&    1.742249142386550D-13,  -1.184560482660793D-11,   1.208244533259373D-09, &
&    1.007716087842323D-27,  -1.603067232024778D-26,   4.029969043900517D-25, &
&   -8.833117488069454D-24,   1.663420850412622D-22,  -2.752702098199535D-21, &
&    4.118518520484845D-20,  -6.249611281273639D-19,   1.340607354663365D-17, &
&   -5.145900426674587D-16,   2.700779735680637D-14,  -1.557652104985523D-12, &
&    9.522662943369996D-11,  -6.474921821154024D-09,   6.604399392444886D-07, &
&    3.613212905679662D-26,  -6.003766154633843D-25,   1.549806536054029D-23, &
&   -3.454754061830354D-22,   6.607882703993376D-21,  -1.116829001325433D-19, &
&    1.755675626021464D-18,  -3.066793133920243D-17,   8.385996715741834D-16, &
&   -3.724712184665859D-14,   2.022624473351766D-12,  -1.172111906052885D-10, &
&    7.169127236813746D-09,  -4.874803866573986D-07,   4.972291265708242D-05, &
&    3.758611952574423D-25,  -6.419945551827869D-24,   1.684272371630259D-22, &
&   -3.797982937115153D-21,   7.368059910274885D-20,  -1.282024718249964D-18, &
&    2.190000773732248D-17,  -4.697987110339402D-16,   1.634999074879628D-14, &
&   -8.040977005950345D-13,   4.457461883635241D-11,  -2.590400408823418D-09, &
&    1.584850024008744D-07,  -1.077675028624357D-05,   1.099227542671996D-03, &
&    1.275606521520723D-24,  -2.220260320300969D-23,   5.897637599361498D-22, &
&   -1.346913970032569D-20,   2.678685360538227D-19,  -4.983522889195263D-18, &
&    1.020599665641763D-16,  -2.996735525468504D-15,   1.310198396302658D-13, &
&   -6.913694180796892D-12,   3.882409103962945D-10,  -2.260150895426996D-08, &
&    1.383042271357792D-06,  -9.404605012746879D-05,   9.592693570327637D-03, &
&    7.344686596711403D-25,  -1.317816186975370D-23,   3.626355654674091D-22, &
&   -8.855205593539208D-21,   2.072157878115727D-19,  -5.556126618327991D-18, &
&    2.005416812886093D-16,  -9.381401884030945D-15,   4.951123714552237D-13, &
&   -2.732011541511437D-11,   1.546007014604802D-09,  -9.009355986876568D-08, &
&    5.513622801646054D-06,  -3.749258500486366D-04,   3.824243455041037D-02, &
&   -2.376875627890652D-24,   4.119530996983046D-23,  -1.072311887049354D-21, &
&    2.303886519485644D-20,  -3.718613899552400D-19,   2.075520912001051D-18, &
&    2.061736859517728D-16,  -1.608726479396624D-14,   9.475948358983453D-13, &
&   -5.343783860297948D-11,   3.034893262832537D-09,  -1.769432332816778D-07, &
&    1.082925081808533D-05,  -7.363906310510900D-04,   7.511185113983642D-02, &
&    1.365296540701756D-30,  -1.275729282135551D-29,   2.895327199987573D-28, &
&   -5.694183852251931D-27,   9.753333881678582D-26,  -1.512088664026418D-24, &
&    2.253743662439316D-23,  -4.079320881436766D-22,   1.291955545132958D-20, &
&   -6.481680465446653D-19,   3.789005201230811D-17,  -2.331014788797031D-15, &
&    1.510063186142893D-13,  -1.087225345632988D-11,   1.174202541529427D-09, &
&    2.786602637048931D-28,  -3.557069288083870D-27,   7.687568024780860D-26, &
&   -1.531128391846109D-24,   2.688757520393230D-23,  -4.335718662014338D-22, &
&    7.162634019674622D-21,  -1.638735435393702D-19,   6.478225481450252D-18, &
&   -3.494217999311404D-16,   2.067762917044581D-14,  -1.273976629922718D-12, &
&    8.254100631767125D-11,  -5.942893275562023D-09,   6.418322280560230D-07, &
&    1.071047801796343D-26,  -1.387780991001393D-25,   3.044661065056245D-24, &
&   -6.144337738866666D-23,   1.100678551011585D-21,  -1.862639107936818D-20, &
&    3.521191034893816D-19,  -1.015976167345390D-17,   4.659286378091919D-16, &
&   -2.612286765032417D-14,   1.555488150198351D-12,  -9.590756665723582D-11, &
&    6.214282594343057D-09,  -4.474258756160323D-07,   4.832198427555247D-05, &
&    1.160024203003402D-25,  -1.520652035545572D-24,   3.371684959581431D-23, &
&   -6.892929455966012D-22,   1.270857342583247D-20,  -2.334811638933858D-19, &
&    5.381698632585530D-18,  -1.964124214560394D-16,   1.001606210301476D-14, &
&   -5.750817580796353D-13,   3.437037247019377D-11,  -2.120141287847388D-09, &
&    1.373791539253421D-07,  -9.891270922891269D-06,   1.068257142186123D-03, &
&    4.044005988240897D-25,  -5.351826272933385D-24,   1.201580617280562D-22, &
&   -2.517549972145898D-21,   4.967236296540979D-20,  -1.092283404843665D-18, &
&    3.415561177827744D-17,  -1.563009665788652D-15,   8.587807548287463D-14, &
&   -5.005534678364574D-12,   2.998502958322539D-10,  -1.850145392172113D-08, &
&    1.198872656693809D-06,  -8.631872999785574D-05,   9.322422416676583D-03, &
&    2.420386124663286D-25,  -3.305451386028154D-24,   7.961013598337553D-23, &
&   -1.968263040353801D-21,   5.613085985786153D-20,  -2.155508625470500D-18, &
&    1.062650804340668D-16,  -5.877507021667979D-15,   3.387721840922558D-13, &
&   -1.992442270526869D-11,   1.195173335630547D-09,  -7.375708676194752D-08, &
&    4.779446107553581D-06,  -3.441200580275184D-04,   3.716496600877998D-02, &
&   -7.532666035293872D-25,   9.755656878042750D-24,  -2.050683535921801D-22, &
&    3.456484849494778D-21,  -1.885115068239710D-20,  -2.228671049244439D-18, &
&    1.814026308426700D-16,  -1.122045204508866D-14,   6.620908838511498D-13, &
&   -3.910528766631199D-11,   2.347237777136175D-09,  -1.448649697837636D-07, &
&    9.387291256017178D-06,  -6.758851641239655D-04,   7.299559853469578D-02, &
&    3.847509814133020D-31,  -3.249667972306519D-30,   4.332182229771146D-29, &
&   -8.162780315166290D-28,   1.374556704452780D-26,  -2.237085642556369D-25, &
&    4.446248960160124D-24,  -1.496898211822316D-22,   7.780595138266372D-21, &
&   -4.695989686437956D-19,   2.961928690547087D-17,  -1.928614604365626D-15, &
&    1.319122231397545D-13,  -1.002530625027606D-11,   1.142884820867248D-09, &
&    5.349484144730307D-29,  -6.164737908467099D-28,   1.222539264679356D-26, &
&   -2.310172911244155D-25,   4.004772440537671D-24,  -7.221015704475559D-23, &
&    1.796974473723441D-21,  -7.479481003370454D-20,   4.185573515868403D-18, &
&   -2.561403095716798D-16,   1.618656068955891D-14,  -1.054182778626951D-12, &
&    7.210461814370075D-11,  -5.479944225379608D-09,   6.247136142997011D-07, &
&    2.130724641621414D-27,  -2.465217425846942D-26,   4.952789898215863D-25, &
&   -9.543865792191055D-24,   1.738436909951657D-22,  -3.586354104607810D-21, &
&    1.115621611239209D-19,  -5.364677874451533D-18,   3.125387119785566D-16, &
&   -1.926297621877593D-14,   1.218503245783960D-12,  -7.936608370923584D-11, &
&    5.428577928044705D-09,  -4.125716386689676D-07,   4.703316565387880D-05, &
&    2.352587503836017D-26,  -2.745749587969248D-25,   5.592544279927779D-24, &
&   -1.110171405359693D-22,   2.201873353993334D-21,  -5.530135266717492D-20, &
&    2.156491734864365D-18,  -1.150953037868720D-16,   6.875160989600576D-15, &
&   -4.255659318322829D-13,   2.693561091288064D-11,  -1.754540680884837D-09, &
&    1.200098721854993D-07,  -9.120747038382158D-06,   1.039765149146822D-03, &
&    8.322523702201948D-26,  -9.827115443331604D-25,   2.056530190706160D-23, &
&   -4.384710546339967D-22,   1.045857083777758D-20,  -3.540102399014554D-19, &
&    1.715054269999262D-17,  -9.854719466781075D-16,   5.981251633418121D-14, &
&   -3.712276149918883D-12,   2.350501084311914D-10,  -1.531139680336572D-08, &
&    1.047296982368862D-06,  -7.959455894752303D-05,   9.073779672258363D-03, &
&    5.178821516290668D-26,  -6.572490794748410D-25,   1.651805699267712D-23, &
&   -5.137975579431555D-22,   2.124549089735067D-20,  -1.110095521223519D-18, &
&    6.445346658375517D-17,  -3.884114897090944D-15,   2.380124272026274D-13, &
&   -1.479580836921488D-11,   9.370309153518098D-10,  -6.104060357044791D-08, &
&    4.175175722065034D-06,  -3.173133477169375D-04,   3.617372161049690D-02, &
&   -1.515198815301513D-25,   1.667765060244770D-24,  -2.713473203290846D-23, &
&    1.163561222665518D-22,   2.304544273522621D-20,  -1.904681773374355D-18, &
&    1.230007887459836D-16,  -7.587857163990654D-15,   4.670775625824583D-13, &
&   -2.905706351159555D-11,   1.840396770628655D-09,  -1.198895431625041D-07, &
&    8.200449647523860D-06,  -6.232341956226834D-04,   7.104869839238976D-02, &
&    8.419480939217145D-31,  -6.246983014855983D-31,  -8.366844577821703D-32, &
&   -1.090783136638088D-28,   1.987432612622008D-27,  -4.343940976282085D-26, &
&    1.586511631112812D-24,  -8.644730076408116D-23,   5.415164303924528D-21, &
&   -3.527731724716151D-19,   2.350421657997654D-17,  -1.611620233314016D-15, &
&    1.160361074877342D-13,  -9.282886163276249D-12,   1.113946329950187D-09, &
&    9.595904012012979D-30,  -9.152472539903070D-29,   1.725519059651637D-27, &
&   -3.285162876989265D-26,   6.492125594875023D-25,  -1.783613921945403D-23, &
&    7.946481643878089D-22,  -4.646917438185547D-20,   2.952654484002847D-18, &
&   -1.927714718724442D-16,   1.284728473486799D-14,  -8.809276346099927D-13, &
&    6.342662529151234D-11,  -5.074129291086194D-09,   6.088955120194301D-07, &
&    3.356529273971620D-28,  -3.747565021193181D-27,   7.242163636265658D-26, &
&   -1.444925977533877D-24,   3.281081822400184D-23,  -1.118211699556398D-21, &
&    5.703718058559608D-20,  -3.468116828075335D-18,   2.220108193263292D-16, &
&   -1.451099202890078D-14,   9.672255274119246D-13,  -6.632281493856856D-11, &
&    4.775235742443536D-09,  -3.820188284411237D-07,   4.584225928960219D-05, &
&    3.900685679354409D-27,  -4.252275975949267D-26,   8.498494022084473D-25, &
&   -1.859455867777953D-23,   5.152740968260209D-22,  -2.176345912810724D-20, &
&    1.223979209572787D-18,  -7.626465878597250D-17,   4.904162088503427D-15, &
&   -3.207644613594019D-13,   2.138230985997255D-11,  -1.466201554643024D-09, &
&    1.055664324475614D-07,  -8.445314240387300D-06,   1.013437707428375D-03, &
&    1.395910480230197D-26,  -1.574152450751144D-25,   3.416516512397085D-24, &
&   -9.063330390128093D-23,   3.364219116435869D-21,  -1.739207638325989D-19, &
&    1.048067827435683D-17,  -6.633346693857722D-16,   4.277641753890900D-14, &
&   -2.799064379802008D-12,   1.865971301900309D-10,  -1.279518135720120D-08, &
&    9.212527706649755D-07,  -7.370022036837136D-05,   8.844026439073305D-03, &
&    9.281877947072397D-27,  -1.302603080703786D-25,   4.272404010023150D-24, &
&   -1.934373207939871D-22,   1.075066083402643D-20,  -6.556549486006846D-19, &
&    4.130863677040922D-17,  -2.639238441311029D-15,   1.704835359460438D-13, &
&   -1.115840614107310D-11,   7.438893692007954D-10,  -5.100952590736349D-08, &
&    3.672685689558678D-06,  -2.938148543769931D-04,   3.525778252208968D-02, &
&   -2.311284605488130D-26,   1.979577941221061D-25,  -1.585509693914365D-25, &
&   -2.262524798595646D-22,   1.867565839025372D-20,  -1.253159757377588D-18, &
&    8.069862633853568D-17,  -5.178911819821186D-15,   3.348002986049350D-13, &
&   -2.191582052044218D-11,   1.461068402362881D-09,  -1.001876440846589D-07, &
&    7.213510923505268D-06,  -5.770808763400559D-04,   6.924970517063181D-02, &
&   -6.683939319968577D-31,   9.550133703953702D-32,   5.574322214975631D-30, &
&   -1.675258011365713D-29,   3.725990359487022D-28,  -1.547784250842077D-26, &
&    8.915138629747127D-25,  -5.814314053026801D-23,   3.925336606120525D-21, &
&   -2.695914277753988D-19,   1.886987708304007D-17,  -1.358620760408200D-15, &
&    1.027116720570786D-13,  -8.627780202704509D-12,   1.087100304567359D-09, &
&    1.789853408578393D-30,  -1.199687187661787D-29,   2.327674271357685D-28, &
&   -5.273279538835974D-27,   1.619588151299655D-25,  -7.808583074315736D-24, &
&    4.794628512726158D-22,  -3.169886994516417D-20,   2.144873864758336D-18, &
&   -1.473557711294976D-16,   1.031444753170990D-14,  -7.426370944436630D-13, &
&    5.614334697927959D-11,  -4.716041070368694D-09,   5.942211745700094D-07, &
&    4.724481979973070D-29,  -5.214773575393582D-28,   1.065516078257484D-26, &
&   -2.729527883863601D-25,   1.031804827606625D-23,  -5.624284940583127D-22, &
&    3.578954650860966D-20,  -2.383250263289646D-18,   1.614520345413501D-16, &
&   -1.109381914774666D-14,   7.765480762083991D-13,  -5.591132916191262D-11, &
&    4.226895748543365D-09,  -3.550592396530940D-07,   4.473746418366916D-05, &
&    5.608211204149855D-28,  -6.194121251421690D-27,   1.402864039712689D-25, &
&   -4.401273106069701D-24,   2.032447939615697D-22,  -1.209411295376854D-20, &
&    7.870734447001391D-19,  -5.264249794530139D-17,   3.568820698588738D-15, &
&   -2.452485294539339D-13,   1.716717610059925D-11,  -1.236035159191490D-09, &
&    9.344424956727504D-08,  -7.849316926508944D-06,   9.890139325945738D-04, &
&    2.144776944317559D-27,  -2.534589449147359D-26,   7.112972921062821D-25, &
&   -2.956328127709708D-23,   1.638514829749443D-21,  -1.036901431198335D-19, &
&    6.846009021001233D-18,  -4.591560074475553D-16,   3.114198376550398D-14, &
&   -2.140206959664065D-12,   1.498136889671985D-10,  -1.078658010902115D-08, &
&    8.154654255936266D-07,  -6.849909561530946D-05,   8.630886047001253D-03, &
&    1.774356785960083D-27,  -3.370748168556027D-26,   1.632478757075806D-24, &
&   -9.700801369083981D-23,   6.212842931596454D-21,  -4.089884899055751D-19, &
&    2.723886264804862D-17,  -1.829905151322712D-15,   1.241459263584065D-13, &
&   -8.532151811418451D-12,   5.972501378522359D-10,  -4.300200655426733D-08, &
&    3.250951676684286D-06,  -2.730799407587728D-04,   3.440807253528065D-02, &
&   -2.373282735024485D-27,  -4.629760341936744D-27,   2.100176035554139D-24, &
&   -1.713869470307479D-22,   1.190907044165522D-20,  -7.992570107386580D-19, &
&    5.345039726294481D-17,  -3.593580083767526D-15,   2.438296910764601D-13, &
&   -1.675793463548949D-11,   1.173056952323886D-09,  -8.446011109054560D-08, &
&    6.385184457133061D-06,  -5.363554946568824D-04,   6.758079232777811D-02, &
&   -4.475727977153260D-31,   4.549473748245723D-31,   3.587213782304007D-30, &
&   -6.313365921886563D-30,   1.294885021450423D-28,  -8.556818333784033D-27, &
&    5.825851302780424D-25,  -4.081771391511335D-23,   2.899093959246697D-21, &
&   -2.087150410668982D-19,   1.530561146382279D-17,  -1.154479347352022D-15, &
&    9.143475854781652D-14,  -8.046258727509336D-12,   1.062106151936531D-09, &
&    4.355421978823638D-31,  -1.953118891513647D-30,   3.639034533519846D-29, &
&   -1.356816508329748D-27,   7.138432404279988D-26,  -4.613260326859183D-24, &
&    3.176330697685359D-22,  -2.230306491830395D-20,   1.584602010223659D-18, &
&   -1.140853977467017D-16,   8.366214606183886D-15,  -6.310512938432960D-13, &
&    4.997926071512030D-11,  -4.398174935373632D-09,   5.805590914402530D-07, &
&    3.236389244641091D-30,  -7.211184004657654D-29,   2.093911935446159D-27, &
&   -8.841557837525435D-26,   5.168395208998400D-24,  -3.445966370556612D-22, &
&    2.388158166428714D-20,  -1.678807013575168D-18,   1.192977758552862D-16, &
&   -8.589188078514746D-15,   6.298717601336634D-13,  -4.751031335145782D-11, &
&    3.762816742569338D-09,  -3.311278730235530D-07,   4.370887923786620D-05, &
&    8.605617837022524D-29,  -1.028667183164764D-27,   3.450159715263454D-26, &
&   -1.767986817441874D-24,   1.115038428523319D-22,  -7.581292740804845D-21, &
&    5.275150821310405D-19,  -3.710891913420992D-17,   2.637281840760816D-15, &
&   -1.898813988878531D-13,   1.392461252949833D-11,  -1.050313472936772D-09, &
&    8.318482619278570D-08,  -7.320264701239214D-06,   9.662749405492042D-04, &
&    3.585384315708021D-28,  -5.373348061118560D-27,   2.407726675592986D-25, &
&   -1.441368690656616D-23,   9.579691149401083D-22,  -6.595836755618724D-20, &
&    4.601092696941831D-18,  -3.238153393276347D-16,   2.301469239225405D-14, &
&   -1.657047385368288D-12,   1.215167235785250D-10,  -9.165832292157341D-09, &
&    7.259339144059841D-07,  -6.388218445420260D-05,   8.432448347902538D-03, &
&    4.126958138410793D-28,  -1.300565757614715D-26,   8.182215833257371D-25, &
&   -5.505693868034812D-23,   3.783227027438164D-21,  -2.624714134114509D-19, &
&    1.833708844375906D-17,  -1.290868856709396D-15,   9.175030895182046D-14, &
&   -6.606015822769653D-12,   4.844411083220454D-10,  -3.654070039025430D-08, &
&    2.894023468979791D-06,  -2.546740652618893D-04,   3.361697661453719D-02, &
&    2.367949540254243D-28,  -1.808625642482381D-26,   1.473745928037755D-24, &
&   -1.059208148456419D-22,   7.397607929120874D-21,  -5.150768390086405D-19, &
&    3.601053403359312D-17,  -2.535336011158816D-15,   1.802059989349529D-13, &
&   -1.297485196334757D-11,   9.514893061443224D-10,  -7.176948018771322D-08, &
&    5.684142836868550D-06,  -5.002045696703448D-04,   6.602700319658555D-02, &
&    6.785557096649343D-32,  -4.006306613856827D-31,   8.943005393257973D-32, &
&    1.576413399948736D-30,   7.463874835043884D-29,  -5.469655821784325D-27, &
&    3.973593865681516D-25,  -2.922457714220691D-23,   2.171394506286657D-21, &
&   -1.634447867949514D-19,   1.253075120815865D-17,  -9.881391340436152D-16, &
&    8.181791974142668D-14,  -7.527248613855607D-12,   1.038760308703161D-09, &
&    1.433345209151111D-31,  -2.132178762936872D-31,   9.562274890603106D-30, &
&   -6.107697889087643D-28,   4.154573716663309D-26,  -2.978886306866430D-24, &
&    2.171178988534190D-22,  -1.597367809900054D-20,   1.186901348927859D-18, &
&   -8.934069284900176D-17,   6.849448300146847D-15,  -5.401278912091692D-13, &
&    4.472258922082623D-11,  -4.114478207589969D-09,   5.677979926446611D-07, &
&   -1.159215770607708D-30,  -1.661820801841012D-29,   7.220067393203807D-28, &
&   -4.445885471328387D-26,   3.106248725813881D-24,  -2.239958813427902D-22, &
&    1.634305644988431D-20,  -1.202586266743146D-18,   8.935861580051820D-17, &
&   -6.726240815844180D-15,   5.156782571237583D-13,  -4.066491262831245D-11, &
&    3.367054758295286D-09,  -3.097690377320507D-07,   4.274812720690476D-05, &
&    2.435672535037948D-29,  -2.532600229719350D-28,   1.427950644961422D-26, &
&   -9.631784896900160D-25,   6.838213653970625D-23,  -4.948114591903990D-21, &
&    3.612529568745113D-19,  -2.658519731707583D-17,   1.975452486386090D-15, &
&   -1.486973976370231D-13,   1.140013144758712D-11,  -8.989817784123072D-10, &
&    7.443569116774789D-08,  -6.848083587072444D-06,   9.450355350146266D-04, &
&    9.044641452383300D-29,  -1.879851083503978D-27,   1.185412645048709D-25, &
&   -8.295135460619271D-24,   5.951576754325456D-22,  -4.316014037321680D-20, &
&    3.152323637449933D-18,  -2.320000912122526D-16,   1.723927486166016D-14, &
&   -1.297646152605730D-12,   9.948619643041002D-11,  -7.845197147077341D-09, &
&    6.495823234699172D-07,  -5.976157375792209D-05,   8.247097178588262D-03, &
&    1.470436282677401D-28,  -6.546597209626834D-27,   4.575808656254728D-25, &
&   -3.280843181421720D-23,   2.368865659385722D-21,  -1.720133435966016D-19, &
&    1.256653742869104D-17,  -9.248904472640159D-16,   6.872640316930911D-14, &
&   -5.173223136369565D-12,   3.966137684912811D-10,  -3.127582856580377D-08, &
&    2.589638605058496D-06,  -2.382467516645726D-04,   3.287805172970794D-02, &
&    3.153014540286964D-28,  -1.191600257083511D-26,   8.831293831523764D-25, &
&   -6.419842482894956D-23,   4.649175051715529D-21,  -3.378048685446017D-19, &
&    2.468135958758006D-17,  -1.816568991646644D-15,   1.349852728591046D-13, &
&   -1.016071170314477D-11,   7.789879137223565D-10,  -6.142876130589807D-08, &
&    5.086301436718796D-06,  -4.679397321806407D-04,   6.457568304093798D-02, &
&    4.133473649035090D-31,  -7.155248694976057D-31,  -2.954967323660232D-30, &
&    4.792010452537261D-30,   5.588909143528209D-29,  -3.645910588646075D-27, &
&    2.765330629690418D-25,  -2.123632827515557D-23,   1.646612522819788D-21, &
&   -1.293337336203981D-19,   1.034669717087434D-17,  -8.513853573321810D-16, &
&    7.355969482133356D-14,  -7.061730702630299D-12,   1.016889221177949D-09, &
&    5.412384206384691D-31,  -6.561998546373792D-31,   6.187941646715087D-31, &
&   -3.472338449750615D-28,   2.623717120888915D-26,  -1.983434553320867D-24, &
&    1.511533942729016D-22,  -1.160795178964108D-20,   9.000561451503601D-19, &
&   -7.069525915122967D-17,   5.655620265189517D-15,  -4.653767502037486D-13, &
&    4.020855120146155D-11,  -3.860020915272764D-09,   5.558430117990248D-07, &
&   -3.980889579301083D-30,  -3.300790123076675D-30,   3.926547353344164D-28, &
&   -2.631750229845096D-26,   1.972095881871252D-24,  -1.493000308361369D-22, &
&    1.137966334179598D-20,  -8.739312822613219D-19,   6.776300640328490D-17, &
&   -5.322473579697296D-15,   4.257978663847647D-13,  -3.503708144616973D-11, &
&    3.027203836255734D-09,  -2.906115682776450D-07,   4.184806583196998D-05, &
&    2.692273943189796D-29,  -1.099040494313286D-28,   7.624028826721374D-27, &
&   -5.794354644422796D-25,   4.357122570309591D-23,  -3.300214725110686D-21, &
&    2.515666702835361D-19,  -1.932001065934950D-17,   1.498040661686670D-15, &
&   -1.176642551060683D-13,   9.413140177103506D-12,  -7.745669616309596D-10, &
&    6.692258547687389D-08,  -6.424568205746166D-06,   9.251378216273212D-04, &
&    2.252146608114813D-29,  -9.581647234502497D-28,   6.747812692961741D-26, &
&   -5.045047315508601D-24,   3.800698768789795D-22,  -2.879811566516052D-20, &
&    2.195337963424705D-18,  -1.686008326742483D-16,   1.307303741537911D-14, &
&   -1.026827558601183D-12,   8.214620384712908D-11,  -6.759459053915961D-09, &
&    5.840172622290735D-07,  -5.606565717386823D-05,   8.073454633036563D-03, &
&    1.485771138760680D-29,  -3.546607582343977D-27,   2.678902536018440D-25, &
&   -2.008699275796038D-23,   1.514808751352289D-21,  -1.148022340405129D-19, &
&    8.751923868414953D-18,  -6.721470619563844D-16,   5.211724186513483D-14, &
&   -4.093572385685610D-12,   3.274857903358807D-10,  -2.694740217280954D-08, &
&    2.328255547712654D-06,  -2.235125325803388D-04,   3.218580469156850D-02, &
&    2.496771113611314D-28,  -6.984019350772667D-27,   5.227536416393780D-25, &
&   -3.942710005610141D-23,   2.974881991184111D-21,  -2.254781526668399D-19, &
&    1.718957482568220D-17,  -1.320161498224591D-15,   1.023633140945658D-13, &
&   -8.040173240296132D-12,   6.432138608354656D-10,  -5.292731198787058D-08, &
&    4.572919755808124D-06,  -4.390002965578154D-04,   6.321604270432631D-02/
end


!------------------
  module rysgrid8
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t8(15,8,0:25)
      real(8) :: w8(15,8,0:25)
      data t8 / &
&    7.959228287628360D-18,  -8.633457916174975D-17,   4.188169322190930D-16, &
&   -1.196458742891324D-15,   2.269615756159815D-15,  -2.848665345227627D-15, &
&   -1.958731148332462D-14,  -1.354495084119331D-12,  -5.817875119894960D-11, &
&   -2.122930385061246D-09,  -6.921799166954598D-08,  -2.046968249732834D-06, &
&   -5.448223014618979D-05,  -1.250980563913419D-03,   9.789142101623511D-01, &
&   -1.592906852103273D-17,   1.732394132723092D-16,  -8.425861906337354D-16, &
&    2.408196617810200D-15,  -4.782445307256223D-15,   3.012496780656563D-15, &
&    6.930056372993611D-14,   5.316175621447590D-12,   1.564938772495332D-10, &
&    1.947345198939064D-09,  -6.383690475096821D-08,  -5.223788884406523D-06, &
&   -2.078875519446800D-04,  -5.827995329929145D-03,   8.922219742137979D-01, &
&    1.144114873235029D-17,  -1.250641342540257D-16,   6.105750995720009D-16, &
&   -1.753993260078318D-15,   3.891138729043811D-15,   2.354726752555107D-15, &
&   -2.310492849658472D-13,  -1.020524829116551D-11,  -6.643583562991922D-11, &
&    6.431107613156787D-09,   2.226679441303807D-07,   2.349571272535797D-08, &
&   -2.581864528853033D-04,  -1.138429362146975D-02,   7.493173785474033D-01, &
&   -4.377520363505302D-18,   4.813599380614632D-17,  -2.356122609066039D-16, &
&    6.938361202670220D-16,  -2.056083478233542D-15,  -6.515353907860924D-15, &
&    4.348578074639875D-13,   8.283341377576367D-12,  -2.556495684305377D-10, &
&   -7.909138685226457D-09,   1.519954546317337D-07,   8.353240486085428D-06, &
&   -9.556010669379233D-05,  -1.484912611575862D-02,   5.706358201621722D-01, &
&    1.075994633018932D-18,  -1.181332069406235D-17,   5.775670982825552D-17, &
&   -1.903129563618884D-16,   9.596811571426178D-16,   6.124017642278158D-15, &
&   -4.851390240882118D-13,   6.239535333080379D-13,   3.390056942609219D-10, &
&   -4.260346270196901D-09,  -2.272634808778432D-07,   6.795005863407616D-06, &
&    1.535447230804563D-04,  -1.430435855667711D-02,   3.817710533971156D-01, &
&   -1.660861468798129D-19,   1.811573744776279D-18,  -9.188173343407018D-18, &
&    4.399548043224340D-17,  -3.675058489762689D-16,  -3.985898389211388D-15, &
&    3.335027895182872D-13,  -6.175687797064375D-12,  -8.145241175312514D-11, &
&    7.374241747106563D-09,  -1.547059922066260D-07,  -2.135713013458297D-06, &
&    2.649310522336719D-04,  -1.004678697689624D-02,   2.097793686155101D-01, &
&    1.330166071337218D-20,  -1.475397168422641D-19,   9.168870388406066D-19, &
&   -7.481175749069102D-18,   5.185513964943575D-17,   2.355377301298057D-15, &
&   -1.433443584303815D-13,   4.429857420564690D-12,  -7.724340072433820D-11, &
&   -4.632325500125025D-10,   1.013049085949219D-07,  -4.959439873328118D-06, &
&    1.691729156266312D-04,  -4.424968546974029D-03,   7.930055981148665D-02, &
&    1.489978829955555D-22,  -1.337299514261163D-21,   9.021827866473463D-21, &
&   -3.883684782140529D-19,   2.025419323842695D-17,  -8.642264410170498D-16, &
&    3.269023364126390D-14,  -1.141703838426716D-12,   3.746621329590265D-11, &
&   -1.164080640898511D-09,   3.424900696544292D-08,  -9.477807450890717D-07, &
&    2.419178901433520D-05,  -5.421747569505436D-04,   9.027377025647151D-03, &
&    5.150923862488688D-25,   4.901199302522005D-21,   1.927289579466368D-19, &
&    5.620676894978056D-18,   1.284733802086192D-16,   2.008802216010679D-15, &
&   -1.293716444410509D-15,  -1.737297769028587D-12,  -9.144763951949164D-11, &
&   -3.456827621245522D-09,  -1.103140515807749D-07,  -3.104191098312506D-06, &
&   -7.729393921929380D-05,  -1.641569526426153D-03,   9.746094922126589D-01, &
&    1.778085516743587D-21,   3.713326541708038D-20,   6.521859621895780D-19, &
&   -2.648760069804698D-18,  -5.009809044894460D-16,  -1.440540963787696D-14, &
&   -1.398518036131275D-13,   5.157892390550382D-12,   2.752859378435899D-10, &
&    5.834289397736595D-09,  -8.186942869182614D-09,  -5.714233770954895D-06, &
&   -2.576045910781843D-04,  -7.222212287395905D-03,   8.727213864939012D-01, &
&    5.174809489279150D-21,   1.991726688936322D-20,  -1.270273962879890D-18, &
&   -3.029257938527525D-17,   2.772399584818597D-16,   2.254783943486362D-14, &
&    1.776767420217294D-13,  -1.178328803729389D-11,  -3.147699867745659D-10, &
&    3.055755428944573D-09,   2.994858526837253D-07,   3.206874824002733D-06, &
&   -2.443514072430331D-04,  -1.290627774985436D-02,   7.128609807320687D-01, &
&    6.630059863494379D-22,  -5.523754448993376D-20,  -1.378216271242718D-19, &
&    3.349862153790158D-17,   4.903328750433221D-17,  -2.109331531126264D-14, &
&   -1.514189708215429D-14,   1.405891598906711D-11,  -1.624678741543491D-12, &
&   -1.041118077567639D-08,   8.789097175220503D-09,   9.356044145661306D-06, &
&   -1.456895290387883D-05,  -1.518406041722927D-02,   5.254641624631807D-01, &
&   -2.424136990128316D-21,   1.101622626807168D-20,   6.222147895681912D-19, &
&   -1.744983534363383D-17,  -1.214375750436756D-16,   1.395155415642241D-14, &
&   -1.558370934198841D-13,  -7.468227276939854D-12,   2.528449331976550D-10, &
&    1.323704440089339D-09,  -2.472844592793894D-07,   3.863182087742971D-06, &
&    2.016831000720448D-04,  -1.322540549795315D-02,   3.404041472642195D-01, &
&    2.947077614571996D-22,   6.676975875397893D-21,  -3.236843409312086D-19, &
&    5.243694096355309D-18,   7.359876190358370D-17,  -6.612397602449139D-15, &
&    1.630802804807273D-13,  -8.987319320635334D-14,  -1.398577893048327D-10, &
&    5.189984336563089D-09,  -5.919383117465703D-08,  -3.385769740466765D-06, &
&    2.392224917017134D-04,  -8.528731321090543D-03,   1.819549128668680D-01, &
&    1.685937925949345D-22,  -2.828209796747038D-21,   6.136487622071608D-20, &
&   -4.997722000364226D-19,  -3.402165982196603D-17,   2.161922328904521D-15, &
&   -7.698818547146848D-14,   1.800937344040941D-12,  -1.465093486746704D-11, &
&   -1.207577660020305D-09,   8.737832406769296D-08,  -3.816423266215309D-06, &
&    1.298093727465458D-04,  -3.533174986465180D-03,   6.742235115230024D-02, &
&   -1.865701349848216D-24,  -4.045815981400616D-23,   4.055968712444918D-21, &
&   -2.264941225618968D-19,   1.022722064166371D-17,  -4.198490168763096D-16, &
&    1.603210871434177D-14,  -5.808938568374998D-13,   2.007289021786329D-11, &
&   -6.637442917924628D-10,   2.092855792681074D-08,  -6.241680467259111D-07, &
&    1.723720706003039D-05,  -4.193373386007568D-04,   7.595505088339401D-03, &
&   -1.458589569249535D-21,  -3.807769550337664D-21,   3.231218892091556D-19, &
&    1.564223457716669D-17,   4.650315057724263D-16,   1.007194900099470D-14, &
&    1.392807710827723D-13,  -5.077365507239379D-13,  -1.207362480594098D-10, &
&   -5.402552932061340D-09,  -1.760750536541580D-07,  -4.793235042490487D-06, &
&   -1.122417590750439D-04,  -2.202602324877769D-03,   9.688954791484063D-01, &
&   -7.059250590975822D-21,   4.422321405618138D-21,   2.128338289585371D-18, &
&    5.010744659120190D-17,   1.274637811507174D-16,  -2.440540576848514D-14, &
&   -7.040725891608888D-13,  -4.381500008430228D-12,   3.074657648986189D-10, &
&    1.137571397765356D-08,   1.200552829385600D-07,  -5.127030058316484D-06, &
&   -3.075428751404818D-04,  -8.920221156810453D-03,   8.485829893231561D-01, &
&   -2.147709370377007D-21,   9.142817732879360D-20,   1.471631369496511D-18, &
&   -3.602083828433698D-17,  -1.096048181091153D-15,   1.090302249733409D-14, &
&    7.257805011518182D-13,  -3.206496899215921D-13,  -4.657063204412309D-10, &
&   -4.333495801710627D-09,   2.934077751716283D-07,   6.876175239982974D-06, &
&   -1.989293729196691D-04,  -1.425273311230430D-02,   6.720543177227594D-01, &
&    3.758613490099659D-21,   1.536099121062999D-20,  -1.166436946629537D-18, &
&    1.313313360982586D-18,   7.288391469225036D-16,  -6.616978948590502D-15, &
&   -4.365651695811676D-13,   7.825650051606286D-12,   2.462659222780144D-10, &
&   -8.007856225516126D-09,  -1.350134634923136D-07,   8.562036665485510D-06, &
&    6.736688518482991D-05,  -1.502206035428479D-02,   4.800316848838375D-01, &
&    5.861923076859699D-23,  -1.362489437010757D-20,   3.693135936612424D-19, &
&    3.105297326840747D-18,  -3.301854878025650D-16,   5.434479363525111D-15, &
&    1.195678548660449D-13,  -7.424491545874857D-12,   8.479083147275068D-11, &
&    4.357979404187302D-09,  -2.008378333042643D-07,   1.128951531816672D-06, &
&    2.237227397228356D-04,  -1.193684300148722D-02,   3.026278434395363D-01, &
&   -2.370180544155396D-22,   5.214259968801479D-21,  -5.397369754539330D-20, &
&   -1.316587109509049D-18,   1.112606108279212D-16,  -3.302526463902662D-15, &
&    2.705589328492251D-14,   2.007248716086874D-12,  -1.139954068458746D-10, &
&    2.840424230318108D-09,   4.265135604938218D-10,  -3.702937126214643D-06, &
&    2.067878415222628D-04,  -7.189305035210752D-03,   1.584266708038391D-01, &
&    5.876014372609679D-23,  -3.741293158570414D-22,   7.223382721821945D-21, &
&    4.618783671508425D-19,  -2.939326111699168D-17,   1.136101171835039D-15, &
&   -3.284748666977560D-14,   5.390867272512710D-13,   8.068873372102139D-12, &
&   -1.227423917696967D-09,   6.861293660014261D-08,  -2.880295726046746D-06, &
&    9.984392452944317D-05,  -2.848427785239713D-03,   5.789484411579726D-02, &
&    1.294302380699888D-24,  -1.621168857355654D-23,   2.705278211061623D-21, &
&   -1.085847501142677D-19,   4.835430795667265D-18,  -2.035691392298138D-16, &
&    7.978037302447512D-15,  -3.043472140902948D-13,   1.111309535073375D-11, &
&   -3.917089980476921D-10,   1.321275091898011D-08,  -4.233749005262047D-07, &
&    1.259234705040455D-05,  -3.307486061313386D-04,   6.477322782355720D-03, &
&   -9.288428755590326D-21,  -1.005794607632939D-19,  -1.117360663713257D-18, &
&    1.141304341732773D-17,   1.046365770838702D-15,   3.291818866522958D-14, &
&    6.786383444155643D-13,   8.072527996818082D-12,  -6.360824424256707D-11, &
&   -7.324151018185096D-09,  -2.727110359400864D-07,  -7.456350120170911D-06, &
&   -1.664931108012039D-04,  -3.026849855715472D-03,   9.611324161115549D-01, &
&   -9.962276607334618D-21,  -2.473699096705398D-19,  -2.267776873262298D-18, &
&    7.804672114025952D-17,   2.670210385608335D-15,   1.472225716454539D-14, &
&   -1.012162523665853D-12,  -2.705603566377857D-11,  -8.178173218587512D-12, &
&    1.479655897786330D-08,   3.233813580328340D-07,  -2.519921314684706D-06, &
&   -3.437966985545461D-04,  -1.088592285572523D-02,   8.189287084192236D-01, &
&   -1.018494849058602D-20,  -8.696231100251054D-20,   2.235187802921513D-18, &
&    5.220917659465874D-17,  -9.146819493533981D-16,  -2.691345946002694D-14, &
&    4.986244163587548D-13,   1.649877390313458D-11,  -2.862075232661887D-10, &
&   -1.164416037762481D-08,   1.694931381222083D-07,   9.764888696289684D-06, &
&   -1.229219718640411D-04,  -1.523138717386093D-02,   6.277137884564568D-01, &
&   -2.577520440113127D-21,   2.573327613077377D-20,   1.480863500960694D-19, &
&   -1.808281474459110D-17,   3.146881320262380D-16,   1.065444395435606D-14, &
&   -3.521985256671102D-13,  -2.589738075890238D-12,   2.974417810443287D-10, &
&   -2.780368200237043D-09,  -2.170589932330981D-07,   6.370179456679280D-06, &
&    1.353022946225310D-04,  -1.440411758589857D-02,   4.357902924687058D-01, &
&    8.859089375900118D-23,  -8.079837238781356D-21,  -4.942223530320018D-20, &
&    8.102374917193421D-18,  -1.040072187482899D-16,  -1.477204055725368D-15, &
&    1.571685710509014D-13,  -3.726180863766311D-12,  -3.373555314826702D-11, &
&    4.698590681696332D-09,  -1.302404768595115D-07,  -8.622677594404022D-07, &
&    2.242826242465741D-04,  -1.058386228769866D-02,   2.688461383562693D-01, &
&   -3.100497146612995D-22,  -8.542310089702933D-22,   3.740728917650649D-20, &
&   -9.344327146829221D-19,   6.497224135026421D-17,  -7.023755356880957D-16, &
&   -2.376165334715048D-14,   1.906895719460693D-12,  -7.079029049631992D-11, &
&    1.181393842573378D-09,   2.960860826542248D-08,  -3.497854192130915D-06, &
&    1.741234157588875D-04,  -6.047516516199749D-03,   1.386205131462126D-01, &
&   -5.788547248913291D-23,  -5.243362035603400D-22,  -9.813720990878132D-22, &
&    5.966001083335723D-19,  -1.124617570213513D-17,   5.149989291135517D-16, &
&   -1.179088476350539D-14,   3.709199216354504D-14,   1.324475964394424D-11, &
&   -1.020000824066159D-09,   5.164470649197136D-08,  -2.161907741707068D-06, &
&    7.730692256579011D-05,  -2.320205129908925D-03,   5.017565434648298D-02, &
&   -6.481793874505371D-24,  -7.645689615765808D-23,   1.544386538124021D-21, &
&   -2.524209007252315D-20,   2.732681106966120D-18,  -9.704230201140349D-17, &
&    4.060360920453015D-15,  -1.655627740249943D-13,   6.342406751814764D-12, &
&   -2.389456343993051D-10,   8.589448784171272D-09,  -2.948401898614706D-07, &
&    9.401797533577622D-06,  -2.653425329288168D-04,   5.587959497082963D-03, &
&   -5.380378535210825D-21,  -3.572153376390595D-19,  -1.011815806898841D-17, &
&   -1.588568615040225D-16,  -4.991610691157916D-16,   5.461457350409803D-14, &
&    1.952702217479020D-12,   3.833399252712958D-11,   3.694165988282010D-10, &
&   -5.516447693285003D-09,  -3.785131214428508D-07,  -1.138798830966443D-05, &
&   -2.503235092259544D-04,  -4.259586566144781D-03,   9.503282141790459D-01, &
&    4.627006138098701D-20,   9.261212420094751D-20,  -9.865885307623393D-18, &
&   -1.761374364378697D-16,   1.869697140625704D-15,   1.044067268196230D-13, &
&    6.386210057644204D-13,  -3.661754058829781D-11,  -7.463984830653488D-10, &
&    8.339195866927707D-09,   5.138234521039968D-07,   2.599124087249693D-06, &
&   -3.451849704410216D-04,  -1.297598939010431D-02,   7.831384498287969D-01, &
&    1.037887411912523D-20,  -9.846809536923564D-20,  -3.043538380782076D-18, &
&    3.944068455468765D-17,   1.143780682202608D-15,  -2.245547836291884D-14, &
&   -3.143383763029009D-13,   1.845859606495696D-11,   1.162472859106851D-10, &
&   -1.323392262732770D-08,  -2.630948445225714D-08,   1.064801531618149D-05, &
&   -2.928496375241291D-05,  -1.569200374103491D-02,   5.811877107316329D-01, &
&   -2.050795978737710D-22,  -2.138467440368054D-20,   3.726351207297059D-20, &
&   -8.879729311263875D-18,  -1.163651111004256D-16,   1.276702413382234D-14, &
&   -7.118856180073960D-15,  -7.005822275304030D-12,   1.819531679615771D-10, &
&    1.673922718077321D-09,  -2.226920664171842D-07,   3.664438735997394D-06, &
&    1.805039249551792D-04,  -1.344446242082972D-02,   3.939496068857450D-01, &
&    5.311522230646309D-22,  -5.327700933178275D-21,  -3.452259346813186D-19, &
&    8.380773035969715D-19,   7.325453082376203D-17,  -1.336682311850874D-15, &
&    1.068112554070546D-13,  -5.725222906628835D-13,  -7.665155737128322D-11, &
&    3.605872863465158D-09,  -6.700158667301394D-08,  -2.029031821293091D-06, &
&    2.107009143311869D-04,  -9.273676367910801D-03,   2.390803744157840D-01, &
&    1.881961548897124D-22,  -3.428494459713021D-21,  -8.483143339145010D-20, &
&   -1.455234410738701D-18,   3.816344157240589D-17,   8.817568279784006D-16, &
&   -1.970432927762686D-14,   1.299388159653872D-12,  -3.730782187556931D-11, &
&    2.281895523249884D-10,   3.942797857342919D-08,  -3.069396340733018D-06, &
&    1.444837678711409D-04,  -5.093635816948406D-03,   1.219532700504515D-01, &
&    6.513523932537586D-23,  -9.586020329318044D-22,  -3.956997332266587D-20, &
&   -6.619712215988332D-20,   1.457655439493037D-18,   4.216513801539994D-16, &
&   -5.786833201689744D-17,  -1.006241153281023D-13,   1.209274208013453D-11, &
&   -7.876518702780144D-10,   3.811539850071561D-08,  -1.626845247240447D-06, &
&    6.037924566555399D-05,  -1.909551253148833D-03,   4.385637478061455D-02, &
&    7.362196420455283D-24,  -1.181922864669028D-22,  -3.334495331461038D-21, &
&   -5.093724223436755D-20,   1.973400769236321D-18,  -2.444808944351037D-17, &
&    2.464673372274705D-15,  -9.120352235259697D-14,   3.713031085150321D-12, &
&   -1.507641249517149D-10,   5.725487169747526D-09,  -2.102663765214832D-07, &
&    7.154487919213631D-06,  -2.160530771707002D-04,   4.869229358951054D-03, &
&    2.250696607803528D-19,   1.261018564048105D-18,  -9.925002774595601D-18, &
&   -6.719364051143096D-16,  -1.400309068705354D-14,  -1.179975865077962D-13, &
&    2.004274684648225D-12,   9.464134072691084D-11,   1.755890032384358D-09, &
&    1.178340273251431D-08,  -3.626480203821362D-07,  -1.608890044778392D-05, &
&   -3.740562992971627D-04,  -6.111345492596804D-03,   9.349574341178109D-01, &
&   -2.878391272674306D-20,   6.618400894050557D-19,   1.081104602534194D-17, &
&   -2.366658764609613D-16,  -7.071227224038057D-15,   3.275355802954764D-14, &
&    3.123111557343865D-12,   1.231713910757918D-11,  -1.111324009934655D-09, &
&   -9.945436919574543D-09,   5.104920131965573D-07,   9.024012060682018D-06, &
&   -2.928669562728003D-04,  -1.491931009102650D-02,   7.412170215113481D-01, &
&    7.184087145095961D-21,   1.507458267746191D-19,  -1.739139657267386D-18, &
&   -7.657355120395021D-17,   3.973658506583055D-16,   1.075680979352030D-14, &
&   -4.200506320245417D-13,   7.740939735826593D-12,   3.953369912238736D-10, &
&   -8.279751657993974D-09,  -1.939586694853752D-07,   9.251028048740149D-06, &
&    6.178092081085763D-05,  -1.558816117209273D-02,   5.341304070185025D-01, &
&    3.347778852106075D-21,   2.350597997264737D-20,  -1.976310762303839D-19, &
&   -1.717048210105662D-17,  -5.192323032250130D-16,   4.011754820204803D-15, &
&    2.461989408321378D-13,  -3.672938379255941D-12,   5.896314386553711D-11, &
&    3.734285574359796D-09,  -1.793139152311741D-07,   1.221824763368337D-06, &
&    2.020965992559158D-04,  -1.228564169210477D-02,   3.553221810178187D-01, &
&    1.394427030565185D-21,   1.744944018427335D-20,  -1.759187490959057D-19, &
&   -1.115324681429667D-17,  -1.128079877300744D-16,  -8.951721075707482D-16, &
&    8.944844496523588D-14,   1.747359631943522D-12,  -6.369450498249409D-11, &
&    2.269935085034391D-09,  -2.322714739278844D-08,  -2.550147037076996D-06, &
&    1.897011708372316D-04,  -8.070143409459442D-03,   2.130962623281140D-01, &
&    6.703586032018674D-22,   6.855273885221450D-21,  -5.491760452295134D-20, &
&   -5.153513806285268D-18,  -7.335924633934203D-17,   6.795585639558140D-16, &
&    8.931376066967890D-15,   1.177415137830833D-12,  -1.256767371802584D-11, &
&   -2.168838516946361D-10,   3.896193901643863D-08,  -2.592392113041756D-06, &
&    1.190109011401996D-04,  -4.305304322807357D-03,   1.078930674599536D-01, &
&    2.214822196631491D-22,   2.409020683144020D-21,  -2.325396542890121D-20, &
&   -1.582227349960874D-18,  -2.719999937493306D-17,   1.673041987935083D-16, &
&    9.846048352604139D-15,   2.911348367213815D-14,   1.090944632160197D-11, &
&   -5.847922922142427D-10,   2.785066921985528D-08,  -1.234079162747927D-06, &
&    4.759741536126824D-05,  -1.587385995027285D-03,   3.863011396187241D-02, &
&    2.413352570425705D-23,   2.496251357004611D-22,  -2.053157063707306D-21, &
&   -1.899101750738484D-19,  -2.110704903486928D-18,  -1.431040364346576D-17, &
&    2.218483556972590D-15,  -3.568829214977333D-14,   2.388675139770824D-12, &
&   -9.759282765205871D-11,   3.892576499439497D-09,  -1.533503380621392D-07, &
&    5.534655342362498D-06,  -1.782410584641637D-04,   4.280212978456824D-03, &
&   -2.786607117680183D-19,   5.970393117987956D-18,   1.604868762544322D-16, &
&    1.325462730199077D-15,  -2.027986998508960D-14,  -7.843731174006160D-13, &
&   -9.522521704840818D-12,   4.198937301152112D-11,   3.668296556414823D-09, &
&    6.201876573941447D-08,   1.457021989053991D-07,  -1.814804626038820D-05, &
&   -5.326147699876739D-04,  -8.821409368001511D-03,   9.127974764151439D-01, &
&   -8.494564138971798D-21,  -4.323514713277342D-19,   1.379160267063007D-17, &
&    3.538470552368642D-16,  -5.414700160002617D-15,  -2.058722207414685D-13, &
&    6.778117777488720D-13,   7.138099183019026D-11,  -1.288948884110338D-10, &
&   -2.305422076311283D-08,   2.404220160611125D-07,   1.373208051120884D-05, &
&   -1.879929174190021D-04,  -1.638326066611701D-02,   6.941051075343606D-01, &
&    4.331624286334216D-22,   1.910275040047216D-19,   5.402080839522783D-18, &
&   -1.346522504884873D-17,  -1.800680865813672D-15,  -1.545493225121325D-14, &
&   -3.254526171523148D-13,   2.658825040736203D-13,   4.740732606441837D-10, &
&   -2.290119766810283D-10,  -2.595192890550225D-07,   6.408733274284994D-06, &
&    1.328430114176645D-04,  -1.499138951037518D-02,   4.881543095100750D-01, &
&    2.978150031915096D-21,   9.520291989425930D-20,   2.112330683466441D-18, &
&    9.253630012863161D-18,  -8.777990737426215D-16,  -1.898477621329515D-14, &
&    7.133843188250830D-14,   1.400708224584181D-12,   4.220870629123572D-11, &
&    4.476997449350105D-09,  -1.173838106100504D-07,  -5.689884204869179D-07, &
&    2.044763940775196D-04,  -1.105785468905242D-02,   3.203035342196133D-01, &
&    1.389933516980218D-21,   5.053510081211860D-20,   1.127907424947616D-18, &
&    2.221713354138992D-18,  -3.885086639381551D-16,  -9.453316304998713D-15, &
&   -2.991906303918998D-14,   2.934758655774594D-12,  -9.695866658477840D-12, &
&    1.569009489963705D-09,   4.328551850107164D-09,  -2.652899600208393D-06, &
&    1.660417015390890D-04,  -7.002462030004693D-03,   1.905229168112923D-01, &
&    6.584581687770410D-22,   2.311588603800937D-20,   5.193820077463630D-19, &
&    1.342051126280014D-18,  -1.927408868448469D-16,  -3.815536084023212D-15, &
&   -2.458592568158722D-14,   1.237581454801953D-12,   1.412071137612262D-11, &
&   -2.063783266755090D-10,   3.518114591845908D-08,  -2.147678733912489D-06, &
&    9.771570529309797D-05,  -3.657125588337015D-03,   9.598135470891247D-02, &
&    2.183475181233273D-22,   7.896436818872477D-21,   1.740271205544746D-19, &
&    4.990140056298156D-19,  -6.447397845415514D-17,  -1.368546386365711D-15, &
&   -3.593714695624802D-15,   1.887614790339517D-13,   1.373733884294412D-11, &
&   -3.685377128840537D-10,   2.063468347511175D-08,  -9.463934714807595D-07, &
&    3.785035301586512D-05,  -1.332334378582418D-03,   3.426513445998403D-02, &
&    2.358900275657624D-23,   8.488718680451372D-22,   1.897856513770812D-20, &
&    4.552933244021939D-20,  -6.561039489354766D-18,  -1.626107798122596D-16, &
&    1.582661324696762D-16,   1.032061184361201D-15,   2.108456857105866D-12, &
&   -5.832749433303863D-11,   2.729108088134437D-09,  -1.142055165463901D-07, &
&    4.341114814811898D-06,  -1.487893743713744D-04,   3.791454503066058D-03, &
&   -2.183057252585703D-18,  -3.480267021482258D-17,  -1.983096623871388D-16, &
&    5.664651168511025D-15,   1.266894012974611D-13,   3.662191914467590D-13, &
&   -2.548816334262193D-11,  -4.350432534145352D-10,   2.998579671703926D-10, &
&    1.131024425770302D-07,   1.531316026769754D-06,  -8.898734081857710D-06, &
&   -6.669229351175048D-04,  -1.246089482784768D-02,   8.810792778041338D-01, &
&   -1.726952335541372D-19,  -6.625230478700642D-19,   3.997154306069043D-18, &
&    6.351882660613486D-16,   1.174533274598609D-14,  -1.333145049993076D-13, &
&   -5.070003101139366D-12,   1.499448736352975D-11,   1.029309177830049D-09, &
&   -1.315176742913549D-08,  -5.833220282871700D-08,   1.467065787406643D-05, &
&   -5.744193486890690D-05,  -1.712364815730287D-02,   6.436480897510594D-01, &
&   -9.844893836768642D-20,  -4.428557476461288D-19,   7.981552087990054D-18, &
&    2.820086785100320D-16,   2.278933830986446D-15,  -3.357076911781153D-14, &
&   -1.257280194910216D-12,  -1.747123428217078D-11,   3.348005595749693D-10, &
&    7.600905584372972D-09,  -2.012869860777084D-07,   3.524808384622118D-06, &
&    1.770147093983915D-04,  -1.404873087800306D-02,   4.445280308036513D-01, &
&   -5.054672911327271D-20,  -2.264223697870763D-19,   3.680357809328068D-18, &
&    1.420495696147865D-16,   1.409004161595427D-15,  -2.245153666914956D-14, &
&   -6.392103663586194D-13,  -5.100798682256775D-12,   3.445806473961508D-11, &
&    5.369481435616296D-09,  -4.350319157654076D-08,  -1.548301920605719D-06, &
&    1.942837151733183D-04,  -9.857154625876130D-03,   2.889465087124827D-01, &
&   -2.583992496953924D-20,  -1.216010347061772D-19,   1.859510181002987D-18, &
&    7.166130590902541D-17,   7.298050304903161D-16,  -1.032671242257521D-14, &
&   -3.708829671775135D-13,  -1.761735819378430D-12,   1.755631597262592D-11, &
&    1.786800473177763D-09,   2.881556385794578D-08,  -2.457741634559665D-06, &
&    1.428247129477743D-04,  -6.076737491963348D-03,   1.709390085737297D-01, &
&   -1.182829672380644D-20,  -5.730017145408387D-20,   8.287102438760116D-19, &
&    3.302523905926471D-17,   3.305348370187576D-16,  -4.487741282089299D-15, &
&   -1.713207309732761D-13,  -1.046826745955162D-12,   2.257479968490400D-11, &
&    1.953390338603171D-10,   3.487855102436505D-08,  -1.733559982503549D-06, &
&    8.025327312109579D-05,  -3.125076489731882D-03,   8.583424424196133D-02, &
&   -3.990544037488488D-21,  -1.964174621473526D-20,   2.749303588257573D-19, &
&    1.114115104917224D-17,   1.131291835772458D-16,  -1.559984000504289D-15, &
&   -5.489149088836173D-14,  -4.925696653633449D-13,   1.279977571762399D-11, &
&   -1.083985586278997D-10,   1.706843287799575D-08,  -7.241405545123038D-07, &
&    3.036503480991387D-05,  -1.128684759510982D-03,   3.058482410555988D-02, &
&   -4.298601675202272D-22,  -2.135088155054393D-21,   2.949239808665324D-20, &
&    1.196468221939631D-18,   1.240776573584371D-17,  -1.745715394254466D-16, &
&   -5.650227058698761D-15,  -6.312704658704440D-14,   1.710876802479598D-12, &
&   -2.194646781843581D-11,   2.134833978601964D-09,  -8.557358047369487D-08, &
&    3.447444247356807D-06,  -1.255520420424671D-04,   3.381281285304555D-03, &
&    9.849568322137540D-18,   8.089391547210078D-17,  -4.640313355170321D-16, &
&   -2.020925513702805D-14,  -6.654263354531697D-14,   3.645552250316868D-12, &
&    4.094145341714912D-11,  -4.535100260466175D-10,  -1.191995028328315D-08, &
&    1.046206783241006D-08,   2.746189720389486D-06,   1.829828395034768D-05, &
&   -6.360877341363873D-04,  -1.649368886874095D-02,   8.376046570288962D-01, &
&    7.205228255752568D-19,  -2.526328480859393D-18,  -1.198386506150091D-16, &
&   -9.526758655988786D-16,   1.942436808284619D-14,   4.559990304371419D-13, &
&   -1.410864202015745D-12,  -9.586923767338595D-11,   3.295171023938468D-11, &
&    1.126352578269627D-10,  -1.330586432099617D-07,   1.331195985255690D-05, &
&    6.911036739150498D-05,  -1.708233494970331D-02,   5.921491029174696D-01, &
&    2.936766358516083D-19,  -1.119805287887633D-18,  -5.058271250413376D-17, &
&   -3.057113135443517D-16,   8.010359784688311D-15,   1.659323531701826D-13, &
&    5.789628230635444D-14,  -4.310868419411646D-11,  -3.522524410587141D-10, &
&    8.323508952255722D-09,  -6.617442682612587D-08,   1.906468278505365D-06, &
&    2.002110518097888D-04,  -1.290975777527189D-02,   4.040558802926979D-01, &
&    1.456623048525372D-19,  -5.068617669765184D-19,  -2.492966617943948D-17, &
&   -1.604152185497224D-16,   4.109647903831322D-15,   8.379044760862280D-14, &
&   -3.513163804087507D-14,  -1.917612897315906D-11,  -2.437862263692336D-10, &
&    3.967248390115945D-09,   3.288370259063633D-08,  -1.592480285044121D-06, &
&    1.794511865867722D-04,  -8.735768115327772D-03,   2.610795845834976D-01, &
&    7.392493978613139D-20,  -2.367277164767215D-19,  -1.248783493559977D-17, &
&   -8.311223648327652D-17,   2.051235959813015D-15,   4.347336655865286D-14, &
&   -3.359678649691426D-14,  -9.647884033701113D-12,  -1.154078994018194D-10, &
&    1.173992076817253D-09,   5.407041938729689D-08,  -1.952062412762805D-06, &
&    1.227477697439120D-04,  -5.282302802255012D-03,   1.539306341089195D-01, &
&    3.379521398874754D-20,  -1.014420038693499D-19,  -5.656753960186582D-18, &
&   -3.843206592240106D-17,   9.253737401627262D-16,   1.995553909670234D-14, &
&   -1.217535582773000D-14,  -4.627833221555830D-12,  -4.324099994085124D-11, &
&    1.309903330529306D-10,   3.883400995697664D-08,  -1.290695811369328D-06, &
&    6.660578800789635D-05,  -2.686492577371209D-03,   7.713737372226800D-02, &
&    1.139554720283679D-20,  -3.278458682025184D-20,  -1.895475999750294D-18, &
&   -1.307698029379579D-17,   3.103873692986790D-16,   6.697342443138902D-15, &
&   -2.043097463897695D-15,  -1.641794780113716D-12,  -1.168029278554137D-11, &
&   -5.913317535949249D-11,   1.637175519767433D-08,  -5.243598584109500D-07, &
&    2.475203857595053D-05,  -9.642317304142241D-04,   2.745386741924897D-02, &
&    1.227848474434162D-21,  -3.460164342880676D-21,  -2.035556531565324D-19, &
&   -1.416489857598449D-18,   3.340146708237081D-17,   7.183073267700446D-16, &
&   -6.978582996297139D-17,  -1.821567584351658D-13,  -1.082935851699913D-12, &
&   -1.222231562104285D-11,   1.942379066949206D-09,  -6.126880223942553D-08, &
&    2.788270040849606D-06,  -1.069541230648116D-04,   3.033510328909463D-03, &
&   -1.686179078305957D-17,  -1.152847110882628D-16,   1.514687636553989D-15, &
&    2.491970424944607D-14,  -2.324593642629302D-13,  -5.025584714477671D-12, &
&    3.713091642853544D-11,   9.990193278835469D-10,  -6.170372103754529D-09, &
&   -2.014855575673812D-07,   1.184332377393471D-06,   4.521247624574969D-05, &
&   -3.360003384719747D-04,  -1.953412443937315D-02,   7.831084894438908D-01, &
&   -1.794119394489081D-18,   1.224412039376715D-17,   2.547701275003939D-16, &
&   -1.174675767310965D-15,  -5.500773217136179D-14,  -1.100252462387783D-14, &
&    1.016677432930780D-11,   3.346438090247245D-11,  -1.157354862290881D-09, &
&   -1.423091277835754D-08,  -2.096597949620501D-07,   1.148366467083579D-05, &
&    1.813253998953996D-04,  -1.632301053505978D-02,   5.418725788991559D-01, &
&   -5.883202866613926D-19,   5.259700598475617D-18,   9.402616356450782D-17, &
&   -5.965324382333514D-16,  -2.194465859873259D-14,   3.756188202452793D-16, &
&    4.533469248337959D-12,   2.036446669126294D-11,  -7.985400560651306D-10, &
&   -4.084135035500874D-09,  -2.336558721150419D-08,   1.561558839708900D-06, &
&    2.154113033448061D-04,  -1.166151412614165D-02,   3.671762965273525D-01, &
&   -2.700347722343630D-19,   2.531784734437474D-18,   4.493096120861665D-17, &
&   -3.046238011327914D-16,  -1.084348694749548D-14,   3.815854837706124D-15, &
&    2.257611788827860D-12,   1.154103328552464D-11,  -4.299434895459227D-10, &
&   -3.088607816296737D-09,   4.415808955854787D-08,  -1.021383671594028D-06, &
&    1.675785060942966D-04,  -7.697348100144767D-03,   2.364477535315517D-01, &
&   -1.314839667871605D-19,   1.236439396122394D-18,   2.216409058934584D-17, &
&   -1.522569599077070D-16,  -5.447882551036627D-15,   2.634608569982278D-15, &
&    1.145105331197654D-12,   5.765059706877591D-12,  -2.105389588874922D-10, &
&   -2.257723797575478D-09,   4.833707058931151D-08,  -1.284631131619885D-06, &
&    1.082297383398518D-04,  -4.592421992529173D-03,   1.391403104314126D-01, &
&   -5.877673138994985D-20,   5.488751331301737D-19,   9.949379510056725D-18, &
&   -6.840129754099371D-17,  -2.467511241935690D-15,   1.237751897668153D-15, &
&    5.255340808301719D-13,   2.486192326993564D-12,  -9.050825478503159D-11, &
&   -1.302684720962158D-09,   3.122565078703007D-08,  -8.481355443993357D-07, &
&    5.704730807450718D-05,  -2.317545062872377D-03,   6.964563539472103D-02, &
&   -1.958108548651919D-20,   1.815578612742719D-19,   3.318904137783352D-18, &
&   -2.278118359265735D-17,  -8.263567901286617D-16,   3.980543055587431D-16, &
&    1.780282199642527D-13,   7.915484081563247D-13,  -2.890655553742806D-11, &
&   -5.030356109853639D-10,   1.258187311710809D-08,  -3.437411976789921D-07, &
&    2.087889471624677D-05,  -8.281580141774422D-04,   2.477108262970050D-02, &
&   -2.098441635466003D-21,   1.937821595109027D-20,   3.558051136301491D-19, &
&   -2.439419348025226D-18,  -8.871629930165329D-17,   4.112176880006163D-17, &
&    1.923617733595750D-14,   8.243188984622049D-14,  -3.019921684148578D-12, &
&   -5.769466170363345D-11,   1.465743984503322D-09,  -4.011207058394604D-08, &
&    2.336256616061993D-06,  -9.167639563054643D-05,   2.736241322560108D-03, &
&    1.280224598718097D-17,   9.264917105702157D-17,  -1.695222026404941D-15, &
&   -1.119869711147988D-14,   3.586980030570114D-13,   4.432654956482099D-13, &
&   -6.988273086031724D-11,   2.691881145099225D-10,   1.203934188270952D-08, &
&   -1.234367738490704D-07,  -1.685115668786966D-06,   4.095839740210311D-05, &
&    7.839012323479006D-05,  -2.028665630690837D-02,   7.227476424684432D-01, &
&    2.846877802780642D-18,  -1.716741709235584D-17,  -2.643657615025152D-16, &
&    3.514012327911024D-15,   4.198258797355419D-14,  -6.818140124676968D-13, &
&   -6.569656902450679D-12,   1.184179600232050D-10,   1.205489430187245D-09, &
&   -1.675269489265334D-08,  -4.987862907634128D-07,   7.280050043583623D-06, &
&    2.684692257469605D-04,  -1.495475639106398D-02,   4.948243869378353D-01, &
&    8.775655953469685D-19,  -7.950659021157832D-18,  -8.690896414886121D-17, &
&    1.632859967086113D-15,   1.509550890659530D-14,  -3.243798728034416D-13, &
&   -2.623942608562255D-12,   6.339755991963847D-11,   4.060062484100347D-10, &
&   -9.106485939593033D-09,  -1.509085147885513D-07,   5.958957376610040D-07, &
&    2.263204257980610D-04,  -1.033204726903252D-02,   3.341692237176374D-01, &
&    3.722144885123621D-19,  -3.954133540774427D-18,  -3.827958903298895D-17, &
&    8.290898170208199D-16,   6.908451071753618D-15,  -1.670782276941650D-13, &
&   -1.273419464009538D-12,   3.387635355698135D-11,   2.068670987395918D-10, &
&   -5.869803280075304D-09,  -3.810084982310923D-08,  -9.409091856991946D-07, &
&    1.595162290852448D-04,  -6.716466698718711D-03,   2.148388907316600D-01, &
&    1.710539295896628D-19,  -1.963319246037569D-18,  -1.799417932293397D-17, &
&    4.182547806856852D-16,   3.316914243818527D-15,  -8.534489986074235D-14, &
&   -6.249271284601243D-13,   1.740623428709637D-11,   1.128192501546704D-10, &
&   -3.539728640820812D-09,  -2.790929408274280D-09,  -9.908692333035097D-07, &
&    9.846419501465441D-05,  -3.973681051957802D-03,   1.263056600888859D-01, &
&    7.358086702943332D-20,  -8.798271679633330D-19,  -7.845517035407014D-18, &
&    1.894288467467797D-16,   1.465290416512942D-15,  -3.903581213180865D-14, &
&   -2.775326514063461D-13,   7.928724444173576D-12,   5.513797158006311D-11, &
&   -1.808813276088065D-09,   4.444023114693536D-09,  -6.259405577760494D-07, &
&    5.066133403721577D-05,  -1.995426603591613D-03,   6.318568182167788D-02, &
&    2.394978977975490D-20,  -2.926151372509229D-19,  -2.573185942486465D-18, &
&    6.340527669905806D-17,   4.844120360625550D-16,  -1.315394300665957D-14, &
&   -9.169165602264624D-14,   2.656691398242939D-12,   1.948083442372713D-11, &
&   -6.521149095633472D-10,   2.773033037882568D-09,  -2.491755626805002D-07, &
&    1.830115454775994D-05,  -7.110456830517569D-04,   2.246611630460292D-02, &
&    2.538720419165365D-21,  -3.131059239462914D-20,  -2.737066805304451D-19, &
&    6.804992983749944D-18,   5.172113326811574D-17,  -1.416528021121836D-15, &
&   -9.776546339371254D-15,   2.850853771706726D-13,   2.148857796655956D-12, &
&   -7.250857740604291D-11,   3.668478224428524D-10,  -2.887260711083699D-08, &
&    2.035940665397189D-06,  -7.861060943495402D-05,   2.481258225081401D-03, &
&   -5.877917042090693D-18,  -3.011350469551674D-17,   9.623068427869508D-16, &
&   -3.144045570160434D-15,  -1.599253931070330D-13,   2.372750440001138D-12, &
&    7.074695809320901D-12,  -5.754609435973029D-10,   5.249668583294361D-09, &
&    5.930510579111492D-08,  -1.996578832432048D-06,   1.604502181726397D-05, &
&    3.373903143396237D-04,  -1.892463211983596D-02,   6.635415059905429D-01, &
&   -1.925341105206030D-18,   1.213388790388443D-17,   1.144349852304218D-16, &
&   -3.153616502953763D-15,   1.766575994427582D-15,   5.947146394105228D-13, &
&   -4.347542992016011D-12,  -8.855547678876612D-11,   1.394570243981298D-09, &
&    1.366560044101896D-08,  -5.255707176662334D-07,   6.559257167299544D-07, &
&    3.044282042363019D-04,  -1.320581684234940D-02,   4.525295137563256D-01, &
&   -6.194067974022640D-19,   6.063009564369511D-18,   2.713436405087458D-17, &
&   -1.423476816065679D-15,   4.499512422197328D-15,   2.569877632839961D-13, &
&   -2.609627556301848D-12,  -3.407274482949333D-11,   7.047553986044490D-10, &
&    4.188185702513943D-09,  -1.944589996703555D-07,  -1.685921993927736D-06, &
&    2.218192029016198D-04,  -8.977167555330302D-03,   3.052120306157417D-01, &
&   -2.554174731674149D-19,   3.109278431132139D-18,   8.466339435717913D-18, &
&   -7.119822094314548D-16,   3.056475275025268D-15,   1.274569221811168D-13, &
&   -1.462172021001504D-12,  -1.650830090219138D-11,   3.939225247975171D-10, &
&    1.239626173271558D-09,  -7.705042537698855D-08,  -1.743716711183444D-06, &
&    1.477935688254436D-04,  -5.790821900064559D-03,   1.960954333980983D-01, &
&   -1.132466797947690D-19,   1.568125473876575D-18,   2.892536175783882D-18, &
&   -3.561105617023150D-16,   1.752264683344947D-15,   6.354720688757499D-14, &
&   -7.749866827592749D-13,  -8.262776345588764D-12,   2.137691120022107D-10, &
&    2.663281870405452D-10,  -2.963226551214840D-08,  -1.245176030509664D-06, &
&    8.864770062434324D-05,  -3.411146144495493D-03,   1.152430697901414D-01, &
&   -4.728873417337595D-20,   7.088412840431108D-19,   9.592156871337906D-19, &
&   -1.604965319398362D-16,   8.495877857065183D-16,   2.858940625549921D-14, &
&   -3.607037083133863D-13,  -3.756571597308011D-12,   1.018904455342442D-10, &
&   -1.062727834285478D-12,  -1.019410260408888D-08,  -6.887754878107337D-07, &
&    4.487877911502677D-05,  -1.708497528524231D-03,   5.763842910770283D-02, &
&   -1.508346810180590D-20,   2.368705547202509D-19,   2.559785210988705D-19, &
&   -5.357779445702791D-17,   2.951139368203145D-16,   9.533496669187663D-15, &
&   -1.225495333847455D-13,  -1.264513106455853D-12,   3.522333734458219D-11, &
&   -2.740460299690260D-11,  -2.682277573869547D-09,  -2.584104405556314D-07, &
&    1.606676484875590D-05,  -6.078914062503814D-04,   2.049104724725302D-02, &
&   -1.582737977856317D-21,   2.539972366650011D-20,   2.432379099798852D-20, &
&   -5.743458027281853D-18,   3.220368927750890D-17,   1.021431169793093D-15, &
&   -1.324067394875346D-14,  -1.361954982894971D-13,   3.839876815768429D-12, &
&   -4.388349519595692D-12,  -2.484648794455954D-10,  -2.922802790959273D-08, &
&    1.780095474969994D-06,  -6.715992526334575D-05,   2.262984499510664D-03, &
&    2.149654049971728D-18,  -2.494848086072464D-18,  -2.375238770167358D-16, &
&    4.289634530480517D-15,  -1.599037102885006D-14,  -7.764555357719617D-13, &
&    1.717940289460381D-11,  -1.093381548779067D-10,  -2.262639568113662D-09, &
&    7.038976646123275D-08,  -8.535962444924948D-07,  -1.173459486146641D-06, &
&    3.937181434499008D-04,  -1.665373704119998D-02,   6.100926783412340D-01, &
&    5.285372497026502D-19,  -5.564763724167837D-18,   9.880872379320970D-18, &
&    1.120382925725999D-15,  -1.742875815701094D-14,  -2.791787284271331D-14, &
&    4.378513778681120D-12,  -5.020893483979245D-11,  -4.371112042493814D-10, &
&    2.082357486840275D-08,  -2.239883564798051D-07,  -3.944089168809065D-06, &
&    2.868386650340965D-04,  -1.141122566182676D-02,   4.156311823452589D-01, &
&    1.532440979571869D-19,  -2.675973616042319D-18,   1.505040100872798D-17, &
&    4.368278722398073D-16,  -9.153467222596864D-15,   1.444551729279349D-14, &
&    1.930922471166553D-12,  -2.716292151423763D-11,  -1.360953987683802D-10, &
&    8.988202509573133D-09,  -7.581288488769010D-08,  -3.378466938097072D-06, &
&    1.979252527171930D-04,  -7.710254362084452D-03,   2.802170746534476D-01, &
&    5.440745777808542D-20,  -1.358475034109307D-18,   1.008459352481189D-17, &
&    2.009444291516970D-16,  -4.920668611947503D-15,   1.400364302731028D-14, &
&    9.755875752574270D-13,  -1.524910256400724D-11,  -4.630409383079973D-11, &
&    4.281111650004280D-09,  -2.525090597643459D-08,  -2.402822817573029D-06, &
&    1.286488553711705D-04,  -4.958488020477978D-03,   1.800003336549112D-01, &
&    2.066860475040668D-20,  -6.814314502306714D-19,   5.770403411249311D-18, &
&    9.511974832579884D-17,  -2.560698202467302D-15,   8.994670798730262D-15, &
&    4.936075309091622D-13,  -8.210507776445941D-12,  -1.490007786829277D-11, &
&    2.031559904683350D-09,  -6.997749888694675D-09,  -1.491330356232961D-06, &
&    7.611979167231098D-05,  -2.915712283202290D-03,   1.057716393907594D-01, &
&    7.521613114254149D-21,  -3.069844661825205D-19,   2.795972817063921D-18, &
&    4.133537055980448D-17,  -1.181006638926817D-15,   4.600771468378854D-15, &
&    2.244815578256079D-13,  -3.879180565247789D-12,  -4.012798588443936D-12, &
&    8.735702094017526D-10,  -1.149483425709529D-09,  -7.699242407127696D-07, &
&    3.822863533156865D-05,  -1.458798352670117D-03,   5.289748689728447D-02, &
&    2.163003951187733D-21,  -1.023728317593214D-19,   9.708285480204439D-19, &
&    1.349286921805811D-17,  -3.994160825181371D-16,   1.642169738149431D-15, &
&    7.538787077041479D-14,  -1.332207345790255D-12,  -7.510052605033303D-13, &
&    2.816393604368201D-10,   7.385750482165851D-11,  -2.786885600448960D-07, &
&    1.362345411008454D-05,  -5.187253370774015D-04,   1.880479521075375D-02, &
&    2.146259413774646D-22,  -1.096673184223391D-20,   1.059173528474990D-19, &
&    1.431005367625004D-18,  -4.307117509603028D-17,   1.813140160691249D-16, &
&    8.105482099968491D-15,  -1.447322467051240D-13,  -4.935596924803470D-14, &
&    2.963934837387869D-11,   3.273589198219783D-11,  -3.103208314263653D-08, &
&    1.506225534623782D-06,  -5.729238565956757D-05,   2.076717669792136D-03, &
&   -4.065502315226490D-19,   3.809200933515514D-18,  -2.175274949506149D-17, &
&   -6.131007484786848D-16,   2.094970607334862D-14,  -2.944398410166565D-13, &
&    5.650802830200787D-13,   7.315067045025967D-11,  -1.927938037670861D-09, &
&    2.712991135875971D-08,  -1.329766205713680D-07,  -6.427635363013985D-06, &
&    3.530495582795595D-04,  -1.439039513225479D-02,   5.635894190578188D-01, &
&   -7.987807008375252D-21,   1.258696659447763D-18,  -2.320096366023186D-17, &
&    8.512082902631102D-17,   4.863436269343985D-15,  -1.172123303318956D-13, &
&    8.881272623733713D-13,   1.667624764147116D-11,  -6.296660701173610D-10, &
&    9.095643324720597D-09,   3.995306055654340D-09,  -5.081724212724919D-06, &
&    2.441647745953215D-04,  -9.813262551110477D-03,   3.838590788940300D-01, &
&    2.109465735661702D-20,   4.992211277675841D-19,  -1.249041041491464D-17, &
&    8.503205125140572D-17,   1.886582265845509D-15,  -5.858107285018487D-14, &
&    5.591533613859147D-13,   6.239854042733884D-12,  -2.915495554820826D-10, &
&    4.066210708708056D-09,   2.529097715641460D-08,  -3.604522817186374D-06, &
&    1.655863501752547D-04,  -6.618772927348973D-03,   2.587723173993433D-01, &
&    1.730193181277877D-20,   2.266947540964552D-19,  -6.771117946820887D-18, &
&    5.564063413719133D-17,   8.627139972833064D-16,  -3.128215401156977D-14, &
&    3.318578326993338D-13,   2.700270432066917D-12,  -1.475117855789004D-10, &
&    1.957651741464521D-09,   2.367263518577152D-08,  -2.375685951094368D-06, &
&    1.067015292945996D-04,  -4.252592608633992D-03,   1.662167673819385D-01, &
&    1.068733220040223D-20,   1.054343588320680D-19,  -3.534965462034238D-18, &
&    3.187000886972005D-17,   4.057534656703630D-16,  -1.629169978554168D-14, &
&    1.834531927067194D-13,   1.195014626701005D-12,  -7.371816631664701D-11, &
&    9.298944698531104D-10,   1.646621528084620D-08,  -1.417072393628551D-06, &
&    6.281860391038729D-05,  -2.499247317533801D-03,   9.766921606267718D-02, &
&    5.381301486679844D-21,   4.511395193910197D-20,  -1.632429402074001D-18, &
&    1.550398699080975D-17,   1.753561647729782D-16,  -7.529374442305252D-15, &
&    8.788098472582221D-14,   4.883659621213894D-13,  -3.304425546532138D-11, &
&    3.986807600197924D-10,   9.014401365855610D-09,  -7.151824560407834D-07, &
&    3.145308540567817D-05,  -1.250006492004726D-03,   4.884447086505972D-02, &
&    1.906739599355501D-21,   1.456516032137879D-20,  -5.523646048811774D-19, &
&    5.400904896500080D-18,   5.701845233381445D-17,  -2.550927823701568D-15, &
&    3.040012251040383D-14,   1.521814689753540D-13,  -1.097016352960117D-11, &
&    1.280695390287039D-10,   3.366284957277721D-09,  -2.555982460406016D-07, &
&    1.118914453558677D-05,  -4.443937087023125D-04,   1.736377716130353D-02, &
&    2.098892959936187D-22,   1.536022442738640D-21,  -5.957464275807777D-20, &
&    5.902481687688922D-19,   6.035150594549117D-18,  -2.753441263656267D-16, &
&    3.313134528958100D-15,   1.574211616882297D-14,  -1.172140751161897D-12, &
&    1.344667079322335D-11,   3.800421552346004D-10,  -2.829674417172757D-08, &
&    1.236077440704262D-06,  -4.907802468817715D-05,   1.917568232338026D-03, &
&   -2.765262680034907D-20,  -3.352945745900846D-19,   1.510386608181053D-17, &
&   -2.938521546689366D-16,   2.779155797031840D-15,   2.760360204837338D-14, &
&   -1.770438484838978D-12,   4.169780480910252D-11,  -6.347154757769984D-10, &
&    5.162685133225633D-09,   7.974836259385070D-08,  -6.420921791909959D-06, &
&    2.933698492681588D-04,  -1.245145924543299D-02,   5.234167085400867D-01, &
&   -3.261590914541238D-20,   9.968429008525066D-20,   3.468829761951857D-18, &
&   -1.158404416729732D-16,   1.750061533098351D-15,  -4.139518719129012D-15, &
&   -5.050242387519562D-13,   1.503062928664659D-11,  -2.404156989486801D-10, &
&    1.356424569079680D-09,   7.337855160919234D-08,  -4.501718595540499D-06, &
&    2.004312361096889D-04,  -8.482188593811177D-03,   3.564816827756224D-01, &
&   -1.842608560057968D-20,   8.749129863323192D-20,   1.206504701132367D-18, &
&   -5.653048866523670D-17,   9.877734609988669D-16,  -4.878977903268796D-15, &
&   -2.183221311402649D-13,   7.320783272315215D-12,  -1.172416059560927D-10, &
&    3.722846817874150D-10,   5.451560332283400D-08,  -3.070254970204728D-06, &
&    1.352942528675055D-04,  -5.718585211199083D-03,   2.403117940543442D-01, &
&   -1.021329206579182D-20,   5.649669239061875D-20,   4.891355498165493D-19, &
&   -2.961876730936630D-17,   5.584594969117983D-16,  -3.427761532599305D-15, &
&   -1.061871062726909D-13,   3.835957935155243D-12,  -6.077632796195808D-11, &
&    5.737099746484308D-11,   3.675288902020403D-08,  -1.984564627078199D-06, &
&    8.696639987347683D-05,  -3.673374600298583D-03,   1.543574529804474D-01, &
&   -5.395815501296298D-21,   3.228880673380465D-20,   2.056018755936942D-19, &
&   -1.521310639591934D-17,   3.002562656613619D-16,  -2.047973392384322D-15, &
&   -5.181016425544063D-14,   1.967214360079490D-12,  -3.075612385259031D-11, &
&   -2.950922172132513D-11,   2.220880132866836D-08,  -1.170580577159106D-06, &
&    5.112433437638552D-05,  -2.158540731478731D-03,   9.070009010228879D-02, &
&   -2.508745417241210D-21,   1.570615252489859D-20,   8.088032780736233D-20, &
&   -6.963728214425924D-18,   1.414018739492148D-16,  -1.022888168975448D-15, &
&   -2.288688110038708D-14,   8.984609275249354D-13,  -1.387842314409079D-11, &
&   -3.416220560436263D-11,   1.129644280849113D-08,  -5.867962236053317D-07, &
&    2.557447215794750D-05,  -1.079507436744512D-03,   4.535902369682442D-02, &
&   -8.520950197852239D-22,   5.472844010653768D-21,   2.457353704606530D-20, &
&   -2.345075155238630D-18,   4.842445571606342D-17,  -3.619571610534121D-16, &
&   -7.534336500069063D-15,   3.019592290995334D-13,  -4.623060021684850D-12, &
&   -1.618535486582173D-11,   4.055534076400852D-09,  -2.088928041557781D-07, &
&    9.093006797255908D-06,  -3.837593901707564D-04,   1.612469346223049D-02, &
&   -9.205876600469981D-23,   5.982301275148913D-22,   2.509970371776098D-21, &
&   -2.523865403822775D-19,   5.252709984193974D-18,  -3.984922282901081D-17, &
&   -8.019294504838773D-16,   3.246114148667595D-14,  -4.946682194297769D-13, &
&   -1.994880324302626D-12,   4.499196549408880D-10,  -2.308414160941034D-08, &
&    1.004263967687478D-06,  -4.238066716491465D-05,   1.780728090790533D-03, &
&    1.429092399292137D-20,  -1.744934668086893D-19,   2.465888942799113D-18, &
&   -6.268609425611900D-18,  -8.972561177278336D-16,   3.261875383438469D-14, &
&   -7.266622257420286D-13,   1.171004511162830D-11,  -1.196470992583359D-10, &
&   -6.824881062932564D-10,   1.019700640363349D-07,  -5.245764754631296D-06, &
&    2.406900851597421D-04,  -1.085464291895360D-02,   4.885366262411131D-01, &
&    3.229536578083774D-21,  -6.965590477759352D-20,   1.423570343907322D-18, &
&   -1.431279773131441D-17,  -1.630083282403434D-16,   1.106564839305383D-14, &
&   -2.857710457945512D-13,   4.813954677764710D-12,  -4.229975818928300D-11, &
&   -8.618635480138111D-10,   7.267828395167268D-08,  -3.593087092177619D-06, &
&    1.640188119954125D-04,  -7.392955972096444D-03,   3.327235792896451D-01, &
&    1.001625527910684D-21,  -3.368276180761614D-20,   7.913659319699899D-19, &
&   -9.548672906777889D-18,  -4.278568069227801D-17,   5.233070418488521D-15, &
&   -1.449122929353061D-13,   2.460681148396699D-12,  -1.819224233066055D-11, &
&   -6.904907602126236D-10,   4.991799960029789D-08,  -2.428183924208715D-06, &
&    1.105966221697988D-04,  -4.983815645338650D-03,   2.242952251034075D-01, &
&    3.425806198216990D-22,  -1.746678102331783D-20,   4.438823484679032D-19, &
&   -5.803124958470344D-18,  -1.102449211474455D-17,   2.699421041613567D-15, &
&   -7.785304372715106D-14,   1.319685105829082D-12,  -8.151537508164564D-12, &
&   -4.818412512837484D-10,   3.239271156501963D-08,  -1.561848621929579D-06, &
&    7.104889384385607D-05,  -3.201237904028692D-03,   1.440693978058204D-01, &
&    1.155210397510589D-22,  -8.895614663418035D-21,   2.374472228619643D-19, &
&   -3.245294517484932D-18,  -1.865582566411233D-18,   1.372402746099073D-15, &
&   -4.060813776905544D-14,   6.852162924695258D-13,  -3.546440289175481D-12, &
&   -2.967917188592423D-10,   1.915253825394906D-08,  -9.185289606189218D-07, &
&    4.175194141669898D-05,  -1.881049582843550D-03,   8.465475449984543D-02, &
&    3.495881368111977D-23,  -4.046536835390020D-21,   1.114507685061393D-19, &
&   -1.564009095975005D-18,   2.823471544534551D-19,   6.237893559484318D-16, &
&   -1.876136720953150D-14,   3.150868818494303D-13,  -1.389265158437980D-12, &
&   -1.526830785994004D-10,   9.615389858967738D-09,  -4.596047272707549D-07, &
&    2.088129977638998D-05,  -9.407140088815817D-04,   4.233572653287036D-02, &
&    8.119549205033968D-24,  -1.357155480290488D-21,   3.808924412150507D-20, &
&   -5.427092449007996D-19,   3.286663976467821D-19,   2.091130459260989D-16, &
&   -6.351285491585328D-15,   1.062790355355537D-13,  -4.135009168017671D-13, &
&   -5.517234510652005D-11,   3.426035022949956D-09,  -1.634378363724157D-07, &
&    7.423353845574242D-06,  -3.344153571216825D-04,   1.504993404847971D-02, &
&    6.876662574463326D-25,  -1.457703226809601D-22,   4.127577361649066D-21, &
&   -5.922530119130447D-20,   4.733368342444125D-20,   2.245537457951466D-17, &
&   -6.851779565560641D-16,   1.144309068654480D-14,  -4.152957780133350D-14, &
&   -6.139129844704418D-12,   3.787600016708245D-10,  -1.805196916172835D-08, &
&    8.198101502357474D-07,  -3.693114286885487D-05,   1.662036856518622D-03, &
&    2.649506206802892D-21,  -1.230918238866932D-20,  -2.692604367952174D-19, &
&    1.600198532937298D-17,  -4.780831782444882D-16,   1.044958745572280D-14, &
&   -1.769414016046641D-13,   2.079141821040386D-12,   2.329438356218418D-12, &
&   -1.442650292842045D-09,   8.338914903367671D-08,  -4.123084236778227D-06, &
&    1.987021706919589D-04,  -9.541527350222665D-03,   4.580053005414239D-01, &
&    1.460681126226858D-21,  -1.116069367226994D-20,   1.385215307597667D-20, &
&    4.790772137912757D-18,  -1.833811741065561D-16,   4.411460228640134D-15, &
&   -7.728154469139107D-14,   8.318407196759402D-13,   8.234856131050024D-12, &
&   -1.045410713260679D-09,   5.727602936948845D-08,  -2.810974002061560D-06, &
&    1.353411028904936D-04,  -6.498397744334056D-03,   3.119295228609373D-01, &
&    8.049860534873238D-22,  -6.928117846543449D-21,   3.380298540810924D-20, &
&    2.077642314393060D-18,  -9.191484496391614D-17,   2.309674564720053D-15, &
&   -4.076401097286619D-14,   3.999126098832810D-13,   7.453834868899380D-12, &
&   -7.233017094729915D-10,   3.875730195472853D-08,  -1.895830049054381D-06, &
&    9.123999335497989D-05,  -4.380701590041719D-03,   2.102774536374299D-01, &
&    4.494624406928629D-22,  -4.099299688101619D-21,   2.641724390842075D-20, &
&    1.007424337193295D-18,  -4.910209215397127D-17,   1.264577057262813D-15, &
&   -2.232107119269914D-14,   2.006956304476214D-13,   5.465150500343050D-12, &
&   -4.713090577881456D-10,   2.494829840165653D-08,  -1.218063971121039D-06, &
&    5.860681112809141D-05,  -2.813817545032541D-03,   1.350654574322995D-01, &
&    2.396854464669061D-22,  -2.261256401189690D-21,   1.650447597416727D-20, &
&    4.899021872240956D-19,  -2.554115134857265D-17,   6.677795702883448D-16, &
&   -1.176110461936060D-14,   9.793552144772473D-14,   3.455175782951929D-12, &
&   -2.793812674498878D-10,   1.467921911298158D-08,  -7.158539188828889D-07, &
&    3.443774770882231D-05,  -1.653392248316420D-03,   7.936405085056278D-02, &
&    1.122796033037117D-22,  -1.081286341991749D-21,   8.436180055957436D-21, &
&    2.158774432536601D-19,  -1.178500840583452D-17,   3.110325257165571D-16, &
&   -5.463947736848140D-15,   4.275482392559144D-14,   1.804385521375496D-12, &
&   -1.404882335370566D-10,   7.347293961103004D-09,  -3.580367666099153D-07, &
&    1.722244870886530D-05,  -8.268596222271616D-04,   3.968984818646528D-02, &
&    3.832395291343137D-23,  -3.735529434322471D-22,   3.022182747695772D-21, &
&    7.095753900937293D-20,  -3.987342614033317D-18,   1.058200418241497D-16, &
&   -1.855143269146062D-15,   1.389204213075262D-14,   6.575717022057064D-13, &
&   -5.010525309322477D-11,   2.613215615368349D-09,  -1.272868982297505D-07, &
&    6.122449075708776D-06,  -2.939405481801967D-04,   1.410934933547643D-02, &
&    4.150526107277864D-24,  -4.068348536812642D-23,   3.345376356387550D-22, &
&    7.547036002017696D-21,  -4.300691540656437D-19,   1.144313829075774D-17, &
&   -2.003875687273215D-16,   1.466764871959935D-15,   7.345279942382487D-14, &
&   -5.541813441773284D-12,   2.886587787899095D-10,  -1.405734068137070D-08, &
&    6.761335845464211D-07,  -3.246127824151880D-05,   1.558163494540178D-03, &
&   -5.255754398454077D-23,   5.296404636163978D-21,  -2.101238060821024D-19, &
&    5.787375418434829D-18,  -1.267439685197878D-16,   2.246863881831275D-15, &
&   -2.912840896001229D-14,   3.973044058911366D-14,   1.856710308452361D-11, &
&   -1.193044654198719D-09,   6.328275607570235D-08,  -3.246978042112277D-06, &
&    1.657184371906995D-04,  -8.452204402604257D-03,   4.310641239741031D-01, &
&    8.743623400243537D-23,   1.236098822083599D-21,  -7.745275534003486D-20, &
&    2.422670199542116D-18,  -5.659569287559182D-17,   1.028164278935853D-15, &
&   -1.250078367132739D-14,  -6.528558621306826D-14,   1.363591151427007D-11, &
&   -8.214432489089618D-10,   4.316487473690183D-08,  -2.211768034450732D-06, &
&    1.128659526456427D-04,  -5.756469878541935D-03,   2.935808959717171D-01, &
&    6.942830950107090D-23,   4.166091212346606D-22,  -3.784237315801593D-20, &
&    1.263882508898410D-18,  -3.038957653927499D-17,   5.549826313865796D-16, &
&   -6.325586133904985D-15,  -7.133234248387844D-14,   9.493364105055779D-12, &
&   -5.565212510777463D-10,   2.911901844725093D-08,  -1.491115845699879D-06, &
&    7.608554786722435D-05,  -3.880543874899839D-03,   1.979082910567317D-01, &
&    4.520639669405267D-23,   1.566471548574916D-22,  -1.987901040804490D-20, &
&    6.911076469932017D-19,  -1.688525552932000D-17,   3.083308855937752D-16, &
&   -3.315363645509343D-15,  -5.570225751230373D-14,   6.208248170625133D-12, &
&   -3.584936170576817D-10,   1.871152898122664D-08,  -9.578200902313243D-07, &
&    4.887148496428113D-05,  -2.492552201918430D-03,   1.271204889529504D-01, &
&    2.618822197199789D-23,   5.926410288973595D-23,  -1.022404732674878D-20, &
&    3.648559584988161D-19,  -9.000656976006865D-18,   1.640677317983273D-16, &
&   -1.679126895207269D-15,  -3.632197205153568D-14,   3.688427486651861D-12, &
&   -2.110294845209560D-10,   1.099773299427574D-08,  -5.628294431551944D-07, &
&    2.871681067122271D-05,  -1.464616245237265D-03,   7.469560957385536D-02, &
&    1.289450403368217D-23,   2.066305000733007D-23,  -4.682462694480762D-21, &
&    1.699639227941699D-19,  -4.217825521696024D-18,   7.673219000095462D-17, &
&   -7.554537828169617D-16,  -1.929707446274171D-14,   1.857410549162320D-12, &
&   -1.056564876404187D-10,   5.500876567208371D-09,  -2.814757448854132D-07, &
&    1.436126010073298D-05,  -7.324525430853814D-04,   3.735516673615568D-02, &
&    4.525981515704062D-24,   5.618481446427773D-24,  -1.577026551018252D-21, &
&    5.783860406609050D-20,  -1.440309662306259D-18,   2.616159992059168D-17, &
&   -2.507841462119754D-16,  -7.099701082569114D-15,   6.630173986487815D-13, &
&   -3.758560680135583D-11,   1.955705139844419D-09,  -1.000630368942799D-07, &
&    5.105291429023377D-06,  -2.603796626318188D-04,   1.327939298069456D-02, &
&    4.966271162016320D-25,   5.356553116243674D-25,  -1.697265263971799D-22, &
&    6.255466297915413D-21,  -1.560254001939768D-19,   2.831626352597078D-18, &
&   -2.677666840636374D-17,  -7.964757351890012D-16,   7.336170223037892D-14, &
&   -4.152099345137713D-12,   2.159882480326661D-10,  -1.105050564814923D-08, &
&    5.638022256042221D-07,  -2.875498254941183D-05,   1.466507404220026D-03, &
&   -1.330261275118252D-22,   2.245900462625094D-21,  -5.892879830423548D-20, &
&    1.320500809185754D-18,  -2.444326316476051D-17,   3.409972000388215D-16, &
&   -8.952988098597744D-16,  -2.215149556695309D-13,   1.552815175183363D-11, &
&   -8.785716542714073D-10,   4.781898972719295D-08,  -2.585106728020499D-06, &
&    1.396130937855148D-04,  -7.539183956999739D-03,   4.071161577561206D-01, &
&   -4.557867510699945D-23,   9.206020869840190D-22,  -2.634976888950758D-20, &
&    6.165024757171148D-19,  -1.160294633376534D-17,   1.530749793127272D-16, &
&    4.791455364431222D-16,  -1.638823126290195D-13,   1.070915814584538D-11, &
&   -5.995152116893313D-10,   3.257583314289577D-08,  -1.760660813667174D-06, &
&    9.508519978894573D-05,  -5.134643397358278D-03,   2.772708686501842D-01, &
&   -2.117234874804193D-23,   4.742861123495446D-22,  -1.416477991834412D-20, &
&    3.377961778888157D-19,  -6.375140089032645D-18,   7.971647621498083D-17, &
&    6.549235282457498D-16,  -1.145379873136317D-13,   7.261762587209066D-12, &
&   -4.045184215756102D-10,   2.196266640750976D-08,  -1.186909202294126D-06, &
&    6.409874877622771D-05,  -3.461357858467203D-03,   1.869133993733239D-01, &
&   -1.073662826846858D-23,   2.572678151355394D-22,  -7.880348858679420D-21, &
&    1.898985677933045D-19,  -3.580395170740588D-18,   4.270892909401701D-17, &
&    5.425208286470262D-16,  -7.507956322959621D-14,   4.680347852286380D-12, &
&   -2.599722113297065D-10,   1.410809504702480D-08,  -7.623816291206390D-07, &
&    4.117194450489233D-05,  -2.223300054690737D-03,   1.200582474767600D-01, &
&   -5.372788437434416D-24,   1.351325938463957D-22,  -4.205770784636029D-21, &
&    1.019779986882347D-19,  -1.918863998402870D-18,   2.200929292922275D-17, &
&    3.634450457802848D-16,  -4.467395132227074D-14,   2.756094547278617D-12, &
&   -1.528119123016607D-10,   8.290260938812267D-09,  -4.479753347978258D-07, &
&    2.419251773455447D-05,  -1.306404316822187D-03,   7.054585787659517D-02, &
&   -2.422384899837968D-24,   6.273258562591933D-23,  -1.972806374858046D-21, &
&    4.801641228392557D-20,  -9.016979868966361D-19,   1.003375282097924D-17, &
&    1.959183694680953D-16,  -2.251896313943141D-14,   1.380218096603424D-12, &
&   -7.643804831894863D-11,   4.146072415118173D-09,  -2.240325392263252D-07, &
&    1.209864630271313D-05,  -6.533309235853699D-04,   3.527988180735170D-02, &
&   -8.059352624897318D-25,   2.130570613913621D-23,  -6.741553837329172D-22, &
&    1.644393811870100D-20,  -3.083344070542763D-19,   3.360906443892785D-18, &
&    7.265522993476301D-17,  -8.043109316047941D-15,   4.910596604574406D-13, &
&   -2.717661872904834D-11,   1.473914606920665D-09,  -7.964151064641440D-08, &
&    4.300949969259295D-06,  -2.322526947119522D-04,   1.254164965908461D-02, &
&   -8.628038272572578D-26,   2.302070331710650D-24,  -7.305589127208117D-23, &
&    1.783758989780104D-21,  -3.341985951396366D-20,   3.604909106761108D-19, &
&    8.179791085309959D-18,  -8.902065255768699D-16,   5.425121090819819D-14, &
&   -3.001435190615974D-12,   1.627728962527850D-10,  -8.795204161842687D-09, &
&    4.749746798373088D-07,  -2.564878514906366D-05,   1.385034850648328D-03, &
&   -4.040449562679423D-23,   5.347198060078081D-22,  -1.183774698841430D-20, &
&    2.311770998773669D-19,  -3.408471763675710D-18,   9.897622282063897D-18, &
&    2.482958763735911D-15,  -1.855045843706989D-13,   1.112375583108348D-11, &
&   -6.399431870681521D-10,   3.652979407372535D-08,  -2.082589603674206D-06, &
&    1.187098832274732D-04,  -6.766473136512304D-03,   3.856889965279599D-01, &
&   -1.787475945916428D-23,   2.500338978691692D-22,  -5.734052802608474D-21, &
&    1.130021586734819D-19,  -1.576229887438233D-18,  -4.357127699331514D-18, &
&    1.836959228649708D-15,  -1.280163803006535D-13,   7.592556264065412D-12, &
&   -4.359792684451865D-10,   2.487997034025264D-08,  -1.418375430361438D-06, &
&    8.084867266650929D-05,  -4.608379861125536D-03,   2.626776678286626D-01, &
&   -9.561592524734315D-24,   1.371998057397653D-22,  -3.195260546456727D-21, &
&    6.296310787261127D-20,  -8.347443957279476D-19,  -6.411468574426334D-18, &
&    1.284943680385730D-15,  -8.684338452782578D-14,   5.123766426562613D-12, &
&   -2.939482333910714D-10,   1.677237145071190D-08,  -9.561547947336538D-07, &
&    5.450158660053441D-05,  -3.106593757994891D-03,   1.770758537153219D-01, &
&   -5.289590843064063D-24,   7.723077730792191D-23,  -1.814003163969072D-21, &
&    3.565825205479055D-20,  -4.524604411573082D-19,  -5.410879067505185D-18, &
&    8.428778896877024D-16,  -5.598826498390818D-14,   3.293198686808312D-12, &
&   -1.888268536266046D-10,   1.077335892677054D-08,  -6.141582166876533D-07, &
&    3.500747152734843D-05,  -1.995427853894673D-03,   1.137393933436901D-01, &
&   -2.821831448784965D-24,   4.153089963816398D-23,  -9.801111803510922D-22, &
&    1.921424589218952D-20,  -2.351706374519315D-19,  -3.657041565178915D-18, &
&    5.017939008645343D-16,  -3.297598507290369D-14,   1.935863360758490D-12, &
&   -1.109608721112288D-10,   6.330440611482164D-09,  -3.608777510832404D-07, &
&    2.057028396006917D-05,  -1.172507287343906D-03,   6.683291854375289D-02, &
&   -1.319623977523593D-24,   1.957081780300058D-23,  -4.633254903862742D-22, &
&    9.060999000024559D-21,  -1.078754256415437D-19,  -1.981086975488455D-18, &
&    2.530335466032288D-16,  -1.651612497801381D-14,   9.683771098191990D-13, &
&   -5.549356844086652D-11,   3.165859773665716D-09,  -1.804745298547963D-07, &
&    1.028716970567721D-05,  -5.863692046030468D-04,   3.342304619054802D-02, &
&   -4.510318719210396D-25,   6.707456577188497D-24,  -1.590449023905570D-22, &
&    3.105082266384339D-21,  -3.628084395698259D-20,  -7.366944785665022D-19, &
&    9.039693841073698D-17,  -5.876649357015330D-15,   3.443031636788044D-13, &
&   -1.972788808076241D-11,   1.125435243460103D-09,  -6.415693226114777D-08, &
&    3.656987340713550D-06,  -2.084484630975638D-04,   1.188156292796888D-02, &
&   -4.882787636684160D-26,   7.278112098015200D-25,  -1.727194204799754D-23, &
&    3.369007246568796D-22,  -3.899346491508681D-21,  -8.304317390612610D-20, &
&    1.000619303599087D-17,  -6.492646229488436D-16,   3.802591206726796D-14, &
&   -2.178670499468367D-12,   1.242874163344382D-10,  -7.085160391133783D-09, &
&    4.038587509302569D-07,  -2.301996897648492D-05,   1.312138289724469D-03, &
&   -8.372059305233757D-24,   9.763838852642567D-23,  -1.891356241803404D-21, &
&    2.947122301018257D-20,  -6.269967131918069D-20,  -2.631300061267389D-17, &
&    2.048200824857691D-15,  -1.293428238440758D-13,   7.837863190282839D-12, &
&   -4.710685279625224D-10,   2.827104545428362D-08,  -1.696312333066078D-06, &
&    1.017790204124940D-04,  -6.106742400387959D-03,   3.664045472751356D-01, &
&   -4.061888306385430D-24,   4.858396275714562D-23,  -9.469985054760858D-22, &
&    1.387952644797110D-20,   5.650224352892055D-20,  -1.934042398536564D-17, &
&    1.412964816691423D-15,  -8.829083460765815D-14,   5.339990681208637D-12, &
&   -3.208420567539939D-10,   1.925440753539186D-08,  -1.155292448706152D-06, &
&    6.931770626782343D-05,  -4.159063048239230D-03,   2.495437847641926D-01, &
&   -2.283620574176313D-24,   2.742649447314609D-23,  -5.334834961079797D-22, &
&    7.411069431560203D-21,   6.989363663499998D-20,  -1.350103393792559D-17, &
&    9.584776523843256D-16,  -5.958588020675474D-14,   3.600442783555158D-12, &
&   -2.162909576742276D-10,   1.297978757586804D-08,  -7.788041154102203D-07, &
&    4.672834323196682D-05,  -2.803701001504311D-03,   1.682220612275149D-01, &
&   -1.278814174870910D-24,   1.567443201665067D-23,  -3.042533260395804D-22, &
&    4.035573597549816D-21,   5.687438637586155D-20,  -8.848176948910130D-18, &
&    6.179400784436911D-16,  -3.829926318475995D-14,   2.312892615784584D-12, &
&   -1.389301677714159D-10,   8.337193939651651D-09,  -5.002416742207066D-07, &
&    3.001455791465453D-05,  -1.800873718559033D-03,   1.080524237947472D-01, &
&   -7.078040631671320D-25,   8.514184104862921D-24,  -1.644964654472794D-22, &
&    2.103270349677709D-21,   3.787832072128734D-20,  -5.265140344630295D-18, &
&    3.639620100471223D-16,  -2.251438359597307D-14,   1.359145703732205D-12, &
&   -8.163574971812697D-11,   4.898915134173535D-09,  -2.939405030563576D-07, &
&    1.763646225811441D-05,  -1.058187871689787D-03,   6.349127268261541D-02, &
&   -3.276535814867130D-25,   4.035604769011154D-24,  -7.783320427454249D-23, &
&    9.664199340153291D-22,   2.037094269447623D-20,  -2.654296319027925D-18, &
&    1.822950016930332D-16,  -1.126259893844461D-14,   6.797383111482384D-13, &
&   -4.082618402060702D-11,   2.449942206148348D-09,  -1.469992315755506D-07, &
&    8.819969383008912D-06,  -5.291982288088116D-04,   3.175189391293075D-02, &
&   -1.141961621572282D-25,   1.387810402997881D-24,  -2.670117101732738D-23, &
&    3.253429406424210D-22,   7.546833279304369D-21,  -9.481202609879587D-19, &
&    6.486379807458052D-17,  -4.004428703968492D-15,   2.416470492917997D-13, &
&   -1.451336218392785D-11,   8.709306572739231D-10,  -5.225677760588041D-08, &
&    3.135412042817933D-06,  -1.881247454745815D-04,   1.128748479267118D-02, &
&   -1.233819705327299D-26,   1.508413252994659D-25,  -2.899767028545992D-24, &
&    3.498230744482732D-23,   8.493289138915963D-22,  -1.049424530072755D-19, &
&    7.166340232323736D-18,  -4.422642263746092D-16,   2.668660422808897D-14, &
&   -1.602783549835828D-12,   9.618109284236073D-11,  -5.770968057039009D-09, &
&    3.462586720057735D-07,  -2.077552282388620D-05,   1.246531376451403D-03, &
&   -1.397984986933173D-24,   1.449353080045388D-23,  -2.168155545197693D-22, &
&   -2.161930612418758D-23,   2.636760175526592D-19,  -2.101084965120566D-17, &
&    1.389409993028890D-15,  -8.840182258314333D-14,   5.579373446648965D-12, &
&   -3.516010208921581D-10,   2.215171432610796D-08,  -1.395563926762623D-06, &
&    8.792056007750433D-05,  -5.538995418897562D-03,   3.489567117535714D-01, &
&   -7.059459706695942D-25,   7.384375525177593D-24,  -1.027086200514981D-22, &
&   -8.011193566502051D-22,   1.917403950191386D-19,  -1.447824026491629D-17, &
&    9.483511958389651D-16,  -6.022955143218222D-14,   3.800104331169931D-12, &
&   -2.394633708996960D-10,   1.508667605192062D-08,  -9.504639832491307D-07, &
&    5.987924976887746D-05,  -3.772392813010644D-03,   2.376607474308172D-01, &
&   -4.155559713375534D-25,   4.199971812549404D-24,  -5.464215194633261D-23, &
&   -7.976707589431375D-22,   1.333011429847420D-19,  -9.816915420064845D-18, &
&    6.400109898943241D-16,  -4.060963464274656D-14,   2.561794191880433D-12, &
&   -1.614272635009791D-10,   1.017021013785598D-08,  -6.407252969255079D-07, &
&    4.036570516339593D-05,  -2.543039472639529D-03,   1.602114869055010D-01, &
&   -2.245476483526304D-25,   2.402062299131603D-24,  -2.973678150584972D-23, &
&   -6.104588940350614D-22,   8.717663907011378D-20,  -6.327618610322333D-18, &
&    4.113687436470309D-16,  -2.608744157606415D-14,   1.645521242783113D-12, &
&   -1.036882241295831D-10,   6.532532731842604D-09,  -4.115507931561514D-07, &
&    2.592770683440391D-05,  -1.633445558988977D-03,   1.029070702939986D-01, &
&   -1.343248807721963D-25,   1.304795025337695D-24,  -1.534498704836677D-23, &
&   -3.954917936275034D-22,   5.181019685338976D-20,  -3.726425410942677D-18, &
&    2.418242686190964D-16,  -1.533006668463026D-14,   9.669144040526997D-13, &
&   -6.092697309954520D-11,   3.838496797684723D-09,  -2.418259865216221D-07, &
&    1.523504099412883D-05,  -9.598075985587341D-04,   6.046787875279035D-02, &
&   -5.768257828655684D-26,   6.182131087758700D-25,  -7.066412429383486D-24, &
&   -2.096146403368413D-22,   2.609935400818842D-20,  -1.866278678697090D-18, &
&    1.209701404244022D-16,  -7.666923804384033D-15,   4.835561441109417D-13, &
&   -3.046952106650068D-11,   1.919626912693313D-09,  -1.209368282028311D-07, &
&    7.619022036110100D-06,  -4.799983959869530D-04,   3.023989896829789D-02, &
&   -2.137359437474928D-26,   2.122672643405230D-25,  -2.361032354019781D-24, &
&   -7.705013578526690D-23,   9.318636059944595D-21,  -6.640245299451850D-19, &
&    4.301105938636582D-17,  -2.725597698014909D-15,   1.719002234721437D-13, &
&   -1.083162033603906D-11,   6.824084578126141D-10,  -4.299184862088870D-08, &
&    2.708487110477275D-06,  -1.706346906464143D-04,   1.074998551808408D-02, &
&   -2.261846776479881D-27,   2.307235272753837D-26,  -2.539338212507071D-25, &
&   -8.641340707333831D-24,   1.031223686103082D-21,  -7.336179806077870D-20, &
&    4.750304310177192D-18,  -3.010051914546791D-16,   1.898381195618059D-14, &
&   -1.196188403537517D-12,   7.536165899432509D-11,  -4.747797171701915D-09, &
&    2.991112925932321D-07,  -1.884401172713759D-05,   1.187172739614685D-03, &
&   -1.911709009806316D-25,   1.504352209171088D-24,   7.521889014124812D-24, &
&   -2.491898378274679D-21,   2.010412082411977D-19,  -1.385860755229753D-17, &
&    9.231787398590864D-16,  -6.103883275325619D-14,   4.029789440429648D-12, &
&   -2.659780393672053D-10,   1.755464914730764D-08,  -1.158607515344663D-06, &
&    7.646809964238937D-05,  -5.046894590989435D-03,   3.330950430441122D-01, &
&   -9.898638862491557D-26,   7.170654000788614D-25,   1.059473643781139D-23, &
&   -1.789861746198701D-21,   1.383140617802381D-19,  -9.457363153631092D-18, &
&    6.289672907493727D-16,  -4.157355889909060D-14,   2.744553828059652D-12, &
&   -1.811473968924294D-10,   1.195578502227861D-08,  -7.890822007711775D-07, &
&    5.207942736492146D-05,  -3.437242214621532D-03,   2.268579861878208D-01, &
&   -5.950226383971703D-26,   3.667335847280905D-25,   8.983943044799820D-24, &
&   -1.237858930462427D-21,   9.371744778634595D-20,  -6.381902813662344D-18, &
&    4.240777270454616D-16,  -2.802635047597302D-14,   1.850162160196396D-12, &
&   -1.221148586308650D-10,   8.059615281819515D-09,  -5.319348463798839D-07, &
&    3.510770115566541D-05,  -2.317108281514426D-03,   1.529291465939804D-01, &
&   -2.898714321898695D-26,   2.123830868090952D-25,   6.439433650367953D-24, &
&   -8.073860314350221D-22,   6.038311874783624D-20,  -4.101786735956893D-18, &
&    2.724250194573139D-16,  -1.800222759010555D-14,   1.188399627951948D-12, &
&   -7.843686228595103D-11,   5.176853660951862D-09,  -3.416724844241432D-07, &
&    2.255038475075837D-05,  -1.488325396707365D-03,   9.822947619115018D-02, &
&   -1.882652549368706D-26,   9.931965325781437D-26,   4.070404355730208D-24, &
&   -4.789557601602554D-22,   3.555185550439429D-20,  -2.411176772399694D-18, &
&    1.600881280385606D-16,  -1.057818350896494D-14,   6.983011896104048D-13, &
&   -4.608926926421228D-11,   3.041903390346071D-09,  -2.007657038172677D-07, &
&    1.325053688899318D-05,  -8.745354364472987D-04,   5.771933881028137D-02, &
&   -8.572894235072526D-27,   4.873566254212334D-26,   2.119215155253604D-24, &
&   -2.410450089531444D-22,   1.780249310210139D-20,  -1.206144931679587D-18, &
&    8.006376736058676D-17,  -5.290176798570875D-15,   3.492198162518505D-13, &
&   -2.304918026935292D-11,   1.521251519897991D-09,  -1.004026390795987D-07, &
&    6.626574391049410D-06,  -4.373539106694031D-04,   2.886535810649017D-02, &
&   -2.750253064154980D-27,   1.568469392532950D-26,   7.701563289164869D-25, &
&   -8.600682259072304D-23,   6.333589341810953D-21,  -4.288415474228684D-19, &
&    2.846272830690695D-17,  -1.880614827071512D-15,   1.241442831875039D-13, &
&   -8.193756705372052D-12,   5.407899002154729D-10,  -3.569214691929204D-08, &
&    2.355681770489517D-06,  -1.554749971522144D-04,   1.026134981285175D-02, &
&   -3.198414658711368D-28,   1.702213544550580D-27,   8.618313199053366D-26, &
&   -9.515125474342544D-24,   6.997086369590461D-22,  -4.736265064240989D-20, &
&    3.143320886183433D-18,  -2.076858472296979D-16,   1.370985638336458D-14, &
&   -9.048761013368788D-13,   5.972203673037395D-11,  -3.941655901122315D-09, &
&    2.601492975483374D-07,  -1.716985367100153D-05,   1.133210342374254D-03, &
&   -1.912439758654690D-26,  -1.072394936618097D-25,   2.221675701975943D-23, &
&   -1.800111150228683D-21,   1.289183783118906D-19,  -8.968975765639424D-18, &
&    6.198912574222321D-16,  -4.278537467684024D-14,   2.952332246499214D-12, &
&   -2.037122706044043D-10,   1.405615755226012D-08,  -9.698749438292323D-07, &
&    6.692137151013023D-05,  -4.617574635724025D-03,   3.186126498689487D-01, &
&   -3.876346603293722D-28,  -1.109702786111258D-25,   1.568613459548031D-23, &
&   -1.236241589601577D-21,   8.795208153649117D-20,  -6.110408135651499D-18, &
&    4.222071269413917D-16,  -2.913968699265536D-14,   2.010720055478983D-12, &
&   -1.387404649112870D-10,   9.573098424951008D-09,  -6.605438339255943D-07, &
&    4.557752476788281D-05,  -3.144849209884498D-03,   2.169945954843958D-01, &
&   -1.776020033645548D-26,  -8.431220917168660D-26,   1.092550420028688D-23, &
&   -8.369627498899018D-22,   5.934265789528597D-20,  -4.119844355002892D-18, &
&    2.846259967842794D-16,  -1.964368773216556D-14,   1.355464223274469D-12, &
&   -9.352750883209346D-11,   6.453401998466838D-09,  -4.452847640666168D-07, &
&    3.072464886037481D-05,  -2.120000771921555D-03,   1.462800532640497D-01, &
&    8.965921275410037D-27,  -6.242433763450971D-26,   6.957410797281842D-24, &
&   -5.389832969387983D-22,   3.813834012181893D-20,  -2.646540084741515D-18, &
&    1.828243776402040D-16,  -1.261757232023898D-14,   8.706423405617498D-13, &
&   -6.007460835085769D-11,   4.145150316719121D-09,  -2.860153876289980D-07, &
&    1.973506183077414D-05,  -1.361719266659302D-03,   9.395862940037698D-02, &
&   -4.762440276635928D-27,  -3.641541307182444D-26,   4.191379516070996D-24, &
&   -3.172536050487972D-22,   2.241783041025355D-20,  -1.555207048695496D-18, &
&    1.074283415651933D-16,  -7.414060495916521D-15,   5.115868936796860D-13, &
&   -3.529965651993104D-11,   2.435677613782889D-09,  -1.680617642160449D-07, &
&    1.159626177836679D-05,  -8.001420628964165D-04,   5.520980234035150D-02, &
&   -4.973170925895232D-28,  -1.956727674094678D-26,   2.095580306798212D-24, &
&   -1.588300163624732D-22,   1.121377498659354D-20,  -7.777922458366625D-19, &
&    5.372518460399513D-17,  -3.707765471895017D-15,   2.558439092360142D-13, &
&   -1.765330764647410D-11,   1.218078864446179D-09,  -8.404744594650513D-08, &
&    5.799273793342524D-06,  -4.001498918324698D-04,   2.761034253668276D-02, &
&   -7.233374727507245D-29,  -6.896818434953919D-27,   7.459319858921538D-25, &
&   -5.650129680548452D-23,   3.986961383272542D-21,  -2.765051470899739D-19, &
&    1.909886513851996D-17,  -1.318074997817662D-15,   9.094999274569966D-14, &
&   -6.275576643873793D-12,   4.330150104075462D-10,  -2.987803721747921D-08, &
&    2.061584576041317D-06,  -1.422493357788995D-04,   9.815204168828670D-03, &
&   -2.059610323793767D-29,  -7.806931753984313D-28,   8.260773136508880D-26, &
&   -6.241621863198132D-24,   4.403288378617703D-22,  -3.053620025042060D-20, &
&    2.109184634055189D-18,  -1.455614295854062D-16,   1.004404675447049D-14, &
&   -6.930421947396791D-13,   4.781993571929762D-11,  -3.299575728677907D-09, &
&    2.276707261580859D-07,  -1.570928010841568D-05,   1.083940327489944D-03, &
&    1.931831498378047D-27,  -1.836012962466394D-25,   1.511832628382069D-23, &
&   -1.122787785264518D-21,   8.140842516177624D-20,  -5.870046029691849D-18, &
&    4.227615887816845D-16,  -3.044027777315152D-14,   2.191715521564318D-12, &
&   -1.578036624336394D-10,   1.136186484565630D-08,  -8.180542764463733D-07, &
&    5.889990794361170D-05,  -4.240793372093675D-03,   3.053371227911409D-01, &
&    5.427693423415261D-27,  -1.315485409726294D-25,   1.033685280301921D-23, &
&   -7.657468547582488D-22,   5.545967065377107D-20,  -3.998059562845651D-18, &
&    2.879286889157942D-16,  -2.073170467575283D-14,   1.492691802644765D-12, &
&   -1.074738947843394D-10,   7.738121102135163D-09,  -5.571447238234730D-07, &
&    4.011442013871428D-05,  -2.888238250078905D-03,   2.079531540059179D-01, &
&   -1.895501199014173D-27,  -8.554953072013131D-26,   7.031385640665563D-24, &
&   -5.166225249079151D-22,   3.739184584637262D-20,  -2.695238195934052D-18, &
&    1.940988811498364D-16,  -1.397563269223948D-14,   1.006251113840778D-12, &
&   -7.245013244788125D-11,   5.216409953794598D-09,  -3.755815194331341D-07, &
&    2.704186941367834D-05,  -1.947014597841545D-03,   1.401850510447382D-01, &
&    1.782805391586130D-27,  -6.034093997774105D-26,   4.507325767846056D-24, &
&   -3.319516016236128D-22,   2.401980795647818D-20,  -1.731235251871503D-18, &
&    1.246739703422715D-16,  -8.976834384938513D-15,   6.463354233738602D-13, &
&   -4.653618199154215D-11,   3.350605355544009D-09,  -2.412435872681283D-07, &
&    1.736953829208041D-05,  -1.250606757064165D-03,   9.004368650870910D-02, &
&    2.601233945168928D-27,  -3.269946469631093D-26,   2.637645916795183D-24, &
&   -1.951371615559620D-22,   1.411487898614215D-20,  -1.017279797732039D-18, &
&    7.325817584460861D-17,  -5.274761725581562D-15,   3.797847240893235D-13, &
&   -2.734451784603258D-11,   1.968805426791114D-09,  -1.417539916688743D-07, &
&    1.020628740510515D-05,  -7.348526931869629D-04,   5.290939390951170D-02, &
&   -9.899556222067795D-28,  -1.737997614528768D-26,   1.339046671200589D-24, &
&   -9.759907289943918D-23,   7.059054185353462D-21,  -5.087439227990232D-19, &
&    3.663635218925480D-17,  -2.637901189724939D-15,   1.899297969858466D-13, &
&   -1.367495397513605D-11,   9.845967550802318D-10,  -7.089096682230953D-08, &
&    5.104149613610119D-06,  -3.674987721893581D-04,   2.645991159765829D-02, &
&    3.484154072699432D-28,  -6.024681811983257D-27,   4.706684665103160D-25, &
&   -3.470106277703826D-23,   2.509503139703302D-21,  -1.808542495122197D-19, &
&    1.302387103609044D-17,  -9.377479280085056D-16,   6.751816851030301D-14, &
&   -4.861311129270986D-12,   3.500144253356470D-10,  -2.520103878350506D-08, &
&    1.814474793251642D-06,  -1.306421851174116D-04,   9.406237328462196D-03, &
&    1.507582170875111D-29,  -6.775139766306195D-28,   5.217705436503303D-26, &
&   -3.832343063114285D-24,   2.771391889003627D-22,  -1.997264984039383D-20, &
&    1.438289387389605D-18,  -1.035600309664325D-16,   7.456356983838876D-15, &
&   -5.368580307081703D-13,   3.865378084057191D-11,  -2.783072237961907D-09, &
&    2.003812012251377D-07,  -1.442744648857052D-05,   1.038776147178015D-03, &
&    1.655544378946216D-27,  -1.193611747985416D-25,   9.185478588436946D-24, &
&   -6.929587460049722D-22,   5.203654038674209D-20,  -3.903703096217642D-18, &
&    2.927906405957360D-16,  -2.195945256392081D-14,   1.646960574231582D-12, &
&   -1.235220580435691D-10,   9.264154470300664D-09,  -6.948115860300037D-07, &
&    5.211086895614941D-05,  -3.908315171726177D-03,   2.931236378795014D-01, &
&    5.653495735477710D-27,  -8.341028232303588D-26,   6.224076176118859D-24, &
&   -4.720455012140006D-22,   3.544171096405228D-20,  -2.658678804081527D-18, &
&    1.994084590164156D-16,  -1.495572521783722D-14,   1.121680353934364D-12, &
&   -8.412603541221628D-11,   6.309452725455507D-09,  -4.732089548607331D-07, &
&    3.549067161688683D-05,  -2.661800371275492D-03,   1.996350278456849D-01, &
&   -4.521931493793788D-27,  -5.174423247722829D-26,   4.272473138671952D-24, &
&   -3.182833362169155D-22,   2.389220737540877D-20,  -1.792271456413339D-18, &
&    1.344249976848249D-16,  -1.008193064971349D-14,   7.561453922638410D-13, &
&   -5.671090989887671D-11,   4.253318285469916D-09,  -3.189988716903510D-07, &
&    2.392491537822533D-05,  -1.794368653372489D-03,   1.345776490029510D-01, &
&    7.770760970322380D-27,  -3.988631481820026D-26,   2.651237547873332D-24, &
&   -2.044112077631202D-22,   1.534700180544639D-20,  -1.151215143708222D-18, &
&    8.634392107390531D-17,  -6.475827800761476D-15,   4.856874436601156D-13, &
&   -3.642656158921695D-11,   2.731992145271498D-09,  -2.048994110652437D-07, &
&    1.536745583077309D-05,  -1.152559187311379D-03,   8.644193904836212D-02, &
&   -4.956548202413115D-27,  -1.809687875793721D-26,   1.638478566855628D-24, &
&   -1.201550000357329D-22,   9.017671287601983D-21,  -6.764515258642464D-19, &
&    5.073543670000551D-17,  -3.805176680248576D-15,   2.853884528413237D-13, &
&   -2.140413583043273D-11,   1.605310201987069D-09,  -1.203982652448909D-07, &
&    9.029869893863660D-06,  -6.772402420416946D-04,   5.079301815313201D-02, &
&    2.538928609731084D-27,  -1.146912529105912D-26,   7.792972581878199D-25, &
&   -6.007422264837528D-23,   4.509880594988764D-21,  -3.382928550656125D-19, &
&    2.537272288673708D-17,  -1.902963415095514D-15,   1.427223541254782D-13, &
&   -1.070417746657122D-11,   8.028133171405827D-10,  -6.021099883216570D-08, &
&    4.515824912654193D-06,  -3.386868684499992D-04,   2.540151513375234D-02, &
&   -2.411335897980119D-28,  -3.600701466754857D-27,   2.859006958279203D-25, &
&   -2.135963577201035D-23,   1.603197639027091D-21,  -1.202598428131621D-19, &
&    9.019753465746823D-18,  -6.764847154270936D-16,   5.073638784902600D-14, &
&   -3.805229405332460D-12,   2.853922078958012D-10,  -2.140441560847011D-08, &
&    1.605331170719733D-06,  -1.203998378043067D-04,   9.029987835323841D-03, &
&    1.448813945071433D-29,  -4.129708995691890D-28,   3.126284651681776D-26, &
&   -2.358765459861814D-24,   1.770501016679322D-22,  -1.328087895042055D-20, &
&    9.960949192465261D-19,  -7.470746979863634D-17,   5.603063977027230D-15, &
&   -4.202298329391227D-13,   3.151723774368581D-11,  -2.363792832559630D-09, &
&    1.772844624512236D-07,  -1.329633468387756D-05,   9.972251012909087D-04/
      data w8 / &
&    1.287397934783471D-13,  -2.299038714593140D-12,   2.852296151379994D-11, &
&   -3.377122381831401D-10,   3.845990109981920D-09,  -4.048913418355100D-08, &
&    3.854879592439819D-07,  -3.270957461750012D-06,   2.434689213139439D-05, &
&   -1.557590087672603D-04,   8.328945392256496D-04,  -3.574926633293704D-03, &
&    1.155108579124830D-02,  -2.498637303583127D-02,   2.715245941175409D-02, &
&    1.617004366416422D-13,  -2.910326727003360D-12,   3.671438460732742D-11, &
&   -4.447905937396199D-10,   5.197803192756935D-09,  -5.630197532235435D-08, &
&    5.534192510114342D-07,  -4.867762950182112D-06,   3.773298042461782D-05, &
&   -2.527329123210113D-04,   1.423614877154309D-03,  -6.482759292541856D-03, &
&    2.241000853986996D-02,  -5.238098135902545D-02,   6.225352393864789D-02, &
&    8.196017412777704D-14,  -1.497048666702672D-12,   1.948390886742257D-11, &
&   -2.462611336428261D-10,   3.017171875461717D-09,  -3.442939153501579D-08, &
&    3.587098151874928D-07,  -3.368484689922596D-06,   2.810883276992385D-05, &
&   -2.046201154919283D-04,   1.266690175354100D-03,  -6.422760835790734D-03, &
&    2.511467868090388D-02,  -6.770534264528582D-02,   9.515851168249278D-02, &
&    2.071829845631011D-14,  -3.868954002235721D-13,   5.278795151675882D-12, &
&   -7.109686796128368D-11,   9.346903102977506D-10,  -1.152433086688526D-08, &
&    1.308783840413171D-07,  -1.353573904456473D-06,   1.258843170193199D-05, &
&   -1.035464993268387D-04,   7.361191078791309D-04,  -4.370661254522213D-03, &
&    2.050217439872242D-02,  -6.842914024565499D-02,   1.246289712555339D-01, &
&    2.577940437752355D-15,  -4.986842895362454D-14,   7.298936940545094D-13, &
&   -1.075242321549221D-11,   1.557912934685058D-10,  -2.135619075900830D-09, &
&    2.727532965116111D-08,  -3.215045260041359D-07,   3.460707403262892D-06, &
&   -3.354307937222308D-05,   2.870492312782556D-04,  -2.106079386701255D-03, &
&    1.262711951327197D-02,  -5.645268290458198D-02,   1.495959888165767D-01, &
&    1.553106992077306D-16,  -3.046198550276095D-15,   4.771524757073247D-14, &
&   -7.848266523755958D-13,   1.292096790921134D-11,  -2.038525328571542D-10, &
&    3.039928334427914D-09,  -4.253475631061708D-08,   5.538675007350867D-07, &
&   -6.639476424321886D-06,   7.216267056690865D-05,  -6.951427659664832D-04, &
&    5.718732644952418D-03,  -3.738554407489182D-02,   1.691565193950025D-01, &
&   -2.712508363586649D-18,  -1.190928106013186D-18,   8.389804048569461D-16, &
&   -2.132702838613864D-14,   4.341433420811918D-13,  -8.307140912968885D-12, &
&    1.523768490878547D-10,  -2.674862983972053D-09,   4.470998670241705D-08, &
&   -7.066424611154673D-07,   1.045821317658486D-05,  -1.428450819997596D-04, &
&    1.757766837568653D-03,  -1.869757594368103D-02,   1.826034150449236D-01, &
&    1.805847121308973D-18,  -1.973064673367868D-17,   9.984031129019811D-17, &
&   -3.995598119882023D-16,   3.781521008359832D-15,  -8.330309965877996D-14, &
&    2.054008505982295D-12,  -5.009702913978696D-11,   1.197898511022345D-09, &
&   -2.802720992387448D-08,   6.408157136968774D-07,  -1.434855878922043D-05, &
&    3.184335934671937D-04,  -7.295693124381088D-03,   1.894506104550685D-01, &
&    1.549102458290960D-14,  -1.147808133001501D-13,   1.453372387261466D-12, &
&   -1.921626567205601D-11,   2.244340858745493D-10,  -2.382690198854991D-09, &
&    2.284442547111130D-08,  -1.952574523481582D-07,   1.464933378233487D-06, &
&   -9.453919683001098D-06,   5.104256494606782D-05,  -2.214424284376771D-04, &
&    7.241366805384913D-04,  -1.587693483817170D-03,   1.752032831812639D-03, &
&    2.023525053893610D-14,  -1.535083087120063D-13,   2.004506267173318D-12, &
&   -2.725898034440168D-11,   3.293118813750286D-10,  -3.632636109550506D-09, &
&    3.636007327675794D-08,  -3.262322646226488D-07,   2.585545114064481D-06, &
&   -1.775517112479920D-05,   1.028744936286919D-04,  -4.837608751175139D-04, &
&    1.735192590403295D-03,  -4.233625405025322D-03,   5.292971831159267D-03, &
&    1.100208974250777D-14,  -8.709282067475922D-14,   1.201301884473283D-12, &
&   -1.718155010040832D-11,   2.204177305372839D-10,  -2.601581614881234D-09, &
&    2.808510696276906D-08,  -2.742891510405178D-07,   2.391365951299104D-06, &
&   -1.828647288826655D-05,   1.196830904977594D-04,  -6.466623026038303D-04, &
&    2.721183700799134D-03,  -7.997352983239941D-03,   1.248244365568053D-02, &
&    3.069917710748930D-15,  -2.586067810232437D-14,   3.857898113724687D-13, &
&   -5.935825631483753D-12,   8.297126815423918D-11,  -1.077744061811004D-09, &
&    1.293978640904324D-08,  -1.422596249365645D-07,   1.415630982797428D-06, &
&   -1.255544144905714D-05,   9.713266192022253D-05,  -6.347880283945464D-04, &
&    3.326124037753780D-03,  -1.265662099276619D-02,   2.721055979724507D-02, &
&    4.374969979480846D-16,  -4.006476123100415D-15,   6.622810280070154D-14, &
&   -1.122891691286615D-12,   1.755991968104142D-11,  -2.582160924616350D-10, &
&    3.554034346516571D-09,  -4.543767995308292D-08,   5.344721166660148D-07, &
&   -5.710876286584405D-06,   5.444649871484189D-05,  -4.509359137452068D-04, &
&    3.105791403140783D-03,  -1.635661829634074D-02,   5.408215027298111D-02, &
&    2.879751741518563D-17,  -2.940954799043371D-16,   5.537515810710508D-15, &
&   -1.064253474217349D-13,   1.918900457500348D-12,  -3.297309257859548D-11, &
&    5.379938442750147D-10,  -8.287136716428838D-09,   1.196451626225463D-07, &
&   -1.603363160683817D-06,   1.967480950322323D-05,  -2.166505991271259D-04, &
&    2.071585279939234D-03,  -1.610367188632361D-02,   9.425873345461121D-02, &
&    6.855658105330186D-19,  -8.091269264973307D-18,   1.801815104307400D-16, &
&   -4.082256374373490D-15,   8.842957725075860D-14,  -1.853672749072889D-12, &
&    3.750944251471120D-11,  -7.299865047527444D-10,   1.359992218479670D-08, &
&   -2.410535734544022D-07,   4.029935491764795D-06,  -6.272504734389283D-05, &
&    8.893484495950186D-04,  -1.111070919855573D-02,   1.391767748661549D-01, &
&    2.846056986035489D-21,  -4.169491004334894D-20,   1.180298868750420D-18, &
&   -3.404413433834782D-17,   9.587356156451337D-16,  -2.664872176868496D-14, &
&    7.293340834427451D-13,  -1.964821592965498D-11,   5.199337239475264D-10, &
&   -1.350750857940081D-08,   3.443173272342762D-07,  -8.652757128352337D-06, &
&    2.175693215296074D-04,  -5.713123064527871D-03,   1.700878935217932D-01, &
&    8.998081329652553D-16,  -6.703218409595258D-15,   8.545784547941717D-14, &
&   -1.136623271600109D-12,   1.336733348045661D-11,  -1.429996029966446D-10, &
&    1.382504221808514D-09,  -1.192548449422466D-08,   9.038374088565145D-08, &
&   -5.899033757082286D-07,   3.225363167255628D-06,  -1.419306265525231D-05, &
&    4.716724866487223D-05,  -1.053457008066630D-04,   1.187703799223400D-04, &
&    1.259835982814260D-15,  -9.687883285375342D-15,   1.287098854502553D-13, &
&   -1.777771266361475D-12,   2.187641526270526D-11,  -2.463466544459843D-10, &
&    2.522996188117533D-09,  -2.322631027621170D-08,   1.894814427272703D-07, &
&   -1.344482917167971D-06,   8.086041637203121D-06,  -3.968911327686979D-05, &
&    1.496271900239770D-04,  -3.871469951235503D-04,   5.195755666446688D-04, &
&    7.720247994065517D-16,  -6.274498570208059D-15,   8.944986577063505D-14, &
&   -1.318561932567626D-12,   1.752377081779804D-11,  -2.151152764998684D-10, &
&    2.425382253270343D-09,  -2.486032420503323D-08,   2.287763140395784D-07, &
&   -1.858993486576916D-06,   1.303370242848125D-05,  -7.619399150420127D-05, &
&    3.513542029124195D-04,  -1.151349473665511D-03,   2.058880814254930D-03, &
&    2.535365756643175D-16,  -2.225798380822342D-15,   3.491691360803299D-14, &
&   -5.628355407614761D-13,   8.298946365585560D-12,  -1.142952715723498D-10, &
&    1.462891675648433D-09,  -1.725258537598168D-08,   1.854997402697122D-07, &
&   -1.792768139558851D-06,   1.526801891325445D-05,  -1.112468720175760D-04, &
&    6.608642254632208D-04,  -2.919817303312674D-03,   7.641890827584510D-03, &
&    4.411629057773758D-17,  -4.273172400887264D-16,   7.546323008471107D-15, &
&   -1.361146584928966D-13,   2.281467251604671D-12,  -3.615288530932526D-11, &
&    5.392923296868295D-10,  -7.521006079932667D-09,   9.722109560904862D-08, &
&   -1.151519195128444D-06,   1.229679536096954D-05,  -1.155754502908953D-04, &
&    9.194595131336738D-04,  -5.732649313423462D-03,   2.412093375538614D-02, &
&    3.664605178260246D-18,  -4.009699385698863D-17,   8.165750684249688D-16, &
&   -1.690334595175334D-14,   3.305492181701302D-13,  -6.189867107532858D-12, &
&    1.106198096235470D-10,  -1.876947121536564D-09,   3.004167069284602D-08, &
&   -4.496460602178673D-07,   6.217860979636999D-06,  -7.803067471346230D-05, &
&    8.631965067484058D-04,  -7.908271140967909D-03,   6.001853662319766D-02, &
&    1.141154880566908D-19,  -1.457009347135001D-18,   3.535773206675943D-17, &
&   -8.697824160492733D-16,   2.056730992031519D-14,  -4.722591742911740D-13, &
&    1.050646950043798D-11,  -2.257083215100468D-10,   4.662967721110315D-09, &
&   -9.212644145645087D-08,   1.727295853505736D-06,  -3.036981782014590D-05, &
&    4.907958623734490D-04,  -7.113922977570633D-03,   1.124315878554126D-01, &
&    6.735543371390805D-22,  -1.015168346029702D-20,   3.290338170532824D-19, &
&   -1.015399695093301D-17,   3.117922264730416D-16,  -9.505169361137290D-15, &
&    2.838270501771920D-13,  -8.395628041255664D-12,   2.438309840138416D-10, &
&   -6.982433745503687D-09,   1.967731400603527D-07,  -5.503051248561961D-06, &
&    1.551851097483969D-04,  -4.608946693212324D-03,   1.546979715312555D-01, &
&    5.310170172867092D-17,  -3.982193928218306D-16,   5.119719124057113D-15, &
&   -6.860023145349530D-14,   8.138364901499495D-13,  -8.790755527613213D-12, &
&    8.589949008671235D-11,  -7.498072085444054D-10,   5.758663215120935D-09, &
&   -3.814973575509980D-08,   2.121457863206794D-07,  -9.517668339951033D-07, &
&    3.234430027632689D-06,  -7.415285987791071D-06,   8.624464265036059D-06, &
&    8.152771298611892D-17,  -6.377917587743684D-16,   8.660700446742963D-15, &
&   -1.220278420712889D-13,   1.537436306323316D-12,  -1.777713291535314D-11, &
&    1.875319629293574D-10,  -1.784769096274310D-09,   1.511811870777107D-08, &
&   -1.119602252737070D-07,   7.072042051550525D-07,  -3.674089396926451D-06, &
&    1.480660398573214D-05,  -4.149814120186261D-05,   6.150836462241652D-05, &
&    5.812242315915617D-17,  -4.878094808158967D-16,   7.237280814396827D-15, &
&   -1.106853710238363D-13,   1.535440853245639D-12,  -1.976571206604117D-11, &
&    2.348636255347079D-10,  -2.551836062233371D-09,   2.506096756426289D-08, &
&   -2.190634475776248D-07,   1.668217743367150D-06,  -1.072059085265546D-05, &
&    5.520631295998068D-05,  -2.065362627727157D-04,   4.387057694548846D-04, &
&    2.316330707815792D-17,  -2.132571454930872D-16,   3.541953437852999D-15, &
&   -6.021807829972411D-14,   9.433219136450894D-13,  -1.387712899914618D-11, &
&    1.908121229672720D-10,  -2.433462436843599D-09,   2.850867851955766D-08, &
&   -3.028850479419865D-07,   2.866235885110957D-06,  -2.351962690945676D-05, &
&    1.602271027719801D-04,  -8.328271343182091D-04,   2.732870843795372D-03, &
&    5.031886959944563D-18,  -5.179758226981134D-17,   9.815397323637428D-16, &
&   -1.892214501559724D-14,   3.414260705347392D-13,  -5.854482711116411D-12, &
&    9.501745668307754D-11,  -1.450683235348411D-09,   2.067485456865734D-08, &
&   -2.722113954426120D-07,   3.263556276290308D-06,  -3.486967467778380D-05, &
&    3.208540863876706D-04,  -2.363696955064548D-03,   1.285117207516821D-02, &
&    5.329602738468989D-19,  -6.258265609315451D-18,   1.379583907614665D-16, &
&   -3.080259939503284D-15,   6.535835944803188D-14,  -1.333885307743752D-12, &
&    2.609618869066637D-11,  -4.871605989911319D-10,   8.628360613240865D-09, &
&   -1.438444007831865D-07,   2.233404930143472D-06,  -3.178538913930844D-05, &
&    4.040557407892888D-04,  -4.310649789497538D-03,   4.236846263460839D-02, &
&    2.167364082742139D-20,  -2.982772792663637D-19,   7.864004764513753D-18, &
&   -2.097941472359964D-16,   5.395275302794360D-15,  -1.352355359266391D-13, &
&    3.294298886373663D-12,  -7.774196855342351D-11,   1.771468090928403D-09, &
&   -3.876779717276044D-08,   8.093371758573891D-07,  -1.593688541174540D-05, &
&    2.905635837138056D-04,  -4.834089838615459D-03,   9.480748723591703D-02, &
&    7.009165149189718D-23,  -3.439032104275325D-21,   1.094334022944186D-19, &
&   -2.961671822784293D-18,   1.165464278320112D-16,  -3.661364449333999D-15, &
&    1.189761657607521D-13,  -3.871334669583557D-12,   1.218442793139327D-10, &
&   -3.831939451135185D-09,   1.183795740561755D-07,  -3.658973101367112D-06, &
&    1.146566800642373D-04,  -3.807677682305976D-03,   1.421336180320091D-01, &
&    3.195105952940230D-18,  -2.415984081141717D-17,   3.139073487979540D-16, &
&   -4.245881932490288D-15,   5.093565759502558D-14,  -5.571013782275515D-13, &
&    5.520063859416622D-12,  -4.894376747821548D-11,   3.826116677365835D-10, &
&   -2.586400608000882D-09,   1.472064472607687D-08,  -6.785092583780541D-08, &
&    2.380410739820947D-07,  -5.669827132608437D-07,   6.911792628075630D-07, &
&    5.535339090577301D-18,  -4.425418320797703D-17,   6.177251336338825D-16, &
&   -8.927209963499283D-15,   1.159028504257682D-13,  -1.386190070737178D-12, &
&    1.518667295908417D-11,  -1.508294830207523D-10,   1.340890818133972D-09, &
&   -1.049344428635217D-08,   7.062919923122082D-08,  -3.951160622622763D-07, &
&    1.738241012992292D-06,  -5.420169591157409D-06,   9.221536728383429D-06, &
&    4.753285297201873D-18,  -4.146054688478772D-17,   6.448933994889007D-16, &
&   -1.030663455075771D-14,   1.504324201750025D-13,  -2.048280025971180D-12, &
&    2.588877506271736D-11,  -3.011695594376274D-10,   3.190976707154441D-09, &
&   -3.036491434841452D-08,   2.544923382880672D-07,  -1.824805052286259D-06, &
&    1.067950025201108D-05,  -4.660530216288903D-05,   1.223058816566128D-04, &
&    2.363147646862037D-18,  -2.295049906592289D-17,   4.060035429057480D-16, &
&   -7.324659792971763D-15,   1.226583663441374D-13,  -1.939458021484605D-12, &
&    2.882964982719605D-11,  -4.001170473444097D-10,   5.139975549353105D-09, &
&   -6.041466611975555D-08,   6.393508813145373D-07,  -5.946715624909968D-06, &
&    4.679558492015660D-05,  -2.877896944947482D-04,   1.216453762826588D-03, &
&    6.505703399647222D-19,  -7.142244038696317D-18,   1.456626698428137D-16, &
&   -3.010813659335892D-15,   5.864461457017749D-14,  -1.090860964814097D-12, &
&    1.929970956764770D-11,  -3.231065226710884D-10,   5.082324343849331D-09, &
&   -7.441139570380308D-08,   1.001353391964539D-06,  -1.214708214456531D-05, &
&    1.290412539367285D-04,  -1.113720639054887D-03,   7.916912227881946D-03, &
&    8.801537123449191D-20,  -1.109270714726835D-18,   2.650869424657027D-17, &
&   -6.375696147418940D-16,   1.466500126622230D-14,  -3.261424099228775D-13, &
&    6.966425169266439D-12,  -1.427895950550828D-10,   2.790277876368699D-09, &
&   -5.159978391257847D-08,   8.954882791003701D-07,  -1.436454317843261D-05, &
&    2.081946820626135D-04,  -2.551086995030225D-03,   3.236613403234197D-02, &
&    4.618077559271265D-21,  -6.790897901469588D-20,   1.972822892293621D-18, &
&   -5.645902209714459D-17,   1.570162102588234D-15,  -4.299477880649028D-14, &
&    1.138818820044163D-12,  -2.939530335399860D-11,   7.349785783749655D-10, &
&   -1.770248619251320D-08,   4.087370108594470D-07,  -8.939980423749895D-06, &
&    1.821821226972675D-04,  -3.447060109863595D-03,   8.254727041972356D-02, &
&    7.590303860386764D-23,  -2.995783491708479D-21,  -1.666564091599190D-20, &
&   -1.299984744798183D-18,   5.872465319713138D-17,  -1.169316961737475D-15, &
&    5.749616590420174D-14,  -1.886757727585459D-12,   6.393570962595834D-11, &
&   -2.221599245612289D-09,   7.426955401698790D-08,  -2.527049466973607D-06, &
&    8.721425273749864D-05,  -3.207137036965477D-03,   1.316524414889612D-01, &
&    1.969205384505878D-19,  -1.504726651064506D-18,   1.981546422569658D-17, &
&   -2.713037422228740D-16,   3.302294179510234D-15,  -3.671620041911790D-14, &
&    3.705968170536468D-13,  -3.355744685082283D-12,   2.687304247778120D-11, &
&   -1.867916928589556D-10,   1.098334955942569D-09,  -5.261614468961495D-09, &
&    1.933781893196707D-08,  -4.878175188588984D-08,   6.403411563123886D-08, &
&    3.987637434026095D-19,  -3.276388750201885D-18,   4.733673514422624D-17, &
&   -7.063698203093720D-16,   9.524322347386962D-15,  -1.188561213538245D-13, &
&    1.365656888693395D-12,  -1.431117053781213D-11,   1.352089410818748D-10, &
&   -1.134215582021127D-09,   8.270408347292541D-09,  -5.079985604328201D-08, &
&    2.498377546242948D-07,  -8.934450472926742D-07,   1.833663327514060D-06, &
&    4.274571459056801D-19,  -3.900822980351919D-18,   6.408318749177647D-17, &
&   -1.078071111809438D-15,   1.668653294175018D-14,  -2.423117247136802D-13, &
&    3.286260086594975D-12,  -4.131087190177575D-11,   4.768296946521144D-10, &
&   -4.990916122899254D-09,   4.655076562003957D-08,  -3.769402991450935D-07, &
&    2.543020729504310D-06,  -1.313899859357186D-05,   4.437540200724122D-05, &
&    2.710086379470897D-19,  -2.790491363015406D-18,   5.283407547962591D-17, &
&   -1.016470463900575D-15,   1.828605254585840D-14,  -3.122211672277653D-13, &
&    5.039716526471834D-12,  -7.645601555537729D-11,   1.081173997943823D-09, &
&   -1.411171653857072D-08,   1.675750144653350D-07,  -1.771285788800599D-06, &
&    1.615681051780804D-05,  -1.171332543645497D-04,   6.538193758545471D-04, &
&    9.517425743154764D-20,  -1.118009287430411D-18,   2.457410020569455D-17, &
&   -5.450305938304100D-16,   1.149103210007715D-14,  -2.319578081361359D-13, &
&    4.472217522163853D-12,  -8.218732942008251D-11,   1.424576614786839D-09, &
&   -2.316430196975027D-08,   3.491921957201480D-07,  -4.790918343252829D-06, &
&    5.854833926973748D-05,  -5.833904538095873D-04,   5.475284566333271D-03, &
&    1.618263313662042D-20,  -2.232870033785615D-19,   5.755779809753474D-18, &
&   -1.468932266997711D-16,   3.713074260194070D-15,  -8.939961560864902D-14, &
&    2.069401051206034D-12,  -4.673074988831100D-11,   1.000095933743106D-09, &
&   -2.043543978156083D-08,   3.946154432491824D-07,  -7.082636947751319D-06, &
&    1.161200026382339D-04,  -1.610502028215587D-03,   2.626054020775891D-02, &
&    9.666508093386895D-22,  -1.826357621772025D-20,   5.618286423928522D-19, &
&   -1.597914760791299D-17,   5.113104098816145D-16,  -1.502350478866447D-14, &
&    4.252258547662968D-13,  -1.210252950388152D-11,   3.286436332049147D-10, &
&   -8.665404389665984D-09,   2.199892113833916D-07,  -5.301584530927906D-06, &
&    1.197776908170776D-04,  -2.557433498160893D-03,   7.363363393775371D-02, &
&    4.166377562657304D-22,   2.179581321510890D-21,  -5.888500918796173D-20, &
&   -3.231423287907670D-18,  -1.151485352601685D-17,  -2.918963993410230D-16, &
&    4.244743516858305D-14,  -7.366906671268143D-13,   3.698249070712780D-11, &
&   -1.349247106947650D-09,   4.809206041598957D-08,  -1.805857736737674D-06, &
&    6.795068279443657D-05,  -2.744875954303861D-03,   1.227532471425865D-01, &
&    1.250798887091693D-20,  -9.687703168210569D-20,   1.298121140984783D-18, &
&   -1.805961972036310D-17,   2.240819284517104D-16,  -2.546620703610843D-15, &
&    2.635389251777542D-14,  -2.455783556713868D-13,   2.033138908060403D-12, &
&   -1.469392337628330D-11,   9.049003330802073D-11,  -4.583491782717482D-10, &
&    1.804372898773566D-09,  -4.967662048904763D-09,   7.356432358667687D-09, &
&    3.087851535988072D-20,  -2.624741776535234D-19,   3.956501938397638D-18, &
&   -6.143760211190830D-17,   8.680163416764876D-16,  -1.141420369809670D-14, &
&    1.390475872803711D-13,  -1.556085192204134D-12,   1.583411636755784D-11, &
&   -1.445326636020739D-10,   1.161263185017987D-09,  -7.986276294509942D-09, &
&    4.497014849418745D-08,  -1.896873767566697D-07,   4.989086748353239D-07, &
&    4.273433937152543D-20,  -4.106660803259099D-19,   7.173943553164196D-18, &
&   -1.279075782760898D-16,   2.114512381993794D-15,  -3.298257851057624D-14, &
&    4.835699816693585D-13,  -6.618813483090518D-12,   8.385093925738492D-11, &
&   -9.731573694393824D-10,   1.018003348715786D-08,  -9.381821158244833D-08, &
&    7.372623710933118D-07,  -4.521803552379722D-06,   2.050090160868320D-05, &
&    3.503221578550447D-20,  -3.844849978608994D-19,   7.808116785290608D-18, &
&   -1.608577629334840D-16,   3.121558284071445D-15,  -5.764000746446973D-14, &
&    1.013993961979918D-12,  -1.685961084351803D-11,   2.625128268050711D-10, &
&   -3.815478226593634D-09,   5.083082035552235D-08,  -6.100055084273481D-07, &
&    6.460361241035158D-06,  -5.437527940224073D-05,   4.107994312079094D-04, &
&    1.555917265333353D-20,  -2.001027822026896D-19,   4.638398611080887D-18, &
&   -1.114861665211254D-16,   2.563570405350304D-15,  -5.531724832471520D-14, &
&    1.171354560313751D-12,  -2.364148586771557D-11,   4.472502277389318D-10, &
&   -8.105204276558053D-09,   1.360673847819063D-07,  -2.099957702655628D-06, &
&    2.941946055235594D-05,  -3.313998649276991D-04,   4.146233248416737D-03, &
&    3.007051883370469D-21,  -5.774391359563255D-20,   1.243820121871644D-18, &
&   -3.784114548306329D-17,   1.099828358246595D-15,  -2.591073511983708D-14, &
&    6.833148347216991D-13,  -1.703393822666497D-11,   3.873698941315911D-10, &
&   -8.862929506448342D-09,   1.884110971770285D-07,  -3.755347837479509D-06, &
&    6.918074400861061D-05,  -1.069419848679304D-03,   2.231051987177256D-02, &
&    1.434616347836672D-22,  -9.054753309914703D-21,   9.150234305664625D-20, &
&   -5.146339348287436D-18,   2.084998658357478D-16,  -5.104076617731591D-15, &
&    1.733309121716260D-13,  -5.446094059850937D-12,   1.547983132859159D-10, &
&   -4.520814515902367D-09,   1.249575354101038D-07,  -3.293457947426730D-06, &
&    8.194836358854891D-05,  -1.961236742357422D-03,   6.691211894595565D-02, &
&    7.369114618383776D-22,   1.524175197454692D-20,   2.506676663757318D-19, &
&   -1.247392762272615D-18,  -1.155491122075114D-16,  -2.336117673773488D-15, &
&    1.439486133480708D-14,   5.717747342552624D-14,   3.096199158980239D-11, &
&   -7.634612305546342D-10,   3.237731898198892D-08,  -1.331750192870132D-06, &
&    5.397264847469310D-05,  -2.381231636887581D-03,   1.150850104763466D-01, &
&    8.254745803486337D-22,  -6.507089957657655D-21,   8.919697898979929D-20, &
&   -1.267566044259215D-18,   1.613661173922930D-17,  -1.888808807840301D-16, &
&    2.022084177137179D-15,  -1.959902884235440D-14,   1.699106255882433D-13, &
&   -1.296817203835606D-12,   8.526161218662566D-12,  -4.677862915507520D-11, &
&    2.036046710790821D-10,  -6.384502206121495D-10,   1.154919958576274D-09, &
&    2.606729416683575D-21,  -2.309472151131650D-20,   3.663402426733074D-19, &
&   -5.970393205804112D-18,   8.922538418470822D-17,  -1.248945138142911D-15, &
&    1.631077228726701D-14,  -1.972428447342467D-13,   2.189369680857485D-12, &
&   -2.205511853913650D-11,   1.981538379895071D-10,  -1.551601855794860D-09, &
&    1.021800634900319D-08,  -5.157297128725187D-08,   1.867590121702096D-07, &
&    4.795047335301363D-21,  -4.876514572340498D-20,   9.099605678020459D-19, &
&   -1.732783426559061D-17,   3.074038199762795D-16,  -5.177030492571582D-15, &
&    8.264886568167320D-14,  -1.236490228866169D-12,   1.727669639127155D-11, &
&   -2.238909476121166D-10,   2.630281607155363D-09,  -2.772363868836478D-08, &
&    2.557543159419657D-07,  -1.830668088879724D-06,   1.167514706702735D-05, &
&    5.249490388327529D-21,  -5.971992226069681D-20,   1.290146021270410D-18, &
&   -2.932160107439830D-17,   6.036856229556941D-16,  -1.205865286579764D-14, &
&    2.348180565687766D-13,  -4.226686568989086D-12,   7.250240551694738D-11, &
&   -1.183744734678700D-09,   1.747313556344017D-08,  -2.385260455473327D-07, &
&    2.934848689892299D-06,  -2.782722993893584D-05,   2.926970083492311D-04, &
&    4.109870225880446D-21,  -3.638956850933797D-20,   8.575416787244699D-19, &
&   -2.903635814223448D-17,   6.093438836009321D-16,  -1.424207562324094D-14, &
&    3.593618835634643D-13,  -7.421895923984161D-12,   1.541384108040738D-10, &
&   -3.190269312253738D-09,   5.779961374433446D-08,  -1.009004086560058D-06, &
&    1.612204787523334D-05,  -1.996201729254235D-04,   3.369442905927452D-03, &
&    4.428067491645431D-21,  -1.124404829889048D-21,  -1.923199978120690D-20, &
&   -2.122722882415598D-17,   2.518715812565761D-16,  -6.913254832462455D-15, &
&    2.957069509316988D-13,  -6.298177042566719D-12,   1.582021043442684D-10, &
&   -4.284614683334396D-09,   9.489048429924458D-08,  -2.123225702136973D-06, &
&    4.355974771386896D-05,  -7.384823836061107D-04,   1.963684940867973D-02, &
&    1.846416216035007D-21,   5.657643647200206D-21,  -1.078124981335910D-19, &
&   -6.821372466601695D-18,   3.255837511307004D-17,  -1.326587298303595D-15, &
&    9.809021483510407D-14,  -2.394881016548826D-12,   7.553209002001937D-11, &
&   -2.542652128945668D-09,   7.375142163012190D-08,  -2.130593884985353D-06, &
&    5.799780998773918D-05,  -1.546604767900722D-03,   6.168614561459872D-02, &
&   -6.745617639725437D-21,  -2.109157522001054D-20,   7.073234282341397D-19, &
&    1.896990905409966D-17,   1.242595229170111D-16,  -3.922763040834140D-15, &
&   -8.552660948652261D-14,  -6.919460472123466D-13,   2.862033890561824D-11, &
&   -2.043319812160834D-10,   2.515186048904977D-08,  -9.950297712958455D-07, &
&    4.356712367632025D-05,  -2.090119927230885D-03,   1.083935719264252D-01, &
&    5.721313469090338D-23,  -4.615468777339538D-22,   6.518709915971809D-21, &
&   -9.530566675845551D-20,   1.255653451221225D-18,  -1.529341720817763D-17, &
&    1.714223432769036D-16,  -1.752731887654962D-15,   1.618193822859056D-14, &
&   -1.331037432217548D-13,   9.572038258176559D-13,  -5.864746868839371D-12, &
&    2.937862180333555D-11,  -1.097784178079246D-10,   2.758001844394770D-10, &
&    2.435117778190392D-22,  -2.260704109773608D-21,   3.814737136222559D-20, &
&   -6.580602107646700D-19,   1.048005421130864D-17,  -1.578901405461575D-16, &
&    2.233016270852485D-15,  -2.942610604039176D-14,   3.607379320491865D-13, &
&   -4.056838300093797D-12,   4.105252654923607D-11,  -3.719007989064577D-10, &
&    2.908251169598692D-09,  -1.727834950330958D-08,   9.405146352217615D-08, &
&    6.046350610263504D-22,  -6.351891693287618D-21,   1.343189932121476D-19, &
&   -2.688539311775311D-18,   5.046363345452522D-17,  -9.453031527480081D-16, &
&    1.637429920926827D-14,  -2.647936810661519D-13,   4.162597234359966D-12, &
&   -6.021299731273346D-11,   7.829021369444102D-10,  -9.613569502490845D-09, &
&    1.038620660977552D-07,  -8.312149886825326D-07,   7.905387082725934D-06, &
&    6.386980259765309D-22,  -6.989989466315205D-21,   3.185988354304710D-19, &
&   -5.850616732312767D-18,   1.157206626417443D-16,  -3.109105563621312D-15, &
&    6.176962278772727D-14,  -1.131472532434954D-12,   2.324767968626608D-11, &
&   -4.166228408773293D-10,   6.547584199935399D-09,  -1.056283225180483D-07, &
&    1.482568746884877D-06,  -1.516302075808559D-05,   2.303613723658389D-04, &
&   -1.780661346802748D-21,   1.422017292074780D-20,   8.338066678121267D-19, &
&   -5.170821266960184D-18,   4.284805758872475D-17,  -6.311927082409521D-15, &
&    1.201790412901852D-13,  -2.076178641343090D-12,   6.413233002908350D-11, &
&   -1.391699148741257D-09,   2.541685177120574D-08,  -5.361894544897579D-07, &
&    9.456587205030436D-06,  -1.249882877953644D-04,   2.892442484874216D-03, &
&   -7.891564742044090D-21,   5.258488404403214D-20,   1.851320980825274D-18, &
&    2.394322824497916D-18,  -2.537287904580001D-16,  -8.720675130756508D-15, &
&    1.214723232022042D-13,  -1.176019352213715D-12,   8.672170068810394D-11, &
&   -2.242427682149963D-09,   4.751510798451577D-08,  -1.298937535784531D-06, &
&    2.858357567631839D-05,  -5.257347675660436D-04,   1.776286123158718D-02, &
&   -4.416245666755108D-21,   1.824940878260500D-20,   8.208957789905559D-19, &
&    3.103601446116918D-18,  -1.263938027494039D-16,  -3.499203689965034D-15, &
&    4.502727012292937D-14,  -5.521470562457339D-13,   4.671044098848645D-11, &
&   -1.501326210810312D-09,   4.406073233022527D-08,  -1.439163222083633D-06, &
&    4.219997585520921D-05,  -1.249109019062373D-03,   5.751619200999699D-02, &
&    1.511324968339569D-20,  -1.011890441270445D-19,  -3.218373459590251D-18, &
&   -1.099398451821693D-17,   6.617595319740138D-16,   1.006237648584441D-14, &
&   -4.451831806980290D-14,  -3.030052619390119D-12,  -1.181077710530432D-11, &
&    2.556143063093493D-11,   2.472611705626130D-08,  -6.994525432344081D-07, &
&    3.594413409477145D-05,  -1.852912835056625D-03,   1.024904568256252D-01, &
&    4.216835600440838D-24,  -3.513465190008291D-23,   5.160114886747247D-22, &
&   -7.823796351673083D-21,   1.079549143675300D-19,  -1.386899279139460D-18, &
&    1.650232442362419D-17,  -1.810638345737175D-16,   1.818694482721760D-15, &
&   -1.647763128404626D-14,   1.328425214579028D-13,  -9.429042407212258D-13, &
&    5.647302413904972D-12,  -2.544176305919592D-11,   1.065609575638678D-10, &
&    2.456483198007624D-23,  -2.598323936247678D-22,   4.527625817720024D-21, &
&   -8.105765327517384D-20,   1.435592808481677D-18,  -2.347922506784244D-17, &
&    3.536940926798438D-16,  -5.180682017403989D-15,   7.166277153376401D-14, &
&   -8.873810511086692D-13,   1.014952621097259D-11,  -1.101164894486054D-10, &
&    1.006426226113073D-09,  -6.672265691887255D-09,   6.089948288894883D-08, &
&    6.748814614310650D-23,  -1.607075437561833D-21,   1.933515481106652D-20, &
&   -3.611328416748329D-19,   1.101937123097833D-17,  -2.075865032265468D-16, &
&    3.329421441349766D-15,  -6.622839071677055D-14,   1.214096643483137D-12, &
&   -1.784415179745380D-11,   2.614815372993243D-10,  -3.965032321601174D-09, &
&    4.733771208832329D-08,  -4.024848733560144D-07,   6.138264471814076D-06, &
&    2.273298789688276D-22,  -1.357793336479318D-20,  -3.216020462618031D-20, &
&    6.257058753006007D-19,   6.316467451309792D-17,  -9.841720115605990D-16, &
&    9.611081912768169D-15,  -3.835046481406815D-13,   9.506623192283242D-12, &
&   -1.447276937112901D-10,   2.636926514642799D-09,  -5.453185073329440D-08, &
&    7.965123037547531D-07,  -8.552128181121636D-06,   1.958074021347009D-04, &
&    2.719115321983786D-21,  -8.289032492761186D-20,  -7.375310272614268D-19, &
&    1.137436674712167D-17,   3.013464853898040D-16,  -2.779590367249281D-15, &
&   -2.211544676013033D-14,  -1.071276144551095D-12,   3.723233443881852D-11, &
&   -5.100418241721718D-10,   1.173103739873496D-08,  -3.264363906376084D-07, &
&    5.696925947251674D-06,  -8.045985095311215D-05,   2.589873251357656D-03, &
&    1.067374442500146D-20,  -2.110400634744353D-19,  -2.436567040533628D-18, &
&    3.222605236750301D-17,   7.527461539017076D-16,  -4.421401263351829D-15, &
&   -1.298283426776646D-13,  -1.470559881992168D-12,   7.012946868037541D-11, &
&   -8.203729039205822D-10,   2.486578110855588D-08,  -8.860155614264616D-07, &
&    1.895459205091180D-05,  -3.849591734147515D-04,   1.641120287030284D-02, &
&    6.799746334150649D-21,  -7.996804970879212D-20,  -1.208110531468120D-18, &
&    1.175540627921226D-17,   3.296803038173642D-16,  -1.445599490539459D-15, &
&   -5.542718919070426D-14,  -7.757291188057893D-13,   3.728057525435538D-11, &
&   -7.377766918927914D-10,   2.745874671090504D-08,  -1.021523211316182D-06, &
&    3.127597682325758D-05,  -1.030550202634733D-03,   5.411304449000876D-02, &
&   -2.004646372021504D-20,   3.827907690568353D-19,   4.571160167252935D-18, &
&   -6.068994854878753D-17,  -1.313552502121511D-15,   5.715109026336747D-15, &
&    3.126500489903191D-13,   3.572494359021748D-13,  -5.612675063457402D-11, &
&   -6.934601730693014D-10,   2.078957198002086D-08,  -4.152493340191458D-07, &
&    3.096141432823486D-05,  -1.653485227466972D-03,   9.723832404006094D-02, &
&    3.438032827210873D-25,  -2.877219828660015D-24,   4.458671306757086D-23, &
&   -7.262660712676352D-22,   1.057999140112793D-20,  -1.431755627803058D-19, &
&    1.849243130151409D-18,  -2.247974945393828D-17,   2.484881619246024D-16, &
&   -2.494650115666358D-15,   2.341984643510834D-14,  -2.016800343800242D-13, &
&    1.424171578443744D-12,  -7.391202153885668D-12,   6.337519327610520D-11, &
&    4.031928550883053D-24,  -1.665257415922139D-23,   5.270243146459235D-22, &
&   -1.487162154142251D-20,   2.344726925763313D-19,  -3.460150799169615D-18, &
&    6.603133364566393D-17,  -1.172704061157595D-15,   1.641343034851483D-14, &
&   -2.146037479766692D-13,   3.077352840704232D-12,  -4.049520679116483D-11, &
&    3.902146490963269D-10,  -2.787006775576635D-09,   4.761669761109788D-08, &
&    3.516637822965854D-23,   7.420265835677032D-22,   2.552690706982452D-21, &
&   -2.763780145136699D-19,   2.212709463207588D-18,  -1.060759471676046D-17, &
&    9.547621634013227D-16,  -2.546516065546385D-14,   3.463392367808305D-13, &
&   -5.017127340105087D-12,   1.091278667451058D-10,  -1.930216962278913D-09, &
&    2.214620178977325D-08,  -2.030212001587124D-07,   5.267395851554798D-06, &
&   -6.099922819923323D-23,   1.666525942837964D-20,   2.985660331083081D-20, &
&   -3.866962730971774D-18,   3.965793398607787D-18,   4.733112090352991D-16, &
&    6.784439551197413D-15,  -2.707125934538664D-13,   2.721612712579384D-12, &
&   -3.768284368979455D-11,   1.421197713831158D-09,  -3.178046012532294D-08, &
&    4.187744460962045D-07,  -5.007214624776352D-06,   1.760318296669992D-04, &
&   -2.889407797096111D-21,   1.192923940444535D-19,   3.510932213141483D-19, &
&   -2.587161872880040D-17,  -4.944743561883913D-17,   4.616286082383015D-15, &
&    2.789003842016663D-14,  -1.443048837915990D-12,   8.514343799614808D-12, &
&   -8.371555910659662D-11,   7.934866120916021D-09,  -2.148834896814111D-07, &
&    3.293960853735199D-06,  -5.398336113848242D-05,   2.391803142320691D-03, &
&   -1.174422952409741D-20,   3.112543847243443D-19,   1.265604331491700D-18, &
&   -6.737285619747028D-17,  -2.171351227818130D-16,   1.324210692823312D-14, &
&    6.014156666323619D-14,  -3.371430964252169D-12,   1.069441893945896D-11, &
&   -2.606369082041563D-11,   1.989467743616670D-08,  -6.295773786087422D-07, &
&    1.217665355625360D-05,  -2.927084133183245D-04,   1.540485605402326D-02, &
&   -7.360965511472545D-21,   1.183222429666272D-19,   7.494462556637251D-19, &
&   -2.638472796650983D-17,  -1.240064282177670D-16,   5.323874181793982D-15, &
&    3.054641399240724D-14,  -1.482232345593844D-12,   9.667617569583779D-12, &
&   -2.902997048678030D-10,   2.038761300246187D-08,  -7.412355805393223D-07, &
&    2.340603722183974D-05,  -8.677593123625493D-04,   5.127736653527257D-02, &
&    2.211805873562640D-20,  -5.678439338814172D-19,  -2.350460357361959D-18, &
&    1.222520606970661D-16,   4.324464095196598D-16,  -2.516600429072161D-14, &
&   -7.795533005144688D-14,   5.044331104798248D-12,   1.810799059266370D-11, &
&   -1.195625366338155D-09,   4.870130539111728D-09,  -2.532623549185122D-07, &
&    2.809960248882938D-05,  -1.477038539283506D-03,   9.254678674243219D-02, &
&    2.727118434488782D-26,  -3.066501614782515D-25,   4.863695145646052D-24, &
&   -7.122281371615786D-23,   1.100573261865830D-21,  -1.799684229727521D-20, &
&    2.653245243949043D-19,  -3.343343603352354D-18,   3.906620040792428D-17, &
&   -4.715351031432236D-16,   5.616797602479849D-15,  -5.616005692579015D-14, &
&    4.163239942496786D-13,  -2.499350537472066D-12,   5.000639357670395D-11, &
&   -4.404645745866349D-26,  -1.609009037865349D-23,   1.982198390613727D-22, &
&   -2.677394322379265D-22,   1.322415722983755D-20,  -9.801229720318890D-19, &
&    2.066368608784020D-17,  -2.527911708878647D-16,   3.229951805206553D-15, &
&   -6.606855576674831D-14,   1.261142360554221D-12,  -1.660839969496708D-11, &
&    1.490803320920389D-10,  -1.274714874022562D-09,   4.188113270396550D-08, &
&   -5.456137779510616D-24,  -7.298301848587554D-22,   5.390645243463991D-21, &
&    9.909439535920273D-20,  -1.016060354940137D-18,  -2.783878326381004D-17, &
&    6.579221492385564D-16,  -4.782216050836103D-15,   3.932699187405910D-14, &
&   -2.207139642859179D-12,   6.180965329360569D-11,  -9.447456149358569D-10, &
&    9.622411658161498D-09,  -1.121146152856476D-07,   4.813355333221221D-06, &
&    9.429406914014288D-23,  -1.309113641234018D-20,   6.664896980224566D-20, &
&    2.330998506666558D-18,  -2.412905829520367D-17,  -4.206716585084112D-16, &
&    9.422284987826990D-15,  -2.118204063972892D-14,  -4.703557859434609D-13, &
&   -2.564744322304824D-11,   1.018643191045911D-09,  -1.729678401809572D-08, &
&    2.014189984674230D-07,  -3.211680812006239D-06,   1.640284888950357D-04, &
&    1.717533807943204D-21,  -9.102379315668198D-20,   3.486425582127516D-19, &
&    1.764402666975223D-17,  -1.733325334865659D-16,  -2.869927949635590D-15, &
&    5.958631818003884D-14,   5.835066108663571D-14,  -7.423382728625163D-12, &
&   -1.241687429291865D-10,   6.740753719396669D-09,  -1.260682325676904D-07, &
&    1.769763071530011D-06,  -3.919260394385466D-05,   2.254322551360202D-03, &
&    6.445778165827516D-21,  -2.364596226928548D-19,   7.125019610683187D-19, &
&    4.777896593683334D-17,  -4.458879669646270D-16,  -7.627254583188206D-15, &
&    1.498285225813135D-13,   3.999785350486929D-13,  -2.438308201620503D-11, &
&   -2.762947040750952D-10,   1.843388662227361D-08,  -3.954605907498927D-07, &
&    7.575663692138527D-06,  -2.345088715155256D-04,   1.462092829675305D-02, &
&    3.835056529347371D-21,  -8.999356390720075D-20,   1.431116744107764D-19, &
&    1.927665894818948D-17,  -1.595564307381234D-16,  -3.224749556831262D-15, &
&    6.002974078725709D-14,   1.152293719332276D-13,  -5.928958488220191D-12, &
&   -3.103242320398757D-10,   1.623945381050387D-08,  -5.210073852298978D-07, &
&    1.776263125399567D-05,  -7.452448177947715D-04,   4.886631452614746D-02, &
&   -1.206160831036102D-20,   4.308766042418049D-19,  -1.261691746235491D-18, &
&   -8.764276004638671D-17,   8.216559201726320D-16,   1.355493455116242D-14, &
&   -2.580042637314714D-13,  -1.305597434878851D-12,   6.511055098520359D-11, &
&   -2.313964486541897D-10,  -6.925287876748924D-09,  -2.807225733757591D-07, &
&    2.580482333021454D-05,  -1.315187813310943D-03,   8.836185667801294D-02, &
&    3.747042387163168D-27,  -1.618630435189411D-26,   2.863021002702367D-25, &
&   -9.431213209078814D-24,   2.021257082905230D-22,  -3.016980333403838D-21, &
&    3.658850702293882D-20,  -4.826101678757317D-19,   8.059136302292502D-18, &
&   -1.328404083891322D-16,   1.741225793549752D-15,  -1.684196819523340D-14, &
&    1.215428141651572D-13,  -1.058429776385916D-12,   4.510192245168085D-11, &
&    3.040739020422944D-25,   3.378041095408163D-24,  -5.661553120773878D-23, &
&   -5.137582552122509D-22,   2.521399276588973D-20,  -3.333216641772947D-19, &
&    1.789552895474522D-18,  -1.927775239594711D-17,   1.176735003200691D-15, &
&   -3.353465507858937D-14,   5.566777831799393D-13,  -6.168405789763640D-12, &
&    5.285109767607954D-11,  -7.154883904442229D-10,   3.903830102760254D-08, &
&    1.117211934544605D-23,   2.474196321178266D-22,  -3.982202893963765D-21, &
&   -1.847915868767341D-20,   1.212984239397142D-18,  -1.263185423812158D-17, &
&   -5.081332085772036D-17,   1.537336883516061D-15,   3.642916166194956D-14, &
&   -1.717906827999256D-12,   3.229396781952991D-11,  -3.868933122415550D-10, &
&    3.895929299526195D-09,  -7.406405289556054D-08,   4.542597246267323D-06, &
&    1.439711431139700D-22,   4.814362075279291D-21,  -7.319108236034226D-20, &
&   -3.482965578454093D-19,   2.159574265997724D-17,  -1.920046198435995D-16, &
&   -2.104937026052074D-15,   5.117958270412998D-14,   3.567110063815778D-13, &
&   -2.884362427663933D-11,   5.889922311169102D-10,  -7.596651305581499D-09, &
&    9.330498377135582D-08,  -2.371210779081429D-06,   1.558151453748503D-04, &
&    7.213421110229018D-22,   3.433707789081328D-20,  -4.981846645594332D-19, &
&   -2.656511749678462D-18,   1.504572559402229D-16,  -1.225346140564893D-15, &
&   -1.853640178319367D-14,   4.391776380915298D-13,   1.277061307531698D-12, &
&   -1.907132342756850D-10,   4.167354994897016D-09,  -5.958876509338073D-08, &
&    9.578609067542925D-07,  -3.130982971075006D-05,   2.149779636302693D-03, &
&    1.357410384558839D-21,   9.032784614206326D-20,  -1.264322308613903D-18, &
&   -7.447787637497809D-18,   3.933921383201391D-16,  -3.054943141081389D-15, &
&   -5.322485522450104D-14,   1.250590146640131D-12,   1.977964267469464D-12, &
&   -5.026181298512688D-10,   1.195730582672123D-08,  -2.096474002091520D-07, &
&    4.912142002304415D-06,  -1.978847600511221D-04,   1.397631513923808D-02, &
&    1.581757068297143D-22,   3.502521724844511D-20,  -4.570731615924497D-19, &
&   -3.279128196958339D-18,   1.535393920343338D-16,  -1.155207964446870D-15, &
&   -2.082506111824643D-14,   4.491768994025516D-13,   3.577666081963505D-12, &
&   -3.410762036032490D-10,   1.112358215085849D-08,  -3.563403635862120D-07, &
&    1.386103675111649D-05,  -6.511152656457316D-04,   4.677761279573840D-02, &
&   -2.385143401947993D-21,  -1.648903521213220D-19,   2.301805462785652D-18, &
&    1.356199085792297D-17,  -7.131046891710974D-16,   5.370729528575474D-15, &
&    1.050221166398700D-13,  -2.586465825063549D-12,   8.080005465887251D-12, &
&    4.638542624555984D-10,  -3.824147434359263D-09,  -3.557524219577859D-07, &
&    2.291027346089985D-05,  -1.168695369539425D-03,   8.464038317815642D-02, &
&   -2.147793577618372D-30,  -4.388363442005375D-27,   1.337822027026467D-25, &
&   -2.172996156333517D-24,   2.336788939091905D-23,  -2.295528149895541D-22, &
&    4.670480254301146D-21,  -1.316151420859422D-19,   2.850799257650256D-18, &
&   -4.481670896965314D-17,   5.205917949494101D-16,  -4.562053729692089D-15, &
&    3.601327017008617D-14,  -6.398703317504642D-13,   4.267955509948812D-11, &
&   -1.386712026333352D-25,  -3.711635571751400D-25,   2.782447225291828D-23, &
&   -4.123362954606697D-22,   1.411639526867827D-21,   4.656887390326834D-20, &
&   -3.588903149543227D-19,  -2.236005854776395D-17,   8.148804337510175D-16, &
&   -1.538624130956808D-14,   1.976029218552097D-13,  -1.915781790566741D-12, &
&    1.969005637761123D-11,  -5.167556256627584D-10,   3.723871299235791D-08, &
&   -8.543119237385926D-24,  -1.766101922574475D-23,   1.563265628593826D-21, &
&   -2.180297103676981D-20,  -4.992373528085565D-21,   5.044649449616260D-18, &
&   -6.353261976104656D-17,  -7.811246573071522D-16,   4.412296097780855D-14, &
&   -9.139718848877504D-13,   1.238441055802418D-11,  -1.311265714140644D-10, &
&    1.744329973896223D-09,  -5.828305629634107D-08,   4.347250095543258D-06, &
&   -1.536350956270945D-22,  -3.426024678227427D-22,   2.877020208231671D-20, &
&   -3.899183998266962D-19,  -6.987667965650288D-19,   1.113978194037619D-16, &
&   -1.551658303907294D-15,  -8.910273170932332D-15,   7.630199544294391D-13, &
&   -1.677165332730114D-11,   2.379326033338333D-10,  -2.822295170073262D-09, &
&    4.959519829000778D-08,  -1.963823976113847D-06,   1.493772032414151D-04, &
&   -1.038329029392836D-21,  -2.555190351068980D-21,   2.009325554045581D-19, &
&   -2.684884081170816D-18,  -6.732596757922252D-18,   8.383371189705353D-16, &
&   -1.222005374065839D-14,  -3.989156722752940D-14,   5.103982014615174D-12, &
&   -1.175048127319111D-10,   1.771456073217546D-09,  -2.510224352611167D-08, &
&    5.984646261828360D-07,  -2.679499196170760D-05,   2.063154965041615D-03, &
&   -2.625397685286932D-21,  -6.998347174249574D-21,   5.226867511516030D-19, &
&   -6.931501452102825D-18,  -1.982191350093224D-17,   2.260049822205602D-15, &
&   -3.369648234197039D-14,  -7.518459237612825D-14,   1.323683348581479D-11, &
&   -3.221552937681386D-10,   5.523569350141651D-09,  -1.076019431049305D-07, &
&    3.542865489551183D-06,  -1.729763345919577D-04,   1.342205985188987D-02, &
&   -9.445058601532059D-22,  -2.931377556356578D-21,   1.995107137038321D-19, &
&   -2.625942057421029D-18,  -8.143921078406746D-18,   8.782171828904839D-16, &
&   -1.278906834643806D-14,  -6.195783353510416D-14,   7.203947809560859D-12, &
&   -2.272682009059941D-10,   6.781585648090247D-09,  -2.506676574780882D-07, &
&    1.116871980239381D-05,  -5.764999207673080D-04,   4.494021670777687D-02, &
&    4.772814315201576D-21,   1.279975598107938D-20,  -9.516530373774151D-19, &
&    1.257928527422261D-17,   3.847238693952669D-17,  -4.219190355061853D-15, &
&    6.552823128989060D-14,  -2.986671871343117D-14,  -1.725491069841928D-11, &
&    2.975587632286370D-10,   2.445933143928413D-09,  -3.612720306727292D-07, &
&    1.962623417692433D-05,  -1.041063582419181D-03,   8.133068816567086D-02, &
&    1.491386095899956D-28,  -1.229936745444721D-27,   9.966717239623427D-27, &
&   -6.459806868726246D-27,  -1.330577932914677D-25,  -5.217897911413420D-23, &
&    2.284061236326653D-21,  -5.592716633263354D-20,   9.705443719817475D-19, &
&   -1.276469396853344D-17,   1.306578970693055D-16,  -1.128368832896973D-15, &
&    1.384058938258070D-14,  -5.053365795095345D-13,   4.099398313425506D-11, &
&    4.194399333322692D-26,  -3.374769672811094D-25,   1.088006642976653D-24, &
&    6.475924257134018D-23,  -1.527309420036297D-21,   6.299233244668987D-21, &
&    5.144568527819480D-19,  -1.790653214240625D-17,   3.542019769149228D-16, &
&   -5.022188457771242D-15,   5.507757789626655D-14,  -5.546633562616669D-13, &
&    9.836679088225627D-12,  -4.341611805845853D-10,   3.582674122677299D-08, &
&    2.453567674790883D-24,  -1.988513354633102D-23,   4.125713456290371D-23, &
&    4.995140139213210D-21,  -1.224422047892238D-19,   9.627619308515406D-19, &
&    2.327491215435916D-17,  -1.020552278236010D-15,   2.151965333055103D-14, &
&   -3.172439075025090D-13,   3.675520046435919D-12,  -4.373364240589417D-11, &
&    1.034880742396088D-09,  -5.033061672534306D-08,   4.185370657467387D-06, &
&    4.510548477662610D-23,  -3.679772107213209D-22,   6.479120402898414D-22, &
&    1.004087311819265D-19,  -2.525568085594892D-18,   2.333846921673615D-17, &
&    3.496451619034192D-16,  -1.815421052683666D-14,   3.984466759889993D-13, &
&   -6.061046536392349D-12,   7.525291688671029D-11,  -1.104569132161574D-09, &
&    3.337272799362585D-08,  -1.722504444856022D-06,   1.438716118280357D-04, &
&    3.127132516713285D-22,  -2.563160929662972D-21,   4.292398614807714D-21, &
&    7.234167572551490D-19,  -1.850590681758937D-17,   1.840585307924844D-16, &
&    2.091435133103972D-15,  -1.231529892430466D-13,   2.787703080620417D-12, &
&   -4.410601299648391D-11,   6.142156444623521D-10,  -1.189599020648666D-08, &
&    4.422869212534804D-07,  -2.373116590972911D-05,   1.987596913600312D-03, &
&    8.075147556754625D-22,  -6.641632713864022D-21,   1.103893621974459D-20, &
&    1.904486855036360D-18,  -4.927241560865506D-17,   5.093800485378708D-16, &
&    4.937387105726201D-15,  -3.181149304334166D-13,   7.476815054357042D-12, &
&   -1.287443973540768D-10,   2.278770757447292D-09,  -6.370916145409640D-08, &
&    2.800916524698329D-06,  -1.541398693705226D-04,   1.293248981692049D-02, &
&    3.031974355000343D-22,  -2.512253530027407D-21,   4.366846146310540D-21, &
&    7.288538410987796D-19,  -1.910366302644348D-17,   1.986836710049138D-16, &
&    2.207362086444326D-15,  -1.493474195335247D-13,   4.352575102409009D-12, &
&   -1.207639185030680D-10,   4.238351956632116D-09,  -1.861527466046448D-07, &
&    9.225794273147471D-06,  -5.156052487110746D-04,   4.330496652791410D-02, &
&   -1.470253881399842D-21,   1.208842055203927D-20,  -1.965995298663290D-20, &
&   -3.494286513852626D-18,   9.094220455341492D-17,  -9.787962782033947D-16, &
&   -6.836144027906864D-15,   4.855562891870243D-13,  -9.417411364594809D-12, &
&    4.249931781305358D-11,   4.806267030047621D-09,  -3.138895167888928D-07, &
&    1.656711701211391D-05,  -9.327002489468329D-04,   7.837463731531004D-02, &
&    1.904080121140014D-29,   8.850508406358885D-29,  -2.051227621610245D-27, &
&    8.510167400766782D-27,   9.363316200744366D-25,  -3.917322217362513D-23, &
&    9.657303615552115D-22,  -1.765280503684910D-20,   2.540829915698956D-19, &
&   -2.944062515658534D-18,   2.870851927273183D-17,  -3.158827699858625D-16, &
&    8.230638904092712D-15,  -4.426511268734833D-13,   3.958015337842845D-11, &
&    1.370538237659143D-27,   4.388947148429156D-26,  -1.425845893141537D-24, &
&    1.955692409742475D-23,   6.859939657357869D-23,  -1.118086662182550D-20, &
&    3.383685117928032D-19,  -6.779408986029454D-18,   1.033289698013180D-16, &
&   -1.260399984755319D-15,   1.356351629405554D-14,  -1.981686982923294D-13, &
&    6.812502851521234D-12,  -3.857684600966933D-10,   3.460127525068915D-08, &
&    8.774853961876667D-26,   2.952610146467045D-24,  -1.006007904918667D-22, &
&    1.563644964473255D-21,  -2.791076054631651D-21,  -5.920434636447344D-19, &
&    2.006663911495462D-17,  -4.201824244191540D-16,   6.596121706909542D-15, &
&   -8.360904842034058D-14,   1.003849160046920D-12,  -1.910309911887177D-11, &
&    7.755588063517698D-10,  -4.500705725266529D-08,   4.042746173672765D-06, &
&    1.752251822196815D-24,   5.620008312039580D-23,  -1.977767121985324D-21, &
&    3.243690068805070D-20,  -1.216537460417321D-19,  -1.000545563509226D-17, &
&    3.648420603034936D-16,  -7.852113680531329D-15,   1.261346072185595D-13, &
&   -1.675018436448552D-12,   2.335336260795355D-11,  -5.777026710181773D-10, &
&    2.625858904199785D-08,  -1.545923494745454D-06,   1.389795057171475D-04, &
&    1.287024364229140D-23,   3.931358808379136D-22,  -1.413898847548578D-20, &
&    2.388570359354247D-19,  -1.135389250629993D-18,  -6.530218349970494D-17, &
&    2.504240530587792D-15,  -5.505323411596883D-14,   9.092580036944876D-13, &
&   -1.305867648363831D-11,   2.277587899368866D-10,  -7.303075664903663D-09, &
&    3.592931336450945D-07,  -2.134668345770090D-05,   1.920103619412347D-03, &
&    3.460717672851199D-23,   1.016269410646417D-21,  -3.711315840859917D-20, &
&    6.385109738724433D-19,  -3.400151277805683D-18,  -1.625699672929313D-16, &
&    6.475943252626376D-15,  -1.462104766499346D-13,   2.563337754486378D-12, &
&   -4.401444632930309D-11,   1.093752566147949D-09,  -4.472780092985349D-08, &
&    2.323416075613194D-06,  -1.388511659718074D-04,   1.249371640044214D-02, &
&    1.401988889803960D-23,   3.791089568666909D-22,  -1.422460228198701D-20, &
&    2.502896248586110D-19,  -1.426158845472201D-18,  -6.460397861221627D-17, &
&    2.805837316286819D-15,  -7.547836543811327D-14,   1.977006459401241D-12, &
&   -6.620953190417986D-11,   2.889548607859577D-09,  -1.441963152438297D-07, &
&    7.751266401481410D-06,  -4.648621436091380D-04,   4.183647363075534D-02, &
&   -6.305472552256615D-23,  -1.854336927037892D-21,   6.786424110483012D-20, &
&   -1.176178591002762D-18,   6.769694068460343D-18,   2.707030404384412D-16, &
&   -1.062837123159117D-14,   2.109620698402561D-13,  -1.993418629219882D-12, &
&   -5.114560592503933D-11,   4.573976805616737D-09,  -2.562310505466139D-07, &
&    1.400396673923409D-05,  -8.412476893115818D-04,   7.571755937684432D-02, &
&   -3.206673391829193D-29,   1.848534738392820D-29,   3.837619558048911D-28, &
&   -1.692046162756367D-26,   5.905395824708627D-25,  -1.426905261102640D-23, &
&    2.703680776756262D-22,  -4.185458161936367D-21,   5.375679113410230D-20, &
&   -5.890654336050420D-19,   6.587463397945128D-18,  -1.381963215359044D-16, &
&    6.378593206752170D-15,  -3.995928132096888D-13,   3.831950913684305D-11, &
&   -1.507547003889810D-27,   1.500134525194146D-26,  -1.052829486969240D-25, &
&   -3.827857929580154D-24,   1.961783085830274D-22,  -5.353677418293496D-21, &
&    1.083297782217917D-19,  -1.753386858403974D-18,   2.344708140235119D-17, &
&   -2.755761425336996D-16,   3.797240620794737D-15,  -1.083108458839747D-13, &
&    5.518118825843427D-12,  -3.491682583873576D-10,   3.350078671587879D-08, &
&   -1.022681191810206D-25,   1.083549422082964D-24,  -1.038786210993850D-23, &
&   -1.657332776841431D-22,   1.125707228298171D-20,  -3.271210839334015D-19, &
&    6.831971060960545D-18,  -1.131720274163393D-16,   1.558251861441437D-15, &
&   -1.978721748918740D-14,   3.391866011169741D-13,  -1.197364502100475D-11, &
&    6.414979302667631D-10,  -4.078714469109021D-08,   3.914254251980441D-06, &
&   -1.962495699795648D-24,   2.160815676475731D-23,  -2.320757032673311D-22, &
&   -2.348964054915528D-21,   2.001687801053596D-19,  -6.046103928179635D-18, &
&    1.287924006947822D-16,  -2.171927037856578D-15,   3.095026849188093D-14, &
&   -4.385675046624823D-13,   9.597521473237021D-12,  -3.980143218033987D-10, &
&    2.198792754184404D-08,  -1.401976531196317D-06,   1.345640261290174D-04, &
&   -1.384119097638956D-23,   1.558947955528981D-22,  -1.774687785745162D-21, &
&   -1.317204701273949D-20,   1.350833041928412D-18,  -4.188662256905691D-17, &
&    9.061685067979968D-16,  -1.560785679280179D-14,   2.356434239137724D-13, &
&   -3.987195639015460D-12,   1.147613419972869D-10,  -5.380342324800636D-09, &
&    3.032082457464966D-07,  -1.936771388924499D-05,   1.859115856963765D-03, &
&   -3.602335273539886D-23,   4.118004352948752D-22,  -4.853171449210141D-21, &
&   -2.877731436426571D-20,   3.430023641859482D-18,  -1.086288711022675D-16, &
&    2.397576363652435D-15,  -4.321136991785894D-14,   7.490454895587490D-13, &
&   -1.742399674549193D-11,   6.729936700607165D-10,  -3.451654852273942D-08, &
&    1.970531893904784D-06,  -1.260149261048262D-04,   1.209694548312359D-02, &
&   -1.364301613799573D-23,   1.597759447335753D-22,  -1.968436458765487D-21, &
&   -8.869994855109421D-21,   1.328862975222340D-18,  -4.525472293510716D-17, &
&    1.153464316450920D-15,  -2.923361746854072D-14,   9.482918998392609D-13, &
&   -4.132997965901403D-11,   2.105827362022070D-09,  -1.145929197595643D-07, &
&    6.593727498713241D-06,  -4.219600468827007D-04,   4.050797455480790D-02, &
&    6.568520050145903D-23,  -7.529489897916245D-22,   8.976254289873836D-21, &
&    4.643448842938040D-20,  -5.974196185233696D-18,   1.846088648624111D-16, &
&   -3.701500268861937D-15,   4.469787594526117D-14,   3.938184203995495D-13, &
&   -6.034336096212882D-11,   3.685445854978019D-09,  -2.065520924811497D-07, &
&    1.192953258310330D-05,  -7.636708508514797D-04,   7.331329077892858D-02, &
&   -2.515503985246891D-29,  -3.605455129684453D-30,   4.264177196638760D-28, &
&   -7.547681671033449D-27,   1.791688900893413D-25,  -3.520347755379000D-24, &
&    5.809024214171332D-23,  -8.153862840614644D-22,   9.929085249921023D-21, &
&   -1.184746359448085D-19,   2.228423543270701D-18,  -9.205669440539781D-17, &
&    5.380010067478315D-15,  -3.645186675412919D-13,   3.717482873716702D-11, &
&   -1.924874704553483D-28,  -4.542990719487410D-28,   7.553525384350561D-26, &
&   -2.754476990752296D-24,   7.104964103017406D-23,  -1.461508377938295D-21, &
&    2.498464236242421D-20,  -3.624039623198680D-19,   4.658285105917324D-18, &
&   -6.513236703530360D-17,   1.649395691629083D-15,  -7.866185430714355D-14, &
&    4.695350560729488D-12,  -3.186585911203347D-10,   3.250027510330686D-08, &
&   -1.460105419305647D-26,   7.778688231559389D-27,   4.128315108476887D-24, &
&   -1.655829229569930D-22,   4.442801543915148D-21,  -9.358136719382615D-20, &
&    1.630033963190587D-18,  -2.420871783901759D-17,   3.301622789039402D-16, &
&   -5.514671529310143D-15,   1.760975322738148D-13,  -9.087960572599010D-12, &
&    5.481412263183326D-10,  -3.723103047313264D-08,   3.797366604160242D-06, &
&   -3.026698464828474D-25,   5.125800030072622D-25,   7.095486933048293D-23, &
&   -3.026615357057518D-21,   8.317612217688510D-20,  -1.778374189459185D-18, &
&    3.142934005515373D-17,  -4.797309925163545D-16,   7.126358049402562D-15, &
&   -1.477303630904514D-13,   5.718380025659301D-12,  -3.103277785864283D-10, &
&    1.883438158068483D-08,  -1.279900464175120D-06,   1.305459308740021D-04, &
&   -2.236114310975443D-24,   5.149288589827744D-24,   4.670647918639986D-22, &
&   -2.078445847076749D-20,   5.805808333090814D-19,  -1.256225487839352D-17, &
&    2.258538466800421D-16,  -3.609612811993733D-15,   6.196364716132984D-14, &
&   -1.676679898345206D-12,   7.606451982514394D-11,  -4.268953901883879D-09, &
&    2.601279725441917D-07,  -1.768267669025748D-05,   1.803604789892415D-03, &
&   -5.995701153611725D-24,   1.601663266891636D-23,   1.161794278886647D-21, &
&   -5.333592512880974D-20,   1.510709718254536D-18,  -3.321488299171188D-17, &
&    6.196481203478552D-16,  -1.108766862080619D-14,   2.524019579398690D-13, &
&   -9.397119838229952D-12,   4.826813382448137D-10,  -2.769997629336902D-08, &
&    1.692251072715841D-06,  -1.150571471712026D-04,   1.173575428883884D-02, &
&   -2.381721282157880D-24,   7.562717273831683D-24,   4.202376716209537D-22, &
&   -2.057718106955319D-20,   6.182010584619122D-19,  -1.536198052992517D-17, &
&    3.860634432728873D-16,  -1.237958395719512D-14,   5.431459213196364D-13, &
&   -2.842771895944857D-11,   1.591618196165342D-09,  -9.260023143436883D-08, &
&    5.665970157735975D-06,  -3.852797488189030D-04,   3.929850511577003D-02, &
&    1.097719776202252D-23,  -3.047041555516168D-23,  -2.059838285129498D-21, &
&    9.445471897201745D-20,  -2.613503374291506D-18,   5.315193990081323D-17, &
&   -7.321774787779238D-16,  -1.385327473320900D-15,   7.259563616708333D-13, &
&   -4.885867964575980D-11,   2.859505305459865D-09,  -1.674588180861515D-07, &
&    1.025392899504763D-05,  -6.972962254694013D-04,   7.112435133465789D-02, &
&    6.283287147083771D-31,   1.019762172947144D-30,   8.066018814351696D-29, &
&   -1.982579421024510D-27,   3.945676782215336D-26,  -6.903058667552379D-25, &
&    1.048604038298713D-23,  -1.403778768605284D-22,   1.816083360637797D-21, &
&   -3.311237067800282D-20,   1.265559516690834D-18,  -7.231336875763260D-17, &
&    4.648703787491629D-15,  -3.345202952659516D-13,   3.612736478365573D-11, &
&    5.425547172101182D-29,  -9.915239412446500D-28,   3.154474365265132D-26, &
&   -8.019358581785254D-25,   1.688404341756180D-23,  -3.039599507852170D-22, &
&    4.744862489989278D-21,  -6.641208558422141D-20,   9.758244994777377D-19, &
&   -2.337103774297335D-17,   1.064842573545111D-15,  -6.297649042744326D-14, &
&    4.063099165100505D-12,  -2.924532960833798D-10,   3.158455413102788D-08, &
&    1.901619761793041D-27,  -5.825036221326992D-26,   1.965283555402470D-24, &
&   -5.108654643396568D-23,   1.095533072711030D-21,  -2.003215343725470D-20, &
&    3.190246876648741D-19,  -4.688414106469344D-18,   7.994513900344822D-17, &
&   -2.414502747949046D-15,   1.220227722748914D-13,  -7.343999658242502D-12, &
&    4.746745492392619D-10,  -3.417039135095265D-08,   3.690374529508870D-06, &
&    2.958276611000032D-26,  -1.049287098761133D-24,   3.659552290568198D-23, &
&   -9.664755671677699D-22,   2.097165052197587D-20,  -3.882030087390456D-19, &
&    6.327753688769643D-18,  -9.984713231875915D-17,   2.060408660263341D-15, &
&   -7.655969409299735D-14,   4.145666772383805D-12,  -2.521771099477189D-10, &
&    1.631707042931297D-08,  -1.174706868872857D-06,   1.268677916775451D-04, &
&    1.827392606223950D-25,  -7.126641821501139D-24,   2.542335911392522D-22, &
&   -6.788842125442880D-21,   1.487411691157612D-19,  -2.794115714294220D-18, &
&    4.736602119685140D-17,  -8.457187098916998D-16,   2.243825091122525D-14, &
&   -1.000917092732092D-12,   5.683967695203034D-11,  -3.481417700849373D-09, &
&    2.254228057072213D-07,  -1.622955946290075D-05,   1.752788442154769D-03, &
&    4.306414992907357D-25,  -1.811621528683951D-23,   6.571645290116432D-22, &
&   -1.772467270623918D-20,   3.936365733404817D-19,  -7.636073678817747D-18, &
&    1.427773348832339D-16,  -3.287335870543009D-15,   1.208691260439336D-13, &
&   -6.274981333194238D-12,   3.680139469035409D-10,  -2.264193550514480D-08, &
&    1.466739370006236D-06,  -1.056028957769037D-04,   1.140510218455245D-02, &
&    1.352796804528151D-25,  -6.726426422698575D-24,   2.542268671676242D-22, &
&   -7.203621695453095D-21,   1.784184102451263D-19,  -4.536886003373808D-18, &
&    1.468482979536412D-16,  -6.556957709042140D-15,   3.541131415801672D-13, &
&   -2.053222773118655D-11,   1.228628203024867D-09,  -7.579665045593848D-08, &
&    4.911443555330344D-06,  -3.536230178917945D-04,   3.819128177876530D-02, &
&   -7.600272959086027D-25,   3.251319488794647D-23,  -1.172678950760231D-21, &
&    3.095390121705058D-20,  -6.420919504230048D-19,   9.646609490540429D-18, &
&   -1.607886179633455D-17,  -8.073090808785046D-15,   5.976677753369654D-13, &
&   -3.674967598753925D-11,   2.220457402205361D-09,  -1.371612478092392D-07, &
&    8.888884605026667D-06,  -6.400039595337368D-04,   6.912044690068354D-02, &
&   -2.289923474627634D-29,   2.086476084485047D-29,   2.129859029991062D-28, &
&   -5.357803200378352D-28,   6.468826305668891D-27,  -1.158886336067006D-25, &
&    1.696997246783147D-24,  -2.387153320434067D-23,   4.433062613782647D-22, &
&   -1.626441405639640D-20,   9.245709807651073D-19,  -5.941507871000943D-17, &
&    4.058943045158174D-15,  -3.084551827244086D-13,   3.516378530915611D-11, &
&    1.128840531798196D-29,  -3.157538402109592D-28,   7.808014289762582D-27, &
&   -1.692965858633894D-25,   3.204012543894296D-24,  -5.350012662419220D-23, &
&    8.110005043396593D-22,  -1.272363191851206D-20,   3.027432445010908D-19, &
&   -1.347478475077346D-17,   8.029470450926946D-16,  -5.191346618523414D-14, &
&    3.548425944492552D-12,  -2.696683768243532D-10,   3.074214293525972D-08, &
&    1.265174537100999D-27,  -1.985785225753236D-26,   5.008658211523699D-25, &
&   -1.111590063465304D-23,   2.131577057012861D-22,  -3.622447888714919D-21, &
&    5.731150160233237D-20,  -1.024086630970113D-18,   3.047874791240483D-17, &
&   -1.530840707482131D-15,   9.349928591713573D-14,  -6.063798495184371D-12, &
&    4.145942844733014D-10,  -3.150833424042428D-08,   3.591946485310652D-06, &
&    2.357989225622591D-26,  -3.745241355935378D-25,   9.560337117787205D-24, &
&   -2.142061906943838D-22,   4.151885713811571D-21,  -7.204489303674618D-20, &
&    1.213913577846797D-18,  -2.577065961188924D-17,   9.470960196498956D-16, &
&   -5.172383516349453D-14,   3.207681729524814D-12,  -2.084229913205117D-10, &
&    1.425276907753348D-08,  -1.083193917015809D-06,   1.234840344364573D-04, &
&    1.624889762854919D-25,  -2.621033026670235D-24,   6.753805038537587D-23, &
&   -1.525272321115186D-21,   2.995803069800234D-20,  -5.386678931348132D-19, &
&    1.014348461726915D-17,  -2.728521575373706D-16,   1.219222585826373D-14, &
&   -7.065616492079684D-13,   4.425749979338047D-11,  -2.879198940801234D-09, &
&    1.969128724260712D-07,  -1.496525850453708D-05,   1.706038946301863D-03, &
&    4.179244882227270D-25,  -6.808219300740206D-24,   1.769375241667109D-22, &
&   -4.043961415818212D-21,   8.181774663275853D-20,  -1.609680368122862D-18, &
&    3.836926800307742D-17,  -1.427173824538827D-15,   7.558276700303111D-14, &
&   -4.563565507896871D-12,   2.877251404598456D-10,  -1.873300474137942D-08, &
&    1.281272951871797D-06,  -9.737642611039279D-05,   1.110091118533347D-02, &
&    1.581998161114255D-25,  -2.644331991851486D-24,   7.190064890722065D-23, &
&   -1.818972515718761D-21,   4.754810181190713D-20,  -1.583154251392538D-18, &
&    7.281878890004223D-17,  -4.075788174040863D-15,   2.455072576721812D-13, &
&   -1.521283805233762D-11,   9.629703078266011D-10,  -6.272661988338844D-08, &
&    4.290475396065844D-06,  -3.260760046593273D-04,   3.717266398177066D-02, &
&   -7.542633076145529D-25,   1.219623919149734D-23,  -3.103965544509040D-22, &
&    6.656992704126574D-21,  -1.065628935964442D-19,   3.794757948240830D-19, &
&    8.427107405010157D-17,  -6.775357284057953D-15,   4.378342706873670D-13, &
&   -2.747400017232631D-11,   1.742393191783412D-09,  -1.135231440840390D-07, &
&    7.765100902391060D-06,  -5.901482494313813D-04,   6.727690297481036D-02, &
&    9.991082393352875D-30,   2.104936062353478D-29,  -9.322064533669249D-29, &
&   -2.227957327839082D-28,   1.491979043619599D-27,  -1.734001485600546D-26, &
&    2.714618626414728D-25,  -5.305623982604705D-24,   1.935794065511252D-22, &
&   -1.108617244498073D-20,   7.248117275400014D-19,  -4.959483435662742D-17, &
&    3.570186792672300D-15,  -2.856119164809359D-13,   3.427341725942499D-11, &
&    3.037667889863407D-30,  -5.553729301768945D-29,   1.490352451086908D-27, &
&   -2.972243601013509D-26,   5.268350414239648D-25,  -8.605991364053986D-24, &
&    1.452145899757131D-22,  -3.555879568264525D-21,   1.583499067377948D-19, &
&   -9.599511518013965D-18,   6.330219470533346D-16,  -4.335497569432035D-14, &
&    3.121241732986190D-12,  -2.496978357149163D-10,   2.996373393634213D-08, &
&    3.127401861986232D-28,  -4.424750905845796D-27,   9.790704941896735D-26, &
&   -1.988526790619755D-24,   3.593156083695780D-23,  -6.106540180349430D-22, &
&    1.160713068676009D-20,  -3.520099342030884D-19,   1.785505719844075D-17, &
&   -1.116051274018728D-15,   7.392359495292381D-14,  -5.065423621063410D-12, &
&    3.646884754920936D-10,  -2.917497312395664D-08,   3.500996330333043D-06, &
&    6.721305888951705D-27,  -8.515986713613122D-26,   1.892435257033481D-24, &
&   -3.892719031144234D-23,   7.173800128977945D-22,  -1.293204532967438D-20, &
&    2.886489195605565D-19,  -1.078414339867004D-17,   6.003029048607484D-16, &
&   -3.825053687136818D-14,   2.540513628218412D-12,  -1.741345826414391D-10, &
&    1.253725088055446D-08,  -1.002977974803721D-06,   1.203573480805010D-04, &
&    4.567598195263687D-26,  -6.042991047920525D-25,   1.354286399399437D-23, &
&   -2.817444738852389D-22,   5.372190733559397D-21,  -1.075712127484015D-19, &
&    3.008983892325460D-18,  -1.372518577145188D-16,   8.172678320346227D-15, &
&   -5.274116846285051D-13,   3.509187516559212D-11,  -2.405777712449614D-09, &
&    1.732128085571984D-07,  -1.385700945427502D-05,   1.662841069780572D-03, &
&    1.192283953351090D-25,  -1.586902881290983D-24,   3.600063734363830D-23, &
&   -7.707270538277902D-22,   1.603159145822140D-20,  -4.023023604122659D-19, &
&    1.546572887636483D-17,  -8.435863834366125D-16,   5.266661553231705D-14, &
&   -3.427318144019952D-12,   2.283050227739416D-10,  -1.565381397213299D-08, &
&    1.127066131139873D-06,  -9.016524994916159D-05,   1.081982982143394D-02, &
&    4.935185772657409D-26,  -6.463856456523321D-25,   1.622139405344244D-23, &
&   -4.468681198738122D-22,   1.556149266491881D-20,  -7.459984037273500D-19, &
&    4.346218437251886D-17,  -2.724458100695728D-15,   1.753203765055831D-13, &
&   -1.146768189863343D-11,   7.644401753861742D-10,  -5.241820779926694D-08, &
&    3.774107614085576D-06,  -3.019285930862465D-04,   3.623143110200587D-02, &
&   -2.169269540810604D-25,   2.791163085713550D-24,  -5.930229075348760D-23, &
&    1.009889491467594D-21,  -4.379840193045339D-21,  -8.362117199018488D-19, &
&    7.153245533038601D-17,  -4.844828205389769D-15,   3.164113962035744D-13, &
&   -2.074697169292568D-11,   1.383465163634405D-09,  -9.486871536337751D-08, &
&    6.830562976629712D-06,  -5.464451121453677D-04,   6.557341377233255D-02, &
&    8.344763816811319D-30,   6.570080146655454D-30,  -6.178187164982334D-29, &
&   -7.341707606269935D-29,   3.406135716110308D-28,  -2.494167506562400D-27, &
&    5.658362597482945D-26,  -2.125728525768408D-24,   1.240990604604756D-22, &
&   -8.322518702928040D-21,   5.807723686769494D-19,  -4.180250422358582D-17, &
&    3.160192405296788D-15,  -2.654558074224964D-13,   3.344743027740748D-11, &
&    5.016882861291622D-30,  -1.124886903267127D-29,   2.014590452951134D-28, &
&   -4.592864979104186D-27,   8.053934510996063D-26,  -1.464184541328092D-24, &
&    3.783355165049103D-23,  -1.724192517794515D-21,   1.071847245840512D-19, &
&   -7.265154543597553D-18,   5.076693743026806D-16,  -3.654567960183072D-14, &
&    2.762814933255914D-12,  -2.320762762444214D-10,   2.924161007101721D-08, &
&    4.066274591209432D-29,  -7.956762752188629D-28,   1.638246848759541D-26, &
&   -3.149132595344719D-25,   5.739649190725011D-24,  -1.171543607284062D-22, &
&    3.715905769961677D-21,  -1.933921806071811D-19,   1.244388832057151D-17, &
&   -8.482018021660009D-16,   5.931205842127128D-14,  -4.270013116981563D-12, &
&    3.228102984081558D-10,  -2.711605255193352D-08,   3.416622569726006D-06, &
&    1.490504047352867D-27,  -1.546862837841605D-26,   3.171782278832567D-25, &
&   -6.316994183474738D-24,   1.220222192299858D-22,  -2.907036161961205D-21, &
&    1.129997278788274D-19,  -6.478590060201307D-18,   4.261079145653184D-16, &
&   -2.914529712008212D-14,   2.038933070987724D-12,  -1.467940876905646D-10, &
&    1.109757911412633D-08,  -9.321963946311040D-07,   1.174567446827185D-04, &
&    8.987234592937086D-27,  -1.111891910572738D-25,   2.316604580370782D-24, &
&   -4.748353849473513D-23,   1.017470821415283D-21,  -3.017073411297327D-20, &
&    1.429093946586609D-18,  -8.797954021299209D-17,   5.871806097638503D-15, &
&   -4.025388200908178D-13,   2.816873212423388D-11,  -2.028082610430579D-09, &
&    1.533226529344030D-07,  -1.287910101782060D-05,   1.622766720652986D-03, &
&    2.408456247988628D-26,  -2.958789165564077D-25,   6.360063534847802D-24, &
&   -1.423635686596399D-22,   3.811726685455875D-21,  -1.541807123678880D-19, &
&    8.740225471376686D-18,  -5.659895833078185D-16,   3.814206266133087D-14, &
&   -2.618704627447924D-12,   1.832854247981084D-10,  -1.319637459718309D-08, &
&    9.976448738719937D-07,  -8.380216452829923D-05,   1.055907271030142D-02, &
&    1.236306635087464D-26,  -1.341586974117181D-25,   3.739727354030782D-24, &
&   -1.401791350005294D-22,   7.077129794422261D-21,  -4.308033833935950D-19, &
&    2.813205913387143D-17,  -1.882088745664677D-15,   1.275908805819945D-13, &
&   -8.767910314356475D-12,   6.137442796882498D-10,  -4.418951848778217D-08, &
&    3.340727183181012D-06,  -2.806210814511737D-04,   3.535825625479231D-02, &
&   -4.481616912192769D-26,   4.870882195282026D-25,  -8.155031724956422D-24, &
&    3.402501737605052D-23,   7.939983546142648D-21,  -7.064195220230642D-19, &
&    4.994048020160876D-17,  -3.394967170015257D-15,   2.308066142800289D-13, &
&   -1.586762884624172D-11,   1.110777646647390D-09,  -7.997631185421719D-08, &
&    6.046211085410374D-06,  -5.078817400797686D-04,   6.399309928705646D-02, &
&   -1.966848149876196D-29,   3.550577685867037D-30,   1.519968051260838D-28, &
&   -7.304443883488972D-30,  -4.365305692054499D-28,  -5.995340905641065D-28, &
&    2.221567340268057D-26,  -1.295786784215924D-24,   8.958400293471749D-23, &
&   -6.424813942987282D-21,   4.709377438191050D-19,  -3.552063365166159D-17, &
&    2.813225414543708D-15,  -2.475637968583856D-13,   3.267842102551072D-11, &
&    1.850484641397557D-29,   8.744220714033805D-31,  -1.089975761565138D-28, &
&   -6.831003539737327D-28,   1.362635352912094D-26,  -3.660151644714782D-25, &
&    1.740439476697892D-23,  -1.117410987517047D-21,   7.817085821139933D-20, &
&   -5.615723147191122D-18,   4.117119668634452D-16,  -3.105407715647478D-14, &
&    2.459478478772273D-12,  -2.164340860237562D-10,   2.856929927371107D-08, &
&    1.119228600377144D-29,  -1.395247754177997D-28,   2.418250764471819D-27, &
&   -4.799651814537133D-26,   1.062423715240964D-24,  -3.595561935623859D-23, &
&    1.947304237391488D-21,  -1.295989151145143D-19,   9.124318284295492D-18, &
&   -6.560717739116958D-16,   4.810437831192346D-14,  -3.628390528085981D-12, &
&    2.873682175010692D-10,  -2.528840171970361D-08,   3.338069021236425D-06, &
&    2.076097954258916D-28,  -2.367242809395400D-27,   4.897041505348870D-26, &
&   -1.030386712863881D-24,   2.651404049423852D-23,  -1.092395373360860D-21, &
&    6.511336436506401D-20,  -4.434867753003880D-18,   3.134777532935641D-16, &
&   -2.255282506221488D-14,   1.653722603397522D-12,  -1.247368500635763D-10, &
&    9.879152249327169D-09,  -8.693653693566720D-07,   1.147562286389106D-04, &
&    1.761499415477479D-27,  -1.786821523410495D-26,   3.684386808580331D-25, &
&   -8.661830516328220D-24,   2.765989337903729D-22,  -1.379912091575221D-20, &
&    8.830530401165982D-19,  -6.108579362678737D-17,   4.329163094179406D-15, &
&   -3.115719680580096D-13,   2.284750998145705D-11,  -1.723347141695922D-09, &
&    1.364890478307015D-07,  -1.201103600031921D-05,   1.585456751192791D-03, &
&    3.875015320720376D-27,  -4.987051154669795D-26,   1.124748334805522D-24, &
&   -3.287555521749504D-23,   1.420138037733172D-21,  -8.430197333171770D-20, &
&    5.675516833445975D-18,  -3.966833124181532D-16,   2.816143815788951D-14, &
&   -2.027283309152388D-12,   1.486645082784334D-10,  -1.121353041727743D-08, &
&    8.881114868076734D-07,  -7.815381028132017D-05,   1.031630295486369D-02, &
&    2.021763462084032D-27,  -2.855065297089244D-26,   1.157168893807874D-24, &
&   -6.245766172862019D-23,   3.983676568540708D-21,  -2.711197885229519D-19, &
&    1.886157633014260D-17,  -1.326721650816636D-15,   9.428601750337286D-14, &
&   -6.788458566857406D-12,   4.978191313843979D-10,  -3.754977754550558D-08, &
&    2.973942332994740D-06,  -2.617069250814546D-04,   3.454531410984681D-02, &
&   -6.779094143181814D-27,   6.122805954437353D-26,  -1.324098711735176D-25, &
&   -7.217508710600837D-23,   6.547544630708920D-21,  -4.810875308736812D-19, &
&    3.401320575480410D-17,  -2.399773934989550D-15,   1.706298683092859D-13, &
&   -1.228597168951278D-11,   9.009766150458400D-10,  -6.795941742751789D-08, &
&    5.382386083493506D-06,  -4.736499763660734D-04,   6.252179688446881D-02, &
&    3.805801489561696D-29,   1.318093045185750D-30,  -2.919136282545701D-28, &
&   -1.730865162893031D-29,   8.799007967223105D-28,  -1.378628060447470D-28, &
&    1.134802464728570D-26,  -9.037847838866409D-25,   6.685214466177938D-23, &
&   -5.029139873228854D-21,   3.855429765237083D-19,  -3.040264783256060D-17, &
&    2.517338284208837D-15,  -2.315951179037498D-13,   3.196012625388987D-11, &
&   -1.421396071343043D-29,  -1.379671943383470D-29,   1.215015963207770D-28, &
&   -8.272436733322324D-30,   2.866548252926946D-27,  -1.635875997672758D-25, &
&    1.089267474393403D-23,  -7.883340776992443D-22,   5.842889048204931D-20, &
&   -4.396626455393813D-18,   3.370623413356514D-16,  -2.657968693705857D-14, &
&    2.200797590507245D-12,  -2.024733761537086D-10,   2.794132590056456D-08, &
&   -4.121990592796647D-30,  -1.423446680873944D-29,   3.882178115333131D-28, &
&   -8.752484361895740D-27,   3.205718273328393D-25,  -1.827455207680435D-23, &
&    1.262681222656817D-21,  -9.200162470087292D-20,   6.825877112177116D-18, &
&   -5.136986037536105D-16,   3.938268850734920D-14,  -3.105600196259139D-12, &
&    2.571436616888850D-10,  -2.365721672112421D-08,   3.264695906900087D-06, &
&    3.315532215536007D-29,  -3.800603436092613D-28,   7.803496746458953D-27, &
&   -2.207242331726453D-25,   9.786234003858319D-24,  -6.110185405882404D-22, &
&    4.319472432671748D-20,  -3.160500387530566D-18,   2.346381030543543D-16, &
&   -1.765976711949936D-14,   1.353897968354618D-12,  -1.067644027495536D-10, &
&    8.840091850876812D-09,  -8.132884471666156D-07,   1.122338056965605D-04, &
&    5.533968339756595D-28,  -2.704585497060073D-27,   6.364110516152517D-26, &
&   -2.334622795829849D-24,   1.240484506536348D-22,  -8.285456947218439D-21, &
&    5.948266894076731D-19,  -4.364374336046081D-17,   3.241526526225791D-15, &
&   -2.439833572060548D-13,   1.870526291527352D-11,  -1.475042693032627D-09, &
&    1.221335298873982D-07,  -1.123628472684630D-05,   1.550607292213707D-03, &
&    3.282638972426701D-29,  -8.391508848836681D-27,   2.622809891538599D-25, &
&   -1.214979506181552D-23,   7.595674255690200D-22,  -5.324554482762043D-20, &
&    3.862122266068510D-18,  -2.838913207344285D-16,   2.109120558190419D-14, &
&   -1.587552053665465D-12,   1.217119828785038D-10,  -9.597856824904404D-09, &
&    7.947025314770838D-07,  -7.311263283490368D-05,   1.008954333097286D-02, &
&    7.843975167942000D-28,  -9.288909804087121D-27,   5.118031707965009D-25, &
&   -3.449097857281751D-23,   2.446537986761554D-21,  -1.769366186912859D-19, &
&    1.291573823507291D-17,  -9.504554259692868D-16,   7.062452181425547D-14, &
&   -5.316084276783100D-12,   4.075663254822783D-10,  -3.213951499783302D-08, &
&    2.661151836386993D-06,  -2.448259689232533D-04,   3.378598371131149D-02, &
&   -8.212631644210312D-28,   1.675988661678074D-28,   6.283216144718432D-25, &
&   -5.710526534877502D-23,   4.344464541573801D-21,  -3.190563702554832D-19, &
&    2.336087868138077D-17,  -1.720019535294869D-15,   1.278181746667098D-13, &
&   -9.621296579677095D-12,   7.376333609470080D-10,  -5.816766369704470D-08, &
&    4.816282579001423D-06,  -4.430979973795338D-04,   6.114752363882112D-02, &
&   -7.514366140320663D-29,  -8.627780088378944D-30,   6.065736959074122D-28, &
&    6.884071115034582D-29,  -1.931560452168204D-27,  -3.271891276453388D-28, &
&    1.163752640169821D-26,  -6.535638906079543D-25,   5.066418687583017D-23, &
&   -3.979319797830497D-21,   3.183429187461735D-19,  -2.619505628339621D-17, &
&    2.263252762709317D-15,  -2.172722647825810D-13,   3.128720612698250D-11, &
&    7.527526995975541D-30,   7.387603727236425D-30,  -5.541805818897659D-29, &
&   -8.346261729613257D-29,   1.594928545309215D-27,  -9.933259151251733D-26, &
&    7.461057644932774D-24,  -5.714738882273572D-22,   4.429403256893131D-20, &
&   -3.478930143646619D-18,   2.783130589360232D-16,  -2.290117957712842D-14, &
&    1.978661863923877D-12,  -1.899515387108613D-10,   2.735302157347912D-08, &
&    9.582494734625354D-30,   1.323613700119937D-30,  -1.171660894914370D-29, &
&   -2.684022114903568D-27,   1.606316108388646D-25,  -1.153543283443792D-23, &
&    8.706947653205596D-22,  -6.675999759664951D-20,   5.175257005279240D-18, &
&   -4.064812603239666D-16,   3.251840494844745D-14,  -2.675799519965277D-12, &
&    2.311890748567993D-10,  -2.219415117015021D-08,   3.195957768438423D-06, &
&   -8.341621185169616D-29,  -7.829141840686694D-29,   2.381908687241745D-27, &
&   -8.149800294823649D-26,   5.368265950956221D-24,  -3.946195907868611D-22, &
&    2.990912111434278D-20,  -2.294823991850701D-18,   1.779127791973364D-16, &
&   -1.397400540575942D-14,   1.117918498708007D-12,  -9.198870887730200D-11, &
&    7.947824372822174D-09,  -7.629911394649207D-07,   1.098707240816674D-04, &
&    3.115379317657085D-28,  -4.774781365399227D-28,   1.598913271160689D-26, &
&   -1.042586012692916D-24,   7.289846341656654D-23,  -5.434184003802602D-21, &
&    4.130035598456547D-19,  -3.170265791408312D-17,   2.457997606082374D-15, &
&   -1.930628239951363D-13,   1.544501177395716D-11,  -1.270903728575953D-09, &
&    1.098060816053862D-07,  -1.054138383172609D-05,   1.517959271759153D-03, &
&    2.579708320590590D-28,  -1.822760574339758D-27,   9.538768385441565D-26, &
&   -6.417788992849976D-24,   4.687160059296592D-22,  -3.528298411406492D-20, &
&    2.686414807052091D-18,  -2.062739198201121D-16,   1.599368780769175D-14, &
&   -1.256226894754984D-12,   1.004981137501780D-10,  -8.269558813661586D-09, &
&    7.144898800447984D-07,  -6.859102847789441D-05,   9.877108100791587D-03, &
&   -9.329528966940189D-28,  -4.255677884553011D-27,   2.887614966461990D-25, &
&   -2.073462992844213D-23,   1.558077510941006D-21,  -1.179926355835538D-19, &
&    8.993856029562667D-18,  -6.907111575198170D-16,   5.355649167495703D-14, &
&   -4.206617156045163D-12,   3.365293573919967D-10,  -2.769155844701517D-08, &
&    2.392550649240127D-06,  -2.296848623244881D-04,   3.307462017471618D-02, &
&    7.360258873632335D-28,  -4.964944615884930D-27,   4.637224107381285D-25, &
&   -3.688606033226144D-23,   2.810107632499241D-21,  -2.134139457649237D-19, &
&    1.627587273932245D-17,  -1.250065072614099D-15,   9.692898927629416D-14, &
&   -7.613339893490745D-12,   6.090672605777358D-10,  -5.011753506078416D-08, &
&    4.330155031910771D-06,  -4.156948830751377D-04,   5.986006316286588D-02, &
&   -3.102269823578956D-29,   5.490136918246436D-30,   2.327198994340857D-28, &
&   -3.706522070505123D-29,  -6.716951765947183D-28,   1.596492894220435D-29, &
&    6.955135850384886D-27,  -4.812134735658205D-25,   3.885481650044593D-23, &
&   -3.179048484989979D-21,   2.649204347706263D-19,  -2.270746396584695D-17, &
&    2.043671746803159D-15,  -2.043671746367277D-13,   3.065507619534115D-11, &
&   -2.242937455644252D-30,  -5.941646992563856D-30,   2.358342227004477D-29, &
&    2.583618027891079D-29,   7.639150936356046D-28,  -6.649480297352041D-26, &
&    5.259786675626735D-24,  -4.205970874943905D-22,   3.396944151102436D-20, &
&   -2.779300339775821D-18,   2.316082195229684D-16,  -1.985213214335643D-14, &
&    1.786691887655001D-12,  -1.786691887428413D-10,   2.680037831133863D-08, &
&   -2.226043698980739D-29,   9.193427077923767D-30,   1.988330956918679D-28, &
&   -1.389223431304648D-27,   9.851717295729953D-26,  -7.749561503203403D-24, &
&    6.144266819936530D-22,  -4.914184918457929D-20,   3.969016840895186D-18, &
&   -3.247364895998097D-16,   2.706136401171889D-14,  -2.319545418324168D-12, &
&    2.087590872741567D-10,  -2.087590872579354D-08,   3.131386308862752D-06, &
&    1.489084295220356D-28,  -7.674069863041599D-29,  -5.201086859865166D-28, &
&   -4.389936405575324D-26,   3.393959871609483D-24,  -2.662119373467158D-22, &
&    2.112024076911587D-20,  -1.689373571277017D-18,   1.364467305202014D-16, &
&   -1.116379811043370D-14,   9.303163044456945D-13,  -7.974139613866702D-11, &
&    7.176725644875899D-09,  -7.176725644546631D-07,   1.076508846680719D-04, &
&   -2.831577786111165D-28,  -5.519708970461539D-29,   1.026955679602390D-26, &
&   -6.037259664873916D-25,   4.669149858262690D-23,  -3.675997965773093D-21, &
&    2.917714636826336D-19,  -2.333991742299238D-17,   1.885127614291963D-15, &
&   -1.542375286379397D-13,   1.285312588560313D-11,  -1.101696494317953D-09, &
&    9.915268443278793D-08,  -9.915268443036874D-06,   1.487290266454593D-03, &
&   -5.958144121130578D-28,  -3.665215373049273D-28,   5.620526175180569D-26, &
&   -3.885411106551066D-24,   3.032111658194216D-22,  -2.391079936173932D-20, &
&    1.898408988545361D-18,  -1.518679076372463D-16,   1.226620175192708D-14, &
&   -1.003597829293394D-12,   8.363314842132159D-11,  -7.168555551736982D-09, &
&    6.451699995066347D-07,  -6.451699995001446D-05,   9.677549992499651D-03, &
&    1.995007765649957D-27,  -3.044434186345533D-27,   1.500807191178675D-25, &
&   -1.290997817389926D-23,   1.014169657177514D-21,  -8.005099602951109D-20, &
&    6.356834023058589D-18,  -5.085448109252318D-16,   4.107475231043509D-14, &
&   -3.360661354552737D-12,   2.800551112715912D-10,  -2.400472381237530D-08, &
&    2.160425143053782D-06,  -2.160425143051178D-04,   3.240637714576666D-02, &
&   -1.077356073792844D-27,  -3.155743394588995D-27,   3.038449238209719D-25, &
&   -2.330627488733060D-23,   1.834281339139161D-21,  -1.448654207984382D-19, &
&    1.150473245237143D-17,  -9.203873766113182D-16,   7.433907599465230D-14, &
&   -6.082288941733425D-12,   5.068574191546299D-10,  -4.344492169157973D-08, &
&    3.910042952515676D-06,  -3.910042952527535D-04,   5.865064428791762D-02/
end


!------------------
  module rysgrid9
!------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t9(18,9,0:16)
      real(8) :: w9(18,9,0:16)
      data t9 / &
&   -1.574535779192816D-18,   3.503640486373085D-17,  -3.563458707512256D-16, &
&    2.193851852344775D-15,  -9.126621484327669D-15,   2.712141144872918D-14, &
&   -5.934461192986820D-14,   9.712988727998919D-14,  -1.197332787689071D-13, &
&    9.789601822203417D-14,  -7.136729570659086D-13,  -2.727162398405454D-11, &
&   -1.047178216286075D-09,  -3.680356394993265D-08,  -1.190473986128447D-06, &
&   -3.498639953328994D-05,  -8.927744112730837D-04,   9.832014832256292D-01, &
&    3.479687587858198D-18,  -7.740433321009001D-17,   7.870107634054974D-16, &
&   -4.843819670439157D-15,   2.014537903732286D-14,  -5.985241107452617D-14, &
&    1.309409515335864D-13,  -2.143273340811624D-13,   2.642839847235329D-13, &
&   -1.890467670183755D-13,   2.352471866566594D-12,   4.971890710709413D-11, &
&    5.012888221869045D-11,  -5.990898572149198D-08,  -3.613908793032896D-06, &
&   -1.431292442166970D-04,  -4.266784737634258D-03,   9.135994225742659D-01, &
&   -2.917231692043147D-18,   6.484777289378169D-17,  -6.589081180571359D-16, &
&    4.052931102242855D-15,  -1.684715118441820D-14,   5.003202645744530D-14, &
&   -1.094223034924607D-13,   1.791485711159263D-13,  -2.224626851936167D-13, &
&    7.096291318340172D-14,  -2.507246059724800D-12,   5.152130388034979D-11, &
&    4.146109232541542D-09,   8.928595515864350D-08,  -1.750736153430434D-06, &
&   -2.107032371136241D-04,  -8.753830758099219D-03,   7.967391631975201D-01, &
&    1.288865120124365D-18,  -2.860656919678510D-17,   2.902431720344530D-16, &
&   -1.782869911078831D-15,   7.402132299887838D-15,  -2.196080336472856D-14, &
&    4.799014697836549D-14,  -7.862960628740364D-14,   1.014831201564220D-13, &
&    7.047680746773329D-14,  -1.726240151637433D-12,  -1.710828122392184D-10, &
&   -9.566246744098003D-10,   1.611899794550703D-07,   3.960858292850225D-06, &
&   -1.464058416073784D-04,  -1.236221792227453D-02,   6.459416610770251D-01, &
&   -3.167840217348949D-19,   7.002444157909532D-18,  -7.076454302224066D-17, &
&    4.330252730759671D-16,  -1.791427294488048D-15,   5.297636026284058D-15, &
&   -1.153947542928153D-14,   1.894902215804102D-14,  -3.001335275560645D-14, &
&   -4.228017168035646D-14,   5.889487658098819D-12,   4.352104434748984D-11, &
&   -5.639568247784475D-09,  -3.091306378639687D-08,   6.515242358468087D-06, &
&    2.345546810505651D-05,  -1.348836631093831D-02,   4.784309655375749D-01, &
&    4.536273148509018D-20,  -9.925958444383737D-19,   9.927399073106564D-18, &
&   -6.011427596440928D-17,   2.460979460622851D-16,  -7.201128091232486D-16, &
&    1.548575925082574D-15,  -2.572212403866752D-15,   9.158867126887948D-15, &
&   -6.784198504102335D-14,  -4.085655075087996D-12,   1.385549059038566D-10, &
&    1.167338613717776D-09,  -1.698318093340327D-07,   2.506108355358691D-06, &
&    1.759005291359898D-04,  -1.163023283513677D-02,   3.133433833212179D-01, &
&   -4.145160979049933D-21,   8.907591113614388D-20,  -8.737365820200528D-19, &
&    5.181559680045664D-18,  -2.074144181618780D-17,   5.915056777516302D-17, &
&   -1.219988249421298D-16,   2.255148349941712D-16,  -3.753553403723642D-15, &
&    9.773850929111505D-14,  -1.640842035137356D-13,  -9.067379786004158D-11, &
&    3.635130410046727D-09,  -4.303821278205428D-08,  -2.767752369510309D-06, &
&    2.038432773950037D-04,  -7.610569730488986D-03,   1.695390189659999D-01, &
&    5.883107970006130D-22,  -1.274440962265797D-20,   1.259741510372947D-19, &
&   -7.523121638526134D-19,   3.028391569160712D-18,  -8.657856385319667D-18, &
&    1.790032857268625D-17,  -4.625262375165703D-17,   1.384591107402824D-15, &
&   -5.245219934671127D-14,   1.323260432870667D-12,  -1.259460701668378D-11, &
&   -8.905545641515820D-10,   6.981851734878683D-08,  -3.203981909564225D-06, &
&    1.136592985428760D-04,  -3.211956252490370D-03,   6.344667069311205D-02, &
&    4.485525220351838D-24,  -1.111711521048064D-22,   1.244921574397622D-21, &
&   -8.352545702558374D-21,   3.748364625649441D-20,  -1.167312652991080D-19, &
&    1.296643106684201D-19,   6.537174891616645D-18,  -2.988611030384273D-16, &
&    1.187571182220277D-14,  -4.451781485858087D-13,   1.589857855195636D-11, &
&   -5.424222624604975D-10,   1.763580997352912D-08,  -5.418116940123665D-07, &
&    1.540727339046199D-05,  -3.856839297956540D-04,   7.186802836226390D-03, &
&    4.278160246088279D-24,  -4.810663288862558D-24,  -1.098112396641624D-22, &
&    1.510269246918117D-22,   3.286200492786287D-21,   7.823415185538235D-20, &
&    2.288382719327738D-18,   5.170582442126697D-17,   7.145050976297346D-16, &
&   -8.820132559108936D-15,  -1.182955600918983D-12,  -5.941063781118866D-11, &
&   -2.298313013773528D-09,  -7.661381974439770D-08,  -2.272937288946158D-06, &
&   -5.997677171608268D-05,  -1.354188297994570D-03,   9.776873855804372D-01, &
&   -9.962041219805507D-24,   1.056839351521139D-23,   2.557566541887875D-22, &
&    1.097328466175652D-22,   9.205156525356966D-21,   1.424508267670294D-19, &
&   -3.774548678891270D-18,  -2.386262321398022D-16,  -5.710064849305082D-15, &
&   -2.309659092083224D-14,   3.721480078964743D-12,   1.612827911217584D-10, &
&    3.066285886345804D-09,  -2.801788735535251D-08,  -4.617545456228609D-06, &
&   -2.056269098192780D-04,  -5.997710562300305D-03,   8.881992133392959D-01, &
&    8.982914364981411D-24,  -1.032738114905950D-23,  -2.066293624550451D-22, &
&    8.154842624320211D-22,  -3.154176140109006D-21,  -4.956483320400052D-19, &
&   -5.320001297142019D-18,   2.498098786091029D-16,   8.559427943616242D-15, &
&   -2.317458973549881D-14,  -7.133151611317348D-12,  -1.266263155998543D-10, &
&    3.464817863564176D-09,   1.956950110358357D-07,   1.123636751194341D-06, &
&   -2.181233683244678D-04,  -1.093395069351671D-02,   7.475529111470336D-01, &
&   -4.558251246465276D-24,   5.802733494748128D-24,   1.295873836031124D-22, &
&   -5.595984701892732D-22,  -1.165698080265948D-20,   2.875494155339298D-19, &
&    8.277744535909138D-18,  -1.939578389699310D-16,  -6.862730600726164D-15, &
&    1.327537474395653D-13,   5.938387137045955D-12,  -9.574654056896632D-11, &
&   -5.668387259004098D-09,   7.364004990033749D-08,   6.511518819362796D-06, &
&   -6.565051719171260D-05,  -1.345489541545130D-02,   5.810605449743664D-01, &
&    1.296642154490046D-24,  -1.267111580159242D-24,  -4.269986489268259D-23, &
&    8.681180747715649D-24,   8.748528483905404D-21,  -8.819066065382683D-20, &
&   -5.656273930026316D-18,   1.455291276771872D-16,   2.746326055364516D-15, &
&   -1.637543536255039D-13,  -1.909390900947320D-13,   1.553509668944719D-10, &
&   -2.095372983656669D-09,  -1.347387697223609D-07,   4.706271126916052D-06, &
&    1.102484774439981D-04,  -1.279684813010277D-02,   4.123540859210900D-01, &
&   -1.840199507620273D-25,   1.083012729992556D-25,   5.908548682670709D-24, &
&    8.442942697071018D-23,  -3.458076285598527D-21,   1.755802262441977D-20, &
&    2.566663857170371D-18,  -9.261546546278403D-17,   2.702417022552220D-16, &
&    8.225457033290009D-14,  -2.806551819679184D-12,   6.544451371607655D-13, &
&    3.126534668846183D-09,  -1.073235777337551D-07,  -3.459428412759917D-07, &
&    1.904944274867247D-04,  -9.762407422533875D-03,   2.598023302535350D-01, &
&    1.131647223543856D-26,  -6.367216626213294D-27,   4.685398185722144D-25, &
&   -3.473723772319282D-23,   8.935951674105401D-22,  -2.177126723304916D-21, &
&   -8.799243576235264D-19,   4.159228589493015D-17,  -9.463788967120910D-16, &
&   -3.817812831920740D-15,   1.300290259612287D-12,  -5.895955368267829D-11, &
&    1.269861551246929D-09,   1.614421230916467D-08,  -2.937159719067394D-06, &
&    1.595878426926242D-04,  -5.791546403616836D-03,   1.362193461242253D-01, &
&   -1.110333579102852D-27,   7.657354606021833D-27,  -1.591889562097390D-25, &
&    6.599319440481249D-24,  -1.071960677006502D-22,  -1.672974177841738D-21, &
&    2.317643810218813D-19,  -1.253103152278871D-17,   4.696181852062910D-16, &
&   -1.276506302408243D-14,   1.553459640074012D-13,   8.688025094063961D-12, &
&   -8.493664462951000D-10,   4.679655554790578D-08,  -2.040370270543563D-06, &
&    7.490844861804080D-05,  -2.283655437911214D-03,   4.986861631043272D-02, &
&    2.497190604599995D-29,   2.355430302735791D-29,   1.412427010640163D-27, &
&    2.913662488170792D-25,  -1.727189627674448D-23,   9.308110952218394D-22, &
&   -4.668783109562627D-20,   2.133102034192819D-18,  -9.365838487847901D-17, &
&    3.928939098952784D-15,  -1.592625831891816D-13,   6.227265649802153D-12, &
&   -2.350290581912419D-10,   8.510906285162564D-09,  -2.929503194724483D-07, &
&    9.371738602116866D-06,  -2.648683381514786D-04,   5.585383623802675D-03, &
&   -5.709167746896407D-26,  -9.383908428989084D-25,  -3.122539642290229D-23, &
&   -7.274483645334538D-22,  -8.996666115172230D-21,   1.109026301116798D-19, &
&    1.079682899872125D-17,   3.898984417465069D-16,   9.693817393215606D-15, &
&    1.629766143387597D-13,   6.164250893224568D-13,  -8.792343294223958D-11, &
&   -4.643783154390614D-09,  -1.613831930490805D-07,  -4.554128236180289D-06, &
&   -1.090710354941871D-04,  -2.171160475698123D-03,   9.690768196505509D-01, &
&    3.812783119743867D-25,   1.348523798102221D-24,  -6.989015593104520D-23, &
&   -2.393633316971533D-21,  -2.131740130157670D-20,   8.991398911728447D-19, &
&    3.551990795458854D-17,   3.661948803432202D-16,  -1.184706286689759D-14, &
&   -5.205415464972461D-13,  -5.947242430763458D-12,   1.826415905112010D-10, &
&    9.047953706166502D-09,   1.213094805451357D-07,  -3.940635206888925D-06, &
&   -2.735342912523652D-04,  -8.401330732008849D-03,   8.524876537094807D-01, &
&    1.263071835591259D-25,   5.395734547616930D-25,  -6.333057693242038D-23, &
&   -9.271455845008719D-22,   2.888170801615451D-20,   8.246006604846199D-19, &
&   -9.868532583080426D-18,  -5.604683256498224D-16,   2.570653644845896D-15, &
&    3.943996617010556D-13,   1.126401336554784D-12,  -2.845164961736331D-10, &
&   -3.439131461555889D-09,   2.065660677278258D-07,   5.440101416331210D-06, &
&   -1.692213462273970D-04,  -1.292537136959960D-02,   6.877011389115483D-01, &
&    8.438752132089455D-26,  -7.042355247240985D-25,  -1.624322582887091D-23, &
&    4.189155327206919D-22,   4.187052499618450D-21,  -3.155790706830160D-19, &
&    1.571348716373446D-18,   2.659706498670069D-16,  -3.238055477472015D-15, &
&   -1.882442988243852D-13,   4.226277107415946D-12,   1.218491338120946D-10, &
&   -5.116042423597811D-09,  -7.527384072507831D-08,   6.470786294706067D-06, &
&    3.551126619078157D-05,  -1.360502002423492D-02,   5.129860610555395D-01, &
&   -1.227802485546323D-26,  -7.819125494352121D-26,   1.849612962730344D-24, &
&   -9.735243855701696D-23,  -1.561169458611770D-21,   1.396117280347392D-19, &
&   -4.814789633166614D-19,  -8.547708086782913D-17,   2.888557681595025D-15, &
&    8.669156455278932D-15,  -3.270921016053376D-12,   7.356425295538343D-11, &
&    1.607140991084918D-09,  -1.354590501101883D-07,   1.847784850129665D-06, &
&    1.593944035036856D-04,  -1.141250898245716D-02,   3.516259362984555D-01, &
&    6.237025163591698D-27,  -1.386389325298945D-28,  -2.520189656941756D-24, &
&   -6.555437479759969D-24,   9.392527409094444D-22,  -2.262545304523197D-20, &
&    9.116671033363780D-19,   1.177658735953808D-17,  -1.301038139873779D-15, &
&    3.919777851568050D-14,  -1.562211381942062D-13,  -4.570460492912235D-11, &
&    2.215117789927126D-09,  -3.772660486056440D-08,  -1.756491889673969D-06, &
&    1.729722664922956D-04,  -7.927544097543523D-03,   2.156519270015317D-01, &
&    1.101246901396736D-27,  -1.585761155501093D-26,  -5.166560256547090D-25, &
&   -8.993183349557089D-24,  -7.205383811157305D-24,   1.526741080395084D-20, &
&   -2.395834239988419D-19,   6.662950765716615D-18,   1.028106302788137D-16, &
&   -1.610427585799374D-14,   7.493136325800214D-13,  -2.181563880386153D-11, &
&    1.090766366046109D-10,   3.104434504289256D-08,  -2.417341126989954D-06, &
&    1.190682973462516D-04,  -4.404882798895940D-03,   1.108974010246116D-01, &
&    5.549703844347616D-28,  -2.584924398853980D-27,  -2.484611898564543D-25, &
&   -2.774233936147578D-24,   7.037696157122312D-23,   1.459605447039880D-22, &
&    1.251054230637358D-19,  -3.369215988243052D-18,   9.941159072717748D-17, &
&   -1.652967523092933D-15,  -7.833989596164329D-14,   8.778398504310397D-12, &
&   -5.678728092959653D-10,   2.909092289685959D-08,  -1.293383484569931D-06, &
&    5.034785400096728D-05,  -1.666681371190747D-03,   4.009474133568820D-02, &
&    5.668270917631974D-29,  -3.266412701708017D-28,  -2.656060375028815D-26, &
&   -2.039057556442105D-25,  -7.098690364024713D-25,   4.967907277492550D-22, &
&   -1.015522747562645D-20,   6.819284953247159D-19,  -3.134781283070934D-17, &
&    1.384303517688974D-15,  -6.210643896257048D-14,   2.643968827735413D-12, &
&   -1.103040679922547D-10,   4.414598161303000D-09,  -1.688231797093203D-07, &
&    6.009750956685560D-06,  -1.894997334073396D-04,   4.463387687996694D-03, &
&    1.714413842900342D-24,   1.899235347203046D-23,   1.689502952858489D-22, &
&   -2.653081788758830D-21,  -1.848442498085665D-19,  -4.930139888831414D-18, &
&   -7.385895992570545D-17,  -3.953525324086592D-17,   3.506513709666961D-14, &
&    1.203056700912027D-12,   2.366911088513680D-11,   2.154276379399257D-10, &
&   -4.670324197677693D-09,  -2.952481541242112D-07,  -9.103461611472505D-06, &
&   -2.080724004003367D-04,  -3.700070274311513D-03,   9.548083603330312D-01, &
&   -1.480966561321872D-24,  -8.602595766099543D-24,   2.936350094977968D-22, &
&    8.219378626071670D-21,  -2.359225249166515D-20,  -4.705377242168199D-18, &
&   -6.298511374520667D-17,   1.382198281948630D-15,   5.340499123954046D-14, &
&    1.538793317945883D-13,  -2.369896777621631D-11,  -4.080461637032040D-10, &
&    7.407143241510141D-09,   3.647760312403410D-07,   9.734079212013784D-07, &
&   -3.020658437304556D-04,  -1.134087324635611D-02,   8.032563248068348D-01, &
&   -2.677793233698644D-25,  -8.161058443328748D-25,   1.002335997402830D-22, &
&    9.581188109833727D-22,  -5.677529427604701D-20,  -8.395043558094506D-19, &
&    2.365328452103474D-17,   3.189766772562170D-16,  -1.283202327488303D-14, &
&   -2.083691861463251D-14,   1.121159217384253D-11,  -1.565721032185052D-11, &
&   -8.872308214400393D-09,   3.518285538152376D-08,   8.091904450678044D-06, &
&   -6.335776987008520D-05,  -1.412200887752392D-02,   6.196379133784120D-01, &
&   -4.789382717254966D-26,   5.654096988252540D-25,   2.041911731986658D-23, &
&   -1.804802004049159D-22,  -6.271953135786228D-21,  -9.111929878424533D-20, &
&   -5.914522081935663D-18,   6.710604767164301D-17,   6.561157205248669D-15, &
&   -7.290947707207401D-14,  -2.507522391703704D-12,   1.374905988844881D-10, &
&   -6.100093931818919D-10,  -1.476412593052177D-07,   4.048655086136975D-06, &
&    1.162198162140512D-04,  -1.281559986189890D-02,   4.465967139104725D-01, &
&   -1.756372980892375D-26,   1.459418170863772D-25,   8.519078338775450D-24, &
&    7.768566774568990D-23,  -5.616552698461426D-21,  -1.427412244182630D-19, &
&    9.756208804879219D-19,   8.036467241805178D-18,   5.428070320606112D-16, &
&    6.531126136835576D-14,  -1.426148780083169D-12,  -1.473243202916816D-11, &
&    2.321706309254344D-09,  -8.075651611777973D-08,  -3.427216940969231D-07, &
&    1.692867002565727D-04,  -9.741652792954746D-03,   2.987004870915336D-01, &
&   -6.912559364923200D-27,   8.079241959720890D-26,   4.731513038420752D-24, &
&    1.209305252164086D-23,  -2.290015460417610D-21,  -6.776613587363758D-20, &
&   -5.196733843294266D-19,   3.488908843333454D-17,   1.302861778507774D-16, &
&    8.062483334381419D-15,   5.671929899145533D-13,  -3.476372317696800D-11, &
&    9.487250462992758D-10,   1.090127277765746D-09,  -2.069609702010924D-06, &
&    1.433098453185640D-04,  -6.342353189724863D-03,   1.801015813913119D-01, &
&   -3.529748307469537D-27,   3.685506264821680D-26,   2.106072240961381D-24, &
&    1.076253447459647D-23,  -1.227692831943828D-21,  -2.906044020434708D-20, &
&   -1.691032206355928D-19,   7.763498873441232D-18,   4.233513009827283D-16, &
&   -4.936355103631880D-15,   2.819446060059282D-13,  -5.051243478377973D-12, &
&   -2.522298783240999D-10,   2.822306501270541D-08,  -1.809962897831260D-06, &
&    8.743917454655150D-05,  -3.379974050608443D-03,   9.156698204091190D-02, &
&   -1.111442608645349D-27,   1.250411511144623D-26,   7.157099999337277D-25, &
&    3.039242327623419D-24,  -3.822384987560882D-22,  -1.119362022902010D-20, &
&   -2.788541422293902D-20,   2.463914456055483D-18,   1.030286555453673D-16, &
&    1.689313093688728D-15,  -7.882515627120231D-14,   5.667562591517350D-12, &
&   -3.511152009501278D-10,   1.780234410504858D-08,  -8.334830500488473D-07, &
&    3.467756649062310D-05,  -1.247280442796698D-03,   3.287489568241713D-02, &
&   -1.177936275978573D-28,   1.351495502216362D-27,   7.636159046101896D-26, &
&    3.795796645893631D-25,  -4.404980719464988D-23,  -1.070169481658215D-21, &
&   -9.910191936040263D-21,   5.644997698236346D-19,  -1.110720393864184D-18, &
&    6.596852952700972D-16,  -2.572287213995872D-14,   1.191524971118827D-12, &
&   -5.587688444587791D-11,   2.427056235043236D-09,  -1.026488372306168D-07, &
&    4.022953045668704D-06,  -1.401578144332963D-04,   3.647481266798513D-03, &
&   -3.617611608363438D-23,  -3.196885000225684D-22,  -2.193324074595955D-22, &
&    9.236578785037356D-20,   2.423253589969352D-18,   2.512349936517907D-17, &
&   -2.588372942429965D-16,  -1.495887943248782D-14,  -2.626642054856101D-13, &
&   -9.453985833759005D-13,   7.072814245876621D-11,   2.047154901166175D-09, &
&    2.443983437443212D-08,  -1.644756441120918D-07,  -1.487089247328304D-05, &
&   -3.905641036540770D-04,  -6.618281674363400D-03,   9.297748895985518D-01, &
&    7.421977626696172D-25,   3.962084600413618D-23,  -1.403551413818185D-23, &
&   -1.315190614420995D-20,   1.092642633858908D-19,   8.758328885295681D-18, &
&   -1.015385664687542D-17,  -4.981241467420055D-15,  -4.495532001695997D-14, &
&    1.711352066179564D-12,   2.855895965764174D-11,  -5.384116881577432D-10, &
&   -1.162524022803483D-08,   3.230764421791809D-07,   8.686185900848298D-06, &
&   -2.286379280237361D-04,  -1.409293220682726D-02,   7.393650673285463D-01, &
&   -1.232072552365650D-25,   1.728360398810814D-24,  -1.236249707072004D-23, &
&    1.582448372051996D-21,   9.951726688511598D-20,   5.306692133380950D-19, &
&   -4.138701129970432D-17,  -5.497028765696373D-16,  -1.033820917175278D-15, &
&   -1.555373292223802D-13,   5.352386957944784D-12,   2.856460540325690D-10, &
&   -4.264627107084093D-09,  -1.479798414305621D-07,   6.767128980753750D-06, &
&    5.275903134435262D-05,  -1.415794559496564D-02,   5.484502781858801D-01, &
&   -1.620985829585243D-25,  -2.757796944459105D-25,   1.950552655304943D-23, &
&    1.256374472986470D-21,   3.659278486360378D-20,   3.546191483351795D-19, &
&   -1.244002371492225D-17,  -5.306327846130354D-16,  -2.858622389287323D-15, &
&    1.254863462374780D-13,  -1.168128754926826D-13,   6.570564837978838D-11, &
&    2.205901868827467D-09,  -1.228681951245626D-07,   1.228244882746232D-06, &
&    1.551523759243746D-04,  -1.142319768971667D-02,   3.858380468868048D-01, &
&   -1.124584705510793D-25,  -2.362240493371918D-25,   1.163652138072834D-23, &
&    7.110644022471361D-22,   2.214515629900586D-20,   1.643975844564366D-19, &
&   -7.460142035638760D-18,  -2.423284837058330D-16,  -2.963110152833100D-15, &
&    6.030209778120611D-14,   1.536072588763266D-12,  -1.340209761880288D-11, &
&    1.633211809175997D-09,  -3.138939033793054D-08,  -1.433248045147888D-06, &
&    1.547330586151924D-04,  -8.108002171124494D-03,   2.541380179764713D-01, &
&   -6.567675746262095D-26,  -1.782588759375067D-25,   6.700635609743074D-24, &
&    3.924709438573826D-22,   1.169194843134207D-20,   9.806949147012483D-20, &
&   -4.166898232335538D-18,  -1.320188399777430D-16,  -1.252841402184493D-15, &
&    1.540562276539317D-14,   1.209975484945900D-12,  -5.293044668667440D-12, &
&    2.888618139162753D-10,   1.474259481253025D-08,  -1.883287072075560D-06, &
&    1.133308370612035D-04,  -5.061549341475944D-03,   1.517170112870942D-01, &
&   -3.280745194268240D-26,  -9.635987633652087D-26,   3.203648594224675D-24, &
&    1.883563999838446D-22,   5.522366940482262D-21,   4.520792248935963D-20, &
&   -1.873487411944967D-18,  -6.528827113362933D-17,  -5.238742309218821D-16, &
&    7.075698554493990D-15,   4.507985534862601D-13,   6.031844650451555D-12, &
&   -2.543762528426990D-10,   2.122137343070816D-08,  -1.315281444357611D-06, &
&    6.417817713091912D-05,  -2.628071565416617D-03,   7.664363904550327D-02, &
&   -1.153995580783566D-26,  -3.581204557531389D-26,   1.112238102124347D-24, &
&    6.491171674191672D-23,   1.902347490370581D-21,   1.541055979456483D-20, &
&   -6.406420152723162D-19,  -2.199889896672473D-17,  -2.110786159091485D-16, &
&    4.053190448901541D-15,   7.747800960511479D-14,   5.254344939942690D-12, &
&   -2.016442593976676D-10,   1.092416310274730D-08,  -5.523239441035018D-07, &
&    2.445579950518011D-05,  -9.551129687895851D-04,   2.741135975761396D-02, &
&   -1.270789199092303D-27,  -4.019524781346640D-27,   1.210047754325383D-25, &
&    7.085449414090451D-24,   2.058608462391902D-22,   1.715979605285200D-21, &
&   -7.131288156975566D-20,  -2.301043924307903D-18,  -2.675688106858428D-17, &
&    5.915116772073480D-16,   2.567481294807406D-15,   7.810156619831204D-13, &
&   -2.881679148672422D-11,   1.394179774248632D-09,  -6.554273559223137D-08, &
&    2.787208808008990D-06,  -1.065680886549370D-04,   3.035794079219941D-03, &
&   -3.011994482595925D-23,   4.304303630078009D-21,   6.429310047452477D-20, &
&   -3.529547314899246D-19,  -2.119132423732788D-17,  -1.984346291016437D-16, &
&    2.703514756592607D-15,   8.746824977370626D-14,   4.928160173063826D-13, &
&   -1.582534155657741D-11,  -3.414199048821981D-10,  -4.801450342398589D-10, &
&    8.505608541626638D-08,   1.332006938315389D-06,  -6.033649017571563D-06, &
&   -5.853314497728752D-04,  -1.160079347772310D-02,   8.850705752554279D-01, &
&    4.102159494874199D-23,   1.129592261397810D-22,  -4.031680189984791D-21, &
&   -7.238814503800397D-20,  -7.172702384772675D-19,   2.472380838382180D-18, &
&    4.422184410910289D-16,   8.125335841476000D-15,  -7.213339569115419D-14, &
&   -3.420842815651726D-12,   1.622944553764801D-12,   6.471870476681846D-10, &
&   -7.787430191485192D-09,  -2.214898664227233D-09,   1.171709311235316D-05, &
&   -6.704922577945967D-05,  -1.560879134077941D-02,   6.644301774683057D-01, &
&    1.484158048801455D-23,   6.186964455983850D-23,  -1.288665603949281D-21, &
&   -3.617142569479898D-20,  -3.925568884305157D-19,   3.921443285324626D-18, &
&    2.005950905669421D-16,   2.226179775631575D-15,  -1.846775947133635D-14, &
&   -1.044392484822079D-12,  -1.420869757391664D-11,   2.441024462206746D-10, &
&    5.301717085276664D-09,  -1.338875906568623D-07,   3.536710319674736D-06, &
&    1.296830795642113D-04,  -1.320431158198905D-02,   4.797244142269628D-01, &
&    7.492852307859938D-24,   3.611824044725734D-23,  -6.099052265753429D-22, &
&   -1.913799839611157D-20,  -2.159660500688306D-19,   1.848374652582811D-18, &
&    1.084790159832456D-16,   1.310302860302407D-15,  -1.301532444721093D-14, &
&   -5.407529047086297D-13,  -5.988557097419398D-12,   4.340720382470006D-11, &
&    4.306884567143076D-09,  -4.115681920710829D-08,  -5.032247732700423D-07, &
&    1.585481158925209D-04,  -9.832819988468011D-03,   3.326855545776361D-01, &
&    4.028449151639502D-24,   2.117335717512953D-23,  -3.076332516342180D-22, &
&   -1.057437864022615D-20,  -1.244568036774780D-19,   9.834942027416316D-19, &
&    5.989847905181349D-17,   7.518017422786438D-16,  -6.858493818549394D-15, &
&   -3.267777870227027D-13,  -2.697135209572066D-12,   1.509192565676845D-11, &
&    2.005891644820873D-09,   1.168949458410519D-08,  -1.648579592469376D-06, &
&    1.305557985989199D-04,  -6.678817461300912D-03,   2.172725887056009D-01, &
&    2.107191896719110D-24,   1.171214818298532D-23,  -1.533262884420430D-22, &
&   -5.618468907645138D-21,  -6.817513442784454D-20,   5.025283763384156D-19, &
&    3.208844751411245D-17,   4.034140430324617D-16,  -3.447414571972554D-15, &
&   -1.801111915303195D-13,  -1.478178225274982D-12,   1.480129722408434D-11, &
&    6.539915966761879D-10,   2.495229056917489D-08,  -1.503356587441508D-06, &
&    8.768434484270204D-05,  -4.061178114678393D-03,   1.290172553815727D-01, &
&    9.762639715739573D-25,   5.626244645013102D-24,  -6.859780312182649D-23, &
&   -2.629842619587580D-21,  -3.252821257483411D-20,   2.277427729801369D-19, &
&    1.510442594272074D-17,   1.907684081776968D-16,  -1.603794925115247D-15, &
&   -8.385164237945879D-14,  -7.926079761226805D-13,   1.160840898726335D-11, &
&    1.129242308776632D-10,   1.895529233927428D-08,  -9.296510096671533D-07, &
&    4.740065125974276D-05,  -2.074956586773935D-03,   6.495592439564368D-02, &
&    3.312291120707091D-25,   1.950860859903128D-24,  -2.275167105605920D-23, &
&   -8.976884080230928D-22,  -1.123624833364494D-20,   7.626007826316809D-20, &
&    5.165957498319652D-18,   6.587825763093583D-17,  -5.587875791730497D-16, &
&   -2.805933890382095D-14,  -3.058782931372556D-13,   5.330319023385823D-12, &
&   -1.136337087835788D-11,   8.204216497142853D-09,  -3.692231709230377D-07, &
&    1.761259625069507D-05,  -7.470390242598351D-04,   2.318443595542188D-02, &
&    3.577398363330621D-26,   2.128855804261743D-25,  -2.430195453194499D-24, &
&   -9.722930594837617D-23,  -1.224223849349355D-21,   8.192818098823896D-21, &
&    5.596764281237246D-19,   7.189981211171118D-18,  -6.161222665278417D-17, &
&   -2.994347170637778D-15,  -3.540938266673081D-14,   6.599001727689180D-13, &
&   -4.093384134152124D-12,   9.845194733023182D-10,  -4.281096336032585D-08, &
&    1.984801743083509D-06,  -8.298951865771457D-05,   2.565234881598349D-03, &
&    1.887336581697067D-21,   2.123543742715691D-20,  -1.639294623534290D-19, &
&   -5.456396340797895D-18,   8.438239141529899D-18,   1.165674016019451D-15, &
&    2.555176270237504D-15,  -2.325416769611213D-13,  -1.326984407168909D-12, &
&    4.416019515254434D-11,   4.178791188692852D-10,  -8.172447693732011D-09, &
&   -1.138209004015336D-07,   1.577571752116925D-06,   3.193228669220337D-05, &
&   -4.005370067003321D-04,  -1.702751466430826D-02,   8.127389374589261D-01, &
&    2.204685595539697D-22,  -1.966890736640960D-21,  -4.315959348833023D-20, &
&    1.771801040864684D-19,   9.756516850903820D-18,   3.788087168754433D-17, &
&   -1.830770180900186D-15,  -2.167025041968442D-14,   2.671358968812852D-13, &
&    5.911608177395072D-12,  -2.176797771643053D-11,  -9.011522885058198D-10, &
&   -8.093624902239437D-09,  -8.846482677538084D-08,   1.078829964843750D-05, &
&    1.033023301947756D-04,  -1.541582022511157D-02,   5.861577688149763D-01, &
&    6.794814233263580D-23,  -7.852335447806058D-22,  -1.546455360311100D-20, &
&    8.825143357213193D-20,   3.929150047146535D-18,   1.087861777501512D-17, &
&   -7.931203641662809D-16,  -8.588724089840435D-15,   1.152338153255490D-13, &
&    2.823074483898366D-12,  -8.296083335390354D-12,  -6.362169355556838D-10, &
&   -5.028640588702524D-10,  -1.262580654347696D-08,   2.310514056304382D-06, &
&    1.701857340579878D-04,  -1.169023286170644D-02,   4.173222020003693D-01, &
&    3.239574243122363D-23,  -3.775421581268020D-22,  -7.561589114601767D-21, &
&    4.395706967494320D-20,   1.988321879195707D-18,   5.437312546101480D-18, &
&   -4.165254259162504D-16,  -4.453237812402455D-15,   6.264295992974403D-14, &
&    1.488978382068940D-12,  -3.431314750680158D-12,  -3.774820403630662D-10, &
&   -6.011510013135202D-10,   3.476709318131832D-08,  -3.647279482500879D-07, &
&    1.499851883766253D-04,  -8.292387630391319D-03,   2.874099823229654D-01, &
&    1.725065696877979D-23,  -1.939096080443298D-22,  -4.015022871905288D-21, &
&    2.267239413867257D-20,   1.068116379136675D-18,   3.025982336734461D-18, &
&   -2.274995270692809D-16,  -2.456898052606492D-15,   3.510710595268792D-14, &
&    8.228373218974432D-13,  -1.848040462011063D-12,  -2.094801791556092D-10, &
&   -8.036460502065337D-10,   4.262102280276031D-08,  -9.899855375398205D-07, &
&    1.099096901399101D-04,  -5.485009050199118D-03,   1.869497926017517D-01, &
&    9.047747615113542D-24,  -9.787627128283325D-23,  -2.088776248385810D-21, &
&    1.139133412257695D-20,   5.580734099516167D-19,   1.639720109184948D-18, &
&   -1.198954810535886D-16,  -1.308431136161117D-15,   1.874470338562358D-14, &
&    4.405028684952489D-13,  -1.071810960849291D-12,  -1.081250852716686D-10, &
&   -6.858204515345903D-10,   3.324582718005208D-08,  -8.664153527958957D-07, &
&    6.965806495448754D-05,  -3.282564077574016D-03,   1.107332369696520D-01, &
&    4.214235414404275D-24,  -4.421245539577708D-23,  -9.656009074063739D-22, &
&    5.113563756456418D-21,   2.583800730786588D-19,   7.813251096521064D-19, &
&   -5.578974480696149D-17,  -6.132803532254583D-16,   8.769291349080798D-15, &
&    2.079537173432060D-13,  -5.548966723849042D-13,  -4.881233349634250D-11, &
&   -4.212453862530758D-10,   1.935219588106091D-08,  -5.246887962506196D-07, &
&    3.646089236513589D-05,  -1.660765112646588D-03,   5.566223748465954D-02, &
&    1.436059847713676D-24,  -1.475849232999967D-23,  -3.273017370823399D-22, &
&    1.698267716980191D-21,   8.762086918363505D-20,   2.701214612813576D-19, &
&   -1.897465365178975D-17,  -2.094807757310788D-16,   2.987594646457989D-15, &
&    7.147562698992849D-14,  -2.042579073480543D-13,  -1.617261449255749D-11, &
&   -1.676257447393976D-10,   7.472856033853915D-09,  -2.060528993778996D-07, &
&    1.330842685305133D-05,  -5.944893805081126D-04,   1.984854320106055D-02, &
&    1.554734479148262D-25,  -1.581451006278109D-24,  -3.533959926661662D-23, &
&    1.814752325063092D-22,   9.461529123642393D-21,   2.945008200304815D-20, &
&   -2.051742680505186D-18,  -2.269573061504585D-17,   3.231584348110856D-16, &
&    7.771129287183251D-15,  -2.300310389814179D-14,  -1.723134178897639D-12, &
&   -1.947275209595566D-11,   8.564237909271892D-10,  -2.377178460702937D-08, &
&    1.487762924311932D-06,  -6.586624365096818D-05,   2.195164846327592D-03, &
&    1.734798957107648D-21,   1.227489164856184D-20,  -2.996902698735153D-19, &
&   -1.335726827653894D-18,   6.554672143496252D-17,  -1.335268316439610D-16, &
&   -1.259340616256464D-14,   1.109496732989388D-13,   1.862909691141462D-12, &
&   -3.621755427499977D-11,  -1.292163874894910D-10,   8.722605992403109D-09, &
&   -4.345399385092508D-08,  -1.606537562409029D-06,   2.813818841757105D-05, &
&    1.360504600697078D-04,  -1.829311245351792D-02,   7.221274922436521D-01, &
&    3.898509352575047D-22,  -3.986825114793775D-21,  -3.642078310166605D-20, &
&    9.692862731645646D-19,   3.260267105729789D-18,  -2.011150872972292D-16, &
&   -6.882340401797770D-18,   3.959802650752841D-14,  -1.207997552650185D-13, &
&   -7.311867537237812D-12,   3.976071392376513D-11,   1.397119315786189D-09, &
&   -7.868414471743033D-09,  -4.589599692382211D-07,   5.371886341018189D-06, &
&    2.346826669503810D-04,  -1.365841112849818D-02,   5.129159499097001D-01, &
&    8.379713593807426D-23,  -1.733392515953295D-21,  -6.474407122469718D-21, &
&    4.170828151095888D-19,   6.270046531020153D-20,  -8.681756461848971D-17, &
&    2.138163623927839D-16,   1.748644283000383D-14,  -9.122143408218483D-14, &
&   -3.369414251552034D-12,   2.753758983498867D-11,   6.000861874253992D-10, &
&   -5.130285084822179D-09,  -1.725653994029438D-07,   6.891286667944168D-07, &
&    1.971566873693792D-04,  -9.833872461685210D-03,   3.633956563760160D-01, &
&    2.702007944003794D-23,  -8.590125091931482D-22,  -1.579741762224173D-21, &
&    2.095664627199077D-19,  -2.305809018228448D-19,  -4.438149027713590D-17, &
&    1.570484975055753D-16,   9.104553260043076D-15,  -5.608883179082445D-14, &
&   -1.804519389325949D-12,   1.663719300403691D-11,   3.278616577012031D-10, &
&   -3.634222764995080D-09,  -6.869952830011258D-08,  -5.565482135353472D-07, &
&    1.459293397524545D-04,  -6.810809913223719D-03,   2.496664114073202D-01, &
&    1.050792471380505D-23,  -4.487400863743750D-22,  -4.076591378864111D-22, &
&    1.108814380696763D-19,  -1.932297274839404D-19,  -2.381777207853391D-17, &
&    9.803385781525192D-17,   4.950936922251981D-15,  -3.313081492821787D-14, &
&   -9.957291760483120D-13,   9.665619183161562D-12,   1.880724938017798D-10, &
&   -2.433413605890984D-09,  -2.622474688349258D-08,  -7.460519214061315D-07, &
&    9.876038331736534D-05,  -4.444921428049755D-03,   1.621698075803711D-01, &
&    4.363048721682803D-24,  -2.290673548672681D-22,  -8.925234920255497D-23, &
&    5.715316081247354D-20,  -1.206960719103842D-19,  -1.240403914919936D-17, &
&    5.527025758685761D-17,   2.602685024520930D-15,  -1.827097911311790D-14, &
&   -5.273844826545029D-13,   5.250216271764029D-12,   1.033886648966322D-10, &
&   -1.471810955573873D-09,  -8.818744175182975D-09,  -5.828156427574110D-07, &
&    5.992011325419001D-05,  -2.638323941451746D-03,   9.597061967896190D-02, &
&    1.725526818049570D-24,  -1.042707571947506D-22,  -9.082311423593426D-24, &
&    2.619431325069142D-20,  -6.108099757800599D-20,  -5.725387897107317D-18, &
&    2.668833687625126D-17,   1.209096658838719D-15,  -8.737921005224178D-15, &
&   -2.459285197093250D-13,   2.480318594158977D-12,   4.965647627056424D-11, &
&   -7.502206047140586D-10,  -2.322210108790295D-09,  -3.375427117082879D-07, &
&    3.057313326764727D-05,  -1.327979971036964D-03,   4.821441096797819D-02, &
&    5.302358952555015D-25,  -3.497588221203241D-23,   2.917225448832003D-24, &
&    8.824597803026175D-21,  -2.168915268672660D-20,  -1.937368031858739D-18, &
&    9.260937215826679D-18,   4.107943955071291D-16,  -3.019297321466927D-15, &
&   -8.370699257609211D-14,   8.497984276466198D-13,   1.724352625592905D-11, &
&   -2.698000303617383D-10,  -3.827482438254202D-10,  -1.298094502570052D-07, &
&    1.099845766891390D-05,  -4.739225816824958D-04,   1.718695936238272D-02, &
&    5.460415984880830D-26,  -3.756722631781267D-24,   6.040862394136594D-25, &
&    9.498339498986406D-22,  -2.389324815235176D-21,  -2.089715446772526D-19, &
&    1.010346481632355D-18,   4.439636837217225D-17,  -3.288714678372941D-16, &
&   -9.053152042025467D-15,   9.216247071701068D-14,   1.883788944120298D-12, &
&   -2.995873155147435D-11,  -1.932198974802729D-11,  -1.484557200804613D-08, &
&    1.221388163865527D-06,  -5.243358731250779D-05,   1.900505283116182D-03, &
&    3.275200736467568D-22,  -9.752632487699345D-22,  -3.482246435654732D-20, &
&    7.003261168053231D-19,  -3.687236509815985D-18,  -1.177699948807232D-16, &
&    2.943628609303720D-15,  -1.909808371239481D-14,  -4.409820698512850D-13, &
&    1.256217511541808D-11,  -1.056411736508051D-10,  -1.379035531345418D-09, &
&    5.475799964328056D-08,  -7.576794958088859D-07,   5.410668909083330D-07, &
&    3.262210204967730D-04,  -1.562707404704732D-02,   6.365567736274278D-01, &
&    2.850267791975902D-23,  -9.315979277298520D-22,   8.357909722158227D-21, &
&    1.274836783368197D-19,  -3.800845412862180D-18,   1.987627695168352D-17, &
&    6.544318425626828D-16,  -1.344716279185971D-14,   1.709352916710796D-14, &
&    3.084078959067039D-12,  -4.466591024223795D-11,  -2.269862662313709D-10, &
&    1.688850058259949D-08,  -2.236454367237356D-07,  -2.544705925023711D-06, &
&    2.493434758197742D-04,  -1.113653422726401D-02,   4.508731978187603D-01, &
&   -8.394665728155560D-24,  -3.686131128754581D-22,   6.007998153002818D-21, &
&    2.767584279840494D-20,  -1.812638846244027D-18,   1.614505500571807D-17, &
&    2.421485169565156D-16,  -7.058041132627804D-15,   2.942288671888839D-14, &
&    1.371321481828320D-12,  -2.432782859839794D-11,  -5.593594790843555D-11, &
&    7.722991618834778D-09,  -8.935125359587976D-08,  -2.505106337287309D-06, &
&    1.811803549985661D-04,  -7.900779100923093D-03,   3.191276624270334D-01, &
&   -9.518609200825788D-24,  -1.702173058337462D-22,   3.601303646401385D-21, &
&    5.989921896408006D-21,  -9.517558546244688D-19,   1.028697030420235D-17, &
&    1.105105633376019D-16,  -3.955451670673559D-15,   2.151611577321597D-14, &
&    7.201051462532522D-13,  -1.423028409891225D-11,  -1.064592863036823D-11, &
&    3.962849518463150D-09,  -3.818811085676251D-08,  -1.966068121136943D-06, &
&    1.261030669153998D-04,  -5.432151209834668D-03,   2.191424274208181D-01, &
&   -6.660919817637365D-24,  -8.404310965804952D-23,   2.077182883658635D-21, &
&    4.871049766687741D-22,  -5.144789822785469D-19,   6.168638347898966D-18, &
&    5.443434459979505D-17,  -2.233450388032613D-15,   1.374068668431765D-14, &
&    3.936441951038674D-13,  -8.306579251626916D-12,   2.084455837256521D-12, &
&    2.084894461763463D-09,  -1.606374956667145D-08,  -1.371392677360213D-06, &
&    8.254640176903679D-05,  -3.530049222124098D-03,   1.423002464317723D-01, &
&   -3.948130127053974D-24,  -4.109196315753947D-23,   1.123654054558905D-21, &
&   -6.619506143787281D-22,  -2.682225709132854D-19,   3.424523832031765D-18, &
&    2.660456346624274D-17,  -1.199256769954476D-15,   7.903576489637606D-15, &
&    2.076188358100382D-13,  -4.569988384598430D-12,   4.234043985815574D-12, &
&    1.056900103632587D-09,  -6.275763072384394D-09,  -8.469291894073579D-07, &
&    4.909134444606726D-05,  -2.089673843387394D-03,   8.419584890408059D-02, &
&   -1.956197286911728D-24,  -1.813345683874773D-23,   5.298073006819820D-22, &
&   -5.769094069455934D-22,  -1.237078683182631D-19,   1.642537155066711D-18, &
&    1.174011651312899D-17,  -5.640480405442273D-16,   3.872286134117442D-15, &
&    9.665378162087374D-14,  -2.186164133171963D-12,   3.015584270410587D-12, &
&    4.755333468557385D-10,  -2.126127671451359D-09,  -4.368227386416240D-07, &
&    2.474072750963691D-05,  -1.050028632295383D-03,   4.229371909361935D-02, &
&   -6.880723868180253D-25,  -5.961771206798806D-24,   1.813837430555870D-22, &
&   -2.503426804559975D-22,  -4.181755457907342D-20,   5.682585680899826D-19, &
&    3.859854794092176D-18,  -1.929722419410113D-16,   1.356229850971378D-15, &
&    3.288024457991989D-14,  -7.560066530670072D-13,   1.255183599130443D-12, &
&    1.578372581319016D-10,  -5.397188903179450D-10,  -1.581365739721576D-07, &
&    8.836024259940183D-06,  -3.743469319388918D-04,   1.507530061063145D-02, &
&   -7.551417882183666D-26,  -6.340762023406170D-25,   1.966712782538508D-23, &
&   -2.980119437420222D-23,  -4.507755568318909D-21,   6.192352936152759D-20, &
&    4.105215304927505D-19,  -2.092102586930909D-17,   1.486298076828562D-16, &
&    3.555664439090903D-15,  -8.239037406457390D-14,   1.479010382054698D-13, &
&    1.685069336203168D-11,  -4.836268874695309D-11,  -1.761255524733727D-08, &
&    9.779447187321117D-07,  -4.139695845148155D-05,   1.666943546798449D-03, &
&   -6.126687320780885D-24,  -4.652956556207951D-23,   2.562343607127159D-21, &
&   -4.609260445777849D-20,   3.214550808674870D-19,   8.358527936953306D-18, &
&   -3.419830396728896D-16,   6.080676415869691D-15,  -3.989278670148084D-14, &
&   -1.065173591153246D-12,   4.287392553400943D-11,  -8.421440509760559D-10, &
&    1.002688597953752D-08,  -2.047822464314073D-09,  -5.103253828746377D-06, &
&    2.734290868039603D-04,  -1.256324374677600D-02,   5.663163037306079D-01, &
&   -6.874274279831529D-24,   4.104840868257709D-23,   3.909807143815590D-22, &
&   -1.994338285768843D-20,   3.652534642113042D-19,  -1.787416146755559D-18, &
&   -8.281034968661847D-17,   2.528595330859222D-15,  -3.088435791430252D-14, &
&   -1.333340408648798D-13,   1.409979174360752D-11,  -3.201444678742576D-10, &
&    3.602573040819006D-09,   3.244329125982773D-08,  -3.861167370716598D-06, &
&    1.949104516352301D-04,  -8.900342448487939D-03,   4.010131271822698D-01, &
&   -3.431108711384826D-24,   2.877394413379086D-23,   2.143658196298985D-23, &
&   -8.974092035229216D-21,   2.117552269655220D-19,  -1.767635937210126D-18, &
&   -3.178550586176649D-17,   1.307560832518526D-15,  -1.878805091519584D-14, &
&   -1.286652308079051D-14,   6.784016487814948D-12,  -1.632810624426509D-10, &
&    1.669876826175640D-09,   3.206781365041214D-08,  -2.802589722089942D-06, &
&    1.383231484185037D-04,  -6.300256246367744D-03,   2.838061907671631D-01, &
&   -1.797942779249488D-24,   1.777909904403237D-23,  -4.284370928755171D-23, &
&   -4.521030159100375D-21,   1.237011461361776D-19,  -1.230762781326756D-18, &
&   -1.452589838701917D-17,   7.348585747367301D-16,  -1.145461574739163D-14, &
&    1.053885954787485D-14,   3.655004474619816D-12,  -9.064860567976468D-11, &
&    8.347878552059239D-10,   2.534877072635967D-08,  -1.950592525433475D-06, &
&    9.512507435131188D-05,  -4.326578185658735D-03,   1.948760193293324D-01, &
&   -9.596688883171242D-25,   1.050646354267202D-23,  -4.302073289316012D-23, &
&   -2.363103656043235D-21,   7.135526434111386D-20,  -7.769943871030245D-19, &
&   -7.069151302606248D-18,   4.165509133590190D-16,  -6.816625945406690D-15, &
&    1.246398901097072D-14,   2.011412228173585D-12,  -5.074264580880803D-11, &
&    4.210273472367027D-10,   1.777542613110351D-08,  -1.277068669087741D-06, &
&    6.182615566436495D-05,  -2.809566996725684D-03,   1.265382577296219D-01, &
&   -4.933205361623152D-25,   5.780745720944864D-24,  -2.958955616771360D-23, &
&   -1.199952774735083D-21,   3.878293987127750D-20,  -4.454898537475683D-19, &
&   -3.400509215610086D-18,   2.243687465659131D-16,  -3.787641694816037D-15, &
&    9.068267739672547D-15,   1.060238653456524D-12,  -2.701809882011015D-11, &
&    2.035599368150378D-10,   1.101805485144421D-08,  -7.596275099571963D-07, &
&    3.660306884316744D-05,  -1.662397409023657D-03,   7.486807339275735D-02, &
&   -2.249169636529158D-25,   2.756641342940884D-24,  -1.587703899413372D-23, &
&   -5.428052778776324D-22,   1.837219036830138D-20,  -2.180942400751110D-19, &
&   -1.478429440974829D-18,   1.057639553635389D-16,  -1.821523519623664D-15, &
&    5.015374572236060D-15,   4.921361442509078D-13,  -1.261627647827202D-11, &
&    8.760806489796883D-11,   5.696870464818987D-09,  -3.828885912008080D-07, &
&    1.839383480152395D-05,  -8.350777916753994D-04,   3.760756545602733D-02, &
&   -7.541657551277685D-26,   9.503295124317464D-25,  -5.835418366765016D-24, &
&   -1.811664204334458D-22,   6.311180827749084D-21,  -7.638124830944621D-20, &
&   -4.806824239099975D-19,   3.623559558761953D-17,  -6.316453380161636D-16, &
&    1.875089888167240D-15,   1.669355094644060D-13,  -4.293878246071624D-12, &
&    2.809264255033836D-11,   2.065499975104074D-09,  -1.367604211380913D-07, &
&    6.557909166070079D-06,  -2.976605318074428D-04,   1.340482983912167D-02, &
&   -8.096094780856214D-27,   1.033827732106159D-25,  -6.532720100032643D-25, &
&   -1.940629416382047D-23,   6.854984992296470D-22,  -8.371271170143080D-21, &
&   -5.082226183315342D-20,   3.931190420348803D-18,  -6.891870402438057D-17, &
&    2.115731833534994D-16,   1.802199932485900D-14,  -4.642561603253849D-13, &
&    2.943064260901924D-12,   2.302137507444033D-10,  -1.513699518035125D-08, &
&    7.252189468745066D-07,  -3.291381102315442D-05,   1.482225613899565D-03, &
&    4.076746932087571D-25,  -1.024577669213387D-24,  -8.551140860383968D-23, &
&    3.305674017196062D-21,  -7.719748175672225D-20,   1.064024281908997D-18, &
&    8.234593499248887D-19,  -5.409203988319930D-16,   1.863289033475285D-14, &
&   -4.168388985077500D-13,   6.862427482616815D-12,  -7.247721510050041D-11, &
&   -4.479976351588284D-10,   7.097374655633178D-08,  -4.004875901611387D-06, &
&    2.035230168030238D-04,  -1.019320629854832D-02,   5.097177014958488D-01, &
&    3.029538985798472D-25,  -2.555250295245772D-24,   2.038982307413559D-24, &
&    9.813170082044407D-22,  -3.518572955034216D-20,   6.847154157428838D-19, &
&   -5.778819084355783D-18,  -1.277451878601975D-16,   6.870054461377669D-15, &
&   -1.747458929653591D-13,   2.999082235686679D-12,  -2.769135496269136D-11, &
&   -5.628727302669081D-10,   5.230795409753707D-08,  -2.849139108903456D-06, &
&    1.441768063515393D-04,  -7.217957950426996D-03,   3.609290728429389D-01, &
&    1.681093222184115D-25,  -1.707178465983268D-24,   1.004654629818639D-23, &
&    3.967571821208218D-22,  -1.855461647143338D-20,   4.069554282758516D-19, &
&   -4.355613667375666D-18,  -4.666958815724874D-17,   3.476292944418163D-15, &
&   -9.386014042174977D-14,   1.624542696946259D-12,  -1.290487957888415D-11, &
&   -4.710327984192997D-10,   3.764803773502689D-08,  -2.020583892064339D-06, &
&    1.020568419327664D-04,  -5.108338715179293D-03,   2.554358732845867D-01, &
&    9.581677907413908D-26,  -1.068542195661583D-24,   8.581910627259722D-24, &
&    1.836965600093746D-22,  -1.047766166159769D-20,   2.454742062467775D-19, &
&   -2.899690816694004D-18,  -1.981968645342885D-17,   1.933177028829738D-15, &
&   -5.403280626293035D-14,   9.345214521298403D-13,  -6.359909051626183D-12, &
&   -3.511877364053372D-10,   2.609534014219617D-08,  -1.389087159759817D-06, &
&    7.008534669949852D-05,  -3.507659975243961D-03,   1.753947400853699D-01, &
&    5.416368380410185D-26,  -6.414418808428416D-25,   5.929486802542729D-24, &
&    8.921714348254862D-23,  -5.941980360235611D-21,   1.451112281673088D-19, &
&   -1.809559405205327D-18,  -8.850045266558810D-18,   1.087960603863809D-15, &
&   -3.108478105619933D-14,   5.356272380239476D-13,  -3.129111757641419D-12, &
&   -2.392825589564615D-10,   1.704444861286692D-08,  -9.026535434614579D-07, &
&    4.551157191358733D-05,  -2.277622661480635D-03,   1.138882278538889D-01, &
&    2.908685098522279D-26,  -3.575672876107995D-25,   3.571158138003475D-24, &
&    4.258011630251872D-23,  -3.197880572931572D-21,   8.026687663723922D-20, &
&   -1.034561976590117D-18,  -3.894673239791347D-18,   5.829065507647399D-16, &
&   -1.689766481001693D-14,   2.899042754491812D-13,  -1.467584705623988D-12, &
&   -1.459255952820253D-10,   1.012354757667317D-08,  -5.343343221868317D-07, &
&    2.692882389055456D-05,  -1.347588048083877D-03,   6.738339081294295D-02, &
&    1.363646694850082D-26,  -1.720766964533534D-25,   1.800693778340361D-24, &
&    1.834295735916083D-23,  -1.505848487805841D-21,   3.848332513591189D-20, &
&   -5.063678990824746D-19,  -1.560582658965174D-18,   2.737174905547912D-16, &
&   -8.010199196974917D-15,   1.368967578248121D-13,  -6.122639315093816D-13, &
&   -7.472523521802864D-11,   5.098052906350951D-09,  -2.684938270646947D-07, &
&    1.352725352516448D-05,  -6.769180469964700D-04,   3.384783625963755D-02, &
&    4.658396962489039D-27,  -5.967838947765241D-26,   6.413089114471372D-25, &
&    5.918964192427000D-24,  -5.154804257476136D-22,   1.331923432763977D-20, &
&   -1.774155568236975D-19,  -4.763303827857872D-19,   9.354156455257649D-17, &
&   -2.753247147031039D-15,   4.692154107191945D-14,  -1.912854131642327D-13, &
&   -2.694337697146587D-11,   1.819931039157316D-09,  -9.572105945409488D-08, &
&    4.821743331960189D-06,  -2.412806045391512D-04,   1.206470435061150D-02, &
&    5.044475048024364D-28,  -6.510872333511994D-27,   7.083478584028147D-26, &
&    6.231727392589812D-25,  -5.589889542276756D-23,   1.451916276180888D-21, &
&   -1.945102967080509D-20,  -4.864528837690977D-20,   1.013561020372643D-17, &
&   -2.991405826552493D-16,   5.090531979771042D-15,  -1.974141971548331D-14, &
&   -2.995398773951080D-12,   2.013831402312387D-10,  -1.058526944319467D-08, &
&    5.331643267049669D-07,  -2.667936771358959D-05,   1.334042125307443D-03, &
&   -2.930399982660980D-26,   4.176913906019793D-25,  -7.328738971781288D-24, &
&    5.696098552821451D-23,   2.661971526485259D-21,  -1.512196423245500D-19, &
&    4.828086362858266D-18,  -1.170619050456363D-16,   2.284837045322331D-15, &
&   -3.468047994775147D-14,   2.684803275034057D-13,   9.877669677710708D-12, &
&   -8.524879049170967D-10,   5.008919358243868D-08,  -2.781695662919303D-06, &
&    1.531678889877636D-04,  -8.425068379266253D-03,   4.633813667107814D-01, &
&   -1.055003344552902D-26,   2.057869834819055D-25,  -4.818825000027461D-24, &
&    7.248326988458622D-23,   1.509142320902557D-22,  -5.088118706117299D-20, &
&    1.998016708193182D-18,  -5.293806946179832D-17,   1.079065585330296D-15, &
&   -1.623245434712245D-14,   7.990341578539689D-14,   8.233260184454086D-12, &
&   -6.152840237677053D-10,   3.555713012905371D-08,  -1.970242549784730D-06, &
&    1.084598631123648D-04,  -5.965759382178945D-03,   3.281182397392349D-01, &
&   -4.797156615628413D-27,   1.120078810466606D-25,  -2.924218392069214D-24, &
&    4.986008267662516D-23,  -1.555563605386485D-22,  -2.406767212491288D-20, &
&    1.064741598327102D-18,  -2.943036417064115D-17,   6.101390522038859D-16, &
&   -9.005652452591188D-15,   2.248104417535391D-14,   6.221321293093536D-12, &
&   -4.392478147912443D-10,   2.519415437082931D-08,  -1.394557257662170D-06, &
&    7.675975161129169D-05,  -4.222073962390213D-03,   2.322149806316074D-01, &
&   -2.349897072667818D-27,   6.412235296052067D-26,  -1.786301032811138D-24, &
&    3.225723722966691D-23,  -1.690132211854217D-22,  -1.274591270894673D-20, &
&    6.104420248301972D-19,  -1.729860044506832D-17,   3.615719230930932D-16, &
&   -5.234051144804520D-15,   2.159385193899585D-15,   4.427979709716329D-12, &
&   -3.031326543941931D-10,   1.731159731937078D-08,  -9.576455604474250D-07, &
&    5.270732031836203D-05,  -2.899082430437592D-03,   1.594501061259439D-01, &
&   -1.235054759650045D-27,   3.686383016542458D-26,  -1.063300409543174D-24, &
&    1.985588368426724D-23,  -1.267854765078194D-22,  -6.921386939448128D-21, &
&    3.504816854584605D-19,  -1.009204810367975D-17,   2.118464930731850D-16, &
&   -3.013568440956036D-15,  -4.042630664792866D-15,   2.939826431158317D-12, &
&   -1.974675196340018D-10,   1.124592534554844D-08,  -6.218549037474217D-07, &
&    3.422433165869140D-05,  -1.882447480741485D-03,   1.035349599637688D-01, &
&   -6.142101512920774D-28,   1.981619807694585D-26,  -5.909169147868561D-25, &
&    1.127063715974887D-23,  -7.971462360152829D-23,  -3.613542910514323D-21, &
&    1.903522345341868D-19,  -5.539701990500039D-18,   1.165542767277199D-16, &
&   -1.634064125595962D-15,  -4.514050932216599D-15,   1.764731461777443D-12, &
&   -1.170848229663251D-10,   6.655799809183072D-09,  -3.679407377149323D-07, &
&    2.024930845311726D-05,  -1.113773597111675D-03,   6.125774476233969D-02, &
&   -2.760286576779818D-28,   9.416439460201140D-27,  -2.841277399120407D-25, &
&    5.490679915205234D-24,  -4.119217910646333D-23,  -1.666400737469498D-21, &
&    9.020546936155844D-20,  -2.643593895100312D-18,   5.568921456687896D-17, &
&   -7.720657315848347D-16,  -2.965575109513646D-15,   8.948273767545240D-13, &
&   -5.889682691668928D-11,   3.343990377118142D-09,  -1.848271383331406D-07, &
&    1.017159455260698D-05,  -5.594676563165404D-04,   3.077081690290475D-02, &
&   -9.021518539918876D-29,   3.220887532530024D-27,  -9.853880301310297D-26, &
&    1.919113796404518D-24,  -1.487945348491022D-23,  -5.629846761205539D-22, &
&    3.100283040604188D-20,  -9.124611338615021D-19,   1.923367878358573D-17, &
&   -2.646411910676103D-16,  -1.208650757359457D-15,   3.207748710869252D-13, &
&   -2.101129086313853D-11,   1.192076118483349D-09,  -6.588059975885424D-08, &
&    3.625561715379191D-06,  -1.994163517453605D-04,   1.096793281110898D-02, &
&   -9.705472238999913D-30,   3.498228466535784D-28,  -1.074808123349371D-26, &
&    2.101520361607574D-25,  -1.654157844616281D-24,  -6.066215708709271D-23, &
&    3.368460972300999D-21,  -9.933998047550827D-20,   2.094523907165612D-18, &
&   -2.870929260741150D-17,  -1.416055229743273D-16,   3.556521650686694D-14, &
&   -2.324256648492998D-12,   1.318202725039297D-10,  -7.284727028444300D-09, &
&    4.008929285128841D-07,  -2.205025576161303D-05,   1.212767731117368D-03, &
&   -7.161509154590012D-28,  -5.563005143691463D-27,   6.143328173227849D-25, &
&   -2.536127463352322D-23,   7.963277292521749D-22,  -2.066094512063430D-20, &
&    4.548774012927792D-19,  -8.374064520155441D-18,   1.119742891581199D-16, &
&    2.494772314174796D-16,  -1.225756645096661D-13,   8.785288916706569D-12, &
&   -5.433230057453494D-10,   3.275314304271890D-08,  -1.966380240560516D-06, &
&    1.179900728928392D-04,  -7.079437010781221D-03,   4.247663170907532D-01, &
&   -6.864871795274189D-28,   2.193443006758255D-27,   1.924710426013837D-25, &
&   -1.029343149606204D-23,   3.604484859609664D-22,  -9.926217422784197D-21, &
&    2.262665879416275D-19,  -4.203928993674973D-18,   5.186121496883642D-17, &
&    5.593603833601295D-16,  -9.144217439343584D-14,   6.269286970100121D-12, &
&   -3.851507375259943D-10,   2.319542897414435D-08,  -1.392402418441819D-06, &
&    8.354830597220045D-05,  -5.012917226202817D-03,   3.007750897537429D-01, &
&   -4.912208297968375D-28,   2.362479306015344D-27,   8.512847225578657D-26, &
&   -5.394473568910086D-24,   2.001000356345767D-22,  -5.671586149293146D-21, &
&    1.312606379083348D-19,  -2.436149496502902D-18,   2.787987456818755D-17, &
&    5.220631968743520D-16,  -6.628028909029534D-14,   4.453510062484482D-12, &
&   -2.727264886673747D-10,   1.641689702956872D-08,  -9.854336666898398D-07, &
&    5.912861412250706D-05,  -3.547728662114259D-03,   2.128637550468597D-01, &
&   -2.157169022470634D-28,   1.784967232631589D-27,   3.970108902924386D-26, &
&   -3.055199177131302D-24,   1.175213194625063D-22,  -3.387546385619986D-21, &
&    7.904780224634178D-20,  -1.461880407854726D-18,   1.563735224351386D-17, &
&    4.092867259970532D-16,  -4.614863800495233D-14,   3.064835526715862D-12, &
&   -1.873289509028898D-10,   1.127309584823576D-08,  -6.766493548037311D-07, &
&    4.060059490048286D-05,  -2.436043154380393D-03,   1.461626116206752D-01, &
&   -2.676285192486800D-28,   1.185640013923196D-27,   2.364450180834412D-26, &
&   -1.738840340493181D-24,   6.848526612463437D-23,  -1.996997020904073D-21, &
&    4.682884974505738D-20,  -8.625855692507825D-19,   8.699006795337792D-18, &
&    2.870155367937465D-16,  -3.023398786609962D-14,   1.992973944526735D-12, &
&   -1.216636861702633D-10,   7.320099508687209D-09,  -4.393665646857911D-07, &
&    2.636299109585113D-05,  -1.581784028047814D-03,   9.490705537825451D-02, &
&   -5.282460609207359D-29,   6.901538687112872D-28,   9.367675248483012D-27, &
&   -9.380566530011243D-25,   3.760839447533378D-23,  -1.103924772240140D-21, &
&    2.596518270570401D-20,  -4.765512221956711D-19,   4.575605483933995D-18, &
&    1.782090909831371D-16,  -1.799484338684262D-14,   1.180322818919055D-12, &
&   -7.199434457094757D-11,   4.331106077927854D-09,  -2.599571422394193D-07, &
&    1.559799298365976D-05,  -9.358821645874196D-04,   5.615293764558124D-02, &
&   -6.463473120250533D-29,   3.490998121450768D-28,   5.134583988194345D-27, &
&   -4.426949463886682D-25,   1.793360072297336D-23,  -5.292794572350601D-22, &
&    1.247265323217070D-20,  -2.282519816588400D-19,   2.109553596498415D-18, &
&    9.230220328061843D-17,  -9.074577957791189D-15,   5.932819674408019D-13, &
&   -3.616751373261391D-11,   2.175615205803964D-09,  -1.305810896473965D-07, &
&    7.835140319684733D-06,  -4.701096796441448D-04,   2.820658456957638D-02, &
&   -1.617041175372663D-29,   1.248988758858111D-28,   1.533881724725768D-27, &
&   -1.517578766461767D-25,   6.191405505836836D-24,  -1.832159615800799D-22, &
&    4.322295355644781D-21,  -7.894054884840362D-20,   7.107860174799934D-19, &
&    3.350825256802995D-17,  -3.242296830745190D-15,   2.115536157646256D-13, &
&   -1.289230100889443D-11,   7.754808460361031D-10,  -4.654428466205568D-08, &
&    2.792753187653309D-06,  -1.675656320909466D-04,   1.005393925191533D-02, &
&   -1.902680349083153D-30,   1.363263006993565D-29,   1.666379340619654D-28, &
&   -1.646296587381751D-26,   6.740125844231033D-25,  -1.997454359866943D-23, &
&    4.714634630222398D-22,  -8.601811646497868D-21,   7.643035423099761D-20, &
&    3.737169233210506D-18,  -3.589227522718763D-16,   2.339678201021734D-14, &
&   -1.425593557309744D-12,   8.574829114973085D-11,  -5.146587525911848D-09, &
&    3.088057784778684D-07,  -1.852839500585881D-05,   1.111703845710264D-03, &
&    1.484489448209882D-28,  -2.815357114960913D-27,   8.666618458486280D-26, &
&   -2.449763314529313D-24,   5.946482746379353D-23,  -1.253944377566575D-21, &
&    2.135812520122770D-20,  -1.590279338212341D-19,  -1.195978563653528D-17, &
&    1.135282065598658D-15,  -7.884638899276370D-14,   5.187180013898469D-12, &
&   -3.378242279684547D-10,   2.196444338990540D-08,  -1.427731857349283D-06, &
&    9.280282000196999D-05,  -6.032184370381808D-03,   3.920919871053975D-01, &
&    3.340572173130820D-29,  -1.282415056850887D-27,   4.274602369707107D-26, &
&   -1.234537752118749D-24,   3.077124621275021D-23,  -6.566275443764126D-22, &
&    1.086667965254902D-20,  -4.225501431873008D-20,  -9.506745850055731D-18, &
&    8.174559325262543D-16,  -5.598617431823496D-14,   3.674556163987014D-12, &
&   -2.392246833807435D-10,   1.555301115849930D-08,  -1.010970896380236D-06, &
&    6.571325505154936D-05,  -4.271362212496728D-03,   2.776385456182170D-01, &
&    8.665150340287460D-29,  -7.244331601983448D-28,   2.278093976468061D-26, &
&   -7.208303068604383D-25,   1.821506400005060D-23,  -3.894613960158413D-22, &
&    6.271620937191663D-21,  -5.967856493649187D-21,  -7.087685048520401D-18, &
&    5.833027974877251D-16,  -3.967785944732102D-14,   2.601103114410492D-12, &
&   -1.693081774694437D-10,   1.100716905294926D-08,  -7.154818441670507D-07, &
&    4.650641266860692D-05,  -3.022917225694620D-03,   1.964896208191602D-01, &
&   -5.763585570652398D-29,  -3.630398533275639D-28,   1.628311957197427D-26, &
&   -4.377237916973648D-25,   1.107202499723137D-23,  -2.373550295249709D-22, &
&    3.732441421712710D-21,   5.697194849373253D-21,  -5.015352992902115D-18, &
&    4.025146528120127D-16,  -2.726805506593795D-14,   1.786279181487878D-12, &
&   -1.162572404081272D-10,   7.558071957550288D-09,  -4.912847259951602D-07, &
&    3.193356613505798D-05,  -2.075682054816155D-03,   1.349193342958632D-01, &
&    7.286538621011519D-29,  -2.687175237993973D-28,   6.974472339419269D-27, &
&   -2.587517167172551D-25,   6.637037067860640D-24,  -1.416339265440916D-22, &
&    2.182601887691699D-21,   7.837549593326657D-21,  -3.319767980960382D-18, &
&    2.622138175927856D-16,  -1.771584622149679D-14,   1.159977463910287D-12, &
&   -7.548961673095320D-11,   4.907652120001387D-09,  -3.190035479997338D-07, &
&    2.073526681068112D-05,  -1.347792500116657D-03,   8.760651295874198D-02, &
&   -4.255854647220689D-29,  -1.220844054758031D-28,   5.929195270099317D-27, &
&   -1.445149063595497D-25,   3.678501666462928D-24,  -7.887450016542896D-23, &
&    1.196227445309550D-21,   6.281764981537868D-21,  -1.989394933349499D-18, &
&    1.554829451101115D-16,  -1.048582514611563D-14,   6.863560001262549D-13, &
&   -4.466472080600225D-11,   2.903675796170342D-09,  -1.887424236933919D-07, &
&    1.226827810597947D-05,  -7.974381664337893D-04,   5.183348107505923D-02, &
&    2.496361103011287D-29,  -6.670932447592841D-29,   1.685375997608765D-27, &
&   -6.930864821759662D-26,   1.785531971562545D-24,  -3.799531964347032D-23, &
&    5.691772772412403D-22,   3.703505619237804D-21,  -1.007732753908769D-18, &
&    7.821596096931265D-17,  -5.268561524663585D-15,   3.447821755973670D-13, &
&   -2.243597464773974D-11,   1.458567040745678D-09,  -9.480856430402675D-08, &
&    6.162566723921889D-06,  -4.005668808166321D-04,   2.603684737869031D-02, &
&   -3.364569857641561D-30,  -1.992518204804211D-29,   8.934418478466333D-28, &
&   -2.412991942479272D-26,   6.168663735125259D-25,  -1.318736097805750D-23, &
&    1.959818111724230D-22,   1.440083820662059D-21,  -3.610442456370094D-19, &
&    2.790435051096429D-17,  -1.878220568962775D-15,   1.228970015648215D-13, &
&   -7.997092447309081D-12,   5.198910070855326D-10,  -3.379351275351867D-08, &
&    2.196581845769768D-06,  -1.427778353037350D-04,   9.280559338757613D-03, &
&    1.527325108986908D-31,  -2.398331583177078D-30,   8.388342703169432D-29, &
&   -2.627717539117306D-27,   6.750346921319041D-26,  -1.439573037977765D-24, &
&    2.130535230661056D-23,   1.655671284751120D-22,  -4.001970247201694D-20, &
&    3.086821001998715D-18,  -2.076980153874401D-16,   1.358936845991474D-14, &
&   -8.842715424117606D-13,   5.748641566104997D-11,  -3.736682478483564D-09, &
&    2.428847466068273D-07,  -1.578751021008397D-05,   1.026188168482139D-03, &
&    1.452282562329314D-29,  -2.092102631983024D-28,   5.208410994778133D-27, &
&   -1.272359772785340D-25,   2.537633482542155D-24,  -3.171362445158825D-23, &
&   -7.945202081626314D-22,   1.118712150906070D-19,  -8.774592939878776D-18, &
&    6.283636189519721D-16,  -4.417329668538177D-14,   3.094318103111533D-12, &
&   -2.166242758652468D-10,   1.516388696010293D-08,  -1.061473406517032D-06, &
&    7.430314580489872D-05,  -5.201220236766803D-03,   3.640854166569432D-01, &
&    4.060091496403510D-30,  -1.405951046384147D-28,   2.910528303205264D-27, &
&   -6.786464218781683D-26,   1.349723144450702D-24,  -1.401530069820632D-23, &
&   -7.084650991203608D-22,   8.149265464309421D-20,  -6.245163964415329D-18, &
&    4.453394792043813D-16,  -3.128327793057288D-14,   2.191114067278087D-12, &
&   -1.533909963191812D-10,   1.073748135473612D-08,  -7.516244839134028D-07, &
&    5.261371829176956D-05,  -3.682960298800784D-03,   2.578072209665730D-01, &
&    2.073006317385856D-29,   2.380035060974375D-30,   1.191351933327979D-27, &
&   -4.322577103956465D-26,   8.092264888547523D-25,  -6.935598712166146D-24, &
&   -5.532675980499432D-22,   5.849369121086475D-20,  -4.431446530491762D-18, &
&    3.153212409065234D-16,  -2.214134603507115D-14,   1.550705100690949D-12, &
&   -1.085575995464264D-10,   7.599102902881577D-09,  -5.319377062129488D-07, &
&    3.723564225900848D-05,  -2.606494969908742D-03,   1.824546479260692D-01, &
&   -2.838381033031315D-29,  -1.088403835268767D-28,   1.909474832763400D-27, &
&   -2.366618603311844D-26,   4.783012738718107D-25,  -3.568385061878601D-24, &
&   -4.015187294871267D-22,   4.051096191350972D-20,  -3.047792578202378D-18, &
&    2.165776758875460D-16,  -1.520402542567042D-14,   1.064796330849339D-12, &
&   -7.454098530533850D-11,   5.217914178814890D-09,  -3.652543137093023D-07, &
&    2.556780376618639D-05,  -1.789746271179999D-03,   1.252822390034300D-01, &
&    2.732001397773797D-29,   5.507898951585453D-30,  -9.879250965958503D-29, &
&   -1.611656660843827D-26,   2.988495336761174D-25,  -1.771404272902672D-24, &
&   -2.701166552420350D-22,   2.645379302978501D-20,  -1.981148245998585D-18, &
&    1.406566029626375D-16,  -9.872660934388931D-15,   6.914019626598705D-13, &
&   -4.840135854771037D-11,   3.388122916250443D-09,  -2.371688020384732D-07, &
&    1.660181725714145D-05,  -1.162127212660941D-03,   8.134890489914447D-02, &
&   -4.730164526838270D-30,  -1.842801427857800D-29,   5.112491909065360D-28, &
&   -8.453185554567452D-27,   1.593173279248918D-25,  -8.452860938780671D-25, &
&   -1.635107453322132D-22,   1.571181218772564D-20,  -1.173035626123997D-18, &
&    8.323227391827393D-17,  -5.841406394758404D-15,   4.090777590895766D-13, &
&   -2.863727462982456D-11,   2.004625056226117D-09,  -1.403238666701422D-07, &
&    9.822671302293680D-06,  -6.875869938200849D-04,   4.813108957475983D-02, &
&   -1.892691067587081D-30,  -5.692651649870281D-30,   2.268430702451361D-28, &
&   -4.157524325481102D-27,   7.684175939302055D-26,  -3.538580237997584D-25, &
&   -8.339010172817303D-23,   7.912502311861261D-21,  -5.895271914585671D-19, &
&    4.181272960308069D-17,  -2.934280636329328D-15,   2.054871888183093D-13, &
&   -1.438499803141200D-11,   1.006957602403706D-09,  -7.048708731694722D-08, &
&    4.934096423189237D-06,  -3.453867509257154D-04,   2.417707256840338D-02, &
&    7.140983598441075D-31,  -2.985511675108841D-30,   4.364293959146204D-29, &
&   -1.425510404771444D-27,   2.699433151585943D-26,  -1.109032789321215D-25, &
&   -3.000130577367251D-23,   2.824775791889717D-21,  -2.101949747585692D-19, &
&    1.490452955423404D-17,  -1.045902619646533D-15,   7.324382905596791D-14, &
&   -5.127381409824151D-12,   3.589194105196057D-10,  -2.512437806545285D-08, &
&    1.758706573624208D-06,  -1.231094606105143D-04,   8.617662244000205D-03, &
&    2.287906221476593D-32,  -2.097132102619972D-31,   6.194536936114239D-30, &
&   -1.585317831204894D-28,   2.928375653114245D-27,  -1.142423503279911D-26, &
&   -3.331847971661894D-24,   3.125818963066406D-22,  -2.324549283668473D-20, &
&    1.648096460421001D-18,  -1.156500827721066D-16,   8.098864787042485D-15, &
&   -5.669548906705465D-13,   3.968713970499845D-11,  -2.778101899212843D-09, &
&    1.944671449058889D-07,  -1.361270019352939D-05,   9.528890136857724D-04, &
&   -1.020749419911775D-29,  -8.346573003806409D-30,   5.026827808390421D-28, &
&   -3.317507561016829D-27,  -3.991183052478841D-26,   8.729089550161615D-24, &
&   -7.703909731083517D-22,   5.981423026533982D-20,  -4.518368817783399D-18, &
&    3.393384738761792D-16,  -2.545623656546325D-14,   1.909283104784622D-12, &
&   -1.431968657344437D-10,   1.073977013658155D-08,  -8.054827956462873D-07, &
&    6.041120986458490D-05,  -4.530840740612091D-03,   3.398130555479516D-01, &
&    7.818766484545036D-29,  -2.108854030309892D-29,  -2.017901443628394D-27, &
&   -1.222909590591153D-27,  -1.563907521354523D-26,   6.428192171398325D-24, &
&   -5.498203250946836D-22,   4.241633152029249D-20,  -3.200273696760830D-18, &
&    2.402941100777892D-16,  -1.802555194884440D-14,   1.351955635346269D-12, &
&   -1.013970544806806D-10,   7.604782241755743D-09,  -5.703586896816265D-07, &
&    4.277690184292046D-05,  -3.208267638690293D-03,   2.406200729030308D-01, &
&   -2.098363990669873D-28,   3.739684392150021D-29,   5.745319874933334D-27, &
&   -1.912505388078339D-27,  -9.666611084049168D-26,   4.655247794491071D-24, &
&   -3.901778425493715D-22,   3.004201707743073D-20,  -2.265208243228373D-18, &
&    1.700641668344372D-16,  -1.275703738655944D-14,   9.568028668780875D-13, &
&   -7.176045956511110D-11,   5.382036493670646D-09,  -4.036527508956428D-07, &
&    3.027395639251757D-05,  -2.270546729743459D-03,   1.702910047315748D-01, &
&    2.858484052469635D-28,  -5.182200343572006D-29,  -7.634446736298587D-27, &
&    7.482914848393011D-28,   6.026550386309027D-26,   3.215866575499687D-24, &
&   -2.693413480464781D-22,   2.063849192681721D-20,  -1.555537401980935D-18, &
&    1.167760120869740D-16,  -8.759620657630844D-15,   6.569875722320504D-13, &
&   -4.927422453905169D-11,   3.695568140305366D-09,  -2.771676194345785D-07, &
&    2.078757150607251D-05,  -1.559067863151724D-03,   1.169300897369054D-01, &
&   -2.103716081425998D-28,   3.345018278928870D-29,   5.664327067259484D-27, &
&   -1.162243582908912D-27,  -7.955264920583156D-26,   2.122767693757326D-24, &
&   -1.744833272240911D-22,   1.340540231437927D-20,  -1.010112332695297D-18, &
&    7.582633824271905D-17,  -5.687849706671290D-15,   4.265986088955480D-13, &
&   -3.199499236469898D-11,   2.399625230796058D-09,  -1.799718978237926D-07, &
&    1.349789236681088D-05,  -1.012341927632505D-03,   7.592564457276427D-02, &
&    7.997007037677310D-29,  -1.315640110215372D-29,  -2.135092733639193D-27, &
&    1.681282302373124D-28,   1.338864469430150D-26,   1.254268447146960D-24, &
&   -1.037118880240843D-22,   7.933310800922502D-21,  -5.976689449562005D-19, &
&    4.486389666906419D-17,  -3.365290164667328D-15,   2.524023940109655D-13, &
&   -1.893023471180534D-11,   1.419768062069002D-09,  -1.064826078054787D-07, &
&    7.986195602577558D-06,  -5.989646702629344D-04,   4.492235026990693D-02, &
&   -1.195833153247434D-29,   3.943285785326040D-31,   3.355926733017644D-28, &
&   -8.573490945295530D-29,  -9.148974594710450D-27,   6.341553656323483D-25, &
&   -5.204184440927770D-23,   3.985636003927404D-21,  -3.002280547102583D-19, &
&    2.253600818865961D-17,  -1.690444132208999D-15,   1.267860659698677D-13, &
&   -9.508981957614363D-12,   7.131738715377301D-10,  -5.348804190949181D-08, &
&    4.011603151630348D-06,  -3.008702364064316D-04,   2.256526773057409D-02, &
&    1.289242903337805D-31,   2.807098103903326D-31,  -2.778815606792875D-30, &
&   -3.355535718203227D-29,  -1.873127758014010D-27,   2.266202311283714D-25, &
&   -1.856728985209012D-23,   1.420771536250709D-21,  -1.070149408564569D-19, &
&    8.032744940417016D-18,  -6.025412089199110D-16,   4.519155686200129D-14, &
&   -3.389376236930886D-12,   2.542032966034924D-10,  -1.906524778714516D-08, &
&    1.429893586991003D-06,  -1.072420190363182D-04,   8.043151427756076D-03, &
&    1.579562180753751D-32,  -2.739625563672527D-32,  -1.098794711757785D-31, &
&   -2.097562530135918D-30,  -2.138821132571529D-28,   2.506868092991166D-26, &
&   -2.053471058924465D-24,   1.571075552112266D-22,  -1.183316403253711D-20, &
&    8.882136018999742D-19,  -6.662537877305245D-17,   4.997009384508969D-15, &
&   -3.747767429782935D-13,   2.810826437306920D-11,  -2.108119887445061D-09, &
&    1.581089918827128D-07,  -1.185817439251990D-05,   8.893630794425292D-04, &
&   -2.408782063243776D-30,   1.563356471121174D-30,   5.063255226322514D-29, &
&    5.041094198767870D-28,  -5.514280265297868D-26,   4.578887375676259D-24, &
&   -3.699213618935119D-22,   2.965545154347104D-20,  -2.373376764577681D-18, &
&    1.898830596910035D-16,  -1.519080315851128D-14,   1.215265965099630D-12, &
&   -9.722129328804954D-11,   7.777703591569998D-09,  -6.222162881760776D-07, &
&    4.977730305856061D-05,  -3.982184244702401D-03,   3.185747395762377D-01, &
&    2.865430095077507D-30,  -2.040574232210855D-29,  -4.666346169857034D-30, &
&    9.763564007064216D-28,  -4.003725569624213D-26,   3.241839233496093D-24, &
&   -2.620311572781690D-22,   2.100041399941962D-20,  -1.680596718414315D-18, &
&    1.344555544709425D-16,  -1.075654069699233D-14,   8.605243015875391D-13, &
&   -6.884195398554281D-11,   5.507356397927798D-09,  -4.405885123593236D-07, &
&    3.524708099151734D-05,  -2.819766479332292D-03,   2.255813183466118D-01, &
&    1.202684034922407D-29,   5.793297008870708D-29,  -4.901072931380298D-28, &
&   -1.254895451404620D-27,  -2.033792623081509D-26,   2.318455285766802D-24, &
&   -1.855492938086851D-22,   1.486280452272065D-20,  -1.189394769210622D-18, &
&    9.515662073154792D-17,  -7.612591601092344D-15,   6.090080023812477D-13, &
&   -4.872064656120694D-11,   3.897651776106471D-09,  -3.118121424291975D-07, &
&    2.494497139613720D-05,  -1.995597711698076D-03,   1.596478169358646D-01, &
&   -2.629489768116069D-29,  -7.445254989747166D-29,   8.878271223805466D-28, &
&    2.200512545234590D-27,  -3.129353723091514D-26,   1.559255828521920D-24, &
&   -1.272986826559052D-22,   1.020597495426321D-20,  -8.167001719618497D-19, &
&    6.533920473744342D-17,  -5.227176212535446D-15,   4.181745308232898D-13, &
&   -3.345396656949048D-11,   2.676317358590575D-09,  -2.141053889072710D-07, &
&    1.712843111374650D-05,  -1.370274489104316D-03,   1.096219591283573D-01, &
&    1.327134771673120D-29,   4.867927962259882D-29,  -4.590636661039382D-28, &
&   -1.176593139894576D-27,  -6.137588718917632D-27,   1.041914953139524D-24, &
&   -8.276707345156318D-23,   6.626936472153015D-21,  -5.303050207167265D-19, &
&    4.242640513542615D-17,  -3.394137007438505D-15,   2.715312291626348D-13, &
&   -2.172250087669208D-11,   1.737800090628646D-09,  -1.390240073869191D-07, &
&    1.112192059167744D-05,  -8.897536473370542D-04,   7.118029178697182D-02, &
&    6.132182617559748D-30,  -1.877027811088816D-29,  -1.440093941045093D-28, &
&    5.917380774843891D-28,  -6.073845527617388D-27,   6.021630920499684D-25, &
&   -4.895242455007015D-23,   3.921042281137075D-21,  -3.137622516268514D-19, &
&    2.510211628881417D-17,  -2.008183376216162D-15,   1.606548236350639D-13, &
&   -1.285238734579968D-11,   1.028190999394160D-09,  -8.225528002978562D-08, &
&    6.580422402797712D-06,  -5.264337922254563D-04,   4.211470337804079D-02, &
&   -6.241273970776143D-30,   4.525275754755498D-30,   1.698727270308976D-28, &
&   -7.812935641502700D-29,  -5.626661948889967D-27,   3.067734436866735D-25, &
&   -2.457632352068893D-23,   1.969596819134548D-21,  -1.576084188747878D-19, &
&    1.260922650528540D-17,  -1.008745010571617D-15,   8.069967613832236D-14, &
&   -6.455974804859421D-12,   5.164779901458008D-10,  -4.131823925008589D-08, &
&    3.305459140210649D-06,  -2.644367312176574D-04,   2.115493849741470D-02, &
&    7.353637196725501D-31,  -3.602448766780644D-31,  -2.093147716959704D-29, &
&    2.336798194760646D-29,  -1.082219324999760D-27,   1.088021232457593D-25, &
&   -8.765766122884152D-24,   7.020487639318731D-22,  -5.617788398895915D-20, &
&    4.494426192105758D-18,  -3.595565140204056D-16,   2.876454754674617D-14, &
&   -2.301164054355600D-12,   1.840931263703489D-10,  -1.472745012312537D-08, &
&    1.178196009921634D-06,  -9.425568079401381D-05,   7.540454463521847D-03, &
&    2.001228846920662D-32,  -1.512399371685878D-32,  -5.368284674463136D-31, &
&    2.068729852375043D-30,  -1.409484934835168D-28,   1.203590968755066D-26, &
&   -9.691435281700159D-25,   7.762847306637650D-23,  -6.211813862897512D-21, &
&    4.969665174522510D-19,  -3.975758679667772D-17,   3.180609843952809D-15, &
&   -2.544488150250753D-13,   2.035590542396945D-11,  -1.628472435399490D-09, &
&    1.302777948398219D-07,  -1.042222358721684D-05,   8.337778869774287D-04/
      data w9 / &
&   -1.601354835927805D-17,   4.753012085691610D-16,  -8.237656658954384D-15, &
&    1.209284352738779D-13,  -1.694852600899309D-12,   2.271303563368792D-11, &
&   -2.845797898800830D-10,   3.282885090454245D-09,  -3.450203348279911D-08, &
&    3.269306989813087D-07,  -2.758809054467755D-06,   2.041105779629608D-05, &
&   -1.297200023220680D-04,   6.886469261084147D-04,  -2.932265048388534D-03, &
&    9.390969918516508D-03,  -2.011390531321750D-02,   2.161601352648331D-02, &
&   -2.164480470615136D-17,   6.412846166535901D-16,  -1.114081307187102D-14, &
&    1.650892801903590D-13,  -2.349497551563379D-12,   3.207684713838680D-11, &
&   -4.103494773759580D-10,   4.844164080454344D-09,  -5.223096114065009D-08, &
&    5.092211210068864D-07,  -4.435487792148864D-06,   3.399641485592848D-05, &
&   -2.247543816160218D-04,   1.246985865357819D-03,  -5.578965660809226D-03, &
&    1.888954213876028D-02,  -4.308018314784982D-02,   4.971454889496980D-02, &
&   -6.877005702285662D-18,   2.472452883421376D-16,  -5.249418452273460D-15, &
&    9.042322336555541D-14,  -1.403026662658149D-12,   2.016100909664805D-11, &
&   -2.688837144884268D-10,   3.312367870856124D-09,  -3.742030382418416D-08, &
&    3.841897666100909D-07,  -3.544449242254016D-06,   2.896312290864170D-05, &
&   -2.056607521773932D-04,   1.236045391929228D-03,  -6.049801076204018D-03, &
&    2.267019181819613D-02,  -5.801979434692538D-02,   7.642573025488906D-02, &
&   -8.737680852001782D-18,   2.214119332107191D-16,  -3.099479194905891D-15, &
&    3.804670993097029D-14,  -5.091364222098659D-13,   7.248698450210508D-12, &
&   -1.009573412140221D-10,   1.320470122138163D-09,  -1.597149917842042D-08, &
&    1.769037019092753D-07,  -1.775451158475467D-06,   1.593176644907861D-05, &
&   -1.255775267962020D-04,   8.483413829275608D-04,  -4.736595079732568D-03, &
&    2.061198809233425D-02,  -6.264413189059873D-02,   1.009420441062872D-01, &
&    4.013863579732922D-18,  -8.296706286064919D-17,   6.769856819014214D-16, &
&   -5.690089351581887D-16,  -6.633953930593015D-14,   1.388828827185037D-12, &
&   -2.204356353376006D-11,   3.160276389110065D-10,  -4.196042103873610D-09, &
&    5.146465064411242D-08,  -5.780982920723406D-07,   5.877647861879428D-06, &
&   -5.324158977989526D-05,   4.202870601084349D-04,  -2.797748094241969D-03, &
&    1.488542829911994D-02,  -5.719238396175375D-02,   1.225552067114785D-01, &
&   -3.274120462688455D-18,   7.229455788352772D-17,  -7.395204845921214D-16, &
&    4.839516879511933D-15,  -2.714257057417429D-14,   2.174658957004664D-13, &
&   -2.889220321848936D-12,   4.429330010822247D-11,  -6.596615935948562D-10, &
&    9.220152764387809D-09,  -1.196396096380224D-07,   1.426572900669002D-06, &
&   -1.542383731441025D-05,   1.484000211936056D-04,  -1.235541542989812D-03, &
&    8.502396857910617D-03,  -4.429748170958534D-02,   1.406429146706507D-01, &
&    2.103782314469029D-18,  -4.616598730236863D-17,   4.626559164939964D-16, &
&   -2.794392245462373D-15,   1.109655401965928D-14,  -2.456263881914291D-14, &
&   -1.057763892655260D-13,   3.154538240641022D-12,  -5.684783874962076D-11, &
&    9.410295287316381D-10,  -1.465362168905370D-08,   2.134703490672809D-07, &
&   -2.879819900015929D-06,   3.546169655772333D-05,  -3.900951868768006D-04, &
&    3.701037358779592D-03,  -2.827939647312523D-02,   1.546846751262652D-01, &
&   -1.195311221780442D-18,   2.625051031321795D-17,  -2.635309782410733D-16, &
&    1.601902825133087D-15,  -6.587478421427188D-15,   1.951978589576037D-14, &
&   -4.655541123481550D-14,   1.733441452482206D-13,  -2.330816366600319D-12, &
&    4.615029229637983D-11,  -9.070122935439696D-10,   1.706603607345393D-08, &
&   -3.049494858690028D-07,   5.127153912292767D-06,  -8.000159254967218D-05, &
&    1.132432512523979D-03,  -1.401760936806855D-02,   1.642764837458327D-01, &
&    3.890435356734456D-19,  -8.545860672379371D-18,   8.581002075804860D-17, &
&   -5.216351890348636D-16,   2.143119858744034D-15,  -6.290465918658503D-15, &
&    1.357467331665506D-14,  -2.117574883920609D-14,   3.158185371413270D-15, &
&    6.351752998812909D-13,  -1.808875984870766D-11,   4.879763722102038D-10, &
&   -1.289827869344598D-08,   3.341315545690410D-07,  -8.510527733776473D-06, &
&    2.160130038588689D-04,  -5.688447122209036D-03,   1.691423829631436D-01, &
&   -4.406066330076571D-19,   3.957861199192160D-18,  -5.473566479142261D-17, &
&    9.537109290053075D-16,  -1.417513843170180D-14,   1.933531343562732D-13, &
&   -2.449369635389324D-12,   2.851408790567337D-11,  -3.023995015706103D-10, &
&    2.893324175769522D-09,  -2.467277192735408D-08,   1.846356849142979D-07, &
&   -1.188134700624888D-06,   6.394189683220706D-06,  -2.763915294754592D-05, &
&    9.000491087159312D-05,  -1.963864977787729D-04,   2.154925624588029D-04, &
&   -6.148226628518763D-19,   5.627844887002259D-18,  -8.016618419256674D-17, &
&    1.424216996791893D-15,  -2.172001500778978D-14,   3.052261987722696D-13, &
&   -3.994930278081653D-12,   4.822131884123442D-11,  -5.324198973153119D-10, &
&    5.327808666639922D-09,  -4.776311832028490D-08,   3.779790953544855D-07, &
&   -2.589515834424934D-06,   1.495234439118708D-05,  -6.997445715592389D-05, &
&    2.493354432970875D-04,  -6.028928127855786D-04,   7.445401960926015D-04, &
&   -3.784792115163786D-19,   3.583449104499434D-18,  -5.375833474330530D-17, &
&    9.889718999999986D-16,  -1.578468754070185D-14,   2.337049606241411D-13, &
&   -3.238291545568041D-12,   4.162586593165649D-11,  -4.927286816881121D-10, &
&    5.325821249214780D-09,  -5.201003253333536D-08,   4.526827740974199D-07, &
&   -3.448788734547225D-06,   2.243050061829144D-05,  -1.200340500911727D-04, &
&    4.980529022370007D-04,  -1.434372601046464D-03,   2.173120821011689D-03, &
&   -1.281742475189724D-19,   1.274118147993176D-18,  -2.054678872461705D-17, &
&    3.975583779401776D-16,  -6.767811399039471D-15,   1.077881835459092D-13, &
&   -1.616812601472759D-12,   2.267049548655363D-11,  -2.952533779949276D-10, &
&    3.545042812072717D-09,  -3.887308630936834D-08,   3.845943415853351D-07, &
&   -3.377922765404665D-06,   2.574993058057080D-05,  -1.647449982317001D-04, &
&    8.376534716343620D-04,  -3.053519468220097D-03,   6.144325178340060D-03, &
&   -2.431046197536248D-20,   2.576178600420542D-19,  -4.551687339410442D-18, &
&    9.414560981178566D-17,  -1.741474225416264D-15,   3.042888772433491D-14, &
&   -5.045140134764375D-13,   7.889008906468089D-12,  -1.157177820721684D-10, &
&    1.582112282496315D-09,  -1.999995045281173D-08,   2.313334981461134D-07, &
&   -2.414295952156451D-06,   2.229303213584724D-05,  -1.768756217800317D-04, &
&    1.149525627856560D-03,  -5.585786009300688D-03,   1.616775779999200D-02, &
&   -2.446510215534413D-21,   2.813145600219752D-20,  -5.551319262806872D-19, &
&    1.249563868679938D-17,  -2.561128558958849D-16,   5.009765535400923D-15, &
&   -9.377563901546361D-14,   1.671795013661996D-12,  -2.826290107192240D-11, &
&    4.507408552888171D-10,  -6.736656990496553D-09,   9.355106085774781D-08, &
&   -1.193296708086948D-06,   1.375756132651195D-05,  -1.399527555292354D-04, &
&    1.207984622431573D-03,  -8.194609223002285D-03,   3.740678234998780D-02, &
&   -1.170500399056332D-22,   1.471516191431791D-21,  -3.305426139387682D-20, &
&    8.287866595319866D-19,  -1.926465770206563D-17,   4.319475786112219D-16, &
&   -9.356047202385424D-15,   1.950911070601085D-13,  -3.903455088383018D-12, &
&    7.464575915002440D-11,  -1.357448663364928D-09,   2.332272752190681D-08, &
&   -3.753101814451668D-07,   5.588332575477512D-06,  -7.562246659807587D-05, &
&    9.031333297049982D-04,  -8.958070980915718D-03,   7.268787838082705D-02, &
&   -1.043460403935698D-24,   2.727554875582836D-23,  -7.733199934643420D-22, &
&    2.160351940101419D-20,  -5.874995625554354D-19,   1.562366008394947D-17, &
&   -4.055691663538532D-16,   1.025801015940712D-14,  -2.522709045787548D-13, &
&    6.016668417808258D-12,  -1.387130143589126D-10,   3.078494713607810D-09, &
&   -6.540445733673302D-08,   1.319941576507278D-06,  -2.500588340521875D-05, &
&    4.360549243436647D-04,  -6.839462938073001D-03,   1.149608020237690D-01, &
&   -3.172564051312313D-25,   4.567967371845006D-25,   4.834336423192222D-24, &
&    1.022455530340753D-22,  -3.852785677797833D-21,   1.269409149193057D-19, &
&   -4.244837278592354D-18,   1.399602241928142D-16,  -4.570290727881356D-15, &
&    1.471369773993034D-13,  -4.676123075521913D-12,   1.463300263151309D-10, &
&   -4.512386252126737D-09,   1.371534718416513D-07,  -4.137845808833866D-06, &
&    1.259728568400992D-04,  -4.032335730020685D-03,   1.452116102980345D-01, &
&   -3.751612299537435D-21,   3.394463427240700D-20,  -4.746672334733538D-19, &
&    8.327277723535063D-18,  -1.248774156548490D-16,   1.720635351462092D-15, &
&   -2.203294320650519D-14,   2.595085001542953D-13,  -2.787456296746280D-12, &
&    2.704465488692891D-11,  -2.341847100202608D-10,   1.782397038502331D-09, &
&   -1.168714081180171D-08,   6.422853939709103D-08,  -2.842432105486038D-07, &
&    9.506133862878238D-07,  -2.138301986333476D-06,   2.430310998307087D-06, &
&   -5.802706981938971D-21,   5.406959524087059D-20,  -7.913858483838331D-19, &
&    1.431167251345553D-17,  -2.233725686115097D-16,   3.223139487764634D-15, &
&   -4.341654812617795D-14,   5.409245508882114D-13,  -6.185496619054791D-12, &
&    6.435345429712508D-11,  -6.025015653562788D-10,   5.005345144963846D-09, &
&   -3.621948163664928D-08,   2.225130048892347D-07,  -1.117741874284484D-06, &
&    4.322050684439030D-06,  -1.150067486882349D-05,   1.592756072866264D-05, &
&   -4.256925380783974D-21,   4.170561012195248D-20,  -6.580769989041260D-19, &
&    1.253184208350210D-17,  -2.090298933257587D-16,   3.252733553590258D-15, &
&   -4.756684849521359D-14,   6.486052643564629D-13,  -8.192236894777975D-12, &
&    9.511411903057760D-11,  -1.005346094841038D-09,   9.554825755871013D-09, &
&   -8.031459318840734D-08,   5.835088759432036D-07,  -3.541565633874414D-06, &
&    1.699229015776042D-05,  -5.808330826555760D-05,   1.087221952130871D-04, &
&   -1.823504957287074D-21,   1.911619334608229D-20,  -3.323685679424149D-19, &
&    6.786327226807807D-18,  -1.234906424722355D-16,   2.117630806260004D-15, &
&   -3.438654367732052D-14,   5.253978880843525D-13,  -7.511695631125149D-12, &
&    9.983623851569864D-11,  -1.223313288495157D-09,   1.367206051153379D-08, &
&   -1.373906887668979D-07,   1.216764972670461D-06,  -9.217704457999829D-06, &
&    5.689585456502258D-05,  -2.607995774025752D-04,   7.054934261307589D-04, &
&   -4.585380781805939D-22,   5.222543931325382D-21,  -1.016861381171138D-19, &
&    2.261768253662411D-18,  -4.565123862161770D-17,   8.770382034015431D-16, &
&   -1.608281363043200D-14,   2.800904020870789D-13,  -4.611445480473366D-12, &
&    7.138165259278242D-11,  -1.031621186019898D-09,   1.379496394029767D-08, &
&   -1.686311704546043D-07,   1.852770406892193D-06,  -1.784053656960061D-05, &
&    1.445269800352161D-04,  -9.088950840236471D-04,   3.758246579608338D-03, &
&   -6.363175872573666D-23,   7.991052953626445D-22,  -1.766799223384884D-20, &
&    4.348878242246017D-19,  -9.888172908436041D-18,   2.160735998754854D-16, &
&   -4.543753266332486D-15,   9.159412832413039D-14,  -1.763472016056868D-12, &
&    3.228302706896242D-11,  -5.587568750237723D-10,   9.077010840728947D-09, &
&   -1.370466920144194D-07,   1.896993881828833D-06,  -2.358931118809411D-05, &
&    2.551507085739362D-04,  -2.237006742545156D-03,   1.507770440392900D-02, &
&   -4.285795177409765D-24,   6.041036495628211D-23,  -1.540658309090107D-21, &
&    4.275834929989745D-20,  -1.115283319110632D-18,   2.821920538881968D-17, &
&   -6.931672069672495D-16,   1.647683557415836D-14,  -3.780282691080668D-13, &
&    8.342796939299102D-12,  -1.763274435476083D-10,   3.549764991010662D-09, &
&   -6.755956015016393D-08,   1.203396320978455D-06,  -1.976154870939546D-05, &
&    2.917997516596785D-04,  -3.652331103980637D-03,   4.362434793004140D-02, &
&   -1.099462239998225D-25,   1.756339588058735D-24,  -5.268609656418206D-23, &
&    1.697469211665667D-21,  -5.223257547529903D-20,   1.572120787895450D-18, &
&   -4.642484793351913D-17,   1.340161708932307D-15,  -3.776481882899053D-14, &
&    1.036761477664292D-12,  -2.764273360401117D-11,   7.134193390252550D-10, &
&   -1.773540582198705D-08,   4.218666468020695D-07,  -9.499051045770327D-06, &
&    1.990279440462171D-04,  -3.853185139172273D-03,   8.919890522424387D-02, &
&    7.391501630002467D-28,  -6.502943275134983D-28,  -7.511760234142483D-25, &
&    1.156028398203521D-23,  -4.363239948028890D-22,   2.434076028880986D-20, &
&   -7.334597115765828D-19,   2.943891257151406D-17,  -1.094290247152378D-15, &
&    3.944514833311215D-14,  -1.443691733927742D-12,   5.134568102594808D-11, &
&   -1.821516204870351D-09,   6.376719912309889D-08,  -2.238503430643774D-06, &
&    7.995627331067905D-05,  -3.026159596599014D-03,   1.277556128757493D-01, &
&   -3.318715829838716D-23,   3.032693542486416D-22,  -4.305786113062271D-21, &
&    7.627186448774117D-20,  -1.158341964857529D-18,   1.619244451919794D-17, &
&   -2.106128550038116D-16,   2.523611915565299D-15,  -2.762678852238277D-14, &
&    2.737611391320384D-13,  -2.427110730063786D-12,   1.896897381620932D-11, &
&   -1.281650601300354D-10,   7.288558949893516D-10,  -3.355086639002282D-09, &
&    1.174718319849078D-08,  -2.789592385234590D-08,   3.384897607066303D-08, &
&   -6.005192044336950D-23,   5.740163417438537D-22,  -8.730873468043290D-21, &
&    1.620536866380216D-19,  -2.615955146678670D-18,   3.922825455311940D-17, &
&   -5.511343590596283D-16,   7.193993122164022D-15,  -8.663841637828358D-14, &
&    9.550411605188765D-13,  -9.540245708005702D-12,   8.526219251074842D-11, &
&   -6.702519857836390D-10,   4.526674602451521D-09,  -2.536840902400743D-08, &
&    1.115326553449214D-07,  -3.462383930268314D-07,   5.821410106317339D-07, &
&   -5.646314602863082D-23,   5.794032327640763D-22,  -9.772792867661170D-21, &
&    1.951279341881032D-19,  -3.453893604658529D-18,   5.744115288921697D-17, &
&   -9.026294560972882D-16,   1.331307397927630D-14,  -1.832542428629584D-13, &
&    2.338496577272041D-12,  -2.743268234901007D-11,   2.926398258549298D-10, &
&   -2.797978508908793D-09,   2.349777762870714D-08,  -1.682039074680042D-07, &
&    9.774573004151853D-07,  -4.201368411509096D-06,   1.064262921927935D-05, &
&   -3.275959661806543D-23,   3.670222832897444D-22,  -6.986355682635103D-21, &
&    1.526149686320119D-19,  -3.013625485716231D-18,   5.651229356931881D-17, &
&   -1.009575763800745D-15,   1.709259687906968D-14,  -2.729661171824493D-13, &
&    4.088780737175428D-12,  -5.704043265716249D-11,   7.343141920284358D-10, &
&   -8.617005470175130D-09,   9.060733108997669D-08,  -8.320903105440602D-07, &
&    6.406631897746771D-06,  -3.808388619824153D-05,   1.490440108585782D-04, &
&   -1.148524167917788D-23,   1.421278307955336D-22,  -3.080503841386622D-21, &
&    7.451211088314331D-20,  -1.658814755326755D-18,   3.540281713850723D-17, &
&   -7.253220490035365D-16,   1.420789386928420D-14,  -2.650727806044654D-13, &
&    4.687331999404985D-12,  -7.810933795800350D-11,   1.217074959098818D-09, &
&   -1.755058307744583D-08,   2.309257064770204D-07,  -2.713259615475502D-06, &
&    2.755977871833941D-05,  -2.238864844736481D-04,   1.383834889637217D-03, &
&   -2.255890634632219D-24,   3.115284487393149D-23,  -7.746041534751249D-22, &
&    2.097612956643436D-20,  -5.313555279665438D-19,   1.302570408655742D-17, &
&   -3.085062299937061D-16,   7.045332149308032D-15,  -1.547321711706027D-13, &
&    3.250348348905348D-12,  -6.508767318400909D-11,   1.233927325737950D-09, &
&   -2.195783260015940D-08,   3.628305545690685D-07,  -5.469230750223927D-06, &
&    7.337571528806742D-05,  -8.100127168513628D-04,   8.188181950174326D-03, &
&   -2.169687457147770D-25,   3.382174082098992D-24,  -9.854625968579194D-23, &
&    3.016093205318735D-21,  -8.758240090861710D-20,   2.516907364166765D-18, &
&   -6.958041732729854D-17,   1.872824086174937D-15,  -4.918342279984926D-14, &
&    1.240702626299770D-12,  -3.024984745789420D-11,   7.068911941449839D-10, &
&   -1.572098247967780D-08,   3.307116575761465D-07,  -6.483014236097349D-06, &
&    1.159607405673341D-04,  -1.774456726519861D-03,   3.077283456218829D-02, &
&   -8.113108217335614D-27,   1.356020526886279D-25,  -5.155642670862530D-24, &
&    1.783889940189558D-22,  -5.896408500736567D-21,   2.083032860948970D-19, &
&   -6.863705256293429D-18,   2.220883011213392D-16,  -7.162867854514670D-15, &
&    2.229356897129219D-13,  -6.793158150721132D-12,   2.012633463966042D-10, &
&   -5.765289713319775D-09,   1.590104066032000D-07,  -4.174712473213485D-06, &
&    1.028939563356417D-04,  -2.408933981142388D-03,   7.393887022371190D-02, &
&   -8.418718475708235D-28,   3.665784689047577D-26,   1.034126608734655D-24, &
&   -3.474597581221227D-24,  -9.462884919718457D-22,  -1.269186967150716D-20, &
&   -1.662479259829537D-19,   1.439117260545653D-17,  -1.395333296478625D-16, &
&    1.415041615028021D-14,  -5.106151905945428D-13,   2.004231810526877D-11, &
&   -8.299442885241633D-10,   3.254446972363172D-08,  -1.316050328442144D-06, &
&    5.406816239426501D-05,  -2.367467116333339D-03,   1.143787740739611D-01, &
&   -3.093359280906777D-25,   2.867021643306468D-24,  -4.159795752605523D-23, &
&    7.474275107683255D-22,  -1.156537894696610D-20,   1.651939412134513D-19, &
&   -2.200130919660130D-18,   2.706765279099522D-17,  -3.052375317326345D-16, &
&    3.127722734844907D-15,  -2.880645618505207D-14,   2.351801538793438D-13, &
&   -1.671252850140296D-12,   1.008145491442036D-11,  -4.976357134918478D-11, &
&    1.895371226556765D-10,  -4.994368909932146D-10,   6.935261787807313D-10, &
&   -7.064794740989824D-25,   7.003389064379946D-24,  -1.124194319792554D-22, &
&    2.167022477388546D-21,  -3.671624731327053D-20,   5.817718621200253D-19, &
&   -8.682183112796780D-18,   1.211647860440723D-16,  -1.571871760775906D-15, &
&    1.882703811865361D-14,  -2.064138931096321D-13,   2.048791432373700D-12, &
&   -1.814280917576948D-11,   1.404501566410073D-10,  -9.222827867470733D-10, &
&    4.893805995081736D-09,  -1.911448030399062D-08,   4.408541628930043D-08, &
&   -9.241374987178044D-25,   1.007266236698362D-23,  -1.847574734205059D-22, &
&    3.924871192635533D-21,  -7.496371012607526D-20,   1.356099242981623D-18, &
&   -2.332811778397923D-17,   3.795510828663502D-16,  -5.812887943229120D-15, &
&    8.333335934026443D-14,  -1.110416536953253D-12,   1.362654098203532D-11, &
&   -1.521615794490871D-10,   1.519937136007898D-09,  -1.324097537915527D-08, &
&    9.676429029619673D-08,  -5.446675553176810D-07,   2.070725269250288D-06, &
&   -7.692114404732414D-25,   9.322437475387594D-24,  -1.966930697907930D-22, &
&    4.653661261776573D-21,  -1.009949634372516D-19,   2.096649467342121D-18, &
&   -4.171722902641900D-17,   7.925150882952019D-16,  -1.430744455230549D-14, &
&    2.444435261427107D-13,  -3.929352238176433D-12,   5.890759856078506D-11, &
&   -8.164026631982042D-10,   1.030105617079179D-08,  -1.157735990885763D-07, &
&    1.126773537063867D-06,  -8.672364288047473D-06,   5.269044293918412D-05, &
&   -3.859200846212299D-25,   5.235882515162728D-24,  -1.272387471050328D-22, &
&    3.361798323960623D-21,  -8.333786998504211D-20,   1.984024559791164D-18, &
&   -4.558657938145673D-17,   1.011741523568729D-15,  -2.141662020595902D-14, &
&    4.337501657827413D-13,  -8.365474428383053D-12,   1.515797062542973D-10, &
&   -2.579566827342137D-09,   4.054618739416857D-08,  -5.778972178917045D-07, &
&    7.340515998345882D-06,  -7.467515609418607D-05,   7.180605771538361D-04, &
&   -1.032283494109210D-25,   1.641138295815627D-24,  -4.683763945870278D-23, &
&    1.333636746945289D-21,  -3.944508691141796D-20,   1.060978563665598D-18, &
&   -2.795027588601328D-17,   7.413173449105459D-16,  -1.818671964358461D-14, &
&    4.364213018991450D-13,  -1.016749830903812D-11,   2.211528114326882D-10, &
&   -4.620064217066406D-09,   9.022898153532527D-08,  -1.624747441775658D-06, &
&    2.669553730860263D-05,  -3.560354515489951D-04,   5.462227247608497D-03, &
&   -3.562069320866881D-27,   2.701585468931439D-25,  -1.021519262240875D-23, &
&    1.940140215603751D-22,  -1.097746859062491D-20,   2.863257574835731D-19, &
&   -8.149896336514234D-18,   2.974748474896566D-16,  -8.007421713828835D-15, &
&    2.290050972066403D-13,  -6.652161485237516D-12,   1.729169253580115D-10, &
&   -4.490018143309159D-09,   1.100826472139853D-07,  -2.526990188343718D-06, &
&    5.374427638825660D-05,  -9.742691238806053D-04,   2.415584528882690D-02, &
&    2.768738504791924D-27,   3.326803565260516D-26,  -9.591988006438238D-25, &
&   -4.163637277343737D-24,  -1.543203704054062D-21,   3.208561175541977D-20, &
&   -9.563407507739214D-19,   5.197717441758353D-17,  -1.607347663777073D-15, &
&    5.587222882267719D-14,  -2.012170596329873D-12,   6.597060176735713D-11, &
&   -2.161484604905997D-09,   6.815016846095005D-08,  -2.049940863094350D-06, &
&    5.843993151422478D-05,  -1.628460635093906D-03,   6.402876413789041D-02, &
&   -1.999034611947246D-26,  -3.078593208900113D-26,   3.621275484114105D-24, &
&    1.548366533297529D-22,   3.375290071101551D-21,   7.594090623816645D-21, &
&   -1.665683317645226D-18,  -3.837030084683088D-17,  -3.347705127260504D-16, &
&    1.340970143489558D-14,   5.697370555381467D-14,   1.195818134102383D-11, &
&   -3.997876507630285D-10,   1.768113836716861D-08,  -8.313015520681611D-07, &
&    3.833205695144081D-05,  -1.911482056842248D-03,   1.037466616313431D-01, &
&   -3.108967032797360D-27,   2.938628519502198D-26,  -4.400638916900961D-25, &
&    8.083348634451454D-24,  -1.287181225491766D-22,   1.900831047315799D-21, &
&   -2.627409458065698D-20,   3.371045572622945D-19,  -3.987716110285533D-18, &
&    4.316434471304810D-17,  -4.235259969980636D-16,   3.722286357785100D-15, &
&   -2.884920679039923D-14,   1.929852152675282D-13,  -1.079843441050949D-12, &
&    4.807868390972084D-12,  -1.548187931309976D-11,   2.900632949148930D-11, &
&   -9.897952738655702D-27,   1.032317848045281D-25,  -1.782454039488479D-24, &
&    3.624076863133324D-23,  -6.565542406162006D-22,   1.121759255718649D-20, &
&   -1.817946750293199D-19,   2.778028121774809D-18,  -3.984052099092603D-17, &
&    5.333878590100618D-16,  -6.618194090061272D-15,   7.544395667520413D-14, &
&   -7.812038474708220D-13,   7.219899373920363D-12,  -5.820492183088431D-11, &
&    3.949913653660577D-10,  -2.052815892843188D-09,   7.695367911916242D-09, &
&   -1.951782090046060D-26,   2.288370721859361D-25,  -4.621795468414193D-24, &
&    1.063381319875107D-22,  -2.223117480054290D-21,   4.437647059377164D-20, &
&   -8.505731492597485D-19,   1.549563425363839D-17,  -2.682084972021687D-16, &
&    4.398228069660323D-15,  -6.756082014179806D-14,   9.690942219897866D-13, &
&   -1.287988749729211D-11,   1.549665560193936D-10,  -1.671332063001888D-09, &
&    1.574795360703401D-08,  -1.144239208186804D-07,   7.360171398944797D-07, &
&   -2.597674902325180D-26,   3.174871508409288D-25,  -7.197856526474737D-24, &
&    1.995466608381960D-22,  -4.652468226844296D-21,   1.069266230444885D-19, &
&   -2.446454631065056D-18,   5.159796863160041D-17,  -1.057834382720680D-15, &
&    2.102005233207638D-14,  -3.860863940591938D-13,   6.760078454318451D-12, &
&   -1.121214364591961D-10,   1.675530524336369D-09,  -2.311487347012450D-08, &
&    2.864228599000598D-07,  -2.699186999849950D-06,   2.760026829599116D-05, &
&   -4.540011062009892D-26,   1.881378497703423D-25,  -3.440344304045875D-24, &
&    2.824913871153670D-22,  -5.157004698754145D-21,   1.360290491866626D-19, &
&   -4.340649691697277D-18,   9.370131337689654D-17,  -2.265945810705158D-15, &
&    5.679130541707825D-14,  -1.184711316509074D-12,   2.495018494141720D-11, &
&   -5.156790231168473D-10,   9.281905692863921D-09,  -1.608990479431818D-07, &
&    2.545044120962507D-06,  -3.026158415892344D-05,   4.750913039566034D-04, &
&   -1.708037400898466D-25,  -4.770909614964982D-25,   1.453757002160945D-23, &
&    5.676349064813495D-22,  -6.492717271108157D-23,   3.871025450829333D-20, &
&   -5.986384247125779D-18,   7.539039887222134D-17,  -2.331922583949553D-15, &
&    8.980565579274541D-14,  -1.890091461351392D-12,   4.799577154895148D-11, &
&   -1.268743406980732D-09,   2.698164313082931D-08,  -5.866988062198216D-07, &
&    1.164002894445955D-05,  -1.770039838419286D-04,   4.191102630586285D-03, &
&   -3.736415544362456D-25,  -1.573544314459527D-24,   3.587368327993304D-23, &
&    1.057072377206259D-21,   8.133521714059517D-21,  -1.120635214876791D-19, &
&   -7.391952059257639D-18,  -4.228277285908623D-18,  -6.811250302412826D-16, &
&    8.511734319441199D-14,  -1.470416095157089D-12,   4.640562276566530D-11, &
&   -1.634299920613359D-09,   4.124622825816538D-08,  -1.129140942094142D-06, &
&    2.800601440385195D-05,  -5.827059479180108D-04,   2.036926166036075D-02, &
&   -1.056146063456099D-25,  -6.208176703478811D-25,   7.468997808676365D-24, &
&    2.961926374481840D-22,   3.210799789473494D-21,  -2.786050628877527D-20, &
&   -1.964125959157242D-18,  -5.625071858304731D-18,  -1.743688372925975D-16, &
&    2.563343519635599D-14,  -6.057193068525839D-13,   2.346560806106006D-11, &
&   -9.390246352083148D-10,   3.201016053230252D-08,  -1.098295399956989D-06, &
&    3.571866276339278D-05,  -1.169439376694577D-03,   5.712794860064595D-02, &
&    6.718293583959304D-25,   2.883873951958511D-24,  -6.631884545704766D-23, &
&   -1.849540196327354D-21,  -1.682429701879655D-20,   2.790447424112599D-19, &
&    1.069634137638883D-17,   9.790490821666145D-17,  -1.793308032127028D-15, &
&   -5.523739719608822D-14,  -4.713612543659025D-13,   1.314872129776130D-11, &
&    1.697745446244502D-11,   1.271390861879508D-08,  -5.450279640928289D-07, &
&    2.813491006154762D-05,  -1.582681129695942D-03,   9.505363688491938D-02, &
&   -3.625682220781185D-29,   3.398683701900340D-28,  -5.288780217313190D-27, &
&    1.012005438094088D-25,  -1.686411430809909D-24,   2.624215877926247D-23, &
&   -3.845656249629340D-22,   5.275470051678616D-21,  -6.740964246922553D-20, &
&    7.970289128313081D-19,  -8.662756930711757D-18,   8.588547693789039D-17, &
&   -7.667653537141234D-16,   6.063203880709670D-15,  -4.174694344492232D-14, &
&    2.410840913439159D-13,  -1.051765344200494D-12,   3.775034559525942D-12, &
&   -1.663373064516542D-28,   1.998069366304773D-27,  -3.733268463711975D-26, &
&    7.880032060089828D-25,  -1.593492093882972D-23,   3.012768811532614D-22, &
&   -5.334116562614093D-21,   9.175907563710943D-20,  -1.501993605678874D-18, &
&    2.282460833054607D-17,  -3.280657322329132D-16,   4.454826479683894D-15, &
&   -5.504241103100043D-14,   6.174115893091465D-13,  -6.418807418374382D-12, &
&    5.732589545910089D-11,  -3.758665303858894D-10,   2.914305014145948D-09, &
&   -1.605579499299011D-28,   1.269367371368943D-26,  -1.584141072707156D-25, &
&    2.628073656981821D-24,  -1.046497583097545D-22,   2.215751347210545D-21, &
&   -3.944728609459353D-20,   9.114546033348066D-19,  -1.891260864707292D-17, &
&    3.277795190682088D-16,  -5.917125372534328D-15,   1.056605986104963D-13, &
&   -1.609682918534390D-12,   2.280257993584466D-11,  -3.246816190761840D-10, &
&    3.847589566862644D-09,  -3.224194523086464D-08,   4.164608820876670D-07, &
&    3.080543827259347D-27,   1.843051709417569D-25,   5.299225427217138D-25, &
&   -2.363733093156972D-23,  -8.232409527782208D-22,   1.093120934215350D-20, &
&   -3.862854488276212D-20,   5.225634083930970D-18,  -1.392027596115573D-16, &
&    2.028254123644998D-15,  -4.848570224081589D-14,   1.192617548574148D-12, &
&   -2.031778530483945D-11,   3.434710708380994D-10,  -6.528079875526123D-09, &
&    9.583652148328485D-08,  -9.864505740296096D-07,   1.915438668747534D-05, &
&   -1.350305085418310D-26,   1.977328186723711D-24,   1.793143496504806D-23, &
&   -3.470148225905596D-22,  -7.905997773802834D-21,   3.856851698250524D-20, &
&    1.524095087603913D-18,   2.304669993008977D-17,  -7.112081189560516D-16, &
&    3.137078937886040D-15,  -1.782580937829131D-13,   7.044021180389625D-12, &
&   -1.207773037232790D-10,   2.372707769956706D-09,  -6.010901517453266D-08, &
&    1.055134671432261D-06,  -1.348191746148877D-05,   3.718025804398015D-04, &
&   -2.869201739243022D-25,   9.820957265221243D-24,   1.218954681553581D-22, &
&   -1.672543115418364D-21,  -4.258349263780370D-20,   7.810325290093863D-20, &
&    1.011478586374050D-17,   8.617837566021646D-17,  -2.518567138393626D-15, &
&   -1.590223063335740D-14,  -2.507364334417591D-13,   2.272006304311093D-11, &
&   -3.552976226400962D-10,   8.109480821211587D-09,  -2.726045664143780D-07, &
&    5.660239010625529D-06,  -9.433812181077710D-05,   3.537278041378679D-03, &
&   -9.430453612639704D-25,   1.989168630708916D-23,   2.965937538252233D-22, &
&   -3.199626449124342D-21,  -9.411144056031912D-20,   4.660746268866388D-20, &
&    2.265398985864429D-17,   1.775315460828085D-16,  -4.642011538978104D-15, &
&   -5.639806795609879D-14,  -3.558238785919290D-14,   3.692481136926885D-11, &
&   -5.270176346153806D-10,   1.460989822735890D-08,  -6.154621301097761D-07, &
&    1.558595547605411D-05,  -3.710562619522093D-04,   1.803605308615705D-02, &
&   -4.563937922218505D-25,   4.069035614216024D-24,   9.634095320157674D-23, &
&   -5.019363517591839D-22,  -2.549157854491764D-20,  -5.445530294327470D-20, &
&    5.672516733567963D-18,   5.557617442364843D-17,  -1.146861712061870D-15, &
&   -1.317665312647153D-14,  -1.379915284620136D-13,   1.516137562393749D-11, &
&   -4.049421288631122D-10,   1.566982369329729D-08,  -6.433544455548446D-07, &
&    2.306263014865360D-05,  -8.811654600645329D-04,   5.205383210856587D-02, &
&    1.693651106815975D-24,  -3.590423402431858D-23,  -5.346702260717969D-22, &
&    5.791744718892002D-21,   1.694650770735395D-19,  -7.323057096165582D-20, &
&   -4.141772430853657D-17,  -3.002871871472925D-16,   7.653696559026999D-15, &
&    1.283899907244451D-13,  -8.924459813165595D-13,  -3.308410530816070D-11, &
&   -2.086034233193016D-10,   1.349190581452866D-08,  -2.743207984199198D-07, &
&    2.195386542256937D-05,  -1.335641825599211D-03,   8.778361979744907D-02, &
&    5.134226216018103D-31,   5.444900582508385D-30,  -1.101330351181238D-28, &
&    1.533622665777487D-27,  -2.678528722162719D-26,   4.766012124713874D-25, &
&   -7.758607700869614D-24,   1.147039433659882D-22,  -1.620134625699704D-21, &
&    2.228282711920948D-20,  -2.854855884746400D-19,   3.291134371161533D-18, &
&   -3.507979064496391D-17,   3.600029210119222D-16,  -3.380833850595756D-15, &
&    2.531662353779870D-14,  -1.393782394668512D-13,   1.600739929427443D-12, &
&    1.404011535902086D-29,   1.412898125927601D-28,  -3.329791094663832D-27, &
&    6.369824130599112D-27,  -1.311443490489658D-25,   1.452845233325195D-23, &
&   -3.104694070344939D-22,   3.958236466169978D-21,  -6.853249367062870D-20, &
&    1.592083190880159D-18,  -2.835145528133128D-17,   3.882389662204438D-16, &
&   -5.508853632288047D-15,   8.912421180299431D-14,  -1.235499000053843D-12, &
&    1.203570569445077D-11,  -8.933332572126366D-11,   1.930295942684613D-09, &
&    1.056771156838964D-27,   9.796788301866253D-27,  -1.573880254697622D-25, &
&   -1.858784623671279D-24,   2.486173573767106D-23,   5.200507270593692D-22, &
&   -9.654753894171055D-21,   1.262175364519968D-21,  -2.825552293266306D-19, &
&    5.023007243875203D-17,  -1.061687524611666D-15,   1.247391574153924D-14, &
&   -2.157009276140758D-13,   5.465600393961687D-12,  -9.709847063973469D-11, &
&    1.090977630655092D-09,  -1.025925025747910D-08,   3.213642186973302D-07, &
&    2.089744478619456D-26,   2.951241602533805D-25,  -3.243004665547670D-24, &
&   -6.627855027731111D-23,   6.972253967514729D-22,   1.405082233325415D-20, &
&   -1.910924833675504D-19,  -2.056646660950437D-18,   2.558401304442520D-17, &
&    8.720012580510333D-16,  -1.848877841966840D-14,   1.224631008570496D-13, &
&   -2.698269416183503D-12,   1.215589877733086D-10,  -2.596279727822925D-09, &
&    3.262482002829572D-08,  -3.915107203891367D-07,   1.596863103072901D-05, &
&    1.628551623900074D-25,   3.552274861914088D-24,  -2.831304593231827D-23, &
&   -8.352567464950216D-22,   7.086092316541794D-21,   1.734954335888430D-19, &
&   -1.906456990623042D-18,  -3.232893168007664D-17,   4.037221963305275D-16, &
&    8.394192938290167D-15,  -1.633663385710320D-13,   1.496905323835247D-13, &
&   -9.999466723174013D-12,   1.182019462558665D-09,  -2.921717336196816D-08, &
&    4.127051929554272D-07,  -6.517175355599625D-06,   3.244595170261909D-04, &
&    5.420864253519317D-25,   1.843774978678887D-23,  -1.107728730439107D-22, &
&   -4.442670705777432D-21,   3.164947709066083D-20,   9.322260483514148D-19, &
&   -8.933067205902948D-18,  -1.847765661494362D-16,   2.218939311664059D-15, &
&    4.064765800973497D-14,  -7.234994227749250D-13,  -2.534371937501793D-12, &
&    7.899958716249973D-12,   5.456993400568252D-09,  -1.526489432991506D-07, &
&    2.528449811646173D-06,  -5.485418829865555D-05,   3.177301535882774D-03, &
&    6.798276354654110D-25,   3.853967776357781D-23,  -1.773962318926136D-22, &
&   -9.444388170988839D-21,   5.818422843016238D-20,   2.005741367140153D-18, &
&   -1.745014221503704D-17,  -4.063661306038329D-16,   4.678135074877137D-15, &
&    8.431760967004076D-14,  -1.410967335322434D-12,  -8.393258520650186D-12, &
&    5.953945000708603D-11,   1.186905108143432D-08,  -3.765798349886353D-07, &
&    8.198044828933910D-06,  -2.550558585843024D-04,   1.650151795490433D-02, &
&   -1.596378615801279D-25,   8.750550214426846D-24,  -2.744745265312766D-24, &
&   -2.253651389013619D-21,   7.607590900918617D-21,   4.982440644525252D-19, &
&   -3.210159487003442D-18,  -1.031236262695268D-16,   9.791208323137238D-16, &
&    2.260724067887655D-14,  -3.862112303628583D-13,   7.842850347847266D-13, &
&   -1.354261029546188D-10,   9.884674299304851D-09,  -3.993248453002772D-07, &
&    1.538215782565833D-05,  -6.919627754916765D-04,   4.815289895621696D-02, &
&   -1.247333629945653D-24,  -6.958109069611808D-23,   3.224844941699287D-22, &
&    1.704950314856460D-20,  -1.054456427282445D-19,  -3.617147745192353D-18, &
&    3.143994164880458D-17,   7.382147379189923D-16,  -8.657660401536714D-15, &
&   -1.438268779132277D-13,   2.215913109252028D-12,   2.824125388288813D-11, &
&   -6.209879221744883D-10,  -1.223990191978204D-09,  -1.313690709574793D-07, &
&    1.930196285159185D-05,  -1.131203733401750D-03,   8.162722144909769D-02, &
&    1.169682776120986D-31,   2.479269842189639D-31,  -6.640515354608699D-30, &
&    4.254417240927789D-29,  -4.165555573760517D-28,   7.512815945720232D-27, &
&   -2.098109413337086D-25,   4.692597255190855D-24,  -7.524596184387516D-23, &
&    9.628743828946810D-22,  -1.262829237231240D-20,   2.053668163362298D-19, &
&   -3.429692294879912D-18,   4.665627529923073D-17,  -4.701307416296866D-16, &
&    3.479105301198488D-15,  -2.906214413531452D-14,   1.265029904087989D-12, &
&    5.271667203966126D-30,   5.918601350023239D-30,  -8.616724682757611D-28, &
&    7.446412171862093D-27,   7.469635302760854D-26,  -1.892790451393574D-24, &
&   -9.710085454524222D-24,   8.353501711244631D-22,  -1.343938840950011D-20, &
&    9.796175854491608D-20,  -9.318548402806523D-19,   4.441213698218732D-17, &
&   -1.320480912032606D-15,   2.316157851056873D-14,  -2.683005820234128D-13, &
&    2.313701428246914D-12,  -2.930714289409708D-11,   1.672938226749761D-09, &
&    4.300588858649879D-28,   6.309961267508868D-28,  -7.074814068094074D-26, &
&    5.054351083483302D-25,   9.569715760358911D-24,  -2.150920511804652D-22, &
&   -1.466811811870215D-22,   6.008976444434947D-20,  -8.227526013839281D-19, &
&   -2.413011341627668D-19,   7.896886468577217D-17,   1.921160270218148D-15, &
&   -1.024836492291453D-13,   2.060227403114138D-12,  -2.569046383514349D-11, &
&    2.525288310421902D-10,  -4.425628394837096D-09,   2.880777482352366D-07, &
&    1.100887049412968D-26,   2.442109001937570D-26,  -1.948677850847200D-24, &
&    1.221790499671799D-23,   3.047664753638069D-22,  -6.373936747510308D-21, &
&   -4.081200654551504D-21,   1.683175487424537D-18,  -2.037714176057083D-17, &
&   -1.150533268054405D-16,   4.528253484566134D-15,   2.346640951726672D-14, &
&   -2.667983561095189D-12,   5.867638180327575D-11,  -7.766698022210082D-10, &
&    8.883273478531862D-09,  -2.067786780071807D-07,   1.457053930320942D-05, &
&    1.160738343806178D-25,   3.403732359308294D-25,  -2.191227649714115D-23, &
&    1.233100918373714D-22,   3.720722728229224D-21,  -7.378309281674815D-20, &
&   -7.817970882299300D-20,   1.973398513170966D-17,  -2.221067427836112D-16, &
&   -1.953969244919268D-15,   6.681100628719059D-14,   5.472472148549679D-14, &
&   -2.889512638894133D-11,   6.796038032686447D-10,  -9.624019381961010D-09, &
&    1.340880932181750D-07,  -4.030772745858280D-06,   2.992399175281538D-04, &
&    5.465361878571875D-25,   1.937453964686302D-24,  -1.086215695577149D-22, &
&    5.589707701348631D-22,   1.947160827270909D-20,  -3.714697482771991D-19, &
&   -5.486541050380582D-19,   1.016673594966860D-16,  -1.097225955713868D-15, &
&   -1.160670905435529D-14,   3.807452081906020D-13,  -3.712354637517664D-13, &
&   -1.416072672263322D-10,   3.536575452575814D-09,  -5.556766621756660D-08, &
&    1.016339852353709D-06,  -3.836262142746172D-05,   2.950518117089376D-03, &
&    1.059582796026046D-24,   4.316566421619992D-24,  -2.196280640961498D-22, &
&    1.047216322938576D-21,   4.095742431511681D-20,  -7.587481645991988D-19, &
&   -1.392522737517602D-18,   2.123511382416062D-16,  -2.235498196476715D-15, &
&   -2.584505910376804D-14,   8.315614660567943D-13,  -1.299063348636276D-12, &
&   -3.009935112025891D-10,   8.166947009508740D-09,  -1.593370243316570D-07, &
&    4.275187262078581D-06,  -1.954494741732482D-04,   1.539151790143443D-02, &
&    1.834802675092503D-25,   1.167673723859180D-24,  -4.479336337211318D-23, &
&    1.540179502224109D-22,   9.477883891039095D-21,  -1.596600467674484D-19, &
&   -5.057047194448083D-19,   4.888248093753620D-17,  -4.971068917423793D-16, &
&   -5.813019896734505D-15,   1.670497771177787D-13,   1.295527336872401D-12, &
&   -1.563774820226414D-10,   6.144967387812348D-09,  -2.377077107398412D-07, &
&    1.069850343176508D-05,  -5.635834726657550D-04,   4.503346991308113D-02, &
&   -1.917139848813853D-24,  -7.786660517428446D-24,   3.969570145076105D-22, &
&   -1.895465959795441D-21,  -7.397441331003206D-20,   1.371598158822855D-18, &
&    2.473110224073450D-18,  -3.820244879380477D-16,   3.974010935356420D-15, &
&    4.953283462173384D-14,  -1.629926017969964D-12,   8.011943657415376D-12, &
&    2.938889994559658D-10,  -3.621912203677416D-09,  -2.211639796376462D-07, &
&    1.670848864967593D-05,  -9.499221804694224D-04,   7.643517426956042D-02, &
&    9.915446707080552D-32,  -8.854659989896217D-32,  -1.644454257116711D-30, &
&    3.596591574583731D-30,  -5.125643470591060D-29,   9.428519147207023D-28, &
&   -9.524024865197941D-27,   5.949619130985399D-26,  -1.282672328875075D-24, &
&    6.247095384557702D-23,  -1.873544619191955D-21,   3.791361257030963D-20, &
&   -5.609471782221335D-19,   6.258964916873106D-18,  -5.455898930705158D-17, &
&    5.084201219000829D-16,  -1.404126590010127D-14,   1.168861345544998D-12, &
&    2.274267822033600D-31,  -3.353855431859527D-30,   3.516421016666952D-29, &
&    4.239719306115664D-28,  -2.199690637772297D-26,   3.520746353621693D-25, &
&   -1.281745130287883D-24,  -5.969920104911929D-23,   1.068823862219955D-21, &
&    8.764744914536422D-21,  -7.859799979346916D-19,   2.013686516115920D-17, &
&   -3.317946286714114D-16,   3.978348290253965D-15,  -3.838224839818104D-14, &
&    4.858799630483939D-13,  -1.807913943877961D-11,   1.561697450907410D-09, &
&    1.929343963522746D-29,  -3.371408241185999D-28,   3.479463919214356D-27, &
&    3.471077012704390D-26,  -1.958607714337733D-24,   3.077113355819307D-23, &
&   -4.174791176835301D-23,  -8.096371222415181D-21,   1.585557512839422D-19, &
&   -1.554573631346861D-19,  -6.256652841869455D-17,   1.825839750693162D-15, &
&   -3.167576303324494D-14,   3.960291548509640D-13,  -4.207581227728294D-12, &
&    6.981733113228987D-11,  -3.074591357856760D-09,   2.700539262632844D-07, &
&    5.482878958299188D-28,  -9.586241844344551D-27,   9.973185287671492D-26, &
&    1.004221577394316D-24,  -5.695009707879563D-23,   8.884678791444860D-22, &
&   -4.418829998128235D-22,  -2.687101588359966D-19,   5.475478403723346D-18, &
&   -1.975591581538058D-17,  -1.642274381885532D-15,   5.218625238630359D-14, &
&   -9.360083770224643D-13,   1.216273438234268D-11,  -1.456176543557758D-10, &
&    3.135496195752297D-09,  -1.543739769590053D-07,   1.369063008495426D-05, &
&    6.312914390523790D-27,  -1.094355046960195D-25,   1.132145059132060D-24, &
&    1.188284807306604D-23,  -6.648760301427003D-22,   1.034230463260763D-20, &
&   -1.363687063960017D-21,  -3.322885640824839D-18,   6.930493304614546D-17, &
&   -3.361679188483230D-16,  -1.776248432959173D-14,   5.993616288131265D-13, &
&   -1.104813831556137D-11,   1.508842078047861D-10,  -2.131904665495977D-09, &
&    5.927308008082939D-08,  -3.155511061824658D-06,   2.815747620584088D-04, &
&    3.190833086506385D-26,  -5.472818000267884D-25,   5.615224862118167D-24, &
&    6.135515560116615D-23,  -3.383613544673016D-21,   5.256629113702813D-20, &
&    1.951757739403240D-21,  -1.741163932926773D-17,   3.685702129849365D-16, &
&   -2.041620438784242D-15,  -8.590779470721558D-14,   3.032182040844220D-12, &
&   -5.769771758691835D-11,   8.580320236893336D-10,  -1.549526024265478D-08, &
&    5.512087649476952D-07,  -3.101568860692987D-05,   2.778953553066055D-03, &
&    6.557263942046166D-26,  -1.113204988041861D-24,   1.132850322946412D-23, &
&    1.281106270337071D-22,  -6.976612633262117D-21,   1.083302604303272D-19, &
&    1.295600565917396D-20,  -3.649614365684829D-17,   7.798864755988271D-16, &
&   -4.607094281020767D-15,  -1.740534108973249D-13,   6.400232371484640D-12, &
&   -1.300240745737463D-10,   2.352930689847858D-09,  -6.207111638557207D-08, &
&    2.761981572043723D-06,  -1.614587420311336D-04,   1.450542889867363D-02, &
&    1.413124436447557D-26,  -2.315526378955030D-25,   2.284979095961958D-24, &
&    2.910253142487057D-23,  -1.520156935445255D-21,   2.362659005837095D-20, &
&    4.478484401387328D-21,  -8.156686075203547D-18,   1.749595603001659D-16, &
&   -8.872731557375364D-16,  -5.430959869982334D-14,   2.395852926797157D-12, &
&   -8.022320377715026D-11,   3.131232028532115D-09,  -1.482968170389284D-07, &
&    7.879065136071180D-06,  -4.718046947604917D-04,   4.245668407357308D-02, &
&   -1.184958763355950D-25,   2.011468394021275D-24,  -2.046709589406160D-23, &
&   -2.313491425802798D-22,   1.259759082134439D-20,  -1.954762217161541D-19, &
&   -3.203858023435280D-20,   6.634783681602240D-17,  -1.430738091556512D-15, &
&    9.434956247237185D-15,   2.596798178671338D-13,  -8.892643334518612D-12, &
&    1.037729992779312D-10,   2.303765875535424D-09,  -2.249102846348767D-07, &
&    1.321024896549693D-05,  -8.003068959914600D-04,   7.207430638595166D-02, &
&    6.396508635702956D-31,  -5.835193931760488D-31,  -1.705986889001463D-29, &
&    1.544011381153601D-29,   1.884855573110204D-28,  -1.940864601715515D-28, &
&   -1.062285603789005D-27,   1.940227582787148D-26,  -7.167198256846632D-25, &
&    1.761526961291811D-23,  -3.247089455495806D-22,   4.742448121570092D-21, &
&   -5.589670092587396D-20,   5.548374565041520D-19,  -6.343771483829787D-18, &
&    1.843643916314567D-16,  -1.113142632124047D-14,   1.107172754227707D-12, &
&   -9.275457785170062D-32,   1.263432903834851D-31,  -8.660367660400486D-31, &
&   -2.462609569709183D-31,   1.253570537344968D-27,  -3.459849110108858D-26, &
&    4.143569881295924D-25,   4.179935064179151D-24,  -3.472249080371067D-22, &
&    1.005552283430325D-20,  -2.009596422694273D-19,   3.091363127489688D-18, &
&   -3.816352645607973D-17,   4.142946864706287D-16,  -6.221096188585858D-15, &
&    2.351671996459809D-13,  -1.484701524812411D-11,   1.480358743112798D-09, &
&   -1.365844985799732D-30,   2.000176545070582D-29,  -2.679196665211151D-28, &
&   -2.159687848329655D-28,   1.325220427902484D-25,  -3.824990578806335D-24, &
&    5.386314907366163D-23,   1.263136310262309D-22,  -2.958082941380580D-20, &
&    9.372207380229527D-19,  -1.947003528621696D-17,   3.074466979187237D-16, &
&   -3.920511376309844D-15,   4.676295472098846D-14,  -8.990893200805435D-13, &
&    3.976913201789163D-11,  -2.565257291838959D-09,   2.560728005471367D-07, &
&   -3.864702994720630D-29,   5.843048705326405D-28,  -8.107007089876307D-27, &
&   -3.190807968546249D-27,   4.011305837095373D-24,  -1.198230773147216D-22, &
&    1.804046903092377D-21,  -7.100010869533041D-22,  -8.094130240518388D-19, &
&    2.715114480202549D-17,  -5.776085082466373D-16,   9.294538903810208D-15, &
&   -1.227513615781946D-13,   1.651653291066672D-12,  -4.039566822038646D-11, &
&    1.989474275859629D-09,  -1.299831603869718D-07,   1.298430967547796D-05, &
&   -4.427069109813258D-28,   6.800855488956015D-27,  -9.631802845979652D-26, &
&   -5.247309830860428D-27,   4.732716136549023D-23,  -1.445190727051548D-21, &
&    2.257205221514755D-20,  -4.025762654256616D-20,  -8.990660435178679D-18, &
&    3.136376764451140D-16,  -6.787625374872849D-15,   1.112896023336825D-13, &
&   -1.545617691994025D-12,   2.460183345130975D-11,  -7.626422095837460D-10, &
&    4.056409460915655D-08,  -2.672488465125872D-06,   2.670802735339540D-04, &
&   -2.213437840034912D-27,   3.442940546605390D-26,  -4.946784498334547D-25, &
&    9.898205297017349D-26,   2.412026486755221D-22,  -7.475617943253616D-21, &
&    1.194259230189471D-19,  -3.099240482725892D-19,  -4.412155242135464D-17, &
&    1.583625095053691D-15,  -3.481316942947020D-14,   5.867706037705523D-13, &
&   -8.923211418699348D-12,   1.817730432451480D-10,  -7.079889619878035D-09, &
&    3.980118491320326D-07,  -2.636987627655802D-05,   2.636114814171878D-03, &
&   -4.499980190358215D-27,   7.062918732965438D-26,  -1.025505548893830D-24, &
&    4.070934547846612D-25,   4.965534504147798D-22,  -1.555633468091641D-20, &
&    2.522891695695376D-19,  -7.818679520349347D-19,  -8.900914932182712D-17, &
&    3.273780769092949D-15,  -7.379781080800651D-14,   1.331326702201591D-12, &
&   -2.501225031919085D-11,   7.398943764781161D-10,  -3.541926486375629D-08, &
&    2.069488899259870D-06,  -1.376239575747165D-04,   1.376057588715362D-02, &
&   -9.426337817972517D-28,   1.511843826532401D-26,  -2.266745662884641D-25, &
&    2.405214352642414D-25,   1.068328303019079D-22,  -3.455896676171162D-21, &
&    5.790244063650902D-20,  -2.121265238195157D-19,  -2.096398288260486D-17, &
&    8.755729906404546D-16,  -2.588324946833505D-14,   8.285290605286311D-13, &
&   -3.483950152676094D-11,   1.792726117763588D-09,  -1.009216213687974D-07, &
&    6.042886982963519D-06,  -4.027824926849972D-04,   4.027783956063728D-02, &
&    8.138258608079499D-27,  -1.275708366412441D-25,   1.850968893357428D-24, &
&   -7.072528231164710D-25,  -8.976524894767633D-22,   2.813946578336529D-20, &
&   -4.583649400651686D-19,   1.570885822256284D-18,   1.520230983117727D-16, &
&   -5.444630870411802D-15,   1.082746496017935D-13,  -1.058048764792506D-12, &
&   -2.825119726457279D-11,   2.742555148721840D-09,  -1.691038152818791D-07, &
&    1.024673075500848D-05,  -6.837327590382772D-04,   6.837656133211136D-02, &
&   -5.071293096870452D-31,   1.990891163233544D-31,   1.395716720055066D-29, &
&   -5.109882371273316D-30,  -1.579790611840841D-28,   5.865870177099449D-29, &
&    7.549845410460234D-28,   4.743110082622863D-27,  -1.095971099906551D-25, &
&    1.867384524124514D-24,  -2.754835181579506D-23,   3.459339764744635D-22, &
&   -3.949934243707080D-21,   5.981926918563401D-20,  -2.164289165721680D-18, &
&    1.317101414709516D-16,  -9.598587485014092D-15,   1.055558241947707D-12, &
&    2.036798612650097D-32,   4.865002708326429D-32,  -2.347915249107575D-31, &
&   -6.820108711882727D-30,   3.585744788803153D-29,   2.124809133441898D-27, &
&   -1.046958582839616D-25,   3.070168539288704D-24,  -6.878181779072160D-23, &
&    1.255520077773431D-21,  -1.913591156524930D-20,   2.498201771245631D-19, &
&   -3.159874701521533D-18,   6.282080027681171D-17,  -2.785352226165218D-15, &
&    1.756070605374721D-13,  -1.283288236011534D-11,   1.411400789422609D-09, &
&    1.970876948434778D-32,  -8.114350650438752D-31,   2.954014149347623D-29, &
&   -6.074443576793269D-28,   5.380544320295625D-27,   1.565126765904113D-25, &
&   -9.495267454313868D-24,   2.941949606795021D-22,  -6.781394250751473D-21, &
&    1.262352499959278D-19,  -1.960121231961327D-18,   2.648531749805316D-17, &
&   -3.754414729518306D-16,   9.451865148501815D-15,  -4.727013579282551D-13, &
&    3.033404280703780D-11,  -2.219744521820470D-09,   2.441489256411554D-07, &
&    3.899065598005497D-31,  -2.653208017279702D-29,   9.091098885417309D-28, &
&   -1.931652579541937D-26,   1.989983989209824D-25,   3.826054822013063D-24, &
&   -2.699312351441207D-22,   8.651847499255683D-21,  -2.029231651529326D-19, &
&    3.826396438526239D-18,  -6.038461578221302D-17,   8.517060025327642D-16, &
&   -1.394264079674656D-14,   4.366605651097126D-13,  -2.369152807627513D-11, &
&    1.536799492902948D-09,  -1.125505217014458D-07,   1.237983914034589D-05, &
&    3.584536728698024D-30,  -2.995115447864891D-28,   1.083584156323336D-26, &
&   -2.360131387916400D-25,   2.617100874245756D-24,   3.877732414811090D-23, &
&   -3.074168036979897D-21,   1.008140357457038D-19,  -2.393127678183682D-18, &
&    4.561407402604492D-17,  -7.342930718212591D-16,   1.105878992901080D-14, &
&   -2.192321056991594D-13,   8.412813487521705D-12,  -4.835978206679708D-10, &
&    3.159350365608720D-08,  -2.315065188694906D-06,   2.546484633713482D-04, &
&    1.614069226075439D-29,  -1.518855215034221D-27,   5.561216333011219D-26, &
&   -1.230540180051276D-24,   1.426096153007451D-23,   1.766456885556855D-22, &
&   -1.533222461066264D-20,   5.111193330738934D-19,  -1.225289305082391D-17, &
&    2.365675859833760D-16,  -3.941581484502434D-15,   6.680851279404032D-14, &
&   -1.718558910505419D-12,   7.926683630106597D-11,  -4.748401624234277D-09, &
&    3.117139895468161D-07,  -2.284971598194690D-05,   2.513423448135135D-03, &
&    2.693479560754181D-29,  -3.111509138568556D-27,   1.152127611455231D-25, &
&   -2.575859547826147D-24,   3.073271331615254D-23,   3.339317432535203D-22, &
&   -3.116612798693578D-20,   1.053530293267716D-18,  -2.558250193042707D-17, &
&    5.080555561696370D-16,  -9.264578447498886D-15,   2.032240010208920D-13, &
&   -7.434878099583877D-12,   4.007325498669934D-10,  -2.470080240947601D-08, &
&    1.626744054071030D-06,  -1.192751013811183D-04,   1.312016632732765D-02, &
&    2.485669458857206D-30,  -6.290643221997054D-28,   2.531460282289571D-26, &
&   -5.851361573332137D-25,   7.490039554392101D-24,   5.776378929285233D-23, &
&   -6.821502283613821D-21,   2.495395040065960D-19,  -6.989577487296138D-18, &
&    1.949424693590281D-16,  -6.936632071319498D-15,   3.344479314828705D-13, &
&   -1.900690455674792D-11,   1.149519193845941D-09,  -7.214559458882637D-08, &
&    4.760815831795342D-06,  -3.491220769905524D-04,   3.840340687424840D-02, &
&   -4.956885768801132D-29,   5.588723585878355D-27,  -2.080505028680292D-25, &
&    4.655182485132224D-24,  -5.574468383986560D-23,  -5.859656579556955D-22, &
&    5.523087671239465D-20,  -1.840826579404976D-18,   4.261533280979116D-17, &
&   -7.088738465572738D-16,   4.497544929693370D-15,   3.574489475458875D-13, &
&   -3.003810253689999D-11,   1.932466720136699D-09,  -1.223505061309308D-07, &
&    8.081467904667930D-06,  -5.926761141698403D-04,   6.519454373668940D-02, &
&   -3.578418369292978D-31,   4.735550683383264D-32,   9.202319865052030D-30, &
&   -8.189340918327335D-31,  -9.686069713558111D-29,   4.520215985204633D-30, &
&    5.122875150322494D-28,   4.482205151242257D-28,  -9.251549889467244D-27, &
&    1.162301926134409D-25,  -1.579470714718217D-24,   2.169178619979688D-23, &
&   -4.770378798091154D-22,   2.252471270569469D-20,  -1.469349253080735D-18, &
&    1.053046524199386D-16,  -8.421895901066220D-15,   1.010616380338769D-12, &
&    2.147594524362281D-32,  -1.500544644349381D-31,  -4.711268457126721D-31, &
&    3.967582137575415D-30,  -1.644677475163268D-29,   5.641597128942251D-28, &
&   -1.453615860116293D-26,   3.018128812396672D-25,  -5.411732871620824D-24, &
&    8.476068981301503D-23,  -1.205489581862215D-21,   1.901295510303955D-20, &
&   -5.457090131255182D-19,   2.942240204916484D-17,  -1.960552730625353D-15, &
&    1.407862777258878D-13,  -1.126099336776772D-11,   1.351310563443120D-09, &
&   -4.884587827703370D-32,  -4.357266333364812D-32,   1.086982342114433D-30, &
&    4.432046600244652D-29,  -1.920599081102911D-27,   5.848376376299509D-26, &
&   -1.456677052324982D-24,   3.071961647066085D-23,  -5.585344639000434D-22, &
&    8.909311945571060D-21,  -1.330206319557136D-19,   2.444187050542648D-18, &
&   -8.647854040264574D-17,   5.028912107843047D-15,  -3.387778632429335D-13, &
&    2.435208502267346D-11,  -1.947961923251361D-09,   2.337544998091716D-07, &
&    5.437842944228858D-31,  -1.468292514607792D-30,  -1.551225596559860D-29, &
&    1.230769010071198D-27,  -5.550830802075869D-26,   1.743905079355831D-24, &
&   -4.400187052422723D-23,   9.369898965859923D-22,  -1.721243602425244D-20, &
&    2.801148896185935D-19,  -4.465222234449119D-18,   9.816854331315772D-17, &
&   -4.141220838365434D-15,   2.531139406944958D-13,  -1.716668864331088D-11, &
&    1.234748666109787D-09,  -9.877344623240807D-08,   1.185278418135595D-05, &
&    6.518901878456194D-31,  -1.840457945781370D-29,   3.000487846180505D-30, &
&    1.376273198311182D-26,  -6.447808043782204D-25,   2.049517284313018D-23, &
&   -5.216888172971655D-22,   1.119321881671498D-20,  -2.078581201337064D-19, &
&    3.482869577055819D-18,  -6.135097085687358D-17,   1.672354013188339D-15, &
&   -8.188222967432404D-14,   5.180830702982012D-12,  -3.529559997511633D-10, &
&    2.539760468439562D-08,  -2.031729881168210D-06,   2.438072276165733D-04, &
&    1.126976215273741D-29,  -9.695522120667727D-29,  -7.344588175625523D-29, &
&    6.766939709433459D-26,  -3.250627322187243D-24,   1.044477947964029D-22, &
&   -2.676947626364853D-21,   5.788441141596122D-20,  -1.093089901625276D-18, &
&    1.934601285125373D-17,  -4.033991199854078D-16,   1.419677402480424D-14, &
&   -7.861305835095432D-13,   5.096383759547280D-11,  -3.482685434123268D-09, &
&    2.506739769818697D-07,  -2.005350849152869D-05,   2.406419147759133D-03, &
&    3.268795213585312D-29,  -2.115304768432505D-28,  -2.181200259351373D-28, &
&    1.360113909181250D-25,  -6.652484045963099D-24,   2.156611138767773D-22, &
&   -5.571334087690301D-21,   1.222681539433160D-19,  -2.411501811494899D-18, &
&    4.911909345833975D-17,  -1.405824351132862D-15,   6.608693751825885D-14, &
&   -4.026820277996818D-12,   2.654334686730648D-10,  -1.817607847872658D-08, &
&    1.308511322170358D-06,  -1.046800465201334D-04,   1.256160165426844D-02, &
&   -1.092443017015714D-29,  -4.860921934112763D-29,   5.410791345795858D-28, &
&    2.748887917949623D-26,  -1.451372486589514D-24,   4.919510550940323D-23, &
&   -1.379883261827162D-21,   3.697913280762626D-20,  -1.162967885358075D-18, &
&    5.071368455878219D-17,  -2.856353485671854D-15,   1.789900391317028D-13, &
&   -1.164809735541674D-11,   7.758536332855984D-10,  -5.319567724143582D-08, &
&    3.830050732572453D-06,  -3.064038615850121D-04,   3.676846248713294D-02, &
&   -3.420457906558853D-29,   3.776435109058493D-28,  -2.729443676281021D-28, &
&   -2.440275343256802D-25,   1.192094918765535D-23,  -3.831305452912948D-22, &
&    9.664930182741675D-21,  -1.959537075441964D-19,   2.787559090443788D-18, &
&    1.081898456567849D-17,  -3.829736884170940D-15,   2.921426466143374D-13, &
&   -1.966160092678840D-11,   1.316227365375196D-09,  -9.030085367549461D-08, &
&    6.501961716528533D-06,  -5.201584884110127D-04,   6.241902570019169D-02, &
&    1.519586501337476D-31,   1.775494103111901D-31,  -4.550102617620481D-30, &
&   -5.362028971575795D-30,   5.717810633762516D-29,   6.645097554623964D-29, &
&   -3.920376060594737D-28,  -4.108276604558481D-28,   1.191029022467021D-27, &
&    7.351435031490294D-27,  -1.076260341887764D-25,   3.552625167032964D-24, &
&   -2.116802420415344D-22,   1.491504144467897D-20,  -1.105118744359553D-18, &
&    8.618166568482848D-17,  -7.468992694926910D-15,   9.709686849887250D-13, &
&    3.579357343336895D-32,   3.862971907703713D-33,  -9.994469039451844D-31, &
&   -1.882982800792035D-31,   9.527300764854099D-30,   5.171285693814738D-29, &
&   -1.026990338157096D-27,   1.736089886583551D-26,  -2.871598823256338D-25, &
&    4.680184590806964D-24,  -1.030172179266792D-22,   4.384032384703279D-21, &
&   -2.798131628971722D-19,   1.991990649944110D-17,  -1.477539374368383D-15, &
&    1.152342696363373D-13,  -9.986902967550829D-12,   1.298297095915765D-09, &
&    4.177531307291221D-32,  -6.435684233017511D-34,  -1.317818661752507D-30, &
&    7.916418184859898D-30,  -1.948143412536177D-28,   4.811070453561131D-27, &
&   -9.954614645078618D-26,   1.835859560251036D-24,  -3.110908733625259D-23, &
&    5.500995706760412D-22,  -1.466645689408620D-20,   7.253920115969623D-19, &
&   -4.811204264749218D-17,   3.443704830601635D-15,  -2.555779123904342D-13, &
&    1.993358230611349D-11,  -1.727569845612193D-09,   2.245840483387783D-07, &
&   -4.726102707409130D-31,   2.977189089771713D-31,   4.603301437678363D-30, &
&    2.301339107970110D-28,  -6.404885321153838D-27,   1.478472246646127D-25, &
&   -3.077928123906882D-24,   5.750166181919896D-23,  -1.007860071338449D-21, &
&    1.988030481518088D-20,  -6.454946390123233D-19,   3.574782279227985D-17, &
&   -2.430388954925619D-15,   1.745498754355223D-13,  -1.295897861452750D-11, &
&    1.010753023777233D-09,  -8.759836428915658D-08,   1.138778635387078D-05, &
&    2.320615142221296D-30,   1.793654604437369D-30,  -1.472513800669932D-28, &
&    2.771282706209659D-27,  -7.422121390591086D-26,   1.772237054866377D-24, &
&   -3.718626640460075D-23,   7.058638730239849D-22,  -1.304732451372701D-20, &
&    3.001996559329615D-19,  -1.193841086997118D-17,   7.211503532848916D-16, &
&   -4.986575913540377D-14,   3.589497890946668D-12,  -2.665558690150571D-10, &
&    2.079077958726391D-08,  -1.801864735736574D-06,   2.342424033452389D-04, &
&   -4.889149222906113D-30,   1.181606484188878D-29,  -3.155446428545977D-28, &
&    1.411313996407885D-26,  -3.867157212090294D-25,   9.173814697802203D-24, &
&   -1.944068575898801D-22,   3.802208948087045D-21,  -7.756311845631562D-20, &
&    2.235447967313538D-18,  -1.088417472960233D-16,   7.022435617443366D-15, &
&   -4.913296269045194D-13,   3.542268660992543D-11,  -2.630915785330212D-09, &
&    2.052084054689696D-07,  -1.778471365744638D-05,   2.312012710974829D-03, &
&   -5.889761605943483D-30,   2.134224997611903D-29,  -7.698199789170407D-28, &
&    2.929121346516569D-26,  -8.037127505614726D-25,   1.927895436358976D-23, &
&   -4.189384619090020D-22,   8.881831013955408D-21,  -2.268822660051265D-19, &
&    9.133743958209863D-18,  -5.367477418657397D-16,   3.632329250990786D-14, &
&   -2.561764602937862D-12,   1.848857614061731D-10,  -1.373335489182831D-08, &
&    1.071195322375535D-06,  -9.283689677674700D-05,   1.206879644523963D-02, &
&    2.131208053950990D-29,   1.332216987567854D-30,  -7.452357110605778D-28, &
&    6.715167658076680D-27,  -1.856127538311488D-25,   5.225324988356179D-24, &
&   -1.567711944572096D-22,   6.271056900379640D-21,  -3.432610021524366D-19, &
&    2.215715331105870D-17,  -1.514287325924286D-15,   1.057151598871637D-13, &
&   -7.492987560697428D-12,   5.411302419765096D-10,  -4.019801272803524D-08, &
&    3.135443525654405D-06,  -2.717384316842057D-04,   3.532599608749309D-02, &
&   -1.230533460941559D-29,  -3.641146904814385D-29,   1.961284834038719D-27, &
&   -5.244579421507523D-26,   1.410819503254717D-24,  -3.248816266551897D-23, &
&    5.992116267405232D-22,  -5.333875870803870D-21,  -3.225423883828770D-19, &
&    3.389845341590685D-17,  -2.524541225457036D-15,   1.789726541237977D-13, &
&   -1.271585663960349D-11,   9.186031242342168D-10,  -6.824092316620359D-08, &
&    5.322803486082830D-06,  -4.613096917123043D-04,   5.997026016762001D-02, &
&   -1.882710301050977D-31,  -3.351280075621042D-32,   4.805381693288663D-30, &
&    1.728204744069250D-30,  -5.050404240693706D-29,  -2.770561687768327D-29, &
&    2.815303330794731D-28,   2.082020983830592D-28,  -9.121448805253383D-28, &
&   -3.049099041152602D-28,  -2.428579270160854D-26,   1.816611921900536D-24, &
&   -1.371790490811110D-22,   1.065684910791477D-20,  -8.524565144656102D-19, &
&    7.160580580402210D-17,  -6.683206023367170D-15,   9.356488328231839D-13, &
&    9.561116260958595D-32,   3.894197428634160D-32,  -2.555156628455193D-30, &
&   -8.795280818560588D-31,   2.824304097372303D-29,   9.921612542594995D-30, &
&   -2.134022080765076D-28,   7.703191526661734D-28,  -1.591959254571201D-26, &
&    5.683865901552909D-25,  -3.347011307915318D-23,   2.415354626416175D-21, &
&   -1.833258273081355D-19,   1.424877353143940D-17,  -1.139829022175220D-15, &
&    9.574520468501200D-14,  -8.936217080050553D-12,   1.251070382774307D-09, &
&   -1.474105184043829D-32,   1.140841200069567D-32,   3.451847478378937D-31, &
&    2.552914300796568D-31,  -1.557506514192792D-29,   2.508751406240717D-28, &
&   -4.757355561154145D-27,   9.055634841847511D-26,  -2.149486417035522D-24, &
&    8.904758116168164D-23,  -5.682836853935881D-21,   4.167540393339772D-19, &
&   -3.170338682625043D-17,   2.464741097341771D-15,  -1.971713332839186D-13, &
&    1.656234457471797D-11,  -1.545818604850042D-09,   2.164146037512975D-07, &
&   -1.688463551904024D-32,  -3.082643968929964D-32,  -8.674777612814888D-32, &
&    1.720843478015299D-29,  -3.765692218697245D-28,   7.775909154643654D-27, &
&   -1.529617253029570D-25,   3.103177713270172D-24,  -8.677629227053636D-23, &
&    4.221688098119322D-21,  -2.847537750651251D-19,   2.109794153381540D-17, &
&   -1.607267131209612D-15,   1.249754460745288D-13,  -9.997782675341185D-12, &
&    8.398122337429591D-10,  -7.838246806015586D-08,   1.097354549876787D-05, &
&   -2.594532136636685D-31,   2.617473505122670D-31,  -1.036209451750584D-30, &
&    1.931645813815984D-28,  -4.542361631384555D-27,   9.527690543769673D-26, &
&   -1.933864893414135D-24,   4.347112688373341D-23,  -1.479894961643491D-21, &
&    8.278992658454352D-20,  -5.810194325268860D-18,   4.335036506024530D-16, &
&   -3.305684512294496D-14,   2.570668828070328D-12,  -2.056504033366574D-10, &
&    1.727461532724559D-08,  -1.612297343397938D-06,   2.257216277107971D-04, &
&    1.731136194036396D-30,   1.606005887622541D-30,  -8.623550673707395D-29, &
&    9.853117242615104D-28,  -2.283746932439289D-26,   5.076138341119614D-25, &
&   -1.096557751647450D-23,   2.921563607783998D-22,  -1.254890021516775D-20, &
&    7.897610283649369D-19,  -5.702825617651025D-17,   4.275539736020899D-15, &
&   -3.262493092229429D-13,   2.537274962337114D-11,  -2.029803692547461D-09, &
&    1.705034127646359D-07,  -1.591365140012585D-05,   2.227911194098711D-03, &
&   -1.978765956411253D-30,   3.051391970746325D-30,  -2.682979361656733D-29, &
&    2.086517222968720D-27,  -5.052168784018699D-26,   1.141953110754109D-24, &
&   -2.886604717044061D-23,   1.046397873531061D-21,  -5.829520160399937D-20, &
&    4.026424523921195D-18,  -2.965665100013462D-16,   2.230715543433920D-14, &
&   -1.702937345533039D-12,   1.324460606027382D-10,  -1.059565057650943D-08, &
&    8.900344431999921D-07,  -8.306988040000606D-05,   1.162978325195322D-02, &
&   -1.139996838349702D-30,   1.652642717017063D-30,   7.204640353182678D-30, &
&    5.197079894201286D-28,  -1.654788667489505D-26,   6.249294914044811D-25, &
&   -3.327630380481418D-23,   2.196708119023638D-21,  -1.575673048351412D-19, &
&    1.161108985704369D-17,  -8.660253469816341D-16,   6.527360582312438D-14, &
&   -4.984410213250432D-12,   3.876752799358946D-10,  -3.101401444400602D-08, &
&    2.605177165591062D-06,  -2.431498685636917D-04,   3.404098159797258D-02, &
&    1.709267870098681D-30,  -6.437651415932934D-30,   1.024123137807303D-28, &
&   -3.570503000809403D-27,   7.791157393724525D-26,  -1.144307344216562D-24, &
&   -1.489803505281505D-23,   3.025221769172064D-21,  -2.568623781028640D-19, &
&    1.956925301989248D-17,  -1.468523570361224D-15,   1.107932521656953D-13, &
&   -8.461510959700623D-12,   6.581258619819587D-10,  -5.265013082240116D-08, &
&    4.422611359535166D-06,  -4.127770619657812D-04,   5.778878868251567D-02, &
&   -9.463430889713784D-32,   1.574122857833266D-31,   1.950699074322490D-30, &
&   -3.677545756073260D-30,  -1.440362365173754D-29,   3.439407152467015D-29, &
&    3.940646217222913D-29,  -1.653452828162392D-28,   1.774498186630155D-29, &
&    6.268188060179781D-28,  -1.452657314034459D-26,   1.145584494099699D-24, &
&   -9.374450291716718D-23,   7.811709786246426D-21,  -6.695725028822969D-19, &
&    6.026151062055012D-17,  -6.026150996058916D-15,   9.039226491426037D-13, &
&   -9.232885073907766D-32,  -3.961743080678740D-32,   2.368689310262337D-30, &
&    1.202607397884876D-30,  -2.492898049771683D-29,  -1.439566492496593D-29, &
&    1.365454928998793D-28,   1.508310731071671D-28,  -3.766914468076849D-27, &
&    2.411454017522319D-25,  -1.901455277143825D-23,   1.532415955790468D-21, &
&   -1.253451690531271D-19,   1.044513899916907D-17,  -8.952955582120484D-16, &
&    8.057658833823263D-14,  -8.057658779950458D-12,   1.208648816774682D-09, &
&   -5.640919364013068D-32,   1.268480527923211D-32,   1.529994504437228D-30, &
&   -2.902056369409414D-31,  -1.773230437551658D-29,   1.365092562973067D-29, &
&   -1.454134109963059D-28,   9.157217126281024D-27,  -5.542738326413720D-25, &
&    4.148685804175893D-23,  -3.286266425457795D-21,   2.650532129812638D-19, &
&   -2.168241286678782D-17,   1.806835670655580D-15,  -1.548714007752634D-13, &
&    1.393842475549146D-11,  -1.393842469587413D-09,   2.090763704139530D-07, &
&    5.641119922859637D-31,  -6.391034021782799D-32,  -1.527207877246601D-29, &
&    2.376429550298125D-30,   1.542891126268032D-28,   3.355664623486297D-28, &
&   -1.048047223493804D-26,   4.151110262307365D-25,  -2.737250557183088D-23, &
&    2.094659690695739D-21,  -1.665341605934951D-19,   1.343886067825821D-17, &
&   -1.099423236813263D-15,   9.161757848837272D-14,  -7.852927998912837D-12, &
&    7.067634777869281D-10,  -7.067634758739580D-08,   1.060145213733318D-05, &
&   -1.099411078260932D-30,   4.661961307763767D-32,   2.991136004980601D-29, &
&    8.287028331325380D-30,  -5.483071996112034D-28,   4.745648866568709D-27, &
&   -1.487051739653529D-25,   7.841805388705877D-24,  -5.532233311996424D-22, &
&    4.296097409419111D-20,  -3.424146720464574D-18,   2.764187269739530D-16, &
&   -2.261460421419152D-14,   1.884537747076817D-12,  -1.615317169942033D-10, &
&    1.453785401032998D-08,  -1.453785398672699D-06,   2.180678097913194D-04, &
&   -5.687822312432636D-30,   1.538956776184224D-30,   1.473547677687836D-28, &
&    9.913177385395945D-30,  -2.731521920217719D-27,   3.032659787402626D-26, &
&   -1.182453505186799D-24,   7.267469785487519D-23,  -5.392967694440421D-21, &
&    4.231765419295278D-19,  -3.378736180664444D-17,   2.728207830235704D-15, &
&   -2.232092641393260D-13,   1.860070574841318D-11,  -1.594345734034369D-09, &
&    1.434911133298158D-07,  -1.434911132054646D-05,   2.152366698031437D-03, &
&    1.962289999222789D-29,  -3.415218886230857D-30,  -5.294988381686259D-28, &
&    1.971129584513809D-28,   3.027818506373975D-27,   9.602288289061225D-26, &
&   -5.211134449469398D-24,   3.627551429404583D-22,  -2.791355547588881D-20, &
&    2.205975972433501D-18,  -1.763375549612228D-16,   1.424102383261310D-14, &
&   -1.165158363415815D-12,   9.709639053878967D-11,  -8.322546762426180D-09, &
&    7.490292028476494D-07,  -7.490292025849762D-05,   1.123543803866785D-02, &
&   -2.057800384246087D-29,   2.384446225922196D-30,   5.567911194473215D-28, &
&   -9.113378841153405D-30,  -8.883473449981556D-27,   1.770554899244776D-25, &
&   -1.322026556727437D-23,   1.031563460567636D-21,  -8.127242416931980D-20, &
&    6.451502231869405D-18,  -5.160876053131701D-16,   4.168362150134333D-14, &
&   -3.410474326097257D-12,   2.842061612585488D-10,  -2.436052787477350D-08, &
&    2.192447507379621D-06,  -2.192447507318077D-04,   3.288671260974609D-02, &
&    7.188227191417033D-30,  -3.840907639378712D-31,  -1.907627429460597D-28, &
&   -1.250010063464206D-28,   2.311354680381240D-27,   2.122286914410352D-25, &
&   -2.097750461504286D-23,   1.726585508641711D-21,  -1.376171414019277D-19, &
&    1.094773475550735D-17,  -8.760724408372691D-16,   7.076263008834286D-14, &
&   -5.789699182341735D-12,   4.824751841148050D-10,  -4.135501758281348D-08, &
&    3.721951592869782D-06,  -3.721951593343926D-04,   5.582927390035166D-02, &
&    5.397572025849088D-32,   6.056160587209013D-32,  -1.849716733582002D-30, &
&   -1.531606637829428D-30,   2.551800019649436D-29,   1.614934400871029D-29, &
&   -1.842396168371596D-28,  -9.098321872396135D-29,   7.504914045688011D-28, &
&    3.881649182406799D-28,  -1.047620748413289D-26,   7.527261676147228D-25, &
&   -6.572860353508827D-23,   5.842720402945514D-21,  -5.341914976230473D-19, &
&    5.128238331173882D-17,  -5.470120885007240D-15,   8.752193415950244D-13, &
&   -1.825077678535779D-32,  -2.122934183989961D-32,   5.163578105579384D-31, &
&    4.329733737422554D-31,  -6.152447811884783D-30,  -3.283229599042787D-30, &
&    3.950892923937516D-29,   3.086231108033608D-29,  -1.776189755009523D-27, &
&    1.370851357454085D-25,  -1.169007533071345D-23,   1.007077446250267D-21, &
&   -8.788947617925376D-20,   7.812390260071707D-18,  -7.142756286001308D-16, &
&    6.857046005303624D-14,  -7.314182404366732D-12,   1.170269184693585D-09, &
&    2.387724009723698D-34,   8.546375511799754D-33,  -2.246592963217515D-32, &
&   -2.582943518840993D-31,   4.691980427746930D-31,   4.107095656929897D-30, &
&   -4.946836649297979D-29,   3.374742626887727D-27,  -2.807563691593833D-25, &
&    2.370849912887838D-23,  -2.022169149779516D-21,   1.742071155778658D-19, &
&   -1.520342834103888D-17,   1.351415011320515D-15,  -1.235579380820213D-13, &
&    1.186156202332370D-11,  -1.265233282344055D-09,   2.024373251744805D-07, &
&    7.910035940665323D-32,  -1.526310527442615D-31,  -2.021129283105132D-30, &
&    4.119733006088520D-30,   2.017570043441317D-29,  -1.232510127559996D-29, &
&   -2.282921746997450D-27,   1.711412494432866D-25,  -1.421746192321241D-23, &
&    1.201922425510028D-21,  -1.025337952791198D-19,   8.833343529853857D-18, &
&   -7.709067162757468D-16,   6.852501442636076D-14,  -6.265143989268359D-12, &
&    6.014538219216867D-10,  -6.415507433367768D-08,   1.026481189337009D-05, &
&   -7.355146277241774D-31,   3.944052924620241D-31,   2.036158926269708D-29, &
&   -1.004861095871892D-29,  -2.450009439584671D-28,   7.285872000927345D-28, &
&   -4.188077031946139D-26,   3.493827543691078D-24,  -2.921849068372358D-22, &
&    2.471974607750503D-20,  -2.109044661444140D-18,   1.816981540162805D-16, &
&   -1.585725317369487D-14,   1.409533281814608D-12,  -1.288716120281887D-10, &
&    1.237167474174339D-08,  -1.319645305728583D-06,   2.111432489163461D-04, &
&    2.215846903603997D-30,   6.568147956779658D-31,  -6.459671720854112D-29, &
&   -1.712633076328868D-29,   6.830411380723372D-28,   5.730550771364633D-27, &
&   -4.232169542403300D-25,   3.435287421187029D-23,  -2.881962881901645D-21, &
&    2.439650179134056D-19,  -2.081638346654297D-17,   1.793389618072612D-15, &
&   -1.565137909150822D-13,   1.391233521167039D-11,  -1.271984921459108D-09, &
&    1.221105523916633D-07,  -1.302512558814110D-05,   2.084020094101376D-03, &
&    1.014949490342701D-30,  -4.552819143323884D-30,  -2.026831814363169D-29, &
&    1.327807698376149D-28,  -2.445562892409270D-28,   2.535458896282480D-26, &
&   -2.151760157516692D-24,   1.788531967843600D-22,  -1.503736552954201D-20, &
&    1.273424864034762D-18,  -1.086614466795600D-16,   9.361555377731455D-15, &
&   -8.170080213122519D-13,   7.262293151165093D-11,  -6.639810855316278D-09, &
&    6.374218419656659D-07,  -6.799166314236324D-05,   1.087866610277558D-02, &
&   -5.937968527372771D-30,   6.630265313181177D-30,   1.576484326530085D-28, &
&   -1.656527712749470D-28,  -2.634985042364259D-27,   7.696740572300612D-26, &
&   -6.229723290598762D-24,   5.225870403984596D-22,  -4.400297087483351D-20, &
&    3.727231258341823D-18,  -3.180560963279718D-16,   2.740174519717254D-14, &
&   -2.391424930466791D-12,   2.125711040587003D-10,  -1.943507236503263D-08, &
&    1.865766947009096D-06,  -1.990151410141525D-04,   3.184242256226381D-02, &
&    3.303939996312795D-30,  -2.925168784572138D-30,  -8.984105559977379D-29, &
&    8.842365778412765D-29,  -3.917987703546507D-28,   1.236403080495593D-25, &
&   -1.055112673230196D-23,   8.864567212357746D-22,  -7.469045090837908D-20, &
&    6.327314857830485D-18,  -5.399383502267580D-16,   4.651784891837099D-14, &
&   -4.059740350658435D-12,   3.608658156552556D-10,  -3.299344604924491D-08, &
&    3.167370820988699D-06,  -3.378528875732852D-04,   5.405646201173022D-02/
end


!-------------------
  module rysgrid10
!-------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t10(33,10,0:4)
      real(8) :: w10(33,10,0:4)
      data t10 / &
&   -1.427115514284848D-33,   2.311010854533143D-31,  -1.784105813206299D-29, &
&    8.738757322532079D-28,  -3.049140338598131D-26,   8.066796487978724D-25, &
&   -1.681678570142936D-23,   2.834305683554844D-22,  -3.931705986150453D-21, &
&    4.546650482406245D-20,  -4.423402865164125D-19,   3.644037798440979D-18, &
&   -2.553022382914385D-17,   1.525068902048705D-16,  -7.775634169812161D-16, &
&    3.382415021628212D-15,  -1.253145501985236D-14,   3.941815532317619D-14, &
&   -1.047878765343814D-13,   2.339624600779006D-13,  -4.352222314996058D-13, &
&    6.677318914696586D-13,  -8.343669859240422D-13,   8.360980262366028D-13, &
&   -6.660896158188466D-13,   9.983682718731491D-14,  -1.355913706864838D-11, &
&   -5.449810727831163D-10,  -2.066645896098841D-08,  -7.280275630202725D-07, &
&   -2.345157820702232D-05,  -6.589276301947741D-04,   9.863044145193489D-01, &
&    4.249021781559246D-33,  -6.881730367012910D-31,   5.313595259997679D-29, &
&   -2.603136312514454D-27,   9.084732655651728D-26,  -2.403989852021678D-24, &
&    5.012818361296184D-23,  -8.450947867712830D-22,   1.172664632326561D-20, &
&   -1.356547923959013D-19,   1.320293561300914D-18,  -1.088154509179259D-17, &
&    7.627524364943860D-17,  -4.559031961282018D-16,   2.326014767662838D-15, &
&   -1.012613928572402D-14,   3.755039696525103D-14,  -1.182417218467236D-13, &
&    3.147182574213610D-13,  -7.036807708877521D-13,   1.311113271700255D-12, &
&   -2.015068265902918D-12,   2.522258287234335D-12,  -2.530502453107875D-12, &
&    2.022021330735682D-12,  -4.060949316203269D-13,   1.369056650244694D-11, &
&   -3.786857850585171D-10,  -4.529460559951225D-08,  -2.480249148494296D-06, &
&   -1.007607156661266D-04,  -3.207385921471731D-03,   9.292418765798955D-01, &
&   -5.382232636746648D-33,   8.717727485686110D-31,  -6.731744023064156D-29, &
&    3.298153490296787D-27,  -1.151124387146866D-25,   3.046352605996307D-24, &
&   -6.352843898576361D-23,   1.071103622922800D-21,  -1.486417563594476D-20, &
&    1.719665736422955D-19,  -1.673871334768938D-18,   1.379701977187755D-17, &
&   -9.672115948658202D-17,   5.781665110617333D-16,  -2.950075106246900D-15, &
&    1.284400346296946D-14,  -4.763196957879507D-14,   1.499915241465471D-13, &
&   -3.992102529152910D-13,   8.924587670030443D-13,  -1.662235199812791D-12, &
&    2.552764345990668D-12,  -3.190507646476649D-12,   3.190793670857139D-12, &
&   -2.546172001767301D-12,   1.479120261031335D-12,   4.899550188220050D-11, &
&    2.145370495175393D-09,   2.670631599738623D-08,  -2.072337797908716D-06, &
&   -1.656358189428920D-04,  -6.812780173159855D-03,   8.321716520870235D-01, &
&    3.670736716804771D-33,  -5.944838787820497D-31,   4.589862462945870D-29, &
&   -2.248358264718800D-27,   7.845568322393394D-26,  -2.075735082473560D-24, &
&    4.327411875727640D-23,  -7.293473301844573D-22,   1.011710237138375D-20, &
&   -1.169863398624693D-19,   1.138006593070285D-18,  -9.373157293422390D-18, &
&    6.564995390028069D-17,  -3.920102235517622D-16,   1.997600677881477D-15, &
&   -8.683225220987706D-15,   3.213836783864054D-14,  -1.009553649887997D-13, &
&    2.678731774023389D-13,  -5.965052322273019D-13,   1.105380913705546D-12, &
&   -1.686185907080173D-12,   2.088222372092199D-12,  -2.060195736378460D-12, &
&    1.594792308023405D-12,  -3.192708135469477D-12,  -6.125841780990414D-11, &
&    1.199046486297575D-09,   1.106591309835889D-07,   1.338782561713478D-06, &
&   -1.518585801231042D-04,  -1.016273809479297D-02,   7.041172924000904D-01, &
&   -1.276497926295124D-33,   2.066133477085152D-31,  -1.594151210902551D-29, &
&    7.802973715604740D-28,  -2.720375241054231D-26,   7.189872303288115D-25, &
&   -1.497081414111888D-23,   2.519579369487004D-22,  -3.489128519487531D-21, &
&    4.026539207430764D-20,  -3.907680616560562D-19,   3.209557219621249D-18, &
&   -2.240489111186619D-17,   1.332490112919633D-16,  -6.757262401175499D-16, &
&    2.919991673091326D-15,  -1.072949505085754D-14,   3.340283860883097D-14, &
&   -8.763613779402315D-14,   1.923628644430117D-13,  -3.498691399229129D-13, &
&    5.206128710117147D-13,  -6.232435386607145D-13,   5.846455070461678D-13, &
&   -3.529608673354092D-13,   2.422196082148335D-12,  -5.858814416484881D-11, &
&   -2.936427885522144D-09,   5.258613239512216D-08,   4.521646659119314D-06, &
&   -5.029880406999960D-05,  -1.203657121987949D-02,   5.570113146004433D-01, &
&    1.431527453328238D-34,  -2.309095762082020D-32,   1.774511061483008D-30, &
&   -8.645564600485957D-29,   2.997863337918231D-27,  -7.873272740211209D-26, &
&    1.627242414002981D-24,  -2.714749924596756D-23,   3.720580200552386D-22, &
&   -4.240867830156372D-21,   4.055099295464981D-20,  -3.271493822068567D-19, &
&    2.234382659922931D-18,  -1.293568722221006D-17,   6.343127666471163D-17, &
&   -2.626631950302020D-16,   9.133071172220091D-16,  -2.641873752114665D-15, &
&    6.262529072049077D-15,  -1.185657294676915D-14,   1.704347504182057D-14, &
&   -1.626625082100650D-14,   4.294147649375846D-15,   1.712728842152087D-14, &
&   -1.232179680072389D-13,   1.022203739979916D-12,   8.457908262740467D-11, &
&   -2.083677137345366D-09,  -8.189788872821816D-08,   3.979650899259247D-06, &
&    8.197178534056528D-05,  -1.175083045159642D-02,   4.045642847657475D-01, &
&    3.060121711218521D-35,  -4.986503849095695D-33,   3.877031426650672D-31, &
&   -1.914424084453756D-29,   6.741632760845155D-28,  -1.802404030604074D-26, &
&    3.802844388228664D-25,  -6.497993073379252D-24,   9.156957035744979D-23, &
&   -1.078220592120822D-21,   1.070994866584411D-20,  -9.036178498464555D-20, &
&    6.507317556304210D-19,  -4.012460871993414D-18,   2.122047760094901D-17, &
&   -9.629667725226723D-17,   3.746410444051190D-16,  -1.246988502523091D-15, &
&    3.538983616339689D-15,  -8.522415753994550D-15,   1.730194489559038D-14, &
&   -2.936208057247547D-14,   4.113813194659224D-14,  -4.580685385415345D-14, &
&    7.525968333311668D-14,  -2.368830796125562D-12,   2.883637054150413D-11, &
&    1.999583683195942D-09,  -9.903587846581187D-08,   3.211181741117719D-07, &
&    1.644738299288787D-04,  -9.408384124775899D-03,   2.609850936822264D-01, &
&   -7.904240948319770D-36,   1.284673786310371D-33,  -9.958597845368032D-32, &
&    4.900497812628134D-30,  -1.718864076934560D-28,   4.574461988686258D-27, &
&   -9.600763055958233D-26,   1.630568135260060D-24,  -2.281790059164752D-23, &
&    2.665271953245808D-22,  -2.623072314863830D-21,   2.189794763834484D-20, &
&   -1.557909967129510D-19,   9.473497108235349D-19,  -4.931232633784758D-18, &
&    2.197619800299604D-17,  -8.375921751197400D-17,   2.723866843066294D-16, &
&   -7.530756711387298D-16,   1.761174330784205D-15,  -3.460916658346404D-15, &
&    5.665924731220688D-15,  -7.612684277451189D-15,   7.171848134541350D-15, &
&    8.522746617356240D-15,   7.513480567743410D-13,  -5.396470113537061D-11, &
&    1.561610740049832D-09,  -2.145146605182490D-10,  -2.503635048344438D-06, &
&    1.544945295004552D-04,  -5.861091471439838D-03,   1.396562407429770D-01, &
&    3.971098560004264D-37,  -6.477889340977274D-35,   5.041247572139987D-33, &
&   -2.491125048716818D-31,   8.776803034267132D-30,  -2.346963117954530D-28, &
&    4.950892681413750D-27,  -8.454279185969715D-26,   1.189952844610454D-24, &
&   -1.398545253854433D-23,   1.385472922264863D-22,  -1.164721857179639D-21, &
&    8.347863471663534D-21,  -5.116150195166002D-20,   2.685182291545710D-19, &
&   -1.207081904987390D-18,   4.642508120106482D-18,  -1.524030065341449D-17, &
&    4.254587416222689D-17,  -1.004883551785060D-16,   1.994476183125482D-16, &
&   -3.296423444013375D-16,   4.379565753994837D-16,   3.455456035552718D-17, &
&   -1.702405663388569D-14,   3.500527465073716D-13,   2.901600536244486D-12, &
&   -7.298318954557600D-10,   4.600405662725893D-08,  -2.105315392980547D-06, &
&    7.866638727834651D-05,  -2.399716882928894D-03,   5.188639398032369D-02, &
&   -7.188298590151939D-39,   1.169161158542500D-36,  -9.069447527324817D-35, &
&    4.465878990399946D-33,  -1.567373791472375D-31,   4.173615865989998D-30, &
&   -8.763819432602590D-29,   1.489059890983896D-27,  -2.084496594825731D-26, &
&    2.435468595606342D-25,  -2.397323750191860D-24,   2.001485538192835D-23, &
&   -1.423900038345403D-22,   8.657469173309401D-22,  -4.505440879758493D-21, &
&    2.007238669937601D-20,  -7.647468430587393D-20,   2.485994529866409D-19, &
&   -6.870630728619091D-19,   1.606372891705889D-18,  -3.155561899005475D-18, &
&    5.116923193957081D-18,  -4.496695382759611D-18,  -1.026592305063199D-16, &
&    4.646741110555224D-15,  -1.878716966308688D-13,   7.286340771788758D-12, &
&   -2.715095703111973D-10,   9.682350831020600D-09,  -3.273046986074487D-07, &
&    1.026650302854019D-05,  -2.840005896726210D-04,   5.856308436795614D-03, &
&   -2.706633941074605D-45,   1.011473929912450D-43,   6.359480256074011D-42, &
&   -5.153661041860984D-42,  -3.732694955564499D-39,  -5.516877758461286D-38, &
&    1.014305555527781D-37,   1.558135442675854D-35,   4.486877814232766D-34, &
&    9.016533079141707D-33,   6.953653684210791D-32,  -2.377555109819099D-30, &
&   -1.087654955954069D-28,  -2.289316910306525D-27,  -2.046010687450523D-26, &
&    4.456116925116065D-25,   2.388869076070557D-23,   5.439534451476776D-22, &
&    5.808630058189930D-21,  -7.669808997709013D-20,  -5.218404963042817D-18, &
&   -1.283027705833029D-16,  -1.554222982529786D-15,   1.226881192153046D-14, &
&    1.134534327322942D-12,   3.043090472241993D-11,   4.349292061257503D-10, &
&   -8.350203600781873D-10,  -2.618421932002580D-07,  -9.396856879591517D-06, &
&   -2.252196603614936D-04,  -4.036699529664723D-03,   9.514318401776356D-01, &
&    3.643650424118946D-47,   3.345075572084135D-45,  -4.223416966921093D-43, &
&   -6.629168255876888D-42,   3.930136276302825D-40,   5.800101703621610D-39, &
&   -2.068671000104559D-37,  -3.950199435966898D-36,   8.941598493158902D-35, &
&    3.063312022964260D-33,  -1.387318475447765D-32,  -1.913038775026879D-30, &
&   -2.075588247916841D-29,   6.772925718901893D-28,   1.930710619540528D-26, &
&   -8.408617666663967D-26,  -1.006424973932410D-23,  -5.525296546620064D-23, &
&    4.943588264796667D-21,   8.814313695748213D-20,  -1.788505635716699D-18, &
&   -7.730780036963808D-17,  -1.642121415783264D-16,   3.824673064443826D-14, &
&    6.072873948093508D-13,  -1.132624047638532D-11,  -4.273949070064355D-10, &
&    2.339037990802868D-09,   3.106219342887415D-07,   2.330891878385732D-06, &
&   -2.596559490481860D-04,  -1.107651678729654D-02,   7.990917749021558D-01, &
&    1.122155479284016D-45,  -5.064031420483868D-45,  -8.750819365328056D-43, &
&    3.433226033144191D-42,   2.864340188876401D-40,  -1.640312975231890D-39, &
&   -5.316442824809665D-38,   8.413062606087287D-37,   1.613943122659287D-35, &
&   -1.126210234934465D-34,  -5.665224443727709D-33,  -1.437076068770616D-31, &
&   -1.845809971088801D-30,   6.314965216046713D-29,   2.074343099391545D-27, &
&   -2.252121183151623D-26,  -1.066058668900124D-24,   2.766755302950926D-23, &
&    1.111343778831894D-21,  -1.208636491080417D-20,  -7.884793907853587D-19, &
&   -1.049486873750793D-20,   2.281450605516170D-16,  -3.450491635832938D-15, &
&   -3.550104687868656D-14,   6.822573060502839D-12,   3.713946814098164D-11, &
&   -6.102815027062203D-09,  -1.229418601422505D-09,   6.443999665017983D-06, &
&   -4.370393943107378D-05,  -1.303870640837152D-02,   6.257922305231722D-01, &
&   -2.984201958294660D-46,   2.359526580053719D-45,   2.269248716211481D-43, &
&   -1.972014321408729D-42,  -8.971699791994662D-41,   4.258907520748918D-40, &
&    2.088935813380391D-38,   1.487307988967903D-37,   2.802935546689789D-36, &
&    6.070315079948294D-36,  -2.960716968920059D-33,  -8.460125068462411D-32, &
&   -3.933761358512203D-31,   2.837736505063587D-29,   3.688209772892599D-28, &
&   -8.492151961165475D-27,   3.759574767709742D-26,   1.217000350948333D-23, &
&    1.946725749020499D-22,  -1.981378920863902D-21,  -1.783490262465906D-19, &
&   -5.953485859596907D-18,  -2.875658623184966D-18,   4.006148787235425D-15, &
&    1.140346231365892D-15,  -1.067407540940099D-12,   7.949539516495825D-11, &
&   -3.650950659604766D-10,  -1.036895962821080D-07,   3.096044762416458D-06, &
&    9.223488831084518D-05,  -1.177427276000064D-02,   4.668317137029533D-01, &
&    1.004711093272326D-47,   3.763470178277334D-46,  -3.792354064727635D-45, &
&   -4.257374040108561D-43,  -6.848184214976678D-42,   7.336172887625740D-42, &
&    2.753840878385388D-39,   1.262075889242462D-37,   2.981483436225558D-36, &
&    3.888473987386657D-36,  -1.748460998652170D-33,  -4.671396881953367D-32, &
&   -2.589428229937805D-31,   1.174877244218983D-29,   1.898856362762078D-28, &
&   -2.036612201910795D-27,   1.615989200196424D-26,   6.199218837220233D-24, &
&    1.556923053421743D-22,  -1.689473138600633D-21,  -1.365718046519158D-19, &
&   -2.016797753644848D-18,  -1.107731910229626D-17,   9.886835884519624D-16, &
&    4.795427718259486D-14,  -5.746665084567485D-13,  -2.024896616225767D-12, &
&    1.317046598670838D-09,  -6.060104969967156D-08,   6.541352694505588D-08, &
&    1.340210119177782D-04,  -9.280681376573081D-03,   3.309242101720777D-01, &
&    6.533376769180905D-47,   1.702395669879589D-47,  -5.033500007883006D-44, &
&   -6.604439326461371D-44,   1.361284870568657D-41,  -7.123252797114530D-41, &
&   -2.387306117422163D-39,   8.874804124798127D-38,   2.344080140855078D-36, &
&    2.095991044022568D-36,  -1.018722492485510D-33,  -2.664434951550547D-32, &
&   -1.824110708723750D-31,   5.861585176932448D-30,   1.078124832575418D-28, &
&   -9.589911734609990D-28,   2.120951493969450D-26,   3.639312298322760D-24, &
&    8.135275520363105D-23,  -7.350821054281055D-22,  -7.926378145156689D-20, &
&   -1.495434392740100D-18,   5.576403288387257D-18,   4.040064798885085D-16, &
&    1.926468693561594D-14,   3.081311157254981D-13,  -1.828107122602426D-11, &
&    7.329406102873318D-10,  -1.017197836328904D-08,  -1.279966684386723D-06, &
&    1.219510029112562D-04,  -6.564082108572298D-03,   2.193706745706547D-01, &
&    2.041752168692335D-47,   1.153806359239768D-46,  -1.500965979266750D-44, &
&   -1.169063663673140D-43,   2.833005825758792D-42,  -1.245299252274624D-41, &
&   -3.542419005593992D-40,   4.228208071679975D-38,   1.160966544997903D-36, &
&    2.965516528521389D-36,  -5.247023154240639D-34,  -1.469658534464892D-32, &
&   -1.128239570499232D-31,   2.880447208217139D-30,   5.747490834876463D-29, &
&   -3.784425091570703D-28,   1.340735159130519D-26,   2.001507492188196D-24, &
&    4.495712791792160D-23,  -4.550387638356261D-22,  -4.139205521680388D-20, &
&   -8.570117361067927D-19,   1.016676483401791D-18,   3.696028917598812D-16, &
&    4.881019796397914D-15,   2.828468246503457D-13,  -7.201475355716140D-12, &
&    4.153820395891503D-11,   1.331076282177266D-08,  -1.402306418635536D-06, &
&    8.722708451712010D-05,  -4.104381502547704D-03,   1.316008328867441D-01, &
&   -2.286509517035239D-48,   1.028293518386875D-46,   2.402146286737156D-45, &
&   -9.114557960708313D-44,  -2.086209673672452D-42,   5.409900711406381D-42, &
&    5.506896896629271D-40,   1.765734630041680D-38,   4.558253876116539D-37, &
&    2.051290273572269D-36,  -2.338398950243980D-34,  -7.048630578867055D-33, &
&   -5.847292317323638D-32,   1.276562167270348D-30,   2.708801851473828D-29, &
&   -1.469481105607568D-28,   7.291238295298800D-27,   9.500871945412289D-25, &
&    2.144373276202177D-23,  -2.113857194244258D-22,  -2.022526202814882D-20, &
&   -3.864465440262462D-19,  -5.658124158346840D-19,   1.972770724893301D-16, &
&    2.770972282929188D-15,   6.496744025399947D-14,   1.227057160673929D-12, &
&   -2.028038610780077D-10,   1.494240380454942D-08,  -9.449543495655804D-07, &
&    4.907628228944665D-05,  -2.136492309713296D-03,   6.671144258341085D-02, &
&    3.259685364999128D-48,   1.817958810144916D-47,  -2.335923686553346D-45, &
&   -1.791899702191424D-44,   4.005128510954744D-43,  -2.999030926417880D-42, &
&   -5.181214203935837D-41,   7.057915189592205D-39,   1.927502019065759D-37, &
&    6.404705611227779D-37,  -8.285942369415290D-35,  -2.422899550145731D-33, &
&   -2.075286174783238D-32,   4.191379665008489D-31,   9.257238891083891D-30, &
&   -4.311809494182934D-29,   2.650148094643684D-27,   3.292189550568294D-25, &
&    7.341654679173931D-24,  -7.110251855140953D-23,  -7.010069187260719D-21, &
&   -1.356617575275500D-19,  -1.372694723230756D-20,   5.406746306196846D-17, &
&    1.767312189085811D-15,  -1.658294531728391D-14,   2.123655274836587D-12, &
&   -1.355089380615610D-10,   7.391974527126532D-09,  -3.929492451016533D-07, &
&    1.867522264530631D-05,  -7.780588679844407D-04,   2.391174632885046D-02, &
&    2.146734203582953D-49,   2.712937666850493D-48,  -1.439901387451284D-46, &
&   -2.492975458980061D-45,   4.368409901167877D-45,  -1.510198154719556D-43, &
&    2.475466200850886D-42,   7.306799055822643D-40,   1.990010834292322D-38, &
&    7.820894501650346D-38,  -8.842169987658847D-36,  -2.644401203535128D-34, &
&   -2.310300565044936D-33,   4.461712401331470D-32,   1.004585879107132D-30, &
&   -4.344574688844426D-30,   2.974724288581596D-28,   3.577896258546547D-26, &
&    8.036832955465657D-25,  -8.002640102597727D-24,  -7.487301320672550D-22, &
&   -1.555685110706264D-20,   3.370285186857426D-20,   4.239923230556075D-18, &
&    2.646907760700742D-16,  -4.736668706038933D-15,   3.441166322953668D-13, &
&   -1.875623357828110D-11,   9.339530736827144D-10,  -4.650984349570350D-08, &
&    2.128220601406362D-06,  -8.690897060284632D-05,   2.651052005653556D-03, &
&   -1.404335926511388D-40,   5.626875703960601D-40,   1.274278457798722D-37, &
&   -6.863802977990862D-37,  -5.434011021453925D-35,   4.160620984009445D-34, &
&    1.433483958404324D-32,  -1.684163823597100D-31,  -2.452243396406362D-30, &
&    5.121663963632711D-29,   1.810103798895483D-28,  -1.226095290951443D-26, &
&    5.463372905020434D-26,   2.265405401720098D-24,  -3.004711564822608D-23, &
&   -2.652947000179372D-22,   8.841740650268515D-21,  -1.241535906453040D-20, &
&   -1.882456018725858D-18,   1.851525854484457D-17,   2.685811226528824D-16, &
&   -6.518295492130740D-15,  -4.069603561997740D-15,   1.530175317852216D-12, &
&   -1.310677357717299D-11,  -2.311940963927072D-10,   5.381632565903284D-09, &
&   -1.375871272158169D-09,  -1.349210252925839D-06,   1.885546129564522D-05, &
&    1.627834329599121D-04,  -1.658456110413593D-02,   7.219140832741663D-01, &
&    5.028882561738752D-41,   5.204596141256483D-41,  -4.685513141142024D-38, &
&   -2.708304808286225D-38,   2.112559124895929D-35,  -6.163086511626270D-36, &
&   -6.290058838380517D-33,   1.166201428638964D-32,   1.429868138930841D-30, &
&   -6.420202391333256D-30,  -2.691901830254454D-28,   2.351983232406632D-27, &
&    4.280038366095961D-26,  -6.801515403069645D-25,  -5.239744111372870D-24, &
&    1.674260677509115D-22,   2.194480282927674D-22,  -3.635098884148847D-20, &
&    1.424957294314628D-19,   7.004155406603652D-18,  -6.684189061845518D-17, &
&   -1.158255004400664D-15,   2.033684114133873D-14,   1.460220071240812D-13, &
&   -5.061639625993331D-12,  -9.748886191451746D-12,   1.180916168210894D-09, &
&   -6.750672847340308D-10,  -4.000525573568748D-07,   3.734350210535692D-06, &
&    2.078318354592008D-04,  -1.255030277322286D-02,   5.281146915260981D-01, &
&    1.574508687821572D-41,  -3.891488702699217D-41,  -1.449906671277403D-38, &
&    4.846033305788094D-38,   6.408537594252985D-36,  -3.037587302057405D-35, &
&   -1.845586124119946D-33,   1.300795555321940D-32,   3.969370658461263D-31, &
&   -4.355108511980974D-30,  -6.790170836342049D-29,   1.231508463722342D-27, &
&    8.827016833491319D-27,  -3.079645834625006D-25,  -4.589566391430192D-25, &
&    6.977914237914432D-23,  -2.266195702483591D-22,  -1.441678081445575D-20, &
&    1.175772759286572D-19,   2.677494519837151D-18,  -3.882217949633145D-17, &
&   -4.224919326641473D-16,   1.073254660986904D-14,   4.520506315719489D-14, &
&   -2.624143506203862D-12,   1.684957088750213D-12,   5.707245845163398D-10, &
&   -1.493284891007255D-09,  -1.700582711290193D-07,   5.071224995910777D-07, &
&    1.738132780227997D-04,  -9.326533029599739D-03,   3.880184276876254D-01, &
&    6.148421026315013D-42,  -2.546641288991279D-41,  -5.646807096951735D-39, &
&    2.989354812574007D-38,   2.482858048853519D-36,  -1.764637539334254D-35, &
&   -7.073522414139834D-34,   7.145534627698166D-33,   1.485377089206038D-31, &
&   -2.283951852951110D-30,  -2.393465838535320D-29,   6.248661092276176D-28, &
&    2.529716496728869D-27,  -1.532565060474694D-25,   1.224962546993768D-25, &
&    3.441839048586210D-23,  -1.818718154839193D-22,  -7.086923176048279D-21, &
&    7.325107473041240D-20,   1.309537963939687D-18,  -2.273137435791231D-17, &
&   -2.022829052647483D-16,   6.170708082901529D-15,   1.930967028851785D-14, &
&   -1.516476411827963D-12,   2.384834715025800D-12,   3.313682117261947D-10, &
&   -1.452354702410108D-09,  -8.052336391704198D-08,  -4.193514916505496D-07, &
&    1.328801661238668D-04,  -6.759172984077992D-03,   2.795750294411073D-01, &
&    2.788433873152740D-42,  -1.447359848824632D-41,  -2.558884046761289D-39, &
&    1.675464433238111D-38,   1.122826686645925D-36,  -9.746883235244512D-36, &
&   -3.181603176195666D-34,   3.893241460482771D-33,   6.580931164027857D-32, &
&   -1.231307488616431D-30,  -1.011399218956009D-29,   3.349120754220365D-28, &
&    8.438186982804765D-28,  -8.207129002686531D-26,   1.663542821601450D-25, &
&    1.848284571242055D-23,  -1.193505306008566D-22,  -3.820517859248738D-21, &
&    4.455897739919243D-20,   7.065950094142046D-19,  -1.355735354300276D-17, &
&   -1.077902954093896D-16,   3.666497376061105D-15,   9.385752637757812D-15, &
&   -9.052607736598280D-13,   1.818121092595321D-12,   2.016866365213956D-10, &
&   -1.158103794720849D-09,  -3.921046984785862D-08,  -6.094774174608093D-07, &
&    9.538634517576507D-05,  -4.707742862325173D-03,   1.940425079532056D-01, &
&    1.349273458405298D-42,  -7.958387875069967D-42,  -1.238008210592869D-39, &
&    9.169583689899791D-39,   5.427876788044373D-37,  -5.309913155203699D-36, &
&   -1.533348905491547D-34,   2.113200677745806D-33,   3.138887784753903D-32, &
&   -6.671769446818175D-31,  -4.643814354254094D-30,   1.816289965107718D-28, &
&    2.960493764122099D-28,  -4.465902028630253D-26,   1.239415993165880D-25, &
&    1.010690473535116D-23,  -7.276648472561946D-23,  -2.099306589002690D-21, &
&    2.629814163768032D-20,   3.890914918902444D-19,  -7.941695291659769D-18, &
&   -5.888561540909677D-17,   2.148127125995111D-15,   4.758474152048572D-15, &
&   -5.320163896433104D-13,   1.190357347347020D-12,   1.209769131549671D-10, &
&   -8.180632177294949D-10,  -1.878635772657204D-08,  -5.313197769684386D-07, &
&    6.370595143857851D-05,  -3.085387769988078D-03,   1.268837046077063D-01, &
&    6.481041975241821D-43,  -4.137545679041975D-42,  -5.947201785746652D-40, &
&    4.759475420023781D-39,   2.606789297394111D-37,  -2.752552506100800D-36, &
&   -7.351158726709286D-35,   1.094940137198466D-33,   1.494053420869265D-32, &
&   -3.460093208783567D-31,  -2.145623293501710D-30,   9.443712672572904D-29, &
&    1.015102061397248D-28,  -2.331245935968513D-26,   7.589232034983110D-26, &
&    5.300523019044763D-24,  -4.074297806348289D-23,  -1.105686827097366D-21, &
&    1.448837062793068D-20,   2.053655873709386D-19,  -4.362296635893482D-18, &
&   -3.091948537653442D-17,   1.181363781150194D-15,   2.355510808246000D-15, &
&   -2.931482354802042D-13,   6.931757567202823D-13,   6.784054031080616D-11, &
&   -5.095509356084243D-10,  -8.503195762477371D-09,  -3.680096316565173D-07, &
&    3.839893016145343D-05,  -1.836953847719800D-03,   7.542810291889669D-02, &
&    2.821177452484095D-43,  -1.893075535785378D-42,  -2.589248358028897D-40, &
&    2.176582330247657D-39,   1.134902983341252D-37,  -1.258625597452040D-36, &
&   -3.197247093493287D-35,   5.009401371546746D-34,   6.466694302658387D-33, &
&   -1.585392252834403D-31,  -9.085877157858666D-31,   4.338147293903331D-29, &
&    3.144190194179295D-29,  -1.074529691622628D-26,   3.829290843534380D-26, &
&    2.452175681750183D-24,  -1.962605016938487D-23,  -5.132056389313345D-22, &
&    6.919403753380729D-21,   9.548339828102774D-20,  -2.080981495537198D-18, &
&   -1.432777295300788D-17,   5.642682600659911D-16,   1.044633509027860D-15, &
&   -1.401823893163840D-13,   3.415010764663055D-13,   3.288118495251856D-11, &
&   -2.642720445936587D-10,  -3.411096439985618D-09,  -2.026610983527872D-07, &
&    1.952443756828909D-05,  -9.265715318666582D-04,   3.800816913093838D-02, &
&    9.190566526166042D-44,  -6.352388416421949D-43,  -8.436328820058377D-41, &
&    7.303244526814565D-40,   3.697983606162223D-38,  -4.224026812321274D-37, &
&   -1.041244175719928D-35,   1.682301329812916D-34,   2.099715260097828D-33, &
&   -5.331024066731410D-32,  -2.908029208307393D-31,   1.461541792828672D-29, &
&    7.552150621913256D-30,  -3.628756370336736D-27,   1.360378071533653D-26, &
&    8.301931012469180D-25,  -6.803895647732954D-24,  -1.741295238059485D-22, &
&    2.388010875653102D-21,   3.243512452347947D-20,  -7.179034320513573D-19, &
&   -4.857279081148439D-18,   1.948493840464971D-16,   3.439649704550775D-16, &
&   -4.843833884242891D-14,   1.198697037879296D-13,   1.146486980290753D-11, &
&   -9.598818737070416D-11,  -1.029022537737365D-09,  -7.612267146827979D-08, &
&    7.011019926766698D-06,  -3.311105111695917D-04,   1.357385875069831D-02, &
&    9.730155424145647D-45,  -6.819197932848787D-44,  -8.932426933723272D-42, &
&    7.840156500750354D-41,   3.915638845509141D-39,  -4.535349498103010D-38, &
&   -1.102278091728773D-36,   1.807022641280355D-35,   2.219623098688154D-34, &
&   -5.730297960879846D-33,  -3.052261464127412D-32,   1.572590075896096D-30, &
&    6.594597664452733D-31,  -3.909216448624024D-28,   1.499610147089782D-27, &
&    8.954843569902298D-26,  -7.420349116361761D-25,  -1.880298608806409D-23, &
&    2.599288048768936D-22,   3.504495457381346D-21,  -7.813364615453584D-20, &
&   -5.243150324828265D-19,   2.121729868402197D-17,   3.659253881237611D-17, &
&   -5.276020541376119D-15,   1.314566479742348D-14,   1.254443200116104D-12, &
&   -1.070735654384093D-11,  -1.039749662556040D-10,  -8.621794379116037D-09, &
&    7.779671844645240D-07,  -3.665681779146938D-05,   1.502303469106069D-03, &
&   -2.771343794147297D-48,   2.027134655397874D-47,   2.403638478268857D-45, &
&   -3.682327405173407D-44,  -1.010176147142710D-43,  -3.621157639335061D-42, &
&    1.833019984210735D-40,   1.989252671309415D-39,  -2.293006536922063D-37, &
&    9.399740268067566D-36,  -3.054809484786790D-34,   7.624198529593443D-33, &
&   -1.125759230635046D-31,  -1.217011498093395D-30,   1.598803221287064D-28, &
&   -6.738872210659387D-27,   1.899785739458944D-25,  -3.581031238947334D-24, &
&    2.158381694375346D-23,   1.596104348699151D-21,  -8.609472237453034D-20, &
&    2.769209937510751D-18,  -6.842549720477628D-17,   1.369852932921477D-15, &
&   -2.155512868210686D-14,   1.832531760473703D-13,   6.003987771418958D-12, &
&   -5.777066935135437D-10,   3.696003820315472D-08,  -2.237217957630958D-06, &
&    1.343635825266414D-04,  -8.062451508321861D-03,   4.837491194006947D-01, &
&   -2.296289064178725D-48,   3.195963403157958D-47,   9.159978128670837D-46, &
&   -8.690704891458676D-45,  -3.856651991948285D-44,  -1.192187246404780D-41, &
&    4.102737657906358D-40,  -6.216748620066621D-39,   2.959619338472396D-38, &
&    3.015439638045702D-36,  -1.800390833015008D-34,   6.245932560407749D-33, &
&   -1.489288118066361D-31,   1.943744346302069D-30,   2.775417643248340D-29, &
&   -2.745668616812722D-27,   1.012753453201743D-25,  -2.442147773951252D-24, &
&    3.433310464668302D-23,   1.954088245533020D-22,  -3.107234262841074D-20, &
&    1.201305039769861D-18,  -3.224554070446461D-17,   6.735738421379791D-16, &
&   -1.056473825854571D-14,   6.357522687522093D-14,   5.193473165095939D-12, &
&   -4.296330821955234D-10,   2.704924916109164D-08,  -1.633983795707890D-06, &
&    9.811341433637157D-05,  -5.887172021098156D-03,   3.532315037967858D-01, &
&    4.615559329754266D-49,   2.515474893547839D-47,  -1.033080570176694D-45, &
&   -3.479885779857153D-45,   3.997393706136903D-43,  -5.700827320388271D-42, &
&    1.765438734911927D-40,  -5.816334980481330D-39,   8.716160159825364D-38, &
&    6.886524593771581D-37,  -9.383646597179835D-35,   3.820165451233992D-33, &
&   -1.033532694821765D-31,   1.735750016065020D-30,   1.295441096868796D-30, &
&   -1.359899628434080D-27,   5.833831011503456D-26,  -1.539816567981570D-24, &
&    2.505097713163665D-23,  -1.968842381616224D-23,  -1.556922289772732D-20, &
&    6.676456958697185D-19,  -1.864690552511079D-17,   3.963033310505143D-16, &
&   -6.130783032371957D-15,   2.382283637955431D-14,   4.084282648236347D-12, &
&   -3.181238022885140D-10,   1.988178051353903D-08,  -1.199852348656999D-06, &
&    7.203830378279007D-05,  -4.322532399090477D-03,   2.593527021413477D-01, &
&   -9.890757583596804D-49,   4.956521691908461D-48,   4.241879961384342D-46, &
&    6.706197361984011D-45,  -2.204342599602616D-43,  -5.189502864364060D-42, &
&    2.160213483871516D-40,  -3.803466886054202D-39,   5.743158155856840D-38, &
&   -6.398619657472495D-38,  -4.925966942767427D-35,   2.358230745683904D-33, &
&   -6.847765830766157D-32,   1.267457317377280D-30,  -4.493399058637181D-30, &
&   -7.448381240345528D-28,   3.544582109691712D-26,  -9.845902405602933D-25, &
&    1.712624354930308D-23,  -5.754415917007376D-23,  -8.751029891642197D-21, &
&    4.018007616272774D-19,  -1.148991056594538D-17,   2.463459765925176D-16, &
&   -3.753739607055035D-15,   7.682771392021537D-15,   3.055855246037868D-12, &
&   -2.302731886835706D-10,   1.432935680906483D-08,  -8.642678543010907D-07, &
&    5.188679788258233D-05,  -3.113360991558375D-03,   1.868021568730119D-01, &
&    8.634259468067785D-49,  -5.150710241289876D-48,  -9.105996526071509D-46, &
&    1.160393244576179D-44,   2.653850836328466D-43,  -5.522579914349194D-42, &
&    4.364210889590396D-41,  -1.992623041314292D-39,   5.658660970649604D-38, &
&   -3.102124599421632D-37,  -2.881524737643449D-35,   1.459818186849695D-33, &
&   -4.398292233658638D-32,   8.614878334487823D-31,  -4.905111597643865D-30, &
&   -4.237758996657042D-28,   2.175737798964398D-26,  -6.245752031051500D-25, &
&    1.129288463446487D-23,  -5.358956586762323D-23,  -5.106697994636258D-21, &
&    2.460229578607688D-19,  -7.144473524458055D-18,   1.539281598275836D-16, &
&   -2.312512798569564D-15,   1.100355477915129D-15,   2.171914922096274D-12, &
&   -1.603071296024898D-10,   9.947521852641089D-09,  -5.997515214109109D-07, &
&    3.600492026103324D-05,  -2.160394269231339D-03,   1.296239786175016D-01, &
&    3.862718493991336D-49,   1.289989500870213D-47,  -4.570270111960354D-46, &
&   -5.658683092368356D-45,   1.230521239332232D-43,   1.453969390711517D-42, &
&    3.165470317528854D-41,  -2.276060586874679D-39,   3.643004036910245D-38, &
&   -1.222524892070420D-37,  -1.592022957895317D-35,   8.575868653537921D-34, &
&   -2.709495562279496D-32,   5.501219008941205D-31,  -3.816070872022351D-30, &
&   -2.394461509705416D-28,   1.300496547710037D-26,  -3.817937567626682D-25, &
&    7.076018182972520D-24,  -3.957045685676378D-23,  -2.947703976507953D-21, &
&    1.470273167192863D-19,  -4.314771790610881D-18,   9.322585100988401D-17, &
&   -1.383367569301411D-15,  -1.155990625068427D-15,   1.442943768677487D-12, &
&   -1.050415824028096D-10,   6.505619529524715D-09,  -3.921311440330002D-07, &
&    2.354015754164557D-05,  -1.412470944542397D-03,   8.474845716298951D-02, &
&   -3.387725803198785D-49,  -4.928979323927794D-48,   2.080382936345958D-46, &
&    6.368366972266452D-45,  -1.096341930127401D-43,  -2.459413958898594D-42, &
&    5.727293160870586D-41,  -6.032528846312660D-40,   1.556118929322213D-38, &
&   -1.960341031658440D-37,  -7.727259164788162D-36,   4.861231514134812D-34, &
&   -1.543948496059354D-32,   3.188992474782600D-31,  -2.466645889264560D-30, &
&   -1.278911359987765D-28,   7.243285142494087D-27,  -2.159775976098516D-25, &
&    4.069021035693731D-24,  -2.497647079487378D-23,  -1.602084357552135D-21, &
&    8.193281543515406D-20,  -2.421971052111718D-18,   5.241704015784591D-17, &
&   -7.699572172910464D-16,  -1.454553969506375D-15,   8.671273095840977D-13, &
&   -6.253351689130208D-11,   3.867786112924279D-09,  -2.330912318993637D-07, &
&    1.399249821906579D-05,  -8.395850836629461D-04,   5.037521987937779D-02, &
&    2.251993591878100D-49,   1.174230878380530D-48,  -2.139952710368551D-46, &
&    3.160525611156477D-46,   6.146120893170653D-44,  -1.869057168586349D-43, &
&    2.166158041384226D-42,  -5.066851775456424D-40,   1.164118255158121D-38, &
&   -7.578839131695460D-38,  -3.940817731066011D-36,   2.308014680706534D-34, &
&   -7.499824995371779D-33,   1.580197329359378D-31,  -1.301998858041552D-30, &
&   -5.979716645895435D-29,   3.487570009823652D-27,  -1.050870984636935D-25, &
&    2.001324657776573D-24,  -1.299014624659463D-23,  -7.585584732214270D-22, &
&    3.947408234564385D-20,  -1.172593272547755D-18,   2.540229904555172D-17, &
&   -3.702600469166650D-16,  -9.933706195446210D-16,   4.401266937761796D-13, &
&   -3.154129215716400D-11,   1.949119004851758D-09,  -1.174486685874046D-07, &
&    7.050363340537675D-06,  -4.230390643811712D-04,   2.538240025270885D-02, &
&    1.585882568630548D-50,  -1.174844710846874D-50,  -2.372707859230673D-47, &
&    4.376471931409144D-46,   2.481994579910534D-45,  -1.733236358656813D-43, &
&    4.868312781313493D-42,  -1.545178832349992D-40,   3.514115623574075D-39, &
&   -3.174731000432885D-38,  -1.265776816875432D-36,   8.027632703993113D-35, &
&   -2.627316813555094D-33,   5.572643498508329D-32,  -4.758786291054859D-31, &
&   -2.035692619855695D-29,   1.210012962569401D-27,  -3.669947951566348D-26, &
&    7.035433977693264D-25,  -4.716310106081169D-24,  -2.604328742047453D-22, &
&    1.370255010384037D-20,  -4.082760911370365D-19,   8.849347626103605D-18, &
&   -1.283163405288064D-16,  -4.124302564591396D-16,   1.578885261894240D-13, &
&   -1.127117104033174D-11,   6.961214340744087D-10,  -4.194317029693356D-08, &
&    2.517798430166246D-06,  -1.510739667276309D-04,   9.064457809752722D-03, &
&    2.344497451478283D-51,   6.927545607929291D-51,  -3.096640992902347D-48, &
&    4.143201808019023D-47,   4.520187690132328D-46,  -1.632058207086926D-44, &
&    4.861815859853153D-43,  -1.748462271835695D-41,   3.950619873439533D-40, &
&   -3.508107371263849D-39,  -1.369465576650880D-37,   8.746860806304168D-36, &
&   -2.877158826038767D-34,   6.130388928125472D-33,  -5.322047742803528D-32, &
&   -2.201152226767013D-30,   1.320508218966391D-28,  -4.017669009707395D-27, &
&    7.726217672007070D-26,  -5.257100970848304D-25,  -2.827756342603746D-23, &
&    1.495784588089762D-21,  -4.463268707814534D-20,   9.676374326599397D-19, &
&   -1.399411532871306D-17,  -4.870647805896361D-17,   1.751201975138512D-14, &
&   -1.247813973791539D-12,   7.704583486970423D-11,  -4.642044580251894D-09, &
&    2.786552518170622D-07,  -1.671998033548028D-05,   1.003200994463001D-03, &
&   -9.266725860666228D-50,  -7.046028462764021D-49,   7.501364999600969D-47, &
&    5.636580377251560D-46,  -2.751673897417843D-44,  -2.042612176464694D-43, &
&    6.049522126914247D-42,   4.431065193472255D-41,  -8.886514848716197D-40, &
&   -6.340377274682708D-39,   8.776883396643631D-38,   8.305531444309492D-37, &
&   -1.388333103339586D-35,   2.015895905683247D-34,  -7.678270427080129D-33, &
&    2.398853222778181D-31,  -6.381828026988095D-30,   1.519726457412861D-28, &
&   -2.904733729864638D-27,   1.258776996835903D-26,   3.766165247859782D-24, &
&   -3.958349708616446D-22,   3.336840674722867D-20,  -2.697153594066760D-18, &
&    2.161764533386234D-16,  -1.729936569354015D-14,   1.384009215012587D-12, &
&   -1.107213305569101D-10,   8.857711431535319D-09,  -7.086169491536793D-07, &
&    5.668935612314900D-05,  -4.535148490634884D-03,   3.628118792529170D-01, &
&    8.778175227027197D-49,   3.176323477161191D-48,  -7.059029940266349D-46, &
&   -2.558172170069820D-45,   2.571669023768623D-43,   9.334441189271433D-43, &
&   -5.612461074512084D-41,  -2.040267889155588D-40,   8.175420576150306D-39, &
&    2.977756042060622D-38,  -8.400435115695411D-37,  -2.961304560348528D-36, &
&    5.845271605789795D-35,   3.610564080747029D-34,  -7.831603993626621D-33, &
&    1.215823285595390D-31,  -3.498257249463329D-30,   8.729865609453216D-29, &
&   -1.592696456305486D-27,  -1.594878291815450D-27,   2.949878564597084D-24, &
&   -2.924173487683362D-22,   2.441736220425005D-20,  -1.970167097375492D-18, &
&    1.578599462433350D-16,  -1.263201745468426D-14,   1.010598396906835D-12, &
&   -8.084823975274421D-11,   6.467862287582857D-09,  -5.174290046785309D-07, &
&    4.139432049420229D-05,  -3.311545640030008D-03,   2.649236512037465D-01, &
&   -2.695796536241343D-48,  -4.559632144427935D-48,   2.160330955415510D-45, &
&    3.739982092408260D-45,  -7.842468929364307D-43,  -1.390763980047848D-42, &
&    1.705433516044226D-40,   3.098859730019181D-40,  -2.475235189757166D-38, &
&   -4.606020456349687D-38,   2.527416771204952D-36,   4.869811329433173D-36, &
&   -1.890140485265970D-34,  -2.802121283552459D-34,   7.308718215447012D-33, &
&    1.042023203490302D-31,  -2.696478652138641D-30,   5.400304165130264D-29, &
&   -9.557403632814716D-28,  -5.226490693304538D-27,   2.242345007468683D-24, &
&   -2.160150001493550D-22,   1.794829167010448D-20,  -1.446837162117374D-18, &
&    1.159088301357110D-16,  -9.274828124749627D-15,   7.420106904765609D-13, &
&   -5.936109899859939D-11,   4.748889983542897D-09,  -3.799112131111761D-07, &
&    3.039289712891133D-05,  -2.431431770643123D-03,   1.945145416523516D-01, &
&    4.289625057386019D-48,  -4.059545068839547D-49,  -3.424411135598419D-45, &
&    9.881350476442630D-47,   1.238168821624567D-42,   5.257861689943902D-44, &
&   -2.681324937105121D-40,  -3.187846218187220D-41,   3.874804568409542D-38, &
&    7.741136607978070D-39,  -3.941023376192866D-36,  -1.083526274807146D-36, &
&    2.883087358065323D-34,   1.600335659916429D-34,  -1.737433157327937D-32, &
&    4.751552879758319D-32,  -8.805008577717098D-31,   3.584335339653568D-29, &
&   -6.250276500568141D-28,  -5.630318086062891D-27,   1.650352842409312D-24, &
&   -1.561854959258953D-22,   1.293681613542588D-20,  -1.042234160634997D-18, &
&    8.348647719196124D-17,  -6.680333535407713D-15,   5.344430186459347D-13, &
&   -4.275560471563948D-11,   3.420449761441832D-09,  -2.736359906081609D-07, &
&    2.189087930249063D-05,  -1.751270344421744D-03,   1.401016275543480D-01, &
&   -3.632121007553472D-48,   7.430393476092675D-48,   2.884782290135613D-45, &
&   -5.653503819892283D-45,  -1.037466688727328D-42,   1.933072625779451D-42, &
&    2.234017587895084D-40,  -3.923361066130126D-40,  -3.209183530674958D-38, &
&    5.259695894825136D-38,   3.242624079585376D-36,  -4.882772602361791D-36, &
&   -2.377644857447726D-34,   3.602436430083294D-34,   1.149911685999498D-32, &
&    1.940882671383085D-32,  -1.455197097783736D-30,   2.335011009268531D-29, &
&   -3.660537092547286D-28,  -4.777234634233490D-27,   1.161081453414604D-24, &
&   -1.086623557984375D-22,   8.981440785196253D-21,  -7.232797277312628D-19, &
&    5.793292655552829D-17,  -4.635562230526883D-15,   3.708557049621792D-13, &
&   -2.966856370987303D-11,   2.373486007917679D-09,  -1.898788870207218D-07, &
&    1.519031099717276D-05,  -1.215224879920739D-03,   9.721799039406123D-02, &
&    1.610796941397992D-48,  -8.084379367034818D-48,  -1.267000791980946D-45, &
&    6.247793908608689D-45,   4.509191976099021D-43,  -2.175595832153833D-42, &
&   -9.600684755232183D-41,   4.510793514378757D-40,   1.362305491921987D-38, &
&   -6.199876940343564D-38,  -1.358486852401638D-36,   5.966011495762154D-36, &
&    9.719109796858747D-35,  -3.892063724777118D-34,  -5.841218431851636D-33, &
&    4.215724577394914D-32,  -3.981289619789324D-31,   1.333155028279578D-29, &
&   -2.348476778654529D-28,  -3.491679472338629D-27,   7.669585152290213D-25, &
&   -7.117517708359436D-23,   5.874138670345971D-21,  -4.729109558411585D-19, &
&    3.787704579770229D-17,  -3.030745334805817D-15,   2.424663559552395D-13, &
&   -1.939737585915707D-11,   1.551790641324693D-09,  -1.241432553232523D-07, &
&    9.931460448214154D-06,  -7.945168359496722D-04,   6.356134687622724D-02, &
&   -2.920563958038786D-49,   3.582025861595677D-48,   2.228557635698431D-46, &
&   -2.774513986041054D-45,  -7.665921245036962D-44,   9.683833918717685D-43, &
&    1.570274029385499D-41,  -2.012518578080459D-40,  -2.130829135465101D-39, &
&    2.772514005507130D-38,   2.014305838430082D-37,  -2.660223140154026D-36, &
&   -1.392163725968986D-35,   1.958421285315023D-34,   2.571223977432932D-34, &
&    3.160589276078316D-33,  -3.622896365353438D-31,   8.349819991504478D-30, &
&   -1.278593377129424D-28,  -2.261836801457436D-27,   4.589877801371812D-25, &
&   -4.236190673837575D-23,   3.492507130346655D-21,  -2.811146436993678D-19, &
&    2.251459957712486D-17,  -1.801503086190480D-15,   1.441241264776600D-13, &
&   -1.152996899167170D-11,   9.223978498663872D-10,  -7.379183030964304D-08, &
&    5.903346437689849D-06,  -4.722677150686944D-04,   3.778141720564218D-02, &
&    4.822521554393110D-51,  -5.917683190539578D-49,  -1.472109947861044D-48, &
&    4.561368672937923D-46,  -3.704876730495326D-46,  -1.581862604118779D-43, &
&    2.877150927958974D-43,   3.259700463621838D-41,  -7.379604300773539D-41, &
&   -4.440352073999848D-39,   1.102112860810795D-38,   4.245345066354342D-37, &
&   -1.258647217525915D-36,  -2.271425502687066D-35,  -1.197982587059313D-34, &
&    7.438194731982312D-33,  -1.700574824179530D-31,   3.870571342937534D-30, &
&   -6.182407817777251D-29,  -1.191436733340562D-27,   2.323664000545278D-25, &
&   -2.136394273753645D-23,   1.760058909280799D-21,  -1.416485843201264D-19, &
&    1.134441255560624D-17,  -9.077181672949011D-16,   7.261936633771179D-14, &
&   -5.809568483439963D-12,   4.647656417969422D-10,  -3.718125248932206D-08, &
&    2.974500205526088D-06,  -2.379600164685231D-04,   1.903680131755431D-02, &
&    2.138103092943767D-51,   2.293854410763088D-50,  -1.845617158275929D-48, &
&   -1.726938682912990D-47,   7.177930778573990D-46,   5.800863402469160D-45, &
&   -1.666489036820839D-43,  -1.145067337013300D-42,   2.579732292918513D-41, &
&    1.471811119900795D-40,  -2.835024268772465D-39,  -1.161363032730393D-38, &
&    1.698663269853431D-37,   2.790757464698391D-36,  -8.204487271754486D-35, &
&    2.089492687197213D-33,  -5.772039213416836D-32,   1.373600917700069D-30, &
&   -2.153171971197956D-29,  -4.387630824606236D-28,   8.322911094595517D-26, &
&   -7.633676672954080D-24,   6.286124171824466D-22,  -5.058591247599302D-20, &
&    4.051281746995800D-18,  -3.241606915301098D-16,   2.593352905325437D-14, &
&   -2.074689079990545D-12,   1.659751838812771D-10,  -1.327801511428679D-08, &
&    1.062241211392389D-06,  -8.497929692071350D-05,   6.798343753682640D-03, &
&    2.492076356238253D-52,  -1.200127892438260D-51,  -1.989285692040052D-49, &
&    9.211197134445196D-49,   7.196761540192927D-47,  -3.182393565361137D-46, &
&   -1.560314610377765D-44,   6.532878234493109D-44,   2.259735693318100D-42, &
&   -8.854699077090084D-42,  -2.327913101077225D-40,   9.714793761476344D-40, &
&    1.121582213552688D-38,   1.649605520546118D-37,  -8.490514883323543D-36, &
&    2.353304712462308D-34,  -6.356276325768033D-33,   1.504085535885659D-31, &
&   -2.349391492777432D-30,  -4.924186560134098D-29,   9.224419401939882D-27, &
&   -8.450794555306389D-25,   6.957474334125418D-23,  -5.598603069629144D-21, &
&    4.483727334117888D-19,  -3.587621010986743D-17,   2.870170869085298D-15, &
&   -2.296144122565376D-13,   1.836915930095294D-11,  -1.469532788479731D-09, &
&    1.175626233257746D-07,  -9.405009867087367D-06,   7.524007893698011D-04/
      data w10 / &
&    5.998520981213953D-33,  -9.686589712780572D-31,   7.457172049258841D-29, &
&   -3.642601418601602D-27,   1.267658892154552D-25,  -3.345681604250110D-24, &
&    6.960402976520809D-23,  -1.171294049481396D-21,   1.623454783668578D-20, &
&   -1.877683470659743D-19,   1.829556131830041D-18,  -1.512229812021424D-17, &
&    1.065570296646059D-16,  -6.422404327231736D-16,   3.318100083616115D-15, &
&   -1.471641153813820D-14,   5.620588074047162D-14,  -1.879734886567224D-13, &
&    6.042338621656161D-13,  -2.646328580179662D-12,   2.208836416141721D-11, &
&   -2.508407501383428D-10,   2.843965732808335D-09,  -2.971834233558404D-08, &
&    2.803273032265123D-07,  -2.354466450608584D-06,   1.733191284596135D-05, &
&   -1.095519714356923D-04,   5.781491828997874D-04,  -2.445941676764013D-03, &
&    7.778369617674630D-03,  -1.653120441684278D-02,   1.761400713915212D-02, &
&    8.941934797238838D-35,  -1.446179263847757D-32,   1.114759962432402D-30, &
&   -5.450316789140436D-29,   1.897596588451455D-27,  -5.007147551472866D-26, &
&    1.040541870642148D-24,  -1.747024944200164D-23,   2.412163982249974D-22, &
&   -2.773574814096387D-21,   2.679634974585865D-20,  -2.189000787188161D-19, &
&    1.519038315876681D-18,  -9.002128222331885D-18,   4.625547963752156D-17, &
&   -2.200195990396570D-16,   1.226155521666321D-15,  -1.127054553921563D-14, &
&    1.513093362742201D-13,  -2.177187445947865D-12,   2.990993185437394D-11, &
&   -3.817893273843940D-10,   4.483399638872224D-09,  -4.802989669984259D-08, &
&    4.648286205282269D-07,  -4.015240029510203D-06,   3.048640275631021D-05, &
&   -1.994001814934291D-04,   1.092872250246277D-03,  -4.821483611251348D-03, &
&    1.606382081902695D-02,  -3.595820207177676D-02,   4.060142980038694D-02, &
&    1.294409465134335D-33,  -2.098064685169986D-31,   1.621381073820486D-29, &
&   -7.950809398132836D-28,   2.777751555284065D-26,  -7.359320955978252D-25, &
&    1.536660198754789D-23,  -2.594604229233854D-22,   3.606646886552995D-21, &
&   -4.180638485762113D-20,   4.078442945866197D-19,  -3.370577205407468D-18, &
&    2.370363429075872D-17,  -1.422526307865953D-16,   7.298324137049129D-16, &
&   -3.209827857400746D-15,   1.226539839446247D-14,  -4.393456687211154D-14, &
&    2.010650283203501D-13,  -1.744973409402034D-12,   2.199793880155735D-11, &
&   -2.857556397004466D-10,   3.478704098517365D-09,  -3.885263085230832D-08, &
&    3.937413833753430D-07,  -3.578282920426870D-06,   2.873304508788889D-05, &
&   -1.999226707389455D-04,   1.173414920339272D-03,  -5.585987808222581D-03, &
&    2.025809708749601D-02,  -4.986634937573896D-02,   6.267204833410906D-02, &
&   -2.783479556671781D-33,   4.510080564939113D-31,  -3.484011158871814D-29, &
&    1.707699776821682D-27,  -5.963101274191513D-26,   1.578931613228688D-24, &
&   -3.294675709521295D-23,   5.558666417809011D-22,  -7.719947411601111D-21, &
&    8.939223928936627D-20,  -8.710001298240670D-19,   7.187745154027953D-18, &
&   -5.045753585159750D-17,   3.021021435588413D-16,  -1.544245612155543D-15, &
&    6.734050731811379D-15,  -2.494234673815855D-14,   7.691418860365491D-14, &
&   -1.725235740346777D-13,  -1.499564399892119D-13,   8.450893897568147D-12, &
&   -1.286407818808343D-10,   1.675778125558956D-09,  -1.992338830754111D-08, &
&    2.159940509467123D-07,  -2.113840707341186D-06,   1.841730996855571D-05, &
&   -1.402407464190306D-04,   9.096866083258940D-04,  -4.840738165781421D-03, &
&    1.988930568894092D-02,  -5.637725136425794D-02,   8.327674157670475D-02, &
&    3.226652336856069D-33,  -5.226201966004113D-31,   4.035511119982695D-29, &
&   -1.977078520841385D-27,   6.900023028691333D-26,  -1.825895006522579D-24, &
&    3.807344309668345D-23,  -6.418500225034425D-22,   8.905933327311368D-21, &
&   -1.030163618377880D-19,   1.002520722220020D-18,  -8.261327470163432D-18, &
&    5.789784573399279D-17,  -3.459821892204122D-16,   1.764755130155579D-15, &
&   -7.681291026410324D-15,   2.849603563024322D-14,  -9.013257846976788D-14, &
&    2.478421501658691D-13,  -6.924182552614698D-13,   3.529039818486396D-12, &
&   -3.932308092598588D-11,   5.274128165235785D-10,  -6.775604948754076D-09, &
&    8.031442707931963D-08,  -8.672411625059956D-07,   8.420252630299769D-06, &
&   -7.226525946887394D-05,   5.353304207511918D-04,  -3.304397620208022D-03, &
&    1.605132542062904D-02,  -5.510797222475486D-02,   1.019301198172404D-01, &
&   -2.670286801357433D-33,   4.323299867610639D-31,  -3.336787249638475D-29, &
&    1.633911908451564D-27,  -5.699016591177700D-26,   1.507075236155067D-24, &
&   -3.140149683190559D-23,   5.289116869539009D-22,  -7.331524970567795D-21, &
&    8.470710915104256D-20,  -8.232400016663836D-19,   6.773405046863264D-18, &
&   -4.738358422220624D-17,   2.825428913189548D-16,  -1.437458485666541D-15, &
&    6.236635950347036D-15,  -2.303033794087061D-14,   7.210275632182929D-14, &
&   -1.895821410730307D-13,   3.990138528061771D-13,  -3.564207969677579D-13, &
&   -5.735368649443100D-12,   1.044224074562669D-10,  -1.513125795257469D-09, &
&    2.011873841368353D-08,  -2.460616357531937D-07,   2.739231754619769D-06, &
&   -2.733930726144399D-05,   2.394910497094236D-04,  -1.783877942030385D-03, &
&    1.072773021059405D-02,  -4.720125392288803D-02,   1.181945319615184D-01, &
&    1.902565103731791D-33,  -3.079552492112660D-31,   2.376166036468904D-29, &
&   -1.163150808658700D-27,   4.055522693196630D-26,  -1.072009283270279D-24, &
&    2.232564164299068D-23,  -3.758333727162441D-22,   5.206285139744101D-21, &
&   -6.010779712802645D-20,   5.836626991205576D-19,  -4.797372667583981D-18, &
&    3.352031703785921D-17,  -1.995970852805198D-16,   1.013770079739929D-15, &
&   -4.389665243458552D-15,   1.617276554126782D-14,  -5.052930341293100D-14, &
&    1.332852087119541D-13,  -2.963785605399020D-13,   5.816947715386048D-13, &
&   -1.574268461583134D-12,   1.410444164888580D-11,  -2.144670428760560D-10, &
&    3.266432705166383D-09,  -4.658098494408166D-08,   6.137125468325424D-07, &
&   -7.374220010699657D-06,   7.937249061247578D-05,  -7.450308280007062D-04, &
&    5.836143104501617D-03,  -3.506590148453216D-02,   1.316886384491766D-01, &
&   -1.294520747288084D-33,   2.095353492502219D-31,  -1.616762174215441D-29, &
&    7.914151548630595D-28,  -2.759391199156550D-26,   7.293936532514799D-25, &
&   -1.519018218299178D-23,   2.557103014097115D-22,  -3.542195235851067D-21, &
&    4.089444204221346D-20,  -3.970826741723895D-19,   3.263651127310534D-18, &
&   -2.280259903936398D-17,   1.357687216887509D-16,  -6.895183923131533D-16, &
&    2.985296176542370D-15,  -1.099694054849884D-14,   3.434869934449727D-14, &
&   -9.051380332233858D-14,   1.997920658827810D-13,  -3.644619982746221D-13, &
&    5.067937455480880D-13,   2.357517200289971D-13,  -1.673436438085079D-11, &
&    3.161170414471297D-10,  -5.457402973316912D-09,   8.840797561647645D-08, &
&   -1.332629065614072D-06,   1.843663221460619D-05,  -2.293522618781309D-04, &
&    2.480947244031508D-03,  -2.185832269462193D-02,   1.420961093183821D-01, &
&    7.770840001822787D-34,  -1.257927232374436D-31,   9.707079348604243D-30, &
&   -4.752221778558668D-28,   1.657150844613421D-26,  -4.381014848138612D-25, &
&    9.125327669641758D-24,  -1.536443790004396D-22,   2.128805172784359D-21, &
&   -2.458311173904062D-20,   2.387698627676994D-19,  -1.963127488722117D-18, &
&    1.372144166403217D-17,  -8.173640270158402D-17,   4.153352244388892D-16, &
&   -1.799381665966420D-15,   6.633593391281810D-15,  -2.073980189782835D-14, &
&    5.471935124343424D-14,  -1.210177925865517D-13,   2.224326158330381D-13, &
&   -3.369682128352213D-13,   4.396208686397344D-13,  -1.080820752742675D-12, &
&    1.578565104200250D-11,  -3.391435687040948D-10,   7.115966977473990D-09, &
&   -1.423458711921985D-07,   2.689692499416973D-06,  -4.738111167744509D-05, &
&    7.615287000676058D-04,  -1.081206887003625D-02,   1.491729864726037D-01, &
&   -2.612696647667881D-34,   4.229582374245144D-32,  -3.264031149670965D-30, &
&    1.598046401970569D-28,  -5.572953578397619D-27,   1.473442297165837D-25, &
&   -3.069353759019276D-24,   5.168459740011255D-23,  -7.161983671562502D-22, &
&    8.271713178293916D-21,  -8.035430816442288D-20,   6.607862954469947D-19, &
&   -4.619653939273075D-18,   2.752579509705947D-17,  -1.399134031813552D-16, &
&    6.063828583720637D-16,  -2.236502817787644D-15,   6.996253606650130D-15, &
&   -1.847133096110791D-14,   4.088573227422592D-14,  -7.521512697537498D-14, &
&    1.137178103166254D-13,  -1.390938837320634D-13,   1.282223216610004D-13, &
&    1.341901772199451D-13,  -7.188515340702471D-12,   2.177072972832725D-10, &
&   -6.426753788657037D-09,   1.863822769424553D-07,  -5.332783746915249D-06, &
&    1.527321070401425D-04,  -4.554806907883691D-03,   1.527533871307259D-01, &
&   -2.641489733304174D-46,  -2.092977655002460D-45,   3.569854155172410D-43, &
&   -3.473250525177485D-42,  -2.530711904526145D-41,  -1.713879051443293D-39, &
&    8.201028745868777D-38,  -1.775443270498181D-36,   4.119084728516156D-35, &
&   -1.100238897267168D-33,   2.734674682277843D-32,  -6.315088453612780D-31, &
&    1.401227431533555D-29,  -2.981668761622712D-28,   6.038962492312901D-27, &
&   -1.161179835579759D-25,   2.115073450811274D-24,  -3.637951873127797D-23, &
&    5.887052386657699D-22,  -8.926282570899693D-21,   1.262229232178987D-19, &
&   -1.655515376628711D-18,   2.001123028509046D-17,  -2.212300102391296D-16, &
&    2.216262958557785D-15,  -1.988935570682515D-14,   1.575798679201014D-13, &
&   -1.081233438678924D-12,   6.257642629523049D-12,  -2.939212238757816D-11, &
&    1.053546599269377D-10,  -2.572326231600186D-10,   3.228492113350677D-10, &
&    4.368568931364518D-46,  -7.424617681195679D-45,  -1.082798472732495D-43, &
&   -2.085351855574709D-42,   1.935280633657168D-40,  -3.924027496195513D-39, &
&    8.561765350598323D-38,  -2.782184062404212D-36,   7.947863766699741D-35, &
&   -2.024070732433597D-33,   5.046356297922987D-32,  -1.224738310248700D-30, &
&    2.845291957235389D-29,  -6.323909310983144D-28,   1.344824805821475D-26, &
&   -2.729982982163834D-25,   5.276468516678808D-24,  -9.684634921236478D-23, &
&    1.683061968804616D-21,  -2.760103172825883D-20,   4.254730535500928D-19, &
&   -6.137350502385285D-18,   8.240311950819039D-17,  -1.023288436624958D-15, &
&    1.166210644165640D-14,  -1.208044481201270D-13,   1.123406709921807D-12, &
&   -9.225775850761187D-12,   6.539912831667619D-11,  -3.869014914806460D-10, &
&    1.808793342542674D-09,  -6.030276879684519D-09,   1.107195881562370D-08, &
&    2.733282137330006D-46,  -4.923424331622424D-45,  -5.247867476660172D-44, &
&   -1.745710975247986D-42,   1.357210007009492D-40,  -3.035321746344532D-39, &
&    7.428382339997397D-38,  -2.419087230468614D-36,   7.119799627774781D-35, &
&   -1.922772372146817D-33,   5.080537277709981D-32,  -1.306214388049955D-30, &
&    3.233155380267435D-29,  -7.700964659819986D-28,   1.764354709926961D-26, &
&   -3.881106522243024D-25,   8.180592736563557D-24,  -1.648759962677992D-22, &
&    3.169802338489343D-21,  -5.797123086379722D-20,   1.005347307136790D-18, &
&   -1.647125556823190D-17,   2.538217049659662D-16,  -3.659449068193928D-15, &
&    4.904088542692047D-14,  -6.059122394431345D-13,   6.829615186378708D-12, &
&   -6.924986341349384D-11,   6.193920509292647D-10,  -4.746459256961727D-09, &
&    2.972745752624264D-08,  -1.389521868818985D-07,   3.912911458310123D-07, &
&    1.038569702511058D-46,  -1.904265398339251D-45,  -1.673515273949548D-44, &
&   -8.281756907842843D-43,   5.845297942330567D-41,  -1.426821081139454D-39, &
&    3.866095506871077D-38,  -1.296679111951503D-36,   4.004856801600269D-35, &
&   -1.158776908188611D-33,   3.283650993855496D-32,  -9.068200565021519D-31, &
&    2.424291852535911D-29,  -6.271162543097116D-28,   1.568642896855518D-26, &
&   -3.788607949702426D-25,   8.820971648518952D-24,  -1.976403230654836D-22, &
&    4.252911384584582D-21,  -8.768937244311534D-20,   1.727803998326409D-18, &
&   -3.243067896604488D-17,   5.777078025587658D-16,  -9.722536097294465D-15, &
&    1.537237016389641D-13,  -2.267580880941669D-12,   3.092356328753316D-11, &
&   -3.851934496755577D-10,   4.309336685422063D-09,  -4.221646841959663D-08, &
&    3.481226788644251D-07,  -2.223690669406722D-06,   9.543196306413129D-06, &
&    1.845960310213142D-47,  -4.081813248769382D-46,   7.536930053978300D-46, &
&   -2.513031613423736D-43,   1.395347483216783D-41,  -4.037445424901299D-40, &
&    1.257631546070297D-38,  -4.322091131783416D-37,   1.408752450415466D-35, &
&   -4.410108438462868D-34,   1.351878283110642D-32,  -4.043408449834734D-31, &
&    1.177091732389866D-29,  -3.332176804225092D-28,   9.165403368165068D-27, &
&   -2.446882644497237D-25,   6.331151107291220D-24,  -1.585504590156047D-22, &
&    3.835994565584555D-21,  -8.949436090288441D-20,   2.008843839986826D-18, &
&   -4.325791959360171D-17,   8.909885292437135D-16,  -1.748331534631021D-14, &
&    3.252058644342613D-13,  -5.702136211718801D-12,   9.347381355363776D-11, &
&   -1.418041609031301D-09,   1.962553321826236D-08,  -2.423526967004969D-07, &
&    2.588435476824854D-06,  -2.200441776974701D-05,   1.435924492362879D-04, &
&    3.789998875025950D-48,  -6.773138182049321D-47,  -8.190282780540345D-46, &
&   -2.714294933396609D-44,   2.527810608416690D-42,  -7.143975417121051D-41, &
&    2.225935062909829D-39,  -8.506903225286536D-38,   2.960258554564445D-36, &
&   -1.006772917652114D-34,   3.368650424711595D-33,  -1.092518317828512D-31, &
&    3.496103889682540D-30,  -1.089272453446618D-28,   3.309518218630058D-27, &
&   -9.821410889625621D-26,   2.835706451929158D-24,  -7.974890610470101D-23, &
&    2.175485205344452D-21,  -5.759324693486182D-20,   1.477220345815459D-18, &
&   -3.651531413075356D-17,   8.706064597683078D-16,  -1.992575156700475D-14, &
&    4.353336525669527D-13,  -9.061117887045665D-12,   1.780125143612919D-10, &
&   -3.275384494966073D-09,   5.579345986376391D-08,  -8.627027572253426D-07, &
&    1.183715953588435D-05,  -1.316495659016247D-04,   1.320806052695112D-03, &
&    5.269162100580572D-49,  -1.984824683058222D-47,  -3.990948313612748D-46, &
&    1.594030355041217D-44,   6.291305325886435D-43,  -9.102863295638026D-42, &
&    4.578952531638778D-41,  -1.301467449217611D-38,   2.701484642505058D-37, &
&   -1.231529349945840D-35,   5.189700164783291D-34,  -1.517760881016342D-32, &
&    5.906085618286906D-31,  -2.037345626163040D-29,   6.746807457512144D-28, &
&   -2.259725888921896D-26,   7.280160144992803D-25,  -2.341326088883510D-23, &
&    7.160111135389113D-22,  -2.162975244203970D-20,   6.430090949535082D-19, &
&   -1.816755884075993D-17,   5.049453828044649D-16,  -1.357335027633847D-14, &
&    3.483235895950035D-13,  -8.656133394079887D-12,   2.043763368030810D-10, &
&   -4.572676810477283D-09,   9.617098192740232D-08,  -1.866961067691846D-06, &
&    3.288831931194123D-05,  -4.783240258949157D-04,   7.552999324518401D-03, &
&    5.915729209007164D-49,  -4.309325040239452D-47,  -5.250612455108542D-46, &
&    4.110600630511897D-44,   7.162486268867991D-43,  -4.999863350672859D-42, &
&   -2.670560486401318D-40,  -8.665662718268566D-39,  -1.438704466771287D-37, &
&   -2.487300250842133D-37,   1.435983646923573D-34,   1.428417876730476D-33, &
&    6.137042542455187D-32,  -2.378119799409161D-30,   6.155827419969523D-29, &
&   -2.621434125129234D-27,   8.879199408811883D-26,  -3.913476589606504D-24, &
&    1.177774918010681D-22,  -4.132186052472592D-21,   1.557467995453236D-19, &
&   -4.764715145838970D-18,   1.584975018645509D-16,  -5.129494414482022D-15, &
&    1.540326397357306D-13,  -4.654261379254884D-12,   1.335244434042107D-10, &
&   -3.676222709665584D-09,   9.678552920048060D-08,  -2.389688170209692D-06, &
&    5.443841452668531D-05,  -1.073042105870505D-03,   2.739336700455004D-02, &
&   -8.500424939898197D-48,   2.994957781618612D-47,   6.519399652800241D-45, &
&   -2.227348667659083D-44,  -2.181136640581992D-42,   1.012744718456863D-41, &
&    4.532877151968161D-40,  -3.652263653967904D-39,  -1.058374937634228D-37, &
&    2.262052006531501D-37,   2.768604447225736D-35,   3.919757689054092D-34, &
&    1.487066030247239D-33,  -1.687639561690809D-31,   3.404381000658743D-30, &
&   -6.807859964558498D-29,   3.609407815925721D-27,  -3.187084363965043D-25, &
&    7.858255107503797D-24,  -3.289422818221744D-22,   1.645170433312103D-20, &
&   -5.782502428911043D-19,   2.288755596010185D-17,  -9.022465494103624D-16, &
&    3.340013392655224D-14,  -1.236689232692148D-12,   4.447694561017113D-11, &
&   -1.552898061947830D-09,   5.246123337881909D-08,  -1.695497919462877D-06, &
&    5.194430446423766D-05,  -1.559318726678848D-03,   6.405987757702944D-02, &
&    8.470919930357440D-48,   3.212409015589843D-47,  -6.380898476275083D-45, &
&   -4.146300252478123D-44,   1.270754091331838D-42,  -2.048638456801589D-42, &
&   -2.675852638029826D-41,   1.694117026627911D-38,   3.657115600367180D-37, &
&   -1.232971267335446D-36,  -2.124938474206778D-34,  -4.749375582039206D-33, &
&   -2.415996845620864D-32,   9.773021119284176D-31,   1.522578886393800D-29, &
&    1.371071641678855D-29,   1.390348986249370D-26,   7.670047823564966D-25, &
&    1.083972523507169D-23,  -3.273934260181101D-22,  -1.556723285256428D-20, &
&   -2.606205084085340D-19,   2.570588994141287D-18,   9.034927424793448D-17, &
&    5.251303182751030D-15,  -9.079522575988468D-14,   5.498118500368152D-12, &
&   -2.793257395765944D-10,   1.282352479392581D-08,  -6.362820514187468D-07, &
&    3.170454173138195D-05,  -1.687451296739068D-03,   9.768577653968411D-02, &
&    2.542488235426460D-50,  -3.394094973711908D-50,  -2.075516876521971D-47, &
&    3.334128793378197D-47,   7.677051759628300D-45,  -1.443955774914807D-44, &
&   -1.701472705737639D-42,   3.627023062978307D-42,   2.529728200109347D-40, &
&   -6.079936508664231D-40,  -2.639548539266213D-38,   5.989203338422792D-38, &
&    2.289600503090856D-36,  -9.179979803842335D-36,  -5.369663433756100D-35, &
&   -1.643217253093070D-33,   5.200633191370069D-32,  -8.398768139152017D-31, &
&    1.415077850126530D-29,  -2.774805826069448D-28,   5.166484074247763D-27, &
&   -8.390663776353579D-26,   1.262735185233135D-24,  -1.899898294557397D-23, &
&    2.790894934960753D-22,  -3.718968524922199D-21,   4.443070906660543D-20, &
&   -5.071580539291968D-19,   5.717272744064151D-18,  -5.786183776423414D-17, &
&    4.522781822174404D-16,  -2.629824880630818D-15,   4.034539052409824D-14, &
&    1.226145309200989D-50,   6.457992956427629D-49,  -1.474590751668347D-47, &
&   -6.469193697124381D-46,   8.946798750644511D-45,   3.122860986098716D-43, &
&   -3.716584360764367D-42,  -9.823654151586726D-41,   1.216121490003818D-39, &
&    2.284701980817408D-38,  -3.349788750463409D-37,  -4.321997391907680D-36, &
&    8.505390959271216D-35,   6.067065262940138D-34,  -1.798988006817991D-32, &
&   -1.030574503740545D-31,   4.839950089541909D-30,  -1.485029964413077D-29, &
&   -4.326723104115212D-28,  -7.559688812500469D-27,   3.747504559068273D-25, &
&   -5.213679235238892D-24,   5.714332299450184D-23,  -1.497795845648362D-21, &
&    3.870959427931209D-20,  -6.470821607113854D-19,   8.698753795263981D-18, &
&   -1.396435888465466D-16,   2.522695288609517D-15,  -3.599147683665455D-14, &
&    3.507746514172506D-13,  -2.720623030929154D-12,   7.419162294338373D-11, &
&    4.965694598055643D-49,   5.430202940889935D-47,  -6.550398037758309D-46, &
&   -5.689736234848299D-44,   4.519023525276927D-43,   2.897393733813563D-41, &
&   -2.175329791058933D-40,  -9.723727523066897D-39,   8.230651349693393D-38, &
&    2.469168063214701D-36,  -2.620616265690173D-35,  -5.158357949542324D-34, &
&    7.380159572047950D-33,   9.227377566274761D-32,  -1.885675908736698D-30, &
&   -1.447711754513497D-29,   4.625383966706435D-28,   1.475012711161705D-27, &
&   -9.852878685574118D-26,  -2.035564447566431D-25,   2.684344718704411D-23, &
&   -1.546403533172910D-22,  -2.431938869710349D-21,  -3.171277366755774D-20, &
&    2.308623018313637D-18,  -3.686635185173359D-17,   3.856342255952297D-16, &
&   -8.985401077088551D-15,   2.517432545181809D-13,  -4.389082954594444D-12, &
&    4.814552066713060D-11,  -4.705224872364003D-10,   1.783105792321132D-08, &
&   -3.115615782965778D-47,   1.794662814178673D-45,   2.272636499584887D-44, &
&   -1.915319745525192D-42,  -5.062530719479609D-42,   1.001404543677436D-39, &
&   -1.280360397570727D-39,  -3.490080713722616D-37,   1.416185440019726D-36, &
&    9.347743074651506D-35,  -6.431587084701112D-34,  -2.098938537525133D-32, &
&    2.180997611115093D-31,   4.153484277415837D-30,  -6.344289635552093D-29, &
&   -7.348707339655447D-28,   1.687290748001558D-26,   1.095498829568867D-25, &
&   -4.151741208832168D-24,  -1.270905151722699D-23,   1.028476650934565D-21, &
&   -1.598684177705790D-21,  -1.962910066049304D-19,   4.939196618382666D-20, &
&    7.050962397522201D-17,  -9.041967568863199D-16,   3.134331261958219D-15, &
&   -1.917370685117415D-13,   8.903055690280157D-12,  -1.786320187310122D-10, &
&    2.150920396425873D-09,  -2.650008331714376D-08,   1.262666584924197D-06, &
&   -1.048648178383840D-45,   2.592302238704390D-44,   8.899726122746229D-43, &
&   -2.810476654556781D-41,  -3.290041779937035D-40,   1.502476122188934D-38, &
&    5.858070031746019D-38,  -5.401518664381176D-36,   2.891223683944854D-36, &
&    1.508594067090108D-33,  -6.115461064308535D-33,  -3.573920517651769D-31, &
&    2.740008962949419D-30,   7.554429446834876D-29,  -9.130017466117018D-28, &
&   -1.446881931121579D-26,   2.650878562923804D-25,   2.439224534110758D-24, &
&   -7.054948937505057D-23,  -3.273164905586318D-22,   1.788273787375513D-20, &
&    7.865208730456700D-21,  -4.040890721638306D-18,   6.536598759676585D-18, &
&    1.112543312620675D-15,  -1.111730984619918D-14,  -6.348697337356541D-14, &
&   -1.495869171836200D-12,   1.383212584231928D-10,  -3.091687815374700D-09, &
&    4.096759727123323D-08,  -6.478893491639847D-07,   3.662270220138160D-05, &
&   -1.102008289350281D-44,   1.813205543807366D-43,   9.697834099891211D-42, &
&   -1.993279829840343D-40,  -3.895428217783862D-39,   1.086317674251671D-37, &
&    8.962032216829423D-37,  -4.008772484628658D-35,  -9.291531785605512D-35, &
&    1.158126417530287D-32,  -2.169183218429750D-32,  -2.858468419578281D-30, &
&    1.629050072537566D-29,   6.331764288335708D-28,  -6.313470362474927D-27, &
&   -1.277866757147490D-25,   1.990721592978907D-24,   2.299570055471434D-23, &
&   -5.618933061139645D-22,  -3.382991700246401D-21,   1.474559264717897D-19, &
&    2.342409741642286D-19,  -3.556320661202217D-17,   6.094531787832882D-17, &
&    8.932474829269961D-15,  -7.291674472946734D-14,  -1.074928656781273D-12, &
&   -3.001583051928523D-12,   1.051784726699384D-09,  -2.574667611092077D-08, &
&    3.853121313243004D-07,  -8.031995242584638D-06,   5.171944685179718D-04, &
&   -4.949994928834406D-44,   6.285381746243249D-43,   4.429675865937041D-41, &
&   -6.995047747654311D-40,  -1.843146366013090D-38,   3.876531706580785D-37, &
&    4.623583332560154D-36,  -1.462468212656322D-34,  -6.795825955507839D-34, &
&    4.342959374834375D-32,  -7.320944984043567D-33,  -1.106594282167781D-29, &
&    4.693917721803038D-29,   2.536937233448585D-27,  -2.157014486746441D-26, &
&   -5.308358844913814D-25,   7.332577438276372D-24,   9.948803144516884D-23, &
&   -2.169079422451170D-21,  -1.547148611243626D-20,   5.866828716204074D-19, &
&    1.373591006078620D-18,  -1.462603096374527D-16,   2.270598647491142D-16, &
&    3.557856518440798D-14,  -2.525689069193185D-13,  -5.540875232709679D-12, &
&    9.259786558539162D-12,   4.069632996515492D-09,  -1.090712196154397D-07, &
&    1.961713377819673D-06,  -5.545774632991560D-05,   3.940036603689441D-03, &
&   -9.104985168327316D-44,   9.493487885094794D-43,   8.232793119904197D-41, &
&   -1.068982876732438D-39,  -3.497991749107907D-38,   6.017343944654974D-37, &
&    9.193971920373961D-36,  -2.316080396653146D-34,  -1.551770714653131D-33, &
&    7.045742380323647D-32,   8.981922602578419D-32,  -1.843921100286432D-29, &
&    5.649213794154926D-29,   4.345461819280660D-27,  -3.204578482850127D-26, &
&   -9.346748326754736D-25,   1.171259353923055D-23,   1.803445694873117D-22, &
&   -3.608010636364463D-21,  -2.912265404529108D-20,   1.001354298162092D-18, &
&    2.908633394586681D-18,  -2.549251854468786D-16,   3.385167811124175D-16, &
&    6.154454026736596D-14,  -4.030324371557939D-13,  -1.049912420044452D-11, &
&    2.263218983155549D-11,   7.657548292718754D-09,  -2.340695180063528D-07, &
&    5.799651860196259D-06,  -2.263699723151946D-04,   1.726636022826519D-02, &
&   -1.203556800719131D-44,  -1.421914781672171D-44,   1.146313983852262D-41, &
&    5.734773418290208D-42,  -5.360569342228852D-39,   4.395605709597772D-39, &
&    1.686671439511217D-36,  -5.401753015656402D-36,  -4.113047869312808D-34, &
&    2.975544698168223D-33,   8.234879079863499D-32,  -1.156984590237279D-30, &
&   -1.284716028558252D-29,   3.624534482641141D-28,   9.354119561437898D-28, &
&   -9.682256290395688D-26,   3.532724098191049D-25,   2.241455811036582D-23, &
&   -2.221010114101680D-22,  -4.385599304782086D-21,   8.155601822168971D-20, &
&    6.371710140628289D-19,  -2.387634061314774D-17,  -3.780528723728834D-17, &
&    6.777129230896872D-15,  -6.043215120540895D-14,   4.074733611859676D-13, &
&   -8.038703182656055D-11,   5.008675106741860D-09,  -2.308265153025822D-07, &
&    1.075166987919927D-05,  -5.674334738722349D-04,   4.532970789320407D-02, &
&    1.646847310313629D-43,  -1.772760951815855D-42,  -1.486976798977916D-40, &
&    1.992158452111951D-39,   6.300097984302200D-38,  -1.118470377675901D-36, &
&   -1.645750793518156D-35,   4.291046834074573D-34,   2.731182387624303D-33, &
&   -1.300483918963584D-31,  -1.363699677880650D-31,   3.389950450782850D-29, &
&   -1.098400712869860D-28,  -7.957826137459966D-27,   5.997260568876755D-26, &
&    1.705327149070768D-24,  -2.167113658525130D-23,  -3.278119460941532D-22, &
&    6.636664669494253D-21,   5.267060773461956D-20,  -1.834641360858983D-18, &
&   -5.215931842949764D-18,   4.672191787378861D-16,  -6.944096979536382D-16, &
&   -1.098192284415964D-13,   6.218569813144570D-13,   2.448474208412754D-11, &
&   -2.835628082249005D-10,  -2.968178441526736D-09,  -8.121435534374649D-08, &
&    1.390023114562682D-05,  -8.935917046862017D-04,   7.303357794219535D-02, &
&   -1.877709141255526D-50,  -8.726885285418860D-50,   1.372194212379325D-47, &
&    6.798086106059647D-47,  -4.471454468356826D-45,  -2.388339723990559D-44, &
&    8.546595832733480D-43,   4.999069171183828D-42,  -1.058705533524921D-40, &
&   -6.936457639342431D-40,   8.834187246995834D-39,   6.716217654449850D-38, &
&   -4.958471176274079D-37,  -4.651052026879675D-36,   1.766687068006910D-35, &
&    2.322036415763613D-34,  -3.066208085256652D-34,  -8.307808279343621D-33, &
&   -3.588983595305834D-33,   2.083320222256458D-31,   4.397998756810770D-31, &
&   -6.944114661464146D-30,   8.036337853107330D-29,  -1.879283356417276D-27, &
&    3.440712343693005D-26,  -5.162828194621382D-25,   6.596090898390061D-24, &
&   -7.625317890994780D-23,   1.172147878129406D-21,  -4.534725809846304D-20, &
&    3.015912258767038D-18,  -2.399007971118962D-16,   2.878143522774653D-14, &
&    1.166216181405732D-50,  -1.980981348425281D-50,  -9.313481334519067D-48, &
&    1.625124494824847D-47,   3.362293993029767D-45,  -5.990961274811086D-45, &
&   -7.253142373414472D-43,   1.311149928862321D-42,   1.041182284851574D-40, &
&   -1.895173074121205D-40,  -1.048213372748431D-38,   1.902674823455071D-38, &
&    7.605100241009384D-37,  -1.374646908907727D-36,  -3.998559533322332D-35, &
&    7.345054987900982D-35,   1.321826477652084D-33,   3.840148534326021D-33, &
&   -1.571702145121408D-31,   4.519584234634820D-31,   6.217453777233360D-29, &
&   -2.862164279095619D-27,   8.381288574771215D-26,  -1.899917920828571D-24, &
&    3.524692051574795D-23,  -5.465721159688936D-22,   7.236177799434105D-21, &
&   -9.162524569120783D-20,   1.827031463360118D-18,  -8.634754111424700D-17, &
&    5.936515693092412D-15,  -4.733584218782870D-13,   5.679534897636713D-11, &
&   -8.562032714291591D-52,   8.065498537706027D-52,   6.881212375270942D-49, &
&   -6.076152715642602D-49,  -2.498480589900182D-46,   2.033431752936123D-46, &
&    5.413878470812318D-44,  -3.465988400661841D-44,  -7.986424790920174D-42, &
&    6.726493108386439D-42,   8.320643358210208D-40,  -2.867929526557560D-39, &
&    2.076941583221017D-38,  -1.730369555926040D-36,   2.229496365556729D-35, &
&    4.333247219893869D-34,  -3.156326698784244D-32,   9.988490742476272D-31, &
&   -1.971057495206270D-29,   1.420438129953656D-28,   7.108868052466679D-27, &
&   -3.881375249611483D-25,   1.194581136649668D-23,  -2.780775095054468D-22, &
&    5.254577628587944D-21,  -8.285361932488589D-20,   1.128722440355705D-18, &
&   -1.575712836422255D-17,   3.931567418895375D-16,  -2.093606456907748D-14, &
&    1.463717454565805D-12,  -1.168526437300394D-10,   1.402111125379066D-08, &
&    8.919905153658491D-52,   1.122632365427251D-50,  -7.120185504010304D-49, &
&   -9.419469152576624D-48,   2.739598217185125D-46,   3.297459401331229D-45, &
&   -6.758569367886340D-44,  -4.276983683483012D-43,   3.648591467471242D-42, &
&    1.551986266107725D-40,   1.876261425630570D-40,  -1.058023090056749D-37, &
&    3.526731864680753D-36,  -7.946484228567185D-35,   9.424216679434452D-34, &
&    1.704014246086210D-32,  -1.383480677102177D-30,   4.568471682331289D-29, &
&   -9.443899112798782D-28,   8.393610419523425D-27,   2.701699695191220D-25, &
&   -1.652440600793378D-23,   5.243797277052295D-22,  -1.240643305495817D-20, &
&    2.372066065736012D-19,  -3.790194259843515D-18,   5.334689822205255D-17, &
&   -8.386797973423848D-16,   2.574259950236073D-14,  -1.487470964509422D-12, &
&    1.050757496791328D-10,  -8.394688863805228D-09,   1.007306456282955D-06, &
&   -8.706812361527577D-51,  -7.707818557748365D-50,   7.294998003595247D-48, &
&    4.945862823689614D-47,  -2.488797560138741D-45,  -1.816378810953291D-44, &
&    4.357597313073264D-43,   8.370766313235949D-42,  -1.765634172471240D-40, &
&    5.982731838155717D-40,   2.552046163751430D-38,  -1.605848435556055D-36, &
&    6.068655415921146D-35,  -1.461915562219388D-33,   1.817737471156817D-32, &
&    2.793461262121169D-31,  -2.467850357361150D-29,   8.355300383828528D-28, &
&   -1.775550323172209D-26,   1.746404080845999D-25,   4.343552212879387D-24, &
&   -2.893714254654144D-22,   9.375464202073770D-21,  -2.242886157320710D-19, &
&    4.327088951991109D-18,  -7.011445229815223D-17,   1.032340167974553D-15, &
&   -1.890474997309600D-14,   7.048911823532159D-13,  -4.320637122248209D-11, &
&    3.073414366708899D-09,  -2.456620880961228D-07,   2.947840506164939D-05, &
&    2.867123919860597D-50,   1.977511648005116D-49,  -2.132577503448334D-47, &
&   -2.348036885427466D-46,   9.394591434815755D-45,   7.411054188434883D-44, &
&   -2.952826801223498D-42,   2.120137147630317D-41,  -4.836211312551315D-40, &
&    1.189625617313678D-38,   9.327786580090271D-38,  -1.356525198916306D-35, &
&    5.073319029881501D-34,  -1.219927612310896D-32,   1.570114651628103D-31, &
&    2.156126990037305D-30,  -2.036979221379289D-28,   7.017794237889858D-27, &
&   -1.518403032814162D-25,   1.584167210429761D-24,   3.321475920590743D-23, &
&   -2.362269924385143D-21,   7.767886221248135D-20,  -1.873888134814338D-18, &
&    3.646458379665973D-17,  -6.024854721179999D-16,   9.529935889449664D-15, &
&   -2.134890970643861D-13,   9.538102369970364D-12,  -6.105964003700062D-10, &
&    4.364517254604972D-08,  -3.489819644252995D-06,   4.187694563519818D-04, &
&   -4.420848596166035D-50,   3.979939242516558D-49,   4.151708011109416D-47, &
&   -6.309614478729676D-46,  -8.690945882591363D-45,   1.894225371092746D-43, &
&   -1.518843482321162D-42,   1.021063319482249D-40,  -3.384478898573713D-39, &
&    4.545299667925313D-38,   4.796133424447952D-37,  -5.259626483600777D-35, &
&    1.995046495169125D-33,  -4.884824889946594D-32,   6.437290241906472D-31, &
&    8.118645907783080D-30,  -8.068477384149333D-28,   2.814132338054192D-26, &
&   -6.164486380958719D-25,   6.677968230418289D-24,   1.242629166501953D-22, &
&   -9.292883006163253D-21,   3.090121703577614D-19,  -7.510846050009887D-18, &
&    1.478898130046961D-16,  -2.534003944480675D-15,   4.569692505618991D-14, &
&   -1.340120188612444D-12,   7.041668122078655D-11,  -4.653162724653856D-09, &
&    3.337429727376033D-07,  -2.669217520305405D-05,   3.203024954570580D-03, &
&   -1.851593821355989D-49,  -1.340210396944177D-48,   1.604297777985142D-46, &
&    5.223835884103527D-46,  -4.819294768943315D-44,  -2.449028141579028D-43, &
&    4.994141799596868D-42,   2.887071252232755D-40,  -6.825179943358035D-39, &
&    6.194121915005912D-38,   8.720295854974424D-37,  -8.652933463999229D-35, &
&    3.374209062435613D-33,  -8.370177907806722D-32,   1.121297471950461D-30, &
&    1.321815517867383D-29,  -1.369285821950138D-27,   4.821776024227608D-26, &
&   -1.066139505719069D-24,   1.186267473139520D-23,   2.017481719550511D-22, &
&   -1.572174068148848D-20,   5.283043556567432D-19,  -1.299063653329520D-17, &
&    2.633872836162453D-16,  -4.991348730529146D-15,   1.199876439784036D-13, &
&   -5.016106097567058D-12,   3.018330406958305D-10,  -2.039483024742413D-08, &
&    1.466211345367439D-06,  -1.172843662597146D-04,   1.407406161078131D-02, &
&    2.179266019949841D-49,   1.644803129863550D-48,  -1.752744304825172D-46, &
&   -1.311804403215435D-45,   6.485164557836280D-44,   4.547011085388480D-43, &
&   -1.453506999277425D-41,  -8.017413513400515D-41,   1.692311658954619D-39, &
&    1.966251640043283D-38,  -2.019086075292760D-37,  -7.158715898540670D-36, &
&    2.731185611624353D-34,  -6.822636002718863D-33,   1.059699696237547D-31, &
&    5.835510814669651D-31,  -1.045515753990062D-28,   4.021753484701489D-27, &
&   -9.585125980007737D-26,   1.265920154668511D-24,   1.085110107031005D-23, &
&   -1.304181132711390D-21,   5.194032533984407D-20,  -1.719353967859817D-18, &
&    6.389690603065685D-17,  -3.104130194328741D-15,   1.834210023990573D-13, &
&   -1.176174845485621D-11,   7.812812519628397D-10,  -5.354698638726614D-08, &
&    3.855186343371735D-06,  -3.084137857670190D-04,   3.700964867661079D-02, &
&   -2.564140353544413D-51,  -8.327044804367642D-49,  -1.737517514098796D-47, &
&    1.614256100184751D-45,  -1.318837796087063D-44,  -4.583218966348278D-43, &
&    1.322264628515905D-41,  -3.397844795952519D-40,   9.234615415359626D-39, &
&   -1.397135906489379D-37,  -1.274864874982493D-36,   1.615639836872514D-34, &
&   -6.213513040138940D-33,   1.531125775750211D-31,  -2.047022098797363D-30, &
&   -2.438247823267603D-29,   2.511045206172805D-27,  -8.831600454516575D-26, &
&    1.951181308492415D-24,  -2.170966981045395D-23,  -3.662262269604118D-22, &
&    2.845696487834610D-20,  -9.435083661078590D-19,   2.222606469604396D-17, &
&   -3.824384177755736D-16,   2.744692126966100D-15,   1.934670527127886D-13, &
&   -1.785753650225024D-11,   1.250117202913815D-09,  -8.627546763370150D-08, &
&    6.215888800784124D-06,  -4.972940465891834D-04,   5.967539962020314D-02, &
&    3.632457368042714D-50,   4.504957426806293D-50,  -2.873426470856876D-47, &
&   -3.456768077025424D-47,   1.029691999665568D-44,   1.200346787754130D-44, &
&   -2.210594449687073D-42,  -2.494681694289478D-42,   3.168163718634614D-40, &
&    3.457855996811511D-40,  -3.196868531505640D-38,  -3.370992882904487D-38, &
&    2.334050118667517D-36,   2.374379047163897D-36,  -1.247520522044640D-34, &
&   -1.221406266378384D-34,   4.882519658192024D-33,   4.580765716826371D-33, &
&   -1.385364340420706D-31,  -1.235274369114701D-31,   2.790800345077692D-30, &
&    2.328114508302197D-30,  -3.855726459656633D-29,  -2.924389884491734D-29, &
&    3.491501713113708D-28,  -2.636417699111293D-29,   1.961126125162256D-26, &
&   -1.872976051279280D-24,   1.664008926983912D-22,  -1.521324697037116D-20, &
&    1.460471420862101D-18,  -1.557836169286236D-16,   2.492537870017438D-14, &
&    3.409685541287273D-51,  -3.578424534955740D-50,  -2.833880485953646D-48, &
&    2.841113976485523D-47,   1.061872171980899D-45,  -1.020540831662172D-44, &
&   -2.372704857570526D-43,   2.192222652075173D-42,   3.523779333125160D-41, &
&   -3.136129662677211D-40,  -3.670116000729608D-39,   3.149031577393115D-38, &
&    2.757018991925070D-37,  -2.278951072957053D-36,  -1.513372314399500D-35, &
&    1.201589439884324D-34,   6.085416373376031D-34,  -4.612541017607394D-33, &
&   -1.780738356430520D-32,   1.273078832979823D-31,   3.773886182084191D-31, &
&   -2.543897936100139D-30,  -3.836853606456239D-30,  -4.782410365262825D-29, &
&    5.975876404578840D-27,  -4.934292591432054D-25,   4.234468182567905D-23, &
&   -3.694121007453223D-21,   3.283538855389064D-19,  -3.002083562544971D-17, &
&    2.881999686268880D-15,  -3.074132974054250D-13,   4.918612757470703D-11, &
&   -1.992176054389662D-52,  -6.746710086645199D-51,   1.707836498398334D-49, &
&    5.205943073642975D-48,  -6.630393142720949D-47,  -1.815220310773482D-45, &
&    1.541993263790539D-44,   3.781262550933359D-43,  -2.394429142412964D-42, &
&   -5.241791993196087D-41,   2.619386705640551D-40,   5.098209746564978D-39, &
&   -2.075665334034870D-38,  -3.574363785574693D-37,   1.208897639501634D-36, &
&    1.819550056935580D-35,  -4.977302205158295D-35,  -7.263097545480572D-34, &
&    2.721312344462549D-33,  -6.234168215841302D-33,   4.702788428448434D-31, &
&   -1.131627736600463D-29,   3.394904766460060D-28,  -1.881155436192866D-26, &
&    1.447718612285188D-24,  -1.215868835332795D-22,   1.045221194755891D-20, &
&   -9.119585348440447D-19,   8.106093788396453D-17,  -7.411270911668684D-15, &
&    7.114819202858176D-13,  -7.589140442678336D-11,   1.214262470661683D-08, &
&    1.115030440073773D-51,  -8.378037661679935D-51,  -8.674230053450134D-49, &
&    6.478706224766043D-48,   3.050437403183204D-46,  -2.256269688510189D-45, &
&   -6.409948967809627D-44,   4.675576380257564D-43,   8.962227623462915D-42, &
&   -6.417564600889526D-41,  -8.785092718184808D-40,   6.144933245124975D-39, &
&    6.203365048384047D-38,  -4.242797057542321D-37,  -3.083712518689432D-36, &
&    1.803428472067795D-35,   2.011185736482426D-34,  -2.925314893539277D-33, &
&    4.893843728496959D-32,  -1.134023535281488D-30,   2.452964560627795D-29, &
&   -5.756222051472063D-28,   2.090294654968389D-26,  -1.301744142903837D-24, &
&    1.033614348070592D-22,  -8.727720806856482D-21,   7.508371945619666D-19, &
&   -6.551646319712358D-17,   5.823588346663541D-15,  -5.324416555684005D-13, &
&    5.111439476856621D-11,  -5.452202089340810D-09,   8.723523342146318D-07, &
&   -3.215767906748963D-51,   5.595727630363320D-50,   2.404976530629123D-48, &
&   -4.338888808152327D-47,  -8.081670410267570D-46,   1.515842865458187D-44, &
&    1.609943028157824D-43,  -3.152761005463850D-42,  -2.111038901979869D-41, &
&    4.345781420530259D-40,   1.911321255635001D-39,  -4.185273430578919D-38, &
&   -1.203508779535538D-37,   2.837031261690772D-36,   7.104365978911774D-36, &
&   -1.977801940798778D-34,   1.376097998631745D-33,  -3.515603267584290D-32, &
&    9.753427258063309D-31,  -2.191057705213143D-29,   4.789769129984077D-28, &
&   -1.256891922003846D-26,   5.424851777731300D-25,  -3.708595684444225D-23, &
&    3.011750729069335D-21,  -2.552641579581879D-19,   2.197147356031630D-17, &
&   -1.917300270121394D-15,   1.704248546426072D-13,  -1.558168762575419D-11, &
&    1.495841933268925D-09,  -1.595564725164659D-07,   2.552903560112033D-05, &
&   -1.667028546335666D-50,  -1.132963046604028D-49,   1.376175136397613D-47, &
&    8.802454884293843D-47,  -5.147535217995859D-45,  -3.080064655304142D-44, &
&    1.154052477754308D-42,   6.411989309146085D-42,  -1.728703887269283D-40, &
&   -8.837546387740267D-40,   1.825953038602311D-38,   8.470232739461952D-38, &
&   -1.387458727130693D-36,  -6.242762709534957D-36,   9.285084035607428D-35, &
&   -1.637986703513431D-34,   9.818530811686782D-33,  -3.541957059488796D-31, &
&    8.427522118731627D-30,  -1.895575733503239D-28,   4.428629732937382D-27, &
&   -1.357832743053117D-25,   7.009291904105325D-24,  -5.166542966093480D-22, &
&    4.265251815096441D-20,  -3.624765370428035D-18,   3.121112935711921D-16, &
&   -2.723699742885127D-14,   2.421050642831076D-12,  -2.213530865160604D-10, &
&    2.124989562654879D-08,  -2.266655530346585D-06,   3.626648848423885D-04, &
&    8.139416020835983D-50,  -2.997619418110838D-49,  -6.459600103903181D-47, &
&    2.328130866974111D-46,   2.320882036801345D-44,  -8.159555413922456D-44, &
&   -4.992498655403520D-42,   1.706073266546990D-41,   7.164679420126470D-40, &
&   -2.370599657714570D-39,  -7.233441605695606D-38,   2.299407130688421D-37, &
&    5.323642679013041D-36,  -1.781377287726625D-35,  -2.246308065517813D-34, &
&   -1.003647028581488D-33,   6.389381240788059D-32,  -1.427965403909691D-30, &
&    3.389355829618969D-29,  -8.061507861333586D-28,   2.105496568769314D-26, &
&   -8.064831034006095D-25,   4.982425480303275D-23,  -3.896281165828528D-21, &
&    3.255133049628509D-19,  -2.771634913723609D-17,   2.387151585923982D-15, &
&   -2.083258578926182D-13,   1.851778953746904D-11,  -1.693054573099615D-09, &
&    1.625332362418354D-07,  -1.733687851957045D-05,   2.773900563077807D-03, &
&   -1.098600561510299D-49,   1.102086628560639D-48,   8.465963567187850D-47, &
&   -8.541283225968597D-46,  -2.945050024120348D-44,   2.983127959719218D-43, &
&    6.111451417099733D-42,  -6.204436446165130D-41,  -8.421469623239525D-40, &
&    8.555519808236813D-39,   8.117386525180563D-38,  -8.256874013453198D-37, &
&   -5.538187575171700D-36,   5.415522631152503D-35,   3.794521777618312D-34, &
&   -6.011424060616057D-33,   8.143886842621335D-32,  -2.339224037951351D-30, &
&    6.189794850850080D-29,  -1.607218287748761D-27,   5.376480139054730D-26, &
&   -2.842759595021036D-24,   2.074749177716841D-22,  -1.695237400791907D-20, &
&    1.428115707933204D-18,  -1.217603487593631D-16,   1.048887434230984D-14, &
&   -9.153798590427908D-13,   8.136698643551483D-11,  -7.439266513075940D-09, &
&    7.141695804245425D-07,  -7.617808855617181D-05,   1.218849416889436D-02, &
&    6.444644053281829D-50,  -1.149648468583391D-48,  -4.758577430121796D-47, &
&    8.886419542084434D-46,   1.574224287412758D-44,  -3.092485964588005D-43, &
&   -3.074071510024865D-42,   6.400822861827134D-41,   3.924826604345250D-40, &
&   -8.769692224303809D-39,  -3.420626954160168D-38,   8.375713302123880D-37, &
&    2.058807122035431D-36,  -5.748449093984592D-35,  -7.375373632768882D-35, &
&    2.532595006445446D-33,   1.163853750978498D-32,  -4.464262843534733D-31, &
&    1.606059833263162D-29,  -1.015539492716803D-27,   7.747817930445033D-26, &
&   -6.317573333669580D-24,   5.266406560677267D-22,  -4.430070100319494D-20, &
&    3.751800707637639D-18,  -3.201438091429353D-16,   2.758150344880795D-14, &
&   -2.407111821920829D-12,   2.139654846802805D-10,  -1.956255852171123D-08, &
&    1.878005617624347D-06,  -2.003205992111196D-04,   3.205129587377021D-02, &
&   -1.504168895833524D-50,   4.328991613433541D-49,   1.053989357980700D-47, &
&   -3.340593390386261D-46,  -3.257791841641282D-45,   1.159807904933629D-43, &
&    5.791628657412524D-43,  -2.392967765380251D-41,  -6.410552238236722D-41, &
&    3.264445206886344D-39,   4.303176206765523D-39,  -3.072693153201246D-37, &
&   -2.686760434545678D-37,   2.613409973892790D-35,  -1.842759123637959D-34, &
&    4.705878052932951D-33,  -1.631544092824745D-31,   4.201375504990774D-30, &
&   -8.764526831647628D-29,   8.482322590374126D-28,   7.516737272125332D-26, &
&   -9.284405333790965D-24,   8.344054323656856D-22,  -7.121501746013868D-20, &
&    6.046682707571763D-18,  -5.161765026576313D-16,   4.447287234789395D-14, &
&   -3.881292275953141D-12,   3.450039628382196D-10,  -3.154322095482715D-08, &
&    3.028149220491864D-06,  -3.230025835601515D-04,   5.168041336979441D-02/
end


!-------------------
  module rysgrid11
!-------------------
!
! Chebyshev interpolation grids of Rys quadrature
!
      real(8) :: t11(33,11,0:4)
      real(8) :: w11(33,11,0:4)
      data t11 / &
&   -7.785673016611114D-31,   1.265254656609797D-28,  -9.806624279651230D-27, &
&    4.824822484475535D-25,  -1.691927020179158D-23,   4.501455272672765D-22, &
&   -9.444066347592696D-21,   1.603217872256997D-19,  -2.242231813398951D-18, &
&    2.617205156999081D-17,  -2.573507297173831D-16,   2.146100387617041D-15, &
&   -1.524809668412904D-14,   9.257321729799149D-14,  -4.809328741725312D-13, &
&    2.138267737664101D-12,  -8.126836565272978D-12,   2.634051477743272D-11, &
&   -7.253859556119594D-11,   1.688673536635807D-10,  -3.301087836878188D-10, &
&    5.372849174763565D-10,  -7.203113547489355D-10,   7.847353448815503D-10, &
&   -6.829119884798247D-10,   4.642366178462808D-10,  -2.465968861961915D-10, &
&   -2.075794117537761D-10,  -1.218838636160322D-08,  -4.644286833941981D-07, &
&   -1.628841992404498D-05,  -4.999472038297525D-04,   9.886217227196161D-01, &
&    1.819300836779234D-30,  -2.957055832816420D-28,   2.292354906843414D-26, &
&   -1.128061415637997D-24,   3.956684203941614D-23,  -1.052958786880332D-21, &
&    2.209721884067683D-20,  -3.752356412872672D-19,   5.249757816501923D-18, &
&   -6.129988744509023D-17,   6.030151918727507D-16,  -5.030992781445923D-15, &
&    3.576368904983757D-14,  -2.172500256520069D-13,   1.129365240555212D-12, &
&   -5.024794904852860D-12,   1.911253787002644D-11,  -6.200113315465778D-11, &
&    1.709089712701458D-10,  -3.982973754120520D-10,   7.795323670328990D-10, &
&   -1.270425608693033D-09,   1.705634518760630D-09,  -1.861068229835450D-09, &
&    1.622273872083876D-09,  -1.104787240351505D-09,   5.730532604351890D-10, &
&   -6.074875773589776D-10,  -3.209913668000900D-08,  -1.716460563204074D-06, &
&   -7.254122615110103D-05,  -2.466830214878669D-03,   9.410173694607201D-01, &
&   -1.698249971487059D-30,   2.761264114907125D-28,  -2.141396047982136D-26, &
&    1.054220984433160D-24,  -3.699414518264966D-23,   9.850010472044137D-22, &
&   -2.068283219686609D-20,   3.514386612201624D-19,  -4.920244874008482D-18, &
&    5.749649269558967D-17,  -5.660829570961176D-16,   4.727327771910846D-15, &
&   -3.364024614785038D-14,   2.045885218498101D-13,  -1.064917086452211D-12, &
&    4.744836244555996D-12,  -1.807636200783244D-11,   5.874319030411039D-11, &
&   -1.622448545415226D-10,   3.789240345231085D-10,  -7.433871143781811D-10, &
&    1.214701542208818D-09,  -1.635506022920600D-09,   1.790105460195380D-09, &
&   -1.565611362985511D-09,   1.070562982691316D-09,  -5.245113550673568D-10, &
&    1.205358643076049D-09,   6.654185356295305D-10,  -1.886977885708766D-06, &
&   -1.287633290984770D-04,  -5.375122594733771D-03,   8.592488575036641D-01, &
&    8.911971944596752D-31,  -1.449949308925257D-28,   1.125230827748856D-26, &
&   -5.543779494459812D-25,   1.947018237389768D-23,  -5.188872825774179D-22, &
&    1.090651869950045D-20,  -1.855283717867998D-19,   2.600649799759327D-18, &
&   -3.043168249276129D-17,   3.000649182417673D-16,  -2.509973290539801D-15, &
&    1.789393356005133D-14,  -1.090446274708662D-13,   5.688621589803550D-13, &
&   -2.540868350099300D-12,   9.706291876688695D-12,  -3.163761567160575D-11, &
&    8.767074773363220D-11,  -2.055030016483246D-10,   4.047791126956449D-10, &
&   -6.643125991735557D-10,   8.987138913899469D-10,  -9.887282214236381D-10, &
&    8.694505383195570D-10,  -5.989032202844976D-10,   3.018324351689716D-10, &
&    1.248730300934584D-09,   6.438527114976067D-08,   5.022332201194459D-09, &
&   -1.388661912887943D-04,  -8.341517967987012D-03,   7.496314197386709D-01, &
&   -2.853167300080048D-31,   4.646945602969033D-29,  -3.610449277960166D-27, &
&    1.781058264938247D-25,  -6.263932161909802D-24,   1.671907492010494D-22, &
&   -3.520063050669858D-21,   5.998859114615406D-20,  -8.425774605022327D-19, &
&    9.881125208437368D-18,  -9.766497829092057D-17,   8.190967178096918D-16, &
&   -5.856293201094710D-15,   3.580061433506173D-14,  -1.874093444843085D-13, &
&    8.402414880679977D-13,  -3.223028984226887D-12,   1.055276248325672D-11, &
&   -2.938614116985527D-11,   6.924934401444297D-11,  -1.371885524845432D-10, &
&    2.265542041704231D-10,  -3.085442089618447D-10,   3.418651571501345D-10, &
&   -3.028388491285380D-10,   2.098488795970532D-10,  -1.633990844959541D-10, &
&   -8.132824647147153D-10,   6.660599065958836D-08,   2.639815125656928D-06, &
&   -8.422750112139706D-05,  -1.046410194701489D-02,   6.206553197832813D-01, &
&    6.009174408108617D-32,  -9.801029345986495D-30,   7.626644929442848D-28, &
&   -3.768548840107404D-26,   1.327781184365590D-24,  -3.550906262059727D-23, &
&    7.491926615265179D-22,  -1.279679392725872D-20,   1.801814114944808D-19, &
&   -2.118640722911376D-18,   2.100045101710489D-17,  -1.766675404064232D-16, &
&    1.267283714146070D-15,  -7.774509578838891D-15,   4.085179470005091D-14, &
&   -1.838952359450779D-13,   7.084160239654608D-13,  -2.330024857432271D-12, &
&    6.519572439345074D-12,  -1.544129927349232D-11,   3.075261148507713D-11, &
&   -5.106551556348367D-11,   6.994324342063849D-11,  -7.795074902554104D-11, &
&    6.945624806702886D-11,  -4.688332279452027D-11,   3.667439955207668D-11, &
&   -2.144911640036170D-09,  -1.161035952314351D-08,   3.633453793877880D-06, &
&    1.302440247944731D-05,  -1.109720686316904D-02,   4.823125587285288D-01, &
&   -9.148069252035637D-33,   1.493263308184839D-30,  -1.162955683047897D-28, &
&    5.751514385779610D-27,  -2.028264447980486D-25,   5.429205755175742D-24, &
&   -1.146556082662873D-22,   1.960239060431272D-21,  -2.762611977284147D-20, &
&    3.251310890857778D-19,  -3.225537036592268D-18,   2.715646713280975D-17, &
&   -1.949360604553407D-16,   1.196568078126791D-15,  -6.289973696562684D-15, &
&    2.831970973857954D-14,  -1.090867269187048D-13,   3.586478506819488D-13, &
&   -1.002724398829763D-12,   2.371927752123592D-12,  -4.715458605383935D-12, &
&    7.811468904564194D-12,  -1.066657147251654D-11,   1.184379672983493D-11, &
&   -1.053659741790702D-11,   6.680854855693767D-12,   4.786902031290664D-11, &
&   -1.852298206967260D-10,  -7.534668483861128D-08,   2.041228380103163D-06, &
&    1.035563731992310D-04,  -1.004775477292721D-02,   3.453212438337659D-01, &
&    5.777546145134864D-34,  -9.450376219924550D-32,   7.375477271359261D-30, &
&   -3.655364158677162D-28,   1.291788147926090D-26,  -3.465015693741794D-25, &
&    7.332202944921875D-24,  -1.255935331260565D-22,   1.773056765480985D-21, &
&   -2.089792168780022D-20,   2.075640624380396D-19,  -1.748849815881210D-18, &
&    1.255673156293249D-17,  -7.704546370494493D-17,   4.045183144984737D-16, &
&   -1.817339629051008D-15,   6.976983528386986D-15,  -2.282987504906155D-14, &
&    6.342152522410059D-14,  -1.487774161083937D-13,   2.926695118645728D-13, &
&   -4.785476011586457D-13,   6.432438709142924D-13,  -7.012003598942427D-13, &
&    6.363142355207642D-13,  -1.267196523351225D-12,  -6.945481189290119D-12, &
&    1.550757330419503D-09,  -5.053229652015510D-08,  -6.322467074666419D-07, &
&    1.423093256046797D-04,  -7.634002600786062D-03,   2.202949026522509D-01, &
&    1.429089943800340D-34,  -2.318745486055396D-32,   1.794209576937475D-30, &
&   -8.812138187859869D-29,   3.084590788763162D-27,  -8.191383293951266D-26, &
&    1.715252484028647D-24,  -2.906083041941591D-23,   4.056311773242213D-22, &
&   -4.725221315461421D-21,   4.637175276860153D-20,  -3.859641891861998D-19, &
&    2.737317688921303D-18,  -1.659104849436059D-17,   8.606868186991924D-17, &
&   -3.822255557992134D-16,   1.451564234318205D-15,  -4.703207682770643D-15, &
&    1.295476601163191D-14,  -3.018302379807664D-14,   5.908952585703872D-14, &
&   -9.637275231872429D-14,   1.295328162854268D-13,  -1.417377547032055D-13, &
&    1.205391712279061D-13,   4.947254452114769D-13,  -2.723139576792195D-11, &
&    5.893847071188897D-10,   1.344874024927230D-08,  -2.035806338632817D-06, &
&    1.171686092841493D-04,  -4.588879756155123D-03,   1.169201056091435D-01, &
&   -2.052123239659719D-35,   3.330729953340805D-33,  -2.578024606300245D-31, &
&    1.266491017441013D-29,  -4.434020537431850D-28,   1.177607592145397D-26, &
&   -2.465858262391253D-25,   4.177203810247796D-24,  -5.828706360336542D-23, &
&    6.786304790334828D-22,  -6.654570132949185D-21,   5.532571974346859D-20, &
&   -3.917827460034201D-19,   2.369860285209011D-18,  -1.226216913728336D-17, &
&    5.427601984785902D-17,  -2.052695327602034D-16,   6.616830220633424D-16, &
&   -1.811125855879248D-15,   4.187606456344520D-15,  -8.123563927057271D-15, &
&    1.310732674449163D-14,  -1.740173711899689D-14,   1.892285529003905D-14, &
&   -2.158584368893936D-14,   7.508938048350190D-14,   5.167457501445756D-12, &
&   -5.130032662156846D-10,   3.017207251742805D-08,  -1.414154279664103D-06, &
&    5.594101392526725D-05,  -1.837297878408522D-03,   4.320595698300942D-02, &
&    2.724136960315527D-37,  -4.456845063420050D-35,   3.479537281263218D-33, &
&   -1.725403494673949D-31,   6.102028195569177D-30,  -1.638426269548971D-28, &
&    3.471651281870477D-27,  -5.956885353359810D-26,   8.428090006945615D-25, &
&   -9.961096703307955D-24,   9.927522464899276D-23,  -8.399683061902953D-22, &
&    6.061798293223586D-21,  -3.742319913874530D-20,   1.979349520191271D-19, &
&   -8.970230529582914D-19,   3.479241043772699D-18,  -1.152146498409144D-17, &
&    3.245122150997979D-17,  -7.733451520928693D-17,   1.548561179981139D-16, &
&   -2.582639720624914D-16,   3.555678871179405D-16,  -4.387960795521439D-16, &
&    2.307469097551322D-15,  -8.522674327344081D-14,   3.565861901084340D-12, &
&   -1.443094264163621D-10,   5.606067632127379D-09,  -2.069160976352631D-07, &
&    7.099311454048506D-06,  -2.151071985138349D-04,   4.863566243162920D-03, &
&   -8.036318938811046D-44,   3.390356954859907D-43,   6.334941429090299D-41, &
&   -2.652946971479329D-40,  -2.257005752020784D-38,   9.405720436374193D-38, &
&    4.830795343168583D-36,  -1.938236022524543D-35,  -6.901072974917524D-34, &
&    2.364770144014625D-33,   5.959122901570883D-32,  -3.863318530918890D-31, &
&   -4.514994901289918D-30,   1.130545145123907D-28,   3.775261811212989D-27, &
&    7.818307863179142D-26,   8.930549400182024D-25,  -1.456992404986161D-23, &
&   -1.159991371475791D-21,  -3.672563029190327D-20,  -7.116740110730580D-19, &
&   -4.704538947153945D-18,   2.655008929884540D-16,   1.346842844977517D-14, &
&    3.678478930950169D-13,   6.203473823919568D-12,   1.426420961840533D-11, &
&   -3.622130957234204D-09,  -1.717289658453896D-07,  -5.352752255878409D-06, &
&   -1.314555622359557D-04,  -2.578029303493090D-03,   9.647582082892350D-01, &
&    2.149163176273796D-43,  -9.082230275068635D-43,  -1.696214668103841D-40, &
&    7.073511694176877D-40,   6.048118536057394D-38,  -2.481235684639381D-37, &
&   -1.287261177513861D-35,   5.202602286633811D-35,   1.817851018785293D-33, &
&   -7.502673512824917D-33,  -1.815134075402961D-31,   9.117757455858701D-31, &
&    1.711957132073248D-29,  -1.009515428791050D-28,  -4.185171091700079D-27, &
&   -3.206731935919548D-26,   1.581397323650490D-24,   5.257233429150165D-23, &
&    2.341598156659365D-23,  -3.471872723538763D-20,  -7.565077597881659D-19, &
&    6.303624313529642D-18,   6.166985563090443D-16,   9.053288777159887D-15, &
&   -1.956003073841064D-13,  -9.486524310812617D-12,  -5.275220191664430D-11, &
&    5.830817589775352D-09,   1.683555295739276D-07,  -1.319752118855506D-06, &
&   -2.337882215846691D-04,  -8.458910333720645D-03,   8.433742683843274D-01, &
&   -2.558458227534544D-43,   1.077487083256688D-42,   2.019964159265145D-40, &
&   -8.399495242422611D-40,  -7.206742346538883D-38,   2.948907659599579D-37, &
&    1.536343496592315D-35,  -6.162550779254117D-35,  -2.180584814532488D-33, &
&    8.523259703571783D-33,   2.168886284966095D-31,  -8.147637273565884D-31, &
&   -1.491734804854699D-29,   5.516571098497982D-29,   1.751466224342137D-28, &
&   -5.370779247466463D-27,   5.270215366951344D-25,   7.570100720253054D-24, &
&   -3.685110744862427D-22,  -9.355479158937887D-21,   1.422355082015761D-19, &
&    5.695642918302918D-18,  -8.170830698620753D-17,  -3.013504612563434D-15, &
&    1.056268067848733D-13,   3.233844569799115D-12,  -9.423820365754983D-11, &
&   -3.542828580940814D-09,   8.713661682683060D-08,   4.492701737943322D-06, &
&   -1.055265337493554D-04,  -1.144579165710305D-02,   6.903502039768859D-01, &
&    1.897859614266826D-43,  -7.961444637377068D-43,  -1.498609935735042D-40, &
&    6.206614650213236D-40,   5.347627510495510D-38,  -2.178633076420602D-37, &
&   -1.140249724088076D-35,   4.550410944502567D-35,   1.618444238744219D-33, &
&   -6.305112519957953D-33,  -1.613070443184563D-31,   6.167437481838596D-31, &
&    1.172657433739627D-29,  -4.707830843244359D-29,  -7.296893226677799D-28, &
&    5.712101171800728D-27,   1.491417369358274D-25,  -8.980347219170922D-25, &
&   -5.908864752882633D-23,  -9.778153527572832D-22,  -5.058392112918532D-20, &
&   -1.297045639713075D-19,   7.440147541606026D-17,   5.769832361244790D-16, &
&   -5.417529602610643D-14,   6.535653505864423D-13,   5.517752662254349D-11, &
&   -1.907713116271762D-09,  -5.071072876341352D-08,   3.774362071781589D-06, &
&    2.840234667312297D-05,  -1.145407236016136D-02,   5.397582179861910D-01, &
&   -9.300951161049867D-44,   3.884154545129012D-43,   7.343805246634374D-41, &
&   -3.026852995628336D-40,  -2.620413480765898D-38,   1.062203833441171D-37, &
&    5.587581694123882D-36,  -2.218331746577454D-35,  -7.935273121442747D-34, &
&    3.064784399629321D-33,   7.916441475271211D-32,  -2.922750286820713D-31, &
&   -5.658637133512408D-30,   1.860074258736288D-29,   2.607575904011967D-28, &
&    4.858817004399962D-29,   5.025608463758971D-26,   6.897551256510313D-25, &
&   -4.451399345674462D-23,  -1.559771888338565D-21,  -7.679334604417405D-22, &
&    3.028679198213016D-19,   3.690039908966515D-18,   8.064282157536280D-16, &
&    2.983684364411246D-15,  -8.606997441030330D-13,   2.411570748378242D-11, &
&    4.609376595013240D-10,  -6.366944632209403D-08,   1.345896359058056D-06, &
&    9.757335770112683D-05,  -9.871397887882670D-03,   4.042884395371791D-01, &
&    2.966856246626282D-44,  -1.227482782762591D-43,  -2.342795714058823D-41, &
&    9.563356343689192D-41,   8.360989237542443D-39,  -3.354364404234375D-38, &
&   -1.783103869370641D-36,   7.000266083806536D-36,   2.530958577106757D-34, &
&   -9.707843423872042D-34,  -2.522256327040927D-32,   9.580585231435996D-32, &
&    1.842239746109048D-30,  -7.490536599163133D-30,  -1.206212575907411D-28, &
&    1.055672413753399D-27,   4.186687925689409D-26,   1.994369255615700D-25, &
&   -2.278816027384140D-23,  -8.507785458560032D-22,  -1.039560579531239D-20, &
&    3.604574262205714D-19,   8.294120104491992D-18,   5.063838725095072D-17, &
&    1.092356621026417D-14,  -2.559393435456816D-13,  -7.872032033145392D-12, &
&    8.206576378671929D-10,  -3.022386423892540D-08,  -3.860726167444275D-07, &
&    1.130174876110188D-04,  -7.672175501538919D-03,   2.879498857976365D-01, &
&   -5.838506691782303D-45,   2.391036277399576D-44,   4.612539129128507D-42, &
&   -1.866041692099691D-41,  -1.646814327759095D-39,   6.561673200181550D-39, &
&    3.514448452075185D-37,  -1.373775181005747D-36,  -5.001790667825100D-35, &
&    1.888877857988772D-34,   5.003009000369489D-33,  -1.709888184452678D-32, &
&   -3.449686767981879D-31,   7.111010336257995D-31,   5.407447484911101D-30, &
&    3.456638157819975D-28,   2.168611823671853D-26,   1.609754845088803D-25, &
&   -1.484044049540265D-23,  -4.891962318097523D-22,  -5.290152937606945D-21, &
&    1.158322456450119D-19,   8.092673660554296D-18,   3.640175652486089D-17, &
&    1.515261282095079D-15,   1.118782175496675D-13,  -1.060719228292254D-11, &
&    3.741774846000838D-10,  -1.221529485101859D-09,  -1.088406142320628D-06, &
&    9.729390081325216D-05,  -5.407917398228534D-03,   1.916762577943193D-01, &
&    6.208334987396238D-46,  -2.671472807646513D-45,  -4.901938694002229D-43, &
&    2.093397902457655D-42,   1.748875653596199D-40,  -7.370845719224708D-40, &
&   -3.723448505097798D-38,   1.543206946164424D-37,   5.234973590528197D-36, &
&   -2.240919850256750D-35,  -5.154235690757336D-34,   2.829868444084295D-33, &
&    4.572249501294190D-32,  -4.477633676519548D-31,  -9.299987921006453D-30, &
&    2.373261056195879D-28,   1.236290893620984D-26,   8.754434310174724D-26, &
&   -7.956534482209663D-24,  -2.899209091200854D-22,  -2.606917400740137D-21, &
&    6.529519178483894D-20,   3.597797759454641D-18,   8.209692214936266D-17, &
&   -1.299612783218783D-15,   9.054439587966690D-14,  -3.543719187784990D-12, &
&   -1.702715296822586D-11,   1.113334687016326D-08,  -1.064608055774005D-06, &
&    6.832644506924425D-05,  -3.381992408614257D-03,   1.153645463296505D-01, &
&   -3.713137515072201D-47,   2.054593008139354D-46,   2.893361555776030D-44, &
&   -1.601380491706112D-43,  -1.016726778204199D-41,   5.722900205245413D-41, &
&    2.153209322529343D-39,  -1.230780887738494D-38,  -3.234615304445303D-37, &
&    1.284680756340359D-36,   3.431979064014608D-35,   1.794785278830402D-34, &
&    1.791630637149803D-33,  -1.282198665773281D-31,  -3.329087412952500D-30, &
&    1.087387614297403D-28,   5.920381348347128D-27,   4.180256814162215D-26, &
&   -3.824984699275764D-24,  -1.381414967087823D-22,  -1.466892568361036D-21, &
&    4.041681017656378D-20,   1.424916341216538D-18,   4.483385625214313D-17, &
&   -2.528070655472495D-16,   1.849224488350663D-15,   9.657905910493475D-13, &
&   -1.402345368856688D-10,   1.073211527200646D-08,  -6.961216850881588D-07, &
&    3.819604876642055D-05,  -1.762469424262353D-03,   5.862118372652229D-02, &
&   -2.812590322839814D-50,   4.935782360490745D-49,   7.560475629207667D-48, &
&   -8.406573415556442D-46,   1.297251197795425D-44,   7.505237604949033D-43, &
&   -7.939464391264265D-43,  -2.784785639022748D-40,  -6.786129967362001D-39, &
&   -1.120057015305701D-37,   1.379742347772020D-36,   1.160917064942851D-34, &
&    1.389357134045086D-33,  -4.741817470499873D-32,  -1.180348425025236D-30, &
&    3.790792605236847D-29,   2.046170514206808D-27,   1.489495891769939D-26, &
&   -1.339256882679865D-24,  -4.774470961187273D-23,  -5.164803866532781D-22, &
&    1.297303892726917D-20,   5.982737190487019D-19,   8.680583298464584D-18, &
&    3.202656048319216D-16,  -2.010882302385663D-14,   1.282428590087361D-12, &
&   -8.743790013779317D-11,   5.133653661059191D-09,  -2.865658266519100D-07, &
&    1.450402587397561D-05,  -6.425505270070650D-04,   2.104469666099065D-02, &
&   -4.186912772698426D-49,   1.988253425711329D-48,   3.242712124219117D-46, &
&   -1.508335222578914D-45,  -1.132294992873707D-43,   5.518717433457821D-43, &
&    2.443479687855797D-41,  -1.239525885964457D-40,  -4.271772784257385D-39, &
&    2.366502459592191D-40,   5.093112255435741D-37,   1.143087837626681D-35, &
&    1.252768831663905D-34,  -5.041771961010710D-33,  -1.264719571425533D-31, &
&    4.121592508645190D-30,   2.235051544295392D-28,   1.602763328785367D-27, &
&   -1.443785534499440D-25,  -5.324718400189147D-24,  -5.094615580198214D-23, &
&    1.105496139498448D-21,   8.119154700773860D-20,   1.898340330379855D-19, &
&    7.028786753131701D-17,  -3.731682815851308D-15,   2.027703658223197D-13, &
&   -1.192196055179411D-11,   6.423389875811473D-10,  -3.380849425487708D-08, &
&    1.651905192906999D-06,  -7.181746644008030D-05,   2.334977928822634D-03, &
&   -2.032935819605028D-41,   7.279918351583969D-40,   1.976385215555021D-38, &
&   -7.832767871603425D-37,  -9.634734100484818D-36,   4.162897797662731D-34, &
&    3.286499774279389D-33,  -1.497959588687627D-31,  -9.284268568543927D-31, &
&    4.257876794594165D-29,   2.397735483185210D-28,  -1.060335101273139D-26, &
&   -5.919968025246178D-26,   2.483813489504014D-24,   1.413448147331995D-23, &
&   -5.704198905899989D-22,  -3.263278142433479D-21,   1.308628757391332D-19, &
&    7.263746102810329D-19,  -3.019640556747937D-17,  -1.547608826194637D-16, &
&    7.027256897822243D-15,   3.097187702081485D-14,  -1.653411383538965D-12, &
&   -5.513790463628103D-12,   3.956276665730553D-10,   6.934780724970363D-10, &
&   -9.821294096355664D-08,   7.545047090837685D-08,   2.751290349292449D-05, &
&   -1.568007608235721D-04,  -1.539146503173950D-02,   7.996779751404112D-01, &
&    1.654088902165240D-41,  -1.493098645370586D-40,  -1.582781901738756D-38, &
&    1.518538822422638D-37,   7.507453306652479D-36,  -7.396279742553824D-35, &
&   -2.451960637506466D-33,   2.316372597253010D-32,   6.522173110332859D-31, &
&   -5.254340199919410D-30,  -1.569334223673067D-28,   8.956803820822636D-28, &
&    3.602669883614403D-26,  -1.014279933318133D-25,  -8.017002495577470D-24, &
&   -1.925101777084659D-24,   1.730304681743502D-21,   5.877572329615655D-21, &
&   -3.617427907857297D-19,  -2.469227571832107D-18,   7.331410899598378D-17, &
&    7.846215485867520D-16,  -1.437326847703141D-14,  -2.147557690881550D-13, &
&    2.580223210601353D-12,   5.216485171551492D-11,  -2.570655090046658D-10, &
&   -1.362642225758502D-08,  -1.330380473355147D-07,   7.890119588665092D-06, &
&    1.024945842927458D-04,  -1.310342692448146D-02,   6.032347149218496D-01, &
&    2.190569825111215D-42,  -5.437926674062206D-41,  -2.244764713856258D-39, &
&    5.693945735599463D-38,   1.186359238543110D-36,  -2.893335539017495D-35, &
&   -4.509278419754267D-34,   9.650800508541307D-33,   1.436777343236162D-31, &
&   -2.410950848390917D-30,  -4.140010847996555D-29,   4.819778204377752D-28, &
&    1.113189846167672D-26,  -7.682515833424290D-26,  -2.827544805280854D-24, &
&    7.856285205949760D-24,   6.828717862150027D-22,   6.462774982170737D-22, &
&   -1.573840740136396D-19,  -7.262179810624202D-19,   3.462350876601953D-17, &
&    2.974723788900156D-16,  -7.244328390771294D-15,  -9.618648653340905D-14, &
&    1.430591305152898D-12,   2.672273655702404D-11,  -2.364359968907509D-10, &
&   -6.018797347029935D-09,  -4.395728292214519D-08,   2.546490992759391D-06, &
&    1.305602967476177D-04,  -1.029126971018632D-02,   4.570469317436499D-01, &
&    5.562313349214559D-43,  -2.388508948453276D-41,  -6.131320184588397D-40, &
&    2.535280917683171D-38,   3.584376743328747D-37,  -1.313432846350677D-35, &
&   -1.532864564425155D-34,   4.502427038211611D-33,   5.478237336606749D-32, &
&   -1.168429667018040D-30,  -1.739343450608936D-29,   2.461691930736082D-28, &
&    5.054065532147460D-27,  -4.239745878334235D-26,  -1.367847959956640D-24, &
&    5.150585712176314D-24,   3.488409260834460D-22,   7.489925297260667D-23, &
&   -8.439156212130238D-20,  -3.378874169845363D-19,   1.939578917923649D-17, &
&    1.550708469439268D-16,  -4.212828212520102D-15,  -5.333592723968295D-14, &
&    8.536267331555059D-13,   1.593684820627136D-11,  -1.579816884570007D